<?php
if(!defined('MODULE_PAYMENT_UNZER_STATUS') or MODULE_PAYMENT_UNZER_STATUS != 'True'){
    throw new Exception('Unzer Payment ist nicht installiert.');
}
use UnzerSDK\Resources\TransactionTypes\Charge;
use UnzerSDK\Resources\PaymentTypes\Prepayment;
use UnzerSDK\Resources\PaymentTypes\Card;
use UnzerSDK\Resources\PaymentTypes\Giropay;
use UnzerSDK\Resources\TransactionTypes\AbstractTransactionType;
use UnzerSDK\Resources\TransactionTypes\Authorization;
use UnzerSDK\Resources\EmbeddedResources\Address;
use UnzerSDK\Resources\Customer;
use UnzerSDK\Constants\Salutations;
use UnzerSDK\Resources\Basket;
use UnzerSDK\Resources\EmbeddedResources\BasketItem;
use UnzerSDK\Constants\BasketItemTypes;
use UnzerSDK\Resources\PaymentTypes\Paypage;
use UnzerSDK\Interfaces\DebugHandlerInterface;

try{
    $unzer = new UnzerSDK\Unzer(MODULE_PAYMENT_UNZER_PRIVATE_KEY);
    if(isset($_SESSION['languages_id']) and $_SESSION['languages_id'] == 2){
        $unzer->setLocale('de_DE');
    }
//    $unzer->setClientIp('255.255.255.255');
}catch( Exception $e ){
    die(json_encode([
        'error'=>$e->getMessage()
    ]));
}
$unzer_payment_data = \unzer::getUnzer_payment_data();

$uca = (isset($unzer_call_action))?$unzer_call_action:'';
switch($uca){
    case 'webhook':
        // aus callback/unzer.php
        if(!isset($payload['paymentId'])){
            $no_paymentId = true;
            die('Nothing to do here');
        }

        try{
            $payment = $unzer->fetchPayment($payload['paymentId']);
        }catch( Exception $e ){
            $message = sprintf('Unzer Webhook PaymentId %s (Event %s): %s',
                    $payload['paymentId'],$payload['event'], $e->getMessage()
            );
            yes_mail_debug($message);
            if(main::isDev(true)){
                die($message);
            }
            exit;
        }
        $unzer_payment_id = \unzer::get_unzer_payment_id_from_db($payload['paymentId']);
        if($unzer_payment_id < 1){
            $message = sprintf('Unzer Webhook PaymentId %s (Event %s): Nicht in der DB unzer_payments enthalten.',
                    $payload['paymentId'],$payload['event']
            );
            if(main::isDev(true)){
                die($message);
            }
            exit;
        }
        $local_data_array = \unzer::get_unzer_payment_data_from_db($unzer_payment_id);
        $local_data = current($local_data_array);
        $order = new order($local_data['orders_id'],$xtPrice);
        $orders_status = $order->info['orders_status_id'];

        // muss eine int sein, wird mit secure_files/UNZER_ORDERS_STATUS_ALLOCATIONS.json abgeglichen
        $check_state = $payment->getState();
        $target_orders_status = \unzer::get_yes_orders_status_from_unzer_status($check_state);
        if($target_orders_status !== $orders_status){
            $order->update_orders_status($target_orders_status);
            $order->info['orders_status_id'] = $target_orders_status;
            $osn = main::get_orders_status_name($target_orders_status, $_SESSION['languages_id']);
            $message = sprintf(HISTORY_UNZER_WEBHOOK_ORDERS_STATUS_UPDATE,
                    $payload['paymentId'],$payload['event'],
                    $osn
            );
            $order->add_history($order->info['orders_status_id'], false, $message);
        }
        
        if($payment->getState() == 2){
            $order->add_history($order->info['orders_status_id'],false,'Unzer meldete die Payment Transaktion als fehlgeschlagen. Bitte Vorgang pr&uuml;fen');
            $message = sprintf(
                UNZER_ERROR_PAYMENT_FAILED_DESCRIPTION,
                $local_data['orders_id'], $payload['paymentId'], $payload['event']
            );
            \unzer::error_notice(UNZER_ERROR_PAYMENT_FAILED_TITLE, 
                $message, 
                'orders'
            );
            if(main::isDev(true)){
                die($message);
            }
            exit;
        }
        exit;
        break;
    case 'status':
        $payment = $unzer->fetchPayment($unzer_payment_data['paymentId']);
        if($payment->getState() == 2){
            // cancelled
            $unzer_payment_data = [];
            \unzer::setUnzer_payment_data($unzer_payment_data);
            xtc_redirect(xtc_href_link('checkout_shipping.php','error_message='.urlencode(MSG_ERROR_UNZER_PAYMENT_FAILED)));
        }
        $unzer_payment_data['State'] = $payment->getState();
        $unzer_payment_data['StateName'] = $payment->getStateName();
        $pt = $payment->getPaymentType();
        echo gettype($pt);
        if(gettype($pt) == 'NULL'){
            yes_mail_debug("Unzer Status failed\n".print_r($payment,true));
            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));
        }
        $unzer_payment_data['PaymentType'] = $pt->getResourceName();
        $unzer_payment_data['Payout'] = $payment->getPayout();
        \unzer::setUnzer_payment_data($unzer_payment_data);
        xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_PROCESS));
        exit;
        break;
}

$bill_address_book_id = $_SESSION['billto'];
$item = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id((int)$_SESSION['customer_id'], (int)$bill_address_book_id);
$record = $item->toArray();
$salutation = ($record['entry_gender'] == 'f')?Salutations::MRS:Salutations::MR;
require_once(DIR_FS_INC.'xtc_get_countries_with_iso_codes.inc.php');
$country_info = xtc_get_countries_with_iso_codes($record['entry_country_id']);
$street = $record['entry_street_address'];
if(!empty($record['entry_suburb'])){
    $street .= ' / '.$record['entry_suburb'];
}
$street = substr($street,0,64);

if(main::isDev()){
    $address = (new Address())
        ->setName('Max Mustermann')
        ->setStreet('Schöneberger Str. 21a')
        ->setZip('10963')
        ->setCity('Berlin')
        ->setCountry('DE');
}else{
    $address = (new Address())
        ->setName(substr($record['entry_firstname'].' '.$record['entry_lastname'],0,81))
        ->setStreet($street)
        ->setZip($record['entry_postcode'])
        ->setCity(substr($record['entry_city'],0,30))
        ->setCountry($country_info['countries_iso_code_2']);
}

$cust = \YES4Trade\Model\customers::get_by_customers_id(intval($_SESSION['customer_id']),[
    'customers_email_address'
]);
if($cust === null){
    xtc_redirect(xtc_href_link(FILENAME_LOGIN,'error_message='.urlencode('Please Login first')));
}
$cust_record = $cust->toArray();

if(main::isDev()){
    $customer = (new Customer())
        ->setFirstname('Max')
        ->setLastname('Mustermann')
        ->setSalutation($salutation)
        //->setCompany($record['entry_company'])
        //->setBirthDate()
        ->setEmail($cust_record['customers_email_address'])
        //->setMobile('+49 123456789')
        //->setPhone('+49 123456789')
        ->setBillingAddress($address)
        ->setShippingAddress($address);
}else{
    $customer = (new Customer())
        ->setFirstname($record['entry_firstname'])
        ->setLastname($record['entry_lastname'])
        ->setSalutation($salutation)
        ->setCompany($record['entry_company'])
        //->setBirthDate()
        ->setEmail($cust_record['customers_email_address'])
        //->setMobile('+49 123456789')
        //->setPhone('+49 123456789')
        ->setBillingAddress($address)
        ->setShippingAddress($address);
}
try{
    $customer = $unzer->createCustomer($customer);
}catch(Exception $e){
    xtc_redirect(xtc_href_link('checkout_shipping.php','error_message='.urlencode($e->getMessage())));
}
$unzer_payment_data['customerId'] = $customer->getId();

global $xtPrice;
/*
$order_total_modules = new order_total($xtPrice);
$order_total_modules->process();
$otm = $order_total_modules->output(true);
*/
$total = 0;
$tax_perc = 0;
$highest_tax = 0;
$order=new order();
$tcID = $order->get_shipping_tax_class();
$tax_rate_percent = xtc_get_tax_rate($tcID, $order->delivery['country_id']);
$total_products_num = 0;
$add_str = [];
foreach($order->products as $op){
    $total_products_num += $op['qty'];
}
foreach($order_totals as $ot){
    switch($ot['code']){
        case 'ot_shipping':
            $add_str[] = 'Versand';
            break;
        case 'ot_discount':
            $add_str[] = 'Rabatt';
            break;
        case 'ot_coupon':
            $add_str[] = 'Kupon';
            break;
        case 'ot_total':
            $total = $ot['value'];
            break;
    }
}
$add = '';
if(sizeOf($add_str)){
    $add .= UNZER_BASKET_SUBTOTAL;
    $add .= implode(', ',$add_str);
}
$basketTitle = sprintf(UNZER_BASKET_TOTAL,
    sizeOf($order->products), $total_products_num, $add
);
$basketSubtitle = $add;
$basketItem = (new BasketItem())
    ->setBasketItemReferenceId('CartcID'.$_SESSION['customer_id'])
    ->setQuantity(1)
    ->setUnit('Total')
    ->setAmountPerUnitGross( $total )
    //->setAmountDiscountPerUnitGross(1.00)
    ->setVat($tax_rate_percent)
    ->setTitle($basketTitle)
    ->setSubTitle($basketSubtitle)
    //->setImageUrl($image_file)
    ->setType(BasketItemTypes::GOODS);
/**
 * gross heisst brutto
 */
$basket = (new Basket())
    ->setTotalValueGross($total)
    ->setCurrencyCode($order->info['currency'])
    ->setOrderId('')
    ->addBasketItem($basketItem)
    //->setNote('YES4Trade Test Basket')
;
foreach($basketItems as $bi){
    $basket->addBasketItem($bi);
}


class DummyDebugHandler implements DebugHandlerInterface
{
    /**
     * This method will allow custom handling of debug output.
     *
     * @param string $message
     */
    var $log_items;
    public function log(string $message): void
    {
        // do nothing
        $this->log_items[] = $message;
    }
    public function print(){
        yes_debug($this->log_items);
    }
}
//$unzerdebughandler = new DummyDebugHandler();
//$unzer->setDebugMode(true);
//$unzer->setDebugHandler($unzerdebughandler);

try{
    $basket = $unzer->createBasket($basket);
}catch( Exception $e){
//    $unzerdebughandler->print();
    xtc_redirect(xtc_href_link('checkout_shipping.php','error_message='.urlencode($e->getMessage())));
}
$unzer_payment_data['basketId'] = $basket->getId();
$redirectUrl = xtc_href_link('unzer_redirect.php');
if(main::isDev(true)){
    $redirectUrl = 'https://yes-a177922.de/unzer_redirect.php?local=1';
}
$paypage = new Paypage($total, $order->info['currency'], $redirectUrl);

$paypage->setLogoImage( MODULE_PAYMENT_UNZER_LOGOIMGURL )
    ->setOrderId('')
    ->setShopName(STORE_NAME)
    ->setTagline(STORE_NAME)
    ->setShopDescription( MODULE_PAYMENT_UNZER_SHOP_DESCRIPTION )
    ->setInvoiceId('')
    ->setExemptionType(\UnzerSDK\Constants\ExemptionType::LOW_VALUE_PAYMENT);
try{
    $paymentCharge = $unzer->initPayPageCharge($paypage, $customer, $basket);
}catch(Exception $e){
    xtc_redirect(xtc_href_link('checkout_shipping.php','error_message='.urlencode($e->getMessage())));
}
$unzer_payment_data['paymentChargeId'] = $paymentCharge->getId();
$unzer_payment_data['paymentId'] = $paymentCharge->getPaymentId();

\unzer::setUnzer_payment_data($unzer_payment_data);
xtc_redirect( $paymentCharge->getRedirectUrl());


