<?php
/**

GEPRUEFT+OPTIMIERT - Keine Sicherheitsluecken

**/
function xml_attribute($object, $attribute){
	$role = $object->attributes();
        foreach($role as $key => $value) {
            if($key == $attribute)
		return (string)$value;
        }
}

class category_item
{
    var $categories_id;
    var $depth;
    var $categories_name;
    var $parent_id;

    function category_item($cat_id, $depth, $cat_title, $cat_parent_id)
    {
        $this->categories_id = $cat_id;
        $this->depth = $depth;
        $this->categories_name = $cat_title;
        $this->parent_id = $cat_parent_id;
    }
}

/*************************************************************/
// Builds the category list for the category select

$list = array();

function build_list($cat_array, $item = '', $depth = 0)
{
    global $template;
    global $list;

    foreach($cat_array as $category)
    {
        $loop_item = "$item$category[categories_name]";

        $category_item = new category_item($category['categories_id'], $depth, $category['categories_name'], $category['parent_id'], $loop_item);
        $list[] = $category_item;

        if(count($category['children']) > 0)
        {
            $depth++;
            build_list($category['children'], $loop_item." > ", $depth);
            $depth--;
        }

        $loop_item = '';
    }

    return $list;
}

/*************************************************************/
// Adds the object to the children array of the object with 
// a cat_id equal to $parent_id

function tree_add($tree, $parent_id, $object, $cat_id)
{
    // Only start from the given cat_id, ignore all other roots

    if($parent_id == 0 and $object['categories_id'] == $cat_id)
    {
        $tree[$object['categories_id']] = $object;
        return $tree;
    }
    if($tree)
    {
        foreach($tree as $key => $value)
        {
            $current = $tree[$key];
            // If this is the parent, add the object to it's children array
            if($current['categories_id'] == $parent_id)
            {
                $tree[$key]['children'][$object['categories_id']] = $object;
            }
            else
            {
                // If it's not in this level, look a level deeper on the current object.
                $tree[$key]['children'] = tree_add($current['children'], $parent_id, $object, $cat_id);
            }
        }
    }

    return $tree;
}
function yes_catbuildTree($items) {
    $childs = array();

    foreach($items as &$item) $childs[(int)$item['parent_id']][] = &$item;

    foreach($items as &$item) if (isset($childs[$item['categories_id']]))
            $item['children'] = $childs[$item['categories_id']];

    return $childs[0]; // Root only.
}
$languages_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
// basename __FILE__ enthaelt "categories"
$cache_key = 'BOX-'.basename(__FILE__).'-'.$languages_id;
$cache_group = 'categories';
$key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

$CachedString = $InstanceCache->getItem($key); // cache group
if (!$CachedString->isHit()) {
    /*************************************************************/
    // This pulls the data from the database.  This will not work without a
    // database connection.  This code is compatible with the phpBB2 
    // mySQL database class.
    //
    if(isset($_SESSION['languages_id'])){
            $xml_file = './cat2xml_'.$_SESSION['languages_id'].'.xml';
    }else{
            $xml_file = './cat2xml_2.xml';
    }
    if(defined('YES_SHOP_MENU_FROM_XML') and YES_SHOP_MENU_FROM_XML == 'True' and is_file($xml_file)){
            $xml = simplexml_load_file($xml_file, "SimpleXMLElement", LIBXML_NOCDATA);
            $categories_array = array();
            foreach($xml->children() as $CATEGORY){
                    $PARENT = xml_attribute($CATEGORY,'PARENT');
                    $CATID = xml_attribute($CATEGORY,'ID');
                    $CATEGORY_NAME = (string)$CATEGORY->NAME;
                    $HEADING_TITLE = (string)$CATEGORY->HEADING_TITLE;
                    $_category_array = array(
                            'categories_id'=>$CATID,
                            'categories_name'=>$CATEGORY_NAME,
                            'id'=>$CATID,
                            'text'=>$CATEGORY_NAME,
                            'heading_title'=>$HEADING_TITLE,
                            'categories_image' => (string)$CATEGORY->IMAGE,
                            'categories_additional_image' => (string)$CATEGORY->ADDITIONAL_IMAGE,
                            'parent_id'=>$PARENT,
                            'level'=>$level,
                            'link_id'=>xml_attribute($CATEGORY,'LINK_ID'),
                            'link'=>xtc_href_link('index.php','cPath='.$CATID),
                            'sort_order'=>xml_attribute($CATEGORY,'SORT_ORDER')
                    );
                    $categories_array[] = $_category_array;
            }
            $cat_tree = $categories_array;
    }else{
            $items = [];
            $query = yes_query(sprintf(
                "SELECT c.categories_id, c.parent_id, c.sort_order, cd.categories_name,c.categories_image, c.categories_additional_image,c.link_id FROM %s c LEFT JOIN %s cd USING(categories_id) WHERE c.categories_status=1 AND cd.language_id=:language_id ORDER BY parent_id,sort_order, cd.categories_name",
                    TABLE_CATEGORIES, TABLE_CATEGORIES_DESCRIPTION
                ),['language_id'=>(int)$languages_id]
            );
            while($record = xtc_db_fetch_array($query)){
                $record['link'] = xtc_href_link('index.php','cPath='.$record['categories_id']);
                 $items[] = $record;
            }	
            $cat_tree = yes_catbuildTree($items);
            
            
    }
    $CachedString->set($cat_tree)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $cat_tree = $CachedString->get();
}

$smarty->assign('CATEGORIES_STRUCT', $cat_tree);
