<?php
/**
eBay sends an ItemUnsold notification to a subscribing seller when an auction listing ends with no
winning bidder or when a fixed-price listing ends with no sale(s).
*/
$history = '';
$query = xtc_db_query(sprintf(
	"SELECT id,status FROM ebay_auctions WHERE ebay_id='%s'",
	$response['ebay_id']
));
if(!xtc_db_num_rows($query)){
	$body = sprintf("Die Auktion %s vom Seller %s wurde beendet, es konnte aber keine Zuweisung in der YES Datenbank gefunden werden.",
		$response['ebay_id'],$response['seller']
	);
	yes_write_notice('Unbekannte Auktion '.$response['ebay_id'],$body,0,$recipients_array);
	die("Unbekannte Auktion");
}
$record = xtc_db_fetch_array($query);
if($record['status'] == 2){
	die("Auktion ".$response['ebay_id']." wurde bereits in YES beendet und rueckgebucht.");
}
$eaID = $record['id'];

if(isset($response['item']['Variations']) and sizeOf($response['item']['Variations'])){
	$history .= 'Varianten ';
}
$history .= sprintf("Auktion %s vom Seller %s, online vom %s - %s ist beendet (Grund: %s).",
	$response['ebay_id'], $response['seller'], 
	xtc_date_short($response['item']['ListingDetails']['StartTime']['value']),
	xtc_date_short($response['item']['ListingDetails']['EndTime']['value']),
	$response['item']['ListingDetails']['EndingReason']['value']
);
$ea = new ebay_auction($eaID);
if(isset($response['item']['Variations']) and sizeOf($response['item']['Variations'])){
	if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
		if($ea->has_staffelpreise()){
			$staffel = true;
		}
	}
	foreach($response['item']['Variations']['Variation'] as $variation){
		$sku = $variation['SKU']['value'];
		$eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_sku(intval($eaID),$sku,[
			'products_id'
		]);
		if($eav === null){
			echo "Unbekannte SKU $sku in ebay_auctions_id $eaID \r\n";
			continue;
		}
		$pID = intval($eav->products_id);
		$qty = (int)$variation['Quantity']['value'];
		$in_auction_qty = $qty;
		if($staffel === true){
			$staffelmenge = $ea->get_staffelpreis_quantity_from_sku($sku);
			$in_auction_qty = $in_auction_qty * $staffelmenge;
		}
		yes_update_products_in_auction_quantity(
		    $pID,
		    -$in_auction_qty,
		    $history." (Variante SKU $sku)"
		);
	}
}else{
        yes_update_products_in_auction_quantity(
            $ea->getProductsId(),
            -$response['item']['Quantity']['value'],
            $history
        );
}
$EBAYAPI->set_end_auction($eaID);
yes_write_notice('Auktion '.$response['ebay_id'].' beendet',$history,0,$recipients_array);

