<?php
$shopgateMobileHeader = '';// compatibility to older versions
$shopgateJsHeader = '';
if(defined('MODULE_PAYMENT_INSTALLED') && strpos(MODULE_PAYMENT_INSTALLED, 'shopgate.php') !== false) {
##### XTC3 BOF #####
	include_once DIR_FS_CATALOG.'/shopgate/shopgate_library/shopgate.php';
	include_once DIR_FS_CATALOG.'/shopgate/base/shopgate_config.php';
##### XTC3 EOF #####
	
	try {
		$shopgateCurrentLanguage = isset($_SESSION['language_code']) ? strtolower($_SESSION['language_code']) : 'de';
##### XTC3 BOF #####
		$shopgateHeaderConfig = new ShopgateConfigXtc();
##### XTC3 EOF #####
		$shopgateHeaderConfig->loadByLanguage($shopgateCurrentLanguage);
		
		if($shopgateHeaderConfig->checkUseGlobalFor($shopgateCurrentLanguage)) {
			$shopgateRedirectThisLanguage = in_array($shopgateCurrentLanguage, $shopgateHeaderConfig->getRedirectLanguages());
		} else {
			$shopgateRedirectThisLanguage = true;
		}
		
		if ($shopgateRedirectThisLanguage) {
			// SEO modules fix (for Commerce:SEO and others): if session variable was set, SEO did a redirect and most likely cut off our GET parameter
			// => reconstruct here, then unset the session variable
			if(!empty($_SESSION['shopgate_redirect'])) {
				$_GET['shopgate_redirect'] = 1;
				unset($_SESSION['shopgate_redirect']);
			}
			
			// instantiate and set up redirect class
			$shopgateBuilder = new ShopgateBuilder($shopgateHeaderConfig);
			$shopgateRedirector = $shopgateBuilder->buildRedirect();
			
			##################
			# redirect logic #
			##################
			
			if(($product instanceof product) && $product->isProduct && !empty($product->pID)) {
				$shopgateJsHeader = $shopgateRedirector->buildScriptItem($product->pID);
			} elseif(!empty($current_category_id)) {
				$shopgateJsHeader = $shopgateRedirector->buildScriptCategory($current_category_id);
			} elseif(sgIsHomepage()) {
				$shopgateJsHeader = $shopgateRedirector->buildScriptShop();
			} else {
				$shopgateJsHeader = $shopgateRedirector->buildScriptDefault();
			}
		}
	} catch (ShopgateLibraryException $e) {	}
}

function sgIsHomepage() {
	$scriptName = explode('/', $_SERVER['SCRIPT_NAME']);
	$scriptName = end($scriptName);
	
	if ($scriptName != 'index.php') {
		return false;
	}
	if (!empty($_REQUEST)) {
		foreach ($_REQUEST as $key => $value) {
			if ($key != 'language') {
				return false;
			}
		}
	}
	return true;
}