<?php
include( 'includes/application_top.php');
include(DIR_WS_CLASSES.'order.php');
if(!isset($_SESSION['rma'])){
	$_SESSION['rma'] = array();
}
define('RMA_ERROR_SAVEPATH_NOT_WRITABLE','RMA Speicherort ist nicht beschreibbar.');
define('RMA_ERROR_COPY_FAILED','Datei %s konnte nicht gespeichert werden. Bitte wenden Sie sich an unseren Telefonischen Support.');
define('RMA_ERROR_ORDER_ALWAYS_SUBMITTED','Sie haben f&uuml;r diesen Auftrag bereits eine Reklamation gemeldet.');
define('RMA_ERROR_MISSING_TEMPLATE','Templatedatei %s existiert nicht.');
define('RMA_ERROR_MISSING_REASON','Sie haben keinen Reklamationsgrund gew&auml;hlt. Bitte vervollst&auml;ndigen Sie Ihre Angaben.');
define('RMA_ERROR_MISSING_COMMENT','Sie haben keine weiteren Angaben hinterlassen. Bitte vervollst&auml;ndigen Sie Ihre Angaben.');
define('RMA_SUCCESS','Ihre Angaben wurden an uns übermittelt. Vielen Dank.');
function rma_upload($file_nr,$orders_id){
    if(isset($_FILES) and isset($_FILES['file'.$file_nr]['tmp_name']) and !empty($_FILES['file'.$file_nr]['tmp_name'])){
        $save_file_basename = sprintf('RMA_%s_%s_%s_%s_%s',$_SESSION['customer_id'],$orders_id,$file_nr,time(),$_FILES['file'.$file_nr]['name']);
        $save_path = '../ebaymich/';
        if(!is_writable($save_path)){
            die(RMA_ERROR_SAVEPATH_NOT_WRITABLE);
        }
        $save_file = $save_path.$save_file_basename;
        if ( isset($_COOKIE["file".$file_nr]) or isset($_POST["file".$file_nr]) or isset($_GET["file".$file_nr]) ) {
            die("Security Warning Upload");
        }
        try{
            copy($_FILES['file'.$file_nr]['tmp_name'], $save_file);
            return array(
                'success',
                $save_file_basename
            );
        }catch(Exception $e){
            return array(
                'error',
                sprintf(RMA_ERROR_COPY_FAILED,$_FILES['file'.$file_nr]['name'])
            );
        }
    }
}

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_textarea_field.inc.php');
require_once(DIR_FS_INC . 'xtc_date_short.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_geo_zone_code.inc.php');
require_once(DIR_FS_INC . 'xtc_get_customers_country.inc.php');
require_once(DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}
if(!isset($_REQUEST['orders_id']) or intval($_REQUEST['orders_id']) < 1){
    xtc_redirect(xtc_href_link('account_history.php?error=missing+orders_id'));
}
$orders_id = (int)$_REQUEST['orders_id'];
$check_customer_query = yes_query(
    "SELECT orders_id FROM orders WHERE orders_id=:orders_id AND customers_id=:customers_id",
    ['orders_id'=>$orders_id,'customers_id'=>$_SESSION['customer_id']]
);
if(!sizeOf($check_customer_query)){
    xtc_redirect(xtc_href_link('account_history.php?error=invalid+allocation'));
}
if(isset($_SESSION['rma'][$orders_id])){
    $messageStack->add('error',RMA_ERROR_ORDER_ALWAYS_SUBMITTED);
    xtc_redirect(xtc_href_link('account_history.php'));
}
$order = new order($orders_id,$xtPrice);

$reclamations_query = yes_query(
    "SELECT reclamations_id FROM reclamations WHERE orders_id=:orders_id",
    ['orders_id'=>$orders_id]
);
if(sizeOf($reclamations_query)){
    $reclamations = current($reclamations_query);
    $smarty->assign('RECLAMATIONS_ID',$reclamations['reclamations_id']);
}
$template_file = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/rma.html';
if(!is_file($template_file)){
    die(sprintf(RMA_ERROR_MISSING_TEMPLATE,$template_file));
}
$action = $_REQUEST['action']??'';
switch($action){
    case 'process':
        if(!isset($_REQUEST['reason']) or empty($_REQUEST['reason'])){
            $messageStack->add('error',RMA_ERROR_MISSING_REASON);
            xtc_redirect(xtc_href_link('rma.php',xtc_get_all_get_params(array('action','orders_id','comment')).'orders_id='.$orders_id.'&comment='.urldecode($_REQUEST['comment'])));
        }
        if(!isset($_REQUEST['comment']) or empty($_REQUEST['comment'])){
            $messageStack->add_session('error',RMA_ERROR_MISSING_COMMENT);
            xtc_redirect(xtc_href_link('rma.php',xtc_get_all_get_params(array('action','orders_id','reason')).'orders_id='.$orders_id.'&reason='.urldecode($_REQUEST['reason'])));
        }
        $reason = substr($_REQUEST['reason'],0,32);
        $uploaded_files = array();
        for($i=1;$i<=3;$i++){
            $uploaded = rma_upload($i,$orders_id);
            if(is_array($uploaded) and $uploaded[0] == 'success'){
                $uploaded_files[] = array(
                    'filename'=>$uploaded[1],
                    'html_preview'=>'<img src="'.HTTPS_SERVER.'/files/'.$uploaded[1].'" border="0" width="100">'
                );
            }
            if(is_array($uploaded) and $uploaded[0] == 'error'){
                    $messageStack->add('error',$uploaded);
            }
        }
        if(!sizeOf($uploaded_files)){
            $uploaded_str = '--Keine--';
        }else{
            foreach($uploaded_files as $uf){
                $uploaded_str .= '<p>'.$uf['filename'].'<br />'.$uf['html_preview'].'</p>';
            }
        }
        $cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id']);
        $delivery_address = xtc_address_format($order->customer['format_id'], $order->delivery, 1, '', '<br>');
        $billing_address = xtc_address_format($order->customer['format_id'], $order->billing, 1, '', '<br>');
        $message = sprintf('<b>Kunde:</b> %s<br /><b>Auftrag:</b> %s<br /><b>Kundennnummer:</b> %s<br /><b>Rechnungsadresse:</b><br />%s<br /><br /><b>Lieferadresse:</b><br />%s<br /><br /><b>Grund:</b><br />%s<br /><br /><b>Anmerkungen:</b><p>%s</p><b>Bilder (in ebaymich/):</b><br />%s',
            $cust->customers_firstname.' '.$cust->customers_lastname,
            $orders_id,$_SESSION['customer_id'],
            $billing_address,$delivery_address,
            $_REQUEST['reason'],
            nl2br($_REQUEST['comment']),
            $uploaded_str
        );
        $_SESSION['rma'][$orders_id] = true;
        $messageStack->add_session('success',RMA_SUCCESS,'success');
        if(!main::isDev(true)){
            xtc_php_mail(
                EMAIL_BILLING_ADDRESS,
                EMAIL_BILLING_NAME,
                EMAIL_SUPPORT_ADDRESS,
                'RMA Abwicklung',
                '',
                EMAIL_BILLING_REPLY_ADDRESS,
                EMAIL_BILLING_REPLY_ADDRESS_NAME,
                '',
                '',
                'RMA Auftrag '.$orders_id,
                $message
            );
        }else{
            die($message);
        }
        xtc_redirect(xtc_href_link('account_history.php'));
        break;
}

$breadcrumb->add(NAVBAR_TITLE_1_ACCOUNT_EDIT, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ACCOUNT_EDIT, xtc_href_link(FILENAME_ACCOUNT_EDIT, '', 'SSL'));

require(DIR_WS_INCLUDES . 'header.php');
if($messageStack->size('error') > 0){
    $smarty->assign('MESSAGESTACK_ERROR',$messageStack->output('error'));
}
$smarty->assign(array(
	'FORM'=>xtc_draw_form('rma', xtc_href_link('rma.php', 'action=process&orders_id='.$orders_id, 'SSL'), 'post', 'enctype="multipart/form-data"'),
	'FORM_END'=>'</form>',
	'INPUT_COMMENTS'=> xtc_draw_textarea_field('comment', 'virtual', 60, 20,$_REQUEST['comment']),
	'REASON'=>$_REQUEST['reason'],
	'ORDERS_ID'=>$orders_id
));
$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/rma.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');