<?php
/* -----------------------------------------------------------------------------------------
   $Id: product_reviews_write.php,v 1.4 2012/08/13 08:09:23 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(product_reviews_write.php,v 1.51 2003/02/13); www.oscommerce.com 
   (c) 2003	 nextcommerce (product_reviews_write.php,v 1.13 2003/08/1); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed function
require_once(DIR_FS_INC . 'xtc_draw_textarea_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_selection_field.inc.php');
/*
  if (!isset($_SESSION['customer_id'])) {

    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
  }
*/
$product_query = yes_query(sprintf(
    "select pd.products_name, p.products_image from %s p LEFT JOIN %s pd USING(products_id) where p.products_id =:products_id and pd.language_id =:language_id and p.products_status = '1'",
    TABLE_PRODUCTS, TABLE_PRODUCTS_DESCRIPTION
),[
    'products_id'=> (int)$_GET['products_id'],
    'language_id'=> (int)$_SESSION['languages_id']
]);
$valid_product = (!sizeOf($product_query))?false:true;

if (isset($_GET['action']) && $_GET['action'] == 'process') {
    if ($valid_product == true) { // We got to the process but it is an illegal product, don't write
        $cust = \YES4Trade\Model\customers::get_by_customers_id((int)$_SESSION['customer_id']);
        $date_now = date('Ymd');
        if (empty($cust->customers_lastname)){
            $cust->customers_lastname = TEXT_GUEST;
        }
        $insert_sql_array = [
            'products_id'=>(int)$_GET['products_id'], 
            'customers_id'=>(int)$_SESSION['customer_id'], 
            'customers_name'=>$cust->customers_firstname.' '.$cust->customers_lastname, 
            'reviews_rating'=>$_POST['rating'], 
            'date_added'=>'now()'
        ];
        yes_db_perform(TABLE_REVIEWS, $insert_sql_array);
        $insert_id = xtc_db_insert_id();
        $insert_sql_array = [
            'reviews_id'=>$insert_id, 
            'languages_id'=>(int)$_SESSION['languages_id'], 
            'reviews_text'=>$_POST['review']
        ];
        yes_db_perform(TABLE_REVIEWS_DESCRIPTION, $insert_sql_array);
    }
    xtc_redirect(xtc_href_link(FILENAME_PRODUCT_REVIEWS, $_POST['get_params']));
}

// lets retrieve all $HTTP_GET_VARS keys and values..
$get_params = xtc_get_all_get_params();
$get_params_back = xtc_get_all_get_params(array('reviews_id')); // for back button
$get_params = substr($get_params, 0, -1); //remove trailing &
if (xtc_not_null($get_params_back)) {
    $get_params_back = substr($get_params_back, 0, -1); //remove trailing &
} else {
    $get_params_back = $get_params;
}


$breadcrumb->add(NAVBAR_TITLE_REVIEWS_WRITE, xtc_href_link(FILENAME_PRODUCT_REVIEWS, $get_params));
$cust = \YES4Trade\Model\customers::get_by_customers_id((int)$_SESSION['customer_id']);
require(DIR_WS_INCLUDES . 'header.php');

if ($valid_product == false) {
    $smarty->assign('error',ERROR_INVALID_PRODUCT);
} else {
    $product_info = current($product_query);
    $name = $cust->customers_firstname . ' ' . $cust->customers_lastname;
    if (empty($name)) {
        $cust->customers_lastname = TEXT_GUEST;
    }
    $smarty->assign('PRODUCTS_NAME',$product_info['products_name']);
    $smarty->assign('AUTHOR',$cust->customers_firstname . ' ' . $cust->customers_lastname);
    $smarty->assign('INPUT_TEXT',xtc_draw_textarea_field('review', 'soft', 60, 15,'','',false));
    $smarty->assign('INPUT_RATING',xtc_draw_radio_field('rating', '1') . ' ' . xtc_draw_radio_field('rating', '2') . ' ' . xtc_draw_radio_field('rating', '3') . ' ' . xtc_draw_radio_field('rating', '4') . ' ' . xtc_draw_radio_field('rating', '5'));
    $smarty->assign('FORM_ACTION',xtc_draw_form('product_reviews_write', xtc_href_link(FILENAME_PRODUCT_REVIEWS_WRITE, 'action=process&products_id=' . $_GET['products_id']), 'post', 'onSubmit="return checkForm();"'));
    $smarty->assign('BUTTON_BACK','<a href="javascript:history.back(1)">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');
    $smarty->assign('BUTTON_SUBMIT',xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE).xtc_draw_hidden_field('get_params', $get_params));

}
$smarty->assign('language', $_SESSION['language']);

$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/product_reviews_write.html');


$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
