<?php
class wemalo {
    var $api_token, $title, $description, $icon, $enabled, $webhooks, $code,
            $sort_order, $order, $tax_class, $quotes;


    function __construct() {
        $this->code = 'wemalo';
        $this->title = MODULE_SHIPPING_WEMALO_TEXT_TITLE;
        $this->description = MODULE_SHIPPING_WEMALO_TEXT_DESCRIPTION;
        if(defined('MODULE_SHIPPING_WEMALO_SORT_ORDER')){
            $this->sort_order = MODULE_SHIPPING_WEMALO_SORT_ORDER;
        }else{
            $this->sort_order = 0;
        }
        if(defined('MODULE_SHIPPING_WEMALO_KEY')){
            $this->api_token = MODULE_SHIPPING_WEMALO_KEY;
        }
        if(defined('MODULE_SHIPPING_WEMALO_WEBHOOKS')){
            $this->webhooks = MODULE_SHIPPING_WEMALO_WEBHOOKS;
        }
        $this->icon = '';
        $this->enabled = ((defined('MODULE_SHIPPING_WEMALO_STATUS') and MODULE_SHIPPING_WEMALO_STATUS == 'True') ? true : false);
        if(isset($order)){
            $this->order = $order;
        }
    }

    /**
     * DUMMY METHODE - DARF NICHT ALS VERSANDART IM CHECKOUT ANGEBOTEN WERDEN
     * 
     * @global xtPrice $xtPrice
     * @global order $order
     * @global float $shipping_weight
     * @param string $method
     * @return array
     */
    function quote($method = '') {
        $this->quotes = [];
        return $this->quotes;    
    }
    
    
    
    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_SHIPPING_WEMALO_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }



    function install() {
        xtc_db_query("CREATE TABLE if not exists wemalo (wemalo_id INT NOT NULL AUTO_INCREMENT, shipping_id INT NOT NULL, wemalo_reference_id VARCHAR(16), submitted INT(1) NOT NULL, wemalo_status INT(1) NOT NULL, date_added DATETIME NOT NULL, goodsOrderParcelId VARCHAR(16) NOT NULL, PRIMARY KEY (wemalo_id) )");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) VALUES ('MODULE_SHIPPING_WEMALO_STATUS', 'False', '6', '0', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_WEMALO_ALLOWED', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_WEMALO_SORT_ORDER', '0', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_SHIPPING_WEMALO_KEY', '', '6', '0', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added,set_function) values ('MODULE_SHIPPING_WEMALO_WEBHOOKS', '', '6', '0', now(),'yes_wemalo_webhooks_selection(')");
    }

    function remove() {
        xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
//        xtc_db_query("alter table " . TABLE_ADMIN_ACCESS . " drop dhlgkapi_print_label");
    }

    function keys() {
        return array ('MODULE_SHIPPING_WEMALO_STATUS',
            'MODULE_SHIPPING_WEMALO_ALLOWED', 
            'MODULE_SHIPPING_WEMALO_SORT_ORDER',
            'MODULE_SHIPPING_WEMALO_KEY',
            'MODULE_SHIPPING_WEMALO_WEBHOOKS',
        );
    }

}

