<?php
/* -----------------------------------------------------------------------------------------
   $Id: product_info.php,v 1.94 2020/04/30 10:12:38 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(product_info.php,v 1.94 2003/05/04); www.oscommerce.com
   (c) 2003      nextcommerce (product_info.php,v 1.46 2003/08/25); www.nextcommerce.org

   Released under the GNU General Public License
   -----------------------------------------------------------------------------------------
   Third Party contribution:
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist
   New Attribute Manager v4b                            Autor: Mike G | mp3man@internetwork.net | http://downloads.ephing.com
   Cross-Sell (X-Sell) Admin 1                          Autor: Joshua Dechant (dreamscape)
   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
//include needed functions
require_once(DIR_FS_INC . 'yes_get_master_slave_keys.inc.php');
require_once(DIR_FS_INC . 'yes_get_master_slave_key_value.inc.php');
require_once(DIR_FS_INC . 'xtc_collis.inc.php');
require_once(DIR_FS_INC . 'yes_get_ext_traffic.inc.php');
if(!defined('DIR_FS_ADMIN')){
    define('DIR_FS_ADMIN',DIR_FS_CATALOG.'admin/');
}
require_once('admin/includes/classes/class.storagequantity.php');
require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
require_once(DIR_FS_INC . 'xtc_get_shipping_status_name.inc.php');
require_once(DIR_FS_INC . 'xtc_check_categories_status.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_mo_images.inc.php');
require_once(DIR_FS_INC . 'xtc_get_vpe_name.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
//   require_once(DIR_FS_INC . 'xtc_get_products_unit.inc.php');



$info_smarty = new yesSmarty;
$info_smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$pID = xtc_get_prid((int)xtc_db_input($_REQUEST['products_id']));
if(!isset($admin)){
	$admin = false;
}
$product = new product($pID,$admin);
if(STOCK_ALLOW_CHECKOUT != 'true'){
    $pem = new products_email_notification;
    $pem->collectData();
}
// DIESE INSTANZ IM META TITLE VERWENDEN!
$PRODUCT_INFO_PRODUCT = $product;
if(!$product->isProduct()) { // product not found in database

  	$error=TEXT_PRODUCT_NOT_FOUND;
	header("Status: 404 Not Found");
  	include(DIR_WS_MODULES . FILENAME_ERROR_HANDLER);

} else {
	$product_info = $product->data;
	$SQ = new products_quantity($product_info['products_id']);
	$product_info['qty_total'] = $SQ->get_products_total_qty();
	$info_array = $product->buildDataArray($product_info);
        if(isset($_GET['action']) and $_GET['action'] == 'get_price'){
            $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($pID);
            if($xy !== false){
                die(json_encode([
                    'PRICE'=>$xy->get_price( $_GET['X'], $_GET['Y'],$info_array['PRODUCTS_TAX_RATE']),
                ]));
            }
            die(json_encode([
                'PRICE'=>0.
            ]));
        }
	$info_array['price_float'] = (float)str_replace(',','.',$info_array['PRODUCTS_PRICE_CLEAN']);
        if($_SESSION['customers_status']['customers_status_graduated_prices']=='1'){
            $info_array['GRADUATED'] = $product->getGraduated();
        }else{
            $info_array['GRADUATED'] = null;
        }
	$info_smarty->assign([
            'INFO'=>$info_array,
            'slave_values'=>[],
        ]);
	if (ACTIVATE_NAVIGATOR=='true') {
		include(DIR_WS_MODULES . 'product_navigator.php');
	}
	//fsk18 lock
	if ($_SESSION['customers_status']['customers_fsk18_display']=='0' && $product_info['products_fsk18']=='1') {
		$error=TEXT_PRODUCT_NOT_FOUND;
		include(DIR_WS_MODULES . FILENAME_ERROR_HANDLER);
	} else {
	    $wishl_button = xtc_image_submit('wishlist_button_bg.gif', IMAGE_BUTTON_IN_WISHLIST, 'name="wishbutton" value="1"');
            $wish = new Wishlist;
	    $wishl_id = $wish->CheckProducts($product->data['products_id'], $_SESSION['customer_id']);
	    if( $wishl_id>0 )   {
	      $wishl_button = xtc_image_submit('wishlist_button_del_bg.gif', IMAGE_BUTTON_FROM_WISHLIST, 'name="wishbut_del" value="1"');
	    }
		// check if customer is allowed to add to cart
		if ($_SESSION['customers_status']['customers_status_show_price']!='0') {
			// fsk18
			if ($_SESSION['customers_status']['customers_fsk18']=='1') {
				if ($product_info['products_fsk18']=='0') {
					$info_smarty->assign('ADD_QTY',xtc_draw_input_field('products_qty', '1','size="3"') . ' ' . xtc_draw_hidden_field('products_id', $product_info['products_id']));
					$info_smarty->assign('ADD_CART_BUTTON', xtc_image_submit('button_in_cart.gif', IMAGE_BUTTON_IN_CART));
					$info_smarty->assign('ADD_WISHLIST_BUTTON', $wishl_button );  // wishlist
				}
			} else {
				$info_smarty->assign('ADD_QTY',xtc_draw_input_field('products_qty', '1','size="3"') . ' ' . xtc_draw_hidden_field('products_id', $product_info['products_id']));
				$info_smarty->assign('ADD_CART_BUTTON', xtc_image_submit('button_in_cart.gif', IMAGE_BUTTON_IN_CART));
					$info_smarty->assign('ADD_WISHLIST_BUTTON', $wishl_button );  // wishlist
			}
		}

		if ($product_info['products_fsk18']=='1') {
			$info_smarty->assign('PRODUCTS_FSK18','true');
		}
		
		//Edit Klarna
		if (defined('MODULE_PAYMENT_PCKREDITOR_DE_PRODUCTLEVEL') && MODULE_PAYMENT_PCKREDITOR_DE_PRODUCTLEVEL == 'True' && MODULE_PAYMENT_PCKREDITOR_DE_STATUS == 'True'){
			include DIR_WS_CLASSES . 'kreditor_lang.php';
			require_once DIR_WS_CLASSES . 'kreditor.php';
			global $KRED_ISO3166_DE;

			$lang_month = KREDITOR_LANG_INFO_DE_PAYMENTTEXT2_EACH;
			$lang_from = KREDITOR_LANG_INFO_DE_PARTPAYMENT_FROM;
			$fee = 195;
			$rate = 1495;
			$cc = $KRED_ISO3166_DE;
			$level = MODULE_PAYMENT_PCKREDITOR_DE_MINLIMIT;

			$products_price = $xtPrice->xtcGetPrice($product->data['products_id'], $format = true, 1, $info_array['PRODUCTS_TAX_CLASS_ID'], $product->data['products_price'], 1);
			$products_price_clean = $xtPrice->xtcGetPrice($product->data['products_id'], $format = false, 1, $info_array['PRODUCTS_TAX_CLASS_ID'], $product->data['products_price'], 1);
			monthly_cost($products_price['plain']*100, $rate, 24, $fee, 1, $cc, $result);
			if (($level*100) < "1390")
			{
			   $level = 13.90;
			}
			if ($products_price_clean >= $level){
				$pc = number_format(round($result/100),0) . " " . '&euro;';

				if ($pc < 6.95){
					$pc = 6.95. " " . '&euro;';
				}
				$info_smarty->assign('PRODUCT_KLARNA_RATE','<img src="images/klarna_icon.png" alt="" style="cursor:default" /><br />'.'Ab '. $pc ." ". $lang_month . '<br />'.MODULE_PAYMENT_PCKREDITOR_INFO_KLARNA.'</a>');
			}

		}
		 // End edit Klarna

		$ampel = $SQ->get_ampel();
		$info_smarty->assign(array(
                    'AMPEL'=>$ampel,
                    'PRODUCTS_CONTENT'=>$product->get_products_content(),
                ));
		$info_smarty->assign('SHIPPING_NAME',$info_array['SHIPPING_NAME']);
		if($info_array['PRODUCTS_SHIPPING_IMAGE'] != ''){
			$info_smarty->assign('SHIPPING_IMAGE',$info_array['PRODUCTS_SHIPPING_IMAGE']);
		}

		$info_smarty->assign('FORM_ACTION',xtc_href_link(FILENAME_PRODUCT_INFO, xtc_get_all_get_params(array('action')) . 'action=add_product'));
		$info_smarty->assign('FORM',xtc_draw_form('cart_quantity', xtc_href_link(FILENAME_PRODUCT_INFO, xtc_get_all_get_params(array ('action')).'action=add_product')));
		$info_smarty->assign('FORM_END','</form>');

		if($info_array['MANUFACTURERS_ID'] > 0){
			$info_smarty->assign('MANUFACTURERS_INFO', $product->getManufacturersData() );
		}
		$info_smarty->assign('EXT_AMPEL', yes_get_ext_traffic( $product_info['qty_total'],$product_info['products_date_available'] ) );
		$info_smarty->assign('EXT_AMPEL2', yes_get_ext_traffic( $SQ->get_available1_qty(),$product_info['products_date_available'] ) );
		$info_smarty->assign('VERFUEGBARER_BESTAND1',$SQ->get_available1_qty());
		$info_smarty->assign('VERFUEGBARER_BESTAND2',$SQ->get_available2_qty());

		$info_smarty->assign('PRODUCTS_TAX_INFO',$info_array['PRODUCTS_TAX_INFO']);
		$info_smarty->assign('PRODUCTS_SHIPPING_LINK',$info_array['PRODUCTS_SHIPPING_LINK']);
		$info_smarty->assign('PRODUCTS_STOCKS_TRAFFIC_IMAGE',$info_array['PRODUCTS_STOCKS_TRAFFIC_IMAGE']);
		$info_smarty->assign('PRODUCTS_STOCKS_TRAFFIC_NAME',$info_array['PRODUCTS_STOCKS_TRAFFIC_NAME']);
		if ($product->data['products_vpe_status'] == 1 && (float)$product->data['products_vpe_value'] > 0){
			$info_smarty->assign('PRODUCTS_VPE', $info_array['PRODUCTS_VPE']);
		}
		
				
	//	$info_smarty->assign('PRODUCTS_UNIT',xtc_get_products_unit($product_info['products_id']));
		
		$info_smarty->assign('PRODUCTS_PRICE',$info_array['PRODUCTS_PRICE']);
		$info_smarty->assign('PRODUCTS_ID',$product_info['products_id']);
		$info_smarty->assign('PRODUCTS_NAME',$product_info['products_name']);
		$info_smarty->assign('SLAVE_TITLE',$product_info['slave_title']);
		$info_smarty->assign('PRODUCTS_MODEL',$product_info['products_model']);
		$info_smarty->assign('PRODUCTS_EAN',$product_info['products_ean']);
		$info_smarty->assign('PRODUCTS_QUANTITY',$product_info['products_quantity']);
		$info_smarty->assign('PRODUCTS_WEIGHT',$product_info['products_weight']);
		$info_smarty->assign('SIZE_WIDTH',$product_info['size_width']);
		$info_smarty->assign('SIZE_HEIGHT',$product_info['size_height']);
		$info_smarty->assign('SIZE_DEPTH',$product_info['size_depth']);

		$info_smarty->assign('PRODUCTS_STATUS',$product_info['products_status']);
		$info_smarty->assign('PRODUCTS_MASTER',$product_info['products_master']);
		$info_smarty->assign('PRODUCTS_MASTER_LINK',xtc_href_link(FILENAME_PRODUCT_INFO, xtc_get_all_get_params(array('action','products_id')).'products_id='.$product_info['products_master']));
		$info_smarty->assign('PRODUCTS_ORDERED',$product_info['products_ordered']);
		$info_smarty->assign('PRODUCTS_PRINT', '<img src="'.DIR_WS_ICONS.'print.gif"  style="cursor:hand" onClick="javascript:window.open(\''.xtc_href_link(FILENAME_PRINT_PRODUCT_INFO,'products_id='.$pID).'\', \'popup\', \'toolbar=0, width=640, height=600\')">');
		$info_smarty->assign('PRODUCTS_DESCRIPTION',stripslashes($product_info['products_description']));
		$info_smarty->assign('PRODUCTS_SHORT_DESCRIPTION',stripslashes($product_info['products_short_description']??''));
		$info_smarty->assign('EXTRATEXT',stripslashes($product_info['products_extra_text']));
		$image='';
		if ($product_info['products_image']!='') {
			$image=DIR_WS_INFO_IMAGES . $product_info['products_image'];
			$image_popup=DIR_WS_POPUP_IMAGES . $product_info['products_image'];
		}
		$info_smarty->assign('PRODUCTS_IMAGE',$image);
		$info_smarty->assign('PRODUCTS_IMAGE_POPUP',$image_popup);
		if(LIGHTBOX_ACTIVE == 'True'){
			$info_smarty->assign('LIGHTBOX',1);
                }

		$tax_value = ($_SESSION['customers_status']['customers_status_show_price_tax'] == 1) ? $info_array['PRODUCTS_TAX_RATE'] : false;
		$info_smarty->assign('PRODUCTS_TAX_VALUE',$tax_value);
		$smarty->assign('error',$messageStack->output('product_info'));


		$slave_values = array();
		$is_master_query = yes_query(
			"SELECT products_id FROM products WHERE products_master=:products_id",
			['products_id'=>(int)$product_info['products_id']]
		);
		if (sizeOf($is_master_query)) {
			$products_master_id = $product_info['products_id'];
			$msk_array = yes_get_master_slave_keys($products_master_id,$_SESSION['languages_id']);
			$key_values = array();
			if(sizeOf($msk_array)){
				foreach($msk_array as $pmk){
					$kv_query = xtc_db_query(sprintf(
						"SELECT title FROM products_master_slave_values WHERE products_master_key_id=%d AND products_id=%d",
						intval($pmk['products_master_keys_id']),intval($product_info['products_id'])
					));
					$kv_row = xtc_db_fetch_array($kv_query);
					$slave_values[$pmk['title']][] = array(
						'products_id'=>$product_info['products_id'],
						'value'=>$kv_row['title']
					);
					$key_values[$pmk['title']] = $kv_row['title'];
				}
			}
			$info_smarty->assign('key_values',$key_values);
			$master_sql_raw = "select p.*,pd.products_name,pd.slave_title from " . TABLE_PRODUCTS . " p, products_description pd where products_master=:products_id and pd.products_id=p.products_id and pd.language_id=:language_id and p.products_status=1 order by p.products_master_sorting,pd.slave_title";
                        $master_parameters = [
                            'language_id'=>(int)$_SESSION['languages_id'],
                            'products_id'=>(int) $pID
                        ];
                        include(DIR_WS_MODULES . 'master_listing.php');
                        $info_smarty->assign('slaves',$slaves);
		    
		    
			$msk_array = yes_get_master_slave_keys($products_master_id,$_SESSION['languages_id']);
			if(sizeOf($msk_array)){
				foreach($msk_array as $pmk){
					$kv_query = xtc_db_query(sprintf(
						"SELECT title FROM products_master_slave_values WHERE products_master_key_id=%d AND products_id=%d",
						intval($pmk['products_master_keys_id']),intval($product_info['products_id'])
					));
					$kv_row = xtc_db_fetch_array($kv_query);
					$slave_values[$pmk['title']][] = array(
						'products_id'=>$product_info['products_id'],
						'value'=>$kv_row['title']
					);
				}
			}
			$info_smarty->assign('slave_values',$slave_values);
		} 
		if($product_info['products_master'] > 0 or (isset($products_master_id) and $products_master_id > 0) and $products_master_id != $pID ){
		    if(!isset($products_master_id) or $products_master_id == 0){
			$products_master_id = $product_info['products_master'];
		    }
			$master_sql_raw = "select p.*,pd.products_name,pd.slave_title from " . TABLE_PRODUCTS . " p, products_description pd where ( products_master=:master_id or p.products_id=:products_id) and pd.products_id=p.products_id and p.products_id!=:not_products_id and pd.language_id=:language_id and p.products_status=1  order by pd.slave_title";
                        $master_parameters = [
                            'language_id'=>(int)$_SESSION['languages_id'],
                            'products_id'=>(int)$product_info['products_master'],
                            'not_products_id'=>(int) $pID,
                            'master_id'=>(int)$product_info['products_master']
                        ];
			$msk_array = yes_get_master_slave_keys($products_master_id,$_SESSION['languages_id']);
			include(DIR_WS_MODULES . 'master_listing.php');
			$info_smarty->assign('slaves',$slaves);
			if(sizeOf($msk_array)){
				foreach($msk_array as $pmk){
					$kv_query = xtc_db_query(sprintf(
						"SELECT title FROM products_master_slave_values WHERE products_master_key_id=%d AND products_id=%d",
						intval($pmk['products_master_keys_id']),intval($product_info['products_id'])
					));
					$kv_row = xtc_db_fetch_array($kv_query);
					$slave_values[$pmk['title']][] = array(
						'products_id'=>$product_info['products_id'],
						'value'=>$kv_row['title']
					);
				}
			}
			$info_smarty->assign('slave_values',$slave_values);
		}
	
		include(DIR_WS_MODULES . 'xsell_products.php');
		
		$info_smarty->assign('PRODUCTS_POPUP_LINK','javascript:popupWindow(\'' . xtc_href_link(FILENAME_POPUP_IMAGE, 'pID=' . $product_info['products_id']) . '&imgID=0\')');
		
    $connector = '&';
//-- SEO ShopStat


// BIS HIER HIN


		$info_smarty->assign('PRODUCTS_POPUP_LINK','javascript:popupWindow(\'' . xtc_href_link(FILENAME_POPUP_IMAGE, 'pID=' . $product_info['products_id'] . $connector . 'imgID=' . '0'). '\')');


		$mo_images = $product->getMoImages();
		$info_smarty->assign('mo_images',$mo_images);
		if (sizeOf($mo_images)){
			foreach($mo_images as $img) {
				$mo_img = xtc_href_link($img['image']);
				$info_smarty->assign('PRODUCTS_IMAGE_'.$img['image_nr'], $mo_img);
				$info_smarty->assign('PRODUCTS_POPUP_LINK_'.$img['image_nr'],'javascript:popupWindow(\'' . xtc_href_link(FILENAME_POPUP_IMAGE, 'pID=' . $product_info['products_id'] . $connector . 'imgID='.$img['image_nr']).'\')');
			}
		}
			//mo_images EOF
		
		if ($_SESSION['customers_status']['customers_status_public'] == 1 && $_SESSION['customers_status']['customers_status_discount'] != '0.00') {
			$discount = $_SESSION['customers_status']['customers_status_discount'];
			if ($product_info['products_discount_allowed'] < $_SESSION['customers_status']['customers_status_discount']) $discount = $product_info['products_discount_allowed'];
			if ($discount != '0.00' ) {
				$info_smarty->assign('PRODUCTS_DISCOUNT',$discount . '%');
			}
		}
		
		//include(DIR_WS_MODULES . 'product_attributes.php');
		//include(DIR_WS_MODULES . 'product_reviews.php');
		// KATEGORIEPFADE - WIRD NIRGENDS VERWENDET?
		if(defined('SHOW_CATEGORY_PATH_ARRAY') && SHOW_CATEGORY_PATH_ARRAY == 'true'){
			$top_categories_array = array();
			$in_category = $selected_cat_id;
			$in_category_query = yes_query(
                            "SELECT parent_id FROM categories WHERE categories_id=:cat_id",
                            ['cat_id'=>(int)$in_category]
                        );
			if(sizeOf($in_category_query)){
				$parent = current($in_category_query);
				$top_categories = yes_query(
                                    "SELECT cd.categories_name,c.categories_id FROM categories c LEFT JOIN categories_description cd USING(categories_id) WHERE c.parent_id=:parent_id and cd.language_id=:language_id ORDER BY sort_order",
                                    [
                                        'language_id'=>(int)$_SESSION['languages_id'],
                                        'parent_id'=>(int)$parent['parent_id']
                                    ]
                                );
				if(sizeOf($top_categories)){
                                    foreach($top_categories as $category){
                                        $top_cat_products_query = xtc_db_query(sprintf(
											"SELECT p.products_id FROM products p LEFT JOIN products_to_categories p2c USING(products_id) WHERE p2c.categories_id='%d' ORDER BY products_sort LIMIT 1",
											intval($category['categories_id'])
										));
                                        if(xtc_db_num_rows($top_cat_products_query)){
                                                $top_cat_products = xtc_db_fetch_array($top_cat_products_query);
                                                $tc_link = xtc_href_link(FILENAME_PRODUCT_INFO,'products_id='.$top_cat_products['products_id'].'_'.$category['categories_id']);
                                        }else{
                                                $tc_link = xtc_href_link(FILENAME_DEFAULT,'cPath='.$category['categories_id']);
                                        }
                                        $top_categories_array[] = array(
                                                'id'=>$category['categories_id'],
                                                'name'=>$category['categories_name'],
                                                'link'=>$tc_link
                                        );
                                    }
                                    $info_smarty->assign('TOP_CATEGORIES_ARRAY',$top_categories_array);
				}
			}

			// NUN NOCH EIN PRODUCTS_ARRAY
			$products_in_category_array = array();
			$plisting_sql = sprintf(
                            "select p.products_id,pd.products_name from %s pd LEFT JOIN %s p USING(products_id) LEFT JOIN %s p2c USING(products_id) WHERE p.products_status = '1' and p.products_listing_status = '1' and pd.language_id =:language_id and p2c.categories_id=:cat_id ORDER BY p.products_sort",
                            TABLE_PRODUCTS_DESCRIPTION,
                            TABLE_PRODUCTS,
                            TABLE_PRODUCTS_TO_CATEGORIES
			);

			$prod_ic_query = yes_query($plisting_sql,[
                            'language_id'=>(int)$_SESSION['languages_id'],
                            'cat_id'=>(int)$in_category
                        ]);
			if(sizeOf($prod_ic_query)){
				foreach($prod_ic_query as $prod_ic){
					$products_in_category_array[] = array(
						'id'=>$prod_ic['products_id'],
						'name'=>$prod_ic['products_name'],
						'link'=>xtc_href_link(FILENAME_PRODUCT_INFO,'products_id='.$prod_ic['products_id'].'_'.$in_category)
					);
				}
				$info_smarty->assign('PRODUCTS_IN_CATEGORY',$products_in_category_array);
			}
			$info_smarty->assign('CURRENT_CATEGORY_ID',$current_category_id);
		}
		
		
		if (xtc_not_null($product_info['products_url'])) {
			$info_smarty->assign('PRODUCTS_URL',sprintf(TEXT_MORE_INFORMATION, xtc_href_link(FILENAME_REDIRECT, 'action=url&goto=' . urlencode($product_info['products_url']), 'NONSSL', true, false)));
			$info_smarty->assign('PRODUCTS_URL_RAW',$product_info['products_url']);
		}
		if ($product_info['products_date_available'] > date('Y-m-d H:i:s')) {
			$info_smarty->assign('PRODUCTS_DATE_AVIABLE',sprintf(TEXT_DATE_AVAILABLE, xtc_date_long($product_info['products_date_available'])));
		} else {
			if ($product_info['products_date_added']!='0000-00-00 00:00:00') 
				$info_smarty->assign('PRODUCTS_ADDED',sprintf(TEXT_DATE_ADDED, xtc_date_long($product_info['products_date_added'])));
		}
		
		if ($_SESSION['customers_status']['customers_status_graduated_prices'] == 1) {
			include(DIR_WS_MODULES.FILENAME_GRADUATED_PRICE);
		}
		
		//include(DIR_WS_MODULES . FILENAME_PRODUCTS_MEDIA);
		include(DIR_WS_MODULES . 'product_characteristics.php');
		if(USE_XSELL == 'true'){
			include(DIR_WS_MODULES . FILENAME_XSELL_PRODUCTS);
		}
		include(DIR_WS_MODULES . FILENAME_ALSO_PURCHASED_PRODUCTS);
		if ($product_info['product_template']=='' or $product_info['product_template']=='default') {
			$files=array();
		        if ($dir= opendir(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/product_info/')){
		        	while  ($file = readdir($dir)) {
					if (is_file( DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/module/product_info/'.$file) and ($file !="index.html")){
					        $files[]=array(
		                		        'id' => $file,
				                        'text' => $file);
		        		}//if
				} // while
				closedir($dir);
		        }
			$product_info['product_template']=$files[0]['id'];
		}
		$info_smarty->assign('language', $_SESSION['language']);

		// testeo
		$testeo_query = "SELECT * FROM testeo WHERE yourID='".intval($product_info['products_id'])."'";
		$testeo_query = xtc_db_query($testeo_query);
		if(xtc_db_num_rows($testeo_query)){
			$testeo_data = xtc_db_fetch_array($testeo_query);
			$info_smarty->assign('TESTEO', $testeo_data['sourceCode']);
		}
		$info_smarty->assign('DISTRIBUTOR_ORDERS_EARLIES_ESTIMATED_DATE_RECEIPT',$product->get_earliest_estimated_date_receipt());
		// testeo

		$catID = current(array_reverse(explode('_',$cPath)));
		if(xtc_not_null($catID)){
			$cat = yes_query(
				"SELECT categories_image FROM categories WHERE categories_id=:cat_id",[
					'cat_id'=>(int)$catID
				],
				true
			);
			if(xtc_not_null($cat['categories_image'])){
				$info_smarty->assign('CATEGORIES_IMAGE', $cat['categories_image']);
			}
		}
		
		// BOF BRANCHES
		if(defined('YES_BRANCHES_COUNT') and YES_BRANCHES_COUNT > 0){
			$branches = array();
			$query = xtc_db_query(sprintf(
				"SELECT bp.products_quantity,b.title FROM branches_products bp LEFT JOIN branches b USING(branches_id) WHERE bp.products_id='%d'",
				intval($product_info['products_id'])
			));
			while($record = xtc_db_fetch_array($query)){
				$branches[] = $record;
			}
			if(sizeOf($branches)){
				$info_smarty->assign('BRANCHES',$branches);
			}
		}
		// EOF BRANCHES

		if(defined('MODULE_OTHER_TURNSTILE_STATUS') and constant('MODULE_OTHER_TURNSTILE_STATUS') == 'True'){
			require_once(DIR_WS_MODULES.'other/turnstile.php');
			require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/other/turnstile.php');
			$turnstile = true;
			$turnstile_class = new \turnstile();
		}
		if(!$turnstile){
			$info_smarty->assign('VVIMG', '<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '" />');
			$info_smarty->assign('INPUT_CODE', xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false));
			$info_smarty->assign(array(
				'YES_CAPTCHA'=>$captcha->create(),
			));
		}else{
			$info_smarty->assign(array(
				'YES_CAPTCHA'=>$turnstile_class->create(),
			));
		}

// BOF pem
	    if(STOCK_ALLOW_CHECKOUT != 'true'){
			if($turnstile){
				$info_smarty->assign('PEM_VVIMG',$turnstile_class->create());
			}else{
				$info_smarty->assign('PEM_VVIMG','<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES . '?session_vvcode_prefix=PEM').'" />');
			}
			$info_smarty->assign(array(
				'SAVE_BUTTON'=>IMAGE_SAVE,
				'PEM_email_address'=>'',
				'PEM_add_link'=>xtc_href_link(basename($_SERVER['PHP_SELF']),  xtc_get_all_get_params(array('action')).'action=pem_add')
			));

			if (isset($_SESSION['customer_id'])) {
                    $cust = \YES4Trade\Model\customers::get_by_customers_id($_SESSION['customer_id'],[
                        'customers_email_address'
                    ]);
                    $info_smarty->assign(array(
                        'PEM_email_address'=>$cust->customers_email_address,
                    ));
			}
	    }
// eof pem
		// set cache ID
		if (USE_CACHE=='false') {
			$info_smarty->caching = 0;
			$product_info= $info_smarty->fetch(CURRENT_TEMPLATE.'/module/product_info/'.$product_info['product_template']);
		} else {
			$info_smarty->caching = 1;
			$info_smarty->cache_lifetime=CACHE_LIFETIME;
			$info_smarty->cache_modified_check=CACHE_CHECK;
			$cache_id = $pID.$_SESSION['language'].$_SESSION['customers_status']['customers_status_name'].$_SESSION['currency'];
			$product_info= $info_smarty->fetch(CURRENT_TEMPLATE.'/module/product_info/'.$product_info['product_template'],$cache_id);
		}
	}
}
$smarty->assign('main_content',$product_info);
