<?php
/**
 * Unzer Language File geladen?
 */
if(!defined('MODULE_PAYMENT_UNZER_TEXT_TITLE')){
    $lang = (isset($_SESSION['language']))?$_SESSION['language']:'german';
    require_once(DIR_FS_CATALOG.'lang/'.$lang.'/modules/payment/unzer.php');
}
function yes_get_unzer_public_key(){
    if(empty(MODULE_PAYMENT_UNZER_PUBLIC_KEY)){
        return '';
    }
    return substr(MODULE_PAYMENT_UNZER_PUBLIC_KEY,0,7).'...<br />'.sprintf(
            '<a title="Unzer Admin" style="margin-left: 0px; padding-left: 0px;" href="javascript:;" class="lbOn" id="%s">[Unzer Admin]</a>',
            xtc_href_link('unzer.php')
    );
}
function yes_cfg_pull_down_unzer_list($unzer_list,$key='') {
    $pm = explode(',',$unzer_list);
    $inputs = [];
    foreach(\unzer::UNZER_IMPLEMENTED_PAYMENTS as $ip){
        $checked = in_array($ip,$pm);
        $inputs[] = xtc_draw_checkbox_field("configuration[MODULE_PAYMENT_UNZER_LIST][]",$ip,$checked).'&nbsp;'.$ip;
    }
    return implode('<br />',$inputs);
}

class unzer {
    var $code, //name of the module
	    $title, //title name in list
	    $description,
        $sort_order,
	    $enabled;
    
    public const UNZER_PAYMENT_STATES = [
        ['state'=>0,'title'=>'Pending','description'=>UNZER_PAYMENT_STATE_DESC_0],
        ['state'=>1,'title'=>'Completed','description'=>UNZER_PAYMENT_STATE_DESC_1],
        ['state'=>2,'title'=>'Canceled','description'=>UNZER_PAYMENT_STATE_DESC_2],
        ['state'=>3,'title'=>'Partly','description'=>UNZER_PAYMENT_STATE_DESC_3],
        ['state'=>4,'title'=>'Payment review','description'=>UNZER_PAYMENT_STATE_DESC_4],
        ['state'=>5,'title'=>'Chargeback','description'=>UNZER_PAYMENT_STATE_DESC_5],
        ['state'=>6,'title'=>'Create','description'=>UNZER_PAYMENT_STATE_DESC_6]
    ];
    
    /**
     * Constructor
     */
    function __construct() {
        global $order;
        $this->code = 'unzer';
        if(defined('MODULE_PAYMENT_UNZER_TEXT_TITLE')){
            $this->title =MODULE_PAYMENT_UNZER_TEXT_TITLE;
        }
        $this->sort_order = (defined('MODULE_PAYMENT_UNZER_SORT_ORDER')) ? MODULE_PAYMENT_UNZER_SORT_ORDER : 0;
        $this->enabled = (defined('MODULE_PAYMENT_UNZER_STATUS') and MODULE_PAYMENT_UNZER_STATUS == 'True') ? true : false;
        if(defined('MODULE_PAYMENT_UNZER_TEXT_DESCRIPTION')){
            $this->description = MODULE_PAYMENT_UNZER_TEXT_DESCRIPTION;
        }

        if (is_object($order)) {
            $this->update_status();
        }
    }
    
    public static function setUnzer_payment_data(array $unzer_payment_data ){
        $_SESSION['unzer_payment_data'] = $unzer_payment_data;
    }
    
    /**
     * Implementation von yes_write_notice mit Pruefung ob die Funktion existiert
     * 
     * @param string $notice_subject
     * @param string $notice_text
     * @param string $admin_access_field
     */
    public static function error_notice( string $notice_subject,string $notice_text, string $admin_access_field ){
        if(!function_exists('yes_write_notice')){
            require_once(DIR_FS_INC.'yes_write_notice.inc.php');
        }
        $sender = 0;
        $recipients_array = main::get_notice_recipients($admin_access_field);
        yes_write_notice($notice_subject, $notice_text, $sender, $recipients_array);
    }
    
    /**
     * Zuordnung Unzer Payment Status zu YES Order Status über eine JSON Datei
     * self::get_status_allocation_file_path()
     * Die Datei wird erzeugt beim installieren des Unzer Payment Moduls und
     * kann jederzeit aktualisiert werden aus der Modulkonfiguration Unzer Payment
     * 
     * @param int $unzer_state
     * @return int
     * @throws Exception
     */
    public static function get_yes_orders_status_from_unzer_status(int $unzer_state){
        $file = self::get_status_allocation_file_path();
        if(!is_file($file)){
            self::error_notice(UNZER_ERROR_NO_STATUS_ALLOCATION_FILE_TITLE,
                UNZER_ERROR_NO_STATUS_ALLOCATION_FILE_DESCRIPTION,
                'orders'
            );
            throw new Exception(UNZER_ERROR_NO_STATUS_ALLOCATION_FILE_TITLE);
        }
        $unzer_statii = json_decode(file_get_contents($file));
        foreach($unzer_statii as $us){
            if((int)$us->state == $unzer_state){
                return (int)$us->orders_status_id;
            }
        }
        self::error_notice(UNZER_ERROR_UNKNOWN_UNZER_STATUS_TITLE,
            sprintf(UNZER_ERROR_UNKNOWN_UNZER_STATUS_DESCRIPTION, $unzer_state),
            'orders'
        );
        throw new Exception(sprintf(UNZER_ERROR_UNKNOWN_UNZER_STATUS_DESCRIPTION,$unzer_state));
    }
    
    /**
     * liefert den Pfad inkl. Dateiname der Unzer Payment Status 
     * zu YES Order Status JSON Datei
     * @return string
     */
    public static function get_status_allocation_file_path(){
        return main::get_secure_path().'UNZER_ORDERS_STATUS_ALLOCATIONS.json';
    }
    
    /**
     * Schreibt JSON Daten in self::get_status_allocation_file_path() - die JSON
     * Daten enthalten die Zuweisungen Unzer Payment Status zu YES Order Status
     * Es wird immer geprueft ob die Datei existiert und ggf. geloescht und
     * danach neu erzeugt.
     * 
     * @param array $json
     * @throws Exception
     */
    public static function create_status_allocation_file( array $json ){
        $status_file = self::get_status_allocation_file_path();
        if(file_exists($status_file)){
            unlink($status_file);
        }
        try{
            basics::create_file2($status_file, json_encode($json));
        }catch(Exception $e){
            throw new Exception('Cant create status allocation file. '.$e->getMessage());
        }
    }

    /**
     * Bei einer Unzer Payment Statuswechsel Meldung wird geprüft ob der Lokale 
     * Datensatz in unzer_payments bereits aktualisiert ist und bei Bedarf kriegt 
     * der Auftrag einen neuen Status.
     * 
     * @param int $unzer_payment_id
     * @param int $state
     * @param string $state_name
     */
    public static function update_db_payment_state( int $unzer_payment_id, int $state, string $state_name ){
        $pmd = self::get_unzer_payment_data_from_db($unzer_payment_id);
        $update_sql_array = [
            'unzer_state'=>$state
        ];
        yes_db_perform('unzer_payments',$update_sql_array,'update',[
            'unzer_payments_id'=>$unzer_payment_id
        ]);
        $order = new order( $pmd['orders_id'] );
        $comments = sprintf(UNZER_UPDATE_PAYMENT_STATUS,$state_name,$state);
        if($pmd['unzer_state'] != $state){
            $orders_status_id = self::get_yes_orders_status_from_unzer_status($state);
            $order->update_orders_status( $orders_status_id );
            $lang_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
            $comments .= ' - '.sprintf(UNZER_UPDATE_PAYMENT_STATUS_ORDER_UPDATED,
                main::get_orders_status_name($orders_status_id, $lang_id)
            );
        }
        $order->add_history($order->info['orders_status'], false, $comments);
    }
    
    /**
     * Liefert einen unzer_payments Datensatz basierend auf dem index der 
     * Tabelle unzer_payments
     * Der Datensatz enthaelt unzer_payments_id, PaymentId, ShortId,
     * orders_id und unzer_state
     * 
     * @param int $unzer_payment_id
     * @return array
     */
    public static function get_unzer_payment_data_from_db( int $unzer_payment_id ){
        if($unzer_payment_id < 1){
            throw new Exception( 'missing unzer_payment_id in get_unzer_payment_data_from_db()');
        }
        return yes_query(
            "SELECT * FROM unzer_payments WHERE unzer_payments_id=:payment_id",
            ['payment_id'=>$unzer_payment_id]
        );
    }
    
    /**
     * Liefert den index (unzer_payment_id) der Tabelle unzer_payments basierend 
     * auf der Unzer PaymentId
     * 
     * @param string $paymentId
     * @return type
     * @throws Exception
     */
    public static function get_unzer_payment_id_from_db(string $paymentId){
        if(empty($paymentId)){
            throw new Exception('empty payment id parameter in unzer::get_unzer_payment_id_from_db()');
        }
        $record = yes_query(
            "SELECT unzer_payments_id FROM unzer_payments WHERE PaymentId=:payment_id",
            ['payment_id'=>$paymentId],
            true
        );
        return $record['unzer_payments_id'];
    }
    
    /**
     * Prueft ob in der Tabelle unzer_payments bereits ein Datensatz existiert
     * basierend auf der Unzer PaymentId
     * 
     * @param string $paymentId
     * @return bool
     * @throws Exception
     */
    public static function payment_exists( string $paymentId ){
        if(empty($paymentId)){
            throw new Exception('empty payment id parameter in unzer::payment_exists()');
        }
        $query = yes_query(
            "SELECT unzer_payments_id FROM unzer_payments WHERE PaymentId=:payment_id",
            ['payment_id'=>$paymentId],
        );
        return (sizeOf($query))?true:false;
    }
    
    /**
     * Liefert den Inhalt des Session Arrays "unzer_payment_data" - dieses Array
     * enthaelt die Daten die im Checkout Prozess gesammelt werden
     * 
     * @return array
     */
    public static function getUnzer_payment_data(){
        return $_SESSION['unzer_payment_data'];
    }
    
    public static function getReturnUrl(){
        $url = trim(HTTPS_SERVER);
        if(substr($url,-1) !== '/'){
            $url .= '/';
        }
        $url .= 'checkout_shipping.php';
        return $url;
    }
    
    


    /**
     * Function that checks if payment_module is available for this zone
     * Function is called when displaying the available payments
     */
    function update_status() {
        global $order;
        if (($this->enabled == true) && ((int) MODULE_PAYMENT_UNZER_ZONE > 0)) {
		$billing_country_id = (!strstr($_SERVER['SCRIPT_URL'],'/admin/') and function_exists('xtc_catalog_href_link')) ? $order->billing['country']['id'] : $order->billing['country_id'];
                $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                    intval(MODULE_PAYMENT_UNZER_ZONE),
                    intval($billing_country_id),
                    intval($order->billing['zone_id'])
                );
		if ($check_flag == false) {
			$this->enabled = false;
		}
        }
    }

    /**
     * Function that returns javascript code that will validate the data required from user for the payment
     *
     * @return string
     */
    function javascript_validation() {
        return '';
    }

    /**
     * Function that returns what should be displayed on Available payment types page
     *
     * @return array
     */
    function selection() {
        global $order;
	$selection = array('id' => $this->code, 'module' => $this->title);
	if(!empty($this->description)){
		$selection['description'] = $this->description;
	}
	$this->process_button();
        return $selection;
    }

    /**
     * Function that checks if configuration key is available in database
     */
    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("SELECT configuration_value FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = 'MODULE_PAYMENT_UNZER_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function pre_confirmation_check() {
    }

    function confirmation() {
        global $order;

        $confirmation = array('title' => $this->title,
            'fields' => array()
        );
        return $confirmation;
    }

    function process_button() {
        global $order;
        if($order === null){
            return false;
        }
        $total = $order->info['total'];
        return false;
    }
    
    /**
     * Function that handles successfull payment, or does the request on Secupay API
     */
    function before_process() {
        global $order, $order_totals;
        $unzer_payment_data = self::getUnzer_payment_data();
        // State setzen wir, wenn der User zu unzer_redirect.php geleitet wurde
        // und wir den Status der paymentID geprueft haben.
        // Bei status 2 wird abgebrochen und zur Checkoutseite redirected
        if(!isset($unzer_payment_data['State'])){
            include('unzer_calls.php');
        }
    }
    
    /**
     * Nach erfolgreichem Payment wird ein Datensatz in unzer_payments erzeugt
     * 
     * @param int $orders_id
     * @param string $payment_id
     * @param int $state
     */
    public static function save_order_payment_id_allocation( int $orders_id, string $payment_id, int $state ){
        $insert_sql_array = [
            'PaymentId'=>$payment_id,
            'orders_id'=>(int)$orders_id,
            'unzer_state'=>$state
        ];
        yes_db_perform('unzer_payments',$insert_sql_array);
    }
    /**
     * function that writes to log and db
     */
    function after_process() {
        global $insert_id;
        $unzer_payment_data = self::getUnzer_payment_data();
        self::save_order_payment_id_allocation($insert_id,$unzer_payment_data['paymentId'], $unzer_payment_data['State']);
        // UNZER PAYMENT SESSION LOESCHEN
        self::setUnzer_payment_data([]);
    }

    /**
     * Function that installs Secupay Invoice payment module
     */
    function install() {
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_STATUS',
            'configuration_value'=>'False',
            'configuration_group_id'=>6,
            'sort_order'=>0,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'',
            'set_function'=>"xtc_cfg_select_option(array('True', 'False'),"
	    );
	    xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_SORT_ORDER',
            'configuration_value'=>0,
            'configuration_group_id'=>6,
            'sort_order'=>1,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'',
            'set_function'=>''
        );
        xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_ZONE',
            'configuration_value'=>'',
            'configuration_group_id'=>6,
            'sort_order'=>2,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'xtc_get_zone_class_title',
            'set_function'=>'xtc_cfg_pull_down_zone_classes('
        );
    	xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_PRIVATE_KEY',
            'configuration_value'=>'',
            'configuration_group_id'=>6,
            'sort_order'=>3,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'',
            'set_function'=>''
        );
        xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_PUBLIC_KEY',
            'configuration_value'=>'',
            'configuration_group_id'=>6,
            'sort_order'=>3,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'yes_get_unzer_public_key',
            'set_function'=>''
        );
        xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_LOGOIMGURL',
            'configuration_value'=>'https://yes-system.de/wp-content/uploads/2019/02/cropped-yes_logo_blue.png',
            'configuration_group_id'=>6,
            'sort_order'=>4,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'',
            'set_function'=>''
        );
        xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        
        $insert_sql_array = array(
            'configuration_key'=>'MODULE_PAYMENT_UNZER_SHOP_DESCRIPTION',
            'configuration_value'=>'Eine kurze Beschreibung meines Onlineshops. Wir arbeiten mit YES4Trade. Kontaktieren Sie uns für mehr Infos',
            'configuration_group_id'=>6,
            'sort_order'=>5,
            'last_modified'=>'',
            'date_added'=>'now()',
            'use_function'=>'',
            'set_function'=>'xtc_cfg_textarea('
        );
        xtc_db_perform(TABLE_CONFIGURATION,$insert_sql_array);
        
        $q = xtc_db_query(sprintf("SELECT * FROM information_schema.tables WHERE table_schema = '%s' AND table_name = 'unzer_payments'",
                DB_DATABASE
        ));
        if(!xtc_db_num_rows($q)){
            $sql = xtc_db_query("CREATE TABLE `unzer_payments` ( `unzer_payments_id` INT NOT NULL AUTO_INCREMENT , `PaymentId` VARCHAR(32) NOT NULL , `ShortId` VARCHAR(32) NOT NULL , `orders_id` INT NOT NULL , unzer_state INT NOT NULL, PRIMARY KEY (`unzer_payments_id`), INDEX (`orders_id`))");
        }

        $json = [];
        $status_file = self::get_status_allocation_file_path();
        if(file_exists($status_file)){
            unlink($status_file);
        }
        foreach(self::UNZER_PAYMENT_STATES as $upm){
            $os = 1;
            if($upm['state'] == 1){
                $os = ORDERS_STATUS_BEZAHLT;
            }
            $json[] = ['state'=>$upm['state'],'orders_status_id'=>$os];
        }
        try{
            basics::create_file2($status_file, json_encode($json));
        }catch( Exception $e ){
            throw new Exception('Unzer Status Allocation write error: '.$e->getMessage());
        }
    }

    /**
     * Function that removes payment module
     */
    function remove() {
        xtc_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys(){
	return 	 array(
            'MODULE_PAYMENT_UNZER_STATUS',
            'MODULE_PAYMENT_UNZER_SORT_ORDER',
            'MODULE_PAYMENT_UNZER_ZONE',
            'MODULE_PAYMENT_UNZER_PUBLIC_KEY',
            'MODULE_PAYMENT_UNZER_PRIVATE_KEY',
            'MODULE_PAYMENT_UNZER_LOGOIMGURL',
            'MODULE_PAYMENT_UNZER_SHOP_DESCRIPTION'
       );
   }

    public function getOpenerJavascript(){

    }
    public function getLoginButton(){
            return 'unzer button';
    }

}
