<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

  class sofortueberweisungredirect {
    var $code, $title, $description, $enabled,$form_action_url;

// class constructor
    function __construct() {
      global $order;

      $this->code = 'sofortueberweisungredirect';
      $this->title = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_TITLE;
      $this->description = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER')) ? MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER : 0;
      $this->enabled = ((defined('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS') and MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS == 'True') ? true : false);
      if($this->enabled === true){
        $this->email_footer = '';
        $this->text_redirect = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_REDIRECT;
        $this->form_action_url = 'https://www.sofortueberweisung.de/payment/start';
      }
      if (is_object($order)) $this->update_status();

    }

// class methods
    function update_status() {
      global $order;

      if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE > 0) ) {
        $check_flag = \YES4Trade\Model\zones_to_geo_zones::is_module_payment_zone_valid(
                intval(MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE),
                intval($order->billing['country']['id']),
                intval($order->billing['zone_id'])
        );
        if ($check_flag == false) {
          $this->enabled = false;
        }
      }
    }

    function javascript_validation() {
      return false;
    }

    function selection() {
      return array('id' => $this->code,
                   'module' => $this->title,
                   'fields' => array(array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_DESCRIPTION_CHECKOUT_PAYMENT)));
    }

    function pre_confirmation_check() {
      return false;
    }

    function confirmation() {
      return array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_DESCRIPTION_CHECKOUT_CONFIRMATION);
    }

    function process_button() {
      global $order, $xtPrice, $cart,$insert_id,$payment_source_from;
      if(!isset($cart) or !is_object($cart))
	$cart = $_SESSION['cart'];
      if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
 		$total = $order->info['total'] + $order->info['tax'];
      } else {
		$total = $order->info['total'];
      }

      // Fix for XTC Bug
      // $order->info['total'] is in 'before_process' String without Tax
      // so it has to be set here

      $_SESSION['sofortueberweisung_total'] =  number_format($xtPrice->xtcCalculateCurrEx($total, 'EUR'), $xtPrice->get_decimal_places('EUR'), '.', '');
      $customer_id = $_SESSION['customer_id'];
     // $order =
      $parameter= array();

      $return = '';
      $parameter['user_id'] = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR;  // Repr�sentiert Ihre Kundennummer bei der Sofort�berweisung
      $parameter['project_id'] = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT;  // Die verantwortliche Projektnummer bei der Sofort�berweisung, zu der die Zahlung geh�rt
      $parameter['amount'] = $_SESSION['sofortueberweisung_total'];
      // number_format($order->info['total'] *  $currencies->get_value('EUR'), 2, '.','');   // Beziffert den Zahlungsbetrag, der an Sie �bermittelt werden soll


      $vzweck1 = str_replace('{{orderid}}', $insert_id, MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_V_ZWECK_1);
      $vzweck2 = str_replace('{{orderid}}', $insert_id, MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_V_ZWECK_2);

      $vzweck1 = str_replace('{{order_date}}', yes_strftime(DATE_FORMAT_SHORT), $vzweck1);
      $vzweck2 = str_replace('{{order_date}}', yes_strftime(DATE_FORMAT_SHORT), $vzweck2);

      $vzweck1 = str_replace('{{customer_id}}', $customer_id, $vzweck1);
      $vzweck2 = str_replace('{{customer_id}}', $customer_id, $vzweck2);

      $vzweck1 = str_replace('{{customer_cid}}', $order->customer['csID'], $vzweck1);
      $vzweck2 = str_replace('{{customer_cid}}', $order->customer['csID'], $vzweck2);

      $vzweck1 = str_replace('{{customer_name}}', $order->customer['firstname'] . ' ' . $order->customer['lastname'], $vzweck1);
      $vzweck2 = str_replace('{{customer_name}}', $order->customer['firstname'] . ' ' . $order->customer['lastname'], $vzweck2);

      $vzweck1 = str_replace('{{customer_company}}', $order->customer['company'], $vzweck1);
      $vzweck2 = str_replace('{{customer_company}}', $order->customer['company'], $vzweck2);

      $vzweck1 = str_replace('{{customer_email}}', $order->customer['email_address'], $vzweck1);
      $vzweck2 = str_replace('{{customer_email}}', $order->customer['email_address'], $vzweck2);

      // K�rzen auf 27 Zeichen
      $vzweck1 = substr($vzweck1, 0, 27);
      $vzweck2 = substr($vzweck2, 0, 27);

      $parameter['reason_1'] = xtc_parse_input_field_data($vzweck1, array('"' => '&quot;'));  // Definieren Sie hier Ihre Verwendungszwecke
      $parameter['reason_2'] = xtc_parse_input_field_data($vzweck2, array('"' => '&quot;'));  // Definieren Sie hier Ihre Verwendungszwecke
      $parameter['currency_id'] = DEFAULT_CURRENCY;
      $parameter['user_variable_0'] = xtc_parse_input_field_data($insert_id, array('"' => '&quot;'));;  // Eindeutige Identifikation der Zahlung, z.B. Session ID oder Auftragsnummer.
      $parameter['user_variable_1'] = xtc_parse_input_field_data($customer_id, array('"' => '&quot;'));;  // Eindeutige Identifikation der Zahlung, z.B. Session ID oder Auftragsnummer.
      $parameter['user_variable_2'] = xtc_parse_input_field_data(xtc_session_id(), array('"' => '&quot;'));;
      $parameter['user_variable_3'] = $cart->cartID;
      // YES SYSTEM
      switch($payment_source_from){
	default:
		$parameter['user_variable_4'] = 'checkout_process.php';
		break;
	case 'ebay':
		$parameter['user_variable_4'] = 'ebay_account_edit.php';
		break;
      }
      $parameter['user_variable_5'] = 'sofortueberweisung';

      if (strlen(MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT) > 0) {
	$tmparray = array(
		$parameter['user_id'],            // user_id
		$parameter['project_id'],            // project_id
		'',                 // sender_holder
		'',                 // sender_account_number
		'',                 // sender_bank_code
		'',                 // sender_country_id
		$parameter['amount'],        // amount
		$parameter['currency_id'],          // currency_id
		$parameter['reason_1'], // reason_1
		$parameter['reason_2'],             // reason_2
		$parameter['user_variable_0'],
		$parameter['user_variable_1'],
		$parameter['user_variable_2'],
		$parameter['user_variable_3'],
		$parameter['user_variable_4'],
		$parameter['user_variable_5'],
		MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT        // project_password
	);
	$parameter['hash'] = md5(implode("|", $tmparray));
      }

		  $process_button_string = '';
      foreach ($parameter as $key => $value) {
        $process_button_string .= xtc_draw_hidden_field($key, $value). "\n";
      }
      return $process_button_string;

    }

    function before_process() {
      global $order, $xtPrice;
      $md5var4 = md5($_GET['sovar3'] . MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT);
      // Statusupdate nur wenn keine Cart�nderung vorgenommen
     // Valid returns are i.e. 13.12 or 13,12 changes sometimes

	$uebergebener_betrag = (float)$_GET['betrag'];
	$gespeicherter_betrag = (float)$_SESSION['sofortueberweisung_total'];
      if ($md5var4 == $_GET['sovar4'] && $uebergebener_betrag == $gespeicherter_betrag) {
        // we have an verified order
        if ( (int)MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID;
          $order->info['order_status'] = MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID;
        }
      } else {
        $order->info['comments'] .= "\n" . MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_CHECK_ERROR . '\n' . $_GET['betrag'] .'!=' . $_SESSION['sofortueberweisung_total'] ;
      }
      if (MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_TRANSACTION_DETAILS == 'True') {
        $order->info['comments'] .= "\n" . serialize($_REQUEST);
      }

      return false;
    }


    function after_process() {

      return false;
    }

    function checkout_success($insert_id) {
		  return false;
    }

    function get_error() {
      $error = false;
      if (!empty($_GET['payment_error'])) {
        $error = array('title' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_ERROR_HEADING,
                      'error' => MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_TEXT_ERROR_MESSAGE);
      }
      return $error;

    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
      // Update Configuration Key Length 64 is often too short
      xtc_db_query('ALTER TABLE ' . TABLE_CONFIGURATION . ' CHANGE configuration_key configuration_key VARCHAR( 255 ) NOT NULL');
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ( 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS', 'True', '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ALLOWED', '', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR', '10000', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT', '500000', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT', 'abcdef', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT', '123456', '6', '1', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER', '0.9', '6', '0', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE', '0', '6', '2', 'xtc_get_zone_class_title', 'xtc_cfg_pull_down_zone_classes(', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, use_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID', '0', '6', '0', 'xtc_cfg_pull_down_order_statuses(', 'xtc_get_order_status_name', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_TRANSACTION_DETAILS', 'False', '6', '6', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value, configuration_group_id, sort_order, set_function, date_added) values ('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_IS_SHIPPING_BEFORE_PAYMENT', 'True', '6', '4', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now());");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STATUS', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ALLOWED', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ZONE', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_ORDER_STATUS_ID', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_SORT_ORDER', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_KDNR', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_PROJEKT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_INPUT_PASSWORT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_CNT_PASSWORT', 'MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_STORE_TRANSACTION_DETAILS','MODULE_PAYMENT_SOFORTUEBERWEISUNGREDIRECT_IS_SHIPPING_BEFORE_PAYMENT');
    }
  }
