<?php
function yes_cfg_yesdsgvo_consents( $param ){
    $consents_raw = MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS;
    $saved = '';
    if(!empty($consents_raw)){
        $consents = json_decode($consents_raw);
        $saved = '<table style="margin-bottom: 10px;" border="0" class="yesListTable_minimal"><thead><tr><th>Nr</th><th>Funktion/File</th><th>Code</th><th>Aktion</th></tr></thead><tbody>';
        $delete = IMAGE_DELETE;
        $edit = IMAGE_EDIT;
        foreach($consents as $nr => $c){
            $funcfile = (!empty($c->script_src))?$c->script_src:$c->use_function;
            $id = $nr+1;
            $cdesc = substr($c->description,0,60).'...';
            $saved .= 
<<<SAVEDCONSENT
                    <tr>
                        <td>$id</td>
                        <td>$funcfile</td>
                        <td>$c->code</td>
                        <td rowspan="2">
                            <a href="javascript:yesDSGVO_admin_edit($id);"><button type="button" class="ui-button ui-corner-all ui-state-default" style="padding: 4px;width: 140px;">$edit</button></a>
                            <br />
                            <a href="javascript:yesDSGVO_admin_delete($id);;"><button type="button" class="ui-button ui-corner-all ui-state-error" style="padding: 4px;width: 140px;">$delete</button></a>
                        </td>
                    </tr>
                    <tr class="odd">
                        <td colspan="3">$cdesc</td>
                    </tr>
SAVEDCONSENT;
        }
        $saved .= '</tbody></table>';
    }else{
        $consents = [];
        $consents_raw = '""';
    }
    
    $values = [
            'yesDSGVO_consent_type' => 'function',
            'yesDSGVO_consent_value'=>'',
            'yesDSGVO_consent_description'=>'',
            'yesDSGVO_consent_code'=>'',
    ];
    if(isset($_GET['yesDSGVO_consent_select'])){
            $nr = (int)$_GET['yesDSGVO_consent_select'] - 1;
            $values = [
                    'yesDSGVO_consent_type' => (!empty($dsgvo[$nr]->script_src)) ? 'file' : 'function',
                    'yesDSGVO_consent_value' => (!empty($dsgvo[$nr]->script_src)) ? $dsgvo[$nr]->script_src : $dsgvo[$nr]->use_function,
                    'yesDSGVO_consent_description'=>$dsgvo[$nr]->description,
                    'yesDSGVO_consent_code'=>$dsgvo[$nr]->code,
            ];
    }
    
    
    $form_action = xtc_get_all_get_params(array('yesDSGVO_consent_select'));
    $legend = (!isset($_GET['yesDSGVO_consent_select'])) ? 'Neuen Consent Parameter anlegen' : 'Consent Bearbeiten';
    $consent_type_file_checked = ( $values['yesDSGVO_consent_type'] == 'file' ) ? ' selected="selected"' : '';
    $consent_type_func_checked = ( $values['yesDSGVO_consent_type'] == 'function' ) ? ' selected="selected"' : '';
    $consent_value = $values['yesDSGVO_consent_value'];
    $consent_description = $values['yesDSGVO_consent_description'];
    $consent_code = $values['yesDSGVO_consent_code'];
    $title = MODULE_OTHER_YESDSGVO_ADMIN_TITLE;
    $lang_err_1 = YESCONSENTJS_ALERT_ADMIN_MISSING_FILEORFUNCTION;
    $lang_err_2 = YESCONSENTJS_ALERT_ADMIN_FUNCTION_INVALID_CHARS;
    $lang_err_3 = YESCONSENTJS_ALERT_ADMIN_MISSING_DESCRIPTION;
    $lang_err_4 = YESCONSENTJS_ALERT_ADMIN_CODE_INVALID_CHARS;
    
    $input_html = 
<<<YESDSGVOINPUT
<script>
var YESCONSENTJS_ALERT_ADMIN_MISSING_FILEORFUNCTION = "$lang_err_1";
var YESCONSENTJS_ALERT_ADMIN_FUNCTION_INVALID_CHARS = "$lang_err_2";
var YESCONSENTJS_ALERT_ADMIN_MISSING_DESCRIPTION = "$lang_err_3";
var YESCONSENTJS_ALERT_ADMIN_CODE_INVALID_CHARS = "$lang_err_4";
var YES_CONSENT_EDIT_ID = null;
function yesDSGVO_check_form(){
        let cv = $('input#yesDSGVO_consent_value').val();
        if(cv.length<2){
                alert(YESCONSENTJS_ALERT_ADMIN_MISSING_FILEORFUNCTION);
                return false;
        }
        if(cv.indexOf('(') > -1 || cv.indexOf(')') > -1){
                alert(YESCONSENTJS_ALERT_ADMIN_FUNCTION_INVALID_CHARS);
                return false;
        }
        let ds = $('textarea#yesDSGVO_consent_description').val();
        if(ds.length<3){
                alert(YESCONSENTJS_ALERT_ADMIN_MISSING_DESCRIPTION);
                return false;
        }
        let co = $('input#yesDSGVO_consent_code').val();
        if(co.length>0){
                if( !onlyLettersAndNumbers(co) ){
                        alert(YESCONSENTJS_ALERT_ADMIN_CODE_INVALID_CHARS);
                        return false;
                }
        }
        let post_url = 'modules.php?$form_action';
        if(YES_CONSENT_EDIT_ID !== null){
            post_url += '&yesDSGVO_consent_select='+YES_CONSENT_EDIT_ID+'&yesDSGVO_action=update'
        }else{
            post_url += '&yesDSGVO_action=update'
        }
        let post_data = {
            yesDSGVO_consent_type: $('select#yesDSGVO_consent_type').val(),
            yesDSGVO_consent_value: cv,
            yesDSGVO_consent_description: ds,
            yesDSGVO_consent_code: co
	};
            
        $.ajax({
            type: 'post',
            url: post_url,
            data: post_data,
            success: function( res ){
                if( res == 'OK'){
                    window.location.href='modules.php?$form_action';
                }else{
                    alert( res );
                }
            },
            error: function( xhr ){
                alert('Cant add consent');
            }
        });
        return false;
}
let saved_consents_json = $consents_raw;
function onlyLettersAndNumbers(str) {
        return /^[A-Za-z0-9]*$/.test(str);
}

function yesdsgvo_dialog(){
    $('#yesDSGVO_consents_admin').dialog({
        modal: true,
        title: '$title',
        width: '800px',
        height: 'auto',
    });
}
            
function yesDSGVO_admin_edit(nr){
    YES_CONSENT_EDIT_ID = nr;
            let curr_consent = saved_consents_json[nr-1];
            let ctype = (curr_consent.use_function != '') ? 'function' : 'file';
            let cvalue = (curr_consent.use_function != '') ? curr_consent.use_function : curr_consent.script_src;
            $('select[name="yesDSGVO_consent_type"]').val(ctype);
            $('input[name="yesDSGVO_consent_value"]').val(cvalue);
            $('textarea[name="yesDSGVO_consent_description"]').text(curr_consent.description);
            $('input[name="yesDSGVO_consent_code"]').val(curr_consent.code);
    yesdsgvo_dialog();
}

function yesDSGVO_admin_delete( nr ){
            if(confirm('Wirklich löschen?')){
                window.location.href = 'modules.php?$form_action&yesDSGVO_consent_select='+nr+'&yesDSGVO_action=delete';
            }
}
</script>    
$saved
<a href="javascript:;" onClick="yesdsgvo_dialog()"><button type="button" style="padding: 4px;" class="ui-button ui-corner-all ui-state-default">Neuen Consent Eintrag erfassen</button></a>
<div id="yesDSGVO_consents_admin" style="display: none;" class="main">
        <fieldset style="padding:8px;margin-bottom: 8px;">
            <legend style="font-weight: bold;">$legend</legend>
            <label for="yesDSGVO_consent_type">Wählen Sie aus, wie der Javascript Code vorliegt<br /></label>
            <select autocomplete="off" name="yesDSGVO_consent_type" id="yesDSGVO_consent_type">
                    <option value="file" $consent_type_file_checked>Javascript Datei</option>
                    <option value="function" $consent_type_func_checked>Javascript Funktionsname</option>
            </select>
            <br /><br />
            <label for="yesDSGVO_consent_value">Datei oder Funktionsname (je nach voriger Auswahl)<br /></label>
            <input type="text" id="yesDSGVO_consent_value" name="yesDSGVO_consent_value" value="$consent_value" size="32" maxlength="64"/>
            <div style="font-style: italic; font-size: 0.8em;">
                    Javascript Datei: <font style="color:#444444;">relativer Pfad zur Domain. Also zb js/beispiel.js</font><br />
                    Javascript Funktionsname: <font style="color:#444444;">Funktion muss im Template bereitgestellt sein, den Funktionsnamen ohne Klammern angeben. Wenn also zb "meine_kaufabwicklung" als Funktion hinterlegt wird, muss auf der Checkoutseite die Javascript Funktion meine_kaufabwicklung() vorhanden sein.</font>
            </div>
            <br /><br />
            <label for="yesDSGVO_consent_description">DSGVO Beschreibung - wird dem Webseitenbesucher bei der Auswahl der Consents angezeigt<br /></label>
            <textarea name="yesDSGVO_consent_description" id="yesDSGVO_consent_description" cols="80" rows="5">$consent_description</textarea>
            <br /><br />
            <label for="yesDSGVO_consent_code">Interne Bezeichnung - um den definierten Consent nur an bestimmten Stellen einzubinden<br /></label>
            <input name="yesDSGVO_consent_code" id="yesDSGVO_consent_code" size="16" maxlength="16" value="$consent_code" />
            <div style="font-style: italic; font-size: 0.8em;">
                    wenn zb der Code "kaufabw" definiert wird, muss im Template für den Checkout ein Container mit der id "yesDSGVO_code_kaufabw" vorhanden sein.
                    <br /><code>&lt;div id="yesDSGVO_code_kaufabw"&gt;&lt;/div&gt;</code>
                    <br />Sobald dieser Container auf einer Seite vorhanden ist, wird die entsprechende Funktion ausgeführt bzw die angegebene JS Datei geladen.
                    <br />nur Buchstaben und Zahlen erlaubt, also zb "kaufabw" oder "infopage01". 
                    <br />Wenn der Code auf jeder Seite geladen werden soll, Feld leer lassen.
            </div>
        </fieldset>
        <input type="button" onClick="yesDSGVO_check_form()" value="Speichern" />
</div>            
YESDSGVOINPUT;
    return $input_html;
}

function yes_cfg_get_yesdsgvo_consents($yesdsgvo_consents, $key=''){
        $consents = json_decode($yesdsgvo_consents);
        $out = sprintf('Es sind %d verschiedene Consents konfiguriert.',
                (is_countable($consents))?sizeOf($consents):0
        );
	$name = (($key) ? 'configuration[' . $key . ']' : 'configuration_value');
	return $out;
}

class yesDSGVO_admin{
    var $code, $title, $description, $enabled, $sort_order, $consent_configurations;

    function __construct() {
        $this->code = 'yesDSGVO_admin';
        $this->title = MODULE_OTHER_YESDSGVO_ADMIN_TITLE;
        $this->description = MODULE_OTHER_YESDSGVO_ADMIN_DESCRIPTION;
        $this->enabled = ((defined('MODULE_OTHER_YESDSGVO_ADMIN_STATUS') and MODULE_OTHER_YESDSGVO_ADMIN_STATUS == 'True') ? true : false);
        $this->sort_order = (defined('MODULE_OTHER_YESDSGVO_ADMIN_SORT_ORDER')) ? MODULE_OTHER_YESDSGVO_ADMIN_SORT_ORDER : 0;
    }


    function check() {
        if (!isset($this->_check)) {
            $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_YESDSGVO_ADMIN_STATUS'");
            $this->_check = xtc_db_num_rows($check_query);
        }
        return $this->_check;
    }

    function install() {
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_YESDSGVO_ADMIN_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_YESDSGVO_ADMIN_SORT_ORDER', '0',  '6', '1', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added, use_function, set_function) values ('MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS', '',  '6', '1', now(),'yes_cfg_get_yesdsgvo_consents','yes_cfg_yesdsgvo_consents(')");
        
        xtc_db_query("CREATE TABLE IF NOT EXISTS `yesDSGVO_consents` (  `yesDSGVO_consents_id` int(11) NOT NULL auto_increment,  `consent` varchar(64) NOT NULL,  `userip` varchar(32) NOT NULL, `cid` varchar(16),`date_saved` DATETIME NOT NULL, PRIMARY KEY  (`yesDSGVO_consents_id`) ) ENGINE=MyISAM");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_OTHER_YESDSGVO_ADMIN_STATUS', 
          'MODULE_OTHER_YESDSGVO_ADMIN_SORT_ORDER',
          'MODULE_OTHER_YESDSGVO_ADMIN_CONSENT_CONFIGURATIONS',
      );
    }
}
