<?php
class meta_opengraph {

    var $code, $title, $description, $enabled, $sort_order;


    function __construct() {
        $this->code = 'meta_opengraph';
        $this->title = (defined('MODULE_OTHER_META_OPENGRAPH_TEXT_TITLE')) ? MODULE_OTHER_META_OPENGRAPH_TEXT_TITLE : 'Meta Opengraph';
        $this->description = (defined('MODULE_OTHER_META_OPENGRAPH_TEXT_DESC')) ?  MODULE_OTHER_META_OPENGRAPH_TEXT_DESCRIPTION : 'Meta Opengraph';
        $this->enabled = (defined('MODULE_OTHER_META_OPENGRAPH_SORT_ORDER')) ? true : false;
        $this->sort_order = (defined('MODULE_OTHER_META_OPENGRAPH_SORT_ORDER')) ? MODULE_OTHER_META_OPENGRAPH_SORT_ORDER : 0;
    }


    function check() {
        // DA ES EIN BEZAHLPFLICHTIGES MODUL IST, WIRD NICHT _STATUS
        // GEPRUEFT SONDERN DIE EXISTENZ VON _SORT_ORDER
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_OTHER_META_OPENGRAPH_SORT_ORDER'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
        if(!defined('MODULE_OTHER_META_OPENGRAPH_STATUS') or MODULE_OTHER_META_OPENGRAPH_STATUS != 'True'){
            return false;
        }
// per config	xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_META_OPENGRAPH_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_SORT_ORDER', '0',  '6', '1', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_TITLE', '',  '6', '120', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_TYPE', 'website',  '6', '121', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_URL', '',  '6', '122', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,set_function) values ('MODULE_OTHER_META_OPENGRAPH_IMAGE', '',  '6', '123', now(),'xtc_cfg_module_other_meta_opengraph_image_properties(')");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_IMAGE_WIDTH', '',  '6', '124', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_IMAGE_HEIGHT', '',  '6', '125', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added) values ('MODULE_OTHER_META_OPENGRAPH_IMAGE_TYPE', '',  '6', '126', now())");
        xtc_db_query("insert into " . TABLE_CONFIGURATION . " ( configuration_key, configuration_value,  configuration_group_id, sort_order, date_added,set_function) values ('MODULE_OTHER_META_OPENGRAPH_DESCRIPTION', '',  '6', '127', now(),'xtc_cfg_module_textarea(')");
   }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_OTHER_META_OPENGRAPH_SORT_ORDER','MODULE_OTHER_META_OPENGRAPH_TITLE','MODULE_OTHER_META_OPENGRAPH_TYPE','MODULE_OTHER_META_OPENGRAPH_URL','MODULE_OTHER_META_OPENGRAPH_DESCRIPTION','MODULE_OTHER_META_OPENGRAPH_IMAGE','MODULE_OTHER_META_OPENGRAPH_IMAGE_WIDTH','MODULE_OTHER_META_OPENGRAPH_IMAGE_HEIGHT','MODULE_OTHER_META_OPENGRAPH_IMAGE_TYPE');
    }
    
    public function get_og_image($file_path,$image_name){
        if(substr($file_path,-1) != '/'){
            $file_path .= '/';
        }
        if( !is_file(DIR_FS_CATALOG.$file_path.$image_name) or !is_readable(DIR_FS_CATALOG.$file_path.$image_name) ){
            return array();
        }
        $size = getimagesize(DIR_FS_CATALOG.$file_path.$image_name);
        return array(
            'Url'=>HTTP_SERVER.$file_path.$image_name,
            'SecureUrl'=>HTTPS_SERVER.$file_path.$image_name,
            'Width'=>$size[0],
            'Height'=>$size[1],
            'Type'=>$size['mime'],
        );
    }
}
