<?php
/* -----------------------------------------------------------------------------------------
   $Id: ot_total.php,v 1.1 2006/04/25 14:33:41 web2 Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(ot_total.php,v 1.7 2003/02/13); www.oscommerce.com 
   (c) 2003	 nextcommerce (ot_total.php,v 1.11 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/


  class ot_total {
    var $title, $output, $code, $description, $enabled, $sort_order, $Price;

    function __construct($price) {
      $this->code = 'ot_total';
      $this->title = MODULE_ORDER_TOTAL_TOTAL_TITLE;
      $this->description = MODULE_ORDER_TOTAL_TOTAL_DESCRIPTION;
      $this->enabled = ((defined('MODULE_ORDER_TOTAL_TOTAL_STATUS') and MODULE_ORDER_TOTAL_TOTAL_STATUS == 'true') ? true : false);
      $this->sort_order = (defined('MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER')) ? MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER : 0;
      $this->Price=$price;

      $this->output = array();
    }

    function process() {
      global $order, $currencies;
      if ($_SESSION['customers_status']['customers_status_show_price_tax'] != 0) {
        $item = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id((int)$_SESSION['customer_id'], (int) $_SESSION['sendto']);
        $country_id = $item->entry_country_id;
	$zone_id = $item->entry_zone_id;
        $tax_class_id = 1; // egal, geht nur drum ob tax enthalten oder nicht
        $tax = xtc_get_tax_rate($tax_class_id, $country_id,$zone_id);
	if($tax > 0){
		$title = $this->title;
	}else{
		$title = $this->title.' (Netto)';
	}
        $this->output[] = array('title' => $title . ':',
                                'text' => '<b>' . $this->Price->xtcFormat($order->info['total'],true) . '</b>',
                                'value' => $this->Price->xtcFormat($order->info['total'],false));
      }

      if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 1) {
        $this->output[] = array('title' => MODULE_ORDER_TOTAL_TOTAL_TITLE_NO_TAX_BRUTTO . ':',                          
                                'text' => '<b>' . $this->Price->xtcFormat($order->info['tax']+$order->info['total'],true) . '</b>',
                                'value' => $this->Price->xtcFormat($order->info['total']+$order->info['tax'],false));
      }
      if ($_SESSION['customers_status']['customers_status_show_price_tax'] == 0 && $_SESSION['customers_status']['customers_status_add_tax_ot'] == 0) {
        $this->output[] = array('title' => MODULE_ORDER_TOTAL_TOTAL_TITLE_NO_TAX . ':',
                                'text' => '<b>' . $this->Price->xtcFormat($order->info['total'],true) . '</b>',
                                'value' => $this->Price->xtcFormat($order->info['total'], false));
      }
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_TOTAL_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_TOTAL_STATUS', 'MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER');
    }

    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, set_function, date_added) values ('MODULE_ORDER_TOTAL_TOTAL_STATUS', 'true', '6', '1','xtc_cfg_select_option(array(\'true\', \'false\'), ', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,configuration_group_id, sort_order, date_added) values ('MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER', '6','6', '2', now())");
    }

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>