<?php

/* -----------------------------------------------------------------------------------------
   $Id: metatags.php,v 1.33 2018/06/01 07:21:12 cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on:
   (c) 2003	 nextcommerce (metatags.php,v 1.7 2003/08/14); www.nextcommerce.org

   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
$robots = META_ROBOTS;
if(!isset($PHP_SELF)){
	$PHP_SELF = $_SERVER['PHP_SELF'];
}
$language_id = intval($_SESSION['languages_id']??2);
if (isset($_GET['cPath'])) {
        if (strstr($_GET['cPath'], '_')) {
                $arr = explode('_', xtc_input_validation(xtc_db_input($_GET['cPath']), 'cPath', ''));
                $_cPath = $arr[sizeOf($arr)-1];
        } else {
                $_cPath=(int)xtc_db_input($_GET['cPath']);
                if (isset ($_GET['cat'])) {
                        $site = explode('_', xtc_db_input($_GET['cat']));
                        $cID = $site[0];
                        $_cPath = str_replace('c', '', $cID);
                }
        }
        $cd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
            intval($_cPath), $language_id
        );
        $categories_meta = [
            'categories_meta_keywords'=>META_KEYWORDS,
            'categories_meta_description'=>META_DESCRIPTION,
            'categories_meta_title'=>'',
        ];
        if($cd !== null){
            $categories_meta['categories_meta_keywords'] = $cd->categories_meta_keywords;
            $categories_meta['categories_meta_description'] = $cd->categories_meta_description;
            if(!empty($cd->categories_meta_title)){
                $categories_meta['categories_meta_title'] = $cd->categories_meta_title;
            }else{
                $categories_meta['categories_meta_title'] = $cd->categories_name;
            }
            $categories_meta['categories_name'] = $cd->categories_name;
            $categories_meta['categories_description'] = $cd->categories_description;
        }
}elseif (isset($_GET['coID'])) {
    $contents_meta = array();
    $items = \YES4Trade\Model\content_manager::get_by_content_group_and_languages_id(intval($_GET['coID']),intval($_SESSION['languages_id']));
    $item = current($items);
    $contents_meta = $item->toArray();
} elseif(isset($_REQUEST['manufacturers_id'])){
    $mID = (int)xtc_db_input($_REQUEST['manufacturers_id']);
    $manufacturer_data = yes_query(
        "SELECT manufacturers_meta_title,manufacturers_meta_description,manufacturers_meta_keywords FROM manufacturers_info WHERE manufacturers_id=:manufacturers_id AND languages_id=:language_id",
        [
            'manufacturers_id'=>(int)$mID,
            'language_id'=>(int)$_SESSION['languages_id']
        ],
        true
    );
}

if (strstr($PHP_SELF, FILENAME_PRODUCT_INFO)) {
	if ($PRODUCT_INFO_PRODUCT->isProduct()) {
		$crrnt = -1;
		if(strstr($_SERVER['QUERY_STRING'],'products_id=')){
			$parts = explode('_',array_pop(explode('products_id=',$_SERVER['QUERY_STRING'])));
			if(isset($parts[1]))
				$crrnt =$parts[1]; 
		}
		if($crrnt >= 0){
			$count_query = yes_query(
				"SELECT products_id FROM products_to_categories WHERE products_id=:products_id",
				['products_id'=>$PRODUCT_INFO_PRODUCT->pID]
			);
			if(sizeOf($count_query)>1){
			    if($PRODUCT_INFO_PRODUCT->data['default_category'] > 0 and $crrnt != $PRODUCT_INFO_PRODUCT->data['default_category']){
				   $robots = "NOINDEX,NOFOLLOW";
			    }
			}
		}
	}
}
if(defined('MODULE_OTHER_META_OPENGRAPH_STATUS') and MODULE_OTHER_META_OPENGRAPH_STATUS == 'True'){
    require_once(DIR_WS_MODULES.'other/meta_opengraph.php');
    require_once(DIR_WS_CLASSES.'open-graph-protocol-tools-master/objects.php');
    $meta_opengraph = new meta_opengraph;
    if($meta_opengraph->enabled){
        switch($_SESSION['language']){
            case 'german':
                $lang_code = 'de_DE';
                break;
            default:
                $lang_code = 'en_EN';
                break;
        }
        $ogp = new OpenGraphProtocol();
        $ogp->setLocale( $lang_code );
        $ogp->setSiteName( STORE_NAME );
        $ogp->setTitle( MODULE_OTHER_META_OPENGRAPH_TITLE );
        $ogp->setDescription( MODULE_OTHER_META_OPENGRAPH_DESCRIPTION );
        $ogp->setType( MODULE_OTHER_META_OPENGRAPH_TYPE );
        $ogp->setURL( MODULE_OTHER_META_OPENGRAPH_URL );
        if (strstr($PHP_SELF, FILENAME_PRODUCT_INFO)) {
                if ($PRODUCT_INFO_PRODUCT->isProduct()) {
                    $ogp->setType('product');
                    $ogp->setTitle( xtc_db_prepare_input($PRODUCT_INFO_PRODUCT->data['products_name'] ));
                    $ogp->setDescription(xtc_db_prepare_input(strip_tags($PRODUCT_INFO_PRODUCT->data['products_description'])));
                    $ogp->setURL('http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
                    $img_path = 'images/product_images/original_images/';
                    if($PRODUCT_INFO_PRODUCT->data['products_image'] != ''){
                        $ogi = $meta_opengraph->get_og_image($img_path,$PRODUCT_INFO_PRODUCT->data['products_image']);
                        if(sizeOf($ogi)){
                            $image = new OpenGraphProtocolImage();
                            $image->setUrl($ogi['Url']);
                            $image->setSecureURL($ogi['SecureUrl']);
                            $image->setWidth($ogi['Width']);
                            $image->setHeight($ogi['Height']);
                            $image->setType($ogi['Type']);
                            $ogp->addImage($image);
                        }
                        foreach($PRODUCT_INFO_PRODUCT->getMoImages() as $mo){
                            $img_name = array_pop(explode('/',$mo['image']));
                            $ogi = $meta_opengraph->get_og_image(str_replace($img_name,'',$mo['image']),$img_name);
                            if(sizeOf($ogi)){
                                $image = new OpenGraphProtocolImage();
                                $image->setUrl($ogi['Url']);
                                $image->setSecureURL($ogi['SecureUrl']);
                                $image->setWidth($ogi['Width']);
                                $image->setHeight($ogi['Height']);
                                $image->setType($ogi['Type']);
                                $ogp->addImage($image);
                            }
                        }
                    }
                }
        }else{
            if(isset($categories_meta) and isset($categories_meta['categories_name'])){
                $ogp->setTitle( xtc_db_prepare_input( $categories_meta['categories_name'] ));
                $ogp->setDescription(xtc_db_prepare_input($categories_meta['categories_description']));
                $ogp->setURL('http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
                $cat_image = yes_query(sprintf(
                    "SELECT categories_image FROM %s WHERE categories_id=:cat_id",
                        TABLE_CATEGORIES
                    ),['cat_id'=>(int)$_cPath],
                    true
                );
                if(!empty($cat_image['categories_image'])){
                    $ogi = $meta_opengraph->get_og_image('images/categories/',$cat_image['categories_image']);
                    if(sizeOf($ogi)){
                        $image = new OpenGraphProtocolImage();
                        $image->setUrl($ogi['Url']);
                        $image->setSecureURL($ogi['SecureUrl']);
                        $image->setWidth($ogi['Width']);
                        $image->setHeight($ogi['Height']);
                        $image->setType($ogi['Type']);
                        $ogp->addImage($image);
                    }
                }
            }else if(isset($_REQUEST['coID'])){
                if(isset($contents_meta['content_heading']) and $contents_meta['content_heading'] != ''){
                    $ogp->setTitle( xtc_db_prepare_input( $contents_meta['content_heading'] ));
                }
            }else if(isset($_REQUEST['manufacturers_id'])){
                if(isset($manufacturer_data['manufacturers_meta_title'])){
                    $ogp->setTitle( xtc_db_prepare_input( $manufacturer_data['manufacturers_meta_title'] ));
                }
                if(isset($manufacturer_data['manufacturers_meta_description'])){
                    $ogp->setDescription(xtc_db_prepare_input($manufacturer_data['manufacturers_meta_description'] ));
                }
                
            }else{
                if(MODULE_OTHER_META_OPENGRAPH_IMAGE != ''){
                    $image = new OpenGraphProtocolImage();
                    $image->setUrl(str_replace('https:/','http:/',MODULE_OTHER_META_OPENGRAPH_IMAGE));
                    $image->setSecureURL( str_replace('http:/','https:/',MODULE_OTHER_META_OPENGRAPH_IMAGE) );
                    $image->setWidth(MODULE_OTHER_META_OPENGRAPH_IMAGE_WIDTH);
                    $image->setHeight(MODULE_OTHER_META_OPENGRAPH_IMAGE_HEIGHT);
                    $image->setType(MODULE_OTHER_META_OPENGRAPH_IMAGE_TYPE);
                    $ogp->addImage($image);
                }
            }
        }
            
        echo $ogp->toHTML();
    }
}

?>
<meta name="robots" content="<?php echo $robots; ?>">
<meta name="language" content="<?php echo META_LANGUAGE_CODE; ?>">
<meta name="author" content="<?php echo META_AUTHOR; ?>">
<meta name="publisher" content="<?php echo META_PUBLISHER; ?>">
<meta name="company" content="<?php echo META_COMPANY; ?>">
<meta name="page-topic" content="<?php echo META_TOPIC; ?>">
<meta name="reply-to" content="<?php echo META_REPLY_TO; ?>">
<meta name="distribution" content="global" />
<meta name="revisit-after" content="<?php echo META_REVISIT_AFTER; ?>">
<?php
if (strstr($PHP_SELF, FILENAME_PRODUCT_INFO)) {
	if ($PRODUCT_INFO_PRODUCT->isProduct()) {
	    
?>
<meta name="description" content="<?php echo $PRODUCT_INFO_PRODUCT->data['products_meta_description']; ?>">
<meta name="keywords" content="<?php echo $PRODUCT_INFO_PRODUCT->data['products_meta_keywords']; ?>">
<title>
<?php if(defined('SUMA_USE_PRODUCTS_NAME_AND_PRODUCTS_META_TITLE_FOR_META') and in_array(SUMA_USE_PRODUCTS_NAME_AND_PRODUCTS_META_TITLE_FOR_META,array('True','All','Meta')) ){ ?>
	<?php echo $PRODUCT_INFO_PRODUCT->data['products_meta_title']; ?>
<?php } ?>
<?php if(defined('SUMA_USE_PRODUCTS_NAME_AND_PRODUCTS_META_TITLE_FOR_META') and in_array(SUMA_USE_PRODUCTS_NAME_AND_PRODUCTS_META_TITLE_FOR_META,array('True','All','Title')) ){ ?>
	<?php echo $PRODUCT_INFO_PRODUCT->data['products_name']; ?>
<?php } ?>	
<?php if(defined('SUMA_USE_SHOP_NAME_IN_PRODUCTS_DETAILS_PAGE') and SUMA_USE_SHOP_NAME_IN_PRODUCTS_DETAILS_PAGE == 'True'){ ?>
	<?php echo TITLE; ?>
<?php } ?>
</title>
<?php

	} else {
?>
<meta name="description" content="<?php echo META_DESCRIPTION; ?>">
<meta name="keywords" content="<?php echo META_KEYWORDS; ?>">
<title><?php echo TITLE; ?></title>
	<?php

	}

} elseif(strstr($PHP_SELF, FILENAME_SPECIALS) ) {?>
<title><?php echo TITLE.' / '.META_TITLE_SPECIALS; ?></title>
<?php    
} elseif(strstr($PHP_SELF, FILENAME_PRODUCTS_NEW) ) {?>
<title><?php echo TITLE.' / '.META_TITLE_PRODUCTS_NEW; ?></title>
<?php    
} else {
	if (isset($_GET['cPath'])) {
?>
<meta name="description" content="<?php echo $categories_meta['categories_meta_description']; ?>" />
<meta name="keywords" content="<?php echo $categories_meta['categories_meta_keywords']; ?>" />
<title><?php 
	echo $categories_meta['categories_meta_title'];
	if(defined('SUMA_USE_SHOP_NAME_IN_CATEGORIES') and SUMA_USE_SHOP_NAME_IN_CATEGORIES == 'True'){
		echo ' - '.TITLE;
	}
?></title>
<?php

	} else {
		if (isset($_GET['coID'])) {
?>
<meta name="description" content="<?php echo META_DESCRIPTION; ?>">
<meta name="keywords" content="<?php echo META_KEYWORDS; ?>">
<title><?php echo $contents_meta['content_heading'].' - '.TITLE; ?></title>
<?php

		} elseif(isset($_REQUEST['manufacturers_id'])){
                    if(!empty($manufacturer_data['manufacturers_meta_description'])){
                        printf("<meta name=\"description\" content=\"%s\">\r\n",xtc_db_prepare_input($manufacturer_data['manufacturers_meta_description']));
                    }
                    if(!empty($manufacturer_data['manufacturers_meta_title'])){
                        printf("<meta name=\"title\" content=\"%s\">\r\n",xtc_db_prepare_input($manufacturer_data['manufacturers_meta_title']));
                    }
                    if(!empty($manufacturer_data['manufacturers_meta_keywords'])){
                        printf("<meta name=\"keywords\" content=\"%s\">\r\n",xtc_db_prepare_input($manufacturer_data['manufacturers_meta_keywords']));
                    }
                    $title_tag_content = (!empty($manufacturer_data['manufacturers_meta_title'])) ? xtc_db_prepare_input($manufacturer_data['manufacturers_meta_title']) : TITLE;
                    printf('<title>%s</title>',$title_tag_content);
		} else {
?>
<meta name="description" content="<?php echo META_DESCRIPTION; ?>">
<meta name="keywords" content="<?php echo META_KEYWORDS; ?>">
<title><?php echo TITLE; ?></title>
<?php

		}
	}
}
if(defined('HEADER_SNIPPETS') and trim(HEADER_SNIPPETS) != ''){
    echo HEADER_SNIPPETS;
}

