<?php
require('yescrawler_products.php');
class yescrawler
{
    var $table_search_word,$table_search_index,$table_search_time,$type,$type_instance,$parseTimeMS,$query_raw;
    function __construct(){
		throw new Exception('not in use');
	$this->table_search_word = 'search_word';
	$this->table_search_index = 'search_index';
	$this->table_search_time = 'search_time';
    }
    
    private static function sanitizeString($input, $link = 'db_link') {
        global $$link;
        return $$link->quote($input);
    }


    public function update_indizes($st_type){
	$this->locData = array();
	$type_instance_str = 'yescrawler_'.$st_type;
	$this->type_instance = new $type_instance_str;
	$this->type = $st_type;
	
	$t = $this->type_instance;
	$query_raw = sprintf(
	    "SELECT %s AS st_doc_id, st_id, '%s' AS st_type, 
	    %s AS search_data 
	    FROM %s LEFT JOIN %s st
	    ON st_doc_id = %s 
	    AND FIND_IN_SET('%s', st_type) 
	    WHERE %s  
	    AND (st_id IS NULL OR %s > st_date) 
	    ORDER BY st_date LIMIT 0,100000",
	    $t->sql_doc_id,
	    $this->type,
	    $t->sql_search_data,
	    $t->sql_from,
	    $this->table_search_time,
	    $t->sql_doc_id,
	    $this->type,
	    $t->sql_where,
	    $t->sql_last_modified
	);
	$query = xtc_db_query($query_raw);
	$num = xtc_db_num_rows($query);
	$errors = array();
	while($record = xtc_db_fetch_array($query)){
		$error = $this->process_document($record);
		if($error != ''){
			$errors[] = $error;
		}
	}
	return array(
		'NUM'=>$num,
		'ERRORS'=>$errors
	);
    }
    
    public function search($type,$searchphrase,$page=0,$limit = false){
	$search = $this->prepare_string($searchphrase);
	$search = $this->remove_stopwords($search);
	$search = $search;
	$search_words = explode(' ',$search);
	if(!sizeOf($search_words)){
		die('No valid Search String');
	}
	$type_instance_str = 'yescrawler_'.$type;
	$this->type_instance = new $type_instance_str;
	$this->type = $type;
	
	$t = $this->type_instance;
	$search_select_parts = array();
	$search_from_parts = array();
	$search_where_parts = array();
	foreach($search_words as $nr=>$word){
		$search_select_parts[$nr] = sprintf(' index_%s.si_count ',$nr);
		$search_from_parts[$nr] = sprintf(' search_index AS index_%s, search_word AS word_%s ',$nr,$nr);
		$search_where_parts[$nr] = sprintf("AND index_%s.si_type='%s' AND word_%s.sw_id = index_%s.si_sw_id AND word_%s.sw_word LIKE '%s%%'",
			$nr,$this->type,$nr,$nr,$nr,$word
		);
		if($nr+1 < sizeOf($search_words))
			$search_where_parts[$nr] .= sprintf(" AND index_%s.si_doc_id  = index_%s.si_doc_id ",$nr,($nr+1));
	}

	$search_where = sprintf('(%s)',implode('or',$search_where_parts));
	$limit_str = '';
	if($limit > 0){
	    $limit_str = sprintf(' LIMIT %s, %s',$page*$limit,$limit);
	}
	$query_raw = sprintf(
	    "
	SELECT 
		index_0.si_doc_id AS si_doc_id, 
		index_0.si_type AS si_type, 
		%s AS matched_words
	FROM 
		%s
	WHERE 1
		%s
		GROUP BY si_doc_id 
		ORDER BY si_type, matched_words DESC 
	%s",
		implode('+',$search_select_parts),
		implode(',',$search_from_parts),
		implode('',$search_where_parts),
		$limit_str
	);
	$this->query_raw = $query_raw;
	$query = xtc_db_query($query_raw);
	$matches = array();
	while($record = xtc_db_fetch_array($query)){
		$matches[] = array(
			'id'=>$record['si_doc_id']/*,
			'searched_content'=>$this->type_instance->get_item_value($record['si_doc_id']),
			'matched_words'=>$record['matched_words']*/
		);
	}
	return $matches;
    }
    
    private function process_document($values){
	$values['search_data'] = $this->prepare_string($values['search_data']);
	if(empty($values['search_data'])) return false;
	$values['search_data'] = $this->remove_stopwords($values['search_data']);
	$words = explode(' ',$values['search_data']);
	if($values['st_id'] > 0){
	    // VORHANDENEN INDEX LOESCHEN - WIRD NEU GESCHRIEBEN
	    $this->db_delete_search_index($values['st_doc_id']);
	}
	$locData = $this->collect_indizes($words,$values['st_doc_id']);
	// INDEXES FUER WOERTER DIESES DOCUMENTS SPEICHERN
	if(sizeOf($locData)){
		$this->db_insert_search_index($locData);
	}else{
		return sprintf("\t%s ID %s hat keine Daten zum Indexieren",$this->type,$values['st_doc_id']);
	}
	$this->db_update_time($values['st_doc_id']);
    }
    
    
    private function collect_indizes($inWords,$docId){
	$locData = array();
	// in $inWords sind alle W�rter des Datensatzes vorhanden
	// in $inStType ist der aktuelle Wert der Spalte 'st_type' enthalten
	// in $inStDocId ist der aktuelle Wert der Sppalte 'st_doc_id' enthalten
	foreach ($inWords as $locKey => $locVal){
	    if (strlen($locVal) > 32){
		$locVal = substr($locVal, 0, 32);
	    }
	    $locSwId = $this->process_word($locVal);  // holt Schl�ssel bzw. speichert Wort neu in Datenbank
	    if($locSwId < 0){
		continue;
	    }
	    if (isset($locData[$locSwId])){
		$locData[$locSwId]["si_count"] = $locData[$locSwId]["si_count"] + 1;
	    }else{
		$locData[$locSwId]["si_sw_id" ] = $locSwId;
		$locData[$locSwId]["si_type"  ] = $this->type;
		$locData[$locSwId]["si_doc_id"] = $docId;
		$locData[$locSwId]["si_count" ] = 1;
	    }
	}
	return $locData;
    }
    
    private function process_word($value){
	if(empty($value) or $value === null) return -1;
	$query = xtc_db_query(sprintf(
		"SELECT sw_id FROM %s WHERE sw_word = '%s'",
		$this->table_search_word,  addslashes($value)
	));
	if(!xtc_db_num_rows($query)){
	    $insert_sql_array = array(
		'sw_word'=>$value
	    );
	    xtc_db_perform($this->table_search_word,$insert_sql_array);
	    return xtc_db_insert_id();
	}else{
	    $record = xtc_db_fetch_array($query);
	    return $record['sw_id'];
	}
    }
    
    private function db_delete_search_index($id){
	xtc_db_query(sprintf("DELETE FROM search_index WHERE si_type = '%s' AND si_doc_id = '%s'",
	    $this->type,$id
	));
    }
    
    private function db_insert_search_index($data){
	$query_raw = "INSERT INTO search_index ( si_sw_id, si_type, si_doc_id, si_count ) VALUES \r\n";
	$inserts = array();
	foreach($data as $d){
	    $inserts[] = sprintf("\r\n(%s,'%s',%s,%s)",
		   $d['si_sw_id'],$d['si_type'],$d['si_doc_id'],$d['si_count']
	    );
	}
	$query_raw .= implode(',',$inserts);
	xtc_db_query($query_raw);
    }
    
    private function db_update_time($docId){
	$query = xtc_db_query(sprintf(
		"SELECT st_id FROM %s WHERE st_type='%s' AND st_doc_id='%s'",
		$this->table_search_time,$this->type,$docId
	));
	if(xtc_db_num_rows($query)){
	    $record = xtc_db_fetch_array($query);
	    $update_sql_array = array(
		'st_date'=>'now()'
	    );
	    xtc_db_perform($this->table_search_time,$update_sql_array,'update',"st_id='".$record['st_id']."'");
	}else{
	    $insert_sql_array = array(
		'st_type'=>$this->type,
		'st_doc_id'=>$docId,
		'st_date'=>'now()'
	    );
	    xtc_db_perform($this->table_search_time,$insert_sql_array);
	}
    }
    
    public function db_truncate(){
	xtc_db_query("TRUNCATE TABLE search_index");
	xtc_db_query("TRUNCATE TABLE search_time");
	xtc_db_query("TRUNCATE TABLE search_word");
    }
    
    private function prepare_string($inString){
	$matches = array(
	    "'",'"','.','?','/','!',','
	);
	$inString = str_replace($matches,' ',$inString);
	$umlaute = Array("/�/","/�/","/�/","/�/","/�/","/�/","/�/");
	$replace = Array("ae","oe","ue","ae","oe","ue","ss");
	$outString = trim(strtolower(stripslashes(strip_tags($inString))));
	if($outString == '') return '';
	$umlaute[] = "=([/.,+-]*\s)=";
	$umlaute[] = "=([^A-Za-z])=";
	$umlaute[] = "= +=";	
	$replace[] = ' ';
	$replace[] = ' ';
	$replace[] = ' ';
	$outString = preg_replace($umlaute, $replace, $outString );
	$outString = trim($outString);
	if($outString == '') return '';
	return self::sanitizeString($outString);
    }
    
    private function remove_stopwords($inString){
	// in $inStopwords ist ein numerisch indiziertes Array mit allen Stoppworten

	$locSearch[] = "=(\s[A-Za-z]{1,2})\s=";
	$locSearch[] = "= " . implode(" | ", $this->get_stopwords()) . " =i";
	$locSearch[] = "= +=";

	$locReplace[] = " ";
	$locReplace[] = " ";
	$locReplace[] = " ";

	$outString = " " . str_replace(" ", "  ", $inString) . " ";
	$outString = trim(preg_replace($locSearch, $locReplace, $outString));
	return $outString;
    }
    
    public function install(){
	$query_raw = "CREATE TABLE `search_word` (
  `sw_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sw_word` varchar(32) COLLATE latin1_german2_ci DEFAULT NULL,
  PRIMARY KEY (`sw_id`),
  UNIQUE KEY `un_sw_word` (`sw_word`)
) ENGINE=MyISAM";
	xtc_db_query($query_raw);

	$query_raw = "CREATE TABLE `search_index` (
  `si_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `si_sw_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `si_type` enum('products','emails','payments') NOT NULL DEFAULT 'products',
  `si_doc_id` mediumint(8) NOT NULL DEFAULT '0',
  `si_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`si_id`),
  UNIQUE KEY `un_si_sw_id` (`si_sw_id`,`si_doc_id`),
  KEY `fk_si_sw_id` (`si_sw_id`)
) ENGINE=MyISAM;";
	xtc_db_query($query_raw);

	$query_raw = "CREATE TABLE `search_time` (
  `st_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `st_type` enum('products','emails','payments') NOT NULL DEFAULT 'products',
  `st_doc_id` mediumint(8) NOT NULL,
  `st_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`st_id`),
  UNIQUE KEY `un_st_type` (`st_type`,`st_doc_id`),
  KEY `st_date` (`st_date`),
  KEY `st_doc_id` (`st_doc_id`,`st_type`)
) ENGINE=MyISAM";
	xtc_db_query($query_raw);
	
    }
    
    
    function get_stopwords($lang = 'de'){
	$stopwords["de"][] = "aber";
	$stopwords["de"][] = "alle";
	$stopwords["de"][] = "allen";
	$stopwords["de"][] = "alles";
	$stopwords["de"][] = "als";
	$stopwords["de"][] = "also";
	$stopwords["de"][] = "andere";
	$stopwords["de"][] = "anderem";
	$stopwords["de"][] = "anderer";
	$stopwords["de"][] = "anderes";
	$stopwords["de"][] = "anders";
	$stopwords["de"][] = "auch";
	$stopwords["de"][] = "auf";
	$stopwords["de"][] = "aus";
	$stopwords["de"][] = "ausser";
	$stopwords["de"][] = "ausserdem";
	$stopwords["de"][] = "bei";
	$stopwords["de"][] = "beide";
	$stopwords["de"][] = "beiden";
	$stopwords["de"][] = "beides";
	$stopwords["de"][] = "beim";
	$stopwords["de"][] = "bereits";
	$stopwords["de"][] = "bestehen";
	$stopwords["de"][] = "besteht";
	$stopwords["de"][] = "bevor";
	$stopwords["de"][] = "bin";
	$stopwords["de"][] = "bis";
	$stopwords["de"][] = "bloss";
	$stopwords["de"][] = "brauchen";
	$stopwords["de"][] = "braucht";
	$stopwords["de"][] = "dabei";
	$stopwords["de"][] = "dadurch";
	$stopwords["de"][] = "dagegen";
	$stopwords["de"][] = "daher";
	$stopwords["de"][] = "damit";
	$stopwords["de"][] = "danach";
	$stopwords["de"][] = "dann";
	$stopwords["de"][] = "darf";
	$stopwords["de"][] = "darueber";
	$stopwords["de"][] = "darum";
	$stopwords["de"][] = "darunter";
	$stopwords["de"][] = "das";
	$stopwords["de"][] = "dass";
	$stopwords["de"][] = "davon";
	$stopwords["de"][] = "dazu";
	$stopwords["de"][] = "dem";
	$stopwords["de"][] = "den";
	$stopwords["de"][] = "denn";
	$stopwords["de"][] = "der";
	$stopwords["de"][] = "des";
	$stopwords["de"][] = "deshalb";
	$stopwords["de"][] = "dessen";
	$stopwords["de"][] = "die";
	$stopwords["de"][] = "dies";
	$stopwords["de"][] = "diese";
	$stopwords["de"][] = "diesem";
	$stopwords["de"][] = "diesen";
	$stopwords["de"][] = "dieser";
	$stopwords["de"][] = "dieses";
	$stopwords["de"][] = "doch";
	$stopwords["de"][] = "dort";
	$stopwords["de"][] = "duerfen";
	$stopwords["de"][] = "durch";
	$stopwords["de"][] = "durfte";
	$stopwords["de"][] = "durften";
	$stopwords["de"][] = "ebenfalls";
	$stopwords["de"][] = "ebenso";
	$stopwords["de"][] = "ein";
	$stopwords["de"][] = "eine";
	$stopwords["de"][] = "einem";
	$stopwords["de"][] = "einen";
	$stopwords["de"][] = "einer";
	$stopwords["de"][] = "eines";
	$stopwords["de"][] = "einige";
	$stopwords["de"][] = "einiges";
	$stopwords["de"][] = "einzig";
	$stopwords["de"][] = "entweder";
	$stopwords["de"][] = "erst";
	$stopwords["de"][] = "erste";
	$stopwords["de"][] = "ersten";
	$stopwords["de"][] = "etwa";
	$stopwords["de"][] = "etwas";
	$stopwords["de"][] = "falls";
	$stopwords["de"][] = "fast";
	$stopwords["de"][] = "ferner";
	$stopwords["de"][] = "folgender";
	$stopwords["de"][] = "folglich";
	$stopwords["de"][] = "fuer";
	$stopwords["de"][] = "ganz";
	$stopwords["de"][] = "geben";
	$stopwords["de"][] = "gegen";
	$stopwords["de"][] = "gehabt";
	$stopwords["de"][] = "gekonnt";
	$stopwords["de"][] = "gemaess";
	$stopwords["de"][] = "getan";
	$stopwords["de"][] = "gewesen";
	$stopwords["de"][] = "gewollt";
	$stopwords["de"][] = "geworden";
	$stopwords["de"][] = "gibt";
	$stopwords["de"][] = "habe";
	$stopwords["de"][] = "haben";
	$stopwords["de"][] = "haette";
	$stopwords["de"][] = "haetten";
	$stopwords["de"][] = "hallo";
	$stopwords["de"][] = "hat";
	$stopwords["de"][] = "hatte";
	$stopwords["de"][] = "hatten";
	$stopwords["de"][] = "heraus";
	$stopwords["de"][] = "herein";
	$stopwords["de"][] = "hier";
	$stopwords["de"][] = "hin";
	$stopwords["de"][] = "hinein";
	$stopwords["de"][] = "hinter";
	$stopwords["de"][] = "ich";
	$stopwords["de"][] = "ihm";
	$stopwords["de"][] = "ihn";
	$stopwords["de"][] = "ihnen";
	$stopwords["de"][] = "ihr";
	$stopwords["de"][] = "ihre";
	$stopwords["de"][] = "ihrem";
	$stopwords["de"][] = "ihren";
	$stopwords["de"][] = "ihres";
	$stopwords["de"][] = "immer";
	$stopwords["de"][] = "indem";
	$stopwords["de"][] = "infolge";
	$stopwords["de"][] = "innen";
	$stopwords["de"][] = "innerhalb";
	$stopwords["de"][] = "ins";
	$stopwords["de"][] = "inzwischen";
	$stopwords["de"][] = "irgend";
	$stopwords["de"][] = "irgendwas";
	$stopwords["de"][] = "irgendwen";
	$stopwords["de"][] = "irgendwer";
	$stopwords["de"][] = "irgendwie";
	$stopwords["de"][] = "irgendwo";
	$stopwords["de"][] = "ist";
	$stopwords["de"][] = "jede";
	$stopwords["de"][] = "jedem";
	$stopwords["de"][] = "jeden";
	$stopwords["de"][] = "jeder";
	$stopwords["de"][] = "jedes";
	$stopwords["de"][] = "jedoch";
	$stopwords["de"][] = "jene";
	$stopwords["de"][] = "jenem";
	$stopwords["de"][] = "jenen";
	$stopwords["de"][] = "jener";
	$stopwords["de"][] = "jenes";
	$stopwords["de"][] = "kann";
	$stopwords["de"][] = "kein";
	$stopwords["de"][] = "keine";
	$stopwords["de"][] = "keinem";
	$stopwords["de"][] = "keinen";
	$stopwords["de"][] = "keiner";
	$stopwords["de"][] = "keines";
	$stopwords["de"][] = "koennen";
	$stopwords["de"][] = "koennte";
	$stopwords["de"][] = "koennten";
	$stopwords["de"][] = "konnte";
	$stopwords["de"][] = "konnten";
	$stopwords["de"][] = "kuenftig";
	$stopwords["de"][] = "leer";
	$stopwords["de"][] = "machen";
	$stopwords["de"][] = "macht";
	$stopwords["de"][] = "machte";
	$stopwords["de"][] = "machten";
	$stopwords["de"][] = "man";
	$stopwords["de"][] = "mehr";
	$stopwords["de"][] = "mein";
	$stopwords["de"][] = "meine";
	$stopwords["de"][] = "meinen";
	$stopwords["de"][] = "meinem";
	$stopwords["de"][] = "meiner";
	$stopwords["de"][] = "meist";
	$stopwords["de"][] = "meiste";
	$stopwords["de"][] = "meisten";
	$stopwords["de"][] = "mich";
	$stopwords["de"][] = "mit";
	$stopwords["de"][] = "moechte";
	$stopwords["de"][] = "moechten";
	$stopwords["de"][] = "muessen";
	$stopwords["de"][] = "muessten";
	$stopwords["de"][] = "muss";
	$stopwords["de"][] = "musste";
	$stopwords["de"][] = "mussten";
	$stopwords["de"][] = "nach";
	$stopwords["de"][] = "nachdem";
	$stopwords["de"][] = "nacher";
	$stopwords["de"][] = "naemlich";
	$stopwords["de"][] = "neben";
	$stopwords["de"][] = "nein";
	$stopwords["de"][] = "nicht";
	$stopwords["de"][] = "nichts";
	$stopwords["de"][] = "noch";
	$stopwords["de"][] = "nuetzt";
	$stopwords["de"][] = "nur";
	$stopwords["de"][] = "nutzt";
	$stopwords["de"][] = "obgleich";
	$stopwords["de"][] = "obwohl";
	$stopwords["de"][] = "oder";
	$stopwords["de"][] = "ohne";
	$stopwords["de"][] = "per";
	$stopwords["de"][] = "pro";
	$stopwords["de"][] = "rund";
	$stopwords["de"][] = "schon";
	$stopwords["de"][] = "sehr";
	$stopwords["de"][] = "seid";
	$stopwords["de"][] = "sein";
	$stopwords["de"][] = "seine";
	$stopwords["de"][] = "seinem";
	$stopwords["de"][] = "seinen";
	$stopwords["de"][] = "seiner";
	$stopwords["de"][] = "seit";
	$stopwords["de"][] = "seitdem";
	$stopwords["de"][] = "seither";
	$stopwords["de"][] = "selber";
	$stopwords["de"][] = "sich";
	$stopwords["de"][] = "sie";
	$stopwords["de"][] = "siehe";
	$stopwords["de"][] = "sind";
	$stopwords["de"][] = "sobald";
	$stopwords["de"][] = "solange";
	$stopwords["de"][] = "solch";
	$stopwords["de"][] = "solche";
	$stopwords["de"][] = "solchem";
	$stopwords["de"][] = "solchen";
	$stopwords["de"][] = "solcher";
	$stopwords["de"][] = "solches";
	$stopwords["de"][] = "soll";
	$stopwords["de"][] = "sollen";
	$stopwords["de"][] = "sollte";
	$stopwords["de"][] = "sollten";
	$stopwords["de"][] = "somit";
	$stopwords["de"][] = "sondern";
	$stopwords["de"][] = "soweit";
	$stopwords["de"][] = "sowie";
	$stopwords["de"][] = "spaeter";
	$stopwords["de"][] = "stets";
	$stopwords["de"][] = "such";
	$stopwords["de"][] = "ueber";
	$stopwords["de"][] = "ums";
	$stopwords["de"][] = "und";
	$stopwords["de"][] = "uns";
	$stopwords["de"][] = "unser";
	$stopwords["de"][] = "unsere";
	$stopwords["de"][] = "unserem";
	$stopwords["de"][] = "unseren";
	$stopwords["de"][] = "viel";
	$stopwords["de"][] = "viele";
	$stopwords["de"][] = "vollstaendig";
	$stopwords["de"][] = "vom";
	$stopwords["de"][] = "von";
	$stopwords["de"][] = "vor";
	$stopwords["de"][] = "vorbei";
	$stopwords["de"][] = "vorher";
	$stopwords["de"][] = "vorueber";
	$stopwords["de"][] = "waehrend";
	$stopwords["de"][] = "waere";
	$stopwords["de"][] = "waeren";
	$stopwords["de"][] = "wann";
	$stopwords["de"][] = "war";
	$stopwords["de"][] = "waren";
	$stopwords["de"][] = "warum";
	$stopwords["de"][] = "was";
	$stopwords["de"][] = "wegen";
	$stopwords["de"][] = "weil";
	$stopwords["de"][] = "weiter";
	$stopwords["de"][] = "weitere";
	$stopwords["de"][] = "weiterem";
	$stopwords["de"][] = "weiteren";
	$stopwords["de"][] = "weiterer";
	$stopwords["de"][] = "weiteres";
	$stopwords["de"][] = "weiterhin";
	$stopwords["de"][] = "welche";
	$stopwords["de"][] = "welchem";
	$stopwords["de"][] = "welchen";
	$stopwords["de"][] = "welcher";
	$stopwords["de"][] = "welches";
	$stopwords["de"][] = "wem";
	$stopwords["de"][] = "wen";
	$stopwords["de"][] = "wenigstens";
	$stopwords["de"][] = "wenn";
	$stopwords["de"][] = "wenngleich";
	$stopwords["de"][] = "wer";
	$stopwords["de"][] = "werde";
	$stopwords["de"][] = "werden";
	$stopwords["de"][] = "weshalb";
	$stopwords["de"][] = "wessen";
	$stopwords["de"][] = "wie";
	$stopwords["de"][] = "wieder";
	$stopwords["de"][] = "will";
	$stopwords["de"][] = "wir";
	$stopwords["de"][] = "wird";
	$stopwords["de"][] = "wodurch";
	$stopwords["de"][] = "wohin";
	$stopwords["de"][] = "wollen";
	$stopwords["de"][] = "wollte";
	$stopwords["de"][] = "wollten";
	$stopwords["de"][] = "worin";
	$stopwords["de"][] = "wuerde";
	$stopwords["de"][] = "wuerden";
	$stopwords["de"][] = "wurde";
	$stopwords["de"][] = "wurden";
	$stopwords["de"][] = "zufolge";
	$stopwords["de"][] = "zum";
	$stopwords["de"][] = "zusammen";
	$stopwords["de"][] = "zur";
	$stopwords["de"][] = "zwar";
	$stopwords["de"][] = "zwischen";
	return $stopwords[$lang];
    }

}

