<?php
/**
 * SmartDevicesApiTest
 * PHP version 5
 *
 * @category Class
 * @package  Secuconnect\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Secuconnect API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 2.0.0
 *
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Please update the test case below to test the endpoint.
 */

namespace Secuconnect\Client\Api;

use PHPUnit\Framework\TestCase;
use Secuconnect\Client\ApiException;
use Secuconnect\Client\Model\SmartDevicesDTO;
use Secuconnect\Client\Model\SmartDevicesList;
use Secuconnect\Client\Model\SmartDevicesProductModel;

/**
 * SmartDevicesApiTest Class Doc Comment
 *
 * @category Class
 * @package  Secuconnect\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class SmartDevicesApiTest extends TestCase
{
    /**
     * @var SmartDevicesApi
     */
    private static $api;

    /**
     * @var SecuconnectObjects
     */
    private static $instance;

    /**
     * @var SmartDevicesList
     */
    private static $smartDevicesList;

    /**
     * @var SmartDevicesDTO
     */
    private static $smartDevicesDTO;

    /**
     * @var SmartDevicesProductModel
     */
    private static $smartDevicesProductModel;

    /**
     * Setup before running any test cases
     * @throws ApiException
     */
    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();
        self::$instance = SecuconnectObjects::getInstance();
        self::$instance->authenticateByApplicationUser();
        self::$api = new SmartDevicesApi();
    }

    /**
     * Test case for getAll
     *
     * GET Smart/Devices.
     *
     * @throws ApiException
     */
    public function testGetAll()
    {
        try {
            self::$smartDevicesList = self::$api->getAll(
                null,
                null,
                null,
                ['online' => true],
                null
            );
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }

        $this->assertNotEmpty(self::$smartDevicesList);
        $this->assertInstanceOf(SmartDevicesList::class, self::$smartDevicesList);
        $this->assertIsInt(self::$smartDevicesList->getCount());

        foreach (self::$smartDevicesList->getData() as $smartDevice) {
            $this->assertInstanceOf(SmartDevicesProductModel::class, $smartDevice);
            $this->assertEquals('smart.devices', $smartDevice->getObject());
            $this->assertNotEmpty($smartDevice->getId());
            $this->assertNotEmpty($smartDevice->getMerchant());
            $this->assertNotEmpty($smartDevice->getMerchant()->getId());
            $this->assertNotEmpty($smartDevice->getStore());
            $this->assertNotEmpty($smartDevice->getStore()->getId());
            $this->assertNotEmpty($smartDevice->getVendor());
            $this->assertNotEmpty($smartDevice->getVendorUid());
            $this->assertNotEmpty($smartDevice->getType());
            $this->assertNotEmpty($smartDevice->getCreated());
        }
    }

    /**
     * Test case for getOne
     *
     * GET Smart/Devices/{id}.
     *
     * @depends testGetAll
     *
     * @throws ApiException
     */
    public function testGetOne()
    {
        try {
            $response = self::$api->getOne(self::$smartDevicesList->getData()[0]->getId());
        } catch (ApiException $e) {
            print_r($e->getResponseBody());
            throw $e;
        }

        $this->assertNotEmpty($response);
        $this->assertInstanceOf(SmartDevicesProductModel::class, $response);

        $this->assertEquals('smart.devices', $response->getObject());
        $this->assertNotEmpty($response->getId());
        $this->assertNotEmpty($response->getMerchant());
        $this->assertNotEmpty($response->getMerchant()->getId());
        $this->assertNotEmpty($response->getStore());
        $this->assertNotEmpty($response->getStore()->getId());
        $this->assertNotEmpty($response->getVendor());
        $this->assertNotEmpty($response->getVendorUid());
        $this->assertNotEmpty($response->getType());
        $this->assertNotEmpty($response->getCreated());
    }
}
