<?php
/**
 * Individuelle Artikeleigenschaften
 *
 * @author mario
 */
require_once(DIR_FS_CATALOG.'includes/classes/product_properties_description.php');
require_once(DIR_FS_INC.'yes_get_products_properties_id_array.inc.php');
class product_properties {
	var $products_id;
	var $products_properties_id;
	var $date_added;
	var $sort_order;
    var $tag;
	
	function __construct( $products_properties_id ) {
		$this->setProducts_properties_id((int)$products_properties_id);
		$record = yes_query(
                    "SELECT products_id,sort_order,date_added,tag FROM products_properties WHERE products_properties_id=:product_properties_id",
                    ['product_properties_id'=>$this->getProducts_properties_id()],
                    true
		);
                if(is_countable($record) and sizeOf($record)){
                    $this->setDate_added($record['date_added']);
                    $this->setSort_order($record['sort_order']);
                    $this->setProducts_id($record['products_id']);
                    $this->setTag($record['tag']);
                }else{
                    return false;
                }
	}
	
	public function getDescription($language_id){
		$record = yes_query(
			"SELECT products_properties_description_id FROM products_properties_description WHERE products_properties_id=:pp_id AND language_id=:language_id",
			[
                            'pp_id'=>$this->getProducts_properties_id(),
                            'language_id'=>(int)$language_id
                        ],true
		);
		return new product_properties_description((int)$record['products_properties_description_id']);
	}
	
	public function getValues(){
		$values = array();
		$query = yes_query(
			"SELECT products_properties_values_id FROM products_properties_values WHERE products_properties_id=:pp_id ORDER BY sort_order",
			[
				'pp_id'=>$this->getProducts_properties_id(),
            ]
		);
		$language_id = intval($_SESSION['languages_id']??2);
		foreach($query as $record){
			$ppv = new product_properties_values((int)$record['products_properties_values_id']);
			$values[] = array(
				'sort_order'=>$ppv->getSort_order(),
				'price'=>$ppv->getPrice(),
				'xy_percent_add'=>$ppv->getXy_percent_add(),
				'input_span'=>$ppv->getInput_span(),
				'description'=>$ppv->getDescription($language_id),
			    'image'=>$ppv->getImage(),
			    'files_image'=>$ppv->getFiles_image()
			);
		}
		return $values;
	}
	
	public function getProducts_id() {
		return $this->products_id;
	}

	public function setProducts_id($products_id) {
		$this->products_id = $products_id;
	}
	
	public function getProducts_properties_id() {
		return $this->products_properties_id;
	}

	public function setProducts_properties_id($products_properties_id) {
		$this->products_properties_id = $products_properties_id;
	}

	public function getDate_added() {
		return $this->date_added;
	}

	public function setDate_added($date_added) {
		$this->date_added = $date_added;
	}

	public function getSort_order() {
		return $this->sort_order;
	}

	public function setSort_order($sort_order) {
		$this->sort_order = $sort_order;
	}
        
        public function getTag() {
            return $this->tag;
        }

        public function setTag($tag): void {
            $this->tag = $tag;
        }

        
	public function delete(){
		$query = xtc_db_query(sprintf(
			"SELECT language_id,products_properties_description_id FROM products_properties_description WHERE products_properties_id='%s'",
			$this->getProducts_properties_id()
		));
		while($record = xtc_db_fetch_array($query)){
			$ppd = new product_properties_description($record['products_properties_description_id'],$record['language_id']);
			$ppd->delete();
		}
		
		$query = xtc_db_query(sprintf(
			"SELECT products_properties_values_id FROM products_properties_values WHERE products_properties_id='%s'",
			$this->getProducts_properties_id()
		));
		while($record = xtc_db_fetch_array($query)){
			$ppv = new product_properties_values($record['products_properties_values_id']);
			$ppv->delete();
		}
		xtc_db_query(sprintf("DELETE FROM products_properties WHERE products_properties_id='%s'",
			$this->getProducts_properties_id()
		));
                // xy preise - Speziell Tabelle product_properties_xy_prices_values_for_properties
                // kann properties_id enthalten die nicht geprueft werden wenn
                // im properties Admin eine Eigenschaft geloescht wird
                // deshalb loeschen wir einfach stumpf zur Sicherheit
                xtc_db_query(sprintf(
                        "DELETE FROM product_properties_xy_prices_values_for_properties WHERE products_properties_id='%d'",
			$this->getProducts_properties_id()
                ));
	}
	
	public function getValues_next_sort_order(){
		$query = xtc_db_query(sprintf(
			"SELECT MAX(sort_order) as max_sort_order FROM products_properties_values WHERE products_properties_id='%s'",
			$this->getProducts_properties_id()
		));
		$record = xtc_db_fetch_array($query);
		return $record['max_sort_order']+1;
	}
	
	public function copy_to_product($pID,$copy_values=false){
	    $insert_sql_array = array(
		'products_id'=>$pID,
		'date_added'=>'now()',
		'sort_order'=>$this->getSort_order(),
                'tag'=>$this->getTag(),
	    );
	    yes_db_perform('products_properties',$insert_sql_array);
	    $new_ppID = xtc_db_insert_id();
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM products_properties_description WHERE products_properties_id='%d'",
		    (int)$this->getProducts_properties_id()
	    ));
	    while($record = xtc_db_fetch_array($query)){
		unset($record['products_properties_description_id']);
		$record['products_properties_id'] = $new_ppID;
		xtc_db_perform('products_properties_description',$record);
	    }
	    if(!$copy_values){
		return true;
	    }
	    $ppv_array = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM products_properties_values WHERE products_properties_id='%d'",
		    $this->getProducts_properties_id()
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$ppv_array[] = $record;
	    }
	    if(!sizeOf($ppv_array))
		return true;
	    foreach($ppv_array as $ppvk=>$ppv){
		$query = xtc_db_query(sprintf(
			"SELECT * FROM products_properties_values_description WHERE products_properties_values_id='%d'",
			$ppv['products_properties_values_id']
		));
		while($record = xtc_db_fetch_array($query)){
		    $ppv_array[$ppvk]['description'][] = $record;
		}
	    }
	    foreach($ppv_array as $ppv){
		$description = $ppv['description'];
		unset($ppv['description']);
		unset($ppv['products_properties_values_id']);
// DIE SOLLEN DOCH MITKOPIERT WERDEN - 07/2018 - Ticket 2876                
//		unset($ppv['image']);
//		unset($ppv['files_image']);
		$ppv['products_properties_id'] = $new_ppID;
		yes_db_perform('products_properties_values',$ppv);
		$new_ppvID = xtc_db_insert_id();
		foreach($description as $desc){
		    unset($desc['products_properties_values_description_id']);
		    $desc['products_properties_values_id'] = $new_ppvID;
		    xtc_db_perform('products_properties_values_description',$desc);
		}
	    }
	    return true;
	}
}
