<?php
use Phpfastcache\CacheManager;
use Phpfastcache\Config\ConfigurationOption;

@setlocale(LC_TIME, 'de_DE');
use yesDSGVO\yesDSGVOmain;
use yesDSGVO\yesDSGVOconsent;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
define('YES_SQL_EMPTY_DATE','0000-00-00 00:00:00');
define('PAGE_PARSE_START_TIME', microtime());
define('PROJECT_VERSION', 'YES4Trade_v1');

$configuration_file = realpath(__DIR__).DIRECTORY_SEPARATOR.'configure.php';
/*$home = getenv('HOME');
if(empty($home)){
    if(str_contains(realpath(__DIR__),'/mnt/efa53e84-19eb-432b-9636-ad4c06d8b8d9/apache2/')){
        $home = '/mnt/efa53e84-19eb-432b-9636-ad4c06d8b8d9/apache2/';
    }else{
        throw new Exception('No home directory found.');
    }
}
if(!str_ends_with($home,DIRECTORY_SEPARATOR)){
    $home .= DIRECTORY_SEPARATOR;
}
if(is_file($home.'secure_files/'.basename($configuration_file))){
    $configuration_file = $home.'secure_files/'.basename($configuration_file);
}
echo $configuration_file;exit;
*/
if(is_file($configuration_file) and is_readable($configuration_file)){
    include($configuration_file);
}else{
    throw new Exception('Shop Configuration not available.');
}

require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'global_functions.php');
require_once(DIR_FS_CATALOG.'includes/classes/vendor/autoload.php');
define('YES_PHPFASTCACHE_METHOD','Files');
define('YES_PHPFASTCACHE_TAG_NEW_ORDERS','new_orders');
define('YES_PHPFASTCACHE_STATS_EXPIRE',60*60*24);

require_once(DIR_FS_CATALOG. 'admin/includes/classes/ACK.php');
define('CHARSET','utf-8');

include('includes/php_deprecated_functions.php');


// NEUE PHPMAILER VERSION
require_once(DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/PHPMailer.php');
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/Exception.php';
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/SMTP.php';


if(!defined('DIR_FS_ADMIN')){
    define('DIR_FS_ADMIN',DIR_FS_CATALOG.'admin/');
}
include(DIR_FS_ADMIN.'includes/config.ebayapi.inc.php');

require_once(DIR_FS_INC . 'xtc_get_products_not_shipped.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_in_reclamations.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_at_amazon.inc.php');
require_once(DIR_FS_INC.'yes_update_products_in_auction_quantity.inc.php');
require_once(DIR_FS_INC.'yes_get_products_images.inc.php');
require_once(DIR_FS_INC.'yes_encode_string.inc.php');
require_once(DIR_FS_INC.'yes_decode_string.inc.php');
require_once(DIR_FS_INC . 'yes_get_products_vpe_string.inc.php');
require_once(DIR_FS_INC.'yes_get_products_properties_values_from_shopping_cart_id.inc.php');
require_once(DIR_FS_INC . 'yes_push.inc.php');
require_once(DIR_FS_INC . 'yes_eu_oss.inc.php');
// define the project version

// set the type of request (secure or not)
$request_type = (getenv('HTTPS') == 'on') ? 'SSL' : 'NONSSL';

// set php_self in the local scope
$PHP_SELF = (isset($_SERVER['PHP_SELF']))?$_SERVER['PHP_SELF']:basename($_SERVER['SCRIPT_NAME']);

// include the list of project filenames
require(DIR_WS_INCLUDES . 'filenames.php');

// include the list of project database tables
require(DIR_WS_INCLUDES . 'database_tables.php');

// SQL caching dir
define('SQL_CACHEDIR',DIR_FS_CATALOG.'cache/');


// Below are some defines which affect the way the discount coupon/gift voucher system work
// Be careful when editing them.
//
// Set the length of the redeem code, the longer the more secure
//  define('SECURITY_CODE_LENGTH', '10');
//
// The settings below determine whether a new customer receives an incentive when they first signup
//
// Set the amount of a Gift Voucher that the new signup will receive, set to 0 for none
//  define('NEW_SIGNUP_GIFT_VOUCHER_AMOUNT', '10');  // placed in the admin configuration mystore
//
// Set the coupon ID that will be sent by email to a new signup, if no id is set then no email :)
//  define('NEW_SIGNUP_DISCOUNT_COUPON', '3'); // placed in the admin configuration mystore

  // Store DB-Querys in a Log File

// include used functions
require(DIR_WS_INCLUDES . 'classes/class.db.php');
$yes_db_class_instance = new db(0);
require_once(DIR_FS_INC . 'yes_db_query.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_pull_down_menu.inc.php');


require_once(DIR_FS_INC . 'xtc_db_queryCached.inc.php');
require_once(DIR_FS_INC . 'xtc_manufacturer_link.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_customer_infos.inc.php');
require_once(DIR_FS_INC . 'xtc_write_user_info.inc.php');

require_once(DIR_FS_INC . 'xtc_db_connect.inc.php');
require_once(DIR_FS_INC . 'xtc_db_close.inc.php');
require_once(DIR_FS_INC . 'xtc_db_error.inc.php');
require_once(DIR_FS_INC . 'xtc_db_perform.inc.php');
require_once(DIR_FS_INC . 'xtc_db_query.inc.php');
require_once(DIR_FS_INC . 'xtc_db_queryCached.inc.php');
require_once(DIR_FS_INC . 'xtc_db_fetch_array.inc.php');
require_once(DIR_FS_INC . 'xtc_db_num_rows.inc.php');
require_once(DIR_FS_INC . 'xtc_db_data_seek.inc.php');
require_once(DIR_FS_INC . 'xtc_db_insert_id.inc.php');
require_once(DIR_FS_INC . 'xtc_db_free_result.inc.php');
require_once(DIR_FS_INC . 'xtc_db_fetch_fields.inc.php');
require_once(DIR_FS_INC . 'xtc_db_output.inc.php');
require_once(DIR_FS_INC . 'xtc_db_input.inc.php');
require_once(DIR_FS_INC . 'xtc_db_prepare_input.inc.php');
require_once(DIR_FS_INC . 'xtc_get_top_level_domain.inc.php');
require_once(DIR_FS_INC . 'xtc_not_null.inc.php');
require_once(DIR_FS_INC . 'xtc_update_whos_online.inc.php');

require_once(DIR_FS_INC . 'xtc_activate_banners.inc.php');
require_once(DIR_FS_INC . 'xtc_expire_banners.inc.php');
require_once(DIR_FS_INC . 'xtc_href_link.inc.php');
require_once(DIR_FS_INC . 'xtc_parse_category_path.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_redirect.inc.php');
require_once(DIR_FS_INC . 'xtc_get_uprid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_all_get_params.inc.php');
require_once(DIR_FS_INC . 'xtc_has_product_attributes.inc.php');
require_once(DIR_FS_INC . 'xtc_image.inc.php');
require_once(DIR_FS_INC . 'xtc_note.inc.php');
require_once(DIR_FS_INC . 'xtc_check_stock_attributes.inc.php');
require_once(DIR_FS_INC . 'xtc_currency_exists.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_separator.inc.php');
require_once(DIR_FS_INC . 'xtc_remove_non_numeric.inc.php');
require_once(DIR_FS_INC . 'xtc_get_ip_address.inc.php');
require_once(DIR_FS_INC . 'xtc_setcookie.inc.php');
require_once(DIR_FS_INC . 'xtc_check_agent.inc.php');
require_once(DIR_FS_INC . 'xtc_count_cart.inc.php');
require_once(DIR_FS_INC . 'xtc_get_qty.inc.php');
require_once(DIR_FS_INC . 'create_coupon_code.inc.php');
require_once(DIR_FS_INC . 'xtc_gv_account_update.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_rate_from_desc.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');

require_once(DIR_FS_INC . 'xtc_input_validation.inc.php');
require_once(DIR_FS_INC.'cartesian_functions.inc.php');

  // make a connection to the database... now
xtc_db_connect() or die('Unable to connect to database server!');
require (DIR_WS_CLASSES.'main.php');
$secure_path = main::get_secure_path();
$fc_config = array(
    "path" => $secure_path.DIRECTORY_SEPARATOR.'fastcache'
);
if(main::isDev(true)){
    error_reporting(E_ERROR);
}else{
    error_reporting(E_ERROR);
}

if(!is_dir($fc_config['path'])){
    mkdir($fc_config['path']) or die('Cant create fastcache dir');
    chmod($fc_config['path'],0777) or die('Cant give write access to fastcache dir');
}
CacheManager::setDefaultConfig(new ConfigurationOption([
    'path' => $fc_config['path'],
    'defaultTtl' => 3600,
]));

$InstanceCache = CacheManager::getInstance(YES_PHPFASTCACHE_METHOD);

$key = 'configuration'; // vereinheitlicht
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
    $configurations = [];
    $configuration_query = xtc_db_query(sprintf(
        "select configuration_key as ckey, configuration_value as cvalue from %s",
        TABLE_CONFIGURATION
    ));
    while ($configuration = xtc_db_fetch_array($configuration_query)) {
        $configurations[] = ['key'=>$configuration['ckey'], 'value'=>$configuration['cvalue']];
    }
    $CachedString->set($configurations)->expiresAfter(0);//configuration
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $configurations = $CachedString->get();
}
foreach($configurations as $cconf){
    define($cconf['key'], $cconf['value']);
}
require (DIR_WS_CLASSES.'product.php');

// if gzip_compression is enabled, start to buffer the output
if ( (GZIP_COMPRESSION == 'true') && ($ext_zlib_loaded = extension_loaded('zlib')) && (PHP_VERSION >= '4') ) {
  if (($ini_zlib_output_compression = (int)ini_get('zlib.output_compression')) < 1) {
    ob_start('ob_gzhandler');
  } else {
    ini_set('zlib.output_compression_level', GZIP_LEVEL);
  }
}
// set the HTTP GET parameters manually if search_engine_friendly_urls is enabled
if (defined('SEARCH_ENGINE_FRIENDLY_URLS') and SEARCH_ENGINE_FRIENDLY_URLS == 'true') {
  if (strlen(getenv('PATH_INFO')) > 1) {
    $GET_array = array();
    $PHP_SELF = str_replace(getenv('PATH_INFO'), '', $PHP_SELF);
    $vars = explode('/', substr(getenv('PATH_INFO'), 1));
    for ($i=0, $n=sizeof($vars); $i<$n; $i++) {
      if (strpos($vars[$i], '[]')) {
        $GET_array[substr($vars[$i], 0, -2)][] = $vars[$i+1];
      } else {
        $_GET[$vars[$i]] = htmlspecialchars($vars[$i +1]);
      }
      $i++;
    }

    if (sizeof($GET_array) > 0) {
      // php8 bugfix
      //while (list($key, $value) = each($GET_array)) {
      foreach($GET_array as $key => $value) {
        $_GET[$key] = $value;
      }
    }
  }
}


// check GET/POST/COOKIE VARS
require (DIR_WS_CLASSES.'class.inputfilter.php');
$InputFilter = new InputFilter();

//$_GET = $InputFilter->process($_GET);
$_GET = $InputFilter->process($_GET, true);
$_POST = $InputFilter->process($_POST);


// set the top level domains
$http_domain = xtc_get_top_level_domain(HTTP_SERVER);
$https_domain = xtc_get_top_level_domain(HTTPS_SERVER);
$current_domain = (($request_type == 'NONSSL') ? $http_domain : $https_domain);

require_once(DIR_FS_CATALOG.'/admin/includes/classes/YES4Trade/autoload.php');

// include shopping cart class
require(DIR_WS_CLASSES . 'shopping_cart.php');

// include navigation history class
require(DIR_WS_CLASSES . 'navigation_history.php');

// some code to solve compatibility issues
require(DIR_WS_FUNCTIONS . 'compatibility.php');
// define how the session functions will be used
require(DIR_WS_FUNCTIONS . 'sessions.php');

// set the session name and save path
// BOF EASYCHECKOUT
if(defined('USE_EASYCHECKOUT') and USE_EASYCHECKOUT == 'True'){
    if(isset($_GET["diesessionid"]) and $_GET["diesessionid"]!=""){
	session_id($_GET["diesessionid"]);
    }
}

// EOF EASYCHECKOUT
session_name('XTCsid');
session_save_path(SESSION_WRITE_DIRECTORY);
// set the session cookie parameters
if (function_exists('session_set_cookie_params')) {
    session_set_cookie_params(0, '/', (xtc_not_null($current_domain) ? '.' . $current_domain : ''));
} elseif (function_exists('ini_set')) {
    ini_set('session.cookie_lifetime', '0');
    ini_set('session.cookie_path', '/');
    ini_set('session.cookie_domain', (xtc_not_null($current_domain) ? '.' . $current_domain : ''));
}


// set the session ID if it exists
/*
if (isset($_POST[session_name()])) {
  session_id($_POST[session_name()]);
} elseif ( ($request_type == 'SSL') && isset($_GET[session_name()]) ) {
  session_id($_GET[session_name()]);
}*/

// start the session
$session_started = false;
if (SESSION_FORCE_COOKIE_USE == 'True') {
    xtc_setcookie('cookie_test', 'please_accept_for_session', time()+60*60*24*30, '/', $current_domain);
    if (isset($_COOKIE['cookie_test'])) {
        session_start();
        include(DIR_WS_INCLUDES . 'tracking.php');
        $session_started = true;
    }
} elseif (CHECK_CLIENT_AGENT == 'True') {
  $user_agent = strtolower(getenv($_SERVER['HTTP_USER_AGENT']));
  $spider_flag = false;

    if (xtc_not_null($user_agent)) {
        $spiders = file(DIR_WS_INCLUDES . 'spiders.txt');

        for ($i=0, $n=sizeof($spiders); $i<$n; $i++) {
            if (xtc_not_null($spiders[$i])) {
                if (is_integer(strpos($user_agent, trim($spiders[$i])))) {
                    $spider_flag = true;
                    break;
                }
            }
        }
    }

    if ($spider_flag == false) {
        session_start();
        include(DIR_WS_INCLUDES . 'tracking.php');
        $session_started = true;
    }
} else { // else if CHECK_CLIENT_AGENT == true
    @session_start();
    include(DIR_WS_INCLUDES . 'tracking.php');
    $session_started = true;
}
// verify the ssl_session_id if the feature is enabled
if ( ($request_type == 'SSL') && (SESSION_CHECK_SSL_SESSION_ID == 'True') && (ENABLE_SSL == true) && ($session_started == true) ) {
    $ssl_session_id = getenv('SSL_SESSION_ID');
    if (!isset($_SESSION['SSL_SESSION_ID'])) {
        $_SESSION['SESSION_SSL_ID'] = $ssl_session_id;
    }

    if ($_SESSION['SESSION_SSL_ID'] != $ssl_session_id) {
        session_destroy();
        xtc_redirect(xtc_href_link(FILENAME_SSL_CHECK));
    }
}
require_once (DIR_WS_CLASSES.'class.wishlist.php');
// verify the browser user agent if the feature is enabled
if (SESSION_CHECK_USER_AGENT == 'True') {
  $http_user_agent = getenv($_SERVER['HTTP_USER_AGENT']);
  if (!isset($_SESSION['SESSION_USER_AGENT'])) {
    $_SESSION['SESSION_USER_AGENT'] = $http_user_agent;
  }

  if ($_SESSION['SESSION_USER_AGENT'] != $http_user_agent) {
    session_destroy();
    xtc_redirect(xtc_href_link(FILENAME_LOGIN));
  }
}
// verify the IP address if the feature is enabled
if (defined('SESSION_CHECK_IP_ADDRESS') and SESSION_CHECK_IP_ADDRESS == 'True') {
  $ip_address = xtc_get_ip_address();
  if (!isset($_SESSION['SESSION_IP_ADDRESS'])) {
    $_SESSION['SESSION_IP_ADDRESS'] = $ip_address;
  }

  if ($_SESSION['SESSION_IP_ADDRESS'] != $ip_address) {
    session_destroy();
    xtc_redirect(xtc_href_link(FILENAME_LOGIN));
  }
}

// wird gecached im 5 min takt
require_once(DIR_FS_INC . 'xtc_expire_specials.inc.php');

// new p URLS
if (isset ($_GET['info'])) {
        $site = explode('_', xtc_db_input($_GET['info']));
        $pID = $site[0];
//      $_GET['products_id']=(int)str_replace('p','',$pID);
        $actual_products_id = (int) str_replace('p', '', $pID);
        $product = new product($actual_products_id);
//      $_GET['products_id'] = $actual_products_id;
}
if (!isset($product) or !is_object($product)) {
        $product = new product();
}

// include the mail classes
if (EMAIL_TRANSPORT == 'sendmail') {
    include(DIR_WS_CLASSES . 'class.phpmailer.php');
}
if (EMAIL_TRANSPORT == 'smtp') {
    include(DIR_WS_CLASSES . 'class.smtp.php');
}

// include cart actions
$main = new main();
// set the language
if (!isset($_SESSION['language']) || isset($_GET['language'])) {
    include(DIR_WS_CLASSES . 'language.php');
    if(isset($_GET['language'])){
        $get_language = xtc_input_validation($_GET['language'],'char','');
    }else{
        $get_language = '';
    }
    $lng = new language($get_language);
    if (!isset($_GET['language'])) {
        $lng->get_browser_language();
    }
    $_SESSION['language'] = $lng->language['directory'];
    $_SESSION['languages_id'] = $lng->language['id'];
    $_SESSION['language_charset'] = $lng->language['language_charset'];
}
// include the language translations
if(is_file(DIR_WS_LANGUAGES . $_SESSION['language'].'/'.$_SESSION['language'] . '.php')){
    if(is_file(DIR_WS_LANGUAGES . $_SESSION['language'].'/own_'.$_SESSION['language'] . '.php')){
        require(DIR_WS_LANGUAGES . $_SESSION['language'].'/own_'.$_SESSION['language'] . '.php');
    }

    require(DIR_WS_LANGUAGES . $_SESSION['language'].'/'.$_SESSION['language'] . '.php');
}else{
    throw new \Exception('Cant find language Files for '.$_SESSION['language']);
}
  
  
// currency
if (!isset($_SESSION['currency']) || isset($_GET['currency']) || ( (defined('USE_DEFAULT_LANGUAGE_CURRENCY') and constant('USE_DEFAULT_LANGUAGE_CURRENCY') == 'true') && (isset($_SESSION['currency']) and constant('LANGUAGE_CURRENCY') != $_SESSION['currency']) ) ) {
    if (isset($_GET['currency'])) {
        $_SESSION['currency'] = xtc_currency_exists(xtc_db_input($_GET['currency']));
        if (!$_SESSION['currency']){
            $_SESSION['currency'] = (defined('USE_DEFAULT_LANGUAGE_CURRENCY') and constant('USE_DEFAULT_LANGUAGE_CURRENCY') == 'true') ? constant('LANGUAGE_CURRENCY') : constant('DEFAULT_CURRENCY');
        }
    } else {
        $_SESSION['currency'] = (defined('USE_DEFAULT_LANGUAGE_CURRENCY') and constant('USE_DEFAULT_LANGUAGE_CURRENCY') == 'true') ? constant('LANGUAGE_CURRENCY') : constant('DEFAULT_CURRENCY');
    }
}
if (isset($_SESSION['currency']) && empty($_SESSION['currency'])) {
    $_SESSION['currency'] = constant('DEFAULT_CURRENCY');
}

// write customers status in session
// _SESSION[customers_status] wird bei jedem aufruf aktualisiert
require(DIR_WS_INCLUDES . 'write_customers_status.php');

  // testing new price class
require(DIR_WS_CLASSES . 'xtcPrice.php');
$xtPrice = new xtcPrice($_SESSION['currency'],$_SESSION['customers_status']['customers_status_id']);

// split-page-results
require(DIR_WS_CLASSES . 'split_page_results.php');

// infobox
require(DIR_WS_CLASSES . 'boxes.php');

// initialize the message stack for output messages
require(DIR_WS_CLASSES . 'message_stack.php');
$messageStack = new messageStack;

require(DIR_WS_INCLUDES.FILENAME_CART_ACTIONS);
// create the shopping cart & fix the cart if necesary
if (!isset($_SESSION['cart']) or !is_object($_SESSION['cart'])) {
	$_SESSION['cart'] = new shoppingCart();
}

// include the who's online functions
// ist die Frage ob man da keine htaccess Funktionen nehmen kann
xtc_update_whos_online();


// auto activate and expire banners
//xtc_activate_banners();
//xtc_expire_banners();

// auto expire special products
xtc_expire_specials();

// calculate category path
if (isset($_GET['cPath'])) {
    $cPath = xtc_input_validation($_GET['cPath'],'cPath','');
} elseif (isset($_GET['products_id']) && !isset($_GET['manufacturers_id'])) {

    //*******************************************************************
    // START BUGFIX VERLINKUNGEN
    $parameter = $_GET['products_id'];
    $selected_cat_id = false;
    if(strstr($parameter,'_')){
        $split = split('_',$parameter);
        $pID = xtc_db_input($split[0]);
        $selected_cat_id = xtc_db_input($split[1]);
        $cPath = xtc_get_product_path((int)$pID,$selected_cat_id);
        $cPath = $cPath.$selected_cat_id;
        $_REQUEST['products_id'] = $pID;
    }else{
        $cPath = xtc_get_product_path((int)xtc_db_input($_GET['products_id']));
    }
    // ENDE BUGFIX VERLINKUNGEN
    //*******************************************************************
} else {
    $cPath = '';
}
if (xtc_not_null($cPath)) {
    $cPath_array = xtc_parse_category_path($cPath);
    
    if(sizeOf($cPath_array)<1){
        $cPath_array = [0];
    }
    $cpath_nr = (sizeof($cPath_array)-1);
    $current_category_id = $cPath_array[$cpath_nr];
    $cat_link_obj = \YES4Trade\Model\category::get_by_categories_id($current_category_id,['link_id']);
    if($cat_link_obj !== Null and intval($cat_link_obj->link_id) > 0){
        foreach($cPath_array as $cpK=>$cpID){
            if(intval($cpID) == $current_category_id){
                $cPath_array[$cpK] = intval($cat_link_obj->link_id);
                $current_category_id = intval($cat_link_obj->link_id);
            }
        }
    }
    $cPath = implode('_', $cPath_array);
} else {
    $current_category_id = 0;
}

// include the breadcrumb class and start the breadcrumb trail
require(DIR_WS_CLASSES . 'breadcrumb.php');
$breadcrumb = new breadcrumb;

$breadcrumb->add(HEADER_TITLE_TOP, HTTP_SERVER);
$breadcrumb->add(HEADER_TITLE_CATALOG, xtc_href_link(FILENAME_DEFAULT));

// add category names or the manufacturer name to the breadcrumb trail
if (isset($cPath_array) and is_countable($cPath_array)) {
    for ($i=0, $n=sizeof($cPath_array); $i<$n; $i++) {
        $languages_id = intval($_SESSION['languages_id']??2);
        $cache_key = 'shop.categories-c'.base64_encode($cPath_array[$i].'-l'.$languages_id);
        $cache_group = 'categories';
        $key = \yescache_helper::cache_key($InstanceCache, $cache_group, $cache_key);

        $CachedString = $InstanceCache->getItem($key); // cache group
        if (!$CachedString->isHit()) {
            $catd = \YES4Trade\Model\categories_description::get_by_categories_id_and_language_id(
                intval($cPath_array[$i]),$languages_id
            );
            $categories_data = [
                'categories_id'=>$cPath_array[$i],
                'categories_name'=>$catd->categories_name??''
            ];
            $CachedString->set($categories_data)->expiresAfter(YES_CACHE_LIFETIME_LONG);//cat
            $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        }else{
            $categories_data = $CachedString->get();
        }

        if(!empty($categories_data['categories_name'])){
            $breadcrumb->add($categories_data['categories_name'],
                xtc_href_link(FILENAME_DEFAULT, 
                        'cPath=' . implode('_', array_slice($cPath_array, 0, ($i+1))))
            );
        } else {
            break;
        }
    }
} elseif (isset($_GET['manufacturers_id'])) {
    $manu = \YES4Trade\Model\manufacturer::get_by_manufacturers_id(intval($_GET['manufacturers_id']));
    if($manu != null){
        $breadcrumb->add($manu->manufacturers_name, 
            xtc_href_link(FILENAME_DEFAULT, 'manufacturers_id=' . (int)$_GET['manufacturers_id'])
        );
    }
}

// add the products model to the breadcrumb trail
if (isset($_GET['products_id'])) {
    $title = '';
    switch(NAVTRAIL_PRODUCTS_TITLE){
        case 'products_name':
            $title = xtc_get_products_name((int)xtc_db_input($_GET['products_id']));
            break;
        case 'products_id':
            $title = (int)xtc_db_input($_GET['products_id']);
            break;
        case 'products_ean':
            $navtrail_product_query_raw = sprintf(
                "select products_ean from %s where products_id = :products_id",
                TABLE_PRODUCTS
            );
            $parameters = ['products_id'=>(int)$_GET['products_id']];
            $navtrail_products =yes_query($navtrail_product_query_raw, $parameters);
            if(is_countable($navtrail_products) and sizeOf($navtrail_products)){
                $navtrail_product = current($navtrail_products);
                $title = $navtrail_product['products_ean'];
            }
            break;
    }
    // wenn nichts gefunden wurde, dann model
	if(empty($title)){
        $parameters = ['products_id'=>(int)xtc_db_input($_GET['products_id'])];
	    $navtrail_product_query_raw = sprintf(
            "select products_model from %s where products_id = :products_id",
            TABLE_PRODUCTS
        );
	    $navtrail_products = yes_query($navtrail_product_query_raw,$parameters);
        if(is_countable($navtrail_products) and sizeOf($navtrail_products)){
            $navtrail_product = current($navtrail_products);
            $title = $navtrail_product['products_model'];
        }
    }
    $breadcrumb->add($title, xtc_href_link(FILENAME_PRODUCT_INFO, 'cPath=' . $cPath . '&products_id=' . (int)xtc_db_input($_GET['products_id'])));
}

// set which precautions should be checked
define('WARN_INSTALL_EXISTENCE', 'false');
define('WARN_CONFIG_WRITEABLE', 'false');
define('WARN_SESSION_DIRECTORY_NOT_WRITEABLE', 'true');
define('WARN_SESSION_AUTO_START', 'true');
define('WARN_DOWNLOAD_DIRECTORY_NOT_READABLE', 'true');

// Include Template Engine
require(DIR_WS_CLASSES . 'class.yesSmarty.php');

if (isset($_SESSION['customer_id'])) {
    $cust = \YES4Trade\Model\customers::get_by_customers_id((int)$_SESSION['customer_id'],[
        'account_type', 'customers_default_address_id'
    ]);
    // check if zone id is unset bug #0000169
    if (!isset($_SESSION['customer_country_id'])) {
        $item = \YES4Trade\Model\address_book::get_by_customers_id_and_address_book_id(
            (int)$_SESSION['customer_id'], 
            (int)$cust->customers_default_address_id
        );
        if($item !== null){
            $_SESSION['customer_country_id']=$item->entry_country_id;
        }
    }
    $_SESSION['account_type']=$cust->account_type;
} else {
    $_SESSION['account_type']='0';
}

// modification for nre graduated system
unset($_SESSION['actual_content']);
xtc_count_cart();

require_once(DIR_WS_CLASSES.'shipping_default_class.php');
if(is_dir(DIR_FS_CATALOG.'admin/cron/')){
    if(!is_writable(DIR_FS_CATALOG.'admin/cron/')){
        if(strstr(HTTP_SERVER,'localhost')){
            die('admin/cron/ not writable');
        }else{
            mail('m.aspeleiter@yes-websolutions.de','admin/cron/ not writable',STORE_NAME.' / '.HTTP_SERVER.' admin/cron/ Directory not writable');
        }
    }
    $cdf_dir = DIR_FS_CATALOG.'admin/cron/';
    $cron_dir_files = scandir($cdf_dir);
}else{
    if(main::isDev(true)){
        die('admin/cron/ not exists');
    }else{
        mail('m.aspeleiter@yes-websolutions.de','no admin/cron/ directory',STORE_NAME.' / '.HTTP_SERVER.' has no admin/cron/ Directory');
    }
}

// BOF YESDSGVO
spl_autoload_register('my_yesdsgvo_psr4_autoloader');

if(defined('MODULE_OTHER_YESDSGVO_ADMIN_STATUS') and MODULE_OTHER_YESDSGVO_ADMIN_STATUS == 'True'){
    $yesDSGVO = new \yesDSGVO\yesDSGVOmain;
    if(main::isDev(true)){
        $yesDSGVO->debug = true;
    }
    if(isset($_GET['yesDSGVO_details']) and $_GET['yesDSGVO_details'] == '1'){
        die($yesDSGVO->get_details());
    }
    if(isset($_GET['yesDSGVO_load_scripts']) and $_GET['yesDSGVO_load_scripts'] == '1'){
        $out = $yesDSGVO->get_load_scripts_js();
        header('Content-Type: application/javascript');
        echo $out;
        exit;
    }
}


$YesBoxes = new \YES4Trade\Model\yes_boxes;

