<?php
setlocale(LC_TIME, 'de_DE') or setlocale(LC_TIME, 'de_DE.utf8');
function json_numeric($array){
	if (is_array($array) || is_object($array)) {
		foreach($array as &$prop) {
			if (is_numeric($prop)) {
				$prop = intval($prop);
			}
			if (is_object($prop) || is_array($prop)) {
				$prop = json_numeric($prop);
			}
		}
	}
	return $array;
}

function yes_get_google_chart_html($param){
    $hour_multiplier = yes_get_google_chart_hour_multiplier($param['freq']);
    $span = yes_get_google_chart_span($param['freq'],$param['from'],$param['to'],$hour_multiplier);
    switch($param['freq']){
	case 'monthly':
	    $dt_modify_di_modifier = 'months';
	    $sql_stat_format = '%%m/%%y';
	    $stat_format = 'm/y';
	    $hAxis_title = TEXT_MONTH;
	    $js_format = 'm/y';
	    $stat_format_strftime = "%m/%g";
	    break;
	case 'weekly':
	    $dt_modify_di_modifier = 'weeks';
	    $sql_stat_format = '%%u %%Y';
	    $stat_format = 'W Y';
$stat_format_strftime = "%V %G";
	    $hAxis_title = TEXT_WEEK;
	    $js_format = '';
	    break;
	case 'daily':
	    $after_format_sql_date_result = 1;
	    $sql_stat_format = '%%Y-%%m-%%d';
	    $stat_format = "d M";
$stat_format_strftime = "%d %b";
	    $js_format = 'dd mm';
	    $hAxis_title = TEXT_DAY;
	    break;
    }
    $rows = array();
    switch($param['type']){
	default:
	    $sources = array('shop'=>0,'counter'=>0,'admin'=>0,'amazon'=>0,'ebay'=>0);
	    $first_row = array('Datum');
	    $default_source_values = array();
	    foreach($sources as $src=>$num){
		$default_source_values[] = $num;
		$first_row[] = yggch_get_source_name($src);
	    }
	    $rows[] = $first_row;
	    for($i=0;$i < $span;$i++){
		if($hour_multiplier > 0){
		    $time = strtotime($param['from'])+(60*60*$hour_multiplier*$i);
		    $date_key = strftime($stat_format_strftime,$time);
		}else{
		    $dt = new DateTime($param['from']);
		    if($i > 0){
			$dt->modify('+'.$i.' '.$dt_modify_di_modifier);
		    }
		    
		    //$formatted_time = strftime("%a %e.%l.%Y", $mytime->getTimestamp())		    
		    $date_key = strftime($stat_format_strftime,$dt->getTimestamp());
		}
		$rows[] = array_merge(array($date_key),$default_source_values);
	    }
	    switch($param['type']){
		case 'ordersum':
		    $query = xtc_db_query(sprintf(
			    "SELECT SUM( ot.value ) AS stat_value, source,DATE_FORMAT(date_purchased,'".$sql_stat_format."') AS stat FROM %s o LEFT JOIN %s ot USING(orders_id) WHERE ot.class='ot_total' AND date_purchased >= '%s' AND date_purchased <= '%s 23:59:59' GROUP BY source,stat",
			    TABLE_ORDERS,TABLE_ORDERS_TOTAL,$param['from'],$param['to']
		    ));
		    break;
		default:
		    $query = xtc_db_query(sprintf(
			    "SELECT COUNT( orders_id ) AS stat_value, source,DATE_FORMAT(date_purchased,'".$sql_stat_format."') AS stat FROM %s WHERE date_purchased >= '%s' AND date_purchased <= '%s 23:59:59' GROUP BY source,stat",
			    TABLE_ORDERS,$param['from'],$param['to']
		    ));
		    break;
	    }
	    $counter = 0;
	    while($record = xtc_db_fetch_array($query)){
		if(empty($record['source'])) $record['source'] = 'admin';
		foreach($rows as $row_nr=>$row_data){
		    if($row_nr == 0) continue;
		    if($after_format_sql_date_result == 1){
			$date_key = date($stat_format, strtotime($record['stat']));
		    }else{
			$date_key = $record['stat'];
		    }
	//	    printf('<li>%s - %s',$row_data[0],$date_key);
		    if($row_data[0] == $date_key){
			$rows[$row_nr][ yggch_get_col_num($record['source'],$sources) ] += $record['stat_value'];
		    }
		}
		$counter++;
	    }
	    break;
    }
    array_shift($rows);
    $title = yes_get_google_chart_title($param['freq'],$span);
    $js_columns = array();
    $_js_columns = array_keys($sources);
    foreach($_js_columns as $k){
	$js_columns[] = sprintf('"%s"',$k);
    }
?>
<html>
  <head>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script type="text/javascript">
	var GC_TITLE = '<?php echo $param['title'].' - '.$title; ?>';
	var VAXIS_TITLE = '<?php echo current(explode(' ',$param['title'])); ?>';
	var HAXIS_TITLE = '<?php echo $hAxis_title; ?>';
      google.charts.load('current', {packages:['corechart']});
      google.charts.setOnLoadCallback(drawStuff);
        function drawStuff() {
          var data = new google.visualization.DataTable();
          data.addColumn('string', VAXIS_TITLE);
	<?php
	foreach($js_columns as $col){
	    printf("\t\t\tdata.addColumn('number', %s);\r\n",$col);
	}
	?>
          data.addRows([
	  <?php
	  echo "\r\n";
	  foreach($rows as $row){
	      $ttl = $row[0];
	      array_shift($row);
	    printf("\t\t\t['%s', %s],\r\n",$ttl,implode(',',$row));
	  }
	  ?>
          ]);

         var options = {
           title: GC_TITLE,
           width: 600,
           height: 400,
           legend: {position: 'bottom', maxLines: 3},
           bar: {groupWidth: '95%'},
           vAxis: { title: VAXIS_TITLE, gridlines: { count: 4 },format: currency },
	   hAxis: { title: HAXIS_TITLE }
         };

         var chart = new google.visualization.ColumnChart(document.getElementById('number_format_chart'));
         chart.draw(data, options);

         /*document.getElementById('format-select').onchange = function() {
           options['vAxis']['format'] = this.value;
           chart.draw(data, options);
         };*/
      };
    </script>
  </head>
  <body>
    <select id="format-select">
      <option value="">none</option>
      <option value="decimal" selected>decimal</option>
      <option value="scientific">scientific</option>
      <option value="percent">percent</option>
      <option value="currency">currency</option>
      <option value="short">short</option>
      <option value="long">long</option>
    </select>
    <div id="number_format_chart">
  </body>
</html>
<?php
}

function yes_get_google_chart_hour_multiplier($freq){
    switch($freq){
	case 'daily':
	    return 24;
	    break;
    }
    return 0;
}
function yes_get_google_chart_span($freq,$from,$to,$hour_multiplier){
//    printf('freq %s, from %s, to %s,hour_multiplier %s',$freq,$from,$to,$hour_multiplier);
    switch($freq){
	case 'monthly':
	    $max_span = 12;
	    $df = new DateTime( $from ); 
	    $span_obj = $df->diff( new DateTime($to) );
	    $span = $span_obj->format('%m')+1;
	    break;
	case 'weekly':
	    $max_span = 20;
	    $df = new DateTime( $from ); 
	    $dt = new DateTime( $to ); 
	    $span = $df->diff( $dt )->days;
	    $span_modulo = $span%7;
	    $span = ($span_modulo > 0) ? (($span-$span_modulo)/7) : $span/7;
	    break;
	case 'daily':
	    $max_span =21;
	    $span = (strtotime($to)-strtotime($from))/(60*60*$hour_multiplier);
	    break;
    }
    $span = (int)$span;
    if($span > $max_span){
	die('Maximum '.$max_span.' for '.$freq.' exceeded');
    }
    return $span;
}
function yes_get_google_chart_title($freq,$span){
    switch($freq){
	case 'monthly':
	    $span_unit = TEXT_MONTHS;
	    break;
	case 'weekly':
	    $span_unit = TEXT_WEEKS;
	    break;
	case 'daily':
	    $span_unit = TEXT_DAYS;
	    break;
    }
    return $span . ' '.$span_unit;
}














function yes_get_google_chart_html2($param){
    switch($param['freq']){
	case 'monthly':
	    $hour_multiplier = 0;
	    $dt_modify_di_modifier = 'months';
	    $max_span = 12;
	    $span_unit = TEXT_MONTHS;
	    $sql_stat_format = '%%m/%%y';
	    $stat_format = 'm/y';
	    $hAxis_title = TEXT_MONTH;
	    $js_format = 'm/y';
	    $df = new DateTime( $param['from'] ); 
	    $param['from'] = $df->format( 'Y-m-01' );
	    $dt = new DateTime( $param['to'] ); 
	    $param['to'] = $dt->format( 'Y-m-t' );
	    $df = new DateTime($param['from']);
	    $span_obj = $df->diff( new DateTime($param['to']) );
	    $span = $span_obj->format('%m');
	    break;
	case 'weekly':
	    $hour_multiplier = 0;
	    $dt_modify_di_modifier = 'weeks';
	    $max_span = 20;
	    $span_unit = TEXT_WEEKS;
	    $sql_stat_format = '%%u/%%y';
	    $stat_format = 'W/y';
	    $hAxis_title = TEXT_WEEK;
	    $js_format = '';
	    $df = new DateTime( $param['from'] ); 
	    $dt = new DateTime( $param['to'] ); 
	    $span = $df->diff( $dt )->days;
	    $span_modulo = $span%7;
	    $span = ($span_modulo > 0) ? (($span-$span_modulo)/7) : $span/7;
	    break;
	case 'daily':
	    $max_span =21;
	    $after_format_sql_date_result = 1;
	    $hour_multiplier = 24; // daily
	    $span_unit = TEXT_DAYS;
	    $sql_stat_format = '%%Y-%%m-%%d';
	    $stat_format = "d M";
	    $js_format = 'dd mm';
	    $hAxis_title = TEXT_DAY;
	    $span = (strtotime($param['to'])-strtotime($param['from']))/(60*60*$hour_multiplier);
	    break;
    }
    $span = (int)$span;
    if($span > $max_span){
	die('Maximum '.$max_span.' for '.$param['freq'].' exceeded');
    }
    $span_text = $span . ' '.$span_unit;
    $rows = array();
    switch($param['type']){
	default:
	    $sources = array('shop'=>0,'counter'=>0,'admin'=>0,'amazon'=>0,'ebay'=>0);
	    $first_row = array('Datum');
	    $default_source_values = array();
	    foreach($sources as $src=>$num){
		$default_source_values[] = $num;
		$first_row[] = yggch_get_source_name($src);
	    }
	    $rows[] = $first_row;
	    for($i=0;$i < $span;$i++){
		if($hour_multiplier > 0){
		    $date_key = date($stat_format, strtotime($param['from']) + ($i*60*60*$hour_multiplier));
		}else{
		    $dt = new DateTime($param['from']);
		    if($i > 0){
			$dt->modify('+'.$i.' '.$dt_modify_di_modifier);
		    }
		    $date_key = $dt->format($stat_format);
		}
		$rows[] = array_merge(array($date_key),$default_source_values);
	    }
	    switch($param['type']){
		case 'ordersum':
		    $query = xtc_db_query(sprintf(
			    "SELECT SUM( ot.value ) AS stat_value, source,DATE_FORMAT(date_purchased,'".$sql_stat_format."') AS stat FROM %s o LEFT JOIN %s ot USING(orders_id) WHERE ot.class='ot_total' AND date_purchased > '%s' AND date_purchased < '%s 23:59:59' GROUP BY source,stat",
			    TABLE_ORDERS,TABLE_ORDERS_TOTAL,$param['from'],$param['to']
		    ));
		    break;
		default:
		    $query = xtc_db_query(sprintf(
			    "SELECT COUNT( orders_id ) AS stat_value, source,DATE_FORMAT(date_purchased,'".$sql_stat_format."') AS stat FROM %s WHERE date_purchased > '%s' AND date_purchased < '%s 23:59:59' GROUP BY source,stat",
			    TABLE_ORDERS,$param['from'],$param['to']
		    ));
		    break;
	    }
	    $counter = 0;
	    while($record = xtc_db_fetch_array($query)){
		if(empty($record['source'])) $record['source'] = 'admin';
		foreach($rows as $row_nr=>$row_data){
		    if($row_nr == 0) continue;
		    if($after_format_sql_date_result == 1){
			$date_key = date($stat_format, strtotime($record['stat']));
		    }else{
			$date_key = $record['stat'];
		    }
		    if($row_data[0] == $date_key){
			$rows[$row_nr][ yggch_get_col_num($record['source'],$sources) ] += $record['stat_value'];
		    }
		}
		$counter++;
	    }
	    break;
    }
    yes_debug($rows);
    exit;
    $json_data = json_encode(json_numeric($rows));
    $js = '
    <script type="text/javascript">
google.setOnLoadCallback(drawChart);
function drawChart() {
        var data = google.visualization.arrayToDataTable(
	    '.$json_data.'
        );

        var options = {
        title: \''.$param['title'].' ('.$span_text.')\',
	hAxis: {
          title: \''.$hAxis_title.'\',
	  format: \''.$js_format.'\'
        },
        vAxis: {
          title: \''.$param['vAxis_title'].'\'';
    if($param['type'] == 'ordersum'){
	$js.= ',format: \'0.00\'';
    }
    $js .= '},
        curveType: \'function\',
        legend: { position: \'bottom\' }
        };
    
        var chart = new google.visualization.LineChart(document.getElementById(\'curve_chart\'));

        chart.draw(data, options);
      }
    </script>';
    return $js.'<div id="curve_chart"></div>';
}
function yggch_get_source_name($src){
    if(defined('TEXT_ORDERS_SOURCE_'.strtoupper($src)) and constant('TEXT_ORDERS_SOURCE_'.strtoupper($src)) != ''){
	return constant('TEXT_ORDERS_SOURCE_'.strtoupper($src));
    }
    return $src;
}

function yggch_get_col_num($src, $sources){
    $k = 0;
    foreach($sources as $_src=>$val){
	if($_src == $src){
	    return $k+1;
	}
	$k++;
    }
    return 0;
}

