<?php
/**
 * exporting order data stats for a given date
 *
 * @param datetime $from
 * @param datetime $to
 * @param bool $tax_export
 * @return array
 */
require_once(DIR_FS_INC . 'xtc_get_payment_method_title.inc.php');
function format_tax_rate_percent_as_key($value){
    return number_format($value,4,'.','');
}
function yes_export_order_stats($from,$to,$tax_export = true,$limit=false,$use_fibu_date_added = false,$branches_id = 0){
	$from_time = strtotime($from);
	$to_time = strtotime($to);
	if( ($from_time > $to_time) or $from_time > time() )
		return false;
	
	$limit_sql = '';
	if($limit)
		$limit_sql = ' LIMIT '.$limit;
	if($branches_id > 0){
		$query_raw = sprintf("SELECT orders_id FROM branches_orders_fibunumbers WHERE date_added>'%s' and date_added<'%s' AND branches_id=%s ORDER BY date_added %s",
				$from,$to,$branches_id,$limit_sql
		);
	}else{
		if(!$use_fibu_date_added){
			$query_raw = sprintf("SELECT orders_id FROM orders WHERE date_purchased>'%s' and date_purchased<'%s' ORDER BY date_purchased %s",$from,$to,$limit_sql);
		}else{
			$query_raw = sprintf("SELECT orders_id FROM orders_fibunumbers WHERE date_added>'%s' and date_added<'%s' ORDER BY date_added %s",$from,$to,$limit_sql);
		}
	}
	$query = xtc_db_query($query_raw);
	$orders_id_array = array();
	while($res = xtc_db_fetch_array($query)){
		$orders_id_array[] = $res['orders_id'];
	}
        if(!sizeOf($orders_id_array)){
            return false;
        }
	$data = get_export_order_stats_data($orders_id_array,$tax_export,$from,$to);
	return $data;
}

function yes_export_order_stats_from_array($orders_id_array,$tax_export = true){
	$data = get_export_order_stats_data($orders_id_array,$tax_export);
	return $data;
}

function get_export_order_stats_data($orders_id_array,$tax_export,$from='',$to=''){
	$tax_header = '';
	if($tax_export){
		$diff_tax_array = array();
		if(!empty($from)){
			$diff_tax_query_raw = sprintf("SELECT distinct(op.products_tax) FROM orders_products op LEFT JOIN orders o USING(orders_id) WHERE date_purchased>'%s' and date_purchased<'%s' ORDER BY date_purchased",$from,$to);
		}else{
			$diff_tax_query_raw = sprintf("SELECT distinct(op.products_tax) FROM orders_products op LEFT JOIN orders o USING(orders_id) WHERE o.orders_id IN(%s) ORDER BY date_purchased",implode(',',$orders_id_array));
		}
		$diff_tax_query = xtc_db_query($diff_tax_query_raw);
		while($diff_tax = xtc_db_fetch_array($diff_tax_query)){
		    if($diff_tax['products_tax'] > 0){
			$diff_tax_array[ format_tax_rate_percent_as_key($diff_tax['products_tax']) ] = 0;
			$tax_header .= '"Artikel MwSt. '.number_format($diff_tax['products_tax'],1,',','.').'%";';
		    }
		}
		foreach($diff_tax_array as $mwst=>$val){
			$tax_header .= '"Auftrag MwSt. '.number_format($mwst,1,',','.').'%";';
		}
	}
        $order_id_col_title = (defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True') ? 'Auftrag Nr' : 'Re-Nr';
        
	$data = '"'.$order_id_col_title.'";"Fibu Nummer";"Ebay/Amazon Nummer";"eBay Order ID";"Bestelldatum";';
	if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
		$data .= '"FiBu Datum";';
	}
	$data .= '"Zahlungseingang";"Bezahlart";';
	$data .= '"Rechnung Firma";"Rechnung Name";"Rechnung Land";"Versand Firma";"Versand Name";"Versand Land";';
	$data .= '"Rechnungsbetrag";'.$tax_header.'"Bestellstatus";"Kundengruppe";"Kunden ID";"USt.-ID"';
	if(isset($_POST['marge']) and $_POST['marge'] == '1' and defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
		$data .= ';"'.TEXT_MARGE_DIFF.'";"Marge in %"';
	}
	$data .= ';"'.BOX_CURRENCIES.'"';
	$data .= "\r\n";

	$add_tax_array = array();
	foreach($orders_id_array as $orders_id){
		$order = new order($orders_id);
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
                
                $country_id = $order->delivery['country_id'];
				if($country_id === null){
					$country_id = STORE_COUNTRY;
				}
                $zone_id = $order->delivery['zone_id'];
                // BOF - BUGF_CH_OSS - WENN AKTIV BLOCK UEBERFLUESSIG
                if(!yes_eu_oss_use_country_handling(intval($country_id))){
                    $country_id = STORE_COUNTRY;
                    $zone_id = 0;
                }else{
                    $xtPrice->setCountryZone($country_id, $zone_id);
                }
                // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG
                
                // BUGF_CH_OSS - COUNTRY/ZONE IMMER SETZEN
                $xtPrice->setCountryZone($country_id, $zone_id);
                
                
                
                
		$tax_array = array();
		$ot_shipping = 0;
		$ot_tax = 0;
		$ot_tax_products = 0;
		$ot_tax_shipping = 0;
		$ot_total = 0;
		$products_netto = 0;
		$products_tax = 0;
		$plus = ($order->info['orders_status'] != ORDERS_STATUS_STORNIERT) ? true : false;
		$ot_tax_array = array();

		$customer_group = $order->info['status'];
		if(!isset($add_tax_array[$customer_group])){
			$add_tax_query = xtc_db_query("SELECT customers_status_add_tax_ot FROM customers_status WHERE customers_status_id='".$customer_group."'");
			$add_tax_res = xtc_db_fetch_array($add_tax_query);
			$add_tax_array[$customer_group] = $add_tax_res['customers_status_add_tax_ot'];
		}

                $netto_products_price = false; // SPEZIALFALL ot_subtotal_no_tax
		for($i=0;$i<sizeOf($order->totals);$i++){
			switch($order->totals[$i]['class']){
                                case 'ot_subtotal_no_tax':
                                    $netto_products_price = true;
                                    break;
				case 'ot_shipping':
					$ot_shipping += $order->totals[$i]['value'];
					break;
				case 'ot_tax':
					$ot_tax += $order->totals[$i]['value'];
					$ot_tax_array[ format_tax_rate_percent_as_key($order->totals[$i]['tax_rate_percent']) ] = $order->totals[$i]['value'];
					break;
				case 'ot_total':
					$ot_total = $order->totals[$i]['value'];
					break;
			}
		}
                
		for($i=0;$i<sizeOf($order->products);$i++){
			$tax = $order->products[$i]['tax'];
//			if($tax  > 0 and $order->products[$i]['allow_tax'] > 0){
			if($tax  > 0 and $add_tax_array[$customer_group] > 0){
                            if($netto_products_price){
				$tax_array[ format_tax_rate_percent_as_key($tax) ] += ($order->products[$i]['final_price'] * ((100+$tax)/100))-$order->products[$i]['final_price'];
                            }else{
				$products_netto = $order->products[$i]['final_price'] / ((100+$tax)/100);
				// BUGFIX - vorher +=
				$products_tax = $order->products[$i]['final_price'] - $products_netto;
				$tax_array[ format_tax_rate_percent_as_key($tax) ] += $products_tax;
                            }
			}else{
				$tax_array[0] += $order->products[$i]['final_price'];
			}

		}
		
		$payments_string = '';
		$inc_payments_query = xtc_db_query("SELECT buchungstag FROM payment_orders po LEFT JOIN incoming_payments ip ON po.payment_id=ip.id WHERE po.orders_id='".$orders_id."'");
		while($inc_payments = xtc_db_fetch_array($inc_payments_query)){
			$payments_string .= $inc_payments['buchungstag'].',';
		}
		$payments_string = substr($payments_string,0,(strlen($payments_string)-1));

		// ABFRAGE OB KASSE
		$kasse_paymode = '';
		$is_kasse_query = xtc_db_query("SELECT paymode,date_purchased,DATE_FORMAT(date_purchased,'%d.%m.%Y') as datum FROM kasse WHERE orders_id='".$orders_id."'");
		if(xtc_db_num_rows($is_kasse_query)){
			$is_kasse = xtc_db_fetch_array($is_kasse_query);
			if(strlen($payments_string)>0)
				$payments_string .= ', Kasse '.$is_kasse['paymode'].' am '.$is_kasse['datum'];
			else
				$payments_string = 'Kasse '.$is_kasse['paymode'].' am '.$is_kasse['datum'];
		}

		$brutto = ($plus) ? number_format($ot_total,2,',','') : number_format(-$ot_total,2,',','');
		$ebay_amazon = '';
		$ebay_order_id = '';
		if($order->info['ebay_id'] != ''){
			$ebay_amazon = $order->info['ebay_id'];
			$ebay_order_query = yes_query(
				"SELECT OrderID FROM ebay_orders WHERE orders_id=:id",
				['id'=>intval($orders_id)],
				true
			);
			if(isset($ebay_order_query['OrderID']) and !empty($ebay_order_query['OrderID'])){
				$ebay_order_id = "".$ebay_order_query['OrderID'];
			}
		}
		$ao = $order->get_amazon_items();
		if(sizeOf($ao)){
			if($ebay_amazon != ''){
				$ebay_amazon .= ', ';
			}
//			foreach($ao as $amzOrder){
// nur eine amazon order id exportieren (ticket 3561)
			$amzOrder = current($ao);
			$ebay_amazon .= $amzOrder['orig_amazon_orders_id'].', ';
//			}
			$ebay_amazon = substr($ebay_amazon,0,(strlen($ebay_amazon)-2));
		}
		$data .= '"'.$orders_id.'";'.
			'"'.$order->get_fibunumber().'";'.
			'"'.$ebay_amazon.'";'.
			'"'.$ebay_order_id.'";'.
			'"'.$order->info['date_purchased'].'";';
		if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
			$fibu_date_query = yes_db_query(sprintf(
				"SELECT date_added FROM orders_fibunumbers WHERE orders_id='%s'",
				$orders_id
			));
			if(yes_db_num_rows($fibu_date_query)){
				$fibu_date = current($fibu_date_query);
				$data .= '"'.$fibu_date['date_added'].'";';
			}else{
				$data .= '"-";';
			}
		}
		$data .= '"'.$payments_string.'";'.
			'"'.xtc_get_payment_method_title($order->info['payment_method']).'";'.
			'"'.$order->customer['company'].'";'.
			'"'.$order->customer['name'].'";'.
			'"'.$order->customer['country'].'";'.
			'"'.$order->delivery['company'].'";'.
			'"'.$order->delivery['name'].'";'.
			'"'.$order->delivery['country'].'";'.
			'"'.$brutto.'";';
		if($tax_export){
			foreach($diff_tax_array as $dtax=>$dval){
				if($plus){
					$data .= '"'.number_format($tax_array[$dtax],2,',','').'";';
				}else{
					$data .= '"'.number_format(-$tax_array[$dtax],2,',','').'";';
				}
			}
			foreach($diff_tax_array as $dtax=>$dval){
				$data .= '"'.number_format($ot_tax_array[$dtax],2,',','').'";';
			}
		}
		$data .= '"'.xtc_get_orders_status_name($order->info['orders_status']).'";'.
			 '"'.$order->info['status_name'].'";'.
			 '"'.$order->customer['ID'].'";'.
			 '"'.$order->customer['vat_id'].'"';
                
                
            if(isset($_POST['marge']) and $_POST['marge'] == '1' and defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
                $marge = $order->get_marge();
                $data .= ';"'.$marge['MARGE_TOTAL_FORMATTED'].'";"'.MARGENRECHNER_FIXKOSTEN_PERCENT.'"';
            }
		$data .= ';"'.$order->info['currency'].'"';
            $data .= "\r\n";
	}
	return $data;
}
