<?php
function yes_get_cdn_link($type,$version='',$theme=''){
    $string = '';
    $cdn_host = '//ajax.googleapis.com/ajax/libs/';
	$theme = (empty($theme)) ? 'start' : $theme;
	if(isset($_SESSION['theme']) and !empty($_SESSION['theme'])){
		$theme = $_SESSION['theme'];
	}
	$theme_obj = \YES4Trade\Enums\JQUERY_UI_THEMES::fromName($theme);
	if($theme_obj === null){
		$theme = 'start';
	}else{
		$theme = $theme_obj->value;
	}
	switch($type){
		case 'jquery':
			$version = (empty($version)) ? '3.7.1' : $version;
			break;
		case 'tinymce':
		case 'tinymce_filemanager':
			$fallback = (defined('TINYMCE_VERSION') and !empty(TINYMCE_VERSION)) ? TINYMCE_VERSION : '4.0.10';
			$version = (empty($version)) ? $fallback : $version;
			break;
		default:
			$version = (empty($version)) ? '1.14.1' : $version;
			break;
	}

    switch($type){
		case 'jquery':
			$string = $cdn_host.'jquery/'.$version.'/jquery.min.js';
			break;
		case 'jquery-ui-css':
			$string = $cdn_host.'jqueryui/'.$version.'/themes/'.$theme.'/jquery-ui.css';
			break;
		case 'jquery-ui':
			$string = $cdn_host.'jqueryui/'.$version.'/jquery-ui.min.js';
			break;
		case 'tinymce':
			$string = sprintf('js/tinymce-%s/js/tinymce/tinymce.min.js',
				$version
			);
			break;
		case 'tinymce_filemanager':
			$string = sprintf('js/tinymce-%s/js/tinymce/plugins/filemanager/dialog.php?type=2&single_use=1',
				$version
			);
			break;
    }
    return $string;
}