<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_get_tax_description.inc.php,v 1.2 2011/02/11 12:28:48 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_get_tax_description.inc.php); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
function xtc_get_tax_description($class_id, $country_id= -1, $zone_id= -1) {
    global $InstanceCache;
    if ( ($country_id == -1) && ($zone_id == -1) ) {
        // aus dem shop admin heraus, dieses define findet nur in der
        // admin/includes/application und -cron_application_top.php statt
      $admin = defined('ORDERS_EDIT_TAX_STATUS');
      if (!isset($_SESSION['customer_id']) or $admin) {
        $country_id = yes_get_store_country_id();
        $zone_id = yes_get_store_zone_id();
      } else {
        $country_id = $_SESSION['customer_country_id'];
        $zone_id = $_SESSION['customer_zone_id'];
      }
    }
    // EU-OSS-BUGFIX2-TAX
    if(main::isDev(true)){
        if(!yes_eu_oss_use_country_handling((int)$country_id)){
            //$country_id = yes_get_store_country_id();
            //$zone_id = yes_get_store_zone_id();
        }
    }
    
    $key = sprintf("tax_description_%d_%d_%d",
            (int)$country_id,
            (int)$zone_id,
            (int)$class_id
    );
    $CachedString = $InstanceCache->getItem($key);
    if (!$CachedString->isHit()) {
        $tax_query = yes_query(sprintf(
            "select tax_description from %s tr left join %s za on (tr.tax_zone_id = za.geo_zone_id) left join %s tz on (tz.geo_zone_id = tr.tax_zone_id) where (za.zone_country_id is null or za.zone_country_id = '0' or za.zone_country_id =:country_id) and (za.zone_id is null or za.zone_id = '0' or za.zone_id =:zone_id) and tr.tax_class_id =:class_id order by tr.tax_priority",
                TABLE_TAX_RATES, TABLE_ZONES_TO_GEO_ZONES,TABLE_GEO_ZONES
            ),[
                'country_id'=>(int)$country_id,
                'zone_id'=>(int)$zone_id,
                'class_id'=>(int)$class_id
            ]
        );
        if(sizeOf($tax_query)){
            $tax_description = '';
            foreach($tax_query as $_tax) {
              $tax_description .= $_tax['tax_description'] . ' + ';
            }
            $return = substr($tax_description, 0, -3);
        }else{
            $return = TEXT_UNKNOWN_TAX_RATE;
        }
        $CachedString->set($return)->expiresAfter(0)->addTag('shop','tax');//tax_description_*
        $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
        return $return;
    }
    return $CachedString->get();
}
