<?php
/* -----------------------------------------------------------------------------------------
   $Id: xtc_date_long.inc.php,v 1.1 2006/05/03 07:11:49 web2 Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(general.php,v 1.225 2003/05/29); www.oscommerce.com 
   (c) 2003	 nextcommerce (xtc_date_long.inc.php,v 1.3 2003/08/13); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
   
// Output a raw date string in the selected locale date format
// $raw_date needs to be in this format: YYYY-MM-DD HH:MM:SS

function localized_strftime(string $format, int $timestamp, string $locale = 'de_DE'): string {
    // Mapping von strftime-Format → IntlDateFormatter-Pattern
    $replacements = [
        '%a' => 'EEE',    // abgekürzter Wochentag
        '%A' => 'EEEE',   // voller Wochentag
        '%d' => 'dd',     // Tag mit führender Null
        '%e' => 'd',      // Tag ohne führende Null
        '%m' => 'MM',     // Monat (Ziffer)
        '%B' => 'MMMM',   // voller Monatsname
        '%y' => 'yy',     // Jahr zweistellig
        '%Y' => 'yyyy',   // Jahr vierstellig
    ];

    // Formatstring umwandeln
    $pattern = strtr($format, $replacements);

    $fmt = new IntlDateFormatter($locale, IntlDateFormatter::NONE, IntlDateFormatter::NONE);
    $fmt->setPattern($pattern);

    return $fmt->format($timestamp);
}


  function xtc_date_long($raw_date) {
    if ( ($raw_date == '0000-00-00 00:00:00') || ($raw_date == '') ) return false;

    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);
    // php8 bugfix (A = bei streftime Wochentag, bei date PM/AM, darum ersetzen
    // in das A zu l, dann hat man den Wochentag
    if (version_compare(phpversion(), '8.0.0', '>')) {
      return localized_strftime(DATE_FORMAT_LONG, mktime($hour, $minute, $second, $month, $day, $year));
        return date(str_replace(['%','A'],['','l'],DATE_FORMAT_LONG), mktime($hour,$minute,$second,$month,$day,$year));
    }else{
        return strftime(DATE_FORMAT_LONG, mktime($hour,$minute,$second,$month,$day,$year));
    }
  }
