<?php
function YES_PAYMODULE_products_fake_sets_csv_export_write(array $products = [],string $filename=''){
    if(!sizeOf($products)){
        return '';
    }
    $fake_set_path = pathinfo($filename);
    if(!is_dir($fake_set_path['dirname'])){
        mkdir($fake_set_path['dirname']);
    }
    if(!is_file($filename)){
        touch($filename);
    }
    $fh = fopen($filename,'a+') or die(json_encode(array('ERROR'=>"Kann ".$filename." nicht anlegen.")));
    fclose($fh);
    $csv = new CSVfile($filename);
    $csv->open("w");
    foreach($products as $product){
        for($i=1;$i<=5;$i++){
            if($product['qty_'.$i] > 0){
                $data = array(
                    $product['products_id'],
                    str_replace(';',' ',$product['name']),
                    (isset($product['artnr_'.$i]))?str_replace(';',' ',$product['artnr_'.$i]):'',
                    (isset($product['qty_'.$i]))?number_format($product['qty_'.$i],4,',',''):0
                );
                $csv->addRow($data);
            }
        }
    }
    $csv->close();
    return $filename;
}

function YES_PAYMODULE_products_fake_sets_csv_export_get_products_fakeset_data(int $products_id){
            $query = xtc_db_query(sprintf(
                    "SELECT * FROM products_fake_sets WHERE products_id='%s'",
                    $products_id
            ));
            if(!xtc_db_num_rows($query)){
                return array();
            }
            return xtc_db_fetch_array($query);
}

function YES_PAYMODULE_products_fake_sets_csv_export_v2($shippings,$filename){
    $products = array();
    foreach($shippings as $sh){
        foreach($sh->products_to_ship as $sp){
            $fs = YES_PAYMODULE_products_fake_sets_csv_export_get_products_fakeset_data($sp->getProducts_id());
            if(!sizeOf($fs)){
                continue;
            }
            if(!isset($products[$sp->getProducts_id()])){
                $products[ $sp->getProducts_id() ] = array(
                    'products_id'=>$sp->getProducts_id(),
                    'name'=>$sp->source_product['name']
                );
            }
            $pqty = $sp->getQuantity();
            for($i=1;$i<=5;$i++){
                if($fs['qty_'.$i] == 0){
                    continue;
                }
                if(!isset($products[ $sp->getProducts_id() ]['artnr_'.$i])){
                    $products[ $sp->getProducts_id() ]['artnr_'.$i] = $fs['artnr_'.$i];
                }
                if(!isset($products[ $sp->getProducts_id() ]['qty_'.$i])){
                    $products[ $sp->getProducts_id() ]['qty_'.$i] = 0;
                }
                $products[ $sp->getProducts_id() ]['qty_'.$i] += $fs['qty_'.$i]*$pqty;
            }
        }
    }
    return YES_PAYMODULE_products_fake_sets_csv_export_write($products,$filename);
}

/**
 * VERALTETE FUNKTION, NACH v2 shipping Modul unnuetz
 * @param type $shippings_array
 * @param type $filename
 * @return string
 */

function YES_PAYMODULE_products_fake_sets_csv_export($shippings_array,$filename){
    $products = array();
    foreach($shippings_array as $versender=>$shippings){
	foreach($shippings as $ship){
	    switch($ship['reclamations_id']){
		case 0:
		    if(yes_count_shippable_order_products($ship['orders_id']) < 1){
			    continue;
		    }
		    $order = new order($ship['orders_id']);
		    if(!is_array($order->products)){
			continue;
		    }
		    foreach($order->products as $k => $product) {
                        $fs = YES_PAYMODULE_products_fake_sets_csv_export_get_products_fakeset_data($product['id']);
			if(!sizeOf($fs)){
			    continue;
			}
			if(!isset($products[$product['id']])){
			    $products[ $product['id'] ] = array(
				'products_id'=>$product['id'],
				'name'=>$product['name']
			    );
			}
			$record = $fs;
			$pqty = $product['qty'] - $product['quantity_shipped'] - $product['not_ship'];
			for($i=1;$i<=5;$i++){
			    if($record['qty_'.$i] == 0){
				continue;
			    }
			    if(!isset($products[ $product['id'] ]['artnr_'.$i]))
				$products[ $product['id'] ]['artnr_'.$i] = $record['artnr_'.$i];
			    if(!isset($products[ $product['id'] ]['qty_'.$i]))
				    $products[ $product['id'] ]['qty_'.$i] = 0;
			    $products[ $product['id'] ]['qty_'.$i] += $record['qty_'.$i]*$pqty;
			}
		    }
		    break;
		default:
		    $reclamation = new reclamation($ship['reclamations_id']);
		    if(!is_array($reclamation->products)){
			continue;
		    }
                    
                    // AUSSCHLUSS VON DEFEKT/ERSATZTEILVERSAND
                    // TICKET 2611
                    if($reclamation->info['reclamations_type'] != 3){
                        continue;
                    }
                    
		    foreach($reclamation->products as $k => $product) {
			$query = xtc_db_query(sprintf(
				"SELECT * FROM products_fake_sets WHERE products_id='%s'",
				$product['id']
			));
			if(!xtc_db_num_rows($query)){
			    continue;
			}
			if(!isset($products[ $product['id'] ])){
			    $products[ $product['id'] ] = array(
				'products_id'=>$product['id'],
				'name'=>$product['name']
			    );
			}
			$record = xtc_db_fetch_array($query);
			for($i=1;$i<=5;$i++){
			    if($record['qty_'.$i] == 0){
				continue;
			    }
			    if(!isset($products[ $product['id'] ]['artnr_'.$i])){
				$products[ $product['id'] ]['artnr_'.$i] = $record['artnr_'.$i];
			    }
			    if(!isset($products[ $product['id'] ]['qty_'.$i]))
				    $products[ $product['id'] ]['qty_'.$i] = 0;
			    $products[ $product['id'] ]['qty_'.$i] += $record['qty_'.$i]*$product['qty'];
			}
		    }
		    break;
	    }
	}
    }
    if(sizeOf($products)){
        return YES_PAYMODULE_products_fake_sets_csv_export_write($products,$filename);
    }
    return ''; // kein resultat = kein filename wiedergeben
}