<?php
/* -----------------------------------------------------------------------------------------
   $Id: create_account.php,v 1.39 2020/02/11 13:02:49 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(create_account.php,v 1.63 2003/05/28); www.oscommerce.com
   (c) 2003  nextcommerce (create_account.php,v 1.27 2003/08/24); www.nextcommerce.org 

   Released under the GNU General Public License 
   -----------------------------------------------------------------------------------------
   Third Party contribution:

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org


   Released under the GNU General Public License
   ---------------------------------------------------------------------------------------*/
include( 'includes/application_top.php');
require_once(DIR_WS_CLASSES.'yesCaptcha.php');
$captcha_lang = (isset($_SESSION['language']) and $_SESSION['language'] == 'english') ? 'english' : 'german';
$captcha = new yesTextCaptcha($captcha_lang);

 // create smarty elements
$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_radio_field.inc.php');
require_once(DIR_FS_INC . 'xtc_get_country_list.inc.php');
require_once(DIR_FS_INC . 'xtc_get_countries.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_checkbox_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_password_field.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_pull_down_menu.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid.inc.php');
require_once(DIR_FS_INC . 'xtc_get_geo_zone_code.inc.php');
require_once(DIR_FS_INC . 'yes_get_shop_content.inc.php');
require_once(DIR_FS_INC . 'yes_check_vat_id.inc.php');
require_once(DIR_WS_CLASSES.'yes_input_field.php');
require_once(DIR_WS_CLASSES . 'class.phpmailer.php');
require_once(DIR_FS_INC . 'xtc_create_password.inc.php');

require_once(DIR_FS_INC . 'xtc_render_vvcode.inc.php');
require_once(DIR_FS_INC . 'xtc_random_charcode.inc.php');
require_once(DIR_FS_INC . 'yes_customers_email_alias_functions.inc.php');
if(isset($_GET['action']) and $_GET['action'] == 'check_capture'){
    die(json_encode(array(
        'IS_VALID'=>$_GET['vvcode'] == $_SESSION['vvcode']
    )));
}

if(defined('YES_CREATE_ACCOUNT_V2') and YES_CREATE_ACCOUNT_V2 == 'True'){
    require('create_account2.php');
    exit;
}


$dob = false;
$process = false;
if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    $error = false;
    $process = true;
    if (ACCOUNT_GENDER == 'true') $gender = xtc_db_input($_POST['gender']);
    $firstname = xtc_db_input($_POST['firstname']);
    $lastname = xtc_db_input($_POST['lastname']);
    
    if (isset($_REQUEST['dob']) and $_REQUEST['dob'] != ''){
	$dob = xtc_db_input($_POST['dob']);
    }
    
    $email_address = xtc_db_input($_POST['email_address']);
    if (ACCOUNT_COMPANY == 'true') $company = xtc_db_input($_POST['company']);
    if (ACCOUNT_COMPANY_VAT_CHECK == 'true') $vat = xtc_db_input($_POST['vat']);
    $street_address = xtc_db_input($_POST['street_address']);
    if (ACCOUNT_SUBURB == 'true') $suburb = xtc_db_input($_POST['suburb']);
    $postcode = xtc_db_input($_POST['postcode']);
    $city = xtc_db_input($_POST['city']);
    $zone_id = (int)xtc_db_input($_POST['zone_id']);
    if (ACCOUNT_STATE == 'true') $state = xtc_db_input($_POST['state']);
    $country = (int)xtc_db_input($_POST['country']);
    $telephone = xtc_db_input($_POST['telephone']);
    $fax = xtc_db_input($_POST['fax']);
    $newsletter = xtc_db_input($_POST['newsletter']);
    $password = xtc_db_input($_POST['password']);
    $confirmation = xtc_db_input($_POST['confirmation']);
    
    $msg = $captcha->check(false); // false = _POST
    if(isset($_POST['captcha_result'])){
        $captcha_success = ($msg == $captcha->lng['captcha_incorrect']) ? false : true;
    }else{
        $captcha_success = $_POST['vvcode'] == $_SESSION['vvcode'];
    }
    
    if(!$captcha_success){
            // error report hier einbauen
            $messageStack->add('create_account',ERROR_CAPTCHA);
            $error = true;
    }else{
        
        if (ACCOUNT_GENDER == 'true') {
          if ( ($gender != 'm') && ($gender != 'f') ) {
            $error = true;

            $messageStack->add('create_account', ENTRY_GENDER_ERROR);
          }
        }

        if (strlen($firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_FIRST_NAME_ERROR);
        }

        if (strlen($lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_LAST_NAME_ERROR);
        }

        if (ACCOUNT_DOB == 'true' and ENTRY_DOB_MIN_LENGTH > 0) {
          if (checkdate(substr(xtc_date_raw($dob), 4, 2), substr(xtc_date_raw($dob), 6, 2), substr(xtc_date_raw($dob), 0, 4)) == false) {
            $error = true;

            $messageStack->add('create_account', ENTRY_DATE_OF_BIRTH_ERROR);
          }
        }
        if(ACCOUNT_DOB != 'true' and $dob){
          if (checkdate(substr(xtc_date_raw($dob), 4, 2), substr(xtc_date_raw($dob), 6, 2), substr(xtc_date_raw($dob), 0, 4)) == false) {
            $error = true;

            $messageStack->add('create_account', ENTRY_DATE_OF_BIRTH_ERROR);
          }
        }
            if(isset($_REQUEST['check_privacy']) and $_REQUEST['check_privacy'] == 1){
                    if(!isset($_REQUEST['privacy']) or $_REQUEST['privacy'] != '1'){
                            $error = true;
                            $messageStack->add('create_account', ENTRY_PRIVACY_ERROR);
                    }
            }

    // Vat Check
    // gehoert das Land NICHT zu "Steuerzone EU-Ausland"?
    if(xtc_get_geo_zone_code($country) != '6'){
        // wurde eine UST ID UEBERGEBEN?
        if ($vat !=''){
            // soll die UST ID geprueft werden?
            if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
                $validate_vatid = validate_vatid($vat);
                if ($validate_vatid == '0') {
                    // wenn die Validierung der UST ID fehlgeschlagen ist
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $messageStack->add('create_account', ENTRY_VAT_ERROR);
                        $error = true;
                    }
                    $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
                    $customers_vat_id_status  = '0';
                }
                // wenn die Validierung der UST-ID erfolgreich war
                if($validate_vatid == '1') {
                    if ($country == '81'){
                        // ist das Land DEUTSCHLAND? Dann normale Kundengruppe
                        if (ACCOUNT_COMPANY_VAT_GROUP == 'true'){
                            // Kunde erhaelt die hinterlegten Kundengruppe
                            // fuer UST-ID
                            $customer_group = DEFAULT_CUSTOMERS_VAT_STATUS_ID_LOCAL;
                        }else{
                            // Kunde erhaelt normale Kundengruppe
                            $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
                        }
                    }else{
                        // Land ist NICHT Deutschland
                        // wenn "Kundengruppe nach UST ID Check anpassen?" aktiv 
                        if (ACCOUNT_COMPANY_VAT_GROUP == 'true'){
                            // Kunde erhaelt die hinterlegten Kundengruppe
                            // fuer UST-ID
                            $customer_group = DEFAULT_CUSTOMERS_VAT_STATUS_ID;
                        }else{
                            // Kunde erhaelt normale Kundengruppe
                            $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
                        }
                    }
                    $customers_vat_id_status  = '1';
                }
                // Validierung der UST-ID ergab eine 8
                // scheint irgendein Standard zu sein, ich hab keine Ahnung was
                // eine 8 ist
                // Die Live abfrage findet hierdrueber statt
                // http://evatr.bff-online.de/eVatR/
                if($validate_vatid == '8'){
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                       $messageStack->add('create_account', ENTRY_VAT_ERROR);
                        $error = true;
                    }
                    // Kunde erhaelt normale Kundengruppe
                    $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
                    $customers_vat_id_status  = '8';
                }

                // Validierung der UST-ID ergab eine 9
                // scheint irgendein Standard zu sein, ich hab keine Ahnung was
                // eine 9 ist
                // Die Live abfrage findet hierdrueber statt
                // http://evatr.bff-online.de/eVatR/
                if($validate_vatid == '9'){
                    if (ACCOUNT_VAT_BLOCK_ERROR == 'true'){
                        $messageStack->add('create_account', ENTRY_VAT_ERROR);
                        $error = true;
                    }
                    // Kunde erhaelt normale Kundengruppe
                    $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
                    $customers_vat_id_status  = '9';
                }
            }else {
                // UST ID soll nicht geprueft werden - Normale Kundengruppe
                $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
            }
        }else{
            // Keine UST ID uebergeben - Normale Kundengruppe
            $customer_group = DEFAULT_CUSTOMERS_STATUS_ID;
        }
    }
    // Vat Check
        if (strlen($email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR);
        } elseif (xtc_validate_email($email_address) == false) {
          $error = true;

          $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
        } else {
            $check_email = yes_query(sprintf(
                "select count(*) as total from %s where customers_email_address =:email AND customers_status != 1",
                    TABLE_CUSTOMERS
                ),['email'=>$email_address],true
            );
            yes_debug($check_email);exit;
            if ($check_email['total'] > 0) {
                $error = true;
                $messageStack->add('create_account', ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
            }
        }

        if (strlen($street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_STREET_ADDRESS_ERROR);
        }

        if (strlen($postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_POST_CODE_ERROR);
        }

        if (strlen($city) < ENTRY_CITY_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_CITY_ERROR);
        }

        if (is_numeric($country) == false) {
          $error = true;

          $messageStack->add('create_account', ENTRY_COUNTRY_ERROR);
        }

        if (ACCOUNT_STATE == 'true') {
          $zone_id = 0;
          $check_query = xtc_db_query("select count(*) as total from " . TABLE_ZONES . " where zone_country_id = '" . $country . "'");
          $check = xtc_db_fetch_array($check_query);
          $entry_state_has_zones = ($check['total'] > 0);
          if ($entry_state_has_zones == true) {
            $zone_query = xtc_db_query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . $country . "' and (zone_name like '" . $state . "%' or zone_code like '%" . $state . "%')");
            if (xtc_db_num_rows($zone_query) > 1) {
            $zone_query = xtc_db_query("select distinct zone_id from " . TABLE_ZONES . " where zone_country_id = '" . $country . "' and zone_name = '" . $state . "'");
            }
            if (xtc_db_num_rows($zone_query) >= 1) {
              $zone = xtc_db_fetch_array($zone_query);
              $zone_id = $zone['zone_id'];
            } else {
              $error = true;

              $messageStack->add('create_account', ENTRY_STATE_ERROR_SELECT);
            }
          } else {
            if (strlen($state) < ENTRY_STATE_MIN_LENGTH) {
              $error = true;

              $messageStack->add('create_account', ENTRY_STATE_ERROR);
            }
          }
        }

        if (strlen($telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_TELEPHONE_NUMBER_ERROR);
        }


        if (strlen($password) < ENTRY_PASSWORD_MIN_LENGTH) {
          $error = true;

          $messageStack->add('create_account', ENTRY_PASSWORD_ERROR);
        } elseif ($password != $confirmation) {
          $error = true;

          $messageStack->add('create_account', ENTRY_PASSWORD_ERROR_NOT_MATCHING);
        }
        if(isset($_POST['newsletter']) and $_POST['newsletter'] == '1'){
            $newsletter = '1';
        }else{
            $newsletter = '0';
        }
    }

    if ($error == false) {
	if(!isset($customer_group)){
		$customers_status = DEFAULT_CUSTOMERS_STATUS_ID;
	}else{
		$customers_status = $customer_group;
	}
	if($customers_status == '' or $customers_status == 0){
		$customers_status = 1; // WORKAROUND - NIEMALS ADMIN!
	}
      	$sql_data_array = array('customers_vat_id' => $vat,
                              'customers_vat_id_status' => $customers_vat_id_status,
                              'customers_status' => $customers_status,
                              'customers_firstname' => $firstname,
                              'customers_lastname' => $lastname,
                              'customers_email_address' => $email_address,
                              'customers_telephone' => $telephone,
                              'customers_fax' => $fax,
                              'customers_newsletter' => $newsletter,
                              'customers_password' => xtc_encrypt_password($password));

	if (ACCOUNT_GENDER == 'true') $sql_data_array['customers_gender'] = $gender;
	if($dob != ''){
	      $sql_data_array['customers_dob'] = xtc_date_raw($dob);
	}else{
	      $sql_data_array['customers_dob'] = '';
	}

      xtc_db_perform(TABLE_CUSTOMERS, $sql_data_array);
      $_SESSION['customer_id'] = xtc_db_insert_id();
      $user_id=xtc_db_insert_id();
                // LOGGING FUER SUCHE NACH DER STELLE WO ADMIN USER BEI
                // SHOPKAUF ERZEUGT WIRD - TICKET 2921
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id'=>(int)$user_id,
                    'memo_date'=>date('Y-m-d H:i:s'),
                    'memo_title'=>'Erzeugt mit customers_status='.$customers_status,
                    'memo_text'=>'create account',
                    'poster_id'=>0
                ]);
                $new->create();
      
      // BOF - customers_email_alias
      yes_remove_customers_email_alias($email_address, $user_id);
      // EOF - customers_email_alias
      
      xtc_write_user_info($user_id);
      $sql_data_array = array(
          'customers_id' => (int)$_SESSION['customer_id'],
          'entry_firstname' => $firstname,
          'entry_lastname' => $lastname,
          'entry_street_address' => $street_address,
          'entry_postcode' => $postcode,
          'entry_city' => $city,
          'entry_country_id' => (int)$country
      );

      if (ACCOUNT_GENDER == 'true') {
          $sql_data_array['entry_gender'] = $gender;
      }
      if (ACCOUNT_COMPANY == 'true') {
          $sql_data_array['entry_company'] = $company;
      }
      if (ACCOUNT_SUBURB == 'true') {
          $sql_data_array['entry_suburb'] = $suburb;
      }
      if (ACCOUNT_STATE == 'true') {
        if ($zone_id > 0) {
            $sql_data_array['entry_zone_id'] = (int)$zone_id;
            $sql_data_array['entry_state'] = '';
        } else {
            $sql_data_array['entry_zone_id'] = 0;
            $sql_data_array['entry_state'] = $state;
        }
      }
      $new = new \YES4Trade\Model\address_book($sql_data_array);
      $address_id = $new->create();

      xtc_db_query("update " . TABLE_CUSTOMERS . " set customers_default_address_id = '" . $address_id . "' where customers_id = '" . (int)$_SESSION['customer_id'] . "'");

      xtc_db_query("insert into " . TABLE_CUSTOMERS_INFO . " (customers_info_id, customers_info_number_of_logons, customers_info_date_account_created) values ('" . (int)$_SESSION['customer_id'] . "', '0', now())");
      
      // history
      $new = new \YES4Trade\Model\customers_memo([
          'customers_id'=>(int)$_SESSION['customer_id'],
          'memo_date'=>date('Y-m-d H:i:s'),
          'memo_title'=>'User angelegt',
          'memo_text'=>'Im Shop registriert.',
          'poster_id'=>0
      ]);
      $new->create();
      
      if (SESSION_RECREATE == 'True') {
        xtc_session_recreate();
      }

      $_SESSION['customer_first_name'] = $firstname;
      $_SESSION['customer_last_name'] = $lastname;
      $_SESSION['customer_default_address_id'] = $address_id;
      $_SESSION['customer_country_id'] = $country;
      $_SESSION['customer_zone_id'] = $zone_id;

      // restore cart contents
      $_SESSION['cart']->restore_contents();

      // build the message content
      $name = $firstname . ' ' . $lastname;


      // load data into array
      $module_content = array();
      $module_content = array(
        'MAIL_NAME' => $name,
	'CID' => $_SESSION['customer_id'],
        'MAIL_REPLY_ADDRESS' => EMAIL_SUPPORT_REPLY_ADDRESS,
        'MAIL_GENDER'=>$gender);

      // assign data to smarty
	$smarty = new yesSmarty;
      $smarty->assign('language', $_SESSION['language']);
      $smarty->assign('logo_path',HTTP_SERVER.DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
      $smarty->assign('content', $module_content);
      $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
      $smarty->caching = false;


      // GV Code Start
            // ICW - CREDIT CLASS CODE BLOCK ADDED  ******************************************************* BEGIN
              if (NEW_SIGNUP_GIFT_VOUCHER_AMOUNT > 0) {
                $coupon_code = create_coupon_code();
                $insert_query = xtc_db_query("insert into " . TABLE_COUPONS . " (coupon_code, coupon_type, coupon_amount, date_created) values ('" . $coupon_code . "', 'G', '" . NEW_SIGNUP_GIFT_VOUCHER_AMOUNT . "', now())");
                $insert_id = xtc_db_insert_id($insert_query);
                $insert_query = xtc_db_query("insert into " . TABLE_COUPON_EMAIL_TRACK . " (coupon_id, customer_id_sent, sent_firstname, emailed_to, date_sent) values ('" . $insert_id ."', '0', 'Admin', '" . $email_address . "', now() )");


                $smarty->assign('SEND_GIFT','true');
                $smarty->assign('GIFT_AMMOUNT',$xtPrice->xtcFormat(NEW_SIGNUP_GIFT_VOUCHER_AMOUNT,true));
                $smarty->assign('GIFT_CODE',$coupon_code);
                $smarty->assign('GIFT_LINK',xtc_href_link(FILENAME_GV_REDEEM, 'gv_no=' . $coupon_code,'NONSSL', false));

              }
              if (NEW_SIGNUP_DISCOUNT_COUPON != '') {
                $coupon_code = NEW_SIGNUP_DISCOUNT_COUPON;
                $coupon_query = xtc_db_query("select * from " . TABLE_COUPONS . " where coupon_code = '" . $coupon_code . "'");
                $coupon = xtc_db_fetch_array($coupon_query);
                $coupon_id = $coupon['coupon_id'];
                $coupon_desc_query = xtc_db_query("select * from " . TABLE_COUPONS_DESCRIPTION . " where coupon_id = '" . $coupon_id . "' and language_id = '" . (int)$_SESSION['languages_id'] . "'");
                $coupon_desc = xtc_db_fetch_array($coupon_desc_query);
                $insert_query = xtc_db_query("insert into " . TABLE_COUPON_EMAIL_TRACK . " (coupon_id, customer_id_sent, sent_firstname, emailed_to, date_sent) values ('" . $coupon_id ."', '0', 'Admin', '" . $email_address . "', now() )");

                $smarty->assign('SEND_COUPON','true');
                $smarty->assign('COUPON_DESC',$coupon_desc['coupon_description']);
                $smarty->assign('COUPON_CODE',$coupon['coupon_code']);

              }
            
  	      $smarty->assign('STORE_NAME_ADDRESS',STORE_NAME_ADDRESS);
  	      $smarty->assign('STORE_NAME',STORE_NAME);
	      
	    // ICW - CREDIT CLASS CODE BLOCK ADDED  ******************************************************* END
            // GV Code End       // create templates
      $smarty->caching = 0;
      $html_mail = $smarty->fetch(CURRENT_TEMPLATE . '/mail/'.$_SESSION['language'].'/create_account_mail.html');
      $smarty->caching = 0;
      $txt_mail = $smarty->fetch(CURRENT_TEMPLATE . '/mail/'.$_SESSION['language'].'/create_account_mail.txt');

      xtc_php_mail(EMAIL_SUPPORT_ADDRESS,EMAIL_SUPPORT_NAME,$email_address , $name , EMAIL_SUPPORT_FORWARDING_STRING, EMAIL_SUPPORT_REPLY_ADDRESS, EMAIL_SUPPORT_REPLY_ADDRESS_NAME, '', '', EMAIL_SUPPORT_SUBJECT, $html_mail, $txt_mail);

	if ($newsletter == 1) {

		require_once (DIR_WS_CLASSES.'class.newsletter.php');
		$newsletter = new newsletter;

		$newsletter->AddUserAuto($email_address);

	}


	if (!isset($mail_error)) {
		if(PAGE_AFTER_REGISTRATION > 0){
			xtc_redirect(xtc_href_link('shop_content.php', 'coID='.PAGE_AFTER_REGISTRATION, 'NONSSL'));
		}else{
		    //BURAK - ANWEISUNG VOM 24.02.14, FUER ALLE KUNDEN - IMMER AUF WARENKORB NACH REGISTRATION
                    //BURAK - NEUE ANWEISUNG VOM 27.10.17, WIEDER REIN - AUSSERDEM NEUER WERT -1
                    if (PAGE_AFTER_REGISTRATION == -1 and isset($_SESSION['cart']) and $_SESSION['cart']->count_contents() > 0){
                            xtc_redirect(xtc_href_link(FILENAME_CHECKOUT_SHIPPING));
                    }
                    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART, '', 'SSL'));
		}
	}else{
		echo $mail_error;
	}
  }
}
$breadcrumb->add(NAVBAR_TITLE_CREATE_ACCOUNT, xtc_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'));
require(DIR_WS_INCLUDES . 'header.php');
if ($messageStack->size('create_account') > 0) {
    $smarty->assign('error',$messageStack->output('create_account'));
}

$smarty->assign('FORM_ACTION',xtc_draw_form('create_account', xtc_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'), 'post', 'onSubmit="return check_form(\'create_account\');"') . xtc_draw_hidden_field('action', 'process'));

if (ACCOUNT_GENDER == 'true') {
    $smarty->assign(array(
	'gender'=>'1',
	'INPUT_GENDER_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'gender',
	    'label'=>ENTRY_GENDER,
	    'type'=>'radio',
	    'required'=>true,
	    'required_text'=>ENTRY_GENDER_TEXT,
	    'values'=>array(
		array(
		    'label'=>MALE,
		    'value'=>'m'
		),
		array(
		    'label'=>FEMALE,
		    'value'=>'f'
		)
	    )
	)),
	'INPUT_MALE'=>xtc_draw_radio_field('gender', 'm'),
	'INPUT_FEMALE'=>xtc_draw_radio_field('gender', 'f').(xtc_not_null(ENTRY_GENDER_TEXT) ? '<span class="inputRequirement">' . ENTRY_GENDER_TEXT . '</span>': '')
    ));
} else {
    $smarty->assign('gender','0');
}

if (ACCOUNT_COMPANY == 'true') {
    $smarty->assign(array(
	'company'=>'1',
	'INPUT_COMPANY'=>xtc_draw_input_field('company') . '&nbsp;' . (xtc_not_null(ENTRY_COMPANY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COMPANY_TEXT . '</span>': ''),
	'INPUT_COMPANY_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'company',
	    'label'=>ENTRY_COMPANY,
	    'type'=>'text',
	    'required'=>((defined('ENTRY_COMPANY_MIN_LENGTH') and ENTRY_COMPANY_MIN_LENGTH > 0) ? true : false),
	    'minlength'=>ENTRY_COMPANY_MIN_LENGTH,
	    'maxlength'=>64,
	    'placeholder'=>(defined('ENTRY_COMPANY_PLACEHOLDER') and ENTRY_COMPANY_PLACEHOLDER != '') ? ENTRY_COMPANY_PLACEHOLDER : '',
	    'required_text'=>ENTRY_COMPANY_TEXT
	))
    ));
}  else {
    $smarty->assign('company','0');
}

$dob_str = (ACCOUNT_DOB == 'true' and xtc_not_null(ENTRY_DATE_OF_BIRTH_TEXT)) ? '&nbsp;<span class="inputRequirement">' . ENTRY_DATE_OF_BIRTH_TEXT . '</span>': '';
if (isset($_POST['country'])){
	$selected_country = (int)xtc_db_input($_POST['country']);
}else{
	$selected_country = STORE_COUNTRY;
}
$countries_array = xtc_get_countries();
$countries = array();
foreach($countries_array as $c){
    $countries[] = array('id'=>$c['countries_id'],'name'=>xtc_db_prepare_input($c['countries_name']));
}
$smarty->assign(array(
    'INPUT_FIRSTNAME'=>xtc_draw_input_field('firstname') . '&nbsp;' . (xtc_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''),
    'INPUT_FIRSTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'firstname',
	'label'=>ENTRY_FIRST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_FIRST_NAME_MIN_LENGTH') and ENTRY_FIRST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_FIRST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_FIRST_NAME_PLACEHOLDER') and ENTRY_FIRST_NAME_PLACEHOLDER != '') ? ENTRY_FIRST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_FIRST_NAME_TEXT
    )),
    'INPUT_LASTNAME'=>xtc_draw_input_field('lastname') . '&nbsp;' . (xtc_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="inputRequirement">' . ENTRY_LAST_NAME_TEXT . '</span>': ''),
    'INPUT_LASTNAME_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'lastname',
	'label'=>ENTRY_LAST_NAME,
	'type'=>'text',
	'required'=>((defined('ENTRY_LAST_NAME_MIN_LENGTH') and ENTRY_LAST_NAME_MIN_LENGTH > 0) ? true : false),
	'minlength'=>ENTRY_LAST_NAME_MIN_LENGTH,
	'maxlength'=>64,
	'placeholder'=>(defined('ENTRY_LAST_NAME_PLACEHOLDER') and ENTRY_LAST_NAME_PLACEHOLDER != '') ? ENTRY_LAST_NAME_PLACEHOLDER : '',
	'required_text'=>ENTRY_LAST_NAME_TEXT
    )),
    'birthdate'=>'1',
    'INPUT_DOB'=>xtc_draw_input_field('dob').$dob_str,
    'INPUT_DOB_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'dob',
	'label'=>ENTRY_DATE_OF_BIRTH,
	'type'=>'date',
	'required'=>((ACCOUNT_DOB == 'true') ? true : false),
	'maxlength'=>10,
	'minlength'=>ENTRY_DOB_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_DOB_PLACEHOLDER') and ENTRY_DOB_PLACEHOLDER != '') ? ENTRY_DOB_PLACEHOLDER : ''
    )),
    'INPUT_EMAIL'=>xtc_draw_input_field('email_address') . '&nbsp;' . (xtc_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_EMAIL_ADDRESS_TEXT . '</span>': ''),
    'INPUT_EMAIL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'email_address',
	'label'=>ENTRY_EMAIL_ADDRESS,
	'type'=>'email',
	'required'=>true,
	'maxlength'=>255,
	'minlength'=>ENTRY_EMAIL_ADDRESS_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_EMAIL_ADDRESS_PLACEHOLDER') and ENTRY_EMAIL_ADDRESS_PLACEHOLDER != '') ? ENTRY_EMAIL_ADDRESS_PLACEHOLDER : '',
	'required_text'=>ENTRY_EMAIL_ADDRESS_TEXT
    )),
    'INPUT_STREET'=>xtc_draw_input_field('street_address') . '&nbsp;' . (xtc_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="inputRequirement">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''),
    'INPUT_STREET_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'street_address',
	'label'=>ENTRY_STREET_ADDRESS,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_STREET_ADDRESS_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_STREET_ADDRESS_PLACEHOLDER') and ENTRY_STREET_ADDRESS_PLACEHOLDER != '') ? ENTRY_STREET_ADDRESS_PLACEHOLDER : '',
	'required_text'=>ENTRY_STREET_ADDRESS_TEXT
    )),
    'INPUT_CODE'=>xtc_draw_input_field('postcode') . '&nbsp;' . (xtc_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="inputRequirement">' . ENTRY_POST_CODE_TEXT . '</span>': ''),
    'INPUT_CODE_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'postcode',
	'label'=>ENTRY_POST_CODE,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>16,
	'minlength'=>ENTRY_POSTCODE_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_POSTCODE_PLACEHOLDER') and ENTRY_POSTCODE_PLACEHOLDER != '') ? ENTRY_POSTCODE_PLACEHOLDER : '',
	'required_text'=>ENTRY_POST_CODE_TEXT
    )),
    'INPUT_CITY'=>xtc_draw_input_field('city') . '&nbsp;' . (xtc_not_null(ENTRY_CITY_TEXT) ? '<span class="inputRequirement">' . ENTRY_CITY_TEXT . '</span>': ''),
    'INPUT_CITY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'city',
	'label'=>ENTRY_CITY,
	'type'=>'text',
	'required'=>true,
	'maxlength'=>128,
	'minlength'=>ENTRY_CITY_MIN_LENGTH,
	'placeholder'=>(defined('ENTRY_CITY_PLACEHOLDER') and ENTRY_CITY_PLACEHOLDER != '') ? ENTRY_CITY_PLACEHOLDER : '',
	'required_text'=>ENTRY_CITY_TEXT
    )),
    'SELECT_COUNTRY'=>xtc_get_country_list('country', $selected_country) . '&nbsp;' . (xtc_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="inputRequirement">' . ENTRY_COUNTRY_TEXT . '</span>': ''),
    'INPUT_COUNTRY_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'country',
	'label'=>ENTRY_COUNTRY,
	'type'=>'select',
	'required'=>true,
	'default_value'=>$selected_country,
	'options'=>  $countries,
	'required_text'=>ENTRY_COUNTRY_TEXT
    )),
    'INPUT_TEL'=>xtc_draw_input_field('telephone') . '&nbsp;' . ((ENTRY_TELEPHONE_MIN_LENGTH>0) ? '<span class="inputRequirement">' . ENTRY_TELEPHONE_NUMBER_TEXT . '</span>': ''),
    'INPUT_TEL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'telephone',
	'label'=>ENTRY_TELEPHONE_NUMBER,
	'type'=>'tel',
	'required'=>(ENTRY_TELEPHONE_MIN_LENGTH>0)?true:false,
	'minlength'=>ENTRY_TELEPHONE_MIN_LENGTH,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_TELEPHONE_PLACEHOLDER') and ENTRY_TELEPHONE_PLACEHOLDER != '') ? ENTRY_TELEPHONE_PLACEHOLDER : '',
	'required_text'=>ENTRY_TELEPHONE_NUMBER_TEXT
    )),
    'INPUT_FAX'=>xtc_draw_input_field('fax') . '&nbsp;' . (xtc_not_null(ENTRY_FAX_NUMBER_TEXT) ? '<span class="inputRequirement">' . ENTRY_FAX_NUMBER_TEXT . '</span>': ''),
    'INPUT_FAX_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'fax',
	'label'=>ENTRY_FAX_NUMBER,
	'type'=>'tel',
	'required'=>false,
	'maxlength'=>32,
	'placeholder'=>(defined('ENTRY_FAX_NUMBER_PLACEHOLDER') and ENTRY_FAX_NUMBER_PLACEHOLDER != '') ? ENTRY_FAX_NUMBER_PLACEHOLDER : '',
	'required_text'=>ENTRY_FAX_NUMBER_TEXT
    )),
    'CHECKBOX_NEWSLETTER'=>xtc_draw_checkbox_field('newsletter', '1') . '&nbsp;' . (xtc_not_null(ENTRY_NEWSLETTER_TEXT) ? '<span class="inputRequirement">' . ENTRY_NEWSLETTER_TEXT . '</span>': ''),
    'INPUT_NEWSLETTER_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'newsletter',
	'label'=>ENTRY_NEWSLETTER,
	'type'=>'checkbox',
	'required'=>false,
	'value'=>'1'
    )),
    'INPUT_PASSWORD'=>xtc_draw_password_field('password') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_TEXT . '</span>': ''),
    'INPUT_PASSWORD_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'password',
	'label'=>ENTRY_PASSWORD,
	'type'=>'password',
	'required'=>true,
	'required_text'=>ENTRY_PASSWORD_TEXT
    )),
    'INPUT_CONFIRMATION'=>xtc_draw_password_field('confirmation') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_CONFIRMATION_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_CONFIRMATION_TEXT . '</span>': ''),
    'INPUT_CONFIRMATION_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'confirmation',
	'label'=>ENTRY_PASSWORD_CONFIRMATION,
	'type'=>'password',
	'required'=>true,
	'required_text'=>ENTRY_PASSWORD_CONFIRMATION_TEXT
    ))
));

if (ACCOUNT_COMPANY_VAT_CHECK == 'true') {
    $smarty->assign(array(
	'vat'=>'1',
	'INPUT_VAT'=>xtc_draw_input_field('vat') . '&nbsp;' . (xtc_not_null(ENTRY_VAT_TEXT) ? '<span class="inputRequirement">' . ENTRY_VAT_TEXT . '</span>': ''),
	'INPUT_VAT_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'vat',
	    'label'=>ENTRY_VAT_ID,
	    'type'=>'text',
	    'required'=>false,
	    'maxlength'=>20,
	    'minlength'=>1,
	    'placeholder'=>(defined('ENTRY_VAT_ID_PLACEHOLDER') and ENTRY_VAT_ID_PLACEHOLDER != '') ? ENTRY_VAT_ID_PLACEHOLDER : '',
	    'required_text'=>ENTRY_VAT_TEXT
	))
    ));
}  else {
    $smarty->assign('vat','0');
}

if (ACCOUNT_SUBURB == 'true') {
    $smarty->assign(array(
	'suburb'=>'1',
	'INPUT_SUBURB'=>xtc_draw_input_field('suburb') . '&nbsp;' . (xtc_not_null(ENTRY_SUBURB_TEXT) ? '<span class="inputRequirement">' . ENTRY_SUBURB_TEXT . '</span>': ''),
	'INPUT_SUBURB_ARRAY'=>yes_input_field::get_html(array(
	    'name'=>'suburb',
	    'label'=>ENTRY_SUBURB,
	    'type'=>'text',
	    'required'=>false,
	    'maxlength'=>128,
	    'placeholder'=>(defined('ENTRY_SUBURB_PLACEHOLDER') and ENTRY_SUBURB_PLACEHOLDER != '') ? ENTRY_SUBURB_PLACEHOLDER : '',
	    'required_text'=>ENTRY_SUBURB_TEXT
	))
    ));
} else {
    $smarty->assign('suburb','0');
}

if (ACCOUNT_STATE == 'true') {
    $zones_array = array();
    if ($process == true) {
	if ($entry_state_has_zones == true) {
	    $zones_query = xtc_db_query("select zone_name from " . TABLE_ZONES . " where zone_country_id = '" . (int)$country . "' order by zone_name");
	    while ($zones_values = xtc_db_fetch_array($zones_query)) {
	      $zones_array[] = array('id' => $zones_values['zone_name'], 'text' => $zones_values['zone_name']);
	    }
	    $state_input= xtc_draw_pull_down_menu('state', $zones_array);
	} else {
	    $state_input= xtc_draw_input_field('state');
	}
    } else {
	$state_input= xtc_draw_input_field('state');
    }
    if (xtc_not_null(ENTRY_STATE_TEXT)) 
	$state_input.= '&nbsp;<span class="inputRequirement">' . ENTRY_STATE_TEXT;
    $smarty->assign(array(
	'state'=>'1',
	'INPUT_STATE'=>$state_input,
	'INPUT_STATE_ARRAY'=>((sizeOf($zones_array)) ? 
	    yes_input_field::get_html(array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'select',
		'required'=>(ENTRY_STATE_MIN_LENGTH > 0) ? true : false,
		'options'=>$zones_array,
		'required_text'=>ENTRY_STATE_TEXT
	    )) : yes_input_field::get_html(array(
		'name'=>'state',
		'label'=>ENTRY_STATE,
		'type'=>'text',
		'required'=>(ENTRY_STATE_MIN_LENGTH > 0) ? true : false,
		'maxlength'=>128,
		'minlength'=>ENTRY_STATE_MIN_LENGTH,
		'placeholder'=>(defined('ENTRY_SUBURB_PLACEHOLDER') and ENTRY_SUBURB_PLACEHOLDER != '') ? ENTRY_SUBURB_PLACEHOLDER : '',
		'required_text'=>ENTRY_STATE_TEXT
	    ))
	)
    ));
} else {
	$smarty->assign('state','0');
}

$shop_content_data = yes_get_shop_content(2, $_SESSION['languages_id'],true);
if (isset($shop_content_data['content_file']) and $shop_content_data['content_file']!=''){
	$privacy= '<iframe SRC="'.$shop_content_data['content_file'].'" width="100%" height="300">';
	$privacy.= '</iframe>';
	$privacy_raw = $privacy;
} else {
	$privacy= '<textarea name="blabla" cols="60" rows="10" readonly="readonly">'.  $shop_content_data['content_text'].'</textarea>';
	$privacy_raw = $shop_content_data['content_text'];
}
$smarty->caching = 0;
$smarty->assign(array(
    'PRIVACY'=>$privacy,
    'PRIVACY_RAW'=>$privacy_raw,
    'PRIVACY_checkbox'=>'<input type="checkbox" name="privacy" value="1">',
    'language'=>$_SESSION['language'],
    'FORM_END'=>'</form>',
    'BUTTON_SUBMIT'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE),
    'VVIMG'=>'<img src="' . main::get_url_with_random_params(FILENAME_DISPLAY_VVCODES) . '" />',
    'INPUT_VVCODE'=>xtc_draw_input_field('vvcode','','size="6" maxlenght="6"',false,'',false),
    'ERROR_CAPTCHA'=>ERROR_CAPTCHA,
    'YES_CAPTCHA'=>$captcha->create(),
));
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/create_account.html');
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
if (!defined('RM')) $smarty->load_filter('output', 'note');
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include ('includes/application_bottom.php');
