<?php
/* --------------------------------------------------------------
   $Id: tax_classes.php,v 1.3 2017/01/09 08:38:49 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(tax_classes.php,v 1.19 2002/03/17); www.oscommerce.com 
   (c) 2003	 nextcommerce (tax_classes.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
    if(strpos($cd->getKey(),'tax_description_')>-1 
            or strpos($cd->getKey(),'tax_rates_')>-1
            or strpos($cd->getKey(),'wishlist_taxclasses')>-1){
        $InstanceCache->deleteItem($cd->getKey()); // tax_description_*, tax_rates_*, wishlist_taxclasses
    }
}

if (isset($_GET['action'])) {
    switch ($_GET['action']) {
        case 'ajax_update':
            $id = (int)xtc_db_input($_GET['id']);
            if($id < 1){
                die(json_encode(array(
                    'MSG'=>'Missing params'
                )));
            }
            $update_sql_array = array(
                'tax_class_title'=>$_GET['tax_class_title'],
                'last_modified'=>'now()',
            );
            xtc_db_perform(TABLE_TAX_CLASS,$update_sql_array,'update',"tax_class_id='".$id."'");
            die(json_encode(array(
                'MSG'=>''
            )));
            break;
        case 'ajax_delete':
            xtc_db_query(sprintf(
                    "DELETE FROM %s WHERE tax_class_id='%d'",
                    TABLE_TAX_CLASS, (int)xtc_db_input($_GET['id'])
            ));
            xtc_db_query(sprintf(
                    "DELETE FROM %s WHERE tax_class_id='%d'",
                    TABLE_TAX_RATES, (int)xtc_db_input($_GET['id'])
            ));
            xtc_db_query(sprintf(
                    "UPDATE %s SET products_tax_class_id='0' WHERE products_tax_class_id='%d'",
                    TABLE_PRODUCTS, (int)xtc_db_input($_GET['id'])
            ));
            yes_add_history('Tax Class #'.$_GET['id'].' deleted');
            die(json_encode(array(
                'MSG'=>''
            )));
            break;
        case 'ajax_insert':
            $insert_sql_array = array(
                'tax_class_title'=>$_GET['tax_class_title'],
                'last_modified'=>'now()',
                'date_added'=>'now()',
            );
            xtc_db_perform(TABLE_TAX_CLASS,$insert_sql_array);
            die(json_encode(array(
                'MSG'=>'',
                'id'=>xtc_db_insert_id()
            )));
            break;
        case 'ajax_list':
            $tax_classes = [];
            $query = xtc_db_query(sprintf("SELECT * FROM %s ORDER BY tax_class_title",TABLE_TAX_CLASS));
            while($record = xtc_db_fetch_array($query)){
                $tax_classes[] = $record;
            }
            $smarty->assign([
                'tax_classes'=>$tax_classes,
                'TABLE_HEADING_TITLE'=>TABLE_HEADING_TITLE,
                'TABLE_HEADING_DESCRIPTION'=>TABLE_HEADING_DESCRIPTION,
                'TABLE_HEADING_DATE_MODIFIED'=>TABLE_HEADING_DATE_MODIFIED,
                'TABLE_HEADING_DATE_ADDED'=>TABLE_HEADING_DATE_ADDED,
                'TEXT_INFO_HEADING_NEW_TAX_CLASS'=>TEXT_INFO_HEADING_NEW_TAX_CLASS,
                'JS_ERROR_TITLE_LENGTH'=>JS_ERROR_TITLE_LENGTH,
                'REALLY_DELETE_TAX_CLASS'=>REALLY_DELETE_TAX_CLASS,
            ]);
            $smarty->display('tax_classes.html');
            exit;
            break;
      case 'insert':
        $tax_class_title = xtc_db_prepare_input($_POST['tax_class_title']);
        $tax_class_description = xtc_db_prepare_input($_POST['tax_class_description']);
        $date_added = xtc_db_prepare_input($_POST['date_added']);

        xtc_db_query("insert into " . TABLE_TAX_CLASS . " (tax_class_title, tax_class_description, date_added) values ('" . xtc_db_input($tax_class_title) . "', '" . xtc_db_input($tax_class_description) . "', now())");
        xtc_redirect(xtc_href_link(FILENAME_TAX_CLASSES));
        break;

      case 'save':
        $tax_class_id = xtc_db_prepare_input($_GET['tID']);
        $tax_class_title = xtc_db_prepare_input($_POST['tax_class_title']);
        $tax_class_description = xtc_db_prepare_input($_POST['tax_class_description']);
        $last_modified = xtc_db_prepare_input($_POST['last_modified']);

        xtc_db_query("update " . TABLE_TAX_CLASS . " set tax_class_id = '" . xtc_db_input($tax_class_id) . "', tax_class_title = '" . xtc_db_input($tax_class_title) . "', tax_class_description = '" . xtc_db_input($tax_class_description) . "', last_modified = now() where tax_class_id = '" . xtc_db_input($tax_class_id) . "'");
        xtc_redirect(xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tax_class_id));
        break;

      case 'deleteconfirm':
        $tax_class_id = xtc_db_prepare_input($_GET['tID']);

        xtc_db_query("delete from " . TABLE_TAX_CLASS . " where tax_class_id = '" . xtc_db_input($tax_class_id) . "'");
        xtc_redirect(xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page']));
        break;
    }
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<div class="yesPageHeading"><?php echo HEADING_TITLE; ?></div>

<table border="0" width="100%" cellspacing="2" cellpadding="2">
<tr>
    <td valign="top">

	<table border="0" width="100%" cellspacing="0" cellpadding="2">
              <tr class="dataTableHeadingRow">
                <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_TAX_CLASSES; ?></td>
                <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_ACTION; ?>&nbsp;</td>
              </tr>
<?php
  $action = isset($_GET['action']) ? $_GET['action'] : '';
  $classes_query_raw = "select tax_class_id, tax_class_title, tax_class_description, last_modified, date_added from " . TABLE_TAX_CLASS . " order by tax_class_title";
  $classes_split = new splitPageResults($_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $classes_query_raw, $classes_query_numrows);
  $classes_query = xtc_db_query($classes_query_raw);
  while ($classes = xtc_db_fetch_array($classes_query)) {
    if ((( !isset($_GET['tID']) ) || (@$_GET['tID'] == $classes['tax_class_id'])) && (!isset($tcInfo)) && ( substr($action, 0, 3) != 'new')) {
      $tcInfo = new objectInfo($classes);
    }

    if ( (isset($tcInfo) and is_object($tcInfo)) && ($classes['tax_class_id'] == $tcInfo->tax_class_id) ) {
      echo '              <tr class="dataTableRowSelected" onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id . '&action=edit') . '\'">' . "\n";
    } else {
      echo'              <tr class="dataTableRow" onmouseover="this.className=\'dataTableRowOver\';this.style.cursor=\'hand\'" onmouseout="this.className=\'dataTableRow\'" onclick="document.location.href=\'' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $classes['tax_class_id']) . '\'">' . "\n";
    }
?>
                <td class="dataTableContent"><?php echo $classes['tax_class_title']; ?></td>
                <td class="dataTableContent" align="right"><?php if ( (is_object($tcInfo)) && ($classes['tax_class_id'] == $tcInfo->tax_class_id) ) { echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); } else { echo '<a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $classes['tax_class_id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
  }
?>
              <tr>
                <td colspan="2"><table border="0" width="100%" cellspacing="0" cellpadding="2">
                  <tr>
                    <td class="smallText" valign="top"><?php echo $classes_split->display_count($classes_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_TAX_CLASSES); ?></td>
                    <td class="smallText" align="right"><?php echo $classes_split->display_links($classes_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page']); ?></td>
                  </tr>
<?php
  if (!isset($_GET['action'])) {
?>
                  <tr>
                    <td colspan="2" align="right"><?php echo '<a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&action=new') . '">' . xtc_image_button('button_new_tax_class.gif', IMAGE_NEW_TAX_CLASS) . '</a>'; ?></td>
                  </tr>
<?php
  }
?>
                </table></td>
              </tr>
            </table></td>
<?php
  $heading = array();
  $contents = array();
  switch ($action) {
    case 'new':
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_NEW_TAX_CLASS . '</b>');

      $contents = array('form' => xtc_draw_form('classes', FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&action=insert'));
      $contents[] = array('text' => TEXT_INFO_INSERT_INTRO);
      $contents[] = array('text' => '<br>' . TEXT_INFO_CLASS_TITLE . '<br>' . xtc_draw_input_field('tax_class_title'));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CLASS_DESCRIPTION . '<br>' . xtc_draw_input_field('tax_class_description'));
      $contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_insert.gif', IMAGE_INSERT) . '&nbsp;<a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page']) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
      break;

    case 'edit':
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_EDIT_TAX_CLASS . '</b>');

      $contents = array('form' => xtc_draw_form('classes', FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id . '&action=save'));
      $contents[] = array('text' => TEXT_INFO_EDIT_INTRO);
      $contents[] = array('text' => '<br>' . TEXT_INFO_CLASS_TITLE . '<br>' . xtc_draw_input_field('tax_class_title', $tcInfo->tax_class_title));
      $contents[] = array('text' => '<br>' . TEXT_INFO_CLASS_DESCRIPTION . '<br>' . xtc_draw_input_field('tax_class_description', $tcInfo->tax_class_description));
      $contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_update.gif', IMAGE_UPDATE) . '&nbsp;<a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
      break;

    case 'delete':
      $heading[] = array('text' => '<b>' . TEXT_INFO_HEADING_DELETE_TAX_CLASS . '</b>');

      $contents = array('form' => xtc_draw_form('classes', FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id . '&action=deleteconfirm'));
      $contents[] = array('text' => TEXT_INFO_DELETE_INTRO);
      $contents[] = array('text' => '<br><b>' . $tcInfo->tax_class_title . '</b>');
      $contents[] = array('align' => 'center', 'text' => '<br>' . xtc_image_submit('button_delete.gif', IMAGE_DELETE) . '&nbsp;<a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
      break;

    default:
      if (is_object($tcInfo)) {
        $heading[] = array('text' => '<b>' . $tcInfo->tax_class_title . '</b>');

        $contents[] = array('align' => 'center', 'text' => '<a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id . '&action=edit') . '">' . xtc_image_button('button_edit.gif', IMAGE_EDIT) . '</a> <a href="' . xtc_href_link(FILENAME_TAX_CLASSES, 'page=' . $_GET['page'] . '&tID=' . $tcInfo->tax_class_id . '&action=delete') . '">' . xtc_image_button('button_delete.gif', IMAGE_DELETE) . '</a>');
        $contents[] = array('text' => '<br>' . TEXT_INFO_DATE_ADDED . ' ' . xtc_date_short($tcInfo->date_added));
        $contents[] = array('text' => '' . TEXT_INFO_LAST_MODIFIED . ' ' . xtc_date_short($tcInfo->last_modified));
        $contents[] = array('text' => '<br>' . TEXT_INFO_CLASS_DESCRIPTION . '<br>' . $tcInfo->tax_class_description);
      }
      break;
  }
  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table>
    </td>
<!-- body_text_eof //-->
</tr>
</table>
<?php 
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
