<?php
/* --------------------------------------------------------------------
/* LIZENZ DES SCRIPTS
 * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE
 * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE
 * ZWECKE, VERWENDET WERDEN.
*/
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'order.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'class.ebay_item.php');
require_once(DIR_WS_CLASSES.'class.ebay_auction.php');
include('includes/classes/class.ebaymail.php');
require_once(DIR_FS_INC.'yes_products_calc_in_auction_quantity.inc.php');

function _get_products_id_from_ebay_sku($sku,$variation=false){
    if($variation){
	$query = xtc_db_query(sprintf(
            "SELECT eav.products_id FROM ebay_auctions_variations eav LEFT JOIN ebay_auctions ea ON eav.ebay_auctions_id=ea.id WHERE eav.sku='%s' AND ea.products_id < 1 ORDER BY ea.start_time DESC LIMIT 1",
            $sku
	));
    }else{
	$query = xtc_db_query(sprintf(
            "SELECT ea.products_id FROM ebay_auctions ea WHERE (ea.sku='%s' AND ea.products_id > 0) or (ea.products_id='%s') ORDER BY ea.start_time DESC LIMIT 1",
            $sku,$sku
	));
    }
    if(!xtc_db_num_rows($query)){
	return -1;
    }
    $record = xtc_db_fetch_array($query);
    return $record['products_id'];
}

function RemoveEmptySubFolders($path){
  $empty=true;
  foreach (glob($path.DIRECTORY_SEPARATOR."*") as $file)
  {
     if (is_dir($file))
     {
        if (!RemoveEmptySubFolders($file)) $empty=false;
     }
     else
     {
        $empty=false;
     }
  }
  if ($empty) rmdir($path);
  return $empty;
}



include(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
$SYSTEM_EBAY_MESSAGES_CLEAN_DATE = date('Y-m-d',time()-(60*60*24*730)); // 2 jahre
$basics = new basics;
$abonded_years = 2;
$abonded_date = yes_strftime('%Y-%m-%d 00:00:00',time()-(60*60*24*365*$abonded_years)); // 2 Jahre
$auctions_abonded_date = yes_strftime('%Y-%m-%d 00:00:00',time()-(60*60*24*100)); // 100 Tage
$size_unit = 'MB';
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.ebay.php');
$EBAYAPI = new EbayAPI;
require(DIR_FS_INC.'xtc_get_site_country_id.inc.php');
require(DIR_FS_INC.'xtc_is_language_installed.inc.php');
require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
$error_reporting = yes_getErrorReporting();

error_reporting($error_reporting);
$smarty = new yesSmarty;
switch($action){
	case 'export_orders':
		require_once(DIR_FS_INC.'xtc_generate_packingslip_barcode.inc.php');
		if(isset($_POST['year']) and intval($_POST['year'])>0){
			$os = [];
			$os_raw = $_POST['orders_status']??[];
			foreach($os_raw as $osr){
				$os[] = intval($osr);
			}
			$query = xtc_db_query(sprintf(
				"SELECT orders_id FROM orders WHERE orders_status IN(%s) AND YEAR(date_purchased) = %d ORDER BY date_purchased ASC",
				implode(',',$os),
				intval($_POST['year'])
			));
			while($record = xtc_db_fetch_array($query)){
				printf('<div>%s %s</div>',
					xtc_draw_checkbox_field('orders_id[]',$record['orders_id'],false),
					$record['orders_id']
				);
			}
			exit;			
		}
		if(isset($_GET['year']) and intval($_GET['year'])>0 and isset($_GET['oID'])){
			$oID = intval($_GET['oID']??0);
			if($oID < 1){
				die(json_encode([
					'MSG'=>'Invalid oID',
				]));
			}
			require_once(DIR_FS_INC.'xtc_format_price_order.inc.php');
			require_once(DIR_FS_INC.'xtc_get_orders_ebay_seller.inc.php');
			require_once(DIR_FS_INC.'xtc_get_ebay_seller_data.inc.php');
			require_once(DIR_FS_INC.'xtc_get_order_html_for_pdf.inc.php');
			$creation_dir = \main::get_secure_path().'ORDER_EXPORT_'.intval($_GET['year']);
			if(!is_dir($creation_dir)){
				mkdir($creation_dir,0755);
			}
			if(is_file($creation_dir.'/'.$record['orders_id'].'.pdf')){
				die(json_encode([
					'MSG'=>'',
				]));
			}
			$order = new \order($oID);
			$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
			

			$pdf_smarty = new yesSmarty;
			$pdf_order_html=xtc_get_order_html_for_pdf($order,$pdf_smarty,CURRENT_TEMPLATE . '/admin/mail/german/pdf_order.html');
			// FUEGE ORDER AN GESAMTPDF AN
			if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
				$headerandfooter=false;
				$pdf = new yes_pdf($headerandfooter);
				if(DOMPDF_ORDER_LANDSCAPE == 'True'){
					$pdf->set_landscape();
				}
				$pdf->set_html($pdf_order_html);
				$pdf->save($creation_dir.'/'.$oID.'.pdf');
			}else{
				die(json_encode([
					'MSG'=>'DOMPDF IST PFLICHT',
				]));
			}
			die(json_encode([
				'MSG'=>'',
			]));

		}
		$oldest_query = xtc_db_query(sprintf(
			"SELECT date_purchased FROM orders WHERE orders_status!='%d' ORDER BY date_purchased ASC LIMIT 1",
			constant('ORDERS_STATUS_STORNIERT')
		));
		$oldest = xtc_db_fetch_array($oldest_query);
		$date = new \DateTime($oldest['date_purchased']);
		$oldY = $date->format('Y');

		$newest_query = xtc_db_query(sprintf(
			"SELECT date_purchased FROM orders WHERE orders_status!='%d' ORDER BY date_purchased DESC LIMIT 1",
			constant('ORDERS_STATUS_STORNIERT')
		));
		$newest = xtc_db_fetch_array($newest_query);
		$date = new \DateTime($newest['date_purchased']);
		$newY = $date->format('Y');
		$span = $newY - $oldY;
		$options = [];
		for($i = 0; $i<=$span; $i++){
			$options[] = [
				'id'=>$oldY+$i,
				'text'=>$oldY+$i
			];
		}

		$smarty = new yesSmarty();
		$smarty->assign([
			'FORM'=>xtc_draw_form('orderpdfexport','system.php',xtc_get_all_get_params(),'POST'),
			'INPUT_YEAR'=>xtc_draw_pull_down_menu('year',$options,'','id="year"'),
			'BUTTON_SUBMIT'=>yes_draw_href_button(IMAGE_EXPORT,'','','submit'),
			'ORDERS_STATUSES'=>xtc_get_orders_status()
		]);
		$smarty->display('system.export_orders.html');
		exit;
		break;
	case 'fix_products_distributors':
		$output = '';
		$table = 'products_distributors';
		$query = xtc_db_query("SELECT * FROM $table");
		$num = xtc_db_num_rows($query);
		while($row = xtc_db_fetch_array($query)){
    		$cols = array_map(fn($col) => "`" . str_replace("`", "``", $col) . "`", array_keys($row));
    		$vals = array_map(fn($val) => isset($val) ? $db_link->quote($val) : 'NULL', array_values($row));
    		$output .= "INSERT INTO `$table` (" . implode(", ", $cols) . ") VALUES (" . implode(", ", $vals) . ");\n";
		}
		if(!empty($output)){
			$basics = new \basics;
			$basics->create_file2('exportdata/products_distributors.sql-BAK'.date('Y-m-d_His'),$output);
		}
		$query = yes_query("DELETE FROM products_distributors WHERE id NOT IN ( SELECT id FROM (SELECT MAX(id) AS id FROM products_distributors GROUP BY products_id, distributor_id  ) AS t)");
		$messageStack->add_session('Es wurden zu '.$num.' products_distributor Einträgen ein Backup angelegt und anschliessend Mehrfachzuweisungen gelöscht.','success');
		xtc_redirect(xtc_href_link('system.php'));
		exit;
		break;
	case 'ebaytaxrate_bugfix':
		$from_date_obj = new \DateTime('-2 Years');
		$query = yes_query("SELECT ot.*, o.date_purchased FROM orders_total ot INNER JOIN orders o ON o.orders_id=ot.orders_id WHERE o.date_purchased > :datep AND o.source='ebay' AND ot.class='ot_tax' AND ot.tax_rate_percent=0",[
			'datep'=>$from_date_obj->format('Y-m-d'),
		]);
		if(isset($_POST['bugf']) and is_countable($_POST['bugf']) and sizeOf($_POST['bugf'])){
			foreach($_POST['bugf'] as $oID_raw=>$new_tax_rate){
				$oID = intval($oID_raw);
				$update_sql = sprintf("UPDATE orders_total SET tax_rate_percent=%s WHERE orders_id=%d AND class='ot_tax' AND tax_rate_percent=0",
					floatval($new_tax_rate),
					$oID,
				);
				xtc_db_query($update_sql);
			}
			$messageStack->add_session('Es wurden '.sizeOf($_POST['bugf']).' Auftraege korrigiert','success');
			xtc_redirect(xtc_href_link('system.php'));
		}
		printf('<h3>%d fehlerhafte Eintraege (ab %s) gefunden</h3>',sizeOf($query),$from_date_obj->format('d.m.y'));
		echo xtc_draw_form('ebaytaxrate_bugfix_frm','system.php','action=ebaytaxrate_bugfix','POST');
		echo '<table><thead><tr><th>Auftrag</th><th>Vom</th><th>MwSt Eintrag ot_total</th><th>Update</th></tr></thead>';
		foreach($query as $entry){
			$update = true;
			if (preg_match('/(\d+(?:\.\d+)?)\s*%/', $entry['title'], $matches)) {
				$new_tax = $matches[1];
				if($new_tax == '0'){
					$update = false;
					$new_tax = '<span style="font-weight: bold;background-color: red;color: white;">0 bleibt</span>';
				}
			}else{
				$update = false;
				$new_tax = '<span style="font-weight: bold;background-color: red;">???</span>';
			}
			echo '<tr>';
			$chkbox = ($update)? xtc_draw_checkbox_field('bugf['.$entry['orders_id'].']',$new_tax,true):'';
			printf('<td>%s</td><td>%s</td><td>%s: %s</td><td>VON 0 AUF %s</td>',
				sprintf('%s <a target="_blank" href="orders.php?action=edit&oID=%s"><button type="button">%s</button></a>',
					$chkbox,
					$entry['orders_id'],
					$entry['orders_id']
				),
				yes_date_short($entry['date_purchased']),
				$entry['title'],$entry['text'],
				$new_tax
			);
			echo '</tr>';
		}
		echo '</table><input type="submit" value="bugfix"></form>';
		exit;
		break;
	case 'server':
		include('system.server.php');
		break;
	case 'lang':
		include('system.lang.php');
		break;
	case 'debugmail':
		yes_mail_debug('<h1>SYSTEM.PHP</h1><p>Nur <u>eine</u> Test <b>Debug</b>mail aus der system.php</p><div>Puh, nochmal <code>Glueck</code> gehabt!</div>',false,'debugmail');
		break;
	case 'convert_products_content':
		$t = 'products_content_description';
		$table_exists_query = xtc_db_query(sprintf(
			"SHOW TABLES LIKE '%s'",$t
		));
		if(xtc_db_num_rows($table_exists_query)){
			printf("<li style=\"color: red;\">Tabelle %s existiert bereits.</li>",$t);
			exit;
		}
		xtc_db_query("CREATE TABLE products_content_description (	`products_content_description_id` INT NOT NULL AUTO_INCREMENT , `language_id` INT(1) NOT NULL,	`content_id` INT(11) NOT NULL , `content_name` VARCHAR(255) NOT NULL,	`file_comment` TEXT, 	PRIMARY KEY (`products_content_description_id`), INDEX (`content_id`)) ENGINE = InnoDB;");
		$query = xtc_db_query(sprintf(
			"SELECT * FROM products_content"
		));
		while($record = xtc_db_fetch_array($query)){
			$insert_sql_array = [
				'language_id'=>intval($record['languages_id']),
				'content_id'=>intval($record['content_id']),
				'content_name'=>$record['content_name'],
				'file_comment'=>$record['file_comment']
			];
			yes_db_perform('products_content_description',$insert_sql_array);
		}
		xtc_db_query("ALTER TABLE products_content DROP COLUMN content_name");
		xtc_db_query("ALTER TABLE products_content DROP COLUMN file_comment");
		$languages = xtc_get_languages();
		$query = xtc_db_query("SELECT content_id FROM products_content");
		while($record = xtc_db_fetch_array($query)){
			foreach($languages as $lang){
				if($lang['id']==2){
					continue;
				}
				$checkq = xtc_db_query(sprintf(
					"SELECT products_content_description_id FROM products_content_description WHERE language_id='%d' AND content_id='%d'",
					$lang['id'],$record['content_id']
				));
				if(xtc_db_num_rows($checkq)){
					continue;
				}
				$getq = xtc_db_query(sprintf(
					"SELECT * FROM products_content_description WHERE content_id='%d' AND language_id=2",
					$record['content_id']
				));
				$get = xtc_db_fetch_array($getq);
				$insert_sql_array = $get;
				unset($insert_sql_array['products_content_description_id']);
				$insert_sql_array['language_id'] = $lang['id'];
				xtc_db_perform('products_content_description',$insert_sql_array);
			}
		}

		

		die('<b>Erfolgreich konvertiert</b><br /><a href="start.php">Zurueck</a>');
		break;
	case 'repair_add_language':
		$show_tables = false;
		if($show_tables){
			$tables = [];
			$excludes = ['ALL_db','ALL_indizes','ALL_table','languages','admin_access'];
			$q = yes_query("SHOW TABLES");
			foreach($q as $r){
				if(!in_array($r['Tables_in_yes'],$excludes)){
					$tables[] = $r['Tables_in_yes'];
				}
			}
			foreach($tables as $t){
				$cols = [];
				$q = xtc_db_query(sprintf("SELECT * FROM `%s` LIMIT 1",$t));
				// Metadaten abrufen
				$count = $q->ColumnCount();
				for($i=0;$i<$count;$i++){
					if(strpos($q->getColumnMeta($i)['name'],'language')>-1){
						echo '<li>'.$t.'.'.$q->getColumnMeta($i)['name'];
					}
				}
			}
		}
		echo '<h3>Fehlende Language Eintraege erstellen</h3>';
		$languages = xtc_get_languages();
		if(sizeOf($languages)==1){
			die('Nur 1 Language installiert, nix zu tun');
		}
		$laction = $_GET['laction']??'';
		switch($laction){
			case 'shipping_status':
				xtc_db_query("DELETE FROM shipping_status WHERE language_id != 2");
				$query = xtc_db_query("SELECT * FROM shipping_status WHERE language_id=2");
				$inserted = 0;
				while($record = xtc_db_fetch_array($query)){
					foreach($languages as $l){
						if($l['id'] == 2){
							continue;
						}
						$insert_sql_array = $record;
						$insert_sql_array['language_id'] = intval($l['id']);
						yes_db_perform('shipping_status', $insert_sql_array);
						$inserted++;

					}
				}
				printf('<b>Es wurden %d shipping_status Eintraege hinzugefuegt.</b><br /><br /><a href="?action=repair_add_language">Zurueck</a>', $inserted);
				exit;
				break;
			case 'coupons_description':
				xtc_db_query("DELETE FROM coupons_description WHERE language_id != 2");
				$query = xtc_db_query("SELECT * FROM coupons_description WHERE language_id=2");
				$inserted = 0;
				while($record = xtc_db_fetch_array($query)){
					foreach($languages as $l){
						if($l['id'] == 2){
							continue;
						}
						$insert_sql_array = $record;
						$insert_sql_array['language_id'] = intval($l['id']);
						yes_db_perform('coupons_description', $insert_sql_array);
						$inserted++;

					}
				}
				printf('<b>Es wurden %d coupons_description Eintraege hinzugefuegt.</b><br /><br /><a href="?action=repair_add_language">Zurueck</a>', $inserted);
				exit;
				break;
			case 'content_manager':
				// content_manager
				xtc_db_query("DELETE FROM content_manager WHERE languages_id != 2");
				$query = xtc_db_query("SELECT * FROM content_manager WHERE languages_id=2");
				$inserted = 0;
				while($record = xtc_db_fetch_array($query)){
					foreach($languages as $l){
						if($l['id'] == 2){
							continue;
						}
						$insert_sql_array = $record;
						unset($insert_sql_array['content_id']);
						$insert_sql_array['languages_id'] = intval($l['id']);
						yes_db_perform('content_manager', $insert_sql_array);
						$inserted++;

					}
				}
				printf('<b>Es wurden %d content_manager Eintraege hinzugefuegt.</b><br /><br /><a href="?action=repair_add_language">Zurueck</a>', $inserted);
				exit;
				break;
			case 'products_content':
				xtc_db_query("DELETE FROM products_content WHERE languages_id != 2");
				$query = xtc_db_query("SELECT * FROM products_content WHERE languages_id=2");
				$inserted = 0;
				while($record = xtc_db_fetch_array($query)){
					foreach($languages as $l){
						if($l['id'] == 2){
							continue;
						}
						$insert_sql_array = $record;
						unset($insert_sql_array['content_id']);
						$insert_sql_array['languages_id'] = intval($l['id']);
						yes_db_perform('products_content', $insert_sql_array);
						$inserted++;
					}
				}
				printf('<b>Es wurden %d products_content Eintraege hinzugefuegt.</b><br /><br /><a href="?action=repair_add_language">Zurueck</a>', $inserted);
				exit;
				break;
			case 'other':
					$tables = [
						'default_products_master_keys_description',
						'default_products_master_slave_values',
						'ebay_auctions_properties_description',
						'ebay_auctions_properties_values_description',
						'ebay_products_properties_description',
						'ebay_products_properties_values_description',
						'products_characteristic_description',
						'products_characteristic_set_description',
						'products_characteristic_text_values',
						'products_conditions_description',
						'products_google_feed_apparel',
						'products_master_keys_description',
						'products_master_slave_values',
						'products_properties_description',
						'products_properties_values_description',
						'products_vpe',
						'units_description'
					];
					foreach($tables as $t){
						$table_exists_query = xtc_db_query(sprintf(
							"SHOW TABLES LIKE '%s'",$t
						));
						if(!xtc_db_num_rows($table_exists_query)){
							printf("<li style=\"color: red;\">Tabelle %s existiert nicht in der DB.</li>",$t);
							continue;
						}
						xtc_db_query(sprintf("DELETE FROM %s WHERE language_id != 2",$t));
						$query = xtc_db_query(sprintf(
							"SELECT * FROM %s WHERE language_id=2",$t
						));
						$inserted = 0;
						while($record = xtc_db_fetch_array($query)){
							foreach($languages as $l){
								if($l['id'] == 2){
									continue;
								}
								$insert_sql_array = $record;
								switch($t){
									case 'products_characteristic_set_description':
										unset($insert_sql_array[$t]);
										break;
									default:
										unset($insert_sql_array[$t.'_id']);
										break;
								}
								$insert_sql_array['language_id'] = intval($l['id']);
								yes_db_perform($t, $insert_sql_array);
								$inserted++;
		
							}
						}
						printf('<b>Es wurden %d %s Eintraege hinzugefuegt.</b><br />', $inserted, $t);
					}
					echo '<br /><a href="?action=repair_add_language">Zurueck</a>';
					exit;
					break;
				// content_manager
		}
		printf('<a href="?action=%s&laction=%s">Content Manager</a> (bereits existierende Eintraege fuer andere Sprachen ausser 2 (Deutsch) werden gelöscht und als Kopie der deutschsprachigen Eintraege neu erzeugt.',
			$_GET['action'],
			'content_manager'
		);
		printf('<br /><a href="?action=%s&laction=%s">coupons_description</a> (bereits existierende Eintraege fuer andere Sprachen ausser 2 (Deutsch) werden gelöscht und als Kopie der deutschsprachigen Eintraege neu erzeugt.',
			$_GET['action'],
			'coupons_description'
		);
		printf('<br /><a href="?action=%s&laction=%s">shipping_status</a> (bereits existierende Eintraege fuer andere Sprachen ausser 2 (Deutsch) werden gelöscht und als Kopie der deutschsprachigen Eintraege neu erzeugt.',
			$_GET['action'],
			'shipping_status'
		);
		printf('<br /><a href="?action=%s&laction=%s">products_content</a> (bereits existierende Eintraege fuer andere Sprachen ausser 2 (Deutsch) werden gelöscht und als Kopie der deutschsprachigen Eintraege neu erzeugt.',
			$_GET['action'],
			'products_content'
		);
		printf('<br /><a href="?action=%s&laction=%s">Alle anderen language basierte Tabellen</a> (bereits existierende Eintraege fuer andere Sprachen ausser 2 (Deutsch) werden gelöscht und als Kopie der deutschsprachigen Eintraege neu erzeugt.',
			$_GET['action'],
			'other'
		);
		echo '<br /><p>Generell sollten VOR DEM HINZUFÜGEN EINER SPRACHE keine Daten in den folgenden Tabellen sein:<br /><code><pre>';
		echo <<<TABLES
default_products_master_keys_description
default_products_master_slave_values
ebay_auctions_properties_description
ebay_auctions_properties_values_description
ebay_products_properties_description
ebay_products_properties_values_description
products_characteristic_description
products_characteristic_set_description
products_characteristic_text_values
products_conditions_description
products_content
products_google_feed_apparel
products_master_keys_description
products_master_slave_values
products_properties_description
products_properties_values_description
products_vpe
reviews_description
units_description
TABLES;
		echo '</pre></code><br />Es ist einfacher und schneller diese Tabellen zu leeren (geht ja eh nur um neu aufgesetzte Systeme auf Basis von clean). Wenn die auf Clean leer sind, gibts auch bei neuen Systemen keine Einträge. Am besten: Auf clean KEINE SAMMLERPRODUKTE, KEINE ARTIKEL MIT EIGENSCHAFTEN/CHARACTERISTICS, KEINE GUTSCHEINE, KEINE MASTER/SLAVES, KEINE PRODUKT-CONTENTDATEIEN, KEINE ARTIKEL VPE, KEINE REVIEWS, KEINE UNITS (gramm, liter usw)</p>';
		exit;
		break;
    case 'create_class_from_sql':
        require_once('system.create_class_from_sql.php');
        exit;
        break;
    case 'amazon_lwa_refresh':
        require_once(DIR_WS_CLASSES.'amazon_sp.php');
        $file = main::get_secure_path().amazon_sp::AMAZON_SP_LWACLIENTID_FILE;
        if(isset($_POST['lwa_client_secret']) and !empty($_POST['lwa_client_secret'])){
            basics::create_file2($file, trim($_POST['lwa_client_secret']));
            $messageStack->add_session('Amazon LWA Client Secret aktualisiert.','success');
            xtc_redirect(xtc_href_link('system.php'));
        }
        $filemtime = filemtime($file);
        printf('<div class="main"><p>Der LWA Client Secret wurde zuletzt am %s aktualisiert.</p>',date('d.m.Y H:i:s',$filemtime));
        echo '<form action="?action=amazon_lwa_refresh" method="post">';
        echo '<label for="lwa_client_secret">Client Secret hier eintragen</label><br />';
        echo '<input name="lwa_client_secret" id="lwa_client_secret" size="48" maxlength="128" type="text"/>';
        echo '<br /><input type="submit" value="Aktualisieren" />';
        echo '</form><br /><span style="color: #555;"><i>Mit dieser Funktionalit&auml;t wird die Datei mit dem LWA Client Secret neu geschrieben. Dieser Vorgang m&uuml;sste eigentlich nun bei jedem System mit Amazon Anbindung wiederholt werden und bei jedem System m&uuml;sste dieser Secret eingetragen werden. Schneller ist es, wenn das per Linux Shell gemacht wird - da muss dann Mario ein entsprechendes Script starten.</i></span></div>';
        exit;
        break;
    case 'products_characteristics_cleanup':
        // BOF - SQL AUFRAEUMEN products_to_characteristics
        xtc_db_query("DELETE FROM products_to_characteristics WHERE products_characteristic_set_id=0");
        $q = xtc_db_query(
                "SELECT * FROM products_to_characteristics"
        );
        $doubles = [];
        while($r = xtc_db_fetch_array($q)){
                if(!isset($doubles[ $r['products_id'] ])){
                        $doubles[ $r['products_id'] ] = [];
                }
                if(!isset($doubles[ $r['products_id'] ][ $r['products_characteristic_set_id'] ])){
                        $doubles[ $r['products_id'] ][ $r['products_characteristic_set_id'] ] = [ $r['products_to_characteristics_id'] ];
                }else{
                        $doubles[ $r['products_id'] ][ $r['products_characteristic_set_id'] ][] = $r['products_to_characteristics_id'];
                }
        }
        foreach($doubles as $pID => $chars){
                foreach($chars as $pcsID=>$ptcIDs){
                        if(sizeOf($ptcIDs)>1){
                                printf('<li>pID %d - pcsID %d: %d Entries.</li>',$pID, $pcsID,sizeOf($ptcIDs));
                                for($i=0;$i < sizeOf($ptcIDs)-1;$i++){
                                        xtc_db_query(sprintf("DELETE FROM products_to_characteristics WHERE products_to_characteristics_id='%d'",
                                                $ptcIDs[$i]
                                        ));
                                }
                        }
                }
        }
        $messageStack->add_session('Produktmerkmale (Sets) wurden bereinigt.','success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'ebay_sync_v2_backup':
        sleep(5);
        $backup_tables = ['products'=>[
            'products_id','products_quantity','in_auction'
        ],'ebay_auctions'=>[
            'id','quantity','status'
        ],'ebay_auctions_variations'=>[
            'ebay_auctions_variations_id','quantity','quantity_sold'
        ]];
        $dir = main::get_secure_path().'BACKUPS';
        if(!is_dir($dir)){
            mkdir($dir);
        }
        $backup_file = $dir.DIRECTORY_SEPARATOR.sprintf('v2sync_backup_%s.sql',date('Ymdhis'));
        $backup_sql = sprintf(
                "/*\n=== YES V2 Sync Backup vom %s ===\n*/\n",
                date('Y-m-d H:i:s')
        );
        foreach($backup_tables as $bt=>$fields){
            $q = xtc_db_query(sprintf(
                    "SELECT %s FROM %s",
                    implode(', ',$fields),
                    $bt
            ));
            $backup_sql .= "\n/* === TABLE ".$bt." === */\n\n";
            while($record = xtc_db_fetch_array($q)){
                $sql_set_strings = [];
                $sql_where = '';
                foreach($fields as $nr=>$field){
                    if($nr == 0){
                        $sql_where = sprintf("%s='%d'",
                                $field, $record[$field]
                        );
                    }else{
                        $sql_set_strings[] = sprintf("%s='%s'",
                                $field, $record[$field]
                        );
                    }
                }
                $backup_sql .= sprintf("UPDATE %s SET %s WHERE %s;\n",
                        $bt, implode(', ',$sql_set_strings),$sql_where
                ); 
            }
        }
        if(empty($backup_sql)){
            die(json_encode([
                'MSG'=>"<b>Fehler:</b> Es konnte kein Backup SQL Export generiert werden.",
            ]));
        }
        try{
            basics::create_file2($backup_file, $backup_sql);
        }catch( Exception $e ){
            die(json_encode([
                'MSG'=>$e->getMessage(),
            ]));
        }
        die(json_encode([
            'MSG'=>'',
        ]));
        break;
    case 'v2_sync':
        $ebay_user = xtc_get_ebay_users();
        $number_of_submitted_files = 0;
        foreach($_FILES['seller']['name'] as $fn=>$fv){
            if(!empty($fv)){
                $number_of_submitted_files++;
            }
        }
        if($number_of_submitted_files != sizeOf($ebay_user)){
            $messageStack->add_session(sprintf("eBay_v2 Sync: Es wurden nur %d Dateien übergeben, aber es sind %d Seller vorhanden.",
                $number_of_submitted_files,
                sizeOf($ebay_user)
            ),'error');
            xtc_redirect(xtc_href_link('system.php'));
        }
        $diff_fn = [];
        foreach($_FILES['seller']['name'] as $nr => $fn){
            if(!in_array($fn,$diff_fn)){
                $diff_fn[] = $fn;
                if($_FILES['seller']['type'][$nr] != 'application/zip' and $_FILES['seller']['type'][$nr] != 'application/x-zip-compressed'){
                    $messageStack->add_session(sprintf(
                        "eBay_v2 Sync: Die Datei %s ist nicht als .zip Archiv (%s) &uuml;bergeben worden.",
                        $fn, $_FILES['seller']['type'][$nr]
                    ),'error');
                    xtc_redirect(xtc_href_link('system.php'));
                }
            }else{
                $messageStack->add_session(
                    sprintf(
                        "eBay_v2 Sync: Die Datei %s wurde mehrfach &uuml;bergeben.",
                        $fn
                    ),'error'
                );
                xtc_redirect(xtc_href_link('system.php'));
            }
        }
        $content = [];
        foreach($ebay_user as $eu){
            if(file_exists(main::get_secure_path().'LMS/sync-seller-'.$eu['id'].'.zip')){
                unlink(main::get_secure_path().'LMS/sync-seller-'.$eu['id'].'.zip');
            }
            if(file_exists(main::get_secure_path().'LMS/sync-seller-'.$eu['id'].'.xml')){
                unlink(main::get_secure_path().'LMS/sync-seller-'.$eu['id'].'.xml');
            }
        }
        foreach($_FILES['seller']['tmp_name'] as $nr => $fn){
            $file = main::get_secure_path().'LMS/sync-seller-'.$eu['id'].'.zip';
            $fp = fopen($file, 'wb');
            fwrite($fp, file_get_contents($fn));
            fclose($fp);
            
            $zip = new ZipArchive;
            if ($zip->open($file) === TRUE) {
                $unzipped = $zip->getNameIndex(0);
                $zip->extractTo(main::get_secure_path().'LMS/');
                $zip->close();
            } else {
                throw new Exception('Cant unzip '.$file.' to '.main::get_secure_path().'LMS/');
            }            
            unlink($file);
            $content[] = ['seller'=>$nr, 'content'=>file_get_contents(main::get_secure_path().'LMS/'.$unzipped)];
            unlink(main::get_secure_path().'LMS/'.$unzipped);
        }
        $data = [];
        foreach($content as $c){
            $array = json_decode(json_encode((array) simplexml_load_string($c['content'])), 1);
            foreach($array['ActiveInventoryReport']['SKUDetails'] as $sd){
                    if(is_countable($sd) and sizeOf($sd)){
                        if(isset($sd['Variations'])){
                            // bugfix 11/25 Wenn nur eine Variation vorhanden ist
							// dann ist der array key "SKU" direkt vorhanden
                            if(isset($sd['Variations']['Variation']['SKU'])){
                            	unset($sd['Variations']['Variation']['VariationSpecifics']);
                            	$single = $sd['Variations']['Variation'];
                            	$sd['Variations']['Variation'] = [$single]; 	
                            }else{
		                    	foreach($sd['Variations']['Variation'] as $vk=>$Variation){
			                        unset($sd['Variations']['Variation'][$vk]['VariationSpecifics']);
		                    	}
		            		}
                        }
                        $data[] = $sd;
                    }
            }
        }
        if(!sizeOf($data)){
            $messageStack->add_session(
                "eBay_v2 Sync: Keine Auktionen zum Synchronisieren vorhanden. Um trotzdem alle Daten zu resetten manuell alle products.in_auction auf 0 sowie alle ebay_auction.status auf 2 setzen.",
                'error'
            );
            xtc_redirect(xtc_href_link('system.php'));
        }
        xtc_db_query("UPDATE products SET in_auction=0");
        xtc_db_query("UPDATE ebay_auctions SET status=2");
        
        foreach($data as $Item){
			$ea_item = \YES4Trade\Model\ebay_auctions::get_by_ebay_id($Item['ItemID'],['id']);
            if($ea_item === null){
                $messageStack->add_session(sprintf("[v2 Sync] Unbekannte Auktion %s", $Item['ItemID']),'error');
                continue;
            }
            
			\YES4Trade\Model\ebay_auctions::update_ebay_auction([ // update status to 0
                'status'=>0,
				'id'=>intval($ea_item->id)
            ]);
            
            if(isset($Item['Variations'])){
                foreach($Item['Variations']['Variation'] as $Variation){
                    $sku = $Variation['SKU'];
                    \YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
                        'quantity'=>(int)$Variation['Quantity'],
                        'ebay_auctions_id'=>intval($ea_item->id),
                        'sku'=>$sku
					]);
                    $vpID = _get_products_id_from_ebay_sku($sku,true);
                    if($vpID > 0){
                        $calculated_in_auction = yes_products_calc_in_auction_quantity($vpID);
                        yes_update_products_in_auction_quantity($vpID, 
                            $calculated_in_auction,
                            "[syncV2] SKU ".$sku." Variante in ".$Item['ItemID']." - Aktueller in_auction Wert: ".$calculated_in_auction,
                            true
                        );
                    }
                }
            }else{
                $pID = _get_products_id_from_ebay_sku($Item['SKU']);
                \YES4Trade\Model\ebay_auctions::update_ebay_auction([ // update quantity
                    'quantity'=>(int)$Item['Quantity'],
					'id'=>intval($ea_item->id)
                ]);
                if(intval($pID) > 0){
                    $calculated_in_auction = yes_products_calc_in_auction_quantity($pID);
                    yes_update_products_in_auction_quantity(intval($pID), 
                        $calculated_in_auction,
                        "[syncV2] eBay ID ".$Item['ItemID']." - Aktueller in_auction Wert: ".$calculated_in_auction,
                        true
                    );
                }
            }
        }
        $messageStack->add_session('eBay Sync V2 erfolgreich abgeschlossen.','success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'delete_file_cache':
        $dir = DIR_FS_CATALOG;
        $system_cmd = 'rm -Rf '.$dir.'/templates_c/*';
        system($system_cmd);
        $messageStack->add_session('Template Cache wurde geleert.','success');
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'xy_delete':
        $unknown_ppID = [];
        $q = xtc_db_query("SELECT DISTINCT(xyv.products_properties_id) FROM `product_properties_xy_prices_values_for_properties` xyv LEFT JOIN products_properties pp USING(products_properties_id) WHERE pp.products_properties_id IS NULL");
        while($r = xtc_db_fetch_array($q)){
            $unknown_ppID[] = $r['products_properties_id'];
        }
        foreach($unknown_ppID as $ppID){
            xtc_db_query(sprintf(
                    "DELETE FROM product_properties_xy_prices_values_for_properties WHERE products_properties_id='%d'",
                    $ppID
            ));
        }
        $messageStack->add_session(sprintf(
                'Es wurden %d verwaiste products_properties_id Eintr&auml;ge aus der product_properties_xy_prices_values_for_properties Tabelle gel&ouml;scht.',
                sizeOf($unknown_ppID)
        ),'success');
        xtc_redirect(xtc_href_link('system.php'));
        break;
    case 'dhl_api_switch':
        $delete_conf = [
            'MODULE_SHIPPING_DHLGKAPI_TAX_CLASS',
            'MODULE_SHIPPING_DHLGKAPI_ORDERSTATUS_SHIPPED',
            'MODULE_SHIPPING_DHLGKAPI_ORDERSTATUS_CANCELED',
            'MODULE_SHIPPING_DHLGKAPI_WUNSCHPAKET_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_WUNSCHPAKET_TIME',
            
            'MODULE_SHIPPING_DHLGKAPI_V62WP_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_V62WP_RETOURE_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V62WP_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V62WP_COUNTRIES',
            'MODULE_SHIPPING_DHLGKAPI_V62WP_FREEAMOUNT',
            
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z4)_FREEAMOUNT',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z4)_RETOURE_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z4)_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z4)_COST',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z4)_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z4)_COUNTRIES',
            
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_RETOURE_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_HANDLING',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_FREEAMOUNT',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_COST',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_COUNTRIES',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z3)_ATTENDANCE',
            
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_FREEAMOUNT',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_RETOURE_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_HANDLING',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_COST',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_COUNTRIES',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z2)_ATTENDANCE',
            
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_RETOURE_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_FREEAMOUNT',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_HANDLING',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_COST',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_COUNTRIES',
            'MODULE_SHIPPING_DHLGKAPI_V53WPAK(Z1)_ATTENDANCE',
            
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_ENABLED',
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_RETOURE_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_FREEAMOUNT',
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_HANDLING',
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_COST',
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_COUNTRIES',
            'MODULE_SHIPPING_DHLGKAPI_V01PAK_ATTENDANCE',
            'MODULE_SHIPPING_DHLGKAPI_TEILNAHME', // wird neu erzeugt
        ];
        foreach($delete_conf as $k=>$dc){
            $delete_conf[ $k ] = sprintf('"%s"',$dc);
        }
        xtc_db_query(sprintf("DELETE FROM configuration WHERE configuration_key IN(%s)",
                implode(',',$delete_conf)
        ));
        xtc_db_query("INSERT INTO " . TABLE_CONFIGURATION . " (`configuration_id`, `configuration_key`, `configuration_value`, `configuration_group_id`, `sort_order`, `last_modified`, `date_added`, `use_function`, `set_function`) VALUES (NULL, 'MODULE_SHIPPING_DHLGKAPI_TEILNAHME', '', '6', '50', '', '2024-03-02 19:11:24', 'yes_dhlgkapi_teilnahme_config_get', 'yes_dhlgkapi_teilnahme_config_save(')");
        
        // SHIPPER PROFILES 3 Defaults
        $insert_sql_array = [
            'profile_name'=>'DHL-PAKET-INT',
            'versender'=>'DHL',
            'versender_params'=>'{"product":"V53WPAK5301","customs":{"invoiceNo":"","exportType":"OTHER","postalCharges":{"currency":"EUR","value":0},"items":[],"permitNo":"approval \/ permit","attestationNo":"confirmation \/ attestation"},"services":{"premium":true,"endorsement":"RETURN"}}',
        ];
        xtc_db_perform('shipper_profiles',$insert_sql_array);
        $insert_sql_array = [
            'profile_name'=>'DHL-PAKET',
            'versender'=>'DHL',
            'versender_params'=>'{"product":"V01PAK0101"}',
        ];
        xtc_db_perform('shipper_profiles',$insert_sql_array);
        $insert_sql_array = [
            'profile_name'=>'DHL-B2C-EU',
            'versender'=>'DHL',
            'versender_params'=>'{"product":"V54EPAK5401"}',
        ];
        xtc_db_perform('shipper_profiles',$insert_sql_array);
        
        $messageStack->add_session('DHL Modul aktualisiert','success');
        xtc_redirect(xtc_href_link('system.php'));
        break;
    case 'ebay_orders_processed':
        if(isset($_GET['id'])){
            $update_sql_array = [
                'processed'=>1
            ];
            xtc_db_perform('ebay_orders', $update_sql_array, 'update',"ebay_orders_id='".$_GET['id']."'");
        }
        $query = xtc_db_query(
                "SELECT * FROM ebay_orders WHERE processed=0"
        );
        if(!xtc_db_num_rows($query)){
            die('Keine offenen ebay_orders');
        }
        $data = [];
        while($record = xtc_db_fetch_array($query)){
            $data[] = $record;
        }
        $contents = [];
        $header = array_keys($data[0]);
        $content = [];
        foreach($header as $v=>$k){
            $content[] = ['text'=>$k,'params'=>'','align'=>'left','form'=>'','th'=>true];
        }
        $contents[] = $content;
        $params = 'class="yesListTable_minimal"';
        $table = new tableBlock();
        $table->table_parameters = $params;
        foreach($data as $d){
            $content = [];
            foreach($d as $k=>$v){
                switch($k){
                    case 'processed':
                        $v = sprintf('<a href="%s" title="Auf processed=1 setzen">%d</a>',
                            xtc_href_link('system.php','action=ebay_orders_processed&id='.$d['ebay_orders_id']),
                            $v
                        );
                        break;
                    case 'transaction_id':
                        $query = xtc_db_query(sprintf(
                                "SELECT orders_id FROM ebay_transactions WHERE transactionid='%s'",
                                $v
                        ));
                        if(xtc_db_num_rows($query)){
                            $record = xtc_db_fetch_array($query);
                            $v = sprintf('<a target="_blank" href="%s">%s</a>',
                                xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$record['orders_id']),
                                $v
                            );
                        }
                        break;
                }
                $content[] = ['text'=>$v,'params'=>'','align'=>'left','form'=>''];
            }
            $contents[] = $content;
        }
        yes_draw_pre_header();
        yes_draw_header(TITLE);
        echo '<a href="system.php"><button class="ui-button ui-corner-all ui-state-default" style="padding: 4px;">'.IMAGE_BACK.'</button></a>';
        echo '<p>Mit Klick auf den processed Wert, wird dieser Eintrag auf 1 gesetzt.</p>';
        echo $table->tableBlock_draw($contents);
        require(DIR_WS_INCLUDES . 'footer.php');
        require(DIR_WS_INCLUDES . 'application_bottom.php');
        exit;
        break;
    case 'cache':
        if(isset($_GET['viewCacheItem']) and $_GET['viewCacheItem'] != ''){
            $CachedString = $InstanceCache->getItem($_GET['viewCacheItem']);
            die( print_r($CachedString->get($_GET['viewCacheItem'])) );
        }
        if(isset($_GET['cache_key']) and is_countable($_GET['cache_key'])){
            $InstanceCache->deleteItems( $_GET['cache_key'] );
            $messageStack->add_session(sprintf(
                    'Die Cache Bereiche %s wurden geleert',
                    implode(', ',$_GET['cache_key'])
            ),'success');
            xtc_redirect(xtc_href_link('system.php'));
        }
        echo '<div class="main">';
        echo '<h3>Cache Manager</h3>';
        echo '<p>Folgende Cache Bereiche k&ouml;nnen geleert werden</p>';
        foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
            printf('<input type="checkbox" name="cache_key[]" value="%s" /><b><a onclick="viewCacheItem(\'%s\')" href="javascript:;">%s</a></b> verf&auml;llt am %s <span style="color:#555;"><i>Tags: %s</i></span><br />',
                    $cd->getKey(),
                    $cd->getKey(),
                    $cd->getKey(),
                    $cd->getExpirationDate()->format('d.m.Y H:i:s'),
                    implode(', ',$cd->getTags())
            );
        }
        echo yes_draw_href_button('Cache '.IMAGE_DELETE, 'javascript: delete_cache()', 'padding: 4px;', 'button');
        echo '&nbsp;'.yes_draw_href_button('File/Template Cache '.IMAGE_DELETE, 'javascript:delete_file_cache()', 'padding: 4px;', 'button');
        echo '</div>';
        exit;
        break;
    case 'cleanup':
        include('system.cleanup.php');
        exit;
        break;
    case 'ebay_notifications':
        include('system.ebay_notifications.php');
        exit;
        break;
    case 'email_export':
        if(isset($_POST['email_export_span'])){
            require_once(DIR_WS_CLASSES.'email_export.php');
            $sDateObj = new DateTime( '-'.$_POST['email_export_span'] );
            $sDate = $sDateObj->format('Y-m-d');
            $ee = new email_export( $sDate );
            $ee->export();
            exit;
        }
        echo '<div class="main">';
        echo '<p style="color: #666;">Beim Export wird eine ZIP Datei zum Download erzeugt. Dieses Archiv enthält dann alle Emails des gewählten Zeitraums im .eml Format und enthält Datum, Absender, Empfänger, Betreff, Body sowie alle gespeicherten Anhänge. Dateien im .eml Format können mit so gut wie jedem Email Programm geöffnet werden.</p>';
        echo xtc_draw_form('email_export', 'system.php', 'action=email_export', 'POST');
        echo '<fieldset>';
        echo '<legend>Exportiere Emails älter als<br /></legend>';
        echo xtc_draw_pull_down_menu('email_export_span',[
           ['id'=>'1 Month','text'=>'1 Monat'],
           ['id'=>'3 Month','text'=>'3 Monate'],
           ['id'=>'6 Month','text'=>'6 Monate'],
           ['id'=>'1 Year','text'=>'1 Jahr'],
        ]);
        echo '<br />*'.xtc_draw_checkbox_field('export_delete', 1, true, false);
        echo 'Exportierte Emails löschen?';
        echo '<br /><br /><input type="submit" value="Export" />';
        echo '<br /><br /><i>* Das l&ouml;schen der Emails aus der DB ist noch nicht implementiert, erstmal soll getestet werden ob das .eml Format ausreicht.</i>';
        echo '</fieldset></form></div>';
        
        exit;
        break;
    case 'cache_update_ebay_shippingmethods':
        $ye = error_reporting();
        error_reporting(E_ERROR);
        $key = 'ebay_shippingmethods';
        $item = $InstanceCache->getItem($key);
        if($item->isHit() == 1){
            $messageStack->add_session('eBay Versandmethoden Cache wurde entfernt','success');
            $InstanceCache->deleteItem($key); // ebay_shippingmethods
        }else{
            $messageStack->add_session('eBay Versandmethoden Cache existierte nicht und wurde nicht entfernt','error');
        }
        xtc_redirect(xtc_href_link('system.php'));
        break;
    case 'amazon_sp_allocate':
        $success = true;
        if(!isset($_POST['selling_partner_id']) or empty($_POST['selling_partner_id'])){
            $success = false;
            $messageStack->add_session("Keine Selling Partner ID gewählt",'error');
        }
        if(!isset($_POST['merchant_id']) or empty($_POST['merchant_id'])){
            $success = false;
            $messageStack->add_session("Keine Merchant ID gewählt",'error');
        }
        if($success){
            $spID = xtc_db_input($_POST['selling_partner_id']);
            $mID = xtc_db_input($_POST['merchant_id']);
            xtc_db_query(sprintf(
                    "UPDATE amazon_products SET selling_partner_id='%s' WHERE merchant_id='%s'",
                    $spID, $mID
            ));
            $messageStack->add_session("Amazon Artikel Merchant ID ".$mID." wurden Selling Partner ".$spID." zugewiesen.",'success');
        }
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'amazon_sp':
        
        $auth_file = main::get_secure_path().'AMAZON_SP_AUTH.json';
        if(!is_file($auth_file)){
            die('Es sind keine Amazon SP Auth Daten hinterlegt.');
        }
        $query = xtc_db_query(
                "SELECT amazon_products_id FROM amazon_products"
        );
        if(!xtc_db_num_rows($query)){
            die('Es sind keine Amazon Artikel im System erfasst.');
        }
        $sp_users = [['id'=>'','text'=>TEXT_SELECT]];
        $merchant_users = $sp_users;
        $auth = json_decode(file_get_contents($auth_file));
        foreach($auth->users as $k=>$u){
            $sp_users[] = ['id'=>"$k",'text'=>"$k"];
        }
        echo '<p>Die Zuweisungen der Amazon Artikel im YES System wurden in der Vergangenheit über die Merchant ID Ihres Amazon Händler Accounts verknüpft. Da nun eine Umstellung stattfand, müssen diese Zuweisungen korrigiert werden. Dazu wählen Sie den neuen und den alten Account und nach Klick auf Speichern werden alle Amazonartikel mit der neuen Zuweisung gespeichert.</p>';
        echo xtc_draw_form('allocate_sp_products','system.php?action=amazon_sp_allocate','','POST');
        echo 'Selling Partner ID: ';
        echo xtc_draw_pull_down_menu('selling_partner_id', $sp_users);
        echo '<br />(Alte) MWS Merchant ID: ';
        foreach(explode(':',MODULE_OTHER_AMAZON_AUTH_DATA) as $amazon_user){
            $cols = explode(',', $amazon_user);
            $merchant_users[] = ['id'=>$cols[0],'text'=>$cols[0]];
        }
        echo xtc_draw_pull_down_menu('merchant_id', $merchant_users);
        echo '<br /><input type="submit" value="Speichern" /></form>';
        exit;
        break;
    // ANHAND EINES EBAY EXPORTS DIE LOKALEN in_auction WERTE DER ARTIKEL
    // KORRIGIERDEN UND GGF AUKTIONEN BEENDEN
    case 'ebay_export_check_local':
        require_once('system.ebay_export_check_local.php');
        exit;
        break;
    case 'hitmeister_fulfillment_status':
    	if(isset($_POST['hitmeister_orders_units_id']) and sizeOf($_POST['hitmeister_orders_units_id'])){
    		foreach($_POST['hitmeister_orders_units_id'] as $hitmeister_orders_units_id){
    			$update_sql_array = array(
    				'fulfillment_sent'=>1
    			);
    			xtc_db_perform('hitmeister_orders_units',$update_sql_array,"update", 
    				"hitmeister_orders_units_id='".$hitmeister_orders_units_id."'"
    			);
    		}
    		echo '<h3 style="color: red">Es wurden '.sizeOf($_POST['hitmeister_orders_units_id']).' real.de Order Units intern als versendet markiert</h3>';
    	}
?>
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script>
$(function(){
	$('a#older4weeks').on('click',function(){
		var targetD = new Date();
		targetD.setDate(targetD.getDate() - 28); // DATUM 4 Wochen
		$('input[name="hitmeister_orders_units_id[]"]').each(function(){
			var D = new Date($(this).data('date_purchased'));
			if(D.getTime() < targetD.getTime()){
				$(this).prop('checked',true);
			}
		});
	});
});
</script>
<a href="javascript:;" id="older4weeks">&gt; 4 Wochen markieren</a><br /><hr noshade="noshade" />
<form action="system.php?action=hitmeister_fulfillment_status" method="POST">
<?php    	
        $query = xtc_db_query(sprintf(
                "SELECT hou.*,ho.hitmeister_id_order,o.orders_status, o.orders_id, o.date_purchased FROM hitmeister_orders_units hou LEFT JOIN hitmeister_orders ho USING(hitmeister_orders_id) LEFT JOIN orders o USING(orders_id) WHERE o.orders_status IN (%s)",
                implode(',',array(ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET))
        ));
        while($record = xtc_db_fetch_array($query)){
        	if($record['orders_id'] < 1){
        		continue;
        	}
            $checked = false;
		$history_query = xtc_db_query(sprintf(
		        "SELECT * FROM orders_status_history WHERE orders_id='%d' AND comments LIKE 'Real Order %s / Order Unit %s: Fulfillment sent%%'",
		        $record['orders_id'],
		        $record['hitmeister_id_order'],
		        $record['id_order_unit']
		        
		));
		if(xtc_db_num_rows($history_query)){
		    $checked = true;
		}
            printf('%s real.de Order %s / oID <a href="%s" target="_blank">%d</a> vom %s im Status %s<br />',
                    xtc_draw_checkbox_field('hitmeister_orders_units_id[]',$record['hitmeister_orders_units_id'],$checked,false,'data-date_purchased="'.$record['date_purchased'].'"'),
                    $record['hitmeister_id_order'],
                    xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$record['orders_id']),
                    $record['orders_id'],
                    $record['date_purchased'],
                    xtc_get_orders_status_name($record['orders_status'])
            );
        }
?>
	<input type="submit" value="Markierte Order Units in YES als Versendet markieren" />
	</form>
<?php	
        exit;
        break;
    case 'barcode_delete':
        $path = \main::get_exportdata_path();
        $exportddatafiles = 0;
        if ($handle = opendir($path)) {
            while (false !== ($file = readdir($handle))) { 
                //24 hours in a day * 3600 seconds per hour
                $filelastmodified = filemtime($path . $file);
                if((time()-$filelastmodified) > (24*3600*7*4) && is_file($path.$file) and substr($file,0,8) == 'BARCODE_'){
                   unlink($path . $file);
                   $exportddatafiles++;
                }
            }
            $messageStack->add_session('Es wurden '.$exportddatafiles.' gel&ouml;scht.','success');
            closedir($handle); 
        }else{
            $messageStack->add_session('Kann exportdata/ nicht lesen.','error');
        }
        xtc_redirect(xtc_href_link(basename(__FILE__)));
        break;
    case 'process_ebaymessages_clean':
        xtc_db_query(sprintf("DELETE FROM ebay_mymessage WHERE receivedate<='%s'",
                $SYSTEM_EBAY_MESSAGES_CLEAN_DATE
        ));
	$messageStack->add_session('Veraltete eBay Nachrichten wurden gel&ouml;scht.','success');
	xtc_redirect(basename(__FILE__));
        break;
    case 'cache_admin':
        include('system.cache_admin.php');
        exit;
        break;
    case 'amzfeeds':
        include('system.amazon_feed_status.php');
        exit;
        break;
    case 'update_database_table_structure':
        $ini_file = $basics->create_sql_structure_ini_file();
        $messageStack->add_session(sprintf('%s wurde erzeugt',basename($ini_file)),'success');
        xtc_redirect(xtc_href_link('system.php'));
        break;
    case 'in_auction_check':
        $products = array();
        $step = (isset($_REQUEST['step'])) ? (int)xtc_db_input($_REQUEST['step']) : 0;
        $max_items = 5000;
        $query = xtc_db_query(
                "SELECT count(products_id) as num FROM products"
        );
        $record = xtc_db_fetch_array($query);
        $total = $record['num'];
        
        printf('<p>Pr&uuml;fe %s bis %s von insgesamt %s Artikeln</p>',($step*$max_items),($step+1)*$max_items,$total);
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM products LIMIT %s, %s",
                ($step * $max_items),$max_items
        ));
        while($record = xtc_db_fetch_array($query)){
                $products[] = $record['products_id'];
        }
        $results = array();
        $errors = 0;
        foreach($products as $pID){
            $product = new product($pID);
            if(sizeOf($product->collies) and $product->info['in_auction']>0){
                printf('<li>Fehler: Set pID '.$product->info['products_id'].' darf keinen eigenen in_auction Bestand haben.');
                $errors++;
                continue;
            }
            $calc_in_auction = $product->get_auction_quantity_from_ebay_auctions();
            
            if($calc_in_auction != $product->info['in_auction']){
                $errors++;
                printf('<li>Fehler: pID '.$product->info['products_id'].' hat in_auction '.$product->info['in_auction'].' gespeichert, aber es wurden '.$calc_in_auction.' Stk ermittelt.');
            }
            continue;
        }
        if($errors > 0){
            printf('<p style="color: red;"><strong>%s Fehler</strong></p>',$errors);
        }
        if( ($step+1)*$max_items < $total){
            printf('<p><a href="%s">Weiter</a>',xtc_href_link(basename(__FILE__),'action='.$action.'&step='.($step+1)));
        }else{
            echo '<p>Alle Artikel durchlaufen</p>';
        }
        exit;
        break;
    case 'unused_master_clean':
	$master = array();
	$query = xtc_db_query(
		"SELECT p.products_id FROM products p WHERE products_master_status=1 AND products_id NOT IN (SELECT products_master FROM products WHERE products_master = p.products_id)"
	);
	while($record = xtc_db_fetch_array($query)){
	    $master[] = $record['products_id'];
	}
	foreach($master as $pID){
	    xtc_db_query(sprintf(
		    "UPDATE products SET products_master_status=0 WHERE products_id='%s'",
		    $pID
	    ));
	    $insert_sql_array = array(
		'products_id'=>$pID,
		'editor_id'=>$_SESSION['customer_id'],
		'date_saved'=>'now()',
		'comments'=>'[system] unused parents clean'
	    );
	    xtc_db_perform('products_history',$insert_sql_array);
	}
	$messageStack->add_session('Es wurden '.sizeOf($master).' Parents ohne Childs aktualisiert','success');
	xtc_redirect(basename(__FILE__));
	break;
    case 'smarty3_check':
	if(isset($_REQUEST['repair'])){
	    $cmd = 'grep -rlI "\`" '.DIR_FS_CATALOG.'templates/ | xargs sed -i "s/\`//g"';
	    echo '<p>Bitte den folgenden Befehl kopieren und in der Shell dieses Systems ausfuehren:</p>';
	    echo '<textarea name="" cols="'.(strlen($cmd)+4).'" rows="1">'.$cmd.'</textarea>';
	    echo '<p>Nach dem ausfuehren in der Shell <a href="?action=smarty3_check">hier erneut pr&uuml;fen</a></p>';
	    exit;
	}
	exec('grep -irI "\`" '.DIR_FS_CATALOG.'templates',$res);
	if(!sizeOf($res))
	    die('Keine Smarty 3 Fehlerquellen entdeckt');
	echo '<h3>Es wurden '.sizeOf($res).' Stellen gefunden in denen Smarty 3 einen Fehler produziert, aufgrund der Verwendung des Zeichens "`"</h3>';
	foreach($res as $line){
	    $line = str_replace(DIR_FS_CATALOG,'',$line);
	    $first = strpos($line,':');
	    $parts = array(
		substr($line,0,$first),
		substr($line,$first+1)
	    );
	    echo '<br /><b>'.$parts[0].'</b>'.$parts[1];
	}
	echo '<p>Wenn nur HTML Dateien gefunden wurden und die Stellen mit dem ung&uuml;ltigen Zeichen ` sich ALLE nur darauf beziehen, das ein value=" gesetzt wird, kann dieses automatisch korrigiert werden. Dabei wird das ung&uuml;ltige Zeichen einfach entfernt.</p>';
	echo '<p><i>Achtung: Wenn aber zb Javascript Teile im Suchergebnis sind oder der Teil sich nicht auf ein value="" bezieht, sollte dies UNBEDINGT manuell gefixt werden.</i></p>';
	echo '<a href="?action=smarty3_check&repair=1">Autom. Korrektur</a>';
	exit;
	break;
    case 'ebay_collie_quantity':
        die('Mario: Funktion ist erstmal deaktiviert, da products.in_auction umgestellt bzw optimiert wurde.');
ini_set('max_execution_time', 0);
	// BOF COLLIES
	$c = array();
	$query = xtc_db_query(sprintf(
		"SELECT DISTINCT collie_products_id FROM products_collies"
	));
	while($record = xtc_db_fetch_array($query)){
	    $c[] = $record['collie_products_id'];
	}
	$updates = array();
	foreach($c as $pID){
	    if(!isset($updates[ $pID ]))
		$updates[ $pID ] = 0;
	    $query = xtc_db_query(sprintf(
		    "SELECT quantity FROM ebay_auctions WHERE products_id='%s' AND status=0",
    		    $pID
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$updates[ $pID ] += $record['quantity'];
	    }
	}
	foreach($updates as $pID=>$in_auction){
	    $query = xtc_db_query(sprintf(
		    "SELECT in_auction FROM products WHERE products_id='%s'",
		    $pID
	    ));
	    $record = xtc_db_fetch_array($query);
	    $update_sql_array = array(
		'in_auction'=>$in_auction
	    );
	    xtc_db_perform('products',$update_sql_array,'update',"products_id='".$pID."'");
	    $insert_sql_array = array(
		'products_id'=>$pID,
		'editor_id'=>0,
		'date_saved'=>'now()',
		'comments'=>'BGFX '.$record['in_auction'].':'.$in_auction
	    );
	    xtc_db_perform('products_history',$insert_sql_array);
	}
	// BOF SETS
	$s = array();
	$query = xtc_db_query(sprintf(
		"SELECT DISTINCT products_id FROM products_collies"
	));
	while($record = xtc_db_fetch_array($query)){
	    $s[] = $record['products_id'];
	}
	foreach($s as $pID){
	    $update_sql_array = array(
		'in_auction'=>0
	    );
	    xtc_db_perform('products',$update_sql_array,'update',"products_id='".$pID."'");
	    $insert_sql_array = array(
		'products_id'=>$pID,
		'editor_id'=>0,
		'date_saved'=>'now()',
		'comments'=>'BGFX SET '.$record['in_auction'].':0'
	    );
	    xtc_db_perform('products_history',$insert_sql_array);
	}
die('FERTIG');
	$messageStack->add_session('Collie in_auction ermittelt und Sets in_auction genullt','success');
	xtc_redirect(xtc_href_link('system.php'));
	exit;
	break;
    case 'ebay_products_ebay_plus':
		xtc_db_query("UPDATE ebay_products SET ebay_plus=1");
		$messageStack->add_session('Alle Sammlerartikel wurden auf eBay Plus aktualisiert','success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
    case 'ebay_auctions_ebay_plus':
		xtc_db_query("UPDATE ebay_auctions SET ebay_plus=1 WHERE status=2"); // zu unique fuer eine YES4Trade Klassenfunktion
		$messageStack->add_session('Alle Auktionen wurden auf eBay Plus aktualisiert','success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
    case 'smarty_set_check':
        $path = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE;
        if(substr($path,-1) != '/'){
            $path .= '/';
        }
        $files = $basics->get_directory_subdirectories($path);
        printf('<p>Checking Set %s with %s Files</p>',$path,sizeOf($files));
        $msg = array();
        $smarty = new yesSmarty;
        $smarty->assign('language','german');
        foreach($files as $file){
            if(strstr($file,'/admin/')){
                $smarty->assign('language_path',DIR_FS_CATALOG.'lang/german/admin/german.conf');
            }else{
                $smarty->assign('language_path',DIR_FS_CATALOG.'lang/german/german.conf');
            }
            if(!is_readable($file)){
                $msg[] = sprintf('Template %s: kann nicht gelesen werden',$file);
                continue;
            }
            $content = file_get_contents($file);
            if(strlen($content) == 0){
                $msg[] = sprintf('Template %s: ist leer',$file);
                continue;
            }
            try{
                ob_start();
                $smarty->display($file);
                ob_end_clean();
            }catch(Exception $ex){
                yes_debug($ex);
                $msg[] = sprintf('Template %s: <b>%s</b> on line %s',$file,$ex->getMessage(),$ex->getLine());
            }
        }
        printf('<p><i>Es wurden %s Fehler in den Templates gefunden</i></p>',sizeOf($msg));
        if(sizeOf($msg)){
            echo '<ul style="padding: 8px; font-size: 14px; font-family: arial, helvetica, sans-serif;list-style-type: none;">';
            foreach($msg as $ms){
                printf('<li style="padding: 5px;">%s</li>',$ms);
            }
            echo '</ul>';
        }
        exit;
        break;
    case 'smarty_check':
	$upload_folder = DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/'; //Das Upload-Verzeichnis
	$filename = pathinfo($_FILES['smarty_file']['name'], PATHINFO_FILENAME);
	$extension = strtolower(pathinfo($_FILES['smarty_file']['name'], PATHINFO_EXTENSION));


	$allowed_extensions = array('html', 'htm', 'tpl', 'txt');
	if(!in_array($extension, $allowed_extensions)) {
		die("Ung&uuml;ltige Dateiendung. Nur ".implode(', ',$allowed_extensions)."-Dateien sind erlaubt");
	}

	$max_size = 1000*1024; //500 KB
	if($_FILES['smarty_file']['size'] > $max_size) {
		die("Bitte keine Dateien gr&ouml;&szlig;er 1MB hochladen");
	}

	//Pfad zum Upload
	$new_path = $upload_folder.'syntax_check_smarty.html';

	//Neuer Dateiname falls die Datei bereits existiert
	if(file_exists($new_path)) { //Falls Datei existiert, h�nge eine Zahl an den Dateinamen
	    unlink($new_path);
	}

	//Alles okay, verschiebe Datei an neuen Pfad
	move_uploaded_file($_FILES['smarty_file']['tmp_name'], $new_path);
    $smarty->assign('language','german');
	$smarty->display($new_path);
	unlink($new_path);
	die('Template File Syntax OK<br /><a href="'.basename(__FILE__).'">Systemverwaltung</a>');
	break;
    case 'apad':
		require_once(DIR_WS_CLASSES.'product.php');
		require_once(DIR_WS_CLASSES.'Amazon_Product_Ads.php');
		$a = new Amazon_Product_Ads;
		$a->get_export_csv_row( new product(100) );
exit;
		break;
    case 'order_source':
	$orders = array();
	$query = xtc_db_query(sprintf(
		"SELECT orders_id,orders_split_id,ebay_id,combined_orders_id,customers_ip FROM orders WHERE source='' AND date_purchased>'2013-01-01'"
	));
	while($record = xtc_db_fetch_array($query)){
	    $orders[$record['orders_id']] = array(
		'split_id'=>$record['orders_split_id'],
		'ebay_id'=>$record['ebay_id'],
		'combined_orders_id'=>$record['combined_orders_id'],
		'ip'=>$record['customers_ip']
	    );
	}
	if(!sizeOf($orders)){
	    $messageStack->add_session('Keine Auftraege ohne Quelle','error');
	    xtc_redirect(xtc_href_link('system.php'));
	}
	$todo = array();
	foreach($orders as $oID=>$o){
	    if($o['split_id'] > 0){
		$query = xtc_db_query(sprintf(
			"SELECT source FROM orders WHERE orders_id='%s'",
			$o['split_id']
		));
		$record = xtc_db_fetch_array($query);
		if($record['source'] != ''){
		    $todo[ $oID ] = $record['source'];
		}else{
		    $todo[ $oID ] = 'counter';
		    //printf('#%s gesplittet aus #%s (auch ohne Source)<br />',$oID,$o['split_id']);
		}
	    }elseif($o['combined_orders_id'] > 0){
		$query = xtc_db_query(sprintf(
			"SELECT source FROM orders WHERE orders_id='%s'",
			$o['combined_orders_id']
		));
		$record = xtc_db_fetch_array($query);
		if($record['source'] != ''){
		    $todo[ $oID ] = $record['source'];
		}else{
		    $todo[ $oID ] = 'counter';
		    //printf('#%s kombiniert aus #%s (auch ohne Source)<br />',$oID,$o['split_id']);
		}
	    }else{
		if($o['ebay_id'] != ''){
		    $todo[ $oID ] = 'ebay';
		}else{
		    $query = xtc_db_query(sprintf(
			    "SELECT orders_id,source FROM orders WHERE combined_orders_id='%s'",
			    $oID
		    ));
		    if(xtc_db_num_rows($query)){
			$comb = array();
			while($record = xtc_db_fetch_array($query)){
			    $comb[] = sprintf('#%s (%s)',$record['orders_id'],$record['source']);
			}
			$todo[ $oID ] = 'counter';
			printf('#%s ist erzeugt worden aus %s',implode(', ',$comb));
		    }else{
			if($o['ip'] != ''){
			    $todo[ $oID ] = 'shop';
			}else{
			    $query = xtc_db_query(sprintf(
				    "SELECT * FROM orders_status_history WHERE orders_id='%s' limit 1",
				    $oID
			    ));
			    if(xtc_db_num_rows($query)){
				while($record = xtc_db_fetch_array($query)){
				    if(substr($record['comments'],0,strlen('Amazon Auftrag')) == 'Amazon Auftrag' ){
					$todo[$oID] = 'amazon';
				    }else{
		    $todo[ $oID ] = 'counter';
//					printf('#%s ist nicht gesplittet, shop, kombiniert oder eBay -',$oID);
//					printf("&nbsp;&nbsp;&nbsp;<i>%s: %s</i><br />",$record['date_added'],$record['comments']);
				    }
				}
			    }
			}
		    }
		}
	    }
	    
	}
	if(!isset($_REQUEST['process']) and $_REQUEST['process'] != 1){
	    echo '<p><b>'.sizeOf($todo).' Auftraege koennen automatisch aktualisiert werden</b></p><a href="system.php?action=order_source&process=1">JETZT AENDERN</a>';
	    yes_debug($todo);
	}else{
	    $c = 0;
	    foreach($todo as $oID => $source){
		xtc_db_query(sprintf(
			"UPDATE orders SET source='%s' WHERE orders_id='%s'",
			$source,$oID
		));
		$order = new order($oID);
		$order->add_history($order->info['orders_status'],false,'[system bugfix source: '.$source.']');
		$c++;
	    }
	    die('Es wurden '.$c.' Auftraege aktualisiert.');
	}
	exit;
	break;
    case 'ot_taxrate':
	$query = xtc_db_query(sprintf(
		"SELECT DISTINCT(orders_id) AS oid FROM orders_total WHERE tax_rate_percent NOT IN(0,19,7,16,5) and class != 'ot_payment_fee'",
		ORDERS_STATUS_STORNIERT
	));
	$process = (isset($_REQUEST['process']) and $_REQUEST['process'] == 1) ? true : false;
	if(!$process){
		echo '<p>Beim kombinieren durch eBay Payment wurde in der Tabelle orders_total der Eintrag fuer ot_tax fehlerhaft angelegt. Fuer die Spalte tax_rate_percent wurde dort ein falscher Wert gespeichert. Erkennbar ist dieser Fehler, indem ich pruefe ob tax_rate_percent Angabe bei einem ot_tax Eintrag nicht 0, 19, 7, 16 oder 5% ist.</p>';
		printf(
			"Es sind %s potentiell ungueltige Auftraege vorhanden (tax_rate_percent bei ot_tax nicht 0,7,19,16 oder 5)<br />",
			xtc_db_num_rows($query)
		);
	}
	$orders = array();
	while($record = xtc_db_fetch_array($query)){
		$orders[] = $record['oid'];
	}
	foreach($orders as $oID){
		$query = xtc_db_query(sprintf(
			"SELECT * FROM orders_total WHERE orders_id=%s AND tax_rate_percent NOT IN(0,19,7,16,5) and class != 'ot_payment_fee'",
			$oID
		));
		$updates = array();
		while($record = xtc_db_fetch_array($query)){
			if(strstr($record['title'],'Enth. UST')){
				$ust = str_replace('%','',substr($record['title'],10,strlen($record['title'])));
				$ust = number_format($ust,4,'.','');
				if(!$process){
					printf('[oID %s] <b>%s</b> Fehlerhafter Wert MwSt Satz: %s / Neuer Wert fuer MwSt Satz %s<br />',$oID,$record['title'],$record['tax_rate_percent'],$ust);
				}else{
					$updates[] = array(
						'ot_id'=>$record['orders_total_id'],
						'tax_rate_percent'=>$ust
					);
				}
			}

		}
		foreach($updates as $update){
			xtc_db_query(sprintf(
				"UPDATE orders_total SET tax_rate_percent='%s' WHERE orders_total_id='%s'",
				$update['tax_rate_percent'],$update['ot_id']
			));
		}
	}
	if(!$process){
		die(sprintf(
			'<br />Stichproben gemacht? Stichproben zur Kontrolle markiert? <a href="%s">Jetzt Reparieren</a>',
			xtc_href_link(basename(__FILE__),'action=ot_taxrate&process=1')
		));
	}else{
		$messageStack->add_session('Es wurden '.sizeOf($orders).' Auftraege repariert','success');
		xtc_redirect(xtc_href_link(basename(__FILE__),'action=ot_taxrate'));
	}
	exit;
		break;
    case 'amazon_feed_clear':
	xtc_db_query("TRUNCATE `amazon_feeds`");
	xtc_db_query("TRUNCATE `amazon_feeds_order_fulfillments`");
	xtc_db_query("TRUNCATE `amazon_feeds_price_items`");
	xtc_db_query("TRUNCATE `amazon_feeds_product_listing`");
	xtc_db_query("TRUNCATE `amazon_feeds_quantity_items`");
	$messageStack->add_session('Vorhandene Amazon Feeds wurden geloescht.','success');
	xtc_redirect(xtc_href_link(basename(__FILE__)));
	break;
    case 'conditions_update':
	foreach($_REQUEST['pc'] as $old_string => $new_conditions_id){
		$old_string = urldecode($old_string);
		$query = xtc_db_query(sprintf(
			"SELECT products_id FROM products_description WHERE products_condition='%s' AND language_id='%s'",
			$old_string,$_SESSION['languages_id']
		));
		echo 'Update '.xtc_db_num_rows($query).' matches for "'.$old_string.'"<br />';
		$products = array();
		while($record = xtc_db_fetch_array($query)){
			$products[] = $record['products_id'];
		}
		foreach($products as $pID){
			xtc_db_query(sprintf(
				"UPDATE products SET products_conditions_id='%s' WHERE products_id='%s'",
				$new_conditions_id,$pID
			));
		}
	}
	$messageStack->add_session('Artikelzustaende wurden aktualisiert');
	xtc_redirect(xtc_href_link(basename(__FILE__)));
	break;
    case 'conditions':
	$conditions = \YES4Trade\Model\products_conditions::get_list($_SESSION['languages_id']);
        $cond = [];
	if(!sizeOf($conditions)){
	    die('<h3>Es sind keine Artikel-Zustands-Auspraegungen hinterlegt.</h3><a href="products_conditions.php">Anlegen</a>');
	}
	foreach($conditions as $c){
	    $cond[] = array(
                'id'=>$c['products_conditions_id'],
                'text'=>$c['title']
            );
	}
	echo '<h2>Folgende Zustandsbeschreibungen sind zu Artikeln hinterlegt und koennen ersetzt werden.</h2>';
	echo xtc_draw_form('pcall', basename(__FILE__), 'action=conditions_update');
	$query = xtc_db_query("SELECT DISTINCT(products_condition) as cond FROM products_description WHERE language_id='".$_SESSION['languages_id']."' AND products_condition!=''");
	while($record = xtc_db_fetch_array($query)){
	    echo $record['cond'].' = '.xtc_draw_pull_down_menu('pc['.urlencode($record['cond']).']',$cond,'').'<br />';
	}
	echo '<input type="submit" />';
	echo '</form>';
	exit;
	break;
    case 'ebay_products_ean':
	if(!isset($_REQUEST['process'])){
	    echo '<h1>EAN/ISBN Zuweisung Sammlerprodukte</h1>';
	}
	if(!isset($_REQUEST['ean_target'])){
	    $html = sprintf(
		    '<h2>Artikel products_ean in Sammlerprodukten verwenden als:</h2><a href="%s">EAN</a> oder <a href="%s">ISBN</a>',
		    xtc_href_link(basename(__FILE__),xtc_get_all_get_params().'ean_target=ean'),
		    xtc_href_link(basename(__FILE__),xtc_get_all_get_params().'ean_target=isbn')
	    );
	    die($html);
	}
	$products = array();
	$query = xtc_db_query(
		"SELECT DISTINCT(products_id) FROM ebay_products WHERE products_id>0"
	);
	while($record = xtc_db_fetch_array($query)){
	    $products[] = $record['products_id'];
	}
	$query = xtc_db_query(
		"SELECT DISTINCT(products_id) FROM ebay_variations WHERE products_id>0"
	);
	while($record = xtc_db_fetch_array($query)){
	    if(!in_array($record['products_id'],$products)){
		$products[] = $record['products_id'];
	    }
	}
	if(!isset($_REQUEST['process'])){
	    $html = sprintf(
		    '<h2>Es wurden %s verschiedene pIDs in Sammlerprodukten und dessen Varianten ermittelt, sollen diese Sammlerprodukte nun mit der products_ean des entsprechenden Artikels als "%s" hinterlegt werden?</h2><a href="%s">Ja</a> oder <a href="%s">Abbrechen</a>',
		    sizeOf($products),$_REQUEST['ean_target'],
		    xtc_href_link(basename(__FILE__),xtc_get_all_get_params().'process=1'),
		    xtc_href_link(basename(__FILE__))
	    );
	    die($html);
	}
	// wenn ean, dann ggf vorhandene isbn loeschen und umgekehrt
	xtc_db_query(sprintf(
		"UPDATE ebay_products SET %s=''",
		(($_REQUEST['ean_target'] == 'ean')?'isbn':'ean')
	));
	xtc_db_query(sprintf(
		"UPDATE ebay_variations SET %s=''",
		(($_REQUEST['ean_target'] == 'ean')?'isbn':'ean')
	));
	$updated = 0;
	foreach($products as $products_id){
	    $query = xtc_db_query(sprintf("SELECT products_ean FROM products WHERE products_id='%s'",
		    $products_id
	    ));
	    $record = xtc_db_fetch_array($query);
	    if(empty($record['products_ean'])){
		continue;
	    }
	    xtc_db_query(sprintf(
		    "UPDATE ebay_products SET %s='%s' WHERE products_id='%s'",
		    $_REQUEST['ean_target'],$record['products_ean'],$products_id
	    ));
	    xtc_db_query(sprintf(
		    "UPDATE ebay_variations SET %s='%s' WHERE products_id='%s'",
		    $_REQUEST['ean_target'],$record['products_ean'],$products_id
	    ));
	    $updated++;
	}
	$messageStack->add_session('Es wurden die '.$_REQUEST['ean_target'].' der Sammlerartikel (inkl. Varianten) zu '.$updated.' verschiedenen Artikeln aktualisiert.','success');
	xtc_redirect(xtc_href_link(basename(__FILE__)));
	break;
    case 'distributor_contacts_upgrade_process':
	xtc_db_query(sprintf(
		"ALTER TABLE  `distributor_contacts` CHANGE  `contact_name`  `contact_firstname` VARCHAR( 64 ) COLLATE %s NOT NULL DEFAULT  ''",
		xtc_db_input($_REQUEST['Collation'])
	));
	xtc_db_query(sprintf(
		"ALTER TABLE  `distributor_contacts` ADD  `contact_lastname` VARCHAR( 64 ) COLLATE %s NOT NULL DEFAULT  ''",
		xtc_db_input($_REQUEST['Collation'])
	));
	foreach($_REQUEST['contact_firstname'] as $id=>$value){
	    $update_sql_array = array(
		'contact_firstname'=>$value,
		'contact_lastname'=>$_REQUEST['contact_lastname'][$id]
	    );
	    xtc_db_perform('distributor_contacts',$update_sql_array,'update',"distributor_contacts_id='".$id."'");
	}
	$messageStack->add_session('Lieferanten Kontakte wurden aktualisiert.','success');
	xtc_redirect('distributor.php');
	break;
    case 'distributor_contacts_upgrade':
	$check_query = xtc_db_query("SHOW FULL COLUMNS FROM distributor_contacts WHERE Field =  'contact_name'");
	if(!xtc_db_num_rows($check_query)){
	    die('<h3>Das Lieferanten-Kontakt Upgrade ist bereits erfolgt.</h3>');
	}
	$check = xtc_db_fetch_array($check_query);
	$query = xtc_db_query("SELECT distributor_contacts_id,contact_name FROM distributor_contacts");
	echo '<h3>Lieferanten Kontakte in Vorname und Nachname splitten</h3>';
	echo xtc_draw_form('distributor_contacts_upgrade_form','system.php','action=distributor_contacts_upgrade_process','POST');
	echo xtc_draw_hidden_field('Collation',$check['Collation']);
	echo '<table border="1"><thead><tr><th>Original contact_name</th><th>Neuer contact_firstname</th><th>Neuer contact_lastname</th></tr></thead><tbody>';
	while($record = xtc_db_fetch_array($query)){
	    $parts = explode(' ',$record['contact_name']);
	    if(sizeOf($parts) == 1){
		$fn = '';
		$ln = $parts[0];
	    }else{
		$ln = '';
		$fn = $parts[0];
		for($i=1;$i<sizeOf($parts);$i++){
		    if(!empty($ln)){
			$ln .= ' '.$parts[$i];
		    }else{
			$ln .= $parts[$i];
		    }
		}
	    }
	    printf('<tr><td>%s</td><td>%s</td><td>%s</td></tr>',
		    $record['contact_name'],
		    xtc_draw_input_field('contact_firstname['.$record['distributor_contacts_id'].']',$fn),
		    xtc_draw_input_field('contact_lastname['.$record['distributor_contacts_id'].']',$ln)
	    );
	}
	echo '</tbody></table><input type="submit"></form>';
	exit;
	break;
    case 'amazon_update_data':
	$tables = array('amazon_feeds', 'amazon_orders', 'amazon_products', 'amazon_settlements');
	$authdataparts = explode(',',MODULE_OTHER_AMAZON_AUTH_DATA);
	foreach($tables as $table){
	    xtc_db_query(sprintf(
		    "UPDATE %s SET merchant_id='%s'",
		    $table,$authdataparts[0]
	    ));
	}
	$messageStack->add_session('Amazon Datens&auml;tze wurden Seller '.$authdataparts[0].' zugewiesen.','success');
	xtc_redirect(xtc_href_link('system.php'));
	break;
    case 'amazon_switch_auth':
	if(!defined('MODULE_OTHER_AMAZON_MERCHANT_ID')){
	    die('Konvertierung der Amazon Auth Daten nicht m&ouml;glich');
	}
	$keys = array(
	    'MODULE_OTHER_AMAZON_MERCHANT_ID',
	    'MODULE_OTHER_AMAZON_MARKETPLACE_ID',
	    'MODULE_OTHER_AMAZON_MERCHANT_IDENTIFIER',
	    'MODULE_OTHER_AMAZON_MWSAUTHTOKEN'
	);
	$new_config_values = array();
	foreach($keys as $key){
	    $new_config_values[] = constant($key);
	    xtc_db_query(sprintf(
		    "DELETE FROM %s WHERE configuration_key='%s'",
		    TABLE_CONFIGURATION,$key
	    ));
	}
	xtc_db_query(sprintf(
		"insert into %s ( configuration_key, configuration_value,  configuration_group_id, sort_order, use_function, set_function, date_added) values ('MODULE_OTHER_AMAZON_AUTH_DATA', '%s',  '6', '10', 'yes_get_amazon_auth_data','yes_cfg_get_amazon_auth_input(', now())",
		TABLE_CONFIGURATION,implode(',',$new_config_values)
	));
	$messageStack->add_session('Amazon Auth Daten wurden neu gespeichert.','success');
	xtc_db_query("DELETE FROM configuration WHERE configuration_key IN('MODULE_OTHER_AMAZON_REVISE','MODULE_OTHER_AMAZON_REVISE_QTY','MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY')");
	xtc_db_query("insert into configuration ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_REVISE', 'False',  '6', '11', 'xtc_cfg_select_option(array(\'True\',\'False\'), ', now())");
	xtc_db_query("insert into configuration ( configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_OTHER_AMAZON_REVISE_QTY', '0',  '6', '12', '', now())");
	xtc_db_query("INSERT INTO  `configuration` (`configuration_id` ,`configuration_key` ,`configuration_value` ,`configuration_group_id` ,`sort_order` ,`last_modified` ,`date_added` ,`use_function` ,`set_function`) VALUES (NULL ,  'MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY',  '3',  '6',  '13',  '2015-04-29 00:00:00',  '2015-04-29 00:00:00', NULL , NULL)");
	$messageStack->add_session('MODULE_OTHER_AMAZON_REVISE, MODULE_OTHER_AMAZON_FULFILLMENT_LATENCY und MODULE_OTHER_AMAZON_REVISE_QTY hinzugef&uuml;gt','success');
    $InstanceCache->deleteItem('configuration');
	xtc_redirect(xtc_href_link('system.php'));
	break;
    case 'order_copy':
	echo xtc_draw_form('order_copy',FILENAME_ORDERS,'','GET').xtc_draw_hidden_field('action','copy').xtc_draw_hidden_field('admin','1');
	printf('<b>Auftragsnummer:</b> %s<br />',xtc_draw_input_field('oID','0','size="7" maxlength="10"'));
	printf('<b>Anzahl Kopien:</b> %s<br />',xtc_draw_input_field('num','1','size="3" maxlength="4"'));
	printf('<b>Auftragsstatus Kopien:</b> %s<br />',xtc_draw_pull_down_menu('status',  xtc_get_orders_status(),ORDERS_STATUS_OFFEN));
	echo yes_draw_href_button(IMAGE_COPY, '', '', 'submit');
	exit;
	break;
    case 'customers_account':
		require_once(DIR_WS_CLASSES.'customer.php');
		$customers = array();
		$query = xtc_db_query(sprintf(
			"SELECT customers_id FROM %s",
			TABLE_CUSTOMERS
		));
		while($record = xtc_db_fetch_array($query)){
			$customers[] = $record['customers_id'];
		}
		foreach($customers as $customers_id){
			$customer = new customer($customers_id);
			$customer->update_current_account_value();
		}
		$messageStack->add_session(sprintf('Es wurden zu %s Kundenkonten die Ums&auml;tze neu errechnet.',sizeOf($customers)),'success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
	case 'mario':
		$deleted = 0;
		$q = xtc_db_query("SELECT ebay_variations_sets_id,ebay_products_id FROM ebay_variations_sets");
		while($r = xtc_db_fetch_array($q)){
			$q2 = xtc_db_query(sprintf(
				"SELECT id FROM ebay_products WHERE id='%s'",
				$r['ebay_products_id']
			));
			if(!xtc_db_num_rows($q2)){
				xtc_db_query(sprintf(
					"DELETE FROM ebay_variations_sets WHERE ebay_variations_sets_id='%s'",
					$r['ebay_variations_sets_id']
				));
				$deleted++;
			}
		}
		die($deleted.' verwaiste ebay_variations_sets Eintraege geloescht');
		exit;
		break;

    case 'products_inventur_qty':
	$start = isset($_GET['start']) ? $_GET['start'] : 0;
	$limit = isset($_GET['limit']) ? $_GET['limit'] : 10000;
//	include("includes/application_top.php");
	$query = xtc_db_query("SELECT COUNT(p.products_id) as anz FROM products p LEFT JOIN products_collies pc USING(products_id) WHERE pc.products_id IS NULL");
	$record = xtc_db_fetch_array($query);
	$total = (int)$record['anz'];
	$status = '';
	if(isset($_REQUEST['submitted'])){
		$query = xtc_db_query("SELECT p.products_id,p.products_quantity FROM products p LEFT JOIN products_collies pc USING(products_id) WHERE pc.products_id IS NULL LIMIT $start,$limit");
		while($record = xtc_db_fetch_array($query)){
			$insert_sql_array = array(
				'products_id'=>$record['products_id'],
				'editor_id'=>0,
				'date_saved'=>'now()',
				'comments'=>'[PHYS-BESTAND-'.date('Y-m-d') .'] '.$record['products_quantity']
			);
			xtc_db_perform('products_history',$insert_sql_array);
		}
		$status = "Artikelhistorie geschrieben (Start: $start, Limit: $limit)";
		$start = $start+$limit;
		die(json_encode(array(
		    'MSG'=>$status,
		    'START'=>$start,
		    'REST'=>$total-$start
		)));
	}
?>
<script type="text/javascript">
    function write_products_history_qty(){
	$.ajax({
	    url:'system.php?'+$('form[name="write_products_history_qty_form"]').serialize(),
	    dataType: 'json',
	    success: function(json){
		alert(json.MSG);
		$('form[name="write_products_history_qty_form"] input[name="start"]').val(json.START);
		if(json.REST <= 0){
		    $('#modal_window').dialog('destroy');
		}
	    }
	});
    }
</script>
<h1>Insgesamt <?php echo $total; ?> Artikel</h1>
<?php echo $status; ?>
<form method="get" onsubmit="return false;" name="write_products_history_qty_form">
<fieldset>
	<legend>Call Parameter</legend>
	Start: <input type="text" name="start" value="<?php echo $start; ?>"><br />
	Limit (max. Anzahl Artikel je Durchlauf): <input type="text" name="limit" value="<?php echo $limit; ?>"><br />
	<input type="button" value="Historien Schreiben" onclick="write_products_history_qty()" />
	<input type="hidden" name="submitted" value="1" />
	<input type="hidden" name="action" value="products_inventur_qty" />
</fieldset>
</form>	
<?php
	exit;
	break;
    case 'recursion_check':
		$query = xtc_db_query(sprintf(
			"SELECT c.categories_id,c.parent_id FROM categories c"
		));
		$path = array();
$unique = array();
		while($r = xtc_db_fetch_array($query)){
			if(!isset($unique[$r['categories_id']])){
				if($r['categories_id'] == $r['parent_id']){
					echo '<br />KATEGORIE '.$r['categories_id'].' hat sich selbst als parent_id - REKURSIONSFEHLER<br />';
				}
				if(isset($unique[$r['parent_id']]) and $unique[$r['parent_id']] == $r['categories_id']){
					echo '<br /><b>[Rekursionsfehler]</b> Kategorie '.$r['parent_id'].' und '.$r['categories_id'].' haben sich gegenseitig als parent_id';
				}
				$unique[$r['categories_id']] = $r['parent_id'];
			}else{
				die('DOPPELTER EINTRAG FUER '.$r['categories_id']);
			}
		}
		die('<p>Rekursionstest abgeschlossen</p>');
		break;
    case 'ebay_update_process':
	switch($_REQUEST['name']){
	    case 'DispatchTimeMaxDetails':
		$table = 'ebay_durations';
		break;
	    case 'CurrencyDetails':
		$table = 'ebay_currencies';
		break;
	    case 'ShippingServiceDetails':
		$res = $EBAYAPI->get_ebay_details('ShippingServiceDetails');
		$data_to_save = array();
		foreach($res->ShippingServiceDetails as $sd){
		    if(in_array($sd->ShippingService,$_REQUEST['values'])){
			$inter = ($sd->InternationalService == 1) ? 'international' : 'national';
			$data_to_save[ $sd->ShippingService ] = array(
			    'source'=>$inter,
			    'title'=>$sd->Description
			);
		    }
		}
		$table = 'ebay_shippingmethods';
		break;
	}
	if(!isset($table)){
	    die('Unknown config module');
	}
	xtc_db_query(sprintf("DELETE FROM %s",$table));
	if(sizeOf($_REQUEST['values'])){
	    foreach($_REQUEST['values'] as $nr=>$val){
		switch($_REQUEST['name']){
		    case 'DispatchTimeMaxDetails':
			$insert_sql_array = array(
			    'id'=>(int)xtc_db_input($val),
			    'duration'=>(int)xtc_db_input($val)
			);
			break;
		    case 'CurrencyDetails':
			$parts = explode('_',$val);
			$insert_sql_array = array(
			    'id'=>$nr,
			    'symbol'=>xtc_db_input($parts[0]),
			    'currency_name'=>xtc_db_input($parts[1])
			);
			break;
		    case 'ShippingServiceDetails':
			$insert_sql_array = array(
			    'ebay_shippingmethods_id'=>$nr,
			    'shippingmethod'=>$val,
			    'source'=>$data_to_save[ $val ]['source'],
			    'title'=>$data_to_save[ $val ]['title']
			);
			break;
		}
		xtc_db_perform($table,$insert_sql_array);
	    }
	}
	$messageStack->add_session(sprintf('Die eBay Konfiguration %s wurde synchronisiert.'),'success');
	xtc_redirect(xtc_href_link('system.php',xtc_get_all_get_params(array('name','action')).'action=ebay_update'));
	exit;
	break;
    case 'ebay_update':
	$name = (isset($_REQUEST['name']))?$_REQUEST['name']:'CurrencyDetails';
	$_values = array(
		/*'CountryDetails',*/
		'CurrencyDetails',
		'DispatchTimeMaxDetails',
		/*'PaymentOptionDetails',*/
		/*'RegionDetails',*/
		/*'ShippingLocationDetails',*/
		'ShippingServiceDetails',
		/*'SiteDetails',*/
		/*'URLDetails',*/
		/*'TimeZoneDetails',
		'RegionOfOriginDetails',*/
		/*'ReturnPolicyDetails',*/
		/*'ListingStartPriceDetails',*/
		/*'BuyerRequirementDetails',*/
		/*'ListingFeatureDetails',
		'VariationDetails',
		'ExcludeShippingLocationDetails',
		'RecoupmentPolicyDetails'*/
	);
	$values = array();
	foreach($_values as $v){
		$values[] = array('id'=>$v,'text'=>$v);
	}
	$res = $EBAYAPI->get_ebay_details($name);
	$smarty->assign(array(
	    'name'=>$name,
	    'input'=>xtc_draw_pull_down_menu('name',$values,$name),
	    'form'=>xtc_draw_form('system_ebay_conf','system.php',xtc_get_all_get_params(array('name'))),
	    'form_end'=>'</form>'
	));
	$detail_values = array();
	$local_values = array();
	$_locals = array();
	switch($name){
	    case 'ShippingServiceDetails':
		$query = xtc_db_query("SELECT * FROM ebay_shippingmethods");
		while($record = xtc_db_fetch_array($query)){
		    $local_values[] = array(
			'id'=>$record['shippingmethod'],
			'text'=>'<span title="'.$record['shippingmethod'].'">'.$record['title'].'</span> ('.$record['source'].')'
		    );
		    $_locals[] = $record['shippingmethod'];
		}
		$details = $res->getShippingServiceDetails();
		foreach($details as $type){
		    $inter = ($type->InternationalService == 1) ? 'international' : 'national';
		    $detail_values[] = array(
			'id'=>$type->ShippingService,
			'text'=>$type->Description . ' ('.$inter.')',
			'saved'=>(in_array($type->ShippingService,$_locals)) ? true : false
		    );
		}
		break;
	    case 'CurrencyDetails':
		$query = xtc_db_query("SELECT * FROM ebay_currencies");
		while($record = xtc_db_fetch_array($query)){
		    $local_values[] = array(
			'id'=>$record['symbol'],
			'text'=>$record['currency_name'].' ('.$record['symbol'].')'
		    );
		    $_locals[] = $record['symbol'];
		}
		$details = $res->getCurrencyDetails();
		foreach($details as $type){
		    $detail_values[] = array(
			'id'=>$type->Currency.'_'.$type->Description,
			'text'=>$type->Description . ' ('.$type->Currency.')',
			'saved'=>(in_array($type->Currency,$_locals)) ? true : false
		    );
		}
		break;
	    case 'DispatchTimeMaxDetails':
		$query = xtc_db_query("SELECT * FROM ebay_durations");
		while($record = xtc_db_fetch_array($query)){
		    $local_values[] = array(
			'id'=>$record['duration'],
			'text'=>$record['duration']
		    );
		    $_locals[] = $record['duration'];
		}
		$details = $res->getDispatchTimeMaxDetails();
		foreach($details as $type){
		    $detail_values[] = array(
			'id'=>$type->DispatchTimeMax,
			'text'=>$type->DispatchTimeMax . ' ('.$type->Description.')',
			'saved'=>(in_array($type->DispatchTimeMax,$_locals)) ? true : false
		    );
		}
		break;
	}
	$smarty->assign(array(
	    'ebay_values'=>$detail_values,
	    'local_values'=>$local_values,
	    'sync_form'=>xtc_draw_form('system_ebay_conf_sync','system.php',xtc_get_all_get_params(array('action')).'action=ebay_update_process&name='.$name)
	));
	$extra_html = $smarty->fetch('system_ebay_config.html');
	// initiate template engine for mail
	/*$extra_html .= sprintf('<br /><br /><pre>%s</pre>',
		var_export($res->$name,true)
	);*/
	$action = '';
	
	break;
    case 'struct':
	    $tables = array();
	    $table_heading = array();
	    $query = xtc_db_query("SHOW TABLES");
	    while($record = xtc_db_fetch_array($query)){
		$tables[current($record)] = array();
	    }
	    foreach($tables as $table=>$_tmp){
		$query = xtc_db_query("SHOW COLUMNS FROM ".$table);
		while($record = xtc_db_fetch_array($query)){
		    if(!sizeOf($table_heading)){
			$table_heading = array_keys($record);
		    }
		    $tables[$table][] = $record;
		}
	    }
	    $extra_html = sprintf('<h2>Tabellen Index Analyse</h2><table border="0" class="yesListTable_minimal"><thead><tr><th>%s</th></tr></thead><tbody>',implode('</th><th>',$table_heading));
	    foreach($tables as $table => $fields){
		$extra_html .= sprintf('<tr class="odd"><td colspan="%s"><b>%s</b></td></tr>',sizeOf($table_heading),$table);
		foreach($fields as $field_key=>$field){
		    $display_field = false;
		    $_extra_html = '<tr>';
		    foreach($field as $k=>$f){
			$f_str = $f;
			if($k == 'Key' and !empty($f)){
			    if($f == 'PRI'){
				$f_str = '<b>Primary</b>';
			    }
			    $display_field = true;
			}
			$_extra_html .= sprintf('<td>%s</td>',$f_str);
		    }
		    $_extra_html .= '</tr>';
		    if($display_field) $extra_html .= $_extra_html;
		}
	    }
	    $extra_html .= '</tbody></table>';
	    break;
	case 'delete_auctions':
		$deleted = 0;
		$query_raw = sprintf("SELECT id FROM ebay_auctions WHERE status=2 AND end_time<'%s' LIMIT 5000",$auctions_abonded_date); // zu unique fuer eigene funktion
		$query = xtc_db_query($query_raw);
		while($row = xtc_db_fetch_array($query)){
			$auction = new ebay_auction($row['id']);
			$auction->delete();
			$deleted++;
		}
		xtc_db_query('OPTIMIZE TABLE ebay_auctions');
		xtc_db_query('OPTIMIZE TABLE ebay_auctions_payments');
		xtc_db_query('OPTIMIZE TABLE ebay_auctions_itemspecifics');
		xtc_db_query('OPTIMIZE TABLE ebay_auctions_characteristics');
		xtc_db_query('OPTIMIZE TABLE ebay_auctions_shippings');
		xtc_db_query('OPTIMIZE TABLE ebay_auctions_shippings_locations');
		xtc_db_query('OPTIMIZE TABLE ebay_auctions_deleted');



		$comments = sprintf('Es wurden %s Auktionen gel&ouml;scht. (&Auml;lter als 100 Tage)',$deleted);
		$insert_sql_array = array(
			'date_added'=>'now()',
			'comments'=>$comments,
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('history',$insert_sql_array);
		$messageStack->add_session($comments,'success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
	case 'delete_emails':
		$deleted = 0;
		$query_raw = sprintf("SELECT id FROM ebay_emails WHERE date<'%s'",$abonded_date);
		$query = xtc_db_query($query_raw);
		while($row = xtc_db_fetch_array($query)){
			$mail = new DBmail($row['id'],false,true);
			$mail->delete();
			$deleted++;
		}
		xtc_db_query('OPTIMIZE TABLE ebay_emails');
		xtc_db_query('OPTIMIZE TABLE ebay_email_bodys');
		$comments = sprintf('Es wurden %s alte E-Mails gel&ouml;scht. (&Auml;lter als %s Jahre)',$deleted,$abonded_years);
		$insert_sql_array = array(
			'date_added'=>'now()',
			'comments'=>$comments,
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('history',$insert_sql_array);
                RemoveEmptySubFolders(\main::get_importdata_path().'mail_attachments/');
                $messageStack->add_session($comments,'success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
	case 'delete_products_history':
		xtc_db_query(sprintf("DELETE FROM products_history WHERE date_saved<'%s'",$abonded_date));
		xtc_db_query(sprintf("DELETE FROM history_bestand WHERE date_saved<'%s'",$abonded_date));
		xtc_db_query('OPTIMIZE TABLE products_history');
		xtc_db_query('OPTIMIZE TABLE history_bestand');
		$comments = sprintf('Es wurden alte Produkthistorien-Eintr&auml;ge gel&ouml;scht. (&Auml;lter als %s Jahre)',$abonded_years);
		$insert_sql_array = array(
			'date_added'=>'now()',
			'comments'=>$comments,
			'editor_id'=>$_SESSION['customer_id']
		);
		xtc_db_perform('history',$insert_sql_array);
		$messageStack->add_session($comments,'success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
	case 'optimize':
		$q = yes_db_query("SHOW tables");
		$number_of_tables = yes_db_num_rows($q);
		$tables = array();
		foreach($q as $table){
			$tables[] = current($table);
		}
		$opt_query_raw = sprintf("OPTIMIZE TABLE %s",implode(', ',$tables));
		xtc_db_query($opt_query_raw);
		$messageStack->add_session('Alle Tabellen wurden optimiert','success');
		xtc_redirect(xtc_href_link('system.php'));
		break;
	default:
		$query = xtc_db_query("SELECT count(1) as anzahl FROM ebay_emails");
		$records = xtc_db_fetch_array($query);
		$saved_emails = (int)$records['anzahl'];

		$query = xtc_db_query(sprintf("SELECT count(1) as anzahl FROM ebay_emails WHERE date<'%s'",$abonded_date));
		$records = xtc_db_fetch_array($query);
		$abonded_emails = (int)$records['anzahl'];

		$email_table_size = $basics->get_table_size('ebay_emails');
		$email_table_size += $basics->get_table_size('ebay_email_bodys');
		$email_table_size = $basics->convert_filesize($email_table_size,$size_unit);

		$query = xtc_db_query("SELECT count(1) as anzahl FROM products_history");
		$records = xtc_db_fetch_array($query);
		$saved_products_history = (int)$records['anzahl'];

		$query = xtc_db_query(sprintf("SELECT count(1) as anzahl FROM products_history WHERE date_saved<'%s'",$abonded_date));
		$records = xtc_db_fetch_array($query);
		$abonded_products_history = (int)$records['anzahl'];

		$products_history_table_size = $basics->get_table_size('products_history');
		$products_history_table_size += $basics->get_table_size('history_bestand');
		$products_history_table_size = $basics->convert_filesize($products_history_table_size,$size_unit);

		$query = xtc_db_query(sprintf("SELECT count(id) as anzahl FROM ebay_auctions WHERE status=2 AND end_time<'%s'",$auctions_abonded_date));
		$records = xtc_db_fetch_array($query);
		$saved_auctions = (int)$records['anzahl'];

		$q = yes_db_query("SHOW tables");
		$number_of_tables = yes_db_num_rows($q);
		$tables = array();
		foreach($q as $table){
			$tables[] = array('id'=>current($table),'text'=>current($table));
		}
		break;
	    case 'unallocated_products':
		header('Content-Type: text/html; charset='.CHARSET);
		$query = xtc_db_query(sprintf(
			"SELECT p.products_id FROM %s p LEFT JOIN %s p2c USING(products_id) WHERE p2c.products_id IS NULL or p2c.products_id=0",
			TABLE_PRODUCTS,TABLE_PRODUCTS_TO_CATEGORIES
		));
		printf('Es wurden %s unzugewiesene Artikel gefunden.<br />',xtc_db_num_rows($query));
		$categories = \YES4Trade\Model\category::get_categories_id_text_values_by_categories_id(0);
		echo 'Speichern in Kategorie: ';
		echo xtc_draw_form('llct_prdct','system.php','action=allocate_products');
		echo xtc_draw_pull_down_menu('categories_id',$categories);
		echo '<input type="submit" value="Zuweisen" class="ui-button ui-corner-all ui-state-default" /></form>';
		exit;
		break;
	    case 'allocate_products':
		$categories_id = (int)xtc_db_input($_REQUEST['categories_id']);
		if($categories_id < 1){
		    $messageStack->add_session('Bitte w&auml;hlen Sie eine g&uuml;ltige Kategorie zum Speichern der Artikel','error');
		}else{
		    $query = xtc_db_query(sprintf(
			    "SELECT p.products_id FROM %s p LEFT JOIN %s p2c USING(products_id) WHERE p2c.products_id IS NULL or p2c.products_id=0",
			    TABLE_PRODUCTS,TABLE_PRODUCTS_TO_CATEGORIES
		    ));
		    $num = 0;
		    while($record = xtc_db_fetch_array($query)){
			xtc_db_query(sprintf(
				"DELETE FROM %s WHERE products_id='%s'",
				TABLE_PRODUCTS_TO_CATEGORIES,$record['products_id']
			));
			xtc_db_query(sprintf(
				"INSERT INTO %s SET products_id='%s', categories_id='%s'",
				TABLE_PRODUCTS_TO_CATEGORIES,$record['products_id'],$categories_id
			));
			$insert_sql_array = array(
			    'products_id'=>$record['products_id'],
			    'editor_id'=>$_SESSION['customer_id'],
			    'date_saved'=>'now()',
			    'comments'=>'[System] Kategoriezuweisung: '.  xtc_get_categories_name($categories_id)
			);
			xtc_db_perform('products_history',$insert_sql_array);
			$num++;
		    }
		    $messageStack->add_session('Es wurden '.$num.' verwaiste Artikel zugewiesen','success');
		}
		xtc_redirect(xtc_href_link('system.php'));
		exit;
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript">
function viewCacheItem( key ){
    $.ajax({
        url: 'system.php?action=cache&viewCacheItem='+key,
        success: function( response ){
            alert(response);
        }
    });
}
function ask_ebay_sync_mode(url){
    window.location.href=url;
}

function delete_cache(){
    let p = new Array();
    $('input[name="cache_key[]"]').each(function(){
        if($(this).prop('checked')){
            p.push( $(this).val() );
        } 
    });
    
    if( p.length > 0){
        window.location.href='system.php?action=cache&cache_key[]='+p.join('&cache_key[]=');
    }
}

function delete_file_cache(){
    if( confirm('File/Templatecache wirklich leeren?') ){
        window.location.href='system.php?action=delete_file_cache';
    }
}


</script>
<?php
if(!isset($extra_html)){
?>
<table border="0">
<tr>
	<td>
		<p><span class="pageHeading">Systemverwaltung</span></p>
		<ul class="clear_block">
			<li class="clear"><a href="history.php"><u>System-Historie</u></a></li>
			<li class="clear"><a href="?action=ebay_update"><u>eBay Konfig Synchronisation</u></a></li>
			<li class="clear"><a href="?action=customers_account"><u>Kundenkonten Gesamtumsatz aktualisieren</u></a></li>
			<li class="clear"><a class="lbOn" id="?action=order_copy" href="javascript:;" title="Auftragskopien erzeugen"><u>Auftragskopien</u></a></li>
			<li class="clear"><a class="lbOn" id="?action=export_orders" href="javascript:;" title="Aufträge PDF Export"><u>Aufträge PDF Export</u></a></li>
			<!--<li class="clear"><a class="lbOn" id="?action=amazon_sp" href="javascript:;" title="Amazon SP Umstellung"><u>Amazon SP Umstellung</u></a></li>*}//-->
			<li class="clear"><a class="lbOn" id="?action=amazon_lwa_refresh" href="javascript:;" title="Amazon SP Umstellung"><u>Amazon LWA Refresh</u></a></li>
                        
			<li class="clear"><a class="lbOn" id="?action=cache" href="javascript:;" title="Cache Manager"><u>Cache Manager</u></a></li>
			<li class="clear"><a href="?action=xy_delete" title="Verwaiste XY Properties"><u>Verwaiste XY Properties</u></a></li>
		</ul>
		<br />
		<ul class="clear_block">
			<li class="clear"><b>E-Mail Bestand:</b> <?php echo $saved_emails; ?></li><br />
			<li class="clear"><b>E-Mails &auml;lter als <?php echo $abonded_years; ?> Jahre:</b> <?php echo $abonded_emails; ?></li><br />
			<li class="clear"><b>Speicherverbrauch E-Mails:</b> <?php echo number_format($email_table_size,2,',','.').$size_unit; ?></li><br />
			<li class="clear"><?php 
                        echo yes_draw_href_button('Alte E-Mails '.IMAGE_DELETE,xtc_href_link('system.php','action=delete_emails'),''); 
                        echo yes_draw_href_button('E-Mail Export',xtc_href_link('system.php','action=email_export'),'','button','lbOn'); 
                        ?></li>
		</ul>
		<br />
		<ul class="clear_block">
			<li class="clear"><b>Produkthistorie Bestand:</b> <?php echo $saved_products_history; ?></li><br />
			<li class="clear"><b>Produkthistorien &auml;lter als <?php echo $abonded_years; ?> Jahre:</b> <?php echo $abonded_products_history; ?></li><br />
			<li class="clear"><b>Speicherverbrauch Produkthistorie:</b> <?php echo number_format($products_history_table_size,2,',','.').$size_unit; ?></li><br />
			<li class="clear"><?php echo yes_draw_href_button('Alte Produkthistorien '.IMAGE_DELETE,xtc_href_link('system.php','action=delete_products_history'),''); ?></li>
			<li class="clear"><?php echo yes_draw_href_button('Verwaiste Artikel',xtc_href_link('system.php','action=unallocated_products'),'', 'button','lbOn'); ?></li>
			<li class="clear"><?php echo yes_draw_href_button('Inventurbestand setzen',xtc_href_link('system.php','action=products_inventur_qty'),'', 'button','lbOn'); ?></li>
			<li class="clear"><?php echo yes_draw_href_button('Kategorien Rekursions-Check',xtc_href_link('system.php','action=recursion_check'),'', 'button','lbOn'); ?></li>
<?php           
$path = \main::get_exportdata_path();
$exportddatafiles = 0;
if ($handle = opendir($path)) {
    while (false !== ($file = readdir($handle))) { 
        //24 hours in a day * 3600 seconds per hour
        $filelastmodified = filemtime($path . $file);
        if((time()-$filelastmodified) > (24*3600*7*4) && is_file($path.$file) and substr($file,0,8) == 'BARCODE_'){
           //unlink($path . $file);
            $exportddatafiles++;
        }
    }
    closedir($handle); 
}else{
    echo '<b>span class="errorText">FEHLER... kann exportdata/ nicht lesen.</span>';
}
if($exportddatafiles > 0){
	printf('<li class="clear">%s</li>',
            yes_draw_href_button($exportddatafiles.' Order Barcodes (>4 Wochen) '.IMAGE_DELETE,
                    xtc_href_link('system.php','action=barcode_delete'),
                    '', 
                    'button',
                    'lbOn'
           )
        );
}

?>
		</ul>
		<br />
		<ul class="clear_block">
                    <li class="clear"><?php echo yes_draw_href_button('Platform Notifications',xtc_href_link('system.php','action=ebay_notifications'),'','button','lbOn'); ?></li>
                    
		</ul>
		<ul class="clear_block">
                    <li class="clear"><b>Produktmerkmale (Sets) aufr&auml;umen <span style="color: darkgreen;">(anschliessend Cache <b>groups_*</b> leeren)</span></li><br />
                    <li class="clear"><?php echo yes_draw_href_button('Start Cleanup',xtc_href_link('system.php','action=products_characteristics_cleanup'),''); ?></li>
		</ul>
                
                            
		<ul class="clear_block">
                    <li class="clear"><b>eBay Versandmethoden Cache aktualisieren</b></li><br />
                    <li class="clear"><?php echo yes_draw_href_button('eBay Versandmethoden Cache aktualisieren',xtc_href_link('system.php','action=cache_update_ebay_shippingmethods'),''); ?></li>
		</ul>
                
		<br />
		<ul class="clear_block">
                    <li class="clear"><b>eBay Sync v2 (synchronisiert alle Artikel in_auction Werte sowie Auktionen Status und Mengen)</b></li><br />
                    <li class="clear"><?php echo yes_draw_href_button('eBay Sync V2',xtc_href_link('ebayapi_sdk_feeds.php','action=get_active_inventory'),'','button','lbOn'); ?></li>
		</ul>
		<br />
                
		<ul class="clear_block">
			<li class="clear"><b>ebay_orders processed Status</li><br />
			<li class="clear">
			    <?php echo yes_draw_href_button('ebay_orders processed',xtc_href_link('system.php','action=ebay_orders_processed'),''); ?>
			</li>
		</ul>
                
                <br />
		<ul class="clear_block">
			<li class="clear"><b>eBay Plus aktivieren</li><br />
			<li class="clear">
			    <?php echo yes_draw_href_button('Alle Sammlerprodukte',xtc_href_link('system.php','action=ebay_products_ebay_plus'),''); ?>
			    &nbsp;
			    <?php echo yes_draw_href_button('Alle laufenden Auktionen',xtc_href_link('system.php','action=ebay_auctions_ebay_plus'),''); ?>
			</li>
		</ul>
                <br />
		<ul class="clear_block">
			<li class="clear"><b>eBay Nachrichten l&ouml;schen</li><br />
			<li class="clear">
                            <?php
                            $q = xtc_db_query("SELECT COUNT(ebay_mymessage_id) AS anz FROM ebay_mymessage");
                            $r = xtc_db_fetch_array($q);
                            $total_ebay_msg = $r['anz'];
                            $q = xtc_db_query(sprintf("SELECT COUNT(ebay_mymessage_id) AS anz FROM ebay_mymessage WHERE receivedate<='%s'",
                                    $SYSTEM_EBAY_MESSAGES_CLEAN_DATE
                            ));
                            $r = xtc_db_fetch_array($q);
                            $date_ebay_msg = $r['anz'];
                            printf('Es werden alle eBay Nachrichten gel&ouml;scht, die &auml;lter sind als %s.<br />Insgesamt: %s Nachrichten / Davon veraltete Nachrichten: %s<br />',
                                    $SYSTEM_EBAY_MESSAGES_CLEAN_DATE,
                                    $total_ebay_msg,
                                    $date_ebay_msg
                            );
                            ?>
			    <?php echo yes_draw_href_button($ebay_msg_num.' eBay Nachrichten l&ouml;schen',xtc_href_link('system.php','action=process_ebaymessages_clean'),''); ?>
			</li>
		</ul>
                
		<br />
		<ul class="clear_block">
			<li class="clear"><b>Anzahl Tabellen:</b> <?php echo $number_of_tables; ?></li><br />
			<li class="clear">Besonders nach grossen Datenbewegungen empfiehlt es sich, mal ein "optimize" auf alle Tabellen auszuf&uuml;hren.
				<br />Kann man durchaus alle paar Wochen oder so mal ausf&uuml;hren, am besten nachts.</li><br />
			<li class="clear">
			    <?php echo yes_draw_href_button('Tabellen Optimieren',xtc_href_link(basename(__FILE__),'action=optimize'),''); ?>
			    <?php echo yes_draw_href_button('Tabellen Strukturen anzeigen',xtc_href_link(basename(__FILE__),'action=struct'),''); ?>
			    <?php echo yes_draw_href_button('Tabellen Strukturdatei erzeugen',xtc_href_link(basename(__FILE__),'action=update_database_table_structure'),''); ?>
                            
			</li>
		</ul>
		<?php
		if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
		?>
		<br />
		<ul class="clear_block">
			<li class="clear"><b>Amazon Multi-User</li><br />
			<li class="clear">F&uuml;r den Umstieg vom Amazon Single-User zu Multi-User m&uuml;ssen einige &Auml;nderungen vorgenommen werden.</li>
			<li class="clear">
			    <br />
			    <?php
			    if(!defined('AMAZONUSER_COUNTER') or AMAZONUSER_COUNTER == 0){
				echo '<br />In der <pre>config.ebayapi.inc.php</pre> muss festgelegt werden, wieviel Amazon Accounts f&uuml;r das jeweilige System verf&uuml;gbar sein sollen. Dies geschieht durch Einf&uuml;gen des Codes <pre><code>define(\'AMAZONUSER_COUNTER\',1);</code></pre>F&uuml;r den Umstieg sollte hier erstmal immer die 1 eingetragen werden - nach Abschluss der Anpassung kann nat&uuml;rlich auch ein h&ouml;herer Wert verwendet werden. Nach dem Einf&uuml;gen dieser Zeile, einfach diese Seite neu Laden.';
			    }else{
				if(defined('MODULE_OTHER_AMAZON_MERCHANT_ID')){
				    echo '<br />Da nun mehrere Amazon User m&ouml;glich sind, m&uuml;ssen die Authentifizierungsdaten des Amazon Moduls entsprechend gespeichert werden. Folgende Konfigurationseintr&auml;ge werden dabei entfernt und in anderer Form neu gespeichert: <pre>';
				    echo '<br /><b>MODULE_OTHER_AMAZON_MERCHANT_ID:</b> '.MODULE_OTHER_AMAZON_MERCHANT_ID;
				    echo '<br /><b>MODULE_OTHER_AMAZON_MARKETPLACE_ID:</b> '.MODULE_OTHER_AMAZON_MARKETPLACE_ID;
				    echo '<br /><b>MODULE_OTHER_AMAZON_MERCHANT_IDENTIFIER:</b> '.MODULE_OTHER_AMAZON_MERCHANT_IDENTIFIER;
				    echo '<br /><b>MODULE_OTHER_AMAZON_MWSAUTHTOKEN:</b> '.MODULE_OTHER_AMAZON_MWSAUTHTOKEN;
				    echo '</pre>';
				    echo '<a class="ui-corner-all ui-state-highlight" href="system.php?action=amazon_switch_auth">Auth-Daten konvertieren</a>';
				}elseif(defined('MODULE_OTHER_AMAZON_AUTH_DATA')){
				    echo '<br />Da bisher alle Daten die von oder an Amazon gesendet, empfangen und gespeichert wurden darauf basierten, dass es exakt einen Amazon Account gibt, m&uuml;ssen nun noch alle Datens&auml;tze mit dem aktuellen Amazon Seller markiert werden (es ist ja zu diesem Zeitpunkt nur ein Amazon Konto hinterlegt). Dies betrifft die Datens&auml;tze der folgenden Tabellen: <pre>amazon_feeds, amazon_orders, amazon_products, amazon_settlements</pre>';
				    $authdataparts = explode(',',MODULE_OTHER_AMAZON_AUTH_DATA);
				    echo '<br /><a class="ui-corner-all ui-state-highlight" href="system.php?action=amazon_update_data">Datens&auml;tze mit MERCHANT_ID &raquo;'.$authdataparts[0].'&laquo; hinterlegen</a>';
				    echo '<br /><br /><i>* Achtung, bei diesem Vorgang sieht YES nicht ob er bereits ausgef&uuml;hrt wurde. Zur Kontrolle einfach in eine der genannten Tabellen nachsehen ob eine merchant_id zu den enthaltenen Datens&auml;tzen bereits gespeichert wurde.</i>';
				}
			    }
			    
			    ?>
			</li>
		</ul>
		<?php
		}
		?>
		<br />
		<ul class="clear_block">
			<li class="clear"><b>Smarty Syntax Check</li><br />
			<li class="clear">Testet ob die Syntax einer Smarty Datei zu Fehlern f&uuml;hrt</li>
			<form action="<?php echo basename(__FILE__); ?>?action=smarty_check" method="post" enctype="multipart/form-data">
			    <input type="file" name="smarty_file" />
			    <input type="submit" />
			</form>
                        <?php if(CURRENT_TEMPLATE!=''){ ?>
                        <br />
			<li class="clear"><b>Smarty Set Check</li><br />
			<li class="clear">Durchl&auml;uft ALLE Dateien des aktuellen Templatesets (<?php echo CURRENT_TEMPLATE; ?>) und listet evtl auftretende Smarty Fehler auf</li>
                        <input title="Smarty Set Check" id="<?php echo basename(__FILE__); ?>?action=smarty_set_check" value="Start" class="lbOn ui-button ui-corner-all ui-state-default" type="button" />
                        <?php } ?>
                </ul>
		<ul class="clear_block">
                    <li class="clear"><a href="<?php echo xtc_href_link(basename(__FILE__),'action=amzfeeds'); ?>">Amazon Feed Statusanzeige</a></li>
		</ul>
		<br />
	</td>
</tr>
</table>
<?php
}else{
    echo yes_draw_href_button(IMAGE_BACK,xtc_href_link('system.php'));
    echo $extra_html;
}

include('includes/application_bottom.php');
