<?php
function generateClassFromTable($tableName, $className) {
    $query = xtc_db_query(sprintf(
        "DESCRIBE %s",
        $tableName
    ));
    $columns = [];
    while ($row = xtc_db_fetch_array($query)) {
        $columns[$row["Field"]] = [
            'type' => $row["Type"],
            'primary_key' => ($row["Key"] == "PRI"),
            'auto_increment' => ($row["Extra"] == "auto_increment")
        ];
    }
    // Generate class definition
    $classDefinition = "
<?php

namespace YES4Trade\Model;

class $className extends \YES4Trade\Model\BaseType {
";

    // Add constants
    $classDefinition .= "
    const TABLE_NAME = '$tableName';\n";
    $classDefinition .= "    const TABLE_INDEX = '" . implode("_", explode("_", $className)) . "_id';\n\n";

    // Add property types
    if(sizeOf($columns)){
        $classDefinition .= "    private static \$propertyTypes = [\n";
    }
    foreach ($columns as $columnName => $columnInfo) {
        $classDefinition .= "        '$columnName' => [\n";
        $type = strtolower(str_replace(" ", "", $columnInfo['type']));
        if(strpos($type,'varchar')>-1 or strpos($type,'text')>-1){
            $type = 'string';
        }
        if($type == 'datetime'){
            $type = 'DateTime';
        }
        if($type == 'int' or strpos($type,'float')>-1 or strpos($type,'double')>-1){
            $type = 'integer';
        }
        $classDefinition .= "            'type' => '" . $type . "',\n";
        $classDefinition .= "            'repeatable' => false,\n";
        $classDefinition .= "            'attribute' => false,\n";
        $classDefinition .= "            'elementName' => '$columnName'\n";
        $classDefinition .= "        ],\n";
    }
    if(sizeOf($columns)){
        $classDefinition .= "    ];\n\n";
    }

    // Add constructor
    $classDefinition .= "\n\tpublic function __construct(array \$values = []) {\n";
    $classDefinition .= "\t\tlist(\$parentValues, \$childValues) = self::getParentValues(self::\$propertyTypes, \$values);\n";
    $classDefinition .= "\t\tparent::__construct(\$parentValues);\n";
    $classDefinition .= "\t\tif (!array_key_exists(__CLASS__, self::\$properties)) {\n";
    $classDefinition .= "\t\t\tself::\$properties[__CLASS__] = array_merge(self::\$properties[get_parent_class(__CLASS__)], self::\$propertyTypes);\n";
    $classDefinition .= "\t\t}\n";
    $classDefinition .= "\t\tif (!array_key_exists(__CLASS__, self::\$xmlNamespaces)) {\n";
    $classDefinition .= "\t\t\tself::\$xmlNamespaces[__CLASS__] = 'xmlns=\"urn:ebay:apis:eBLBaseComponents\"';\n";
    $classDefinition .= "\t\t}\n";
    $classDefinition .= "\t\t\$this->setValues(__CLASS__, \$childValues);\n";
    $classDefinition .= "\t}\n\n";

    // Add create method
    $classDefinition .= "
\tpublic function create() {\n";
    $classDefinition .= "\t\t\$data = self::convert_values( \$this->toArray(),self::\$propertyTypes );\n";
    $classDefinition .= "\t\tyes_db_perform(self::TABLE_NAME, \$data);\n";
    $classDefinition .= "\t\treturn xtc_db_insert_id();\n";
    $classDefinition .= "\t}\n\n";

    // Add update method
    $classDefinition .= "
\tpublic function update() {\n";
    $classDefinition .= "\t\t\$data = self::convert_values( \$this->toArray(),self::\$propertyTypes );\n";
    $classDefinition .= "\t\tunset(\$data[self::TABLE_INDEX]);\n";
    $classDefinition .= "\t\t\$index = self::TABLE_INDEX;\n";
    $classDefinition .= "\t\tyes_db_perform(self::TABLE_NAME, \$data,'update',[\$index=>\$this->\$index]);\n";
    $classDefinition .= "\t}\n\n";

    // Add delete method
    $classDefinition .= "
\tpublic static function delete(int \$index) {\n";
    $classDefinition .= "\t\tyes_query(sprintf(\n";
    $classDefinition .= "\t\t\t\"DELETE FROM %s WHERE %s=:id\",\n";
    $classDefinition .= "\t\t\t\tself::TABLE_NAME,self::TABLE_INDEX\n";
    $classDefinition .= "\t\t\t),['id'=>\$index]\n";
    $classDefinition .= "\t\t);\n";
    $classDefinition .= "\t}\n\n";

    // Add get_by_ methods
    foreach ($columns as $columnName => $columnInfo) {
        if ($columnInfo['primary_key']) {
            $classDefinition .= "
\tpublic static function get_by_" . str_replace(" ", "_", $columnName) . "(int \$" . strtolower($columnName) . ", array \$select_fields = []) {\n";
	    $classDefinition .= "\t\t\$select_field_string = '*';\n";
	    $classDefinition .= "\t\tif(sizeOf(\$select_fields)){\n";
	    $classDefinition .= "\t\t\t\$select_field_string = implode(',',\$select_fields);\n";
	    $classDefinition .= "\t\t}\n";
            $classDefinition .= "\t\t\$query = yes_query(sprintf(\n";
            $classDefinition .= "\t\t\t\"SELECT %s FROM %s WHERE %s=:id\",\n";
            $classDefinition .= "\t\t\t\t\$select_field_string,self::TABLE_NAME, self::TABLE_INDEX\n";
            $classDefinition .= "\t\t\t),['id'=>\$" . strtolower($columnName) . "]\n";
            $classDefinition .= "\t\t);\n";
            $classDefinition .= "\t\tif(!sizeOf(\$query)){\n";
            $classDefinition .= "\t\t\treturn null;\n";
            $classDefinition .= "\t\t}\n";
            $classDefinition .= "\t\t\$record = current(\$query);\n";
            $classDefinition .= "\t\treturn new self(self::convert_values(\$record,self::\$propertyTypes));\n";
            $classDefinition .= "\t}\n\n";
        }
    }

    // Close class definition
    $classDefinition .= "}\n";

    // Write the generated class to a file
    $fileContent = $classDefinition;
    $fileName = $className . ".php";
    echo 'Copy this for '.$fileName;
    yes_debug($fileContent);
}
if(isset($_POST['table_name']) and isset($_POST['class_name'])){
    generateClassFromTable($_POST['table_name'], $_POST['class_name']);
}else{
    printf('<form action="%s" method="post">Table Name: %s<br />New Class Name: %s<br /><input type="submit" /></form>',
            xtc_href_link('system.php',xtc_get_all_get_params(['action']).'action=create_class_from_sql'),
            xtc_draw_input_field('table_name'),
            xtc_draw_input_field('class_name'),
    );
}
