<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
   
require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'product.php');
if(is_file(DIR_WS_CLASSES.'storage.php')) require_once(DIR_WS_CLASSES.'storage.php');
$smarty = new yesSmarty;
$buttons = array(
    array('text'=>TEXT_NEW_STORAGE,
	'link'=>xtc_href_link('storage.php','action=new'),
	'lbOn'=>false,
	'auth'=>true
    )
);
$smarty->assign(array(
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));

if (isset($_GET['action'])){
    switch ($_GET['action']) {
        case 'transfer_distributor_orders_products_process':
            $doID = (int)xtc_db_input($_GET['doID']);
            $pID = (int)xtc_db_input($_GET['pID']);
            $stID = (int)xtc_db_input($_GET['stID']);
            $product = new product($pID);
            $max = $product->get_unallocated_storage_products_quantity();
            $total_submitted = 0;
            foreach($_GET['storage_place_quantity'] as $stpID=>$spqty){
                $total_submitted += (int)xtc_db_input($spqty);
            }
            if(($max < $total_submitted) or ($total_submitted == 0)){
        	$messageStack->add_session(sprintf(MAX_TRANS_ERROR,$max),'error');
                xtc_redirect(xtc_href_link(basename(__FILE__),'action=distributor_order_allocation&doID='.$doID));
            }
            foreach($_GET['storage_place_quantity'] as $stpID=>$spqty){
                $update_sql_query_raw = sprintf("UPDATE storage_products SET quantity=quantity+%d WHERE storage_id='%d' AND products_id='%d' AND storage_places_id='%d'",
                        $spqty,$stID, $pID, $stpID
                );
                xtc_db_query($update_sql_query_raw);
                $sql_insert_array = array(
                        'source_storage_products_id'=>0,
                        'target_storage_products_id'=>$stpID,
                        'quantity'=>$spqty,
                        'editor'=>$_SESSION['customer_id'],
                        'date_added'=>'now()'
                );
                xtc_db_perform('storage_products_transfer',$sql_insert_array);
            }
            $messageStack->add_session(sprintf(
                    TEXT_DISTRIBUTOR_ORDER_ALLOC_TRANSFERRED,
                    $total_submitted
            ),'success');
            xtc_redirect(xtc_href_link(basename(__FILE__),'action=distributor_order_allocation&doID='.$doID));
            break;
        case 'transfer_distributor_orders_products':
            $pID = (int)xtc_db_input($_GET['pID']);
            $stID = (int)xtc_db_input($_GET['stID']);
            $product = new product($pID);
            foreach($product->get_storages() as $st){
                if($st['storage_id'] != $stID){
                    continue;
                }
                if(!isset($st['places']) or !sizeOf($st['places'])){
                    continue;
                }
                $unalloc = $product->get_unallocated_storage_products_quantity();
                printf('<div id="dop_untrans_alloc_container" class="main"><p>%s</p><table border="0">',
                        sprintf(TEXT_DISTRIBUTOR_ORDER_ALLOC_PRODUCTS_UNALLOCATED,
                                $unalloc
                        )
                );
                foreach($st['places'] as $stp){
                    printf('<tr><td>%s:</td><td>%s</td></tr>',
                            $stp['storage_place'],
                            xtc_draw_input_field('storage_place_quantity['.$stp['storage_places_id'].']','0','maxlength="7" size="5" class="stpqt"')
                    );
                }
                echo '</table>';
                echo xtc_draw_hidden_field('unallocated_products_for_transfer', $unalloc);
                printf('<br /><input type="button" class="ui-button ui-corner-all ui-state-default" value="%s" onclick="submit_transfer(%d, %d)" />',
                        IMAGE_SAVE, $pID, $stID
                );
                echo '</div>';
            }
            exit;
            break;
/*            
        case 'allocate_product_to_storage_place_process':
            $pID = (int)xtc_db_input($_GET['pID']);
            $stID = (int)xtc_db_input($_GET['stID']);
            $stpID = (int)xtc_db_input($_GET['stpID']);
            $query = xtc_db_query(sprintf(
                    "SELECT id FROM storage_products WHERE products_id='%d' AND storage_id='%d' AND storage_places_id='%d'",
                    $pID, $stID, $stpID
            ));
            if(xtc_db_num_rows($query)){
                $messageStack->add_session(sprintf(TEXT_ERROR_PRODUCT_STORAGE_PLACE_ALLOCATION_EXISTS,
                    yes_get_storage_place_title($stpID)
                ),'error');
                if(isset($_GET['referrer'])){
                    xtc_redirect($_GET['referrer']);
                }
                xtc_redirect(xtc_href_link(basename(__FILE__),'stID='.$stID));
            }
            $insert_sql_array = array(
                'products_id'=>$pID,
                'storage_id'=>$stID,
                'storage_places_id'=>$stpID,
                'quantity'=>0,
                'created'=>'now()'
            );
            xtc_db_perform('storage_products',$insert_sql_array);
            $messageStack->add_session(TEXT_DISTRIBUTOR_ORDER_ALLOC_ADD_PRODUCT_TO_ANOTHER_PLACE_SUCCESS,'success');
            if(isset($_GET['referrer'])){
                xtc_redirect($_GET['referrer']);
            }
            xtc_redirect(xtc_href_link(basename(__FILE__),'stID='.$stID));
            
            exit;
            break;
        case 'allocate_product_to_storage_place':
            $pID = (int)xtc_db_input($_GET['pID']);
            $stID = (int)xtc_db_input($_GET['stID']);
            $product = new product($pID);
            $values = [];
            foreach($product->get_storages(true) as $st){
                if($st['storage_id'] != $stID){
                    continue;
                }
                if(!isset($st['av_places']) or !sizeOf($st['av_places'])){
                    continue;
                }
                foreach($st['av_places'] as $avp){
                    $values[] = array(
                        'id'=>$avp['storage_places_id'],
                        'text'=>$avp['title']
                    );
                }
            }
            if(sizeOf($values)){
                printf('<div class="main"><p>%s</p>%s<input type="button" onclick="allocate_product_to_storage_place(%d,%d, this, \''.xtc_href_link(basename(__FILE__),'action=distributor_order_allocation&doID=').'\');" class="ui-button ui-corner-all ui-state-default" value="%s" /></div>',
                    TEXT_DISTRIBUTOR_ORDER_ALLOC_ADD_PRODUCT_TO_ANOTHER_PLACE_INTRO,
                    xtc_draw_pull_down_menu('storage_places_id',array_merge(array(['id'=>'','text'=>TEXT_SELECT]),$values)),
                        $pID,$stID,
                    IMAGE_SAVE
                );
            }
            //yes_debug($storages);
            exit;
            break;
 * 
 */
        case 'add_product_to_storage_storage_number_process':
            $pID = (int)xtc_db_input($_GET['pID']);
            $stID = (int)xtc_db_input($_GET['stID']);
            $stn = xtc_db_input($_GET['storage_number']);
            if($pID < 1 or $stID < 1 or strlen($stn) < 1){
                $messageStack->add_session('Missing Parameters','error');
                if(isset($_GET['referrer'])){
                    xtc_redirect($_GET['referrer']);
                }
                xtc_redirect(xtc_href_link('storage.php'));
            }
            $query = xtc_db_query(sprintf(
                    "SELECT id FROM storage_numbers WHERE products_id='%d' AND storage_id='%d' AND nummer='%s'",
                    $pID, $stID, $stn
            ));
            if(xtc_db_num_rows($query)){
                $messageStack->add_session('Artikel hat bereits eine Zuweisung zum gew�hlten Lager','error');
                if(isset($_GET['referrer'])){
                    xtc_redirect($_GET['referrer']);
                }
                xtc_redirect(xtc_href_link('storage.php'));
            }
            $insert_sql_array = array(
                'products_id'=>$pID,
                'storage_id'=>$stID,
                'nummer'=>$stn
            );
            xtc_db_perform('storage_numbers',$insert_sql_array);
            $messageStack->add_session('Artikel wurde neuem Lager zugewiesen','success');
            if(isset($_GET['referrer'])){
                xtc_redirect($_GET['referrer']);
            }
            xtc_redirect(xtc_href_link('storage.php'));
            break;
        case 'add_product_to_storage_storage_number':
            require_once(DIR_WS_CLASSES.'class.storagenumber.php');
            $pID = (int)xtc_db_input($_GET['pID']);
            $stID = (int)xtc_db_input($_GET['stID']);
            $sn = new StorageNumber($pID, $stID);
            printf('<p><b>%s:</b> %s</p>%s:<br />%s',
                    TEXT_PRODUCTS_STORAGE,xtc_get_storage_name($stID),
                    TEXT_PRODUCTS_STORAGE_NUMBER,
                    xtc_draw_input_field('storage_number',$sn->get_new_number())
            );
            printf('<input type="button" onclick="save_new_storage_process(%d,%d,\'%s\')" value="%s" />',
                    $stID,$pID,xtc_href_link('storage.php','action=distributor_order_allocation&doID='),IMAGE_SAVE
            );
            exit;
            break;
        case 'add_product_to_storage':
            $pID = (int)xtc_db_input($_GET['pID']);
            $av_storages = [];
            foreach(xtc_get_storages() as $st){
                $query = xtc_db_query(sprintf(
                        "SELECT id FROM storage_products WHERE storage_id='%d' AND products_id='%d'",
                        $st['id'],$pID
                ));
                if(!xtc_db_num_rows($query)){
                    $av_storages[] = array(
                        'id'=>$st['id'],
                        'text'=> xtc_get_storage_name($st['id'])
                    );
                }
            }
            echo '<div id="'.$_GET['action'].'_container" class="main">';
            if(sizeOf($av_storages)){
                echo xtc_draw_pull_down_menu('storage_id',array_merge(array(['id'=>'','text'=>TEXT_SELECT]),$av_storages),'','onchange="save_new_storage(this,'.$pID.')"');
            }
            echo '</div>';
            exit;
            break;
        case 'distributor_order_allocation':
            $doID = (int)xtc_db_input($_GET['doID']);
            require_once(DIR_WS_CLASSES.'distributor_order.php');
            require_once(DIR_FS_INC.'xtc_get_product_path.inc.php');
            require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
            $do = new distributor_order($doID);
            if(!sizeOf($do->info)){
                die('Invalid Order');
            }
            if($do->info['orders_status'] != 3){
                $messageStack->add_session(sprintf(MSG_ERROR_DISTRIBUTOR_ORDER_NOT_ABGESCHLOSSEN,
                        $doID
                ),'error');
                xtc_redirect(xtc_href_link(basename(__FILE__)));
            }
            $distinct = [];
            foreach($do->get_products_grouped() as $p){
                $product = new product($p['id']);
                $storages = $product->get_storages(false);
                foreach($storages as $sti=>$st){
                    foreach($st['places'] as $stplace_nr=>$stplace){
                        $places_query = xtc_db_query(sprintf(
                            "SELECT quantity FROM storage_products WHERE products_id='%d' and storage_id='%d' AND storage_places_id='%d'",
                            $p['id'],$st['storage_id'],$stplace['storage_places_id']
                        ));
                        $place = xtc_db_fetch_array($places_query);
                        $storages[$sti]['places'][$stplace_nr]['quantity'] = $place['quantity'];
                    }
                }
                
                if(isset($p['collies']) and sizeOf($p['collies'])){
                    foreach($p['collies'] as $pc){
                        if(!isset($distinct[ $p['id'] ])){
                            $distinct[ $p['id'] ] = array(
                                'qty_rueckbuch'=>0,
                                'name'=>$p['name'],
                                'storages'=>$storages,
                                'unallocated'=>$product->get_unallocated_storage_products_quantity()
                            );
                        }
                        $distinct[ $p['id'] ]['qty_rueckbuch'] += $p['qty_rueckbuch'];
                    }
                }else{
                    if(!isset($distinct[ $p['id'] ])){
                        $distinct[ $p['id'] ] = array(
                            'qty_rueckbuch'=>0,
                            'name'=>$p['name'],
                            'storages'=>$storages,
                            'unallocated'=>$product->get_unallocated_storage_products_quantity(),
                        );
                    }
                    $distinct[ $p['id'] ]['qty_rueckbuch'] += $p['qty_rueckbuch'];
                }
            }
            $smarty->assign(array(
                'DISTRIBUTOR_ORDERS_ID'=>$doID,
                'PRODUCTS'=>$distinct,
                'TEXT_ADD_NEW_STORAGE_PLACE'=>TEXT_ADD_NEW_STORAGE_PLACE,
                'TEXT_DISTRIBUTOR_ORDER_ALLOC_ADD_PRODUCT_TO_ANOTHER_PLACE'=>TEXT_DISTRIBUTOR_ORDER_ALLOC_ADD_PRODUCT_TO_ANOTHER_PLACE,
                'MAX_TRANS_ERROR'=>MAX_TRANS_ERROR,
                'TEXT_ALLOCATE_QUANTITY'=>TEXT_ALLOCATE_QUANTITY,
                'TEXT_DISTRIBUTOR_ORDER_ALLOC_CONTINUE'=>TEXT_DISTRIBUTOR_ORDER_ALLOC_CONTINUE,
                'TEXT_DISTRIBUTOR_ORDER_ALLOC_CREATE_STORAGE_PLACE'=>TEXT_DISTRIBUTOR_ORDER_ALLOC_CREATE_STORAGE_PLACE
            ));
            yes_draw_pre_header();
            yes_draw_header(TITLE);
            $smarty->display('storage_distributor_orders_products_allocation.html');
            require(DIR_WS_INCLUDES . 'footer.php');
            require(DIR_WS_INCLUDES . 'application_bottom.php');
            exit;
            break;
        case 'module_export_products_storages':
            require_once(DIR_FS_CATALOG.'lang/german/admin/module_export.php');
            //$module = new products_storages();
            $storage = new storage((int)xtc_db_input($_GET['stID']));
		    echo '<script type="text/javascript">'.
		    '$().ready(function(){'.
			    "$('.start_lbon_export_button').click(function(){
				$('#modal_window').dialog({title: 'Export ".$storage->getName()."'}).load(
				    '".xtc_href_link(FILENAME_MODULE_EXPORT,xtc_get_all_get_params(array('action')).'&action=save_stepwise')."&'+$('form[name=\"products_storage_export_form\"]').serialize()
				);
				return false;
			    });
		    });".
		    '</script>'.
                    '<form name="products_storage_export_form"><div class="main">'.
			'<p><b>&raquo;'.$storage->getName().'&laquo; '.IMAGE_EXPORT.'</b></p>'.
			xtc_draw_hidden_field('module', 'products_storages').
			xtc_draw_hidden_field('export', 'yes').
			xtc_draw_hidden_field('storage_id', $storage->getId()).
			'<input type="checkbox" name="export_linked_products" value="1" />'.TEXT_EXPORT_LINKED_PRODUCTS.'<br />'.
			'<input type="checkbox" name="export_products_name" value="1" />'.TEXT_EXPORT_PRODUCTS_NAME.
			'<br />'.yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','button','start_lbon_export_button ui-button ui-corner-all ui-state-default') . '&nbsp;' .
			yes_draw_href_button(IMAGE_CANCEL,'javascript: $(\'#modal_window\').dialog(\'destroy\')','width:120px;').
                    '</div></form>';
            
            exit;
            break;
        case 'export_storage_places_csv':
            $csv = [];
            $array = array();
            $query = xtc_db_query(
                    "SELECT * FROM storage_products ORDER BY storage_id,priority"
            );
            while($record = xtc_db_fetch_array($query)){
                $array[] = $record;
            }
            foreach($array as $sp){
                $csv[] = array(
                    TEXT_STORAGE=>$sp['storage_id'],
                    TEXT_QUICKEDIT_STORAGE_PLACE=>$sp['storage_places_id'],
                    TEXT_QUANTITY=>$sp['quantity'],
                    'products_id'=>$sp['products_id'],
                    TEXT_PRODUCT=>xtc_get_products_name($sp['products_id'])
                );
            }
            yes_debug($csv);
            exit;
            break;
	case 'json_info':
	    $stID = (int)xtc_db_input($_REQUEST['stID']);
	    $pID = (isset($_REQUEST['pID'])) ? (int)xtc_db_input($_REQUEST['pID']) : 0;
	    $info = yes_get_storage_info($stID);
	    if($info['default_storage'] == 'y'){
		$info['name'] .= ' <span style="color: #00FF00;font-size: larger;" title="Default">&#9733;</span>';
	    }
		
	    $info['country_name'] = xtc_get_country_name($info['storage_country']);
	    $address = '';
	    if($info['storage_company'] != ''){
		$address .= $info['storage_company'].'<br />';
	    }
	    if($info['storage_name'] != ''){
		$address .= $info['storage_name'].'<br />';
	    }
	    if($info['storage_suburb'] != ''){
		$address .= $info['storage_suburb'].'<br />';
	    }
	    if($info['storage_street_address'] != ''){
		$address .= $info['storage_street_address'].'<br />';
	    }
	    if($info['storage_postcode'] != ''){
		$address .= $info['storage_postcode'].' ';
	    }
	    if($info['storage_city'] != ''){
		$address .= $info['storage_city'].'<br />';
	    }
	    if($info['country_name'] != ''){
		$address .= $info['country_name'].'<br />';
	    }
	    if($info['storage_telephone'] != ''){
		$address .= ENTRY_TELEPHONE_NUMBER.': '.$info['storage_telephone'].'<br />';
	    }
	    $info['address'] = $address;
	    foreach($info as $k=>$v){
		$info[$k] = yes_encode_string($v);
	    }
	    
	    $info['storage_number'] = '';
	    $info['new_storage_number'] = '';
	    if($pID > 0){ // LAGERNUMMER PID
		$query = xtc_db_query(sprintf(
			"SELECT nummer FROM storage_numbers WHERE storage_id='%s' AND products_id='%s'",
			$stID,$pID
		));
		if(xtc_db_num_rows($query)){
		    $record = xtc_db_prepare_input(xtc_db_fetch_array($query));
		    $info['storage_number'] = $record['nummer'];
		}else{
		    $schema_key = xtc_db_prepare_input($info['schema_key']);
		    $schema_start = xtc_db_prepare_input($info['schema_start']);
		    if($schema_start >= 0){
			    $max = 0;
			    $key_query = xtc_db_query("SELECT nummer FROM storage_numbers WHERE nummer LIKE '".$schema_key."%'");
			    while($key = xtc_db_fetch_array($key_query)){
				    $value = explode($schema_key,$key['nummer']);
				    if((int)$value[1] > $max) $max = (int)$value[1];
			    }

			    if($max >= $schema_start)
			    $new_key = $schema_key.($max+1);
			    else
			    $new_key = $schema_key.$schema_start;
		    }else{
			    $new_key = $schema_key.$pID;
		    }
		    $info['new_storage_number'] = $new_key;
		}
	    }
	    
	    die(json_encode(xtc_db_prepare_input($info)));
	    break;
	case 'storage_editor':
	    include('storage_editor.php');
	    break;
	case 'storage_places':
	    include('storage_places.php');
	    break;
	case 'import':
	    @unlink(\main::get_importdata_path().'storage_import.csv');
	    $count = 0;
	    echo $messageStack->Output();
	    if(isset($_FILES['storage_file'])){
		if($file = yes_try_upload('storage_file', \main::get_importdata_path(),'755',array('CSV','csv'),'storage_import' )){
		    $data_array = array();
		    $row = 1;
		    if (($handle = fopen(\main::get_importdata_path()."storage_import.csv", "r")) !== FALSE) {
			while (($data = fgetcsv($handle, 1000, "\t")) !== FALSE) {
			    $data_array[] = $data;
			}
			fclose($handle);
		    }
	       }else{
		    xtc_redirect(xtc_href_link('storage.php','action=import'));
		}
		foreach($data_array as $line_nr=>$line){
		    if($line_nr == 0) continue;
		    if((int)$line[0] == 0 or (int)$line[2] == 0) continue;
		    $insert_sql_array = array(
			'storage_id'=>(int)$line[0],
			'products_id'=>(int)$line[2],
			'quantity'=>(int)$line[3],
			'created'=>'now()',
			'storage_place'=>$line[4],
			'priority'=>(int)$line[5]
		    );
		    xtc_db_perform('storage_products',$insert_sql_array);
		    
		    $insert_sql_array = array(
			'products_id'=>(int)$line[2],
			'editor_id'=>$_SESSION['customer_id'],
			'date_saved'=>'now()',
			'comments'=>'[INV-IMPORT] Lager (ID '.$line[0].' / Lagerplatz '.$line[4].': '.$line[3].' Stk.',
		    );
		    xtc_db_perform('products_history',$insert_sql_array);
		    $count++;
		    $check_query = xtc_db_query(sprintf(
			    "SELECT id FROM storage_numbers WHERE products_id='%s' AND storage_id='%s'",
			    (int)xtc_db_input($line[2]),
			    (int)xtc_db_input($line[0])
		    ));
		    if(xtc_db_num_rows($check_query))
			continue;
		    $insert_sql_array = array(
			'storage_id'=>(int)$line[0],
			'products_id'=>(int)$line[2],
			'nummer'=>(int)$line[2]
		    );
		    xtc_db_perform('storage_numbers',$insert_sql_array);
		    
		}
		@unlink(\main::get_importdata_path().'storage_import.csv');
		$messageStack->add_session(sprintf(MSG_SUCCESS_STORAGE_IMPORT,$count),'success');
		xtc_redirect(xtc_href_link('storage.php','action=import'));
	    }
	    
	    $smarty->display('storage_import.html');
	    exit;
	    break;
		case 'info':
			$products_id = (int)xtc_db_input($_REQUEST['products_id']);
			$product = new product($products_id);
			$smarty->assign(array(
				'TEXT_PRODUCTS_STORAGE'=>TEXT_PRODUCTS_STORAGE,
				'TEXT_PRODUCTS_STORAGE_NUMBER'=>TEXT_PRODUCTS_STORAGE_NUMBER,
				'TEXT_PRODUCTS_STORAGE_PLACE'=>TEXT_PRODUCTS_STORAGE_PLACE,
				'TEXT_PRODUCTS_STORAGE_NUMBERS'=>TEXT_PRODUCTS_STORAGE_NUMBERS,
				'TEXT_ADD_NEW_STORAGE'=>TEXT_ADD_NEW_STORAGE
			));
			$storages = $product->get_storages();
			if(sizeOf($storages)){
				$smarty->assign('STORAGES',$storages);
			}
			header('Content-Type: text/html; charset='.CHARSET);
			$smarty->display('storage_info.html');
			exit;
			break;
		case 'quicksave_place':
			$update_sql_array = array(
				'storage_place'=>$_REQUEST['storage_place']
			);
			xtc_db_perform('storage_products',$update_sql_array,'update','id='.(int)xtc_db_input($_REQUEST['id']));
			xtc_redirect(xtc_href_link($_REQUEST['from']));
			exit;
			break;
		case 'quickedit_place':
			$id = (int)xtc_db_input($_REQUEST['id']);
			$storage_product = new storage_product($id);
			header('Content-Type: text/html; charset='.CHARSET);
			echo '<div class="main">';
			echo xtc_draw_form('quickedit','storage.php',xtc_get_all_get_params(array('action')).'action=quicksave_place');
			echo '<fieldset>';
			printf('<legend><b>%s</b></legend>',TEXT_QUICKEDIT_INTRO);
			printf('<label for="storage_place">%s</label><br />',TEXT_QUICKEDIT_STORAGE_PLACE);
			echo xtc_draw_input_field('storage_place',$storage_product->getStorage_place(),'id="storage_place" size="32" maxlength="100"');
			printf('<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" />',IMAGE_SAVE);
			echo '</fieldset>';
			echo '</form></div>';
			exit;
			break;
		case 'quicksave':
			$update_sql_array = array(
				'name'=>$_REQUEST['name'],
				'beschreibung'=>$_REQUEST['beschreibung'],
				'schema_key'=>$_REQUEST['schema_key'],
				'schema_start'=>$_REQUEST['schema_start'],
				'default_storage'=>((isset($_REQUEST['default_storage']) and $_REQUEST['default_storage']==1)?'y':'n'),
				'storage_company'=>$_REQUEST['storage_company'],
				'storage_name'=>$_REQUEST['storage_name'],
				'storage_suburb'=>$_REQUEST['storage_suburb'],
				'storage_street_address'=>$_REQUEST['storage_street_address'],
				'storage_city'=>$_REQUEST['storage_city'],
				'storage_postcode'=>$_REQUEST['storage_postcode'],
				'storage_country'=>$_REQUEST['storage_country'],
				'storage_telephone'=>$_REQUEST['storage_telephone']
			    
			);
			xtc_db_perform('storages',$update_sql_array,'update','id='.(int)xtc_db_input($_REQUEST['id']));
			if(isset($_REQUEST['default_storage']) and $_REQUEST['default_storage']==1){
				xtc_db_query(sprintf(
					"UPDATE storages SET default_storage='n' WHERE id=%s",
					(int)xtc_db_input($_REQUEST['id'])
				));
			}
			xtc_redirect(xtc_href_link($_REQUEST['from']));
			exit;
			break;
		
		case 'quickedit':
			$stID = (int)xtc_db_input($_REQUEST['id']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$storage = new storage($stID);
			echo '<div class="main">';
			echo xtc_draw_form('quickedit','storage.php',xtc_get_all_get_params(array('action')).'action=quicksave');
			echo '<fieldset>';
			printf('<legend><b>%s</b></legend>',TEXT_QUICKEDIT_INTRO);
			printf('<label for="name">%s</label><br />',TEXT_QUICKEDIT_NAME);
			echo xtc_draw_input_field('name',$storage->getName(),'id="name" size="32" maxlength="128"');
			printf('<br /><label for="beschreibung">%s</label><br />',TEXT_QUICKEDIT_BESCHREIBUNG);
			echo xtc_draw_textarea_field('beschreibung','soft','45','4',$storage->getBeschreibung(),'id="beschreibung"');
			printf('<br /><label for="schema_key">%s</label><br />',TEXT_QUICKEDIT_SCHEMA_KEY);
			echo xtc_draw_input_field('schema_key',$storage->getSchema_key(),'id="schema_key"');
			printf('<br /><label for="schema_start">%s</label><br />',TEXT_QUICKEDIT_SCHEMA_START);
			echo xtc_draw_input_field('schema_start',$storage->getSchema_start(),'id="schema_start"');
			printf('<br /><label for="default_storage">%s</label> ',TEXT_QUICKEDIT_DEFAULT_STORAGE);
			echo xtc_draw_checkbox_field('default_storage',1,(($storage->getDefault_storage() == 'y') ? true : false),'id="default_storage"');
			
			
			printf('<br /><label for="storage_company">%s</label> ',CATEGORY_COMPANY);
			echo xtc_draw_input_field('storage_company',$storage->storage_company,'size="32" maxlength="64" id="storage_company"');
			printf('<br /><label for="storage_name">%s</label> ',CATEGORY_ADDRESS);
			echo xtc_draw_input_field('storage_name',$storage->storage_name,'size="32" maxlength="64" id="storage_name"');
			printf('<br /><label for="storage_street_address">%s</label> ',ENTRY_STREET_ADDRESS);
			echo xtc_draw_input_field('storage_street_address',$storage->storage_street_address,'size="32" maxlength="64" id="storage_street_address"');
			printf('<br /><label for="storage_suburb">%s</label> ',ENTRY_SUBURB);
			echo xtc_draw_input_field('storage_suburb',$storage->storage_suburb,'size="32" maxlength="32" id="storage_suburb"');
			printf('<br /><label for="storage_city">%s</label> ',ENTRY_CITY);
			echo xtc_draw_input_field('storage_city',$storage->storage_city,'size="32" maxlength="32" id="storage_city"');
			printf('<br /><label for="storage_postcode">%s</label> ',ENTRY_POST_CODE);
			echo xtc_draw_input_field('storage_postcode',$storage->storage_postcode,'size="10" maxlength="10" id="storage_postcode"');
			printf('<br /><label for="storage_country">%s</label> ',ENTRY_COUNTRY);
			echo xtc_draw_pull_down_menu('storage_country',  xtc_get_countries(),$storage->storage_country,'id="storage_country"');
			printf('<br /><label for="storage_telephone">%s</label> ',ENTRY_TELEPHONE_NUMBER);
			echo xtc_draw_input_field('storage_telephone',$storage->storage_telephone,'size="32" maxlength="32" id="storage_telephone"');
			
			printf('<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" />',IMAGE_SAVE);
			
			
			
			echo '</fieldset>';
			echo '</form></div>';
			exit;
			break;
		case 'delete_storage_place':
			if(!isset($_REQUEST['storage_id']) or !isset($_REQUEST['storage_places_id']) or !isset($_REQUEST['pID'])){
				die(json_encode(array(
					'error'=>TEXT_MISSING_PARAMS
				)));
			}
			$sID = (int)xtc_db_input($_REQUEST['storage_id']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$stpID = (int)xtc_db_input($_REQUEST['storage_places_id']);
			$name = xtc_get_storage_name($sID);
			xtc_db_query(sprintf(
				"DELETE FROM storage_products WHERE storage_id='%s' and products_id='%s' and storage_places_id='%s'",
				$sID,$pID,$stpID
			));
			$product = new product($pID);
			$comment = sprintf(
				TEXT_STORAGE_PLACE_DELETED,
				$place,$name
			);
			$product->add_history($comment);
			die(json_encode(array(
			    'html'=>yes_encode_string($comment),
			    'storage_place'=> yes_encode_string(yes_get_storage_place_title($stpID))
			)));
			exit;
			break;
	    case 'delete_storage':
			$sID = (int)xtc_db_input($_REQUEST['sID']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$name = xtc_get_storage_name($sID);
			xtc_db_query(sprintf(
				"DELETE FROM storage_numbers WHERE storage_id='%s' and products_id='%s'",
				$sID,$pID
			));
			xtc_db_query(sprintf(
				"DELETE FROM storage_products WHERE storage_id='%s' and products_id='%s'",
				$sID,$pID
			));
			$product = new product($pID);
			$product->add_history(sprintf(
				TEXT_STORAGE_ALLOCATION_DELETED,
				$name
			));
			exit;
			break;
		case 'add_storage_place_fieldset':
			if(!isset($_REQUEST['storage_id']) or (!isset($_REQUEST['storage_place']) and !isset($_REQUEST['storage_places_id'])) or !isset($_REQUEST['pID'])){
				die(json_encode(array(
					'error'=>TEXT_MISSING_PARAMS
				)));
			}
			$id = (int)xtc_db_input($_REQUEST['storage_id']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			if(isset($_REQUEST['storage_places_id'])){
			    $stpID = (int)xtc_db_input($_REQUEST['storage_places_id']);
			    $place = yes_get_storage_place_title($stpID);
			}else{
			    $place = xtc_db_input(yes_decode_string($_REQUEST['storage_place']));
			    if(strlen(trim($place)) < 1){
				    die(json_encode(array(
					    'error'=>TEXT_ERROR_MISSING_STORAGE_PLACE
				    )));
			    }
			    $query = yes_db_query(sprintf(
				    "SELECT storage_places_id FROM storage_places WHERE storage_id='%s' and title='%s'",
				    $id,$place
			    ));
			    if(yes_db_num_rows($query)){
				    die(json_encode(array(
					    'error'=>sprintf(
						    TEXT_ERROR_STORAGE_PLACE_ALLOCATION_EXISTS,
						    yes_encode_string(stripcslashes($place))
					    )
				    )));
			    }
			    $insert_sql_array = array(
				'storage_id'=>$id,
				'title'=>yes_decode_string($_REQUEST['storage_place']),
			    );
			    xtc_db_perform('storage_places',$insert_sql_array);
			    $stpID = xtc_db_insert_id();
			}
			$query = yes_db_query(sprintf(
				"SELECT id FROM storage_products WHERE storage_id='%s' and products_id='%s' and storage_places_id='%s'",
				$id,$pID,$stpID
			));
			if(yes_db_num_rows($query)){
				die(json_encode(array(
					'error'=>sprintf(
						TEXT_ERROR_PRODUCT_STORAGE_PLACE_ALLOCATION_EXISTS,
						yes_encode_string($place)
					)
				)));
			}
			$insert_sql_array = array(
				'storage_id'=>$id,
				'products_id'=>$pID,
				'storage_places_id'=>$stpID
			);
			xtc_db_perform('storage_products',$insert_sql_array);
			$product = new product($pID);
			$product->add_history(sprintf(
				TEXT_STORAGE_PLACE_CREATED,
				xtc_get_storage_name($id),$id,$place
			));
			$smarty->assign(array(
				'storage_id'=>$id,
				'storage_place'=>yes_encode_string($place),
				'action'=>'get_storage_place_fieldset',
				'storage_places_id'=>$stpID
			));
			$html = $smarty->fetch('storages_admin.html');
			die(json_encode(array(
				'html'=>yes_encode_string($html)
			)));
			exit;
			break;
		case 'get_storage_fieldset':
			if(!isset($_REQUEST['sID']) or !isset($_REQUEST['pID']) or !isset($_REQUEST['storage_number'])){
				die(json_encode(array(
					'error'=>TEXT_MISSING_PARAMS
				)));
			}
			$id = (int)xtc_db_input($_REQUEST['sID']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$nr = xtc_db_input($_REQUEST['storage_number']);
			if(strlen(trim($nr)) < 1){
				die(json_encode(array(
					'error'=>TEXT_ERROR_MISSING_STORAGE_NUMBER
				)));
			}
			$query = yes_db_query(sprintf(
				"SELECT id FROM storage_numbers WHERE storage_id='%s' and products_id='%s'",
				$id,$pID
			));
			if(yes_db_num_rows($query)){
				die(json_encode(array(
					'error'=>TEXT_ERROR_PRODUCT_STORAGE_NUMBER_EXISTS
				)));
			}
			$query = yes_db_query(sprintf(
				"SELECT id FROM storage_numbers WHERE storage_id='%s' and nummer='%s'",
				$id,$nr
			));
			if(yes_db_num_rows($query)){
				die(json_encode(array(
					'error'=>sprintf(
						TEXT_ERROR_STORAGE_NUMBER_EXISTS,
						$nr
					)
				)));
			}
			$insert_sql_array = array(
				'storage_id'=>$id,
				'products_id'=>$pID,
				'nummer'=>$nr
			);
			xtc_db_perform('storage_numbers',$insert_sql_array);
			$product = new product($pID);
			$product->add_history(sprintf(
				TEXT_STORAGE_NUMBER_ALLOCATED,
				xtc_get_storage_name($id),$id,$nr
			));
			$get_available_places = true;
			$strgs = $product->get_storages($get_available_places);
			$stplaces = array(array('id'=>'','text'=>TEXT_SELECT));
			foreach($strgs as $strgk=>$strg){
			    if($strg['storage_id'] != $id or !isset($strg['av_places']))
				continue;
			    foreach($strg['av_places'] as $plck=>$plc){
				$stplaces[] = array(
				    'id'=>$plc['storage_places_id'],
				    'text'=>htmlentities(yes_encode_string(stripcslashes($plc['title'])))
				);
			    }
			}
			
			$smarty->assign(array(
			    'action'=>'get_fieldset',
			    'storage_id'=>$id,
			    'INPUT_AV_STORAGE_PLACES'=>xtc_draw_pull_down_menu('storage_places_id['.$id.']',$stplaces)
			));
			$smarty->assign('storage',array('id'=>$id,'name'=>xtc_get_storage_name($id),'number'=>$nr));
			
			
			
			
			$html = $smarty->fetch('storages_admin.html');
			die(json_encode(array('html'=>yes_encode_string($html))));
			break;
	  case 'get_storage_number_from_storage_id':
			$id = (int)xtc_db_input($_REQUEST['sID']);
			$pID = (int)xtc_db_input($_REQUEST['pID']);
			$nummer_query = yes_db_query(sprintf(
				"SELECT * FROM storages WHERE id='%s'",
				$id
			));
			if(yes_db_num_rows($nummer_query)){
				$nummer = current($nummer_query);
				$schema_key = xtc_db_prepare_input($nummer['schema_key']);
				$schema_start = (int)xtc_db_prepare_input($nummer['schema_start']);
				if($schema_start >= 0){
				    $key_query = yes_db_query(sprintf(
					    "SELECT MAX( CONVERT( SUBSTRING(nummer,%s),UNSIGNED INTEGER ) ) as numb FROM storage_numbers WHERE nummer LIKE '%s%%' LIMIT 1",
					    strlen($schema_key)+1,$schema_key
				    ));
				    $key = xtc_db_fetch_array($key_query);

				    if((int)$key['numb'] >= $schema_start)
					    $new_key = $schema_key.($key['numb']+1);
				    else
					    $new_key = $schema_key.$schema_start;
				}else{
				    $new_key = $schema_key.$pID;
				}
				echo json_encode(array('html'=>yes_decode_string($new_key)));
			}else{
				die('UNKNOWN STORAGE');
			}
			exit;
		  break;
      case 'save':
        $sID = xtc_db_prepare_input($_GET['sID']);
	$name = xtc_db_prepare_input($_POST['name']);
	$beschreibung = xtc_db_prepare_input($_POST['beschreibung']);
	$schema_key = xtc_db_prepare_input($_POST['schema_key']);
	$schema_start = xtc_db_prepare_input($_POST['schema_start']);
	$default_storage = xtc_db_prepare_input($_POST['default_storage']);
        if($default_storage!=''){
	    	$default_storage = 'y';
	    	// vorhandenes defaultlager loeschen
	    	xtc_db_query("UPDATE storages SET default_storage='n' WHERE default_storage='y'");
	}else{
		$default_storage = 'n';
	}
		
	$update_sql_array = array(
	    'name'=>$name,
	    'beschreibung'=>$beschreibung,
	    'schema_key'=>$schema_key,
	    'schema_start'=>$schema_start,
	    'default_storage'=>$default_storage,
	    'storage_company'=>$_REQUEST['storage_company'],
	    'storage_name'=>$_REQUEST['storage_name'],
	    'storage_suburb'=>$_REQUEST['storage_suburb'],
	    'storage_street_address'=>$_REQUEST['storage_street_address'],
	    'storage_city'=>$_REQUEST['storage_city'],
	    'storage_postcode'=>$_REQUEST['storage_postcode'],
	    'storage_country'=>$_REQUEST['storage_country'],
	    'storage_telephone'=>$_REQUEST['storage_telephone'],
	);
	xtc_db_perform('storages',$update_sql_array,'update',"id = '" . $sID . "'");
	//xtc_db_query("update storages set name='".$name."',beschreibung='".$beschreibung."',schema_key='".$schema_key."',schema_start='".$schema_start."',default_storage='".$default_storage."' where );
        xtc_redirect(xtc_href_link('storage.php', 'sID=' . $sID));
        break;
      case 'insert':
      	$auto_default = false; // wenn kein default-lager existiert, dann dieses neue nehmen
		$name = xtc_db_prepare_input($_POST['name']);
		$beschreibung = xtc_db_prepare_input($_POST['beschreibung']);
		$schema_key = xtc_db_prepare_input($_POST['schema_key']);
        $schema_start = xtc_db_prepare_input($_POST['schema_start']);
        $default_storage = xtc_db_prepare_input($_POST['default_storage']);
        
        $no_default_query = xtc_db_query("SELECT id FROM storages WHERE default_storage='y'");
        if(xtc_db_num_rows($no_default_query) < 1 && $default_storage==''){
	        $auto_default = true;
	        $messageStack->add_session('Das Lager '.$name.' wurde als Default Lager markiert, da kein anderes festgelegt wurde.','success');
    	}
        if($default_storage!=''){
	    	$default_storage = 'y';
	    	// vorhandenes defaultlager loeschen
	    	xtc_db_query("UPDATE storages SET default_storage='n' WHERE default_storage='y'");
	    }else{
		    if($auto_default == true){
		    	xtc_db_query("UPDATE storages SET default_storage='n' WHERE default_storage='y'");
			    $default_storage = 'y';
			}else{
			    $default_storage = 'n';
			}
		}
	$insert_sql_array = array(
	    'name'=>$name,
	    'beschreibung'=>$beschreibung,
	    'schema_key'=>$schema_key,
	    'schema_start'=>$schema_start,
	    'default_storage'=>$default_storage,
	    'storage_company'=>$_REQUEST['storage_company'],
	    'storage_name'=>$_REQUEST['storage_name'],
	    'storage_suburb'=>$_REQUEST['storage_suburb'],
	    'storage_street_address'=>$_REQUEST['storage_street_address'],
	    'storage_city'=>$_REQUEST['storage_city'],
	    'storage_postcode'=>$_REQUEST['storage_postcode'],
	    'storage_country'=>$_REQUEST['storage_country'],
	    'storage_telephone'=>$_REQUEST['storage_telephone']
	);
	xtc_db_perform('storages',$insert_sql_array);
        //xtc_db_query("insert into storages set name='".$name."',beschreibung='".$beschreibung."',schema_key='".$schema_key."',schema_start='".$schema_start."',default_storage='".$default_storage."'");
        $sID = xtc_db_insert_id();
        xtc_redirect(xtc_href_link('storage.php', 'sID=' . $sID));
        break;
    case 'delete':
        $sID = xtc_db_prepare_input($_GET['sID']);
	$name = xtc_db_prepare_input($_POST['name']);

        xtc_db_query("DELETE FROM storages WHERE id='".$sID."'");
	xtc_db_query("DELETE FROM storage_numbers WHERE storage_id='".$sID."'");
	xtc_db_query("DELETE FROM storage_products WHERE storage_id='".$sID."'");
	xtc_db_query("DELETE FROM storage_places WHERE storage_id='".$sID."'");
	xtc_db_query("UPDATE distributors SET default_delivery_storage_id='0' WHERE default_delivery_storage_id='".$sID."'");
        xtc_redirect(xtc_href_link('storage.php'));
        break;
    }
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
	<!--
	function check_storage_form(){
		f = document.forms['storage_form'];
		len = f.length;
		error = false;
		for(i = 0; i < len; i++){
			var fname = '';
			switch(f.elements[i].name){
				case 'name':
					fname = 'Lagerort Name';
					break;
				case 'schema_key':
					fname = 'Nummernschluessel';
					break;
				case 'schema_start':
					fname = 'Nummern-Start';
					break;
			}
			switch(f.elements[i].name){
				case 'name':
				case 'schema_key':
					val = f.elements[i].value;
					val = $.trim(val);
					if(val.length < 2){
						error = true;
						alert("<?php echo JS_ERROR_CF_MISSING_FIELD_STRLEN; ?>\r\nFeld: "+fname);
					}
					break;
				case 'schema_start':
					val = f.elements[i].value;
					val = $.trim(val);
					if(isNaN(val)){
						error = true;
						alert("<?php echo JS_ERROR_CF_MISSING_FIELD_NUMBER; ?>\r\nFeld: "+fname);
					}
					break;
			}
		}
		if(!error)
			return true;
	   return false;
	}
	//-->
</script>
<?php 
$smarty->display('storage.html');
?>

		<table border="0" width="100%" cellspacing="2" cellpadding="0">
		<tr>
			<td valign="top" class="ui-widget-content">
				<table border="0" width="100%" class="yes-ui-table">
				<thead>
					<tr class="ui-widget-header">
					    <th><?php echo TEXT_PRODUCTS_STORAGE; ?></th>
					    <th><?php echo TEXT_QUICKEDIT_BESCHREIBUNG; ?></th>
					    <th><?php echo TEXT_QUICKEDIT_SCHEMA_KEY; ?></th>
					    <th><?php echo TEXT_QUICKEDIT_SCHEMA_START; ?></th>
					    <th>&nbsp;</th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td colspan="5" align="center"><?php echo xtc_image('images/icons/success.gif',TEXT_QUICKEDIT_DEFAULT_STORAGE); ?> <font size="1"><?php echo TEXT_QUICKEDIT_DEFAULT_STORAGE; ?></font></td>
					</tr>
				</tfoot>
			<tbody>
<?php
  $storages_query = xtc_db_query("select * from storages ORDER by name");


  while ($storage = xtc_db_fetch_array($storages_query)) {
    if (((!isset($_GET['sID'])) || (@$_GET['sID'] == $storage['id'])) && (!isset($sInfo)) && (!isset($_GET['action']) or substr($_GET['action'], 0, 3) != 'new')) {
      $sInfo = new objectInfo($storage);
    }

    if ( (isset($sInfo) and is_object($sInfo)) && ($storage['id'] == $sInfo->id) ) {
      echo '                  <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link('storage.php', 'sID=' . $sInfo->id . '&action=edit') . '\'" class="ui-state-highlight">' . "\n";
    } else {
      echo '                  <tr onmouseover="this.style.cursor=\'hand\'" onclick="document.location.href=\'' . xtc_href_link('storage.php', 'sID=' . $storage['id']) . '\'">' . "\n";
    }
?>
                <td><table border="0" cellpadding="0" cellspacing="0"><tr><td><?php echo (($storage['default_storage'] == 'y') ? xtc_image('images/icons/success.gif','Default Lager') : '' ) .'&nbsp;</td><td><font size=1>'. $storage['name']; ?>&nbsp;</font></td></tr></table></td>
                <td><?php echo $storage['beschreibung']; ?>&nbsp;</td>
                <td><?php echo $storage['schema_key']; ?>&nbsp;</td>
                <td><?php echo $storage['schema_start']; ?>&nbsp;</td>

                <td><?php if ( (isset($sInfo) and is_object($sInfo)) && ($storage['id'] == $sInfo->id) ) { echo xtc_image(DIR_WS_IMAGES . 'icon_arrow_right.gif', ''); } else {		    echo '<a href="' . xtc_href_link('storage.php', 'sID=' . $storage['id']) . '">' . xtc_image(DIR_WS_IMAGES . 'icon_info.gif', IMAGE_ICON_INFO) . '</a>'; } ?>&nbsp;</td>
              </tr>
<?php
  }
?>
			</tbody>
            </table>
			</td>
            <script type="text/javascript">
            <!--
            function really_delete(sid) {
	            ok = confirm('<?php echo JS_CONFIRM_REALLY_DELETE_STORAGE; ?>');
	            if(ok){
		            if(sid>0){
	            		window.location.href='<?php echo xtc_href_link('storage.php','action=delete'); ?>&sID='+sid;
            		}else{
	            		alert('<?php echo JS_ERROR_CANT_DELETE_STORAGE; ?>');	
	            	}
            	}
	        }
            //-->
            </script>
<?php
$heading = array();
$contents = array();
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';
switch ($action) {
    case 'edit':
	$heading[] = array('text' => '<b>'.sprintf(TEXT_EDIT_STORAGE_PLACE,$sInfo->name).'</b>');
	$contents = array('form' => xtc_draw_form('storage', 'storage.php', 'sID=' . $sInfo->id . '&action=save','post','id="storage_form" onsubmit="return check_storage_form()"'));
	$contents[] = array('text' => TEXT_EDIT_STORAGE_PLACE_INTRO);
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_NAME.'</b><br />' . xtc_draw_input_field('name',$sInfo->name));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_BESCHREIBUNG.'</b><br />' . xtc_draw_textarea_field('beschreibung','soft','17','4',$sInfo->beschreibung));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_SCHEMA_KEY.'</b><br />' . xtc_draw_input_field('schema_key',$sInfo->schema_key));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_SCHEMA_START.'</b><br />' . xtc_draw_input_field('schema_start',$sInfo->schema_start));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_DEFAULT_STORAGE.'</b><br />' . xtc_draw_checkbox_field('default_storage',(($sInfo->default_storage == 'y') ? true : false)) );
	$contents[] = array('text' => '<b>'.CATEGORY_COMPANY.':</b><br />'.xtc_draw_input_field('storage_company',$sInfo->storage_company,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.CATEGORY_ADDRESS.':</b><br />'.xtc_draw_input_field('storage_name',$sInfo->storage_name,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_SUBURB.'</b><br />'.xtc_draw_input_field('storage_suburb',$sInfo->storage_suburb,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_STREET_ADDRESS.'</b><br />'.xtc_draw_input_field('storage_street_address',$sInfo->storage_street_address,'size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_CITY.'</b><br />'.xtc_draw_input_field('storage_city',$sInfo->storage_city,'size="32" maxlength="32"'));
	$contents[] = array('text' => '<b>'.ENTRY_POST_CODE.'</b><br />'.xtc_draw_input_field('storage_postcode',$sInfo->storage_postcode,'size="10" maxlength="10"'));
	$contents[] = array('text' => '<b>'.ENTRY_COUNTRY.'</b><br />'.xtc_draw_pull_down_menu('storage_country',  xtc_get_countries(),$sInfo->storage_country));
	$contents[] = array('text' => '<b>'.ENTRY_TELEPHONE_NUMBER.'</b><br />'.xtc_draw_input_field('storage_telephone',$sInfo->storage_telephone,'size="32" maxlength="32"'));
	$contents[] = array('align' => 'center', 'text' => '<br />' . xtc_image_submit('button_update.gif', IMAGE_UPDATE) . '&nbsp;<a href="' . xtc_href_link('storage.php', 'sID=' . $sInfo->id) . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
	break;
    case 'new':
	$heading[] = array('text' => '<b>Neuen Lagerort anlegen</b>');
	$contents = array('form' => xtc_draw_form('storage', 'storage.php', 'action=insert','post','id="storage_form" onsubmit="return check_storage_form()"'));
	$contents[] = array('text' => 'Bitte geben Sie hier die Angaben des Lagers an. Wird als Nummern-Start der Wert -1 eingegeben, dann wird nach dem Nummernschl&uuml;ssel die pID des Artikels verwendet bei einer automatischen Lagernummernvergabe.');
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_NAME.'</b><br />' . xtc_draw_input_field('name',''));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_BESCHREIBUNG.'</b><br />' . xtc_draw_textarea_field('beschreibung','soft','17','4',''));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_SCHEMA_KEY.'</b><br />' . xtc_draw_input_field('schema_key',''));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_SCHEMA_START.'</b><br />' . xtc_draw_input_field('schema_start',''));
	$contents[] = array('text' => '<br /><b>'.TEXT_QUICKEDIT_DEFAULT_STORAGE.'</b><br />' . xtc_draw_checkbox_field('default_storage',false));
	$contents[] = array('text' => '<b>'.CATEGORY_COMPANY.':</b><br />'.xtc_draw_input_field('storage_company','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.CATEGORY_ADDRESS.':</b><br />'.xtc_draw_input_field('storage_name','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_SUBURB.'</b><br />'.xtc_draw_input_field('storage_suburb','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_STREET_ADDRESS.'</b><br />'.xtc_draw_input_field('storage_street_address','','size="32" maxlength="64"'));
	$contents[] = array('text' => '<b>'.ENTRY_CITY.'</b><br />'.xtc_draw_input_field('storage_city','','size="32" maxlength="32"'));
	$contents[] = array('text' => '<b>'.ENTRY_POST_CODE.'</b><br />'.xtc_draw_input_field('storage_postcode','','size="10" maxlength="10"'));
	$contents[] = array('text' => '<b>'.ENTRY_COUNTRY.'</b><br />'.xtc_draw_pull_down_menu('storage_country',  xtc_get_countries(),STORE_COUNTRY));
	$contents[] = array('text' => '<b>'.ENTRY_TELEPHONE_NUMBER.'</b><br />'.xtc_draw_input_field('storage_telephone','','size="32" maxlength="32"'));
	$contents[] = array('align' => 'center', 'text' => '<br />' . xtc_image_submit('button_update.gif', IMAGE_UPDATE) . '&nbsp;<a href="' . xtc_href_link('storage.php') . '">' . xtc_image_button('button_cancel.gif', IMAGE_CANCEL) . '</a>');
	break;
    default:
      if (is_object($sInfo)) {
        $heading[] = array('text' => '<b>'.sprintf(TEXT_EDIT_STORAGE_PLACE,$sInfo->name).'</b>');
        $contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_EDIT, xtc_href_link('storage.php','sID=' . $sInfo->id . '&action=edit'),'width:200px;'));
        $contents[] = array('align' => 'center', 'text' => '<input type="button" onclick="really_delete(\''.$sInfo->id.'\');" class="ui-button ui-corner-all ui-state-default" style="width:200px;" value="'.IMAGE_DELETE.'" /><br />('.TEXT_DELETE_STORAGE_PLACE_INTRO.')');
	$contents[] = array('align'=>'center', 'text' => "<input onclick=\"window.location.href='".xtc_href_link('storage_numbers.php','sID='. $sInfo->id)."';\" type=\"button\" value=\"".TEXT_STORAGE_PLACE_PRODUCT_NUMBERS."\" class=\"ui-button ui-corner-all ui-state-default\" style=\"width:200px;\" />");
	$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(IMAGE_VIEW_STORAGE_PRODUCTS, xtc_href_link('stats_stock_warning.php','storage_id='.$sInfo->id), 'width:200px;'));
	$contents[] = array('align'=>'center','text'=>  yes_draw_href_button(IMAGE_VIEW_DEFAULT_STORAGE_PRODUCTS, xtc_href_link('categories.php','default_storage='.$sInfo->id), 'width:200px;'));
        $contents[] = array('text' => '<br /><b>'.$sInfo->name."</b>");
        $contents[] = array('text' => '<br />'.$sInfo->beschreibung);
        $contents[] = array('text' => '<br />'.TEXT_QUICKEDIT_SCHEMA_KEY.': '.$sInfo->schema_key);
	if($sInfo->schema_start >= 0){
		$contents[] = array('text' => '<br />'.TEXT_QUICKEDIT_SCHEMA_START.': '.$sInfo->schema_start);
	}else{
		$contents[] = array('text' => TEXT_AUTOMATIC_SCHEMA_KEY_GEN_INTRO);
	}
		$contents[] = array('text' => '<br />'.TEXT_QUICKEDIT_DEFAULT_STORAGE.': '.(($sInfo->default_storage == 'y') ? YES : NO ) );
      }
      break;
  }

  if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    echo '            <td width="25%" valign="top" class="ui-widget-content">' . "\n";

    $box = new box;
    echo $box->infoBox($heading, $contents);

    echo '            </td>' . "\n";
  }
?>
          </tr>
        </table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
