<?php
include('includes/application_top.php');
require_once(DIR_WS_CLASSES.'product.php');
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'yes_multisort.inc.php');
$allowed_orders_statuses = array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_BEZAHLT);
$default_from = (new DateTime('-4 Weeks'))->format('Y-m-d');
$sort_by = isset($_REQUEST['sort_by']) ? xtc_db_input($_REQUEST['sort_by']) : 'RECLAMATIONS';
$from = isset($_REQUEST['start_date']) ? xtc_db_input($_REQUEST['start_date']) : $default_from;
$to = isset($_REQUEST['end_date']) ? xtc_db_input($_REQUEST['end_date']) : date('Y-m-d',time());
$orders_status = isset($_REQUEST['orders_status']) ? (int)xtc_db_input($_REQUEST['orders_status']) : 0;
if($orders_status > 0){
    if(!in_array($orders_status,$allowed_orders_statuses)){
	$orders_status = 0;
    }
}

function _getOrdersByProductsIDAndDate($products_id,$from,$to,$source = ''){
    global $allowed_orders_statuses,$orders_status;
    $vo = $allowed_orders_statuses;
    if($orders_status > 0){
	$vo = array($orders_status);
    }
    $orders = array();
    $sources_sql = '';
    if($source != ''){
	$sources_sql = " AND (o.source=";
	switch($source){
	    case 'amazon':
	    case 'ebay':
	    case 'shop':
	    case 'counter':
	    case 'admin':
		$sources_sql .= "'".$source."'";
		break;
	}
	if($source == 'admin'){
	    $sources_sql .= " OR o.source='' ";
	}
	$sources_sql .= ")";
    }
    $query = xtc_db_query(sprintf(
	    "SELECT r.orders_id FROM orders o LEFT JOIN reclamations r USING(orders_id) LEFT JOIN reclamations_products rp USING(reclamations_id) WHERE r.date_created > '%s' AND r.date_created < '%s' AND products_id='%s' AND o.orders_status IN(%s) %s",
	    $from,$to.' 00:00:01',$products_id,implode(',',$vo),$sources_sql
    ));
    while($record = xtc_db_fetch_array($query)){
	$orders[] = $record['orders_id'];
    }
    return $orders;
}

function _getRueckerstattungen($products_id,$from,$to){
    $count = 0;
    $orders = _getOrdersByProductsIDAndDate($products_id,$from,$to);
    foreach($orders as $orders_id){
	$query = xtc_db_query(sprintf(
		"SELECT COUNT(rueckerstattungs_id) AS anz FROM rueckerstattungen r WHERE r.orders_id = '%s'",
		$orders_id
	));
	$record = xtc_db_fetch_array($query);
	$count += $record['anz'];
    }
    return $count;
}

function _getRetoure($products_id,$from,$to){
    $count = 0;
    $orders = _getOrdersByProductsIDAndDate($products_id,$from,$to);
    foreach($orders as $orders_id){
	$query = xtc_db_query(sprintf(
		"SELECT COUNT(retoure_id) AS anz FROM retouren r WHERE r.orders_id = '%s'",
		$orders_id
	));
	$record = xtc_db_fetch_array($query);
	$count += $record['anz'];
    }
    return $count;
}

function _getOrdersByStatus($orders_status_id,$products_id,$from,$to){
    $count = 0;
    $orders = _getOrdersByProductsIDAndDate($products_id,$from,$to);
    foreach($orders as $orders_id){
	$query = xtc_db_query(sprintf(
		"SELECT orders_id FROM orders o WHERE orders_status = '%s' AND orders_id='%s'",
		$orders_status_id,$orders_id
	));
	if(xtc_db_num_rows($query)){
	    $count++;
	}
    }
    return $count;
}
function _getCostsReclamations($products_id,$from,$to){
    $sum = 0;
    $query = xtc_db_query(sprintf(
	    "SELECT SUM(c.value) as costs FROM reclamations r LEFT JOIN costs c USING(reclamations_id) WHERE r.date_created > '%s' AND r.date_created < '%s'",
	    $from,$to.' 00:00:01'
    ));
    while($record = xtc_db_fetch_array($query)){
	$sum += $record['costs'];
    }
    return number_format($sum,2,'.','');
}

function _getNetto($products_id,$qty,$from,$to){
    $sum = 0;
    $orders = _getOrdersByProductsIDAndDate($products_id,$from,$to);
    foreach($orders as $orders_id){
	$query = xtc_db_query(sprintf(
		"SELECT products_price,products_tax,allow_tax FROM orders_products op WHERE orders_id = '%s' AND products_id='%s'",
		$orders_id,$products_id
	));
	while($record = xtc_db_fetch_array($query)){
	    if($record['allow_tax'] == 1){
		if($record['products_tax'] > 0){
		    $sum += $qty*xtc_oe_get_price_o_tax($record['products_price'], $record['products_tax'], false);
		}
	    }
	}
    }
    return number_format($sum,2,'.','');
}

function _getOrders($products_id,$from,$to){
    $orders = _getOrdersByProductsIDAndDate($products_id,$from,$to);
    return sizeOf($orders);
}
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$items = array();
$query = xtc_db_query(sprintf(
	"SELECT rp.products_id,SUM(rp.products_quantity) as reclamations FROM reclamations r LEFT JOIN reclamations_products rp USING(reclamations_id) WHERE r.date_created > '%s' AND r.date_created < '%s' GROUP BY products_id",
	$from,$to.' 00:00:01'
));
while($record = xtc_db_fetch_array($query)){
    $product = new product($record['products_id']);
    $items[] = array(
	'PID'=>$record['products_id'],
	'NAME'=>$product->info['products_name'],
	'NUMBER'=>$product->info['products_model'],
	'RECLAMATIONS'=>$record['reclamations'],
	'RUECKERSTATTUNGEN'=>_getRueckerstattungen($record['products_id'],$from,$to),
	'RETOUREN'=>_getRetoure($record['products_id'],$from,$to),
	'ORDERS'=>_getOrders($record['products_id'],$from,$to),
	/*'STORNOS'=>_getOrdersByStatus(ORDERS_STATUS_STORNIERT,$record['products_id'],$from,$to),*/
	'NETTO'=>_getNetto($record['products_id'],$record['reclamations'],$from,$to),
	'COSTS_RECLAMATIONS'=>_getCostsReclamations($record['products_id'],$from,$to),
	'EBAY'=>sizeOf(_getOrdersByProductsIDAndDate($record['products_id'],$from,$to,'ebay')),
	'AMAZON'=>sizeOf(_getOrdersByProductsIDAndDate($record['products_id'],$from,$to,'amazon')),
	'SHOP'=>sizeOf(_getOrdersByProductsIDAndDate($record['products_id'],$from,$to,'shop')),
	'ADMIN'=>sizeOf(_getOrdersByProductsIDAndDate($record['products_id'],$from,$to,'admin')),
	'COUNTER'=>sizeOf(_getOrdersByProductsIDAndDate($record['products_id'],$from,$to,'counter')),
    );
}
if(sizeOf($items)){
    $sort_dir = (isset($_REQUEST['sort_dir']) and $_REQUEST['sort_dir'] == 'DESC') ? SORT_DESC : SORT_ASC;
    $items = yes_multisort($items,$sort_by,$sort_dir);
}
if(isset($_REQUEST['csv'])){
	require(DIR_WS_CLASSES.'class.csv.php');
	$filename = sprintf('stats_reclamations_products_'.date('Y-m-d_His').'.csv');
	$fh = fopen(\main::get_exportdata_path().$filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	fclose($fh);
	$CSV = new CSVfile(\main::get_exportdata_path().$filename);
	$CSV->delimiter = "\t";
	$CSV->open('w');
	$csv_header = array(
	    'pID',
	    TABLE_HEADING_NAME,
	    TABLE_HEADING_NUMBER,
	    TABLE_HEADING_RECLAMATIONS,
	    TABLE_HEADING_RUECKERSTATTUNGEN,
	    TABLE_HEADING_RETOUREN,
	    TABLE_HEADING_ORDERS,
	    /*TABLE_HEADING_STORNOS,*/
	    TABLE_HEADING_TOTAL_NETTO,
	    TABLE_HEADING_COSTS_RECLAMATIONS,
	    TABLE_HEADING_EBAY,
	    TABLE_HEADING_AMAZON,
	    TABLE_HEADING_SHOP,
	    TABLE_HEADING_ADMIN,
	    TABLE_HEADING_COUNTER
	);
	$CSV->addRow($csv_header);
	foreach($items as $product){
	    $line = array();
	    foreach($product as $pd){
		$line[] = $pd;
	    }
	    $CSV->addRow($line);
	}
	$CSV->close();
	$content = file_get_contents(\main::get_exportdata_path().$filename);
	unlink(\main::get_exportdata_path().$filename);
	$len = strlen($content);
	header("Content-type: text/csv");
	header("Content-Disposition: attachment; filename=".$filename);
	header("Content-Length: ".$len);
	echo $content;
	exit;
}
yes_draw_pre_header();
yes_draw_header(TITLE);


$os_array = array(
    array('id'=>'','text'=>TEXT_ONLY_ORDERS_STATUS_ALL),
    array('id'=>ORDERS_STATUS_ABGESCHLOSSEN,'text'=>  xtc_get_orders_status_name(ORDERS_STATUS_ABGESCHLOSSEN)),
    array('id'=>ORDERS_STATUS_VERSENDET,'text'=>  xtc_get_orders_status_name(ORDERS_STATUS_VERSENDET)),
    array('id'=>ORDERS_STATUS_BEZAHLT,'text'=>  xtc_get_orders_status_name(ORDERS_STATUS_BEZAHLT))
);
$buttons = array();
$smarty->assign(array(
    'PAGE_HEADING'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'from'=>$from,
    'to'=>$to,
    'TEXT_STARTDATE'=>TEXT_STARTDATE,
    'TEXT_ENDDATE'=>TEXT_ENDDATE,
    'TABLE_HEADING_NAME'=>TABLE_HEADING_NAME,
    'TABLE_HEADING_NUMBER'=>TABLE_HEADING_NUMBER,
    'TABLE_HEADING_RECLAMATIONS'=>TABLE_HEADING_RECLAMATIONS,
    'TABLE_HEADING_RUECKERSTATTUNGEN'=>TABLE_HEADING_RUECKERSTATTUNGEN,
    'TABLE_HEADING_RETOUREN'=>TABLE_HEADING_RETOUREN,
    'TABLE_HEADING_ORDERS'=>TABLE_HEADING_ORDERS,
    'TABLE_HEADING_STORNOS'=>TABLE_HEADING_STORNOS,
    'TABLE_HEADING_TOTAL_NETTO'=>TABLE_HEADING_TOTAL_NETTO,
    'TABLE_HEADING_COSTS_RECLAMATIONS'=>TABLE_HEADING_COSTS_RECLAMATIONS,
    'TABLE_HEADING_EBAY'=>TABLE_HEADING_EBAY,
    'TABLE_HEADING_AMAZON'=>TABLE_HEADING_AMAZON,
    'TABLE_HEADING_SHOP'=>TABLE_HEADING_SHOP,
    'TABLE_HEADING_ADMIN'=>TABLE_HEADING_ADMIN,
    'TABLE_HEADING_COUNTER'=>TABLE_HEADING_COUNTER,
    'items'=>$items,
    'TEXT_ONLY_ORDERS_STATUS'=>TEXT_ONLY_ORDERS_STATUS,
    'INPUT_ORDERS_STATUS'=>xtc_draw_pull_down_menu('orders_status',$os_array,$orders_status),
    'SORTING'=>$sort_by,
    'SORT_DIR'=>(isset($_REQUEST['sort_dir']) and $_REQUEST['sort_dir'] == 'DESC') ? 'DESC' : 'ASC',
    'BASELINK_SORT'=>xtc_href_link(basename($_SERVER['PHP_SELF']), xtc_get_all_get_params(array('sort_by','sort_dir'))),
    'TEXT_STATS_STATUS_FILTER'=>TEXT_STATS_STATUS_FILTER
));
$smarty->display('stats_reclamations_products.html');
include('includes/footer.php');
include('includes/application_bottom.php');
