<?php
$errors = array();
$mode = (isset($_REQUEST['mode'])) ? $_REQUEST['mode'] : 'delivery';
if(isset($_REQUEST['reset']) and $_REQUEST['reset'] == 1){
	$_SESSION['scanner'] = array();
	$messageStack->add_session(MSG_SUCCESS_RESET,'success');
	xtc_redirect(xtc_href_link('shipping.php','action=daily_otc'));
}
if(isset($_REQUEST['export']) and $_REQUEST['export'] == 1){
	if(!is_countable($_SESSION['scanner']) or !sizeOf($_SESSION['scanner'])){
		$messageStack->add_session(MSG_ERROR_EXPORT,'error');
		xtc_redirect(xtc_href_link('shipping.php','action=daily_otc'));
	}
	$crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
	$crypt_file = yes_get_sha1_from_string( date('d.m.Y_H.i.s') );
	if(!is_dir(\main::get_exportdata_path().$crypt_dir)){
		mkdir(\main::get_exportdata_path().$crypt_dir);
	}
	$csv_file = \main::get_exportdata_path().$crypt_dir.'/VERSANDCODES_'.$crypt_file.'.csv';
	if(!is_file($csv_file)){
		$fp = fopen($csv_file,"w");
		fclose($fp);
	}
	$CSV = new CSVfile($csv_file);
	$CSV->setDelimiter("\t");
	$CSV->open("w");
	$CSV->setEncapsulate('"');
	$CSV->addRow(array(
		'AUFTRAG/REKLA','VERSANDCODE'
	));
	foreach($_SESSION['scanner'] as $scan=>$data){
		if($scan[0] == 'R'){
			$id = (int)substr($scan,1,strlen($scan));
			$csv_scan = 'R'.$id;
			$reclamation = new reclamation($id);
			$reclamation->add_history($reclamation->info['reclamations_status'], false, sprintf(
				TEXT_HISTORY_CODES,implode(',',$data['RESULT_CODE'])
			));
		}else{
			$id = (int)$scan;
			$csv_scan = $id;
			$order = new order($id);
			$YS = new yes_shipping;
			foreach($data['RESULT_CODE'] as $transaction_id){
			    $YS->add_tracking_number($id, $transaction_id);
			}
			$order->add_history($order->info['orders_status'], false, sprintf(
				TEXT_HISTORY_CODES,implode(',',$data['RESULT_CODE'])
			));
		}
		$CSV->addRow(array(
			$csv_scan,implode(',',$data['RESULT_CODE'])
		));
	}
	$CSV->close();
	$_SESSION['scanner'] = array();
	$messageStack->add_session(MSG_SUCCESS_EXPORT,'success');
	xtc_redirect(xtc_href_link('shipping.php','action=daily_otc'));
}
if(isset($_REQUEST['delete_id']) and is_numeric($_REQUEST['delete_id'])){
	unset($_SESSION['scanner'][$_REQUEST['delete_id']]);
	exit;
}
if(isset($_REQUEST['scanner']) and !empty($_REQUEST['scanner']) and isset($_REQUEST['scan_delivery']) and !empty($_REQUEST['scan_delivery'])){
	$scanner_result = xtc_db_input($_REQUEST['scanner']);
	if(!isset($_SESSION['scanner'])){
		$_SESSION['scanner'] = array();
	}
	if(!isset($_SESSION['scanner'][$scanner_result])){
		$_SESSION['scanner'][$scanner_result] = array(
			'RESULT_CODE'=>array($_REQUEST['scan_delivery']),
			'COUNTER'=>1
		);
	}else{
		$counter = $_SESSION['scanner'][$scanner_result]['COUNTER']+1;
		if(!in_array($_REQUEST['scan_delivery'],$_SESSION['scanner'][$scanner_result]['RESULT_CODE'])){
			$_SESSION['scanner'][$scanner_result] = array(
				'RESULT_CODE'=>  xtc_array_merge($_SESSION['scanner'][$scanner_result]['RESULT_CODE'], array($_REQUEST['scan_delivery'])),
				'COUNTER'=>$counter
			);
		}
	}
}
if(isset($_REQUEST['delivery']) and $_REQUEST['delivery'] == 1){
	printf('<div style="margin-bottom: 20px;font-family:sans-serif;font-size:26px; color: #444;"><i>Eingescannter Wert: %s</i></div>',$_REQUEST['scanner']);
	$scan = xtc_db_input($_REQUEST['scanner']);
	if($scan[0] == 'R'){
		$id = (int)substr($scan,1,strlen($scan));
		$query = xtc_db_query(sprintf("SELECT * FROM shippings WHERE reclamations_id=%s",
			$id
		));
	}else{
		$id = (int)$scan;
		$query = xtc_db_query(sprintf("SELECT * FROM shippings WHERE orders_id=%s",
			$id
		));
	}
	if(!xtc_db_num_rows($query) or $id < 1){
		die(sprintf('<span class="errorText">%s</span>',
			sprintf(TEXT_SHIPPING_DAILY_OTC_ENTRY_NOT_EXISTS,$_REQUEST['scanner'])
		));
	}
	$record = xtc_db_fetch_array($query);
        
        if(defined('EASYLOG2_PARTICLE_UPLOAD') and EASYLOG2_PARTICLE_UPLOAD == 'True'){
            $versender = $record['versender'];
            if($versender == 'EASYLOG2'){
                $shipping_daily_otc = 1; // brauchen wir in der shipping_action_EASYLOG2.php
                $packages = array(
                    $record
                );
                include('shipping_action_EASYLOG2.php');
            }
        }
        
        
?>
<script type="text/javascript">
$().ready(function(){
	$('#scan_delivery').focus();
});

</script>
<?php
	if($scan[0] == 'R'){
		printf('<b>Reklamation:</b> %s<br />',$id);
	}else{
		printf('<b>Auftrag:</b> %s<br />',$id);
	}
	printf('<b>Empf&auml;nger:</b> %s<br />',$record['name1']);
	printf('<b>Versand nach:</b> %s / %s<br />',$record['city'],$record['country_name']);
	printf('<b>Versender:</b> %s<br />',$record['versender']);
	echo '<h3>Scan des Versandaufklebers</h3>';
	echo xtc_draw_form('scandelivery','shipping.php','action=daily_otc');
	echo xtc_draw_hidden_field('scanner',$_REQUEST['scanner']);
	echo xtc_draw_input_field('scan_delivery','','size="20" maxlength="32" id="scan_delivery" style="height:30px; width:250px;font-size:22px;"');
	echo '<input type="submit" style="height:30px; width:100px;font-size:20px; background-color:#FFF; border:1px solid #000;" value="Scan" />';
	echo '</form>';
	exit;
}

if(isset($_REQUEST['scanner_delivery']) and !empty($_REQUEST['scanner_delivery'])){
	$scanner_result = xtc_db_input($_REQUEST['scanner_delivery']);
	if($scanner_result[0] == 'R'){
		$query = xtc_db_query(sprintf(
			"SELECT id FROM shippings WHERE reclamations_id=%s",
			(int)substr($scanner_result,1,strlen($scanner_result))
		));
	}else{
		$query = xtc_db_query(sprintf(
			"SELECT id FROM shippings WHERE orders_id=%s",
			(int)$scanner_result
		));
	}
	if(xtc_db_num_rows($query)){
		if(!isset($_SESSION['scanner'][$mode][$scanner_result])){
			$_SESSION['scanner'][$mode][$scanner_result] = 0;
		}
		$_SESSION['scanner'][$mode][$scanner_result]++;
	}else{
		$errors[] = sprintf(TEXT_SHIPPING_DAILY_OTC_ENTRY_NOT_EXISTS,$scanner_result);
	}
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$smarty->assign(array(
	'MODE'=>$mode,
	'ADDITIONAL_HEADING_TITLE'=>TEXT_ORDERSCAN,
	'TEXT_REALLY_DELETE_ENTRY'=>TEXT_REALLY_DELETE_ENTRY,
	'URL_DELETE_ENTRY'=>xtc_href_link('shipping.php','action=daily_otc&mode='.$mode),
	'FORM_ACTION'=>xtc_href_link('shipping.php','action=daily_otc&delivery=1'),
	'HEADING_TITLE'=>sprintf(TEXT_DAILY_OTC_HEADING,date('d.m.Y')),
	'REALLY_RESET'=>TEXT_REALLY_RESET,
	'DELETE'=>IMAGE_RESET,
	'EXPORT'=>IMAGE_EXPORT,
	'URL_RESET'=>xtc_href_link('shipping.php','action=daily_otc&reset=1'),
	'URL_EXPORT'=>xtc_href_link('shipping.php','action=daily_otc&export=1')
));
if(isset($_SESSION['scanner']) and sizeOf($_SESSION['scanner'])){
	$smarty->assign('SCANS',$_SESSION['scanner']);
}
$smarty->display('shipping_daily_otc.html');
exit;