<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

require('includes/application_top.php');
require_once('includes/classes/class.yes_lister.php');    
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_get_rueckerstattung_html_for_pdf.inc.php');

require_once(DIR_FS_CATALOG.'inc/xtc_serials.inc.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_WS_CLASSES.'counter_history.php');
require_once(DIR_WS_CLASSES.'class.help.php');
require_once(DIR_WS_CLASSES . 'currencies.php');
require_once(DIR_WS_CLASSES . 'rueckerstattung.php');
require_once(DIR_WS_CLASSES . 'reclamation.php');
require_once(DIR_WS_CLASSES . 'order.php');
require_once(DIR_WS_CLASSES . 'class.ebaymail.php');
// yes accounting  
$admin_access = main::get_admin_access();
  
// yes accounting
if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['rueckerstattungen'] == '1')) {
}else{
	$messageStack->add_session(MSG_ERROR_MISSING_AUTH,'error');
	xtc_redirect(xtc_href_link('index.php',xtc_get_all_get_params(array('action'))));
}
 
// initiate template engine for mail
$smarty = new yesSmarty;

if ( isset($_GET['action']) and $_GET['action'] == 'edit' && ($_GET['rID']) ) {
    $rID = xtc_db_prepare_input($_GET['rID']);

    $rueckerstattungen_query = xtc_db_query("select rueckerstattungs_id from rueckerstattungen where rueckerstattungs_id = '" . xtc_db_input($rID) . "'");
    $rueckerstattungen_exists = true;
    if (!xtc_db_num_rows($rueckerstattungen_query)) {
      $rueckerstattungen_exists = false;
      $messageStack->add(sprintf('Diese R&uuml;ckerstattungen existiert nicht.', $rID), 'error');
    }
}


require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
if ( isset($_GET['action']) and $_GET['action'] == 'edit' && ($rueckerstattungen_exists) ) {
    $rueckerstattungen = new rueckerstattung($rID);
}
$action = (isset($_GET['action'])) ? $_GET['action'] : '';
switch ($action) {
    case 'pdf':
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $rueckerstattung = new rueckerstattung($rID);
        $template = sprintf('%s/templates/%s/admin/%s',
            DIR_FS_CATALOG,
            CURRENT_TEMPLATE,
            'pdf_rueckerstattung.html'
        );
        if(!is_file($template)){
            $messageStack->add_session('Template %s not available',basename($template),'error');
            xtc_redirect(xtc_href_link(basename(__FILE__)));
        }
        $content = xtc_get_rueckerstattung_html_for_pdf($rueckerstattung,$smarty, $template);
        $yes_pdf = new yes_pdf;
        $yes_pdf->set_html($content);
        $yes_pdf->output('RUECK_'.$rID.'.pdf');
        exit;
        break;
    case 'ajax_address_save':	    
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $rueckerstattung = new rueckerstattung($rID);
        foreach($_REQUEST as $k=>$v){
            if(mb_detect_encoding($v) == 'UTF-8'){
                $_REQUEST[$k] = yes_decode_string($v);
            }
        }
        $json_array = array();
        $update_sql_array = array(
            'kto_inhaber'=>$_REQUEST['kto_inhaber'],
            'kto_nummer'=>$_REQUEST['kto_nummer'],
            'kto_bank'=>$_REQUEST['kto_bank'],
            'kto_iban'=>$_REQUEST['kto_iban'],
            'kto_swift'=>$_REQUEST['kto_swift'],
            'kto_blz'=>$_REQUEST['kto_blz'],
            'kto_grund'=>$_REQUEST['kto_grund'],
            'betrag'=>(float)str_replace(',','.',$_REQUEST['betrag'])
        );
        xtc_db_perform('rueckerstattungen',$update_sql_array,'update',"rueckerstattungs_id='".$rID."'");

        $json = array();
	if($rueckerstattung->info['orders_id'] > 0){
		$order = new order($rueckerstattung->info['orders_id']);
		$ebay_id = $order->info['ebay_id'];
		$currency = $order->info['currency'];
	}else{
		$reclamation = new reclamation($rueckerstattung->info['reclamations_id']);
		$ebay_id = $reclamation->info['ebay_id'];
		$currency = $reclamation->info['currency'];
	}
        $address_str = array();
        foreach($update_sql_array as $k=>$v){
            if($k == 'betrag'){
                $v = number_format($v,2,',','.').' '.$currency;
            }
            $address_str[] = $k.': '.$v;
            $json[$k]=xtc_db_prepare_input(yes_encode_string($v));
        }
        $rueckerstattung->add_history($rueckerstattung->info['status'], false, sprintf(HISTORY_ADDRESS_CHANGE,implode(', ',$address_str)));
        header('Content-Type: text/html; charset='.CHARSET);
        die(json_encode(array(
          'UPDATE_ARRAY'=>$json
        )));
        break;
    case 'ajax_address_edit':
	$fields = array(
            'kto_inhaber',
            'kto_bank',
            'kto_blz',
            'kto_nummer',
            'kto_iban',
            'kto_swift',
            'kto_grund',
            'betrag'
	);
	
        $db_ini = yes_get_database_table_ini();
	$query = xtc_db_query(sprintf("SELECT %s FROM %s WHERE rueckerstattungs_id='%s'",
            implode(',',$fields),'rueckerstattungen',(int)xtc_db_input($_REQUEST['rID'])
	));
	$record = xtc_db_prepare_input(xtc_db_fetch_array($query));
        $inputs = [];
	foreach($record as $key=>$value){
            $const_key = strtoupper( substr($key,strlen($sql_prefix),strlen($key)) );
            $label = (defined($const_key))?constant($const_key):'';
		$size = 32;
		switch($key){
                        case 'betrag':
                            $field = xtc_draw_input_field($key,$value,'id="'.$key.'" size="'.$size.'"');
                            $label = KTO_BETRAG;
                            break;
			default:
                            $current_size = $size;
                            $max_length = $current_size;
                            if(yes_get_database_table_field_length($db_ini, 'rueckerstattungen', $key) > $size){
                                $current_size = yes_get_database_table_field_length($db_ini, 'rueckerstattungen', $key);
                                if($current_size > 64){
                                    $max_length = $current_size;
                                    $current_size = 64;
                                }
                            }
                            $field = xtc_draw_input_field($key,$value,'id="'.$key.'" size="'.$current_size.'" maxlength="'.$max_length.'"');
                            break;
		}
		$inputs[] = sprintf('<label for="%s"><b>%s:</b></label><br />%s<br />',$key,$label,$field);
	}
        $smarty->assign([
            'EDIT_BANKDATA'=>1,
            'FORM'=>xtc_draw_form('ajax_address_edit',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_address_save','POST','onsubmit="return false;" id="ajax_address_edit"'),
            'INPUTS'=>implode('<br />',$inputs),
            'IMAGE_SAVE'=>IMAGE_SAVE
        ]);
        $smarty->display('rueckerstattung_edit.html');
	exit;
        break;
    case 'save_changed_paydate':
	    $rID = (int)xtc_db_input($_REQUEST['rID']);
	    $date_payment = sprintf("%s-%s-%s 12:00:00",
		    xtc_db_input($_POST['new_paydate_y']),
		    xtc_db_input($_POST['new_paydate_m']),
		    xtc_db_input($_POST['new_paydate_d'])
	    );
	    $update_sql_array = array(
		    'date_payment'=>$date_payment
	    );
	    if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
		    $rueckerstattung = new rueckerstattung($rID);
		    $comments = sprintf(HISTORY_PAYMENT_CHANGED,$date_payment);
		    xtc_db_perform('rueckerstattungen',$update_sql_array,"update","rueckerstattungs_id='".$rID."'");
                    $rueckerstattung->add_history($rueckerstattung->info['status'], false, $comments);
		    $messageStack->add_session($comments,'success');
	    }
	    if(!isset($_REQUEST['from'])){
		xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=edit'));
	    }else{
		xtc_redirect($_REQUEST['from']);
	    }
	    break;
    case 'change_paydate':
	    $rID = (int)xtc_db_input($_REQUEST['rID']);
	    $rueckerstattung = new rueckerstattung($rID);
	    $lb_smarty = $smarty;
	    $lb_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
	    $lb_smarty->assign('CHANGE_FORM',xtc_draw_form('change_paydate',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=save_changed_paydate'));
	    $lb_smarty->assign('SAVED_PAYDATE',$rueckerstattung->info['date_payment']);
	    $lb_smarty->assign('TEXT_SAVED_PAYDATE',TEXT_SAVED_PAYDATE);
	    $lb_smarty->assign('TEXT_NEW_PAYDATE',TEXT_NEW_PAYDATE);
	    $year_array = array();
	    for($i=(date('Y')-5);$i<=(date('Y'));$i++){
		    $year_array[] = array('id'=>$i,'text'=>$i);
	    }
	    $lb_smarty->assign('INPUT_NEW_PAYDATE_Y',xtc_draw_pull_down_menu('new_paydate_y',$year_array,date('Y',strtotime($rueckerstattung->info['date_payment'])),'class="ui-button ui-corner-all ui-state-default"'));
	    $month_array = array();
	    for($i=1;$i<=12;$i++){
		    $month_array[] = array('id'=>$i,'text'=>$i);
	    }
	    $lb_smarty->assign('INPUT_NEW_PAYDATE_M',xtc_draw_pull_down_menu('new_paydate_m',$month_array,date('m',strtotime($rueckerstattung->info['date_payment'])),'class="ui-button ui-corner-all ui-state-default"'));
	    $day_array = array();
	    for($i=1;$i<=31;$i++){
		    $day_array[] = array('id'=>$i,'text'=>$i);
	    }
	    $lb_smarty->assign('INPUT_NEW_PAYDATE_D',xtc_draw_pull_down_menu('new_paydate_d',$day_array,date('d',strtotime($rueckerstattung->info['date_payment'])),'class="ui-button ui-corner-all ui-state-default"'));
	    $lb_smarty->assign('ORDERS_ID',$orders_id);
	    if(isset($_REQUEST['from'])){
		$lb_smarty->assign('INPUT_FROM',xtc_draw_hidden_field('from',$_REQUEST['from']));
	    }
	    $lb_content = $lb_smarty->fetch(DIR_FS_ADMIN.'templates/orders_change_paydate.html');
	    $smarty->assign(array(
		'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
		'PAGE_TITLE'=>BUTTON_CHANGE_PAYDATE,
		'LB_CONTENT'=>$lb_content,
	    ));
	    header('Content-Type: text/html; charset='.CHARSET);
	    echo $smarty->fetch(DIR_FS_ADMIN.'templates/lightbox_default.html');
	    exit;
	    break;
    case 'kasse_process':
	if(!isset($_REQUEST['rueckerstattungen_id']) or !ctype_digit($_REQUEST['rueckerstattungen_id'])){
	    header('Content-Type: text/html; charset='.CHARSET);
	    die(json_encode(array(
		'HTML'=>MSG_ERROR_KASSE_PROCESS_INVALID_ID
	    )));
	}
	$rID = (int)xtc_db_input($_REQUEST['rueckerstattungen_id']);
	$query = xtc_db_query(sprintf(
		"SELECT rueckerstattungs_id FROM rueckerstattungen WHERE rueckerstattungs_id='%s' AND status=1",
		$rID
	));
	if(!xtc_db_num_rows($query)){
	    header('Content-Type: text/html; charset='.CHARSET);
	    die(json_encode(array(
		'HTML'=>sprintf(MSG_ERROR_KASSE_PROCESS_ID_NOT_PROCESSABLE,$rID)
	    )));
	}
	xtc_redirect(xtc_href_link('rueckerstattungen.php?action=set&json_mode=1&rID='.$rID.'&rstatus=2&from=kasse'));
	exit;
	break;
    case 'kasse_confirm':
	header('Content-Type: text/html; charset='.CHARSET);
	$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
	$smarty->display('rueckerstattungen_kasse_confirm.tpl');
	exit;
	break;
    case 'set':
	$rID = (int)xtc_db_input($_GET['rID']);
	$rueckerstattungen = new rueckerstattung($rID);
	$cID = $rueckerstattungen->info['customers_id'];
	$email_query = xtc_db_query("SELECT customers_email_address FROM customers WHERE customers_id='".$cID."'");
	$res_email = xtc_db_fetch_array($email_query);
        $params = (isset($_REQUEST['json_mode'])) ? 'onsubmit="return set_rueck_json_check()"' : '';
	$html = xtc_draw_form('setr','rueckerstattungen.php','action=set_now&rstatus='.$_GET['rstatus'].'&rID='.$rID,'POST',$params);
        $html .= '<div class="main">';
	$cmmnts = '';
	if($_REQUEST['from'] == 'kasse' or $_REQUEST['from'] == 'rueckerstattung'){
	    $html .= sprintf(TEXT_RUECKERSTATTUNG_UPDATE_STATUS_KASSE,xtc_get_rueckerstattungen_status_name($_GET['rstatus']),  xtc_get_rueckerstattungen_types_name(3));
	    $cmmnts = TEXT_RUECKERSTATTUNG_UPDATE_FROM_KASSE_COMMENTS;
	    $html .= '<input type="hidden" name="from" value="'.$_REQUEST['from'].'" />';
	}else{
	    $html .= sprintf(TEXT_RUECKERSTATTUNG_UPDATE_STATUS,xtc_get_rueckerstattungen_status_name($_GET['rstatus']));
            $set_recla_html = '';
            if($rueckerstattungen->info['reclamations_id'] > 0){
                $recla = new reclamation($rueckerstattungen->info['reclamations_id']);
                switch($recla->info['reclamations_status']){
                    case 1:
                    case 2:
                        $set_recla_html = sprintf(
                                "<div class=\"formArea\" style=\"padding: 4px;\"><div style='display: inline-block; float: left;width:30px;'>%s</div><div style='display: inline-block; float: left;width:500px;'>%s</div><div style=\"clear: both;\"></div></div>",
                                xtc_draw_checkbox_field('set_reclamation_status_abgeschlossen', '1', false),
                                sprintf(TEXT_SET_RECLAMATION_STATUS_ABGESCHLOSSEN,
                                        $rueckerstattungen->info['reclamations_id'],
                                        xtc_get_reclamations_status_name($recla->info['reclamations_status'])
                                )
                        );
                        break;
                }
            }
	}
	if($_GET['rstatus'] == '2'){
	    $html .= '<p class="formArea" style="padding: 4px;"><i>'.TEXT_RUECKERSTATTUNG_UPDATE_STATUS_EMAIL_INTRO.'</i><br />';
	    $html .= xtc_draw_input_field('email',$res_email['customers_email_address'],'size="25"');
	    $html .= '<br />'.xtc_draw_checkbox_field('sendmail','1',true).IMAGE_SEND;
	    $html .= '</p>';
            if(defined('RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID') and RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID > 0){
                $html .= '<p class="formArea" style="padding: 4px;"><i>'.TEXT_RUECKERSTATTUNG_CREATE_MINUS_ORDER.'</i><br />';
                $html .= xtc_draw_checkbox_field('create_negative_order','1',true).YES.' (pID '.RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID.')';
            }
	}
	
        $html .= $set_recla_html;
	$html .= '<p>'.TEXT_RUECKERSTATTUNG_COMMENT.'</p>';
	$html .= xtc_draw_textarea_field('kommentar','virtual',40,6,$cmmnts).'<br />';
        //$html .= xtc_draw_checkbox_field('print','1',true).' '.TEXT_PRINT.'<br />';
	$html .= yes_draw_href_button(BUTTON_UPDATE_RUECKERSTATTUNG_STATUS,'','style="width:200px;" id="json_close_submit"','submit');
	$html .= '</div></form>';
	if(strtolower(CHARSET) == 'utf-8'){
		header('Content-Type: text/html; charset='.CHARSET);
	}else{
		$html = utf8_encode($html);
		header('Content-Type: text/html; charset=UTF-8');
	}
	if(!isset($_REQUEST['json_mode'])){
	    echo $html;
	}else{
	    die(json_encode(array(
		'HTML'=>$html
	    )));
	}
	
	exit;
	break;
    case 'change_type':
        $rID = (int)xtc_db_input($_REQUEST['id']);
        $json_mode = (isset($_GET['json_mode']));
	if($rID < 1){
            if($json_mode){
                die(json_encode([
                    'MSG'=>'Missing Parameter ID',
                    'item'=>$item_data
                ]));
            }
            die('Missing Parameter ID');
	}
        $rueck = new rueckerstattung($rID);
        $type_id = (int)xtc_db_input($_REQUEST['type']);
        $update_sql_array = array(
                'type'=>$type_id,
                'paymode'=>xtc_get_rueckerstattungen_types_name($type_id)
        );
        xtc_db_perform('rueckerstattungen',$update_sql_array,'update','rueckerstattungs_id='.$rID);
        $new_name = xtc_get_rueckerstattungen_types_name($type_id);
        $rueck->add_history($rueck->info['status'], false, sprintf(MSG_SUCCESS_CHANGE_TYPE,  $new_name));
        $item_data = [
            'rueckerstatten_id' => $rID,
            'type_name' => $new_name,
            'type'=>$type_id
        ];
        if($json_mode){
            die(json_encode([
                'MSG'=>'',
                'item'=>$item_data
            ]));
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_CHANGE_TYPE,  xtc_get_rueckerstattungen_types_name($type_id)),'success');
        xtc_redirect(xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rID));
        break;
        
    case 'change_type_confirm':
		$rID = (int)xtc_db_input($_REQUEST['id']);
		if($rID < 1){
		  die('Missing Parameter ID');
		}
		$rueck = new rueckerstattung($rID);
		$type_name = xtc_get_rueckerstattungen_types_name($rueck->info['type']);
                $json_mode_params = (isset($_GET['json_mode'])) ? '&json_mode=1' : '';
		echo '<div class="main">';
		echo xtc_draw_form('change_type','rueckerstattungen.php','action=change_type&id='.$_REQUEST['id'].$json_mode_params);
		printf('<b>%s:</b> %s<br />',CURRENT_RUECKERSTATTUNG_TYPE, $type_name);
		$types = xtc_get_rueckerstattungen_types();
		printf('<b>%s:</b> %s<br />',NEW_RUECKERSTATTUNG_TYPE, xtc_draw_pull_down_menu('type', $types, $rueck->info['type']));
                if(isset($_GET['json_mode'])){
                    echo '<input type="button" onclick="updateTypeHandler(this)" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
                }else{
                    echo '<input type="submit" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" />';
                }
		echo '</form>';
		echo '</div>';
		exit;
		break;
  	case 'save':
		$current_msg_size = $messageStack->size;
		if(!isset($_POST['rueckerstatten']) or $_POST['rueckerstatten'] == ''){
			$messageStack->add(MSG_ERROR_SELECT_RUECKERSTATTUNG_TYPE,'error');
		}
		$betrag = (isset($_POST['kto_betrag'])) ? (float)str_replace(',','.',xtc_db_input($_POST['kto_betrag'])) : 0;
		if( $betrag <= 0 ){
			$messageStack->add(MSG_ERROR_RUECKERSTATTUNG_AMOUNT,'error');
		}
		if( strlen(trim($_POST['grund'])) < 3 ){
			$messageStack->add(MSG_ERROR_RUECKERSTATTUNG_GRUND,'error');
		}
		if( !$_GET['oID'] or $_GET['oID'] == '' ){
			$messageStack->add(MSG_ERROR_RUECKERSTATTUNG_NO_ORDER,'error');
		}
		if($messageStack->size > $current_msg_size){
			$_GET['action'] = 'add';
			$action = 'add';
		}else{
			$oID = (int)xtc_db_input($_GET['oID']);
			$order = new order($oID);
			$order_status = $order->info['orders_status'];
			
			// RUECKERSTATTEN EINTRAG ERZEUGEN
			$max = 0;
			foreach($order->totals as $ot){
			    switch($ot['class']){
				case 'ot_total':
				    $max = number_format($ot['value'],2,'.','');
				    break;
			    }
			}
			if($_POST['rueckerstatten'] == '2' or $_POST['rueckerstatten'] > 3) { // bank
			    if($max < $betrag){
				$messageStack->add(sprintf(MSG_ERROR_RUECKERSTATTUNG_MAX_AMOUNT,number_format($max,2,',','.')),'error');
                                xtc_redirect(xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$_GET['oID']));
			    }else{
				$sql_array = array(
                                    'orders_id'=>$oID,
                                    'customers_id'=>$order->customer['ID'],
                                    'betrag'=>$betrag,
                                    'paymode'=>xtc_get_rueckerstattungen_types_name($_POST['rueckerstatten']),
                                    'date_created'=>"now()",
                                    'date_payment'=>'0',
                                    'kto_nummer'=>$_POST['kto_nummer'],
                                    'kto_blz'=>$_POST['kto_blz'],
                                    'kto_inhaber'=>$_POST['kto_inhaber'],
                                    'kto_bank'=>$_POST['kto_bank'],
                                    'kto_iban'=>$_POST['kto_iban'],
                                    'kto_swift'=>$_POST['kto_swift'],
                                    'kto_grund'=>$_POST['grund'],
                                    'comments'=>TEXT_CREATE_COMMENT,
                                    'editor_id'=>$_SESSION['customer_id'],
                                    'type'=>$_POST['rueckerstatten'],
                                    'status'=>'1'
                                );
                                xtc_db_perform('rueckerstattungen',$sql_array);
				$rueck_id = xtc_db_insert_id();
				$comment = sprintf(TEXT_CREATE_COMMENT_RUECKERSTATTUNG_HISTORY,$oID);
                                $rueckerstattung = new rueckerstattung($rueck_id);
                                $rueckerstattung->add_history(1, false, $comment);

				$comment = sprintf(TEXT_CREATE_COMMENT_ORDER_HISTORY,$rueck_id,$_POST['kto_grund']);
                                $order->add_history(intval($order_status),false,$comment);
			    }
			}else if($_POST['rueckerstatten'] == '3'){ // bar
			    if($max < $betrag){
				$messageStack->add(sprintf(MSG_ERROR_RUECKERSTATTUNG_MAX_AMOUNT,number_format($max,2,',','.')),'error');
				$_GET['action'] = 'add';
				$action = 'add';
			    }else{
				$sql_array = array('orders_id'=>$oID,
					'customers_id'=>$order->customer['ID'],
					'betrag'=>$betrag,
					'paymode'=>'Bar',
					'kto_inhaber'=>$_POST['kto_inhaber'],
					'date_created'=>"now()",
					'date_payment'=>"now()",
					'comments'=>TEXT_CREATE_COMMENT_BAR,
					'kto_grund'=>$_POST['grund'],
					'editor_id'=>$_SESSION['customer_id'],
					'type'=>$_POST['rueckerstatten'],
					'status'=>'2'
                                );
				xtc_db_perform('rueckerstattungen',$sql_array);
				$rueck_id = xtc_db_insert_id();
				$comment = sprintf(TEXT_CREATE_COMMENT_BAR_HISTORY_RUECKERSTATTUNG,$oID);
                                $rueckerstattung = new rueckerstattung($rueck_id);
                                $rueckerstattung->add_history(2, false, $comment);
				$comment = sprintf(TEXT_CREATE_COMMENT_BAR_HISTORY_ORDER,$rueck_id,$_POST['kto_grund']);
                                $order->add_history($order_status, false, $comment);
                                
                                /**
                                 *  DAS MUSS ALS KASSENEINTRAG GESPEICHERT WERDEN
                                 *  2018-03-15
                                 */
                                $branches_id = (isset($_SESSION['allocated_branches_id'])) ? $_SESSION['allocated_branches_id'] : 0;
                                $CH = new counter_history($branches_id);
                                $CH->insert_entry(
                                    $rueckerstattung,
                                    $smarty,
                                    array(
                                        'rueckerstattungen_id'=>$rueck_id,
                                        'paymode'=>'bar1',
                                        'customers_id'=>$order->customer['ID'],
                                        'date_purchased'=>'now()',
                                        'total'=>-$betrag,
                                        'branches_id'=>$branches_id,
                                ));
                                // EOF KASSENEINTRAG
                                
			    }
			} // END CREATE RUECKERSTATTUNG
			
			// BANKDATEN SPEICHERN
			if($messageStack->size === $current_msg_size){
			    if( $_POST['save_kto'] == '1' ){
                                $sql_array = array(
                                        'kto_nummer'=>$_POST['kto_nummer'],
                                        'kto_inhaber'=>$_POST['kto_inhaber'],
                                        'kto_blz'=>$_POST['kto_blz'],
                                        'kto_iban'=>$_POST['kto_iban'],
                                        'kto_swift'=>$_POST['kto_swift'],
                                        'kto_bank'=>$_POST['kto_bank']);
                                xtc_db_perform('customers',$sql_array,'update','customers_id='.$order->customer['ID']);

                                $new = new \YES4Trade\Model\customers_memo([
                                    'customers_id'=>(int)$order->customer['ID'],
                                    'memo_date'=>date('Y-m-d H:i:s'),
                                    'memo_title'=>TEXT_COMMENT_CUSTOMERS_MEMO,
                                    'memo_text'=>sprintf(TEXT_COMMENT_CUSTOMERS_MEMO_DETAILS,$rueck_id),
                                    'poster_id'=>(int)$_SESSION['customer_id']
                                ]);
                                $new->create();
			    }
			    $messageStack->add_session(MSG_SUCCESS_RUECKERSTATTUNG_CREATED,'success');
			    xtc_redirect( xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rueck_id) );
			    exit;
			}
		}
		break;
	case 'set_now':
		$rID = xtc_db_prepare_input($_GET['rID']);
		$rueckerstattungen = new rueckerstattung($rID);
		$status = xtc_db_prepare_input($_GET['rstatus']);
		$comment = (isset($_POST['kommentar']) and $_POST['kommentar']!='') ? xtc_db_input($_POST['kommentar']) : ' kein Kommentar hinterlegt';
		$sendmail = false;
		$email = xtc_db_prepare_input($_POST['email']);
                $set_reclamation_status_abgeschlossen = (isset($_POST['set_reclamation_status_abgeschlossen']) and $_POST['set_reclamation_status_abgeschlossen'] == 1) ? true : false;
		if( xtc_not_null($rID) && $rID > 0 && xtc_not_null($status) && $status > 0) {
			if($status == '2'){ // bezahlt
				if($_POST['sendmail'] == '1' and xtc_validate_email($email) != true ){
					$messageStack->add_session(MSG_ERROR_INVALID_EMAIL,'error');
					xtc_redirect(xtc_href_link('rueckerstattungen.php',xtc_get_all_get_params(array('action')).'action=set'));
				}
				if(isset($_REQUEST['from']) and ($_REQUEST['from'] == 'kasse' or $_REQUEST['from'] == 'rueckerstattung')){
                                    $json_messages = array();
				    xtc_db_query("UPDATE rueckerstattungen SET status='".$status."',type='3', date_payment=now() WHERE rueckerstattungs_id='".$rID."'");
				}else{
				    xtc_db_query("UPDATE rueckerstattungen SET status='".$status."',date_payment=now() WHERE rueckerstattungs_id='".$rID."'");
				}
                                $cmm = sprintf(TEXT_RUECKERSTATTUNG_SET_NOW,
                                        xtc_get_rueckerstattungen_status_name($status),
                                        $comment
                                );
                                $rueckerstattungen->add_history($status, false, $cmm);
                                
                                /**
                                 *  DAS MUSS ALS KASSENEINTRAG GESPEICHERT WERDEN
                                 *  2018-03-15
                                 */
                                if(strtolower($rueckerstattungen->info['paymode']) == 'bar'){
                                    $branches_id = (isset($_SESSION['allocated_branches_id'])) ? $_SESSION['allocated_branches_id'] : 0;
                                    $CH = new counter_history($branches_id);
                                    $CH->insert_entry(
                                        $rueckerstattungen,
                                        $smarty,
                                        array(
                                            'rueckerstattungen_id'=>$rID,
                                            'paymode'=>'bar1',
                                            'customers_id'=>$rueckerstattungen->info['customers_id'],
                                            'date_purchased'=>'now()',
                                            'total'=>-$rueckerstattungen->info['betrag'],
                                            'branches_id'=>$branches_id,
                                    ));
                                }
                                // EOF KASSENEINTRAG
                                
				if($rueckerstattungen->info['reclamations_id'] > 0){
                                    $recl_status_query = xtc_db_query("SELECT reclamations_status FROM reclamations WHERE reclamations_id='".$rueckerstattungen->info['reclamations_id']."'");
                                    $recl_status_res = xtc_db_fetch_array($recl_status_query);
                                    $recl_status = $recl_status_res['reclamations_status'];
                                    $recl_history_string = sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_PAYMENT_CONFIRMED,
                                            $rID,$comment
                                    );
                                    $new = new \YES4Trade\Model\reclamations_status_history([
                                        'reclamations_id'=>(int)$rueckerstattungen->info['reclamations_id'], 
                                        'reclamations_status_id'=>(int)$recl_status, 
                                        'date_added'=>date('Y-m-d H:i:s'),
                                        'customer_notified'=>(int)$_POST['sendmail'],
                                        'comments'=>$recl_history_string,
                                        'editor_id'=>(int)$_SESSION['customer_id']
                                    ]);
                                    $new->create();

                                    $orderadd = sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_PAYMENT_CONFIRMED_ORDERADD,
                                            $rueckerstattungen->info['reclamations_id']
                                    );
				}else{
					$orderadd = '';
				}
				$order_status_query = xtc_db_query("SELECT orders_status,payment_method,currency FROM orders WHERE orders_id='".$rueckerstattungen->info['orders_id']."'");
				$order_status_res = xtc_db_fetch_array($order_status_query);
				$order_status = $order_status_res['orders_status'];
                                $currency = $order_status_res['currency'];
                                $order_history_str = sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_PAYMENT_CONFIRMED,
                                        $rID.$orderadd,$comment
                                );
                                order::add_history_static(intval($rueckerstattungen->info['orders_id']), 
                                    intval($order_status), $_POST['sendmail']??false, 
                                    $order_history_str
                                );
                                if(isset($_POST['create_negative_order']) and $_POST['create_negative_order'] == 1){
                                    if(defined('RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID') and RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID > 0){
                                        require_once(DIR_WS_CLASSES.'product.php');
                                        require_once(DIR_WS_CLASSES.'customer.php');
                                        $product = new product(RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID);
                                        $customer = new customer($rueckerstattungen->info['customers_id']);
                                        $orders_id = $customer->add_order(ORDERS_STATUS_ABGESCHLOSSEN);
                                        $order = new order($orders_id);
                                        $country_id = $order->delivery['country_id'];
                                        $zone_id = $order->delivery['zone_id'];
                                        
                                        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                                        /*if(!yes_eu_oss_use_country_handling($country_id)){
                                            $country_id = STORE_COUNTRY;
                                            $zone_id = 0;
                                        }*/
                                        // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
                                        $cust_status = main::get_customers_status($order->info['status'], $_SESSION['languages_id']);
                                        $insert_sql_array = array(
                                            'orders_id'=>$orders_id,
                                            'products_id'=>RUECKERSTATTUNG_NEGATIVE_ORDER_PRODUCTS_ID,
                                            'products_model'=>$product->info['products_model'],
                                            'products_name'=>'Rueckerst. '.$rID.' - '.$product->info['products_name'],
                                            'products_price'=>-$rueckerstattungen->info['betrag'],
                                            'final_price'=>-$rueckerstattungen->info['betrag'],
                                            'products_tax'=> xtc_get_tax_rate($product->info['products_tax_class_id'],$country_id, $zone_id),
                                            'products_quantity'=>1,
                                            'allow_tax'=>$cust_status['customers_status_show_price_tax'],
                                            'date_added'=>'now()'
                                        );
                                        xtc_db_perform(TABLE_ORDERS_PRODUCTS,$insert_sql_array);
                                        
                                        $update_sql_array = array(
                                            'value'=>-$rueckerstattungen->info['betrag'],
                                            'text'=>number_format(-$rueckerstattungen->info['betrag'],2,',','.').' '.$order->info['currency']
                                        );
                                        xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,'update',"orders_id='".$orders_id."' AND class IN ('ot_total','ot_subtotal')");
                                        $order = new order($orders_id);
                                        $order->recalc();
                                        $order->add_history(ORDERS_STATUS_ABGESCHLOSSEN, 
                                            $_POST['sendmail']??false, 
                                            sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_NEGATIVE_ORDER_GENERATED,
                                                $rID
                                            )
                                        );
                                        order::add_history_static(intval($rueckerstattungen->info['orders_id']),
                                            intval($order_status), 
                                            $_POST['sendmail']??false, 
                                            sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_NEGATIVE_ORDER_GENERATED_SOURCE_ORDER_HISTORY,
                                                $orders_id,$rID
                                            )
                                        );
                                        $msg_negativ = sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_NEGATIVE_ORDER_ID_GENERATED,
                                            $orders_id
                                        );
                                        $rueckerstattungen->add_history($status, false, $msg_negativ);
                                        $messageStack->add_session($msg_negativ,'success');
                                    }
                                }
                                
                                $status_comm = sprintf(MSG_SUCCESS_SET_NOW_STATUS_2,$rID);
				if(isset($_REQUEST['from']) and $_REQUEST['from'] == 'kasse'){
                                    $json_messages[] = $status_comm;
                                }else{
                                    $messageStack->add_session($status_comm,'success');
                                }
				
				if($_POST['sendmail'] == '1'){
				
					$cID = $rueckerstattungen->info['customers_id'];
					$oID = $rueckerstattungen->info['orders_id'];
					$order = new order($oID);
					$email_address = $email;
						
					$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
					foreach($order->products as $k=>$prod){
						$rueckerstattung_data[]=array(
								'PRODUCTS_MODEL' => $prod['model'],
								'PRODUCTS_NAME' => $prod['name'],
								'PRODUCTS_QTY' => $prod['qty']);
					}
						
					if($rueckerstattungen->info['reclamations_id']>0){
						$reclamation = new reclamation($rueckerstattungen->info['reclamations_id']);
						$smarty->assign('address_label_customer',xtc_address_format($reclamation->customer['format_id'], $reclamation->customer, 1, '', '<br>'));
						foreach($reclamation->products as $k=>$prod){
							$rueckerstattung_data[]=array(
									'PRODUCTS_MODEL' => $prod['model'],
									'PRODUCTS_NAME' => $prod['name'],
									'PRODUCTS_QTY' => $prod['qty']);
						}
					}
						
					$smarty->assign('STATUS',xtc_get_rueckerstattungen_status_name($rueckerstattungen->info['status']));
					$smarty->assign('TYPE',xtc_get_rueckerstattungen_types_name($rueckerstattungen->info['type']));
					$smarty->assign('BANK',$rueckerstattungen->bank['kto_bank']);
					$smarty->assign('BLZ',$rueckerstattungen->bank['kto_blz']);
					$smarty->assign('KONTO',$rueckerstattungen->bank['kto_nummer']);
					$smarty->assign('INHABER',$rueckerstattungen->bank['kto_inhaber']);
					$smarty->assign('IBAN',$rueckerstattungen->bank['kto_iban']);
					$smarty->assign('SWIFT',$rueckerstattungen->bank['kto_swift']);
					$smarty->assign('BETRAG',number_format($rueckerstattungen->info['betrag'],2,',','').' '.$order->info['currency']);
					$smarty->assign('GRUND',$rueckerstattungen->bank['kto_grund']);
					$smarty->assign('PAYMODE',$rueckerstattungen->info['paymode']);
					
					// assign language to template for caching
					$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
					if($rueckerstattungen->info['date_payment']>0)
						$smarty->assign('DATE_FINISHED', xtc_date_long($rueckerstattungen->info['date_payment']));
							
					$smarty->assign('language', $_SESSION['language']);
					$smarty->assign('logo_path',HTTP_SERVER.'yes/templates/'.CURRENT_TEMPLATE.'/img/');
							
					$smarty->assign('oID',$rueckerstattungen->info['orders_id'].$o_ebayid);
					$smarty->assign('rID',$_GET['rID']);
					$smarty->assign('recID',$rueckerstattungen->info['reclamations_id']);
						
					$smarty->assign('DATE',xtc_date_long($rueckerstattungen->info['date_created']));
					$smarty->assign(array(
					    'rueckerstattung_data'=>$rueckerstattung_data,
					    'cID'=>$cID
					));
						
							
					$html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_rueckerstattung.html');
					$txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_rueckerstattung.txt');
						
					// **** EMAILCLIENT - ADDON *****
					$dbMail = new DBmail('0');
					$subject = RUECKERSTATTUNG_EMAIL_SUBJECT.': Auftrag '.$order->info['id'];
					$dbMail->save_mail($subject,$email_address,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$html_mail,date('Y-m-d H:i:s'), $order->info['ebay_id'],$cID,$oID);
					$rueckerstattungen->add_history($status, true, sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_EMAIL_SENT,$email_address));
					
//					$subject = 'R�ckerstattung: Rechnung Nr. '.$order->info['id'].(($order->info['ebay_id']!='') ? ' ('.$order->info['ebay_id'].')':'');
					xtc_php_mail(EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $email_address, $email_address, '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $path_to_attachement='', $path_to_more_attachements='', $subject, $html_mail,$txt_mail);
					$messageStack->add_session(MSG_SUCCESS_RUECKERSTATTUNG_SET_NOW_EMAIL_SENT,'success');
				}
                                if($set_reclamation_status_abgeschlossen){
                                    if($rueckerstattungen->info['reclamations_id'] > 0){
                                        $recla = new reclamation($rueckerstattungen->info['reclamations_id']);
                                        switch($recla->info['reclamations_status']){
                                            case 1:
                                            case 2:
                                                $update_sql_array = array(
                                                    'reclamations_status'=>3,
                                                    'last_modified'=>'now()'
                                                );
                                                xtc_db_perform('reclamations',$update_sql_array,'update',"reclamations_id='".$rueckerstattungen->info['reclamations_id']."'");
                                                $recla->add_history(3,false, sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_RECLAMATION_ABGESCHLOSSEN,
                                                    $rID
                                                ));
                                                $rueckerstattungen->add_history($status, false, sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_RECLAMATIONS_ID_ABGESCHLOSSEN,
                                                        $rueckerstattungen->info['reclamations_id']
                                                ));
                                                if($rueckerstattungen->info['orders_id']>0){
                                                    $order = new order($rueckerstattungen->info['orders_id']);
                                                    $order->add_history($order->info['orders_status'], false, sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_RECLAMATIONS_ID_AND_ORDERS_ID_ABGESCHLOSSEN,
                                                            $recla->info['reclamations_status'],
                                                            $rID
                                                    ));
                                                }
                                                break;
                                        }
                                    }
                                }
				if(isset($_REQUEST['from']) and $_REQUEST['from'] == 'kasse'){
                                    die(json_encode(array(
                                        'MESSAGE'=>implode('<br />',$json_messages)
                                    )));
				}else{
				    xtc_redirect(xtc_href_link('rueckerstattungen.php',xtc_get_all_get_params(array('action')).'action=edit&rID='.$rID));
				}
			} else if($status == '3'){ // abgelehnt
				xtc_db_query("UPDATE rueckerstattungen SET status='".$status."',date_payment=now() WHERE rueckerstattungs_id='".$rID."'");
                                $rueckerstattungen->add_history($status, false, "Auf neuen Status ".xtc_get_rueckerstattungen_status_name($status)." gesetzt. Kommentar: ".$comment);
				if($rueckerstattungen->info['reclamations_id'] > 0){
					$recl_status_query = xtc_db_query("SELECT reclamations_status FROM reclamations WHERE reclamations_id='".$rueckerstattungen->info['reclamations_id']."'");
					$recl_status_res = xtc_db_fetch_array($recl_status_query);
					$recl_status = $recl_status_res['reclamations_status'];
                                        $new = new \YES4Trade\Model\reclamations_status_history([
                                            'reclamations_id'=>(int)$rueckerstattungen->info['reclamations_id'], 
                                            'reclamations_status_id'=>(int)$recl_status, 
                                            'date_added'=>date('Y-m-d H:i:s'),
                                            'customer_notified'=>0,
                                            'comments'=>sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_CANCELLED,$rID,$comment),
                                            'editor_id'=>(int)$_SESSION['customer_id']
                                        ]);
                                        $new->create();
					$orderadd = sprintf(TEXT_RUECKERSTATTUNG_SET_NOW_PAYMENT_CONFIRMED_ORDERADD,
                                                $rueckerstattungen->info['reclamations_id']
                                        );
				}else{
					$orderadd = '';
				}
				$order_status_query = xtc_db_query("SELECT orders_status FROM orders WHERE orders_id='".$rueckerstattungen->info['orders_id']."'");
				$order_status_res = xtc_db_fetch_array($order_status_query);
				$order_status = $order_status_res['orders_status'];
                                order::add_history_static(intval($rueckerstattungen->info['orders_id']), 
                                    intval($order_status), false, sprintf(
                                        TEXT_RUECKERSTATTUNG_SET_NOW_CANCELLED,
                                        $rID.$orderadd,$comment
                                    )
                                );
				$messageStack->add_session(sprintf(MSG_SUCCESS_RUECKERSTATTUNG_SET_NOW_STATUS_CHANGED,$rID),'success');
				xtc_redirect(xtc_href_link('rueckerstattungen.php',xtc_get_all_get_params(array('action')).'action=edit&rID='.$rID));
			}
		}
		break;
	case 'email':
    		$rID = xtc_db_prepare_input($_GET['rID']);
		$rueckerstattung = new rueckerstattung($rID);
		$cID = $rueckerstattung->info['customers_id'];
		$oID = $rueckerstattung->info['orders_id'];
		$order = new order($oID);
		$email_address = $order->customer['email_address'];
		
		$smarty->assign('address_label_customer',xtc_address_format($order->customer['format_id'], $order->customer, 1, '', '<br>'));
		foreach($order->products as $k=>$prod){
			$rueckerstattung_data[]=array(
					'PRODUCTS_MODEL' => $prod['model'],
					'PRODUCTS_NAME' => $prod['name'],
					'PRODUCTS_QTY' => $prod['qty']);
		}
		
		if($rueckerstattung->info['reclamations_id']>0){
			$reclamation = new reclamation($rueckerstattung->info['reclamations_id']);
			$smarty->assign('address_label_customer',xtc_address_format($reclamation->customer['format_id'], $reclamation->customer, 1, '', '<br>'));
			foreach($reclamation->products as $k=>$prod){
				$rueckerstattung_data[]=array(
						'PRODUCTS_MODEL' => $prod['model'],
						'PRODUCTS_NAME' => $prod['name'],
						'PRODUCTS_QTY' => $prod['qty']);
			}
		}
		
		
		$smarty->assign('STATUS',xtc_get_rueckerstattungen_status_name($rueckerstattung->info['status']));
		$smarty->assign('TYPE',xtc_get_rueckerstattungen_types_name($rueckerstattung->info['type']));
		$smarty->assign('BANK',$rueckerstattung->info['kto_bank']);
		$smarty->assign('BLZ',$rueckerstattung->bank['kto_blz']);
		$smarty->assign('KONTO',$rueckerstattung->bank['kto_nummer']);
		$smarty->assign('INHABER',$rueckerstattung->bank['kto_inhaber']);
		$smarty->assign('IBAN',$rueckerstattung->bank['kto_iban']);
		$smarty->assign('SWIFT',$rueckerstattung->bank['kto_swift']);
		$smarty->assign('BETRAG',number_format($rueckerstattung->info['betrag'],2,',','').' '.$order->info['currency']);
		$smarty->assign('GRUND',$rueckerstattung->bank['kto_grund']);
		$smarty->assign('PAYMODE',$rueckerstattung->info['paymode']);
		
		// assign language to template for caching
		$smarty->assign('STORE', nl2br(STORE_NAME_ADDRESS));
		if($rueckerstattung->info['date_payment']>0)
			$smarty->assign('DATE_FINISHED', xtc_date_long($rueckerstattung->info['date_payment']));
			
		$smarty->assign('language', $_SESSION['language']);
		$smarty->assign('logo_path',HTTP_SERVER.'yes/templates/'.CURRENT_TEMPLATE.'/img/');
			
		$smarty->assign('oID',$rueckerstattung->info['orders_id'].$o_ebayid);
		$smarty->assign('rID',$_GET['rID']);
		$smarty->assign('recID',$rueckerstattung->info['reclamations_id']);
		
		$smarty->assign('DATE',xtc_date_long($rueckerstattung->info['date_created']));
		$smarty->assign(array(
		    'rueckerstattung_data'=>$rueckerstattung_data,
		    'cID'=>$cID
		));
		
		$html_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_rueckerstattung.html');
		$txt_mail=$smarty->fetch(CURRENT_TEMPLATE . '/admin/mail/german/send_rueckerstattung.txt');
		
		// **** EMAILCLIENT - ADDON *****
		$dbMail = new DBmail('0');
		$subject = sprintf(SUBJECT_RUECKERSTATTUNG,$order->info['id']);
		$dbMail->save_mail($subject,$email_address,EMAIL_BILLING_REPLY_ADDRESS_NAME,EMAIL_BILLING_REPLY_ADDRESS,$html_mail,date('Y-m-d H:i:s'), $order->info['ebay_id'],$cID,$oID);
		$rueckerstattung->add_history($rueckerstattung->info['status'], true, "Rueckerstattung per Email an ".$email_address." versendet");
		
		//$subject = 'R�ckerstattung: Rechnung Nr. '.$order->info['id'].(($order->info['ebay_id']!='') ? ' ('.$order->info['ebay_id'].')':'');
		xtc_php_mail(EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $email_address, $email_address, '', EMAIL_BILLING_REPLY_ADDRESS, EMAIL_BILLING_REPLY_ADDRESS_NAME, $path_to_attachement='', $path_to_more_attachements='', $subject, $html_mail,$txt_mail);
		$messageStack->add_session(MSG_SUCCESS_EMAIL_SENT,'success');
		xtc_redirect(xtc_href_link('rueckerstattungen.php','rID='.$rID.'&action=edit'));
		break;
}
if(!isset($_GET['action']) or $_GET['action'] != 'add'){
    yes_draw_pre_header();
    yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript"><!--
// PROTOTYPE ONLOAD FUNCTION INIT
var ONLOADPAGE = 'rueckerstattungen';
<?php 
if(!isset($_GET['action'])){?> 
var ONLOADFUNC = "ajax_onload";
var ONLOADFUNCPARAM = 'change_rueckerstattungen'; // FORMNAME AJAXLISTING
<?php }else if($_GET['action'] == 'edit'){?>
// NOT ACTIVE
//var ONLOADFUNC = "ajax_onload_tab";
//var ONLOADFUNCPARAM = "info";
<?php } ?>
//-->
</script>
<!-- header //-->
<?php
  yes_draw_quicknote();
?>
<script type="text/javascript">
<!--
$(document).ready(function(){
	/*
	$('#subm').click(function(){
		$.ajax({
			  type: 'POST',
			  url:  'notiz.php?action=quicknoteadd',
			  data: $('#quicknoteform').serialize(),
			  success: function(response) {
				if(!response.match(/error/))
					toggleBox('addquicknote');
				$('#myspan').html(response);
				toggleBox('myspan');
			  }
		});
	});
	*/
});
//-->
</script>
<table border="0" width="100%" cellspacing="0" cellpadding="2">
	
	
<?php
}
/* * * * * * * * * * * * * * * * * * * * * * * * * * *
rueckerstattungen EDIT
* * * * * * * * * * * * * * * * * * * * * * * * * * */
if ( $action == 'edit' && ($rueckerstattungen_exists) ) {
	$rueckerstattungen = new rueckerstattung(xtc_db_input($_GET['rID']));
	if($rueckerstattungen->info['orders_id'] > 0){
		$order = new order($rueckerstattungen->info['orders_id']);
		$ebay_id = $order->info['ebay_id'];
		$currency = $order->info['currency'];
	}else{
		$reclamation = new reclamation($rueckerstattungen->info['reclamations_id']);
		$ebay_id = $reclamation->info['ebay_id'];
		$currency = $reclamation->info['currency'];
	}
	$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
	$rueckerstattungen->info['betrag_formatted'] = number_format($rueckerstattungen->info['betrag'],2,',','.');
	$smarty->assign('rueckerstattung',array('info'=>xtc_db_prepare_input($rueckerstattungen->info),'bank'=>xtc_db_prepare_input($rueckerstattungen->bank)));

	$buttons = array(
	    array('text'=>IMAGE_BACK,
		'link'=>xtc_href_link('rueckerstattungen.php', xtc_get_all_get_params(array('action'))),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>IMAGE_CRM,
		'link'=>xtc_href_link(FILENAME_CUSTOMERS, 'cID=' . $rueckerstattungen->info['customers_id'].'&action=crm'),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>ADD_QUICKNOTE,
		'link'=>'javascript:toggleBox(\'addquicknote\');',
		'lbOn'=>false,
		'auth'=>true
	    )
	);
        if($rueckerstattungen->info['status'] == 1){
            $buttons[] = array('text'=>TEXT_PAYOUT_LINK,
		'link'=>'rueckerstattungen.php?action=set&from=rueckerstattung&rID='.$rueckerstattungen->info['id'].'&rstatus=2',
		'lbOn'=>true,
		'auth'=>true
	    );
        }
	$smarty->assign(array(
	    'HEADING_TITLE'=>sprintf(HEADING_TITLE,$rueckerstattungen->info['id'],xtc_date_short($rueckerstattungen->info['date_created'])),
	    'ADDITIONAL_HEADING_TITLE'=>TABLE_HEADING_ORDERS_ID.': '.$rueckerstattungen->info['orders_id'].(($rueckerstattungen->info['reclamations_id'] > 0)?' / '.TEXT_RECLAMATION.' '.$rueckerstattungen->info['reclamations_id'] : ''),
	    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
	));
	
	$smarty->assign('SEPARATOR',xtc_draw_separator());
	$smarty->assign('currency',$currency);
	$smarty->assign('ebay_id',$ebay_id);
	$smarty->assign('memo_count', \YES4Trade\Model\customers_memo::count_by_customers_id((int)$rueckerstattungen->info['customers_id']));
	$smarty->assign('memo_link', xtc_href_link(FILENAME_CUSTOMERS,'action=memo&cID='.$rueckerstattungen->info['customers_id']));
	$smarty->assign('DISPLAY_MEMOS',DISPLAY_MEMOS);
	$smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
	$smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);
	$smarty->assign('order_link',yes_draw_order_edit_link($rueckerstattungen->info['orders_id']));
	$smarty->assign('reclamation_link',yes_draw_reclamation_edit_link($rueckerstattungen->info['reclamations_id']));
	$smarty->assign('type', xtc_get_rueckerstattungen_types_name($rueckerstattungen->info['type']));
	$smarty->assign('change_type_link', xtc_href_link('rueckerstattungen.php','action=change_type_confirm&id='.$_REQUEST['rID']));
	$smarty->assign(array(
	   'STATUS' => xtc_get_rueckerstattungen_status_name($rueckerstattungen->info['status']),
	   'COMMENTS'=>$rueckerstattungen->info['comments'],
	   'UPDATE_LINK'=>xtc_href_link('rueckerstattungen_update.php',xtc_get_all_get_params()),
            'LINK_EDIT_ADDRESS'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_address_edit'),
	));
	switch($rueckerstattungen->info['status']){
	    case '1':
                if($rueckerstattungen->info['orders_id'] > 0){
                    $op_query = xtc_db_query("SELECT payment_method FROM orders WHERE orders_id='".$rueckerstattungen->info['orders_id']."'");
                    $op_res = xtc_db_fetch_array($op_query);
                }
		$smarty->assign(array(
		    'BUTTON_END'=> yes_draw_href_button(BUTTON_BEZAHLUNG_ABGESCHLOSSEN, xtc_href_link('rueckerstattungen.php', xtc_get_all_get_params(array('action')).'action=set&rstatus=2'), 'width:200px','button','lbOn'),
		    'BUTTON_FAILED'=> yes_draw_href_button(BUTTON_FAILED, xtc_href_link('rueckerstattungen.php', xtc_get_all_get_params(array('action')).'action=set&rstatus=3'), 'width:200px','button','lbOn')
		));
		break;
	}
	$smarty->assign(array(
	    'BUTTON_PRINT'=>yes_draw_href_button(TEXT_RUECKERSTATTUNG.' '.TEXT_PRINT, 'javascript:window.open(\''.xtc_href_link('print_rueckerstattung.php','rID='.$_GET['rID']).'\');', 'width:200px')
	));
	$smarty->assign('stammdaten_link',xtc_href_link('customers.php','action=edit&cID='.$rueckerstattungen->info['customers_id']));

        $customers_query = xtc_db_query("select c.kto_iban, c.kto_swift, c.kto_nummer,c.kto_inhaber,c.kto_blz,c.kto_bank,c.customers_ebay_userid,c.customers_id,c.customers_cid, c.customers_gender, c.customers_firstname, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_company, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_default_address_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '" . $rueckerstattungen->info['customers_id'] . "'");
        $customers = xtc_db_fetch_array($customers_query);
	$customers['country'] = xtc_get_country_name($customers['entry_country_id']);
	$smarty->assign('customer',xtc_db_prepare_input($customers));
	$order = new order($rueckerstattungen->info['orders_id']);
	
	$query = xtc_db_query(sprintf(
		"SELECT orig_amazon_orders_id FROM amazon_orders WHERE orders_id='%s' LIMIT 1",
		$rueckerstattungen->info['orders_id']
	));
	if(xtc_db_num_rows($query)){
	    $record = xtc_db_fetch_array($query);
	    $smarty->assign('AMAZON_ORDERS_ID',$record['orig_amazon_orders_id']);
	}
	
	$history = array();
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
        $smarty->configLoad($smarty->getTemplateVars('language_path'), 'general');
        $config_vars = $smarty->getConfigVars();
        $contents = [[
            ['text'=>$config_vars['date_created'],'th'=>true],
            ['text'=>$config_vars['customer_notified'],'th'=>true],
            ['text'=>'Status','th'=>true],
            ['text'=>$config_vars['comment'],'th'=>true],
            ['text'=>'Editor','th'=>true],
        ]];
        
	$rueckerstattungen_history_query = xtc_db_query(sprintf(
            "select * from  rueckerstattungen_status_history  where rueckerstattungen_id='%d' order by date_added DESC",
            (int)xtc_db_input($_GET['rID'])
        ));
        while ($rueckerstattungen_history = xtc_db_fetch_array($rueckerstattungen_history_query)) {
            $contents[] = array(
                ['text'=>xtc_datetime_short($rueckerstattungen_history['date_added'])],
                ['text'=>($rueckerstattungen_history['customer_notified'] == '1')?'&#x2610;':'&#x2611;'],
                ['text'=>xtc_get_rueckerstattungen_status_name($rueckerstattungen_history['rueckerstattungen_status_id'])],
                ['text'=>nl2br(xtc_db_prepare_input($rueckerstattungen_history['comments'])) ],
                ['text'=>xtc_get_editor_name($rueckerstattungen_history['editor_id'])],
            );
        }
	$smarty->assign('HISTORY',$table->tableBlock_draw($contents));
        
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
        $contents = [[
            ['text'=>TEXT_INCOMING_PAYMENTS_DAY,'th'=>true],
            ['text'=>TEXT_INCOMING_PAYMENTS_ALLOCATION,'th'=>true],
            ['text'=>TEXT_INCOMING_PAYMENTS_AMOUNT,'th'=>true],
        ]];
	$payment_query = xtc_db_query(sprintf(
            "SELECT ip.buchungstag,ip.betrag,po.created FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='%d'",
            $rueckerstattungen->info['orders_id']
        ));
	$payment_orders = false;
        while($payment = xtc_db_fetch_array($payment_query)) {
            $payment_orders = true;
            $contents[] = [
                ['text'=>$payment['buchungstag']],
                ['text'=>xtc_date_short($payment['created'])],
                ['text'=>number_format($payment['betrag'],2,',','')],
            ];
        }
        if($payment_orders){
            $smarty->assign(array(
                'TEXT_INCOMING_PAYMENTS' => INCOMING_PAYMENTS,
                'PAYMENTS'=>$table->tableBlock_draw($contents)
            ));
        }
	echo $smarty->fetch(DIR_FS_ADMIN.'templates/rueckerstattung.html');
  /* * * * * * * * * * * * * * * * * * * * * * * * * * *
  rueckerstattungen STATUS
  * * * * * * * * * * * * * * * * * * * * * * * * * * */
} else if($action == 'add' and isset($_GET['oID']) and $_GET['oID'] != '') {
  	$order = new order($_GET['oID']);
	$rtypes = xtc_get_rueckerstattungen_types();
	$ask = array(0=>array('id'=>'','text'=>TEXT_SELECT));
	$types = array_merge($ask,$rtypes);
		
	$kasseuser = KASSE_USER;
	
	if($order->customer['ID'] != $kasseuser){
            $save = xtc_draw_checkbox_field('save_kto','1',false);
        }else{
            $save = '<span class=errorText>(nicht bei KASSE)</span>';
        }

	$max = 0;
	foreach($order->totals as $ot){
	    switch($ot['class']){
		case 'ot_total':
		    $max = number_format($ot['value'],2,'.','');
		    break;
	    }
	}
        $mode_value = (isset($_REQUEST['rueckerstatten']))?$_REQUEST['rueckerstatten']:'';
        $betrag = (isset($_GET['betrag']))?(float)xtc_db_input($_GET['betrag']):0;
	$grund = (isset($_REQUEST['grund'])) ? $_REQUEST['grund'] : '';
	$smarty->assign(array(
	    'MAX'=>$max,
	    'ERROR_MSG_MAX'=>sprintf(MSG_ERROR_RUECKERSTATTUNG_MAX_AMOUNT,number_format($max,2,',','.')),
	    'HEADING_TITLE'=>sprintf(HEADING_TITLE_ADD_RUECKERSTATTUNG,$_REQUEST['oID']),
            'TEXT_RUECKERSTATTUNG'=>TEXT_RUECKERSTATTUNG,
            'FORM'=>xtc_draw_form('rueck','rueckerstattungen.php',xtc_get_all_get_params(array('action')).'action=save'),
            'TEXT_RUECKERSTATTUNG_MODE'=>TEXT_RUECKERSTATTUNG_MODE,
            'INPUT_RUECKERSTATTUNG_MODE'=>xtc_draw_pull_down_menu('rueckerstatten', $types,$mode_value,'id="rueckerstatten_select"'),
            'TEXT_KONTO_NUMMER'=>TEXT_KONTO_NUMMER,
            'INPUT_KTO_NUMMER'=>xtc_draw_input_field('kto_nummer',$cInfo->kto_nummer,'size="25" id="kto_nummer"'),
            'TEXT_KONTO_INHABER'=>TEXT_KONTO_INHABER,
            'INPUT_KTO_INHABER'=>xtc_draw_input_field('kto_inhaber',$cInfo->kto_inhaber,'size="25" id="kto_inhaber"'),
            'TEXT_KONTO_BLZ'=>TEXT_KONTO_BLZ,
            'INPUT_KTO_BLZ'=>xtc_draw_input_field('kto_blz',$cInfo->kto_blz,'size="25" id="kto_blz"'),
            'TEXT_KONTO_BANK'=>TEXT_KONTO_BANK,
            'INPUT_KTO_BANK'=>xtc_draw_input_field('kto_bank',$cInfo->kto_bank,'size="25" id="kto_bank"'),
            'INPUT_KTO_IBAN'=>xtc_draw_input_field('kto_iban',$cInfo->kto_iban,'size="25" id="kto_iban"'),
            'INPUT_KTO_SWIFT'=>xtc_draw_input_field('kto_swift',$cInfo->kto_swift,'size="25" id="kto_swift"'),
            'INPUT_SAVE_BANK'=>$save,
            'TEXT_SAVE_KONTO_DATA'=>TEXT_SAVE_KONTO_DATA,
            'TEXT_KTO_BETRAG'=>TABLE_HEADING_BETRAG,
            'INPUT_KTO_BETRAG'=>xtc_draw_input_field('kto_betrag',number_format($betrag,2,',',''),'size="10" id="kto_betrag"'),
            'CURRENCY'=>$order->info['currency'],
            'TEXT_RUECKERSTATTUNG_GRUND'=>TEXT_RUECKERSTATTUNG_GRUND,
            'INPUT_GRUND'=>xtc_draw_textarea_field('grund','','40','4',$grund),
            'IMAGE_SAVE'=>IMAGE_SAVE,
            'TEXT_ADD_PAYMENT_BLOCK'=>TEXT_ADD_PAYMENT_BLOCK,
            'TEXT_ADD_PAYMENT_MAIN'=>TEXT_ADD_PAYMENT_MAIN,
            'MSG_ERROR_SELECT_RUECKERSTATTUNG_TYPE'=>MSG_ERROR_SELECT_RUECKERSTATTUNG_TYPE,
            'MSG_ERROR_RUECKERSTATTUNG_GRUND'=>MSG_ERROR_RUECKERSTATTUNG_GRUND,
	));
        $smarty->display('rueckerstattungen_add.html');
        exit;
  /* * * * * * * * * * * * * * * * * * * * * * * * * * *
  rueckerstattungen LISTING
  * * * * * * * * * * * * * * * * * * * * * * * * * * */
  } else {
	include('rueckerstattungen_listing.php');
  }
?>
    </table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
