<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                              Author M. ASPELEITER <dazze@gmx.de
                                             	Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

  // MIT send_status 1 IST DIE REKLAMATION IM VERSANDMODUL SICHTBAR
  // MIT send_status 2 GILT DIE REKLAMATION ALS VERSENDET
   
require('includes/application_top.php');
require_once(DIR_WS_CLASSES.'class.help.php');
require_once(DIR_WS_CLASSES.'class.branch_quantity.php');
require_once(DIR_WS_CLASSES.'yes_shipping.php');
require_once(DIR_WS_CLASSES.'stepwise.php');
require_once(DIR_FS_INC . 'xtc_serials.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
require_once(DIR_FS_INC . 'changedataout.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_vatid_status.inc.php');
require_once(DIR_FS_INC . 'xtc_get_parent_categories.inc.php');
require_once(DIR_FS_INC . 'xtc_get_product_path.inc.php');
require_once(DIR_FS_INC . 'xtc_format_price_order.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_get_tax_class_id.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_retoure_copy_product.inc.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_tax.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_shipping.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_total.php');
  
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');
if(!function_exists('yes_get_sha1_from_string')){
    require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
}
if(!function_exists('xtc_db_affected_rows')){
    require_once(DIR_FS_INC.'xtc_db_affected_rows.inc.php');
}
$RETOURE_CAT = \YES4Trade\Model\categories_description::get_retoure_categories_id();
if($RETOURE_CAT < 1){
    $messageStack->add_session(MSG_ERROR_NO_RETOURE_CATEGORY,'error');
    xtc_redirect(xtc_href_link('start.php'));
}


define('RECLAMATION_TAXCLASS',ORDERS_EDIT_TAX_VALUE);
// yes accounting  
$admin_access = main::get_admin_access();
  
// yes accounting
$vers_array = array();
foreach($VERSENDER as $k=>$v){
    $vers_array[] = array('id'=>$v,'text'=>$v);
}
  
  // initiate template engine for mail
  $smarty = new yesSmarty;
  require(DIR_WS_CLASSES . 'currencies.php');
  $smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

  $currencies = new currencies();

  if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($_GET['rID']) ) {
    $rID = (int)xtc_db_input($_GET['rID']);

    $reclamations_query = xtc_db_query("select reclamations_id from reclamations where reclamations_id = '" . $rID . "'");
    $reclamation_exists = true;
    if (!xtc_db_num_rows($reclamations_query)) {
      $reclamation_exists = false;
      $messageStack->add(sprintf(MSG_ERROR_RECLAMATION_NOT_EXISTS, $rID), 'error');
      xtc_redirect(xtc_href_link('start.php'));
    }
  }

require(DIR_WS_CLASSES . 'reclamation.php');
require(DIR_WS_CLASSES . 'order.php');
require(DIR_WS_CLASSES . 'rueckerstattung.php');


if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($reclamation_exists) ) {
	$reclamation = new reclamation($rID);
}

$bestand_error = array();
// PRUEFE OB BESTAND VORHANDEN - SONST KEINE REKLA MOEGLICH
if( (isset($_GET['verify']) and $_GET['verify'] == '1') or (isset($_GET['action']) and $_GET['action'] == 'addorder_save')){
		if( (isset($_GET['type']) and $_GET['type']=='3') and STOCK_CHECK == "true"){
			$oID = xtc_db_input( $_GET['oID'] );
			$order = new order($oID);
			
			foreach($order->products as $k=>$product){
				// collies
				$collies = xtc_get_product_collies($product['id']);
				if(sizeOf($collies)>0){
					foreach($collies as $kc=>$collie){
						if( isSet($_POST['qty_collie_'.$product['opID'].'_'.$collie['collie_products_id'] ]) and ($_POST['qty_collie_'.$product['opID'].'_'.$collie['collie_products_id'] ] > 0) ){
							$SQ = new products_quantity($collie['collie_products_id']);
							$qty_total = $SQ->get_products_total_qty();
							
							if($qty_total < $_POST['qty_collie_'.$product['opID'].'_'.$collie['collie_products_id'] ]){
								$error = 'Das Colliprodukt '.xtc_get_products_name($collie['collie_products_id']).' [pID '.$collie['collie_products_id'].'] hat einen Bestand von '.$qty_total.' eine Reklamation von '.$_POST['qty_collie_'.$product['opID'].'_'.$collie['collie_products_id'] ].' Stk. ist somit nicht m&ouml;glich.';
								$bestand_error[] = $error;
								$messageStack->add($error,'error');
							}
						}
					}
				}else{
					$SQ = new products_quantity($product['id']);
					$qty_total = $SQ->get_products_total_qty();
							
					if($qty_total < $_POST['qty_'.$product['opID']]){
						$error = 'Das Produkt '.xtc_get_products_name($product['id']).' [pID '.$product['id'].'] hat einen Bestand von '.$qty_total.' eine Reklamation von '.$_POST['qty_'.$product['opID']].' Stk. ist somit nicht m&ouml;glich.';
						$bestand_error[] = $error;
						$messageStack->add($error,'error');
					}
				}
			}
		}
	}
$action = (isset($_GET['action']))?$_GET['action']:'';
$costs_groups = [
    [
        'title'=>TEXT_SHIPPINGCOSTS,
        'ot_class'=>'ot_shippings',
        'sort_order'=>MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER,
    ],[
        'title'=>TEXT_TRANSPORTKOSTEN,
        'ot_class'=>'ot_transport',
        'sort_order'=>23,
    ],[
        'title'=>TEXT_BEARBEITUNGSGEBUEHREN,
        'ot_class'=>'ot_bearbeitung',
        'sort_order'=>22,
    ],[
        'title'=>TEXT_REPARATURKOSTEN,
        'ot_class'=>'ot_repair',
        'sort_order'=>21,
    ]
];
switch ($action) {
    case 'update_send':
        $rID = (int)xtc_db_input($_GET['rID']);
        $send = (int)xtc_db_input($_GET['send']);
        $update_sql_array = [
            'send'=>$send,
            'last_modified'=>date('Y-m-d H:i:s'),
        ];
        xtc_db_perform('reclamations',$update_sql_array,'update',"reclamations_id='".$rID."'");
        $comments = sprintf(TEXT_UPDATED_RECLAMATION_SEND,
            ($send == 1) ? YES : NO
        );
        $reclamation = new reclamation($rID);
        $reclamation->add_history($reclamation->info['reclamations_status'], false, $comments);
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action']).'action=edit'));
    case 'stepwise_addorder_final':
        $debug = false;
        $data = stepwise::getSV();
        $oID = (int)xtc_db_input($_GET['oID']);
        $order = new order($oID);
        $type = (int)$_GET['type'];
        $status = ( $type == 2 or (isset($data['rueckerstatten']['data']['payment_finished']) and (int)$data['rueckerstatten']['data']['payment_finished'] == 1) )?3:1;
        $send = ($type == 2) ? 0 : 1;
        $send_status = 0; // (noch) nicht im versandmodul listen
        
        $insert_sql_array = [
            'orders_id'=>$oID,
            'customers_id'=>$order->customer['ID'],
            'customers_cid'=>$order->customer['csID'],
            'customers_vat_id'=>$order->customer['vat_id'],
            'customers_status'=>$order->info['status'],
            'customers_status_name'=>$order->info['status_name'],
            'customers_status_image'=>$order->info['status_image'],
            'customers_status_discount'=>$order->info['status_discount'],
            
            'customers_name'=>$order->customer['name'],
            'customers_company'=>$order->customer['company'],
            'customers_street_address'=>$order->customer['street_address'],
            'customers_suburb'=>$order->customer['suburb'],
            'customers_city'=>$order->customer['city'],
            'customers_postcode'=>$order->customer['postcode'],
            'customers_state'=>$order->customer['state'],
            'customers_country'=>$order->customer['country'],
            'customers_telephone'=>$order->customer['telephone'],
            'customers_email_address'=>$order->customer['email_address'],
            'customers_address_format_id'=>$order->customer['format_id'],
            
            'delivery_name'=>$order->delivery['name'],
            'delivery_company'=>$order->delivery['company'],
            'delivery_street_address'=>$order->delivery['street_address'],
            'delivery_suburb'=>$order->delivery['suburb'],
            'delivery_city'=>$order->delivery['city'],
            'delivery_postcode'=>$order->delivery['postcode'],
            'delivery_state'=>$order->delivery['state'],
            'delivery_country'=>$order->delivery['country'],
            'delivery_address_format_id'=>$order->delivery['format_id'],

            'billing_name'=>$order->billing['name'],
            'billing_company'=>$order->billing['company'],
            'billing_street_address'=>$order->billing['street_address'],
            'billing_suburb'=>$order->billing['suburb'],
            'billing_city'=>$order->billing['city'],
            'billing_postcode'=>$order->billing['postcode'],
            'billing_state'=>$order->billing['state'],
            'billing_country'=>$order->billing['country'],
            'billing_address_format_id'=>$order->billing['format_id'],
            
            'comments'=>$data['info']['comments'],
            'date_created'=>date('Y-m-d H:i:s'),
            'date_payment'=>($info['rueckerstatten'] == 3)?date('Y-m-d H:i:s'):'',
            'reclamations_status'=>$status,
            'reclamations_type'=>$type,
            'currency'=>$order->info['currency'],
            'currency_value'=>$order->info['currency_value'],
            'account_type'=>$order->info['account_type'],
            'language'=>$order->info['language'],
            'versender'=>(isset($data['retoure']['data']['versender']))?$data['retoure']['data']['versender']:'',
            'send'=>$send,
            'send_status'=>$send_status,
        ];
        if(!$debug){
            xtc_db_perform('reclamations',$insert_sql_array);
            $rID = xtc_db_insert_id();
        }else{
            $rID = '1';
        }
        $insert_sql_array = [
            'value'=>0,
            'text'=>'0,00 '.$order->info['currency'],
            'class'=>'ot_subtotal',
            'title'=>MODULE_ORDER_TOTAL_SUBTOTAL_TITLE,
            'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER,
            'reclamations_id'=>$rID,
        ];
        if(!$debug){
            xtc_db_perform('reclamations_total',$insert_sql_array);
        }
        
        $total = 0;
        $price_tax = 0;
        $sc = (isset($data['send']['data']['shippingcosts']))?(float)str_replace(',','.',$data['send']['data']['shippingcosts']):0;
        if($sc > 0){
            $insert_sql_array = [
                'title'=>MODULE_ORDER_TOTAL_SHIPPING_TITLE,
                'text'=>number_format($sc,2,',','').' '.$order->info['currency'],
                'value'=>$sc,
                'class'=>'ot_shippings',
                'sort_order'=>'20',
                'reclamations_id'=>$rID
            ];
            if(!$debug){
                xtc_db_perform('reclamations_total',$insert_sql_array);
            }
            $price_tax +=  $sc - ($sc / ((RECLAMATION_TAXCLASS+100)/100));
            $total += $sc;
        }
        foreach($data['costs'] as $k=>$v){
            $v = (float)str_replace(',','.',$v);
            $total += $v;
            if($v > 0){
                $price_tax +=  $v - ($v / ((RECLAMATION_TAXCLASS+100)/100));
                switch($k){
                    case 'transportkosten':
                        $class = 'ot_transport';
                        $sort_order = 23;
                        $title = TEXT_ADDORDER_RECLAMATIONS_TOTAL_TRANSPORT;
                        break;
                    case 'repaircosts':
                        $title = TEXT_ADDORDER_RECLAMATIONS_TOTAL_REPAIR_COSTS;
                        $class = 'ot_repair';
                        $sort_order = 21;
                        break;
                    case 'bearbeitungsgebuehr':
                        $title = TEXT_ADDORDER_RECLAMATIONS_TOTAL_BEARBEITUNGSGEBUEHR;
                        $class = 'ot_bearbeitung';
                        $sort_order = 22;
                        if($v > 0){
                            $sql_array = array(
                                'class'=>'reclamation_bearbeitungsgebuehr',
                                'orders_id'=>$oID,
                                'reclamations_id'=>$rID,
                                'customers_id'=>$order->customer['ID'],
                                'comments'=>TEXT_ADDORDER_RECLAMATIONS_BEARBEITUNGSGEBUEHR_COMMENTS,
                                'date_created'=>"now()",
                                'value'=>$v,
                                'editor_id'=>$_SESSION['customer_id']
                            );
                            xtc_db_perform('costs',$sql_array);
                        }
                        break;
                }
                $insert_sql_array = [
                    'value'=>$v,
                    'text'=>number_format($v,2,',','').' '.$order->info['currency'],
                    'class'=>'ot_subtotal',
                    'title'=>$title,
                    'sort_order'=>$sort_order,
                    'reclamations_id'=>$rID,
                ];
                if(!$debug){
                    xtc_db_perform('reclamations_total',$insert_sql_array);
                }
            }
        }
        if($price_tax > 0){
            $insert_sql_array = [
                'value'=>(float)$price_tax,
                'text'=>number_format($price_tax,2,',','').' '.$order->info['currency'],
                'class'=>'ot_tax',
                'title'=>MODULE_ORDER_TOTAL_TAX_TITLE.' '.number_format(RECLAMATION_TAXCLASS,2,',','').'%',
                'sort_order'=>10,
                'reclamations_id'=>$rID,
            ];
            if(!$debug){
                xtc_db_perform('reclamations_total',$insert_sql_array);
            }
        }
        // total speichern
        $insert_sql_array = array(
            'reclamations_id'=>$rID,
            'title'=>MODULE_ORDER_TOTAL_TOTAL_TITLE,
            'text'=>number_format($total,2,',','').' '.$order->info['currency'],
            'value'=>(float)$total,
            'class'=>'ot_total',
            'sort_order'=>'50'
        );
        if(!$debug){
            xtc_db_perform('reclamations_total',$insert_sql_array);
        }

        $rrID = stepwise::getSV('info','reclamations_reasons_id');
        $insert_sql_array = array(
            'reclamations_id'=>$rID,
            'reclamations_reasons_id'=>$rrID
        );
        if(!$debug){
            xtc_db_perform('reclamations_to_reclamations_reasons',$insert_sql_array);
        }
        $rueckbuch_branches_id = 0;
        if(!isset($data['retoure']['abholung']) or (int)$data['retoure']['abholung'] == 0){
            if(isset($data['products']['rueckbuch']['rueckbuch_branches_id']) and (int)$data['products']['rueckbuch']['rueckbuch_branches_id'] > 0){
                $rueckbuch_branches_id = (int)$data['products']['rueckbuch']['rueckbuch_branches_id'];
                $query = xtc_db_query(sprintf(
                    "SELECT stammlager FROM branches WHERE branches_id='%d'",
                    $rueckbuch_branches_id
                ));
                $record = xtc_db_fetch_array($query);
                if($record['stammlager'] == 1){
                    $rueckbuch_branches_id = 0;
                }
            }
        }
        
        foreach($data['products']['quantity'] as $opkey=>$qty){
            if($qty < 1){
                continue;
            }
            if(strpos($opkey,'-')>0){
                // collie
                $opkey_params = explode('-',$opkey);
                $opID = (int)$opkey_params[0];
                $collie_products_id = (int)$opkey_params[1];
                $cp = new product($collie_products_id);
            }else{
                $opID = $opkey;
                $collie_products_id = 0;
            }
            foreach($order->products as $op){
                if($op['opID'] == $opID){
                    $order_product = $op;
                }
            }
            $insert_sql_array = [
                'reclamations_id'=>$rID,
                'products_id'=>($collie_products_id > 0) ? $collie_products_id : $order_product['id'],
                'products_model'=>($collie_products_id > 0) ? $cp->info['products_model'] : $order_product['model'],
                'products_name'=>($collie_products_id > 0) ? $cp->info['products_name'] : $order_product['name'],
                'products_quantity'=>$qty,
            ];
            if(!$debug){
                xtc_db_perform('reclamations_products',$insert_sql_array);
                $rpID = xtc_db_insert_id();
            }else{
                $rpID = 2;
            }
            if($collie_products_id > 0){
                $comments = sprintf('[Colli/Set pID %d] Reklamation #%d: %d Stk',
                    $order_product['id'], $rID, $qty
                );
            }else{
                $comments = sprintf('Reklamation #%d: %d Stk',
                    $rID,$qty
                );
            }
            if(!$debug){
                product::add_history_static( 
                    (int)($collie_products_id>0)?$collie_products_id:$order_product['id'], 
                    $comments
                );
            }
            if($collie_products_id == 0 and isset($order_product['properties']) and sizeOf($order_product['properties'])){
                foreach($order_product['properties'] as $property){
                    $sql_array = array(
                        'reclamations_products_id'=>$rpID,
                        'property_title'=>$property['property_title'],
                        'property_value'=>$property['property_value'],
                        'input_span'=>$property['input_span'],
                    );
                    if(!$debug){
                        xtc_db_perform('reclamations_products_properties',$sql_array);
                    }
                }
            }
            $reclamation_comment = $data['info']['comments'];
            if($collie_products_id > 0){
                if(!$debug){
                    $order->add_history($order->info['orders_status'], false, 
                        sprintf(TEXT_ADDORDER_ORDER_HISTORY_COLLIE_PRODUCT_SAVED,
                            $collie_products_id,$order_product['id'],$rID,$qty
                        )
                    );
                }
                $new = new \YES4Trade\Model\reclamations_status_history([
                    'reclamations_id'=>(int)$rID,
                    'reclamations_status_id'=>(int)$status,
                    'editor_id'=>(int)$_SESSION['customer_id'],
                    'customer_notified'=>0,
                    'date_added'=>date('Y-m-d H:i:s'),
                    'comments'=>sprintf(TEXT_ADDORDER_RECLAMATION_HISTORY_COLLIE_PRODUCT_SAVED,
                        $collie_products_id,$order_product['id'],$qty).$reclamation_comment,
                ]);
                if(!$debug){
                    $new->create(); 
                }
            }else{
                if(!$debug){
                    $order->add_history($order->info['orders_status'], false, 
                        sprintf(TEXT_ADDORDER_ORDER_HISTORY_PRODUCT_SAVED,
                            $order_product['id'],
                            $rID,$qty
                        )
                    );
                }

                $new = new \YES4Trade\Model\reclamations_status_history([
                    'reclamations_id'=>(int)$rID,
                    'reclamations_status_id'=>(int)$status,
                    'editor_id'=>(int)$_SESSION['customer_id'],
                    'customer_notified'=>0,
                    'date_added'=>date('Y-m-d H:i:s'),
                    'comments'=>TEXT_ADDORDER_RECLAMATION_HISTORY_CREATED.$reclamation_comment
                ]);
                if(!$debug){
                    $new->create();
                }
            }
            
            // rueckbuchen wenn keine retoure
            if(!isset($data['retoure']['abholung']) or (int)$data['retoure']['abholung'] == 0){
                if(in_array($type,[2,3])){
                    $rueckbuch_qty = $qty;
                    if(isset($data['products']['rueckbuch']['defect_quantity'][$opkey]) and $data['products']['rueckbuch']['defect_quantity'][$opkey] > 0){
                        $rueckbuch_qty -= $data['products']['rueckbuch']['defect_quantity'][$opkey];
                    }
                    
                    $new_qty = $rueckbuch_qty;
                    if($collie_products_id > 0){
                        $rueck_qty_comment = sprintf(TEXT_ADDORDER_PRODUCTS_HISTORY_COLLI_WITHOUT_RETOURE,
                            $oID,$rID,$order_product['id'],$new_qty
                        );
                    }else{
                        $rueck_qty_comment = sprintf('Aus Re-Nr.: %d / Reklamation %d -> Rueckbuchung ohne Retoureauftrag %d Stk.',
                            $oID, $rID,$new_qty
                        );
                    }
                    if($rueckbuch_branches_id > 0){
                        if($collie_products_id > 0){
                            $BQ = new branch_quantity($collie_products_id, $rueckbuch_branches_id);
                        }else{
                            $BQ = new branch_quantity($order_product['id'], $rueckbuch_branches_id);
                        }
                        if(!$BQ->allocation_exists()){
                            $insert_sql_array = array(
                                'branches_id'=>$BQ->get_branch_id(),
                                'products_id'=>$BQ->get_products_id(),
                                'products_quantity'=>$new_qty
                            );
                            if(!$debug){
                                xtc_db_perform('branches_products',$insert_sql_array);
                            }
                        }else{
                            $update_sql_array = array(
                                'products_quantity'=>$BQ->get_quantity()+$new_qty
                            );
                            if(!$debug){
                                xtc_db_perform('branches_products',$update_sql_array,'update',
                                    "branches_id='".$BQ->get_branch_id()."' and products_id='".$BQ->get_products_id()."'"
                                );
                            }
                        }
                        if(!$debug){
                            $BQ->add_history($rueck_qty_comment,true);
                        }
                    }else{
                        if($collie_products_id > 0){
                            $SQ = new products_quantity($collie_products_id);
                        }else{
                            $SQ = new products_quantity($order_product['id']);
                        }
                        $qty_total = $SQ->get_products_total_qty();
                        if(!$debug){
                            $SQ->update_qty( $new_qty, $SQ->get_default_storage_id(),$qty_total,
                                $rueck_qty_comment
                            );
                        }
                    }
                    if(isset($data['products']['rueckbuch']['defect_quantity'][$opkey]) and (int)$data['products']['rueckbuch']['defect_quantity'][$opkey] > 0){
                        $copy_products_id = ($collie_products_id>0)?$collie_products_id:$order_product['id'];
                        $defect_qty = (int)$data['products']['rueckbuch']['defect_quantity'][$opkey];
                        $def_comments = $data['products']['rueckbuch']['defect_comments'][$opkey];
                        $categories_id = $RETOURE_CAT;
                        $cat_ids = array('0'=>$categories_id);
                        for($ii=0;$ii<$data['products']['rueckbuch']['defect_quantity'][$opkey];$ii++){
                            if(!$debug){
                                xtc_retoure_copy_product(
                                    $copy_products_id,$cat_ids,1,
                                    $comments,$def_comments[$ii],
                                );
                            }
                            $new = new \YES4Trade\Model\reclamations_status_history([
                                'reclamations_id'=>(int)$rID,
                                'reclamations_status_id'=>(int)$status,
                                'editor_id'=>(int)$_SESSION['customer_id'],
                                'customer_notified'=>0,
                                'date_added'=>date('Y-m-d H:i:s'),
                                'comments'=>$comments.' - '.$def_comments[$ii]
                            ]);
                            if(!$debug){
                                $new->create();
                            }
                        }
                    }// end if rueckbuch defect quantity
                } // type 2 or 3
            } // end not abholung
        } // end foreach products
        // rueckerstatten[data][save_kto] 1 = Bankdaten speichern
        if((int)$data['rueckerstatten']['rueckerstatten'] == 2 and isset($data['rueckerstatten']['data']['save_kto']) and (int)$data['rueckerstatten']['data']['save_kto'] == 1){
            $sql_array = array(
                'kto_nummer'=>$data['rueckerstatten']['data']['kto_nummer'],
                'kto_inhaber'=>$data['rueckerstatten']['data']['kto_inhaber'],
                'kto_blz'=>$data['rueckerstatten']['data']['kto_blz'],
                'kto_iban'=>$data['rueckerstatten']['data']['kto_iban'],
                'kto_swift'=>$data['rueckerstatten']['data']['kto_swift'],
                'kto_bank'=>$data['rueckerstatten']['data']['kto_bank'],
            );
            if(!$debug){
                xtc_db_perform('customers',$sql_array,'update','customers_id='.$order->customer['ID']);
            }

            $new = new \YES4Trade\Model\customers_memo([
                'customers_id'=>(int)$order->customer['ID'],
                'memo_date'=>date('Y-m-d H:i:s'),
                'memo_title'=>TEXT_ADDORDER_CUSTOMERS_MEMO_TITLE,
                'memo_text'=>sprintf(TEXT_ADDORDER_CUSTOMERS_MEMO_TEXT,$rID),
                'poster_id'=>(int)$_SESSION['customer_id']
            ]);
            if(!$debug){
                $new->create();
            }
        }
        
        // RETOURE EINTRAG ERZEUGEN
        if(isset($data['retoure']['abholung']) and (int)$data['retoure']['abholung'] == 1){
            $retoure_sql = array(
                'orders_id'=>$oID,
                'reclamations_id'=>$rID,
                'customers_id'=>$order->customer['ID'],
                'shipping_company'=>$data['retoure']['data']['shipping_company'],
                'shipping_name'=>$data['retoure']['data']['shipping_name'],
                'shipping_name2'=>$data['retoure']['data']['shipping_name2'],
                'shipping_street'=>$data['retoure']['data']['shipping_street'],
                'shipping_street2'=>$data['retoure']['data']['shipping_street2'],
                'shipping_postcode'=>$data['retoure']['data']['shipping_postcode'],
                'shipping_city'=>$data['retoure']['data']['shipping_city'],
                'shipping_country'=>xtc_get_country_name(xtc_db_input($data['retoure']['data']['shipping_country_id'])),
                'date_created'=>date('Y-m-d H:i:s'),
                'retoure_status'=>1,
                'versender'=>$data['retoure']['data']['versender'],
                'costs'=>(isset($data['costs']['transportkosten']))?(float)str_replace(',','.',$data['costs']['transportkosten']):0,
            );
            if(!$debug){
                xtc_db_perform('retouren',$retoure_sql);
                $retoure_id = xtc_db_insert_id();
            }else{
                $retoure_id = 3;
            }
            $newH = new \YES4Trade\Model\retoure_status_history([
                'retoure_id'=>(int)$retoure_id,
                'retoure_status_id'=>1, 
                'date_added'=>date('Y-m-d H:i:s'),
                'customer_notified'=>0,
                'comments'=>sprintf(TEXT_ADDORDER_RETOURE_HISTORY,$rID),
                'editor_id'=>(int)$_SESSION['customer_id']
            ]);
            if(!$debug){
                $newH->create();
            }
            if(!$debug){
                $order->add_history($order->info['orders_status'],false,
                    sprintf(TEXT_ADDORDER_ORDERS_HISTORY,$retoure_id,$rID)
                );
            }
            $new = new \YES4Trade\Model\reclamations_status_history([
                'reclamations_id'=>(int)$rID,
                'reclamations_status_id'=>(int)$status, 
                'date_added'=>date('Y-m-d H:i:s'),
                'customer_notified'=>0,
                'comments'=>sprintf(TEXT_ADDORDER_RECLAMATIONS_HISTORY,$retoure_id),
                'editor_id'=>(int)$_SESSION['customer_id']
            ]);
            if(!$debug){
                $new->create();
            }
            foreach($data['products']['quantity'] as $opkey=>$qty){
                if($qty < 1){
                    continue;
                }
                if(strpos($opkey,'-')>0){
                    // collie
                    $opkey_params = explode('-',$opkey);
                    $opID = (int)$opkey_params[0];
                    $collie_products_id = (int)$opkey_params[1];
                    $cp = new product($collie_products_id);
                }else{
                    $opID = $opkey;
                    $collie_products_id = 0;
                }
                foreach($order->products as $op){
                    if($op['opID'] == $opID){
                        $order_product = $op;
                    }
                }
                $sql_array = array(
                    'retoure_id'=>$retoure_id,
                    'products_id'=>($collie_products_id > 0) ? $collie_products_id : $order_product['id'],
                    'products_model'=>($collie_products_id > 0) ? $cp->info['products_model'] : $order_product['model'],
                    'products_name'=>($collie_products_id > 0) ? $cp->info['products_name'] : $order_product['name'],
                    'products_quantity'=>$qty
                );
                if(!$debug){
                    xtc_db_perform('retoure_products',$sql_array);
                    $rtpID = xtc_db_insert_id();
                }else{
                    $rtpID = 5;
                }
                $ret_comments = sprintf('Retoure #%d: %d Stk',$retoure_id,$qty);
                if($collie_products_id > 0){
                    $ret_comments = sprintf('Retoure #%d: %d Stk (SET pID %d)',
                        $retoure_id,$qty, $order_product['id']
                    );
                }
                $insert_sql_array = array(
                    'products_id'=>($collie_products_id > 0) ? $collie_products_id : $order_product['id'],
                    'editor_id'=>(int)$_SESSION['customer_id'],
                    'date_saved'=>'now()',
                    'comments'=>$ret_comments,
                );
                if(!$debug){
                    xtc_db_perform('products_history',$insert_sql_array);
                }
                if($collie_products_id == 0 and isset($order_product['properties']) and sizeOf($order_product['properties'])){
                    foreach($order_product['properties'] as $property){
                        $sql_array = array(
                            'retoure_products_id'=>$rtpID,
                            'property_title'=>$property['property_title'],
                            'property_value'=>$property['property_value'],
                            'input_span'=>$property['input_span'],
                        );
                        if(!$debug){
                            xtc_db_perform('retoure_products_properties',$sql_array);
                        }
                    }
                }
            }
        }
        // rueckerstatten 1 = KEINE rueckerstattung
        // rueckerstatten 2 = ueberweisung
        if(isset($data['rueckerstatten']['rueckerstatten'])){
             $betrag = (float)str_replace(',','.',$data['rueckerstatten']['data']['kto_betrag']);
             if((int)$data['rueckerstatten']['rueckerstatten'] == 2 or (int)$data['rueckerstatten']['rueckerstatten']>3){
                $sql_array = array(
                    'orders_id'=>$oID,
                    'customers_id'=>$order->customer['ID'],
                    'reclamations_id'=>$rID,
                    'betrag'=>$betrag,
                    'paymode'=>xtc_get_rueckerstattungen_types_name((int)$data['rueckerstatten']['rueckerstatten']),
                    'date_created'=>date('Y-m-d H:i:s'),
                    'kto_nummer'=>$data['rueckerstatten']['data']['kto_nummer'],
                    'kto_blz'=>$data['rueckerstatten']['data']['kto_blz'],
                    'kto_inhaber'=>$data['rueckerstatten']['data']['kto_inhaber'],
                    'kto_bank'=>$data['rueckerstatten']['data']['kto_bank'],
                    'kto_iban'=>$data['rueckerstatten']['data']['kto_iban'],
                    'kto_swift'=>$data['rueckerstatten']['data']['kto_swift'],
                    'kto_grund'=>$data['rueckerstatten']['data']['grund'],
                    'comments'=>TEXT_ADDORDER_RUECKERSTATTUNG_COMMENT,
                    'editor_id'=>$_SESSION['customer_id'],
                    'type'=>(int)$data['rueckerstatten']['rueckerstatten'],
                    'status'=>1
                );
                if(!$debug){
                    xtc_db_perform('rueckerstattungen',$sql_array);
                    $rueck_id = xtc_db_insert_id();
                }else{
                    $rueck_id = 4;
                }
                if(!$debug){
                    rueckerstattung::add_history_static($rueck_id, 1, false,
                        sprintf(TEXT_ADDORDER_RUECKERSTATTUNGEN_HISTORY,
                            $rID
                        ).' '.$data['rueckerstatten']['data']['grund']
                    );
                    $order->add_history($order->info['orders_status'],false,
                        sprintf(TEXT_ADDORDER_ORDERS_HISTORY_FOR_RUECKERSTATTUNG,
                                $rueck_id,$rID)
                    );
                }
                $new = new \YES4Trade\Model\reclamations_status_history([
                    'reclamations_id'=>(int)$rID, 
                    'reclamations_status_id'=>$status, 
                    'date_added'=>date('Y-m-d H:i:s'),
                    'customer_notified'=>0,
                    'comments'=>sprintf(TEXT_ADDORDER_RECLAMATIONS_HISTORY_FOR_RUECKERSTATTUNG,$rueck_id),
                    'editor_id'=>(int)$_SESSION['customer_id']
                ]);
                if(!$debug){
                    $new->create();
                }
             }elseif((int)$data['rueckerstatten']['rueckerstatten'] == 3){
                $sql_array = array(
                    'orders_id'=>$oID,
                    'customers_id'=>$order->customer['ID'],
                    'reclamations_id'=>$rID,
                    'betrag'=>$betrag,
                    'paymode'=>'Bar',
                    'kto_inhaber'=>$data['rueckerstatten']['data']['kto_inhaber'],
                    'date_created'=>"now()",
                    'date_payment'=>"now()",
                    'comments'=>TEXT_ADDORDER_RUECKERSTATTUNG_COMMENT_BAR,
                    'editor_id'=>$_SESSION['customer_id'],
                    'type'=>(int)$data['rueckerstatten']['rueckerstatten'],
                    'status'=>2
                );
                if(!$debug){
                    xtc_db_perform('rueckerstattungen',$sql_array);
                    $rueck_id = xtc_db_insert_id();
                }else{
                    $rueck_id = 4;
                }
                if(!$debug){
                    rueckerstattung::add_history_static(intval($rueck_id), 
                        2,false,
                        sprintf(TEXT_ADDORDER_RUECKERSTATTUNGEN_HISTORY_BAR,
                            $rID
                        ).' '.$data['rueckerstatten']['data']['grund']
                    );
                            
                    $order->add_history($order->info['orders_status'],false,
                        sprintf(TEXT_ADDORDER_ORDERS_HISTORY_FOR_RUECKERSTATTUNG_BAR,
                            $rueck_id,$rID)
                    );
                }
                $new = new \YES4Trade\Model\reclamations_status_history([
                    'reclamations_id'=>(int)$rID, 
                    'reclamations_status_id'=>(int)$status, 
                    'date_added'=>date('Y-m-d H:i:s'),
                    'customer_notified'=>0,
                    'comments'=>sprintf(TEXT_ADDORDER_RECLAMATIONS_HISTORY_FOR_RUECKERSTATTUNG_BAR,$rueck_id),
                    'editor_id'=>(int)$_SESSION['customer_id']
                ]);
                if(!$debug){
                    $new->create();
                }
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_RECLAMATIONS,'action=edit&rID='.$rID));
        exit;
        break;
    case 'stepwise_addorder_save':
        $query = $_SERVER['QUERY_STRING'];
        parse_str($query, $params);
        if(isset($params['quantity'])){
            stepwise::setSV('products','quantity', $params['quantity']);
            if(isset($params['rueckbuch'])){
                stepwise::setSV('products','rueckbuch', $params['rueckbuch']);
            }else{
                stepwise::setSV('products','rueckbuch', []);
            }
        }
        if(isset($params['abholung'])){
            stepwise::setSV('retoure','abholung',$params['abholung']);
            if(isset($params['retoure']) and is_countable($params['retoure']) and sizeOf($params['retoure'])){
                stepwise::setSV('retoure','data',$params['retoure']);
            }else{
                stepwise::setSV('retoure','data',[]);
            }
        }
        if(isset($params['rueckerstatten'])){
            stepwise::setSV('rueckerstatten','rueckerstatten',$params['rueckerstatten']);
            if($params['rueckerstatten'] != '1' and isset($params['rueckerstattung']) and is_countable($params['rueckerstattung']) and sizeOf($params['rueckerstattung'])){
                stepwise::setSV('rueckerstatten','data',$params['rueckerstattung']);
            }else{
                stepwise::setSV('rueckerstatten','data',[]);
            }
        }
        if(isset($params['reclamations_reasons_id'])){
            stepwise::setSV('info','reclamations_reasons_id',(int)$params['reclamations_reasons_id']);
        }
        if(isset($params['comments'])){
            stepwise::setSV('info','comments',$params['comments']);
        }
        if(isset($params['repaircosts'])){
            stepwise::setSV('costs','repaircosts',(float)$params['repaircosts']);
        }
        if(isset($params['transportkosten'])){
            stepwise::setSV('costs','transportkosten',(float)$params['transportkosten']);
        }
        if(isset($params['bearbeitungsgebuehr'])){
            stepwise::setSV('costs','bearbeitungsgebuehr',(float)$params['bearbeitungsgebuehr']);
        }
        
        $msg = '';
        die(json_encode([
            'MSG'=>$msg
        ]));
        break;
    case 'stepwise_addorder_init':
        $type = (int)xtc_db_input($_GET['type']);
        $oID = (int)xtc_db_input($_GET['oID']);
        if(empty($type) or $oID < 1){
            die('stepwise_addorder_init::Invalid or missing parameters');
        }
        $steps = [];
        $steps[] = new stepwise_step([
            'url'=>xtc_href_link(FILENAME_RECLAMATIONS,'action=stepwise_addorder&block=retoure&oID='.$oID.'&type='.$type),
            'title'=>'Angaben zur Abholung',
            'id'=>'retoure'
        ]);
        $steps[] = new stepwise_step([
            'url'=>xtc_href_link(FILENAME_RECLAMATIONS,'action=stepwise_addorder&block=products&oID='.$oID.'&type='.$type),
            'title'=>'Welche Artikel sollen reklamiert werden?',
            'id'=>'products'
        ]);
        $steps[] = new stepwise_step([
            'url'=>xtc_href_link(FILENAME_RECLAMATIONS,'action=stepwise_addorder&block=rueckerstattung&oID='.$oID.'&type='.$type),
            'title'=>'Angaben zur Rückerstattung',
            'id'=>'rueckerstattung'
        ]);
        /*
        $steps[] = new stepwise_step([
            'url'=>xtc_href_link(FILENAME_RECLAMATIONS,'action=stepwise_addorder&block=shipping&oID='.$oID.'&type='.$type),
            'title'=>'Angaben zum Neuversand',
            'id'=>'shipping'
        ]);*/
        $steps[] = new stepwise_step([
            'url'=>xtc_href_link(FILENAME_RECLAMATIONS,'action=stepwise_addorder&block=costs&oID='.$oID.'&type='.$type),
            'title'=>'Angaben zum Vorgang und zu den Kosten',
            'id'=>'costs'
        ]);
        $sw = new stepwise($steps,xtc_href_link(FILENAME_RECLAMATIONS,'action=stepwise_addorder_final&oID='.$oID.'&type='.$type));
        $title = sprintf('Reklamation erzeugen aus Auftrag %d',$oID);
        echo $sw->getBaseHTML($title);
        exit;
        break;
    case 'stepwise_addorder':
        define('TEXT_ADDORDER_ABHOLUNG','Retoure der reklamierten Artikel veranlassen?');
        define('JS_ERROR_NO_KONTO','Angaben zur Bankverdung unvollständig. Weder Kontonummer noch IBAN gefunden.');
        $oID = (int)xtc_db_input($_GET['oID']);
        $block = xtc_db_input($_GET['block']);
        $smarty = new yesSmarty();
        $smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
        $smarty->configLoad($smarty->getTemplateVars('language_path'),'general');
        $smarty->configLoad($smarty->getTemplateVars('language_path'),'reclamation');
        $config_vars = $smarty->getConfigVars();
        $order = new order($oID);
        if(!isset($_GET['type'])){
            die('stepwise_addorder::missing parameters');
        }
        $type = (int) xtc_db_input($_GET['type']);
        // WENN RETOURE DANN KEINE RUECKBUCHUNGEN
        $smarty->assign('ORDERS_ID',$oID);
        if($block == 'products'){
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal rec_op_table" style="width: auto;"';
            $contents = [[
                ['text'=>TEXT_QUANTITY,'th'=>true],
                ['text'=>'pID','th'=>true],
                ['text'=>TEXT_PRODUCT,'th'=>true],
                ['text'=>$config_vars['image'],'th'=>true],

            ]];
            foreach($order->products as $op){
                $product = new product($op['id']);
                $collies = $product->get_collies();
                $image = '';
                if(!empty($product->info['products_image'])){
                    $path = DIR_WS_CATALOG_THUMBNAIL_IMAGES.$product->info['products_image'];
                    if(is_file($path)){
                        $image = xtc_get_products_image_html($product->info['products_image'],
                            'thumbnail_images',
                            'style="max-width: 25px;max-height:25px;" class="hover_img"'
                        );
                    }
                }
                if(sizeOf($collies)){
                    $qty = $op['qty'];
                    $name = '<span style="color: lightgreen;font-weight: bold;">[SET]</span> '.$op['name'];
                }else{
                    $opkey = $op['opID'];
                    $def = ($products_saved != null)?(int)$products_saved[ $opkey ]:0;
                    $qty_array = [];
                    for($i=0;$i<=$op['qty'];$i++){
                        $qty_array[] = ['id'=>$i,'text'=>$i];
                    }
                    $qty = xtc_draw_pull_down_menu('quantity['.$opkey.']',$qty_array, $def);
                    $name = sprintf('<span class="clearName">%s</span>',$op['name']);
                }
                $contents[] = [
                    ['text'=>$qty,'align'=>"right",'params'=>'class="qty"'],
                    ['text'=>$op['id'],'params'=>'class="pid" data-opid="'.$op['opID'].'" data-pid="'.$op['id'].'"'],
                    ['text'=>$name,'params'=>'class="name"'],
                    ['text'=>$image,'params'=>'class="image"']
                ];
                if(sizeOf($collies)){
                    foreach($collies as $colli){
                        $cp = new product($colli['collie_products_id']);
                        $cimage = '';
                        if(!empty($cp->info['products_image'])){
                            $path = DIR_WS_CATALOG_THUMBNAIL_IMAGES.$cp->info['products_image'];
                            if(is_file($path)){
                                $cimage = xtc_get_products_image_html($cp->info['products_image'],
                                    'thumbnail_images',
                                    'style="max-width: 25px;max-height:25px;" class="hover_img"'
                                );
                            }
                        }
                        $copkey = $op['opID'].'-'.$colli['collie_products_id'];
                        $def = ($products_saved != null)?(int)$products_saved[ $copkey ]:0;
                        $cqty_array = [];
                        for($i=0;$i<=($colli['quantity']*$op['qty']);$i++){
                            $cqty_array[] = ['id'=>$i,'text'=>$i];
                        }
                        $cqty = xtc_draw_pull_down_menu('quantity['.$copkey.']', $cqty_array,$def,sprintf(
                            'onchange="rp_quantity_change(\'%s\',this)" class="colli"',
                            $copkey,
                        ));
                        $cname = sprintf('<b>[C]</b> <span class="clearName">%s</span>',$cp->info['products_name']);
                        $contents[] = [
                            ['text'=>$cqty,'align'=>"right",'params'=>'class="qty"'],
                            ['text'=>'<span id="colli_info_text_'.$copkey.'" style="color: lightgreen;">[SET '.$op['id'].']</span> '.$colli['collie_products_id'],
                                'params'=>'class="pid" data-pid="'.$colli['collie_products_id'].'" data-opid="'.$copkey.'"'],
                            ['text'=>$cname,'params'=>'class="name"'],
                            ['text'=>$cimage,'params'=>'class="image"'],
                        ];
                    } // eof foreach collies
                } // eof is collie
            } // endof foreach op
            $smarty->assign([
                'products'=>$table->tableBlock_draw($contents),
            ]);
            $ret_abh = stepwise::getSV('retoure','abholung');
            $isRetoure = ($ret_abh !== null) ? ($ret_abh=='1'):false;
            if(!$isRetoure and in_array($type,[2,3])){
                $smarty->assign('RUECKBUCHEN',1);
                $branches_array = array();
                foreach(main::get_branches() as $branch){
                    $branches_array[] = $branch;
                }
                $smarty->assign(array(
                    'INPUT_RUECKBUCH_BRANCHES_ID'=> xtc_draw_pull_down_menu('rueckbuch[rueckbuch_branches_id]', $branches_array,$_SESSION['allocated_branches_id']),
                    'BRANCHES_NUM'=>sizeOf($branches_array)
                ));
            }
        }elseif($block=='retoure'){// end if step 1
            $block_fields = [
                'shipping_company'=>[
                    'default'=>$order->delivery['company'],
                    'title'=>$config_vars['company'],
                ],
                'shipping_name'=>[
                    'default'=>$order->delivery['name'],
                    'title'=>$config_vars['name'],
                ],
                'shipping_name2'=>[
                    'default'=>'',
                    'title'=>$config_vars['name_2'],
                ],
                'shipping_street'=>[
                    'default'=>$order->delivery['street_address'],
                    'title'=>$config_vars['street'],
                ],
                'shipping_street2'=>[
                    'default'=>$order->delivery['suburb'],
                    'title'=>$config_vars['suburb'],
                ],
                'shipping_postcode'=>[
                    'default'=>$order->delivery['postcode'],
                    'title'=>$config_vars['postcode'],
                ],
                'shipping_city'=>[
                    'default'=>$order->delivery['city'],
                    'title'=>$config_vars['city'],
                ],
                'shipping_country_id'=>[
                    'default'=>$order->delivery['country_id'],
                    'title'=>$config_vars['country'],
                ]
            ];
            $address_input_fields = [];
            foreach($block_fields as $bfk=>$bf){
                switch($bfk){
                    case 'shipping_country_id':
                        $def = $bf['default'];
                        $address_input_fields[] = [
                            'title'=>$bf['title'],
                            'input'=>xtc_draw_pull_down_menu('retoure['.$bfk.']',xtc_get_countries(), $def ),
                        ];
                        break;
                    default:
                        $def = $bf['default'];
                        $address_input_fields[] = [
                            'title'=>$bf['title'],
                            'input'=>xtc_draw_input_field('retoure['.$bfk.']',$def)
                        ];
                        break;
                }
            }
            
            if(in_array($type,[2,3,4])){
                $ret_abh = stepwise::getSV('retoure','abholung');
                $def = ($ret_abh !== null) ? ($ret_abh=='1'):false;
                $costs_tk = stepwise::getSV('costs','transportkosten');
                $def_tk = ($costs_tk !== null)?number_format((float)$costs_tk,2,'.',''):'0.00';
                $ret_vers = stepwise::getSV('retoure','data');
                $def_vers = ($ret_vers !== null)?$ret_vers['versender']:'';
                $smarty->assign([
                    'INPUT_ABHOLUNG'=>xtc_draw_checkbox_field('abholung','1',$def),
                    'TEXT_ADDORDER_ABHOLUNG'=>TEXT_ADDORDER_ABHOLUNG,
                    'INPUT_TRANSPORTKOSTEN'=>xtc_draw_input_field('transportkosten',$def_tk,'min="0.00" step="0.01"',false,'number'),
                    'INPUT_VERSENDER'=>xtc_draw_pull_down_menu('retoure[versender]',$vers_array,$def_vers),
                    'ADDRESS_INPUT'=>$address_input_fields
                ]);
            }else{
                $smarty->assign([
                    'INPUT_ABHOLUNG'=>$config_vars['text_no_retoure'],
                ]);
            }
        }elseif($block == 'rueckerstattung'){
            $konto_fields = [
                [
                    'title'=>$config_vars['kto_nummer'],
                    'input'=>xtc_draw_input_field('rueckerstattung[kto_nummer]','','size="25"'),
                ],[
                    'title'=>$config_vars['kto_inhaber'],
                    'input'=>xtc_draw_input_field('rueckerstattung[kto_inhaber]','','size="25"'),
                ],[
                    'title'=>$config_vars['kto_blz'],
                    'input'=>xtc_draw_input_field('rueckerstattung[kto_blz]','','size="25"'),
                ],[
                    'title'=>$config_vars['kto_bank'],
                    'input'=>xtc_draw_input_field('rueckerstattung[kto_bank]','','size="25"'),
                ],[
                    'title'=>$config_vars['kto_iban'],
                    'input'=>xtc_draw_input_field('rueckerstattung[kto_iban]','','size="25"'),
                ],[
                    'title'=>'SWIFT',
                    'input'=>xtc_draw_input_field('rueckerstattung[kto_swift]','','size="25"'),
                ]
            ];
            
            if($order->customer['ID'] != KASSE_USER){
                    $smarty->assign('SAVE_KTO',xtc_draw_checkbox_field('rueckerstattung[save_kto]','1',false));
            }
            
            $smarty->assign([
                'KONTO_FIELDS'=>$konto_fields,
                'INPUT_BETRAG'=>xtc_draw_input_field('rueckerstattung[kto_betrag]',number_format((float)str_replace(',','.',$_POST['kto_betrag']),2,',',''),'min="0.00" step="0.01"',false,'number').' '.$order->info['currency'],
                'INPUT_GRUND'=>xtc_draw_textarea_field('rueckerstattung[grund]','virtual',40,4,''),
                'INPUT_RUECKERSTATTUNG'=>xtc_draw_pull_down_menu('rueckerstatten', xtc_get_rueckerstattungen_types(), 1),
                'JS_ERROR_NO_KONTO'=>JS_ERROR_NO_KONTO,
                'BARPAYMENT'=>xtc_draw_radio_field('rueckerstattung[payment_finished]','1',false ),
                'NOBARPAYMENT'=>xtc_draw_radio_field('rueckerstattung[payment_finished]','0',true ),
            ]);
        }elseif($block == 'shipping'){
            /*
            $versender_proposal = '';
            $versender_field = xtc_draw_pull_down_menu('shipping[versender_proposal]',
                \YES4Trade\Model\shipper_profiles::get_selection_list(),
                $versender_proposal
            );
            $smarty->assign([
                'INPUT_SEND1'=> xtc_draw_radio_field('send','1',true),
                'INPUT_SEND2'=> xtc_draw_radio_field('send','0',false),
                'INPUT_SHIPPINGCOSTS'=>xtc_draw_input_field('shipping[shippingcosts]','0.00','min="0.00" step="0.01"',false,'number'),
                'INPUT_SHIPPER'=>$versender_field,
            ]);*/
        }elseif($block == 'costs'){
            $reclamations_reasons_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
            $rritems = \YES4Trade\Model\reclamations_reasons::get_all('reason');
            foreach($rritems as $rrit){
                $reclamations_reasons_array[] = array(
                    'id'=>$rrit->reclamations_reasons_id,
                    'text'=>$rrit->reason
                );
            }
            if(sizeOf($reclamations_reasons_array)>1){
                $rrID = '';
                $smarty->assign('INPUT_RECLAMATIONS_REASONS',xtc_draw_pull_down_menu('reclamations_reasons_id',$reclamations_reasons_array,$rrID));
            }
            $ret_reason = stepwise::getSV('info','reclamations_reasons_id');
            $rr = \YES4Trade\Model\reclamations_reasons::get_by_reclamations_reasons_id((int)$ret_reason);
            $default_comment = sprintf($config_vars['text_rueckerstattung_default_comment'], 
                xtc_get_reclamations_types_name($type),
                $oID
            );
            $smarty->assign([
                'INPUT_COMMENTS'=> xtc_draw_textarea_field('comments','virtual',40,4,$default_comment),
                'INPUT_REPAIRCOSTS'=>xtc_draw_input_field('repaircosts','0.00','min="0.00" step="0.01"',false,'number'),
                'INPUT_EDITFEE'=>xtc_draw_input_field('bearbeitungsgebuehr','0.00','min="0.00" step="0.01"',false,'number'),
            ]);
        }
        $smarty->assign([
            'BLOCK'=>$block
        ]);
        $smarty->display('stepwise.reclamation.html');
        exit;
        break;
    case 'update_qty_process':
        $rpID = (int)xtc_db_input($_GET['rpID']);
        $rID = (int)xtc_db_input($_GET['rID']);
        $target_qty = (int)xtc_db_input($_POST['quantity']);
        $reclamation = new reclamation($rID);
        foreach($reclamation->products as $rproduct){
            if($rproduct['rpID'] == $rpID){
                $rp = $rproduct;
                break;
            }
        }
        if($rp['qty']<$target_qty){
            $messageStack->add_session(sprintf(MSG_ERROR_INVALID_RP_QUANTITY,
                 $target_qty, $rp['qty']
            ),'error');
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','rpID']).'action=edit'));
        }elseif($target_qty == 0){
            xtc_db_query(sprintf(
                "DELETE FROM reclamations_products WHERE reclamations_products_id='%d'",
                $rpID
            ));
            xtc_db_query(sprintf(
                "DELETE FROM reclamations_products WHERE reclamations_products_id='%d'",
                $rpID
            ));
            xtc_db_query(sprintf(
                "DELETE FROM reclamations_products_properties WHERE reclamations_products_id='%d'",
                $rpID
            ));
            $comments = sprintf(HISTORY_RECLAMATIONS_PRODUCTS_DELETED,
                    $rpID, $rp['id'],$rp['name'],$rp['qty']
            );
            $reclamation->add_history($reclamation->info['reclamations_status'], false, $comments);
            $reclamation->recalc();
            $messageStack->add_session($comments,'success');
            xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','rpID']).'action=edit'));
        }
        $num_to_delete = (int)($rp['qty']-$target_qty);
        $update_sql_array = [
            'products_quantity'=>$target_qty,
        ];
        xtc_db_perform('reclamations_products',$update_sql_array,'update',
                sprintf("reclamations_products_id='%d'",$rpID)
        );
        $history = sprintf(MSG_SUCCESS_RP_QUANTITY_UPDATE,
                $rpID,$rp['id'],$rp['qty'],$target_qty
        );
        $messageStack->add_session($history,'success');
        $reclamation->add_history($reclamation->info['reclamations_status'], false, $history);
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action','rpID']).'action=edit'));
        break;
    case 'update_qty':
        $rpID = (int)xtc_db_input($_GET['rpID']);
        $rID = (int)xtc_db_input($_GET['rID']);
        $reclamation = new reclamation($rID);
        if(!in_array($reclamation->info['reclamations_status'],[1,2])){
            die(sprintf('<div class="ui-state-error">%s</div>',
                TEXT_RECLAMATIONS_PRODUCTS_EDIT_INVALID_STATUS
            ));
        }
        foreach($reclamation->products as $rproduct){
            if($rproduct['rpID'] == $rpID){
                $rp = $rproduct;
                break;
            }
        }
        echo xtc_draw_form('sn_qty',basename(__FILE__),xtc_get_all_get_params(['action']).'action=update_qty_process');
        $qty_values = [];
        for($i=0;$i<=$rp['qty'];$i++){
            $qty_values[] = [
                'id'=>$i,
                'text'=>$i
            ];
        }
        echo 'Von '.$rp['qty'].' auf '.xtc_draw_pull_down_menu('quantity', $qty_values,$rp['qty'],'onchange="javascript:quantity_selection()"');
        echo '</form>';
        exit;
        break;
    case 'update_products_name':
        $rpID = (int)xtc_db_input($_GET['rpID']);
        $rID = (int)xtc_db_input($_GET['rID']);
        $update_sql_array = array(
            'products_name'=>urldecode($_GET['products_name']),
        );
        xtc_db_perform('reclamations_products',$update_sql_array,'update',"reclamations_products_id='".$rpID."'");
        $comments = sprintf(TEXT_HISTORY_PRODUCTS_NAME_UPDATED,urldecode($_GET['products_name']));
        $reclamation = new reclamation($rID);
        $reclamation->add_history($reclamation->info['reclamations_status'], false, $comments);
        die(json_encode(array(
            'MSG'=>''
        )));
    case 'update_costs':
        if(!isset($_GET['rID'])){
            die('Missing params');
        }
        $rID = (int)xtc_db_input($_GET['rID']);
        $reclamation = new reclamation($rID);
        $diff_classes = [];
        $new_items = [];
        foreach($costs_groups as $cg){
            $diff_classes[] = sprintf("'%s'",$cg['ot_class']);
            $post_value = (isset($_POST[ $cg['ot_class'] ]))?(float)str_replace(',','.',$_POST[ $cg['ot_class'] ]):0;
            if( $post_value > 0){
                $new_items[ $cg['ot_class'] ] = [
                    'value'=>$post_value,
                    'title'=>$cg['title'],
                    'sort_order'=>$cg['sort_order'],
                ];
            }
        }
        xtc_db_query(sprintf(
            "DELETE FROM reclamations_total WHERE `class` IN(%s)",
            implode(',',$diff_classes)
        ));
        $summaries = [];
        if(sizeOf($new_items)){
            foreach($new_items as $nk=>$ni){
                $insert_sql_array = [
                    'class'=>$nk,
                    'reclamations_id'=>$rID,
                    'title'=>$ni['title'],
                    'value'=>$ni['value'],
                    'text'=>number_format($ni['value'],2,',','').' '.$reclamation->info['currency'],
                    'sort_order'=>$ni['sort_order']
                ];
                xtc_db_perform('reclamations_total',$insert_sql_array);
                $summaries[] = sprintf('%s: %s',$ni['title'],$insert_sql_array['text']);
            }
        }
        if(sizeOf($summaries)){
            $summary = implode(', ',$summaries);
        }else{
            $summary = HISTORY_ALL_COSTS_DELETED;
        }
	$reclamation->add_history($reclamation->info['reclamations_status'],0,MSG_SUCCESS_RECLAMATION_UPDATED.' - '.$summary);
        
        $reclamation = new reclamation($rID);
        $reclamation->recalc();
        $messageStack->add_session(MSG_SUCCESS_RECLAMATION_UPDATED,'success');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action']).'action=edit'));
        break;
    case 'edit_costs':
        if(!isset($_GET['rID'])){
            die('Missing params');
        }
        $rID = (int)xtc_db_input($_GET['rID']);
        $reclamation = new reclamation($rID);
        printf('%s<fieldset><legend>%s</legend>',
            xtc_draw_form('costs_form',basename(__FILE__),xtc_get_all_get_params(['action']).'action=update_costs','POST','onsubmit="return false;"'),
            TEXT_EDIT_RECLAMATION_COSTS
        );
        foreach($costs_groups as $cg){
            $cg_val = 0;
            foreach($reclamation->totals as $rt){
                if($rt['class'] == $cg['ot_class']){
                    $cg_val += $rt['value'];
                }
            }
            printf('<label for="input_%s">%s<br /></label>%s<br />',
                    $cg['ot_class'],
                    $cg['title'],
                    xtc_draw_input_field($cg['ot_class'],number_format($cg_val,2,',',''),'class="cost" id="input_'.$cg['ot_class'].'"')
            );
        }
        printf('<input onclick="reclamation_costs_edit_submit_check(this)" type="button" value="%s" class="ui-button ui-corner-all ui-state-default"/></fieldset></form>',
            IMAGE_SAVE
        );
        exit;
        break;
    case 'products_fake_set_export':
        require_once(DIR_WS_CLASSES.'class.basics.php');
        require_once(DIR_WS_CLASSES.'class.csv.php');
        require_once(DIR_FS_INC.'YES_PAYMODULE_products_fake_sets_csv_export.inc.php');
        $basics = new basics;
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $reclamation = new reclamation($rID);
        $filename = \main::get_exportdata_path().'FAKESET_EXPORT_REKLA_'.$rID.'.csv';
        $shippings_array = array('OTC'=>array(array('reclamations_id'=>$rID)));
        $fn = YES_PAYMODULE_products_fake_sets_csv_export($shippings_array,$filename);
        if($fn != ''){
            $basics->download_file($filename);
            exit;
        }
        $messageStack->add_session('Keine Fake Sets exportierbar');
        xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action')).'action=edit'));
        exit;
        break;
    case 'ajax_address_save':	    
            $rID = (int)xtc_db_input($_REQUEST['rID']);
            $json_array = array();
            $address_str = array();
            $reclamation = new reclamation($rID);
            $prefix = $reclamation->get_update_address_part_prefix($_REQUEST['address_type']);
            foreach($_REQUEST as $key=>$val){
                    if(!strstr($key,$prefix) or $key == 'update_customers_name'){
                            continue;
                    }
                    $address_str[] = xtc_db_prepare_input(yes_decode_string($key.': '.$val));
            }
            $address_str = implode(',',$address_str);

            $update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'',false);

            $reclamation->update_address_part($update_sql_array);
            $json_array = $update_sql_array;
            // v2 Versandmodul
            if(isset($_GET['address_type']) and $_GET['address_type'] == 'shipping'){
                $record = main::get_country_values($_GET['delivery_country']);
                $json_array[ 'delivery_country_code' ] = $record['countries_iso_code_2'];
            }
            if(isset($_REQUEST['update_customers_name']) and $_REQUEST['update_customers_name'] == 1){
                $lastname = '';
                $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
                foreach($name_parts as $np){
                        if(!isset($firstname)){
                                $firstname = $np;
                                continue;
                        }
                        $lastname .= $np .' ';
                }
                $lastname = trim($lastname);
                $update_sql_array = array(
                    'customers_firstname'=>yes_decode_string($firstname),
                    'customers_lastname'=>yes_decode_string($lastname),
                    'customers_last_modified'=>'now()'
                );
                xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$reclamation->customer['ID']."'");
                $new = new \YES4Trade\Model\customers_memo([
                    'customers_id'=>(int)$reclamation->customer['ID'],
                    'memo_date'=>date('Y-m-d H:i:s'),
                    'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
                    'memo_text'=>sprintf(TEXT_ADDRESS_UPDATE_CUSTOMERS_MEMO_TEXT,$reclamation->info['id'],$firstname.' '.$lastname),
                    'poster_id'=>(int)$_SESSION['customer_id']
                ]);
                $new->create();
                $firstname = '';
            }


            if(isset($_REQUEST['copy_customer']) and $_REQUEST['copy_customer'] == 1){
                    $update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'customer');
                    $reclamation->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }

            if(isset($_REQUEST['copy_shipping']) and $_REQUEST['copy_shipping'] == 1){
                    $update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'shipping');
                    $reclamation->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }

            if(isset($_REQUEST['copy_invoice']) and $_REQUEST['copy_invoice'] == 1){
                    $update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'invoice');
                    $reclamation->update_address_part($update_sql_array);
                    $json_array = xtc_array_merge($json_array,$update_sql_array);
            }
            $query = xtc_db_query(sprintf(
                    "SELECT entry_gender FROM %s ab LEFT JOIN %s c ON ab.address_book_id=c.customers_default_address_id WHERE c.customers_id='%s' AND ab.customers_id=c.customers_id",
                    TABLE_ADDRESS_BOOK,TABLE_CUSTOMERS,$reclamation->customer['ID']
            ));
            $record = xtc_db_fetch_array($query);
            $entry_gender = $record['entry_gender'];
            if(isset($_REQUEST['ab_action']) and ($_REQUEST['ab_action'] == 'copy_as' or $_REQUEST['ab_action'] == 'update')){
                if(isset($_REQUEST['customers_telephone']) and !empty($_REQUEST['customers_telephone'])){
                    xtc_db_query(sprintf(
                            "UPDATE %s SET customers_telephone='%s',customers_last_modified=now() WHERE customers_id='%s'",
                            TABLE_CUSTOMERS,
                            xtc_db_input($_REQUEST['customers_telephone']),
                            $reclamation->customer['ID']
                    ));
                    $new = new \YES4Trade\Model\customers_memo([
                        'customers_id'=>(int)$reclamation->customer['ID'],
                        'memo_date'=>date('Y-m-d H:i:s'),
                        'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
                        'memo_text'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TEXT,
                        'poster_id'=>(int)$_SESSION['customer_id']
                    ]);
                    $new->create();
                }
            }
            switch($_REQUEST['ab_action']){
                    case 'copy_as':
                            $ab_address_class = xtc_db_input($_REQUEST['ab_address_class']);

                            if($ab_address_class != ''){
                                \YES4Trade\Model\address_book::update_address_class_to_empty_by_address_class_and_customers_id(
                                    $ab_address_class,$reclamation->customer['ID']
                                );
                            }

                            $lastname = '';
                            $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
                            foreach($name_parts as $np){
                                    if(!isset($firstname)){
                                            $firstname = $np;
                                            continue;
                                    }
                                    $lastname .= $np .' ';
                            }
                            $lastname = trim($lastname);
                            $new = new \YES4Trade\Model\address_book([
                                'customers_id'=>(int)$reclamation->customer['ID'],
                                'entry_gender'=>$entry_gender,
                                'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
                                'entry_firstname'=>yes_decode_string($firstname),
                                'entry_lastname'=>yes_decode_string($lastname),
                                'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
                                'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
                                'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
                                'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
                                'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
                                'entry_country_id'=> (int)$_REQUEST[$prefix.'country'],
                                'address_class'=>$ab_address_class,
                                'address_date_added'=>date('Y-m-d H:i:s')
                            ]);
                            $new->create();
                            break;
                    case 'update':
                            $ab_address_book_id = xtc_db_input($_REQUEST['ab_address_book_id']);
                            $lastname = '';
                            $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
                            foreach($name_parts as $np){
                                    if(!isset($firstname)){
                                            $firstname = $np;
                                            continue;
                                    }
                                    $lastname .= $np .' ';
                            }
                            $lastname = trim($lastname);
                            $upd = new \YES4Trade\Model\address_book([
                                'address_book_id'=>(int)$ab_address_book_id,
                                'entry_gender'=>$entry_gender,
                                'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
                                'entry_firstname'=>yes_decode_string($firstname),
                                'entry_lastname'=>yes_decode_string($lastname),
                                'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
                                'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
                                'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
                                'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
                                'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
                                'entry_country_id'=> (int)$_REQUEST[$prefix.'country'],
                                'address_last_modified'=>date('Y-m-d H:i:s'),
                            ]);
                            $upd->update();
                            break;
            }
            $reclamation->add_history($reclamation->info['reclamations_status'], false, sprintf(HISTORY_ADDRESS_CHANGE,$_REQUEST['address_type'],$address_str));
            $reclamation = new reclamation($rID);
                $address = xtc_address_format(5, $reclamation->delivery, true, "", "<br />");
                if($reclamation->delivery['telephone'] != ''){
                    $address .= "<br />&#9742; ".$reclamation->delivery['telephone'];
                }
                if($reclamation->info['mobile'] != ''){
                    $address .= "<br />&#9742; ".$reclamation->customer['mobile'];
                }
                if($reclamation->delivery['email_address'] != ''){
                    $address .= "<br />&#x1f4e7; ".$reclamation->delivery['email_address'];
                }
                $json_array[ 'delivery_address_for_shipping' ] = $address;


            $json = array();
            foreach($json_array as $k=>$v){
                    $json[$k]=xtc_db_prepare_input(yes_encode_string($v));
            }
            header('Content-Type: text/html; charset='.CHARSET);
            die(json_encode(array(
              'UPDATE_ARRAY'=>$json,
                'ADDRESS_TYPE'=>$_REQUEST['address_type']
            )));
            exit;
            break;
    case 'ajax_address_edit':
        require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
        $reclamation = new reclamation((int)xtc_db_input($_REQUEST['rID']));
?>
<script type="text/javascript">
$().ready(function(){
    var _url = window.location.pathname;
    var _filename = _url.substring(_url.lastIndexOf('/')+1);
	$('#address_update_button').click(function(){
		$.ajax({
			url: $('form#ajax_address_edit').attr('action'),
			dataType: 'json',
			data: $('form#ajax_address_edit').serialize(),
			success: function(json){
                            for(var element in json.UPDATE_ARRAY){
                                    switch(element){
                                            case 'customers_telephone':
                                            case 'customers_mobile':
                                            case 'customers_vat_id':
                                                    $('td#'+element).html(json.UPDATE_ARRAY[element]);
                                                    break;
                                            default:
                                                    $('table#address_table td#'+element).html(json.UPDATE_ARRAY[element]);
                                                    break;
                                    }
                            }
                            oe_help_key = json.ADDRESS_TYPE;
                            switch(json.ADDRESS_TYPE){
                                case 'shipping':
                                    oe_help_key = 'delivery';
                                    break;
                                case 'invoice':
                                    oe_help_key = 'billing';
                                    break;
                                case 'customer':
                                    oe_help_key = 'customers';
                                    break;
                            }
                            $('table#address_table td#'+oe_help_key+'_postcode_city').html(json.UPDATE_ARRAY[oe_help_key+'_postcode']+' '+json.UPDATE_ARRAY[oe_help_key+'_city']);
			    $('#modal_window').dialog('destroy');
			},
			error: function(xhr, ajaxOptions, thrownError){
				alert(xhr+' '+thrownError);
			}
		});
	});
});
</script>
<?php
	$copy_list = array(
		'customer'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER,
		'shipping'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY,
		'invoice'=>TEXT_ADDRESS_BOOK_CLASS_BILLING
	);
	echo '<div class="main">';
	echo xtc_draw_form('ajax_address_edit',basename(__FILE__),xtc_get_all_get_params(array('action')).'action=ajax_address_save','POST','onsubmit="return false;" id="ajax_address_edit"');
	echo '<fieldset>';
	printf('<legend>%s</legend>',TEXT_EDIT_ADDRESS);
	switch($_REQUEST['address_type']){
		case 'customer':
			$sql_prefix = 'customers_';
			break;
		case 'shipping':
			$sql_prefix = 'delivery_';
			break;
		case 'invoice':
			$sql_prefix = 'billing_';
			break;
	}
	$fields = array(
		$sql_prefix.'company',
		$sql_prefix.'name',
		$sql_prefix.'street_address',
		$sql_prefix.'suburb',
		$sql_prefix.'postcode',
		$sql_prefix.'city',
		$sql_prefix.'state',
		$sql_prefix.'country'
	);
	switch($_REQUEST['address_type']){
		case 'customer':
			$fields[] = $sql_prefix.'vat_id';
			$fields[] = $sql_prefix.'telephone';
//			$fields[] = $sql_prefix.'mobile';
			break;
	}
	
	
	$query = xtc_db_query(sprintf("SELECT %s FROM %s WHERE reclamations_id='%s'",
			implode(',',$fields),'reclamations',xtc_db_input($_REQUEST['rID'])
	));
	$record = xtc_db_prepare_input(xtc_db_fetch_array($query));
	$countries = xtc_get_countries( $default='',$utf8=true );
        $db_ini = yes_get_database_table_ini();
	foreach($record as $key=>$value){
		$label = constant('TEXT_FIELD_'.strtoupper( substr($key,strlen($sql_prefix),strlen($key)) ));
		$size = 32;
		switch($key){
			case 'customers_country':
			case 'delivery_country':
			case 'billing_country':
				$country_data = xtc_get_country_data_from_name($value);
				$field = xtc_draw_pull_down_menu($key, $countries, $country_data['countries_id'], 'id="'.$key.'"');
				break;
			case 'customers_postcode':
			case 'shipping_postcode':
			case 'billing_postcode':
				$size = 6;
				$field = xtc_draw_input_field($key,yes_encode_string($value),'id="'.$key.'" size="'.$size.'"');
				break;
			default:
                            $current_size = $size;
                            $max_length = $current_size;
                            if(yes_get_database_table_field_length($db_ini, 'reclamations', $key) > $size){
                                $current_size = yes_get_database_table_field_length($db_ini, 'reclamations', $key);
                                if($current_size > 64){
                                    $max_length = $current_size;
                                    $current_size = 64;
                                }
                            }
                            $field = xtc_draw_input_field($key,$value,'id="'.$key.'" size="'.$current_size.'" maxlength="'.$max_length.'"');
				break;
		}
		printf('<label for="%s"><b>%s:</b></label><br />%s<br />',$key,$label,$field);
	}
	printf('<hr noshade="noshade" /><p>%s<br />',TEXT_COPY_ADDRESSTYPES_INTRO);
	foreach($copy_list as $copy=>$copy_text){
		if($copy != $_REQUEST['address_type']){
			printf('<input type="checkbox" name="copy_%s" value="1" />%s<br />',$copy,$copy_text);
		}
	}
	echo '</p>';
	$query = xtc_db_query(sprintf(
			"SELECT customers_default_address_id FROM %s WHERE customers_id='%s'",
			TABLE_CUSTOMERS,
			$reclamation->customer['ID']
	));
	$record = xtc_db_fetch_array($query);
	$customers_default_address_id = $record['customers_default_address_id'];
        $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$reclamation->customer['ID']);
	$ab_entries = array();
	$ab_classes = array(
		array('id'=>'','text'=>yes_decode_string(TEXT_NONE)),
		array('id'=>'customer','text'=>TEXT_ADDRESS_BOOK_CLASS_CUSTOMER),
		array('id'=>'delivery','text'=>TEXT_ADDRESS_BOOK_CLASS_DELIVERY),
		array('id'=>'billing','text'=>TEXT_ADDRESS_BOOK_CLASS_BILLING)
	);
	foreach($items as $it){
            $record = $it->toArray();
            $text = yes_encode_string($record['entry_firstname'].' '.$record['entry_lastname'].', '.$record['entry_city']);
            if($record['address_class'] != ''){
                switch($record['address_class']){
                    case 'customer':
                            $aclass = TEXT_ADDRESS_BOOK_CLASS_CUSTOMER;
                            break;
                    case 'delivery':
                            $aclass = TEXT_ADDRESS_BOOK_CLASS_DELIVERY;
                            break;
                    case 'delivery':
                            $aclass = TEXT_ADDRESS_BOOK_CLASS_BILLING;
                            break;

                }
                $text = $aclass.': '.$text;
            }
            if($customers_default_address_id == $record['address_book_id']){
                    $text .= ' (Default)';
            }
            $ab_entries[] = array(
                    'id'=>$record['address_book_id'],
                    'text'=>$text
            );
	}
	
	printf('<hr noshade="noshade" /><p>%s<br />',TEXT_COPY_ADDRESSBOOK_INTRO);
	echo xtc_draw_radio_field('ab_action','',true).' '.TEXT_COPY_ADDRESSBOOK_NO_ACTION.'<br />';
	$default_ab_address_class = '';
	switch($_REQUEST['address_type']){
            default:
                $default_ab_address_class = $_REQUEST['address_type'];
                break;
            case 'shipping':
                $default_ab_address_class = 'delivery';
                break;
            case 'invoice':
                $default_ab_address_class = 'billing';
                break;
	}
	
	if(KASSE_USER != $reclamation->customer['ID']){
	    $select = xtc_draw_pull_down_menu('ab_address_class', $ab_classes, $default_ab_address_class);
            echo xtc_draw_radio_field('ab_action','copy_as',false).' '.TEXT_COPY_ADDRESSBOOK_COPY_AS.' '.$select.'<br />';
            $select = xtc_draw_pull_down_menu('ab_address_book_id', $ab_entries,$customers_default_address_id);
            echo xtc_draw_radio_field('ab_action','update',false).' '.TEXT_COPY_ADDRESSBOOK_REPLACE.' '.$select.'<br />';
	    echo '</p>';
	    echo '<hr noshade="noshade" />';
	    echo xtc_draw_checkbox_field('update_customers_name', 1, false).' '.TEXT_UPDATE_CUSTOMERS_NAME.'<br />';
	}
	echo '<hr noshade="noshade" />';
	echo '<input type="button" class="ui-button ui-corner-all ui-state-default" value="'.IMAGE_SAVE.'" id="address_update_button" />';
	echo '</fieldset>';
	echo '</form>';
	echo '</div>';
	exit;
        break;
    case 'delete':
	if(!isset($_REQUEST['rID']) or $_REQUEST['rID'] < 1){
	    die('Missing params');
	}
	$r = new reclamation((int)xtc_db_input($_REQUEST['rID']));
	if(!$r->check_delete()){
	   $messageStack->add_session(sprintf(MSG_ERROR_DELETE_RECLAMATION,$_REQUEST['rID']),'error');
	}else{
	    $r->delete();
	   $messageStack->add_session(sprintf(MSG_SUCCESS_DELETE_RECLAMATION,$_REQUEST['rID']),'error');
	}
	xtc_redirect(xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('rID','action'))));
	break;
    case 'ajax_address_save':	    
		$reclamations_id = (int)xtc_db_input($_REQUEST['rID']);
		$json_array = array();
		$address_str = array();
		$reclamation = new reclamation($reclamations_id);
		$prefix = $reclamation->get_update_address_part_prefix($_REQUEST['address_type']);
		foreach($_REQUEST as $key=>$val){
			if(!strstr($key,$prefix) or $key == 'update_customers_name'){
				continue;
			}
			$address_str[] = $key.': '.$val;
		}
		$address_str = implode(',',$address_str);
		
		$update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'',false);
		
		$reclamation->update_address_part($update_sql_array);
		$json_array = $update_sql_array;
		if(isset($_REQUEST['update_customers_name']) and $_REQUEST['update_customers_name'] == 1){
		    $lastname = '';
		    $name_parts = explode(' ',$_REQUEST[$prefix.'name']);
		    foreach($name_parts as $np){
			    if(!isset($firstname)){
				    $firstname = $np;
				    continue;
			    }
			    $lastname .= $np .' ';
		    }
		    $lastname = trim($lastname);
		    $update_sql_array = array(
			'customers_firstname'=>yes_decode_string($firstname),
			'customers_lastname'=>yes_decode_string($lastname),
			'customers_last_modified'=>'now()'
		    );
		    xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$reclamation->customer['ID']."'");
		    $new = new \YES4Trade\Model\customers_memo([
			'customers_id'=>(int)$reclamation->customer['ID'],
			'memo_date'=>date('Y-m-d H:i:s'),
			'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
			'memo_text'=>sprintf(TEXT_ADDRESS_UPDATE_CUSTOMERS_MEMO_TEXT,$reclamation->info['id'],$firstname.' '.$lastname),
			'poster_id'=>(int)$_SESSION['customer_id']
		    ]);
		    $new->create();
		    $firstname = '';
		}
		    
		
		if(isset($_REQUEST['copy_customer']) and $_REQUEST['copy_customer'] == 1){
			$update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'customer');
			$reclamation->update_address_part($update_sql_array);
			$json_array = xtc_array_merge($json_array,$update_sql_array);
		}
		
		if(isset($_REQUEST['copy_shipping']) and $_REQUEST['copy_shipping'] == 1){
			$update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'shipping');
			$reclamation->update_address_part($update_sql_array);
			$json_array = xtc_array_merge($json_array,$update_sql_array);
		}
		
		if(isset($_REQUEST['copy_invoice']) and $_REQUEST['copy_invoice'] == 1){
			$update_sql_array = $reclamation->get_address_part_sql($_REQUEST['address_type'], $_REQUEST,'invoice');
			$reclamation->update_address_part($update_sql_array);
			$json_array = xtc_array_merge($json_array,$update_sql_array);
		}
		$query = xtc_db_query(sprintf(
			"SELECT entry_gender FROM %s ab LEFT JOIN %s c ON ab.address_book_id=c.customers_default_address_id WHERE c.customers_id='%s' AND ab.customers_id=c.customers_id",
			TABLE_ADDRESS_BOOK,TABLE_CUSTOMERS,$reclamation->customer['ID']
		));
		$record = xtc_db_fetch_array($query);
		$entry_gender = $record['entry_gender'];
		if(isset($_REQUEST['ab_action']) and ($_REQUEST['ab_action'] == 'copy_as' or $_REQUEST['ab_action'] == 'update')){
		    if(isset($_REQUEST['customers_telephone']) and !empty($_REQUEST['customers_telephone'])){
			xtc_db_query(sprintf(
				"UPDATE %s SET customers_telephone='%s',customers_last_modified=now() WHERE customers_id='%s'",
				TABLE_CUSTOMERS,
				xtc_db_input($_REQUEST['customers_telephone']),
				$reclamation->customer['ID']
			));
			$new = new \YES4Trade\Model\customers_memo([
			    'customers_id'=>(int)$reclamation->customer['ID'],
			    'memo_date'=>date('Y-m-d H:i:s'),
			    'memo_title'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TITLE,
			    'memo_text'=>TEXT_ADDRESS_UPDATE_TELEPHONE_MEMO_TEXT,
			    'poster_id'=>(int)$_SESSION['customer_id']
			]);
			$new->create();
		    }
		    if(isset($_REQUEST['customers_mobile']) and !empty($_REQUEST['customers_mobile'])){
			xtc_db_query(sprintf(
				"UPDATE %s SET mobile='%s',customers_last_modified=now() WHERE customers_id='%s'",
				TABLE_CUSTOMERS,
				xtc_db_input($_REQUEST['customers_mobile']),
				$reclamation->customer['ID']
			));
			$new = new \YES4Trade\Model\customers_memo([
			    'customers_id'=>(int)$reclamation->customer['ID'],
			    'memo_date'=>date('Y-m-d H:i:s'),
			    'memo_title'=>TEXT_ADDRESS_UPDATE_MOBILE_MEMO_TITLE,
			    'memo_text'=>TEXT_ADDRESS_UPDATE_MOBILE_MEMO_TEXT,
			    'poster_id'=>(int)$_SESSION['customer_id']
			]);
			$new->create();
		    }
		}
		switch($_REQUEST['ab_action']){
			case 'copy_as':
				$ab_address_class = xtc_db_input($_REQUEST['ab_address_class']);
				
				if($ab_address_class != ''){
                                    \YES4Trade\Model\address_book::update_address_class_to_empty_by_address_class_and_customers_id(
                                            $ab_address_class,(int)$reclamation->customer['ID']
                                    );
				}
				
				$lastname = '';
				$name_parts = explode(' ',$_REQUEST[$prefix.'name']);
				foreach($name_parts as $np){
					if(!isset($firstname)){
						$firstname = $np;
						continue;
					}
					$lastname .= $np .' ';
				}
				$lastname = trim($lastname);
				$new = new \YES4Trade\Model\address_book([
                                    'customers_id'=>(int)$reclamation->customer['ID'],
                                    'entry_gender'=>$entry_gender,
                                    'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
                                    'entry_firstname'=>yes_decode_string($firstname),
                                    'entry_lastname'=>yes_decode_string($lastname),
                                    'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
                                    'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
                                    'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
                                    'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
                                    'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
                                    'entry_country_id'=>  (int)$_REQUEST[$prefix.'country'],
                                    'address_class'=>$ab_address_class,
                                    'address_date_added'=>date('Y-m-d H:i:s'),
				]);
				$new->create();
				break;
			case 'update':
				$ab_address_book_id = xtc_db_input($_REQUEST['ab_address_book_id']);
				$lastname = '';
				$name_parts = explode(' ',$_REQUEST[$prefix.'name']);
				foreach($name_parts as $np){
                                    if(!isset($firstname)){
                                        $firstname = $np;
                                        continue;
                                    }
                                    $lastname .= $np .' ';
				}
				$lastname = trim($lastname);
                                $upd = new \YES4Trade\Model\address_book([
                                    'address_book_id'=>(int)$ab_address_book_id,
                                    'entry_gender'=>$entry_gender,
                                    'entry_company'=>yes_decode_string($_REQUEST[$prefix.'company']),
                                    'entry_firstname'=>yes_decode_string($firstname),
                                    'entry_lastname'=>yes_decode_string($lastname),
                                    'entry_street_address'=>yes_decode_string($_REQUEST[$prefix.'street_address']),
                                    'entry_suburb'=>yes_decode_string($_REQUEST[$prefix.'suburb']),
                                    'entry_postcode'=>yes_decode_string($_REQUEST[$prefix.'postcode']),
                                    'entry_city'=>yes_decode_string($_REQUEST[$prefix.'city']),
                                    'entry_state'=>yes_decode_string($_REQUEST[$prefix.'state']),
                                    'entry_country_id'=> (int) $_REQUEST[$prefix.'country'],
                                    'address_last_modified'=>date('Y-m-d H:i:s'),
				]);
				$upd->update();
				break;
		}
		
		
		$json = array();
		foreach($json_array as $k=>$v){
			$json[$k]=yes_encode_string($v);
		}
		$reclamation->add_history($reclamation->info['reclamations_status'], false, sprintf(HISTORY_ADDRESS_CHANGE,$_REQUEST['address_type'],$address_str));
		header('Content-Type: text/html; charset='.CHARSET);
		die(json_encode(array(
		  'UPDATE_ARRAY'=>$json,
		    'ADDRESS_TYPE'=>$_REQUEST['address_type']
		)));
		exit;
		break;
    case 'edit_shipping_comments':
	$reclamations_id = (int)xtc_db_input($_REQUEST['reclamations_id']);
	$reclamation = new reclamation($reclamations_id);
	$smarty->assign(array(
	   'FORM' => xtc_draw_form($action,basename(__FILE__),'action=set_shipping_comments&reclamations_id='.$reclamations_id,'POST','onsubmit="return set_shipping_comments_check()"'),
	    'FORM_END' => '</form>',
	    'RECLAMATIONS_ID'=>$reclamations_id,
	    'FROM'=>(isset($_REQUEST['from'])) ? xtc_db_input($_REQUEST['from']) : '',
	    'INPUT_COMMENTS'=>  xtc_draw_textarea_field('shipping_comments', 'virtual', 50, 4,$reclamation->info['shipping_comments']),
	    'IMAGE_SAVE'=>IMAGE_SAVE,
	    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
	));
	header('Content-Type: text/html; charset='.CHARSET);
	$smarty->display('reclamations_edit_shipping_comments.html');
	exit;
	break;
    case 'set_shipping_comments':
        if(strstr($_REQUEST['reclamations_id'],'_')){
            $parts = explode('_',$_REQUEST['reclamations_id']);
            $reclamations_id = (int)xtc_db_input(current(array_reverse($parts)));
        }else{
            $reclamations_id = (int)xtc_db_input($_REQUEST['reclamations_id']);
        }
	$reclamation = new reclamation($reclamations_id);
	$shipping_comments = (isset($_REQUEST['shipping_comments'])) ? stripslashes(yes_decode_string($_REQUEST['shipping_comments'])) : '';
	$update_sql_array = array(
	    'shipping_comments'=>$shipping_comments,
	    'last_modified'=>'now()'
	);
	xtc_db_perform('reclamations',$update_sql_array,'update',"reclamations_id='".$reclamations_id."'");
	$reclamation->add_history($reclamation->info['reclamations_status'],false, 'ShippingComment: '.$shipping_comments);
	die(stripslashes($_REQUEST['shipping_comments']));
	break;
    case 'update_false_products_id':
        $pID = (int)xtc_db_input($_REQUEST['pID']);
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $fpID = (int)xtc_db_input($_REQUEST['false_products_id']);
        if($fpID == $pID){
            $messageStack->add_session(MSG_ERROR_FALSE_PRODUCTS_ID_SAME,'error');
            xtc_redirect(xtc_href_link('reclamations.php',xtc_get_all_get_params(array('false_products_id','pID','action'))));
        }
        $reclamation_query = xtc_db_query(sprintf(
            "SELECT reclamations_status FROM reclamations WHERE reclamations_id='%s'",
            $rID
        ));
        $reclamation = xtc_db_fetch_array($reclamation_query);
        xtc_db_query(sprintf(
            "UPDATE reclamations_products SET false_products_id='%d' WHERE products_id='%d' and reclamations_id='%d'",
            $fpID,$pID,$rID
        ));
                
        $comments = sprintf(TEXT_FALSE_PRODUCTS_ID_SAVED,$fpID,$pID);
        $new = new \YES4Trade\Model\reclamations_status_history([
            'reclamations_id'=>(int)$rID, 
            'reclamations_status_id'=>(int)$reclamation['reclamations_status'], 
            'date_added'=>date('Y-m-d H:i:s'),
            'customer_notified'=>0,
            'comments'=>$comments,
            'editor_id'=>(int)$_SESSION['customer_id']
        ]);
        $new->create();
		
        $messageStack->add_session($comments,'success');
        xtc_redirect(xtc_href_link('reclamations.php',xtc_get_all_get_params(array('false_products_id','action','edit_action','pID')).'action=edit'));
        break;
    case 'add_false_products_id':
        $pID = (int)xtc_db_input($_REQUEST['pID']);
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $reclamation = new reclamation($rID);
        if(!in_array($reclamation->info['reclamations_status'],[1,2])){
            die(sprintf('<div class="ui-state-error">%s</div>',
                TEXT_RECLAMATIONS_PRODUCTS_EDIT_INVALID_STATUS
            ));
        }
        header('Content-Type: text/html; charset='.CHARSET);
        echo '<div class="main">';
        echo xtc_draw_form('add_false_products_id',FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action')).'action=update_false_products_id');
        echo 'pID: '. xtc_draw_input_field('false_products_id','','size="8" maxlength="8"');
        echo '<input type="submit" value="'.IMAGE_SAVE.'" class="lbOn" />';
        echo '</div>';
        exit;
        break;
    case 'edit_false_products_id':
        $pID = (int)xtc_db_input($_REQUEST['pID']);
        $rID = (int)xtc_db_input($_REQUEST['rID']);
        $reclamation = new reclamation($rID);
        if(!in_array($reclamation->info['reclamations_status'],[1,2])){
            die(sprintf('<div class="ui-state-error">%s</div>',
                TEXT_RECLAMATIONS_PRODUCTS_EDIT_INVALID_STATUS
            ));
        }
        $fpID = (int)xtc_db_input($_REQUEST['false_products_id']);
        header('Content-Type: text/html; charset='.CHARSET);
        echo '<div class="main">';
        echo xtc_draw_form('edit_false_products_id',FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action')).'action=update_false_products_id');
        echo 'pID: '. xtc_draw_input_field('false_products_id',$fpID,'size="8" maxlength="8"');
        echo '<input class="ui-button ui-corner-all ui-state-default" type="submit" value="'.IMAGE_SAVE.'" />';
        echo '</div>';
        exit;
        break;
    case 'change_reclamations':
            $reclamationsID = xtc_db_prepare_input($_POST['statusRID']);
            $status = xtc_db_prepare_input($_GET['status']);
            $reclamations_status = xtc_db_prepare_input($_POST['reclamations_status']);
            if(is_array($reclamationsID) && count($reclamationsID)>0){
                foreach($reclamationsID as $k=>$rID){
                    if( xtc_not_null($rID) && $rID > 0 && xtc_not_null($reclamations_status) && $reclamations_status > 0) {
                        xtc_db_query("UPDATE reclamations SET reclamations_status='".$reclamations_status."',last_modified=now() WHERE reclamations_id='".$rID."'");
                        $new = new \YES4Trade\Model\reclamations_status_history([
                            'reclamations_id'=>(int)$rID,
                            'reclamations_status_id'=>(int)$reclamations_status, 
                            'date_added'=>date('Y-m-d H:i:s'),
                            'customer_notified'=>0,
                            'comments'=>TEXT_RECLAMATIONS_UPDATE_STATUS,
                            'editor_id'=>(int)$_SESSION['customer_id']
                        ]);
                        $new->create();
                        $messageStack->add_session(sprintf(MSG_SUCCESS_RECLAMATIONS_STATUS_UPDATE,$rID),'success');
                    }else{
                        $messageStack->add_session(sprintf(MSG_ERROR_RECLAMATIONS_STATUS_UPDATE,$rID),'error');
                    }
                }
                xtc_redirect(xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action'))));
            }
            break;
	case 'send_now':
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
                $rID = xtc_db_prepare_input($_GET['rID']);
                if( xtc_not_null($rID) && $rID > 0) {
                    xtc_db_query("UPDATE reclamations SET send_status='1',last_modified=now() WHERE reclamations_id='".$rID."'");
                    $reclamation = new reclamation($rID);
                    $reclamation->add_history($reclamation->info['reclamations_status'], 0, MSG_SUCCESS_RECLAMATIONS_TO_SHIPPING);
                    $messageStack->add_session('Die Reklamation '.$rID.' wurde im Versand verf&uuml;gbar gemacht.','success');
                }
            }else{
                $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
            }
            xtc_redirect(xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action'))));
            break;
	case 'send_block':
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
                $rID = xtc_db_prepare_input($_GET['rID']);
                if( xtc_not_null($rID) && $rID > 0) {
                    xtc_db_query("UPDATE reclamations SET send_status='0',last_modified=now() WHERE reclamations_id='".$rID."'");
                    $reclamation = new reclamation($rID);
                    $reclamation->add_history((int)$reclamation->info['reclamations_status'], 0, MSG_SUCCESS_RECLAMATIONS_DELETE_FROM_SHIPPING);
                    $messageStack->add_session(sprintf(TEXT_RECLAMATION_DELETE_FROM_SHIPPING,$rID),'success');
                }
            }else{
                $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
            }
            xtc_redirect(xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action'))));
            break;
        case 'set_block_shipping_confirm':
            $rID = xtc_db_input($_REQUEST['rID']);
            if($rID < 1){
                die('missing param');
            }
            $smarty->assign(array(
               'FORM' => xtc_draw_form($action,basename(__FILE__),'action=set_block_shipping&rID='.$rID,'POST','onsubmit="return set_block_shipping_check()"'),
                'FORM_END' => '</form>',
                'INPUT_COMMENTS'=>  xtc_draw_textarea_field('text', 'virtual', 40, 3),
                'INPUT_USE_DATE' => xtc_draw_checkbox_field('block_shipping_use_end_date','1'),
                'INPUT_DATE' => xtc_draw_input_field('block_shipping_end_date',date('Y-m-d',time()+(60*60*24*7) )),
                'IMAGE_SAVE'=>IMAGE_SAVE,
                'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf'
            ));
            header('Content-Type: text/html; charset='.CHARSET);
            $smarty->display('orders_set_block_shipping.html');
            exit;
            break;
	case "set_block_shipping":
            require_once(DIR_FS_INC.'xtc_checkdate.inc.php');
            require_once(DIR_FS_INC.'xtc_is_leap_year.inc.php');
            $referrer = (isset($_POST['referrer']))?$_POST['referrer']:'';
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
                $rID = (int)xtc_db_input($_GET['rID']);
                $text = xtc_db_input($_POST['text']);
                $block_shipping_end_date = (isset($_REQUEST['block_shipping_end_date'])) ? $_REQUEST['block_shipping_end_date'] : 0;
                if((isset($_REQUEST['block_shipping_use_end_date']) and $_REQUEST['block_shipping_use_end_date'] == 1) and !xtc_checkdate($block_shipping_end_date, 'yyyy-mm-dd', $date_array)){
                    $messageStack->add_session('Invalid date: '.$block_shipping_end_date,'error');
                }else{
                    $end_date = (isset($_REQUEST['block_shipping_use_end_date']) and $_REQUEST['block_shipping_use_end_date'] == 1) ? $block_shipping_end_date : '';
                    $reclamation = new reclamation($rID);
                    $update_sql_array = [
                        'block_shipping'=>1,
                        'block_shipping_comment'=>$text,
                        'block_shipping_end_date'=>$block_shipping_end_date,
                        'last_modified'=>'now()',
                    ];
                    xtc_db_perform('reclamations',$update_sql_array,'update',"reclamations_id='".$rID."'");
                    $messageStack->add_session(sprintf(MSG_SUCCESS_RECLAMATION_BLOCK_SHIPPING,$rID),'success');
                    $comm = sprintf(TEXT_RECLAMATION_BLOCK_SHIPPING,$text);
                    if($block_shipping_end_date != 0){
                        $comm .= ' (bis '.xtc_date_short($block_shipping_end_date).')';
                    }
                    $reclamation->add_history($reclamation->info['reclamations_status'],0,$comm);
                }
            }else{
                    $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
            }
            if($referrer != ''){
                xtc_redirect(urldecode($referrer));
            }
            xtc_redirect( xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action')).'action=edit'));
            break;
	case "set_unblock_shipping":
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
                $rID = xtc_db_input($_GET['rID']);
                $reclamation = new reclamation($rID);
                xtc_db_query("UPDATE reclamations SET block_shipping='0',block_shipping_end_date=0, block_shipping_comment='', last_modified=now() WHERE reclamations_id='".$rID."'");
                $messageStack->add_session(sprintf(MSG_SUCCESS_RECLAMATION_UNBLOCK_SHIPPING,$rID),'success');
                $reclamation->add_history($reclamation->info['reclamations_status'],0,TEXT_RECLAMATION_UNBLOCK_SHIPPING);
            }else{
                $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
            }
            if(isset($_GET['referrer']) and $_GET['referrer'] != ''){
                xtc_redirect(urldecode($_GET['referrer']));
            }
            xtc_redirect( xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action')).'action=edit'));
            break;
	case "set_versand":
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
                $rID = xtc_db_input($_GET['rID']);
                $reclamation = new reclamation($rID);
                xtc_db_query("UPDATE reclamations SET send_status='1',last_modified=now(),reclamations_status='1' WHERE reclamations_id='".$rID."'");
                $messageStack->add_session(sprintf(MSG_SUCCESS_RECLAMATION_SET_VERSAND,$rID),'success');
                $reclamation->add_history($reclamation->info['reclamations_status'], 0, sprintf(TEXT_RECLAMATION_SET_VERSAND,xtc_db_input($_GET['comment'])));
            }else{
                $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
            }
            xtc_redirect( xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action')).'action=edit'));
            break;
	
	case "set_status":
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_reclamations_update_status'] == '1') ) {
                $rID = xtc_db_input($_GET['rID']);
                $reclaOID_query = xtc_db_query("SELECT r.orders_id,o.orders_status FROM reclamations r, orders o WHERE r.reclamations_id='".$rID."' and r.orders_id=o.orders_id");
                $reclaOID = xtc_db_fetch_array($reclaOID_query);

                $new_status = xtc_db_input($_GET['new_status']);
                $comments = xtc_db_input($_GET['comments']);
                xtc_db_query("UPDATE reclamations SET reclamations_status='".$new_status."',last_modified=now() WHERE reclamations_id='".$rID."'");
                $new = new \YES4Trade\Model\reclamations_status_history([
                    'reclamations_id'=>(int)$rID, 
                    'reclamations_status_id'=>(int)$new_status,
                    'date_added'=>date('Y-m-d H:i:s'),
                    'customer_notified'=>0, 
                    'comments'=>sprintf(TEXT_RECLAMATION_CHANGE_STATUS,xtc_get_reclamations_status_name($new_status),$comments),
                    'editor_id'=>(int)$_SESSION['customer_id']
                ]);
                $new->create();
                order::add_history_static(intval($reclaOID['orders_id']),
                    intval($reclaOID['orders_status']),0,sprintf(
                        TEXT_RECLAMATION_CHANGE_STATUS_ORDER_HISTORY,
                            $rID,xtc_get_reclamations_status_name($new_status),
                            $comments
                    )
                );
                $messageStack->add_session(sprintf(MSG_SUCCESS_RECLAMATION_CHANGE_STATUS,$rID,xtc_get_reclamations_status_name($new_status)),'success');
            }else{
                 $messageStack->add_session(sprintf(JS_MISSING_PERMISSION,$action),'error');
            }
            xtc_redirect( xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action','comments','new_status')).'action=edit'));
            break;
	case 'show':
		require('reclamations_show.php');
		break;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
<!--
var ONLOADPAGE = 'reclamations';
<?php 
if(!isset($_GET['action'])){?> 
var ONLOADFUNC = "ajax_onload";
var ONLOADFUNCPARAM = 'change_reclamations'; // FORMNAME AJAXLISTING
<?php }else if(isset($_GET['action']) and $_GET['action'] == 'edit'){?>
// NOT ACTIVE
var ONLOADFUNC = "";
var ONLOADFUNCPARAM = "";
<?php } ?>
//-->
</script>

<?php
yes_draw_quicknote();
  /* * * * * * * * * * * * * * * * * * * * * * * * * * *
  REKLAMATION EDIT
  * * * * * * * * * * * * * * * * * * * * * * * * * * */
if ( (isset($_GET['action']) and $_GET['action'] == 'edit') && ($reclamation_exists) ) {
        // EOF - Teillieferungen und DHL Etiketten
	$reclamation = new reclamation(xtc_db_input($_GET['rID']));
  	$helpID = '27';
	$buttons = array(
	    array('text'=>IMAGE_BACK,
		'link'=>xtc_href_link(FILENAME_RECLAMATIONS, xtc_get_all_get_params(array('action'))),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>TEXT_CRM,
		'link'=>xtc_href_link(FILENAME_CUSTOMERS, 'cID=' . $reclamation->customer['ID'].'&action=crm'),
		'lbOn'=>false,
		'auth'=>true
	    ),
	    array('text'=>ADD_QUICKNOTE,
		'link'=>"javascript:toggleBox('addquicknote');",
		'lbOn'=>false,
		'auth'=>true
	    )
	);
	switch($reclamation->info['reclamations_type']){
		case '3':
                    if($reclamation->is_otc() and $reclamation->info['reclamations_status'] == 3 and defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') and YES_PAYMODULE_PRODUCTS_FAKE_SETS == 'True'){
                        $buttons[] = array('text'=>'Fakeset Export',
                            'link'=>xtc_href_link('reclamations.php', xtc_get_all_get_params(array('action')).'action=products_fake_set_export'),
                            'lbOn'=>false,
                            'auth'=>true
                        );
                    }
		case '4':
		    if(in_array($reclamation->info['reclamations_status'],[1,2])){
                        $buttons[] = array('text'=>TEXT_OTC,
                            'link'=>xtc_href_link('otc.php', 'rID='.$_GET['rID']),
                            'lbOn'=>false,
                            'auth'=>true
                        );
		    }else{
			$buttons[] = array('text'=>TEXT_OTC,
			    'link'=>'javascript:;',
			    'lbOn'=>false,
			    'auth'=>true,
			    'error'=>TEXT_OTC_STATUS_ERROR
			);
		    }
		    break;
	}
	$mod_att = new module_attachments('reclamation', (int)xtc_db_input($_REQUEST['rID']));
	$reclamation_type = xtc_get_reclamations_types_name($reclamation->info['reclamations_type']);
	$buttons[] = array(
	    'text'=>$mod_att->get_button_text(),
	    'link'=>$mod_att->get_button_link(),
	    'add_css_class'=>'module_attachments_button',
	    'lbOn'=>true,
	    'auth'=>true
	);
        // BOF - Teillieferungen und DHL Etiketten
        $query = xtc_db_query(sprintf(
                "SELECT id FROM shippings WHERE reclamations_id='%s'",
                $rID
        ));
        if(xtc_db_num_rows($query) and $reclamation->info['reclamations_status'] == 3){
            require_once(DIR_WS_CLASSES.'yes_shipping.php');
            $shipments = array();
            $nr = 0;
            while($record = xtc_db_fetch_array($query)){
                $shipping = new yes_shipping($record['id']);
                $shipments[$nr] = array(
                    'shippings_id'=>$record['id'],
                    'date'=>xtc_date_short($shipping->getDate_finished()),
                    'versender'=>$shipping->getVersender(),
                    'tracking_numbers'=>$shipping->getTracking_id_array_full(),
                    'packages'=>$shipping->getPackages(),
                    'products'=>$shipping->getProducts()
                );
                
                if(sizeOf($shipments[$nr]['tracking_numbers']) != $shipments[$nr]['packages']){
                    if($shipping->getVersender() == 'DHL' and defined('DHL_VERSENDEN_APPLICATION_ID') and DHL_VERSENDEN_APPLICATION_ID != ''){
                        $shipments[$nr]['get_label'] = $shipments[$nr]['packages']-sizeOf($shipments[$nr]['tracking_numbers']);
                    }
                }
                $nr++;
            }
            $smarty->assign('SHIPMENTS',$shipments);
        }
	$smarty->assign(array(
	    'HEADING_TITLE'=>sprintf(HEADING_TITLE_VIEW,
		$rID,
		xtc_get_reclamations_status_name($reclamation->info['reclamations_status'])
	    ),
	    'ADDITIONAL_HEADING_TITLE'=>sprintf(ADDITIONAL_HEADING_TITLE,$reclamation_type,$reclamation->info['orders_id']),
	    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	    'SHIPPING_COMMENTS'=>xtc_db_prepare_input($reclamation->info['shipping_comments']),
	    'TEXT_UPDATE_TO_STATUS_ABGESCHLOSSEN'=>TEXT_UPDATE_TO_STATUS_ABGESCHLOSSEN,
            'ADDRESSES'=>array('customer'=>$reclamation->customer,'delivery'=>$reclamation->delivery,'billing'=>$reclamation->billing),
            'LINK_ADDRESS_EDIT_CUSTOMER'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=customer'),
            'LINK_ADDRESS_EDIT_SHIPPING'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=shipping'),
            'LINK_ADDRESS_EDIT_INVOICE'=>xtc_href_link(basename(__FILE__),xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=invoice'),
            'ALLOW_ADDRESS_EDIT'=>$admin_access['reclamations_edit'] == '1',
            'JS_CONFIRM_REALLY_SHIPPING'=>JS_CONFIRM_REALLY_SHIPPING,
            'JS_PROMPT_SHIPPING_COMMENTS'=>JS_PROMPT_SHIPPING_COMMENTS,
            'SET_VERSAND_BASELINK'=>xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action','comment')).'action=set_versand&comment='),
            'JS_CONFIRM_REALLY_BLOCK_SHIPPING' => JS_CONFIRM_REALLY_BLOCK_SHIPPING,
            'JS_PROMPT_BLOCK_SHIPPING_REASON' => JS_PROMPT_BLOCK_SHIPPING_REASON,
            'JS_ALERT_NO_REASON' => JS_ALERT_NO_REASON,
            'BLOCK_SHIPPING_BASELINK'=>xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action','text')).'action=set_block_shipping&text='),
            'UNBLOCK_SHIPPING_LINK'=>xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action')).'action=set_unblock_shipping'),
            'JS_CONFIRM_REALLY_UNBLOCK_SHIPPING'=>JS_CONFIRM_REALLY_UNBLOCK_SHIPPING,
            'JS_CONFIRM_REALLY_SET_STATUS' => JS_CONFIRM_REALLY_SET_STATUS,
            'TEXT_UPDATE_TO_STATUS_ABGESCHLOSSEN' => TEXT_UPDATE_TO_STATUS_ABGESCHLOSSEN,
            'JS_PROMPT_STATUS_REASON' => JS_PROMPT_STATUS_REASON,
            'SET_RECLA_STATUS_BASELINK'=>xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('action','new_status','comments')).'action=set_status'),
            'JS_CONFIRM_REALLY_SET_IN_VERSAND'=>JS_CONFIRM_REALLY_SET_IN_VERSAND,
            'SEND_NOW_LINK'=>xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('rID','action')).'rID='.((isset($_GET['rID']))?$_GET['rID']:'').'&action=send_now'),
            'JS_CONFIRM_REALLY_BLOCK_IN_VERSAND'=>JS_CONFIRM_REALLY_BLOCK_IN_VERSAND,
            'SEND_BLOCK_LINK'=>xtc_href_link(FILENAME_RECLAMATIONS,xtc_get_all_get_params(array('rID','action')).'rID='.((isset($_GET['rID']))?$_GET['rID']:'').'&action=send_block'),
            'TEXT_FALSE_PRODUCTS_ID_TITLE'=>TEXT_FALSE_PRODUCTS_ID_TITLE,
            'TEXT_FALSE_PRODUCTS_ID_SHORT'=>TEXT_FALSE_PRODUCTS_ID_SHORT,
	));
	$smarty->assign('SEPARATOR',xtc_draw_separator());

	$smarty->assign('reclamations_status_name',xtc_get_reclamations_status_name($reclamation->info['reclamations_status']));

	$smarty->assign('address_label_customer',xtc_address_format($reclamation->customer['format_id'], $reclamation->customer, 1, '', '<br />'));
	$smarty->assign('address_label_shipping',xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, 1, '', '<br />'));
	$smarty->assign('address_label_payment',xtc_address_format($reclamation->billing['format_id'], $reclamation->billing, 1, '', '<br />'));
	$smarty->assign('customer_data',(array)$reclamation->customer);
	$smarty->assign('info',(array)$reclamation->info);
	$smarty->assign('totals',(array)$reclamation->totals);

	for($i=0;$i<sizeOf($reclamation->products);$i++){
		$reclamation->products[$i]['edit_link'] = xtc_href_link('categories.php','pID='.$reclamation->products[$i]['id'].'&cPath='.xtc_get_product_path($reclamation->products[$i]['id']).'&action=new_product');
		if($reclamation->products[$i]['qty'] > 0){
			$reclamation->products[$i]['price_formatted'] = format_price($reclamation->products[$i]['final_price']/$reclamation->products[$i]['qty'], 1, $reclamation->info['currency'], $reclamation->products[$i]['allow_tax'], $reclamation->products[$i]['tax']);
			$reclamation->products[$i]['price_netto_formatted'] = format_price($reclamation->products[$i]['final_price']/$reclamation->products[$i]['qty'], 1, $reclamation->info['currency'], 0, 0);
		}else{
			$reclamation->products[$i]['price_formatted'] = format_price(0, 1, $reclamation->info['currency'], false, 0);
			$reclamation->products[$i]['price_netto_formatted'] = format_price(0, 1, $reclamation->info['currency'], false, 0);
		}
		if($reclamation->products[$i]['allow_tax'] == 1){
			$reclamation->products[$i]['tax_value'] = xtc_display_tax_value($reclamation->products[$i]['tax']);
		}
		$reclamation->products[$i]['final_price_formatted'] = format_price(($reclamation->products[$i]['final_price']),1,$reclamation->info['currency'],0,0);
                if($reclamation->info['reclamations_type'] == 4){
                    $reclamation->products[$i]['false_products_id_input'] = true;
                }
                if($reclamation->products[$i]['false_products_id'] > 0){
                    $reclamation->products[$i]['false_products_id_name'] = xtc_get_products_name($reclamation->products[$i]['false_products_id']);
                }
        	if(in_array($reclamation->info['reclamations_type'],[3,4,5])){
                    $reclamation->products[$i]['allow_edit_name'] = true;
                }
	}
	$smarty->assign('products',(array)$reclamation->products);
	$smarty->assign('memo_count',\YES4Trade\Model\customers_memo::count_by_customers_id((int)$reclamation->customer['ID']));
	$smarty->assign('memo_link', xtc_href_link(FILENAME_CUSTOMERS,'action=memo&cID='.$reclamation->customer['ID']));
	$smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
	$smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);
	$smarty->assign('DISPLAY_MEMOS',DISPLAY_MEMOS);

	$smarty->assign('email_link',xtc_href_link('ebay_mail_frame.php','email='.$reclamation->customer['email_address'].'&box=reply&rID='.$reclamation->info['id']));
	$smarty->assign('order_link',yes_draw_order_edit_link($reclamation->info['orders_id']));

	$shipping_status = TEXT_RECLAMATION_SHIPPING_STATUS_0;
	switch( $reclamation->info['send_status'] ){
		case '1':
			$shipping_status = TEXT_RECLAMATION_SHIPPING_STATUS_1;
			break;
		case '2':
			$shipping_status = TEXT_RECLAMATION_SHIPPING_STATUS_2;
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
				$shipping_status .= '&nbsp;<a href="#" onClick="set_recla_shipping(\''.$_GET['rID'].'\');"><u>['.TEXT_RENEW_SHIPPING.']</u></a>';
			}
			break;
	}
	$smarty->assign('shipping_status',$shipping_status);
	$smarty->assign('reimbursements_count',sizeOf($reclamation->rueckerstattungen));
	$smarty->assign('reclamation_type',$reclamation_type);

	$smarty->assign(array(
            'customers_edit_link'=>xtc_href_link('customers.php','action=edit&cID='.$reclamation->customer['ID']),
            'customers_edit_link_title'=>IMAGE_EDIT_CUSTOMER,
            'TEXT_NO_EDIT_USER_KASSE'=>TEXT_NO_EDIT_USER_KASSE,
            'IS_KASSE'=>($reclamation->customer['ID'] != KASSE_USER) ? false : true
        ));
	$smarty->assign('exclude_shipping_link',yes_draw_href_button(IMAGE_EXCLUDE_FROM_SHIPPING,'javascript:really_block_shipping('.$_GET['rID'].')','','button','ui-button ui-corner-all ui-state-default'));
	$smarty->assign('include_shipping_link',yes_draw_href_button(IMAGE_INCLUDE_SHIPPING,'javascript:really_unblock_ship('.$rID.');','','button','ui-button ui-corner-all ui-state-default'));
	$smarty->assign('comments_link',xtc_href_link('reclamations_update.php',xtc_get_all_get_params(array('rID')).'rID='.$_GET['rID']));

	$customers_query = xtc_db_query("select c.*,a.entry_company, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '" . $reclamation->customer['ID'] . "'");
	$customers = xtc_db_fetch_array($customers_query);
	$customers['country_name'] = xtc_get_country_name($customers['entry_country_id']);
	$smarty->assign('cInfo',$customers);

	$smarty->assign('BLOCK_WARNING_DAYSPAN',sprintf(TEXT_BLOCK_WARNING_DAYSPAN,$customers['block_warnings_dayspan'],xtc_date_short($customers['block_warnings_date'])));
	$smarty->assign('TEXT_BLOCK_WARNING',TEXT_BLOCK_WARNING);
	$smarty->assign('TEXT_BLOCK_WARNING_TOTAL',TEXT_BLOCK_WARNING_TOTAL);

        if ($reclamation->products[0]['allow_tax'] == 1) {
		$smarty->assign('allow_tax',true);
	}

	$reclamations_update_status_array = array();
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ( $admin_access['f_reclamations_update_status'] == '1') ) {
		$recl_status = xtc_get_reclamations_status();
		foreach($recl_status as $key_status=>$recstatus){
			if($reclamation->info['reclamations_status'] != $recstatus['id']){
			    $title = 'Status: '.$recstatus['text'];
			    if($recstatus['id'] == 3){
				$title = BUTTON_UPDATE_TO_STATUS_ABGESCHLOSSEN;
			    }
			    $reclamations_update_status_array[] = xtc_draw_input_field('setstatus_'.$recstatus['id'],$title,'class="ui-button ui-corner-all ui-state-default" onClick="set_recla_status(\''.$recstatus['id'].'\',\''.$recstatus['text'].'\');"','','button').'&nbsp;';
			}
		}
	}
	if(sizeOf($reclamations_update_status_array) and $reclamation->info['reclamations_status'] != 3){
		$smarty->assign('update_statuses',$reclamations_update_status_array);
	}
	$reclamations_versand_status_array = array();
	if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_set_versand'] == '1')) {
            if($reclamation->info['send'] == 1 && !$reclamation->is_otc()){
                if($reclamation->info['send_status'] == 0){
                    $reclamations_versand_status_array[] = xtc_draw_input_field('send_stat',IMAGE_TO_VERSAND,'style="width:160px;"  onClick="send_now();" class="ui-button ui-corner-all ui-state-default"','','button');
                    $reclamations_versand_status_array[] = xtc_draw_input_field('quick_shipping',BUTTON_QUICKSHIPPING_PROCESS,'style="width:160px;" class="ui-button ui-corner-all ui-state-default quick_shipping"','','button');
                }else if($reclamation->info['send_status'] == 1){
                    $reclamations_versand_status_array[] = xtc_draw_input_field('send_blok',IMAGE_BLOCK_VERSAND,'style="width:160px;"  onClick="send_block();" class="ui-button ui-corner-all ui-state-default"','','button');
                }
            }
	}
	if(sizeOf($reclamations_versand_status_array)){
		$smarty->assign('versand_statuses',$reclamations_versand_status_array);
	}

        
        $smarty->configLoad($smarty->getTemplateVars('language_path'), 'general');
        $smvars = $smarty->getConfigVars();

        $retoure_array = array();
	$retouren_query = xtc_db_query("SELECT * FROM retouren WHERE reclamations_id='".(int)$rID."'");
	while($retouren = xtc_db_fetch_array($retouren_query)){
		$retouren['status_name'] = xtc_get_retoure_status_name($retouren['retoure_status']);
		$retouren['costs_formatted'] = number_format($retouren['costs'],2,',','.');
		$retoure_array[] = xtc_db_prepare_input($retouren);
	}
	if(sizeOf($retoure_array)){
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
            $contents = [[
                ['text'=>'ID','th'=>true],
                ['text'=>$smvars['date_created'],'th'=>true],
                ['text'=>$smvars['status'],'th'=>true],
                ['text'=>$smvars['costs'],'th'=>true],
                ['text'=>$smvars['shipper'],'th'=>true],
            ]];
            foreach($retoure_array as $ret){
                $contents[] = [
                    ['text'=> smarty_function_yes_system_link(['type'=>'retoure','id'=>$ret['retoure_id']], $smarty)],
                    ['text'=> xtc_date_short($ret['date_created'])],
                    ['text'=> $ret['status_name']],
                    ['text'=> $ret['costs_formatted']],
                    ['text'=> $ret['versender']],
                ];
            }
            $smarty->assign('retouren',$table->tableBlock_draw($contents));
	}
        
	if(sizeOf($reclamation->rueckerstattungen)){
            $table = new tableBlock();
            $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
            $contents = [[
                ['text'=>'ID','th'=>true],
                ['text'=>$smvars['amount'],'th'=>true],
                ['text'=>$smvars['type'],'th'=>true],
                ['text'=>$smvars['date_added'],'th'=>true],
                ['text'=>$smvars['payment_done'],'th'=>true],
                ['text'=>$smvars['comment'],'th'=>true],
                ['text'=>$smvars['status'],'th'=>true],
                ['text'=>$smvars['editor'],'th'=>true],
            ]];
            foreach($reclamation->rueckerstattungen as $rue){
                $contents[] = [
                    ['text'=> smarty_function_yes_system_link(['type'=>'rueckerstattung','id'=>$rue['id']], $smarty)],
                    ['text'=>$rue['betrag_formatted']],
                    ['text'=> $rue['paymode']],
                    ['text'=>xtc_date_short($rue['date_created'])],
                    ['text'=>xtc_date_short($rue['date_payment'])],
                    ['text'=>$rue['comments']],
                    ['text'=>$rue['status_name']],
                    ['text'=> xtc_get_editor_name($rue['editor_id'])],
                ];
            }
            $rueckerstattungen = $table->tableBlock_draw($contents);
            $smarty->assign('rueckerstattungen',$rueckerstattungen);
	}
        
        
        $table = new tableBlock();
        $table->table_parameters = 'class="yesListTable_minimal" style="width: auto;"';
        $contents = [[
            ['text'=>$smvars['date_added'],'th'=>true],
            ['text'=>$smvars['customer_notified'],'th'=>true],
            ['text'=>$smvars['status'],'th'=>true],
            ['text'=>$smvars['comment'],'th'=>true],
            ['text'=>$smvars['editor'],'th'=>true],
        ]];
        $hitems = \YES4Trade\Model\reclamations_status_history::get_by_reclamations_id((int)$rID);
        foreach($hitems as $hit){
            $contents[] = [
                ['text'=>$hit->date_added->format('Y-m-d H:i:s')],
                ['text'=>($hit->customer_notified == 1)?'&#x2610;':'&#x2611;'],
                ['text'=> xtc_get_reclamations_status_name($hit->reclamations_status_id)],
                ['text'=>$hit->comments],
                ['text'=> xtc_get_editor_name($hit->editor_id)]
            ];
        }
        $history = $table->tableBlock_draw($contents);
	$smarty->assign(array(
            'history'=>$history,
            'EDIT_REASON_LINK'=>xtc_href_link('reclamations_reasons.php',xtc_get_all_get_params(array('action')).'action=ajax_edit_reason'),
            'TEXT_UPDATE_RECLAMATION_PRODUCTS_QTY_SN_LESS'=>TEXT_UPDATE_RECLAMATION_PRODUCTS_QTY_SN_LESS,
            'TEXT_CONFIRM_UPDATE_RECLAMATION_SEND'=>TEXT_CONFIRM_UPDATE_RECLAMATION_SEND,
	));

	if(sizeOf($reclamation->reasons)){
            $smarty->assign('reason',current($reclamation->reasons));
	}
	$smarty->assign('EDIT_COSTS_BUTTON',yes_draw_href_button(
		TEXT_EDIT_RECLAMATION_COSTS,
		xtc_href_link(basename(__FILE__),xtc_get_all_get_params(['action']).'action=edit_costs'),
                'padding: 5px;',
                'button',
                'lbOn ui-button ui-corner-all ui-state-default'
	));
        
        
	$smarty->assign('print_link',yes_draw_href_button(
		IMAGE_PRINT,
		'javascript:window.open(\''.xtc_href_link('print_reclamation.php','rID='.$_GET['rID']).'\', \'popup\', \'toolbar=0, width='.EXT_POPUP_WIDTH.', height='.EXT_POPUP_HEIGHT.', resizable=1,scrollbars=1\');',
		'width:160px;',
                'button',
                'ui-button ui-corner-all ui-state-default'
	));


	$smarty->display('reclamations.html');
} else {
    include('reclamation_listing.php');
}
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
