<?php
include('includes/classes/PhpSpreadsheet/vendor/autoload.php');
$xy_action = (isset($_GET['xy_action']))?$_GET['xy_action']:'';
$pID = (int)xtc_db_input($_GET['pID']);
if($pID < 1){
    $messageStack->add_session(MSG_ERROR_XY_PRICE_INVALID_PID,'error');
    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'action=new_product&pID='.$pID));
}
$file = main::get_secure_path().'XY_PRICE_FILES/DATA-'.$pID.'.xlsx';
$product = new \product($pID);
switch($xy_action){
    case 'copy_prices_confirm':
        require_once(DIR_FS_INC.'yes_get_products_characteristics.inc.php');
        $products_id = (int)xtc_db_input($_GET['pID']);
        $group = current(xtc_get_product_groups($products_id));
        $gh = new \YES4Trade\Model\group_handler($_SESSION['languages_id']);
        $options = [
            ['id'=>'','text'=>TEXT_SELECT]
        ];
        foreach($gh->groups as $g){
            $options[] = [
                'id'=>$g['groups_id'],
                'text'=>$g['groups_title'],
            ];
        }
        echo '<p>'.XY_PRICE_COPY_INTRO.'</p>';
        echo XY_PRICE_COPY_FROM_GROUP.'<br />';
        echo xtc_draw_form('copy_xy',FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action']).'xy_action=copy_prices');
        echo xtc_draw_pull_down_menu('groups_id', $options, $group['id']);
        echo '<input type="submit" value="'.IMAGE_COPY.'" class="ui-button ui-corner-all ui-state-default" style="padding: 4px;" /></form>';
        exit;
        break;
    case 'copy_prices':
        $source_pid = (int)xtc_db_input($_GET['pID']);
        $target_pids = [];
        $query = xtc_db_query(sprintf(
            "SELECT products_id FROM groups_allocations WHERE groups_id='%d' AND products_id != %d",
            (int)xtc_db_input($_POST['groups_id']),
            $source_pid
        ));
        if(!xtc_db_num_rows($query)){
            $messageStack->add_session('No products found','error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action'])));
        }
        while($record = xtc_db_fetch_array($query)){
            $target_pids[] = $record['products_id'];
        }
        $copy_prices = [];
        $copy_prices_add = [];

        $source_add_properties = [];
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($source_pid);
        
        foreach($xy->product_properties_xy_prices_values as $pv){
            $copy_prices[ $pv->val_X ][ $pv->val_Y ] = $pv->xy_price;
            /** RAUS 2024/10
            if(!is_countable($pv->product_properties_xy_prices_values_for_properties) or !sizeOf($pv->product_properties_xy_prices_values_for_properties)){
                continue;
            }
            foreach($pv->product_properties_xy_prices_values_for_properties as $pvfp){
                if(!in_array($pvfp->products_properties_id,$source_add_properties)){
                    $source_add_properties[] = $pvfp->products_properties_id;
                }
                $copy_prices_add[ $pv->val_X.':'.$pv->val_Y ][ $pvfp->products_properties_id ] = $pvfp->price_netto;
            }*/
        }
        $source_property_conversion = [];
        foreach($source_add_properties as $sap){
            $property = new \product_properties($sap);
            $desc = $property->getDescription(2);
            $source_property_conversion[ $sap ] = $desc->getTitle();
        }
        foreach($target_pids as $target_pid){
            $xyt = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($target_pid);
            if($xyt === false){
                continue;
            }
            $property_conversion = [];
            foreach($xyt->product_properties_xy_prices_values as $pv){
                $target_property_conversion = [];
                $target_add_properties = [];
                $update_sql_array = [
                    'xy_price'=>$copy_prices[ $pv->val_X ][ $pv->val_Y ],
                ];
                xtc_db_perform('product_properties_xy_prices_values', $update_sql_array, 'update',
                        sprintf("product_properties_xy_prices_values_id='%d'",
                                $pv->product_properties_xy_prices_values_id
                        )
                );
                if(!sizeOf($property_conversion)){
                    /** RAUS 2024/10
                    if(is_countable($pv->product_properties_xy_prices_values_for_properties) and sizeOf($pv->product_properties_xy_prices_values_for_properties)){
                        foreach($pv->product_properties_xy_prices_values_for_properties as $pvfp){
                            if(!in_array($pvfp->products_properties_id,$target_add_properties)){
                                $target_add_properties[] = $pvfp->products_properties_id;
                            }
                        }
                    }*/
                    foreach($target_add_properties as $tap){
                        $property = new \product_properties($tap);
                        $desc = $property->getDescription(2);
                        $target_property_conversion[ $tap ] = $desc->getTitle();
                    }
                    foreach($source_property_conversion as $ppID => $spc){
                        foreach($target_property_conversion as $tppID=>$tpc){
                            if($spc == $tpc){
                                $property_conversion[ $tppID ] = $ppID;
                            }
                        }
                    }
                }
                $coord = $pv->val_X.':'.$pv->val_Y;
                /** RAUS 2024/10
                if(is_countable($pv->product_properties_xy_prices_values_for_properties) and sizeOf($pv->product_properties_xy_prices_values_for_properties)){
                    foreach($pv->product_properties_xy_prices_values_for_properties as $pvfp){
                        $update_sql_array = [
                            'price_netto'=>$copy_prices_add[ $coord ][ $property_conversion[ $pvfp->products_properties_id ] ]
                        ];
                        xtc_db_perform('product_properties_xy_prices_values_for_properties',$update_sql_array,'update',
                                sprintf(
                                        "product_properties_xy_prices_values_for_properties_id='%d'",
                                        $pvfp->product_properties_xy_prices_values_for_properties_id
                                )
                        );
                    }
                }*/
            }
        }
        $messageStack->add_session(sprintf(MSG_SUCCESS_XY_PRICE_COPY,sizeOf($target_pids)),'success');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action'])));
        break;
    case 'add_ppv':
        $ppID = (int)xtc_db_input($_GET['ppID']);
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($pID);
        /** RAUS 2024/10
        foreach($xy->product_properties_xy_prices_values as $xypv){
            $obj = new \YES4Trade\Model\product_properties_xy_prices_values_for_properties([
                'product_properties_xy_prices_values_id'=>$xypv->product_properties_xy_prices_values_id,
                'products_properties_id'=>$ppID,
                'price_netto'=>0.0
            ]);
            $obj->create();
        }
         * 
         */
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params([
            'xy_action','ppID'
        ])));
        exit;
        break;
    case 'delete':
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)$pID);
        $xyID = $xy->product_properties_xy_prices_id;
        \YES4Trade\Model\product_properties_xy_prices::delete($xyID);
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params([
            'xy_action',
        ])));
        break;
    case 'save_values':
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($pID);
        $product = new \product($pID);
        $tax_rate = xtc_get_tax_rate( $product->info['products_tax_class_id'] );
        foreach($_POST as $k=>$v){
            $v = str_replace(',','.',$v);
            if(strpos($k,'add_')>-1){
                /** RAUS 2024/10
                $product_properties_xy_prices_values_for_properties_id = (int)str_replace('add_','',$k);
                $netto = xtc_oe_get_price_o_tax((float)$v, $tax_rate);
                $instance = new \YES4Trade\Model\product_properties_xy_prices_values_for_properties([
                    'product_properties_xy_prices_values_for_properties_id'=>$product_properties_xy_prices_values_for_properties_id,
                    'price_netto' => $netto,
                ]);
                $instance->update();
                 * 
                 */
            }else{
                $pp_parts = explode(':',$k);
                $ppIDX = (int)$pp_parts[0];
                $ppIDY = (int)$pp_parts[1];
                $product_properties_xy_prices_values_id = (int)$pp_parts[2];
                $netto = xtc_oe_get_price_o_tax((float)$v, $tax_rate);
                if( $product_properties_xy_prices_values_id == 0){
                    $instance = new \YES4Trade\Model\product_properties_xy_prices_values([
                        'product_properties_xy_prices_id'=>(int)$_GET['product_properties_xy_prices_id'],
                        'val_X'=>$ppIDX,
                        'val_Y'=>$ppIDY,
                        'xy_price'=>$netto,
                    ]);
                    $instance->create();
                }else{
                    $instance = new \YES4Trade\Model\product_properties_xy_prices_values([
                        'product_properties_xy_prices_values_id'=>$product_properties_xy_prices_values_id,
                        'product_properties_xy_prices_id'=>(int)$_GET['product_properties_xy_prices_id'],
                        'val_X'=>$ppIDX,
                        'val_Y'=>$ppIDY,
                        'xy_price'=>$netto,
                    ]);
                    $instance->update();
                }
            }
        }
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params([
            'xy_action',
            'product_properties_xy_prices_id',
        ])));
        exit;
        break;
    case 'create':
        $xy = new \YES4Trade\Model\product_properties_xy_prices([
            'products_id'=>$pID,
            'products_properties_id_X'=>(int)xtc_db_input($_GET['ppIDX']),
            'products_properties_id_Y'=>(int)xtc_db_input($_GET['ppIDY']),
        ]);
        $xy->create();
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params([
            'ppIDX',
            'ppIDY',
            'xy_action'
        ])));
        exit;
        break;
    case 'upload':
        if(!isset($_FILES['xy-file'])){
            $messageStack->add_session('No file uploaded','error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action'])));
        }
        if(strpos($_FILES['xy-file']['name'],'.xlsx')<0){
            $messageStack->add_session('Not a valid Data file','error');
            xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action'])));
        }
        $path = main::get_secure_path().'XY_PRICE_FILES/';
        if(!is_dir($path)){
            mkdir($path);
        }
        $upload = new \upload('xy-file', $path);
        rename($path.$_FILES['xy-file']['name'], $path.'DATA-'.$pID.'.xlsx');
        
        $data_start_row = 2; // ab Zeile 2 sind Daten
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($file);
        $worksheet = $spreadsheet->getActiveSheet();
        $row_nr = 0;
        $keyvalue_x = 0;
        $keyvalue_y = 0;
        $data = [];
        foreach ($worksheet->getRowIterator() as $row) {
            $cellIterator = $row->getCellIterator();
            if($row_nr < $data_start_row){
                $row_nr++;
                continue;
            }
            $cell_nr = 0;
            $data_row = [];
            foreach ($cellIterator as $cell) {
                if($cell_nr < 1){
                    $cell_nr++;
                    continue;
                }
                if(!empty($cell->getValue())){
                    $data_row[] = $cell->getValue();
                }
                $cell_nr++;
            }
            if(sizeOf($data_row)){
                $data[] = $data_row;
            }
            $row_nr++;
        }
        $values = [];
        $x_header = [];
        foreach($data as $nr=>$row){
            foreach($row as $cnr=>$col){
                if($nr == 0){
                    if(!empty($col)){
                        $x_header[] = $col;
                    }
                }else{
                    if($cnr == 0){
                        $y_header[] = $col;
                    }else{
                        $values[ 'ROW'.$nr ][ 'COL'.$cnr ] = $col;
                    }
                }
            }
        }
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($pID);
        $xy->delete_values();
        foreach($values as $row=>$data){
            foreach($data as $colnr=>$col){
            	$row_nr = (int)str_replace('ROW','',$row);
            	$col_nr = (int)str_replace('COL','',$colnr);
                $tax_rate = xtc_get_tax_rate( $_POST['tax_class_id'] );
                $netto = xtc_oe_get_price_o_tax((float)$col, $tax_rate);
                $data = [
                    'product_properties_xy_prices_id'=>(int)xtc_db_input($_GET['product_properties_xy_prices_id']),
                    'val_X'=>$x_header[ $col_nr-1 ],
                    'val_Y'=>$y_header[ $row_nr-1 ],
                    'xy_price'=>$netto
                ];
                $instance = new \YES4Trade\Model\product_properties_xy_prices_values($data);
                $instance->create();
            }
        }
        unlink($path.'DATA-'.$pID.'.xlsx');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action','product_properties_xy_prices_id'])));
        break;
}
$ppID_array = yes_get_products_properties_id_array($pID);
if(sizeOf($ppID_array)<2){
    $messageStack->add_session(MSG_ERROR_XY_PRICE_TWO_PROPERTIES,'error');
    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'action=new_product&pID='.$pID));
}
$props = [];
foreach($ppID_array as $propID){
    $prop = new product_properties($propID);
    $d = $prop->getDescription(2);
    $vals = $prop->getValues(2);
    foreach($vals as $k=>$val){
        unset($val['image']);
        unset($val['files_image']);
        $vals[ $k ] = $val;
    }
    $props[] = [
        'id'=>$propID,
        'title'=>$d->title,
        'text'=>$d->text,
        'sort_order'=>$prop->getSort_order(),
        'values'=>$vals,
    ];
}


$smarty = new yesSmarty;
$buttons = array();
$buttons[] = array('text'=>IMAGE_BACK,
    'link'=>xtc_href_link(FILENAME_CATEGORIES, xtc_get_all_get_params(array('action')).'action=new_product'),
    'lbOn'=>false,
    'auth'=>true
);

$xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)$pID);
$xy_exists = ($xy === false) ? false : true;

if($xy_exists){
    
    $unused_properties = [];
    $used_properties = [];
    foreach($props as $p){
        if($p['id'] != $xy->products_properties_id_X and $p['id'] != $xy->products_properties_id_Y){
            $distinct_ppvs = [];
            foreach($xy->product_properties_xy_prices_values as $pppv){
                /** RAUS 2024/10
                foreach( $pppv->product_properties_xy_prices_values_for_properties as $pppv_fp){
                    $distinct_ppvs[] = $pppv_fp->products_properties_id;
                    $used_properties[ $pppv_fp->products_properties_id ] = true;
                }
                 * 
                 */
            }
            if(!in_array($p['id'], $distinct_ppvs)){
                $unused_properties[] = $p;
            }
        }
    }
    
    // BOF INSERT MISSING product_properties_xy_prices_values
    $prop_x_matrix = [];
    $prop_y_matrix = [];
    foreach($props as $p){
        if($p['id'] == $xy->products_properties_id_X){
            foreach($p['values'] as $pp){
                $prop_x_matrix[] = $pp['description']->title;
            }
        }
    }
    foreach($props as $p){
        if($p['id'] == $xy->products_properties_id_Y){
            foreach($p['values'] as $pp){
                $prop_y_matrix[] = $pp['description']->title;
            }
        }
    }
    $prop_matrix = [];
    foreach($prop_x_matrix as $x){
        if(!isset($prop_matrix[ $x ])){
            $prop_matrix[ $x ] = [];
        }
        foreach($prop_y_matrix as $y){
            if(!isset($prop_matrix[ $x ][ $y ])){
                $prop_matrix[ $x ][ $y ] = false;
            }
            $prop_matrix[ $x ][ $y ] = true;
        }
    }
    $reload_xy = false;
    foreach($prop_matrix as $x=>$y_arr){
        foreach($y_arr as $y=>$egal){
            $xy_val_exists = false;
            foreach($xy->product_properties_xy_prices_values as $xypv){
                if($xypv->val_X == $x and $xypv->val_Y == $y){
                    $xy_val_exists = true;
                }
            }
            if(!$xy_val_exists){
                $new_ppv = new \YES4Trade\Model\product_properties_xy_prices_values([
                    'product_properties_xy_prices_id' => $xy->product_properties_xy_prices_id,
                    'val_X' => (int)$x,
                    'val_Y' => (int)$y,
                    'xy_price' => 0.0,
                ]);
                $ppxypvID = $new_ppv->create();
                $reload_xy = true;
            }
            
        }
    }
    if($reload_xy){
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)$pID);
    }
    $reload_xy = false;
    foreach($xy->product_properties_xy_prices_values as $xypv){
        foreach($used_properties as $ppID=>$egal){
            $exists = false;
            /** RAUS 2024/10
            foreach($xypv->product_properties_xy_prices_values_for_properties as $xypvfp){
                if($xypvfp->products_properties_id == $ppID){
                    $exists = true;
                }
            }
            if(!$exists){
                $new_itm = new \YES4Trade\Model\product_properties_xy_prices_values_for_properties([
                    'product_properties_xy_prices_values_id' => $xypv->product_properties_xy_prices_values_id,
                    'products_properties_id' => (int)$ppID,
                    'price_netto' => 0.0
                    
                ]);
                $new_itm->create();
                $reload_xy = true;
            }
             * 
             */
        }
    }
    if($reload_xy){
        $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id((int)$pID);
    }
    // EOF INSERT MISSING product_properties_xy_prices_values

    $smarty->assign([
        'SAVEDOBJECT'=>$xy,
        'UNUSED_PROPERTIES'=>$unused_properties,
    ]);
    $buttons[] = array('text'=>XY_PRICE_COPY_BUTTON,
        'link'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['xy_action']).'xy_action=copy_prices_confirm'),
        'lbOn'=>true,
        'auth'=>true
    );
    $buttons[] = array('text'=>IMAGE_DELETE,
        'link'=>'javascript:delete_xy()',
        'lbOn'=>false,
        'auth'=>true
    );
}
$smarty->assign([
    'INFO'=>$product->info,
    'PROPERTIES'=> $props,
    'PROPERTIES_JSON'=>str_replace(["\\t","\\r\\n"],"",json_encode($props)),
    'HEADING_TITLE'=>XY_PRICE_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TEXT_SELECT'=>TEXT_SELECT,
    'JS_ERROR_SELECT_XY_PRICES_ALLOCATIONS'=>JS_ERROR_SELECT_XY_PRICES_ALLOCATIONS,
    'XY_PROPERTY_VALUES'=>XY_PROPERTY_VALUES,
    'XY_PROPERTY'=>XY_PROPERTY,
    'XY_PRICE_ALLOCATION'=>XY_PRICE_ALLOCATION,
    'XY_UPLOAD_FORM_ACTION'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('xy_action','product_properties_xy_prices_id')).'xy_action=upload'),
    'EXISTS'=>($xy_exists === true) ? '1' : '0',
    'XY_PRICE_UPDATE_EXISTING'=>XY_PRICE_UPDATE_EXISTING,
    'XY_PRICE_CREATE_NEW'=>XY_PRICE_CREATE_NEW,
    'BUTTON_USE_PROPERTY_CONFIGURATION'=>BUTTON_USE_PROPERTY_CONFIGURATION,
    'XY_PRICE_VALUES_TITLE'=>XY_PRICE_VALUES_TITLE,
    'LINK_CREATE_XY_PRICE'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('xy_action','ppIDX','ppIDY')).'xy_action=create'),
    'IMAGE_SAVE'=>IMAGE_SAVE,
    'FORM_XY_PRICE_VALUES_ACTION'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('xy_action','product_properties_xy_prices_id')).'xy_action=save_values'),
    'INPUT_TAX_CLASSES'=> xtc_tax_classes_pull_down('name="tax_class_id"',$product->info['products_tax_class_id']),
    'XY_TAX_CLASS'=>XY_TAX_CLASS,
    'REALLY_DELETE_XY_ALLOCATIONS'=>REALLY_DELETE_XY_ALLOCATIONS,
    'XY_FILEUPLOAD_INTRO'=>XY_FILEUPLOAD_INTRO,
    'XY_PRICE_ADD_PROPERTY_TO_EXISTING_MATRIX'=>XY_PRICE_ADD_PROPERTY_TO_EXISTING_MATRIX,
    'XY_ADD_PPV_LINK'=>xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(array('xy_action','ppID')).'xy_action=add_ppv'),
]);
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->display('product_properties_xy_prices.html');
require(DIR_WS_INCLUDES . 'footer.php');
exit;
