<?php
require('includes/application_top.php');
// load classes
//require('../includes/classes/paypal_checkout.php');
require_once(DIR_FS_INC.'xtc_format_price.inc.php');
require_once(DIR_WS_CLASSES.'order.php');

function renderIniStyle(array $array, string $parentKey = '', int $level = 0): string {
    $output = '';
    $indent = str_repeat('    ', $level); // 4 Leerzeichen für Einrückung

    foreach ($array as $key => $value) {
        if (is_array($value)) {
            $sectionName = $parentKey ? "{$parentKey}.{$key}" : $key;
            $output .= "\n{$indent}[" . $sectionName . "]\n";
            $output .= renderIniStyle($value, $sectionName, $level);
        } else {
            $keyEscaped = htmlspecialchars((string)$key);
            $valueEscaped = htmlspecialchars((string)$value);
            $output .= "{$indent}{$keyEscaped} = {$valueEscaped}\n";
        }
    }

    return $output;
}

if(isset($_GET['txn_id']) and !empty($_GET['txn_id'])){
	$pp = new \YES4Trade\Model\paypal_api();
	if($pp->get_access_token() === null){
		$accessToken = $pp->getAccess_token();
		$pp->set_access_token($accessToken);
	}
	try{
		$response = $pp->getOrder($_GET['txn_id']);
	}catch(Exception $e){
		printf('Keine Infos zur Transaktion abrufbar.<div style="margin-top: 20px;font-size:0.8em;" class="ui-state-error">%s</div>',$e->getMessage());
	}
	$smarty = new yesSmarty();
	$smarty->assign([
		'ORDER'=>$response
	]);
	$smarty->display('paypal.html');
	exit;
}
$pp = new \YES4Trade\Model\paypal_api();
if($pp->get_access_token() === null){
	$token = $pp->getAccess_token();
	$pp->set_access_token($token);
}

if(isset($_GET['action']) and $_GET['action']=='delete_webhook'){
	try{
		$response = $pp->ppcall('/v1/notifications/webhooks/'.$_GET['id'],$pp->get_access_token(),[],'DELETE');
		$messageStack->add_session('Paypal Webhook gelöscht','success');
	}catch(Exception $e){
		$messageStack->add_session($e->getMessage(),'error');
	}
	xtc_redirect(xtc_href_link(basename(__FILE__)));
}
if(isset($_GET['action']) and $_GET['action']=='create_webhook'){
	$url = (main::isDev())?"https://yes-a177922.de/callback/paypal/ipn2.php":HTTPS_CATALOG_SERVER."callback/paypal/ipn2.php";
	try{
		$response = $pp->ppcall('/v1/notifications/webhooks',$pp->get_access_token(),[
			"url" => $url,
			"event_types" => [
				["name" => "CHECKOUT.ORDER.APPROVED"],
				["name" => "CHECKOUT.ORDER.COMPLETED"],
				["name" => "PAYMENT.CAPTURE.COMPLETED"],
				["name" => "PAYMENT.CAPTURE.DENIED"],
				["name" => "PAYMENT.CAPTURE.PENDING"],
				["name" => "PAYMENT.CAPTURE.REFUNDED"],
				["name" => "PAYMENT.CAPTURE.REVERSED"],
			]
		],'',true);
		$res = json_decode($response);
		$pp->save_webhook_id($res->id);

		$messageStack->add_session('Paypal Webhook eingerichtet','success');
	}catch(Exception $e){
		$messageStack->add_session($e->getMessage(),'error');
	}
	xtc_redirect(xtc_href_link(basename(__FILE__)));
}
if(isset($_GET['action']) and $_GET['action'] == 'webhooks'){
	$webhooks_result = $pp->ppcall('/v1/notifications/webhooks',$pp->get_access_token());
	$webhooks = json_decode($webhooks_result,true);
	echo '<div class="main">';
	if(!sizeOf($webhooks['webhooks'])){
		echo 'Es sind keine Webhooks eingerichtet. <a class="ui-button ui-corner-all ui-state-highlight" href="?action=create_webhook">Einrichten</a></div>';
	}else{
		echo '<b>Webhooks</b>';
		echo '	<div id="webhook_details">';
		$webhooks_id = $pp->get_webhook_id();
		echo '<div style="margin-top: 5px;margin-bottom: 5px;">Derzeitig verwendete Webhook ID: '.$webhooks_id.'</div>';
		foreach($webhooks['webhooks'] as $wh){
			$enableds = [];
			foreach($wh['event_types'] as $et){
				$enableds[] = sprintf('%s %s',
					($et['status'] == 'ENABLED')?'&#x2611;':'&#x2610;',
					$et['description']
				);
			}
			printf('<div title="%s">&#x27B2; <a title="Löschen" href="?action=delete_webhook&id=%s">%s</a><div style="margin-left: 15px;">%s</div></div>',
				$wh['id'],$wh['id'],$wh['url'],
				implode('<br />',$enableds)
			);
		}
		echo '</div>';
	}
	$webhook_files = [];
	$files_dir = \main::get_secure_path();
	$files = scandir(\main::get_secure_path($files_dir));
	foreach($files as $f){
		if(strpos($f,'YES_PPP_WEBHOOK_ID') !== false){
			$webhook_files[] = [
				'id'=>$f,
				'content'=>file_get_contents($files_dir.DIRECTORY_SEPARATOR.$f),
				'ctime'=>date('d.m.Y H:i:s',filectime($files_dir.DIRECTORY_SEPARATOR.$f))
			];
		}
	}
	if(sizeOf($webhook_files)){
		$apiclient = constant('MODULE_PAYMENT_YES_PPP_APICLIENTID');
		$apiclient_short = sprintf(
			'<span title="%s">%s[...]</span>',
			$apiclient, substr($apiclient,0,40)
		);
		printf('<div style="margin-top: 10px;"><div style="margin-bottom: 10px;">Lokale Webhook Files für aktuellen registrierten API Client <b>%s</b></div>',
			$apiclient_short
		);
		foreach($webhook_files as $f){
			$f_parts = explode('.',$f['id']);
			$f_short = sprintf(
				'<span title="%s">%s[...]</span>',
				$f_parts[1], substr($f_parts[1],0,40)
			);
			printf('<div style="margin-left: 10px;font-size: 0.8em;"><img src="images/basicons/document162.png" width="16" align="left" style="padding-right: 10px;" alt="File" />%s vom %s</div><div style="margin-left:10px;font-size: 0.8em;color: #666;">%s</div>',
				$f_parts[0].'.'.$f_short,
				$f['ctime'],
				$f['content']
			);
		}
		echo '</div>';
	}
	echo '</div>';
	exit;
}
if(isset($_GET['action']) and $_GET['action'] == 'send_paypalme'){
	$paypalMeName = urlencode(constant('MODULE_PAYMENT_YES_PPP_PAYPALME'));
	$amount = urlencode($_GET['amount']);
	$link = "https://paypal.me/$paypalMeName/$amount";
	die($link);
}
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'paypalme'){
	$oID = intval($_GET['oID']??0);
	if($oID < 1){
		die('Missing order allocation');
	}
	$order = new order($oID);
	$total = 0;
	foreach($order->totals as $ot){
		switch($ot['class']){
			case 'ot_total':
				$total += $ot['value'];
				break;
		}
	}
	echo <<<JSFUNC1
<script>	
function paypalme_handler(){
	var params = $('form[name="paypalme"]').serialize();
	$.ajax({
		url: $('form[name="paypalme"]').attr('action')+'&'+params,
		success: function(response){
			navigator.clipboard.writeText(response)
			.then(() => {
				console.log('Text wurde in die Zwischenablage kopiert:', response);
				alert(response);
			})
			.catch(err => {
				console.error('Fehler beim Kopieren:', err);
				alert("Paypal Me Link konnte nicht autom. in die Zwischenablage kopiert werden. Kopieren Sie ihn nachdem Sie diese Meldung wegklicken");
				alert(response);
			});			
		},
		error: function(xhr){
			alert('Cant generate Paypal Me Link');
		}
	});
	return false;
}
</script>
JSFUNC1;
	echo '<div class="main">';
	echo xtc_draw_form('paypalme','paypal.php',xtc_get_all_get_params(['action']).'action=send_paypalme','post','onsubmit="return paypalme_handler();"');
	echo '<img src="https://www.paypalobjects.com/webstatic/icon/pp258.png" alt="PayPal" width="100" align="left" style="padding: 15px;">';
	echo '<p><i>Es wird ein PaypalMe Link generiert. Dieser wird automatisch in der Zwischenablage gespeichert, so dass Sie den Link mit STRG+V oder "einfügen" in eine Email an den Kunden verwenden können.</i></p>';
	printf('<p><b>Send PaypalMe Link</b></p>Email: <i>%s</i><br />Amount: <i>%s %s</i>',
		$order->customer['email_address'],
		number_format($total,2,',','.'),
		$order->info['currency']
	);
	printf('<br /><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-highlight">',
	    'Link generieren'
    );
	echo xtc_draw_hidden_field('amount',number_format($total,2,'.'));
	echo xtc_draw_hidden_field('email',$order->customer['email_address']);
	echo '</form></div>';
	exit;
}
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'refund'){
	$captureId = $_GET['capture_id']??null;
	$orders_id = intval($_GET['oID']);
	if($captureId === null){
		$messageStack->add_session('No capture_id found','error');
	}else{
		try{
			$response = $pp->refund($captureId,floatval($_POST['refund_amount']),$_POST['refund_note']??'');
			if($response['status'] == 'COMPLETED'){
				$messageStack->add_session('Paypal Refund success','success');
			}else{
				$messageStack->add_session('Paypal Refund success with Status '.$response['status'],'success');
			}
			$order = new order($orders_id);
			$order->add_history($order->info['orders_status'],false, 'Paypal Refund: '.$_POST['refund_amount'].' '.constant('DEFAULT_CURRENCY').' '.$_POST['refund_note']);
		}catch(Exception $e){
			$messageStack->add_session($e->getMessage(),'error');
		}
	}
	xtc_redirect(xtc_href_link(FILENAME_ORDERS,'action=edit&oID='.$orders_id));
}

if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'refund_info'){
	$txn = $_GET['txn']??null;
	if($txn === null){
		die('No transaction found');
	}
	try{
		$response = $pp->getOrder($txn);
	}catch(Exception $e){
		printf('Keine Infos zur Transaktion abrufbar.<div style="margin-top: 20px;font-size:0.8em;" class="ui-state-error">%s</div>',$e->getMessage());
	}
	$captureId = $response['purchase_units'][0]['payments']['captures'][0]['id']??null;
	if($captureId === null){
		die(sprintf(
			'<div class="ui-state-error">No refund available for transaction %s - missing capture info from paypal</div>',
			$txn
		));
	}
	$trans = $response['transaction_details'];
	echo <<<JSFUNC
<script>	
function check_paypal_refund(){
	if($('input[name="refund_amount"]').val() < 0.01 || $('input[name="refund_amount"]').val() > $('input[name="refund_amount"]').attr('max')){
		alert('Invalid amount '+$('input[name="refund_amount"]').val());
		return false;
	}
	return true;
}
</script>
JSFUNC;
echo '<div class="main">';
echo '<img src="https://www.paypalobjects.com/webstatic/icon/pp258.png" alt="PayPal" width="100" align="left" style="padding: 15px;">';
	echo xtc_draw_form('refund','paypal.php','action=refund&capture_id='.$captureId.'&oID='.$_GET['oID'], 'post', 'onsubmit="return check_paypal_refund()"');
	printf('<p><b>%s</b></p>',TEXT_PAYPAL_REFUND_TRANSACTION);
	printf('<p><b>Transaction:</b> %s / <b>Capture ID:</b> %s</p>',$txn,$captureId);
	printf('%s <input name="refund_amount" type="number" value="%s" max="%s" min="0.01" step="0.01" /> %s',
	    TEXT_PAYPAL_AMOUNT,
		$response['purchase_units'][0]['amount']['value'],
		$response['purchase_units'][0]['amount']['value'],
		constant('DEFAULT_CURRENCY')
	);
	printf('<br />%s<br />%s<br />',TEXT_PAYPAL_REFUND_NOTE,xtc_draw_textarea_field('refund_note','virtual',40,2));
	printf('<input type="submit" value="%s" class="ui-button ui-corner-all ui-state-highlight">',
	     TYPE_REFUNDED
    );
	echo '</form></div>';
	exit;
}	
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'redirect_to_ip'){
    $payment_id = xtc_db_input($_REQUEST['payment_id']);
    $query = xtc_db_query(sprintf(
	    "SELECT buchungstag FROM incoming_payments WHERE id='%s'",
	    $payment_id
    ));
    $record = xtc_db_fetch_array($query);
    $_SESSION['payment_day_selected'] = $record['buchungstag'];
    xtc_redirect('incoming_payments.php');
}
if(isset($_GET['action']) and $_GET['action'] == 'view_transaction'){
	$txn = $_GET['txn']??null;
	if($txn === null){
		die('No transaction found');
	}
    $response = $pp->searchTransactions([
		'transaction_id'=>$txn
	]);
	if(!is_countable($response['transaction_details']) or !sizeOf($response['transaction_details'])){
		die(sprintf(
			'<div class="ui-state-error">Cant find Transaction Data for #%s</div>',
			$_GET['transaction_id']
		));
	}
	$trans = current($response['transaction_details']);
	echo '<pre><code>'.renderIniStyle($trans).'</pre></code>';
	exit;
}
if(isset($_REQUEST['action']) and $_REQUEST['action'] == 'add_ip'){
    $response = $pp->searchTransactions([
		'transaction_id'=>$_GET['transaction_id']
	]);
	if(!is_countable($response['transaction_details']) or !sizeOf($response['transaction_details'])){
		die(sprintf(
			'<div class="ui-state-error">Cant find Transaction Data for #%s</div>',
			$_GET['transaction_id']
		));
	}
	$trans = current($response['transaction_details']);
    $msg = '';
    $id = 0;
	$sorting_query = xtc_db_query("SELECT sorting FROM incoming_payments order by sorting DESC limit 1");
	$sorting_res = xtc_db_fetch_array($sorting_query);
	$sorting = ($sorting_res['sorting']+1);

	$buchungstag = (new \DateTime($trans['transaction_info']['transaction_initiation_date']))->format('Y-m-d H:i:s');

	$vwz_items = [];
	foreach($trans['payer_info'] as $pk=>$piv){
		switch($pk){
			case 'account_id':
			case 'address_status':
			case 'payer_status':
			case 'country_code':
				break;
			default:
				if(is_array($piv)){
					foreach($piv as $pppk=>$pppv){
						if(!empty($pppv)){
							$vwz_items[] = $pppv;
						}
					}
				}else{
					if(!empty($piv)){
						$vwz_items[] = $piv;
					}
				}
		}
	}
	foreach($trans['shipping_info'] as $pk=>$piv){
		switch($pk){
			case 'account_id':
			case 'address_status':
			case 'payer_status':
			case 'country_code':
				break;
			default:
				if(is_array($piv)){
					foreach($piv as $pppk=>$pppv){
						if(!empty($pppv)){
							$vwz_items[] = $pppv;
						}
					}
				}else{
					if(!empty($piv)){
						$vwz_items[] = $piv;
					}
				}
		}
	}
	if(sizeOf($vwz_items)>1){
		$chunks = array_chunk($vwz_items, ceil(count($vwz_items) / 2), true);
	}else{
		$chunks = [$vwz_items];
	}
	$insert_sql_array = array(
		'betrag'=>floatval($trans['transaction_info']['transaction_amount']['value']),
		'waehrung'=>$trans['transaction_info']['transaction_amount']['currency_code'],
		'buchungstag'=>$buchungstag,
		'bankleitzahl'=>'',
		'kontonummer'=>'',
		'verwendungszweck2'=>implode(' ',$chunks[0]),
		'verwendungszweck1'=>(isset($chunks[1]))?implode(' ',$chunks[1]):'',
		'verwendungszweck3'=>'TACode: '.$_GET['transaction_id'],
		'confirmed'=>0,
		'sorting'=>$sorting
	);
	$sorting++;
	yes_db_perform('incoming_payments',$insert_sql_array);
	$id = xtc_db_insert_id();
    die(json_encode([
		'MSG'=>'OK',
		'ipID'=>$id
	]));
}
switch($_GET['view']) {
    case 'list':
        $date = array();
        $date['actual']['tt'] = date('d');
        $date['actual']['mm'] = date('m');
        $date['actual']['yyyy'] = date('Y');
        $last_month  = mktime(0, 0, 0, date("m")-1, date("d"),   date("Y"));
        $date['last_month']['tt'] = date('d',$last_month);
        $date['last_month']['mm'] = date('m',$last_month);
        $date['last_month']['yyyy'] = date('Y',$last_month);
        $filter = array(
            'for' => '1',
            'span'=>'broad'
        );
        $response = array();
        $_response = $paypal->TransactionSearch($filter);
        if(is_array($_response) and sizeOf($_response)){
           foreach($_response as $ptx){
               $unknown_ptx = false;
               if(empty($ptx['EMAIL']) or $ptx['AMT'] <= 0){
                   continue;
               }
               $query = xtc_db_query(sprintf(
                       "SELECT paypal_ipn_id FROM paypal WHERE txn_id='%s'",
                       $ptx['TXNID']
               ));
               if(!xtc_db_num_rows($query)){
                    $query = xtc_db_query(sprintf(
                            "SELECT orders_id FROM orders WHERE payment_transaction_id='%s'",
                            $ptx['TXNID']
                    ));
                    if(!xtc_db_num_rows($query)){
                        $unknown_ptx = true;
                    }
               }
               if($unknown_ptx){
                   $response[] = $ptx;
               }
           }
        }
        break;
    case 'refund' :
		if(isset($_GET['paypal_ipn_id'])) {
			$query = "SELECT * FROM ".TABLE_PAYPAL." WHERE paypal_ipn_id = '" . (int) $_GET['paypal_ipn_id'] . "'";
			$query = xtc_db_query($query);
			$ipn_data = xtc_db_fetch_array($query);
		}
		if($_GET['action'] == 'perform') {
		// refunding
			$txn_id = xtc_db_prepare_input($_POST['txn_id']);
			$ipn_id = xtc_db_prepare_input($_POST['ipn_id']);
			$amount = xtc_db_prepare_input($_POST['amount']);
			$note = xtc_db_prepare_input($_POST['refund_info']);
			//$orders_id = xtc_db_prepare_input($_POST['refund_orders_id']);
			$refund_amount = xtc_db_prepare_input(str_replace(',','.',$_POST['refund_amount']));
			$query = "SELECT * FROM ".TABLE_PAYPAL." WHERE paypal_ipn_id = '" . (int) $ipn_id . "'";
			$query = xtc_db_query($query);
			$ipn_data = xtc_db_fetch_array($query);
			$response = $paypal->RefundTransaction($txn_id, $ipn_data['mc_currency'], $amount, $refund_amount, $note);
			if($response['ACK'] == 'Success') {
				xtc_redirect(xtc_href_link(FILENAME_PAYPAL, 'err=refund_Success'));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_PAYPAL, 'view=detail&paypal_ipn_id=' . (int) $ipn_id . '&err=error_' . $response['L_ERRORCODE0']));
			}
		}
		break;
	case 'search' :
		$date = array();
		$date['actual']['tt'] = date('d');
		$date['actual']['mm'] = date('m');
		$date['actual']['yyyy'] = date('Y');
		$last_month  = mktime(0, 0, 0, date("m")-1, date("d"),   date("Y"));
		$date['last_month']['tt'] = date('d',$last_month);
		$date['last_month']['mm'] = date('m',$last_month);
		$date['last_month']['yyyy'] = date('Y',$last_month);
		if($_GET['action'] == 'perform') {
			$response = '';
//echo '<pre>';
//print_r ($response);
//echo '</pre>';
		}
		break;
	case 'capture' :
		if(PAYPAL_COUNTRY_MODE!='uk') xtc_redirect(xtc_href_link(FILENAME_PAYPAL));
		if(isset($_GET['paypal_ipn_id'])) {
			$query = "SELECT * FROM ".TABLE_PAYPAL." WHERE paypal_ipn_id = '" . (int) $_GET['paypal_ipn_id'] . "'";
			$query = xtc_db_query($query);
			$ipn_data = xtc_db_fetch_array($query);
		}
		if($_GET['action'] == 'perform') {
			// refunding
			$txn_id = xtc_db_prepare_input($_POST['txn_id']);
			$ipn_id = xtc_db_prepare_input($_POST['ipn_id']);
			$amount = xtc_db_prepare_input($_POST['amount']);
			$note = xtc_db_prepare_input($_POST['refund_info']);
			$capture_amount = xtc_db_prepare_input($_POST['capture_amount']);
			$query = "SELECT * FROM ".TABLE_PAYPAL." WHERE paypal_ipn_id = '" . (int) $ipn_id . "'";
			$query = xtc_db_query($query);
			$ipn_data = xtc_db_fetch_array($query);
			$response = $paypal->DoCapture($txn_id, $ipn_data['mc_currency'], $amount, $capture_amount, $note);
			if($response['ACK'] == 'Success') {
				$response = $paypal->GetTransactionDetails($ipn_data['txn_id']);
				$data = array();
				$data['paypal_ipn_id'] = $ipn_id;
				$data['txn_id'] = $txn_id;
				$data['payment_status'] ='Pending';
				$data['pending_reason'] = 'partial-capture';
				$data['mc_amount'] = $capture_amount;
				$data['date_added']='now()';
				if($response['PAYMENTSTATUS']=='Completed') {
					$data['payment_status'] = 'Completed';
					$data['pending_reason'] = 'completed-capture';
					xtc_db_query("UPDATE ".TABLE_PAYPAL." SET payment_status='Completed',pending_reason='',mc_gross=mc_authorization WHERE paypal_ipn_id='".$ipn_id."'");
				}
				// update captured amount
				xtc_db_query("UPDATE ".TABLE_PAYPAL." SET mc_captured = (mc_captured+".$capture_amount.") WHERE paypal_ipn_id='".$ipn_id."'");
				// save capture in DB
				xtc_db_perform('paypal_status_history',$data);
				// update transaction
				xtc_redirect(xtc_href_link(FILENAME_PAYPAL, 'err=capture_Success'));
			} else {
				xtc_redirect(xtc_href_link(FILENAME_PAYPAL, 'view=capture&paypal_ipn_id=' . (int) $ipn_id . '&err=error_' . $response['L_ERRORCODE0']));
			}
		}
	break;
}

yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$buttons = array();
$buttons[] = array('text'=>'Webhooks',
	'link'=>xtc_href_link(basename(__FILE__),'action=webhooks'),
	'lbOn'=>true,
	'auth'=>true
);

$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE  ,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
	'TEXT_PAYMENT_ALLOCATION'=>TEXT_PAYMENT_ALLOCATION,
));

$smarty->display('paypal.html');
?>
<!-- header_eof //-->
<!-- body //-->
			<table border="0" width="100%" cellspacing="0" cellpadding="2">
				<tr>
					<td>
<?php
// errors
if(isset($_GET['err']))
	$error = $paypal->getErrorDescription($_GET['err']);
switch($_GET['view']) {
	case 'detail' :
		include(DIR_WS_MODULES . 'paypal_transactiondetail.php');
		break;
	case 'refund' :
		include(DIR_WS_MODULES . 'paypal_refundtransaction.php');
		break;
	case 'capture' :
		include(DIR_WS_MODULES . 'paypal_capturetransaction.php');
		break;
	case 'list':
	case 'search':
		include(DIR_WS_MODULES . 'paypal_searchtransaction.php');
		break;
	case 'auth' :
		include(DIR_WS_MODULES . 'paypal_authtransaction.php');
		break;
	default :
		include(DIR_WS_MODULES . 'paypal_listtransactions.php');
		break;
}
?>
					</td>
				</tr>
			</table>
		</td>
<!-- body_text_eof //-->
  </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
