<?php
/* --------------------------------------------------------------
   $Id: orders_tab.php,v 1.190 2020/06/24 08:50:06 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.109 2003/05/28); www.oscommerce.com
   (c) 2003	 nextcommerce (orders.php,v 1.19 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public Licensekic
   --------------------------------------------------------------
   Third Party contribution:
   OSC German Banktransfer v0.85a       	Autor:	Dominik Guder <osc@guder.org>
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   credit card encryption functions for the catalog module
   BMC 2003 for the CC CVV Module

   Released under the GNU General Public License
   --------------------------------------------------------------*/
$oID = intval(xtc_db_input($_GET['oID']??0));
$order = new order($oID);
//$order->info['comments'] = wordwrap($order->info['comments'], 80,'-<br />',true);

$order_array = array('info'=>$order->info,
    'products'=>$order->products,
    'totals'=>$order->totals,
    'billing'=>xtc_db_prepare_input($order->billing),
    'customer'=>xtc_db_prepare_input($order->customer),
    'delivery'=>xtc_db_prepare_input($order->delivery)
);  
$order_array['customer']['email_aliases'] = yes_get_customers_email_aliases($order->customer['ID']);
$smarty->assign('order',$order_array);
$fibu_number = $order->get_fibunumber();
$title_order = $order->get_title($fibu_number);
$smarty->assign('JS_TEXT_CALC_SUM',JS_TEXT_CALC_SUM);
$smarty->assign('ENTRY_CREDIT_CARD_TYPE',ENTRY_CREDIT_CARD_TYPE);
$smarty->assign('ENTRY_CREDIT_CARD_OWNER',ENTRY_CREDIT_CARD_OWNER);
$smarty->assign('ENTRY_CREDIT_CARD_NUMBER',ENTRY_CREDIT_CARD_NUMBER);
$smarty->assign('ENTRY_CREDIT_CARD_EXPIRES',ENTRY_CREDIT_CARD_EXPIRES);
$smarty->assign('TEXT_BANK_NAME',TEXT_BANK_NAME);
$smarty->assign('TEXT_BANK_BLZ',TEXT_BANK_BLZ);
$smarty->assign('TEXT_BANK_NUMBER',TEXT_BANK_NUMBER);
$smarty->assign('TEXT_BANK_OWNER',TEXT_BANK_OWNER);
$smarty->assign('TEXT_BANK_STATUS',TEXT_BANK_STATUS);
$smarty->assign('TEXT_BANK_ERRORCODE',TEXT_BANK_ERRORCODE);
$smarty->assign('TEXT_BANK_PRZ',TEXT_BANK_PRZ);
$smarty->assign('TEXT_BANK_FAX',TEXT_BANK_FAX);
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$smarty->assign('TEXT_EBAYAPI_BUG',TEXT_EBAYAPI_BUG);
$smarty->assign('TEXT_EBAYAPI_BUG_SHIPPINGADDRESS',TEXT_EBAYAPI_BUG_SHIPPINGADDRESS);
$smarty->assign('TEXT_EBAYAPI_BUG_REGISTRATIONADDRESS',TEXT_EBAYAPI_BUG_REGISTRATIONADDRESS);
$smarty->assign('TEXT_EBAYAPI_BUG_ADDRESS',TEXT_EBAYAPI_BUG_ADDRESS);
$smarty->assign('LINK_TEXT_UPDATE',LINK_TEXT_UPDATE);

$smarty->assign('LINK_TEXT_EDIT',IMAGE_EDIT);
$smarty->assign('MSG_AUTH_CHANGE_PAYMODE',MSG_AUTH_CHANGE_PAYMODE);
$smarty->assign('BUTTON_EXT_STORNO',BUTTON_EXT_STORNO);
$smarty->assign('BUTTON_PRINT_ACCOUNTING',BUTTON_PRINT_ACCOUNTING);
$smarty->assign('BUTTON_PRINT_PACKINGSLIP',BUTTON_PRINT_PACKINGSLIP);
$smarty->assign('BUTTON_PRINT_PACKINGSLIP_ALLPRODUCTS',BUTTON_PRINT_PACKINGSLIP_ALLPRODUCTS);
$smarty->assign('BUTTON_PDF_PACKINGSLIP',BUTTON_PDF_PACKINGSLIP);
$smarty->assign('MSG_AUTH_CHECKOUT_COUNTER_EDIT',MSG_AUTH_CHECKOUT_COUNTER_EDIT);
$smarty->assign('TEXT_BLOCK_WARNING',TEXT_BLOCK_WARNING);
$smarty->assign('TEXT_BLOCK_WARNING_TOTAL',TEXT_BLOCK_WARNING_TOTAL);
$smarty->assign('TEXT_ORDER_HAS_RECLAMATIONS',TEXT_ORDER_HAS_RECLAMATIONS);
$smarty->assign('TEXT_ORDER_HAS_NO_RECLAMATIONS',TEXT_ORDER_HAS_NO_RECLAMATIONS);
$smarty->assign('TEXT_ORDER_COSTS',TEXT_ORDER_COSTS);
$smarty->assign('TEXT_ORDER_NO_ADD_RECLAMATIONS',TEXT_ORDER_NO_ADD_RECLAMATIONS);
$smarty->assign('BUTTON_REIMBURSEMENT',BUTTON_REIMBURSEMENT);
$smarty->assign('MSG_AUTH_RECLAMATIONS',MSG_AUTH_RECLAMATIONS);
$smarty->assign('ORDERS_STATUS_OFFER',ORDERS_STATUS_OFFER);
$smarty->assign('TEXT_OFFER_NO_RECLAMATIONS',TEXT_OFFER_NO_RECLAMATIONS);
$ebaynetto_cs_array = [['id'=>'','text'=>TEXT_SELECT]];
foreach(xtc_get_customers_statuses($_SESSION['languages_id']) as $cs){
	if(!in_array($cs['id'],[0,$order->info['status']])){
		$ebaynetto_cs_array[] = ['id'=>$cs['id'],'text'=>$cs['text']];
	}
}
$email_parts = explode('@',EMAIL_SUPPORT_ADDRESS);
$email_domain = $email_parts[1];
$email_user = $oID.'_'.($order->info['ebay_userid']??'');
$ebaynetto_email = sprintf('%s@%s',$email_user, $email_domain);
$storages_options_select = [['id'=>'0','text'=>TEXT_SELECT]];
$storages_options = xtc_array_merge($storages_options_select, xtc_get_storages());

$smarty->assign(array(
    'TEXT_NO_REIMBURSEMENTS_SAVED'=>TEXT_NO_REIMBURSEMENTS_SAVED,
    'ENCODED_CURRENT_PAGE_LINK'=>urlencode(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('tab','action')).'action=edit')),
    'JS_CONFIRM_REALLY_COPY_ORDER'=>JS_CONFIRM_REALLY_COPY_ORDER,
    'TEXT_TAB_COSTS_DECKUNGSBEITRAG_INTRO'=>TEXT_TAB_COSTS_DECKUNGSBEITRAG_INTRO,
    'TEXT_TAB_COSTS_FIXKOSTEN'=>TEXT_TAB_COSTS_FIXKOSTEN,
    'TEXT_TAB_COSTS_PACKAGING_COSTS'=>TEXT_TAB_COSTS_PACKAGING_COSTS,
    'TEXT_TAB_COSTS_EK'=>TEXT_TAB_COSTS_EK,
    'TEXT_TAB_COSTS_DECKUNGSBEITRAG'=>TEXT_TAB_COSTS_DECKUNGSBEITRAG,
    'TEXT_RECREATE_DHL_LABEL'=>TEXT_RECREATE_DHL_LABEL,
    'STOP_RECREATE_DHL_LABEL'=>STOP_RECREATE_DHL_LABEL,
    'UNSTOP_RECREATE_DHL_LABEL'=>UNSTOP_RECREATE_DHL_LABEL,
    'JS_CONFIRM_REALLY_DELETE_ITEMS'=>JS_CONFIRM_REALLY_DELETE_ITEMS,
    'VERSENDER_VORGABE_AENDERN_ERLAUBT'=>(in_array($order->info['orders_status'],[ORDERS_STATUS_ABGESCHLOSSEN, ORDERS_STATUS_VERSENDET, ORDERS_STATUS_STORNIERT])) ? 0 : 1,
	'IS_EBAY_ORDER_RESERVATION_ORDER'=>(defined('EBAY_ORDER_RESERVATION_ORDERS_ID') and intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) == intval($order->info['id'])),
	'INPUT_CUSTOMERS_STATUS_ID'=>xtc_draw_pull_down_menu('ebaynetto_cs',$ebaynetto_cs_array,'','id="ebaynetto_cs"'),
	'INPUT_EBAYNETTO_EMAIL'=>xtc_draw_input_field('ebaynetto_email',$ebaynetto_email,'id="ebaynetto_email" size="32"',false,'email'),
	'INPUT_EBAYNETTO_CID'=>xtc_draw_input_field('ebaynetto_cid','','id="ebaynetto_cid" size="7"',false,'number'),
	'ALLOW_EBAYNETTO'=>(in_array($order->info['orders_status'],[1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_BEZAHLT]) and $order->info['source'] == 'ebay')?true:false,
	'TEXT_ORDER_CHANGE_CURRENCY'=>TEXT_ORDER_CHANGE_CURRENCY,
	'COMMISSION_NUMBER_TITLE'=>COMMISSION_NUMBER_TITLE,
	'DISTRIBUTION_WAREHOUSE_STORAGE_ID_TITLE'=>DISTRIBUTION_WAREHOUSE_STORAGE_ID_TITLE,
	'INPUT_DISTRIBUTION_WAREHOUSE_STORAGE_ID'=>xtc_draw_pull_down_menu('distribution_warehouse_storage_id', $storages_options, $order->info['distribution_warehouse_storage_id']),
));
$allow_address_edit = ( !in_array($order->info['orders_status'],array(ORDERS_STATUS_UPSELLING,ORDERS_STATUS_STORNIERT)) and ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_edit_address'] == '1' )) ? 1 : 0);
$display_errors = [];

if(defined('MODULE_SHIPPING_WEMALO_STATUS') and MODULE_SHIPPING_WEMALO_KEY != ''){
    require_once(DIR_WS_CLASSES.'wemalo.php');
    if(wemalo::is_wemalo_order( $order->info['id'] )){
        $wemalo = new wemalo;
        $winfo = $wemalo->getOrderPackages($order->info['id']);
        $smarty->assign('wemalo_order_packages',$winfo);
    }
}


switch($order->info['orders_status']){
	case ORDERS_STATUS_BEZAHLT:
		if($admin_access['f_change_order_if_status_bezahlt'] != 1){
			$allow_address_edit = false;
		}
		break;
	case ORDERS_STATUS_ABGESCHLOSSEN:
	case ORDERS_STATUS_VERSENDET:
		if($admin_access['f_orders_edit_after_shipping'] != 1){
			$allow_address_edit = false;
		}
		break;
        case ORDERS_STATUS_STORNIERT;
            break;
        default:
            // CHECK LOW ORDER FEE
            // KANN JA ZB DURCH HINZUFUEGEN VON ARTIKELN INZWISCHEN WEGGEFALLEN 
            // SEIN
            if(!$order->check_low_order_fee()){
                $display_errors[] = sprintf(ADD_LOWORDERFEE_ERROR,
                    number_format(MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER,2,',','')
                );
            }
            break;
}


$smarty->assign(array(
    'DISPLAY_ERRORS'=>$display_errors,
    'BUTTON_CHANGE_PAYDATE'=>BUTTON_CHANGE_PAYDATE,
    'TEXT_NO_RETOURES_SAVED'=>TEXT_NO_RETOURES_SAVED,
    'LINK_ADDRESS_EDIT_CUSTOMER'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=customer'),
    'LINK_ADDRESS_EDIT_SHIPPING'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=shipping'),
    'LINK_ADDRESS_EDIT_INVOICE'=>xtc_href_link(FILENAME_ORDERS_EDIT,xtc_get_all_get_params(array('action','address_type')).'action=ajax_address_edit&address_type=invoice'),
    'ALLOW_ADDRESS_EDIT'=>$allow_address_edit,
    'PART_ORDERS'=>$order->get_part_order_short_html(),
    'NOT_SHIP_PRODUCTS'=>$order->get_not_ship_short_html(),
    'TEXT_PRODUCT_SHIPPINGINFO_QTY'=>TEXT_PRODUCT_SHIPPINGINFO_QTY,
    'TEXT_PRODUCT_SHIPPINGINFO_QUANTITY_SHIPPED'=>TEXT_PRODUCT_SHIPPINGINFO_QUANTITY_SHIPPED,
    'TEXT_PRODUCT_SHIPPINGINFO_NOT_SHIP'=>TEXT_PRODUCT_SHIPPINGINFO_NOT_SHIP,
    'TEXT_ADD_DISCOUNT'=>TEXT_ADD_DISCOUNT,
    'TEXT_ADD_DISCOUNT_BUTTON'=>TEXT_ADD_DISCOUNT_BUTTON,
    'TEXT_REMOVE_DISCOUNT'=>TEXT_REMOVE_DISCOUNT,
    'TEXT_REMOVE_DISCOUNT_BUTTON'=>TEXT_REMOVE_DISCOUNT_BUTTON,
));




switch($_GET['tab']){
	default:
	    $amazon_link = '';
	    $amazon_orders = $order->get_amazon_items();
            $amazon_invoice_uploads = [];
	    if(sizeOf($amazon_orders)){
		$double_oaid = array();
		    foreach($amazon_orders as $ao){
			if(!in_array($ao['orig_amazon_orders_id'], $double_oaid)){
			    $amazon_link .= sprintf('<a target="_blank" href="https://sellercentral.amazon.de/orders-v3/order/%s">%s</a> ',
				    $ao['orig_amazon_orders_id'],$ao['orig_amazon_orders_id']
			    );	
			    $double_oaid[] = $ao['orig_amazon_orders_id'];
			}
                        $query = xtc_db_query(sprintf(
                                "SELECT invoice_upload FROM amazon_orders WHERE orig_amazon_orders_id='%s'",
                                $ao['orig_amazon_orders_id']
                        ));
                        if(xtc_db_num_rows($query)){
                            $record = xtc_db_fetch_array($query);
                            $amazon_invoice_uploads[] = sprintf(
                                    "<b>%s %s:</b> %s",
                                    TEXT_AMAZON_INVOICE_UPLOAD,
                                    $ao['orig_amazon_orders_id'],
                                    constant('TEXT_AMAZON_INVOICE_UPLOAD_STATUS_'.$record['invoice_upload'])
                            );
                        }
		    }
		    $smarty->assign(array(
                        'AMAZON_LINK'=>$amazon_link,
                        'AMAZON_INVOICE_UPLOADS'=>$amazon_invoice_uploads
                    ));
	    }
            
	    $customers_status_query = xtc_db_query(sprintf(
		    "SELECT customers_status FROM %s WHERE customers_id='%s'",
		    TABLE_CUSTOMERS,$order->customer['ID']
	    ));
	    $customers_status_res = xtc_db_fetch_array($customers_status_query);
	    $allow_recalc = true;
	    $allow_recalc_reasons = array();
            $has_shipping_costs = false;
	    foreach($order->totals as $ot){
		switch($ot['class']){
		    case 'ot_total':
		    case 'ot_subtotal':
		    case 'ot_subtotal_no_tax':
		    case 'ot_shipping':
		    case 'ot_tax':
                        if($ot['class'] == 'ot_shipping'){
                            // fuer produkt margen berechnung, dort werden
                            // dann versandkosten nicht mehr beruecksichtigt
                            $has_shipping_costs = true;
                        }
			break;
		    default:
			$allow_recalc = false;
			$allow_recalc_reasons[] = $ot['title'];
			if($ot['class'] == 'ot_discount'){
			    $smarty->assign('has_discount',1);
			}
			break;
		}
	    }
	    $allow_discount = $allow_recalc;
            $allow_split = true;
            $allow_edit = true;
            if($order->has_current_tax_failure()){
                $allow_discount = false;
                $allow_recalc = false;
                $allow_recalc_reasons[] = TAX_CALCULATION_DIFFERENCE_ERROR;
                $allow_split = false;
                $allow_edit = false;
            }
	    if(in_array($order->info['orders_status'],array(1,2,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_OFFER))){
                if($allow_discount){
                    $smarty->assign('allow_discount',$allow_discount);
                }
	    }
	    
	    if($customers_status_res['customers_status'] != $order->info['status']){
		$smarty->assign(array(
		    'ALLOW_RECALC'=>$allow_recalc,
		    'ALLOW_RECALC_REASONS'=>implode(', ',$allow_recalc_reasons),
		    'DISTINCT_CUSTOMERS_STATUS'=>1,
		    'WARNING_CUSTOMERS_STATUS_NOT_ORDERS_CUSTOMERS_STATUS'=>WARNING_CUSTOMERS_STATUS_NOT_ORDERS_CUSTOMERS_STATUS,
		    'TEXT_CHANGE_CUSTOMERS_STATUS'=>TEXT_CHANGE_CUSTOMERS_STATUS,
		    'TEXT_CHANGE_CUSTOMERS_STATUS_INTRO'=>TEXT_CHANGE_CUSTOMERS_STATUS_INTRO,
		    'TEXT_CHANGE_CUSTOMERS_STATUS_OLD'=>TEXT_CHANGE_CUSTOMERS_STATUS_OLD,
		    'TEXT_CHANGE_CUSTOMERS_STATUS_NEW'=>TEXT_CHANGE_CUSTOMERS_STATUS_NEW,
		    'CUSTOMERS_STATUS_OLD'=>$order->info['status_name'],
		    'CUSTOMERS_STATUS_NEW'=>  xtc_get_customers_status_name($customers_status_res['customers_status']),
		    'TEXT_HISTORY_ORDER_CUSTOMERS_STATUS_CHANGE_UNALLOWED_REASONS'=>TEXT_HISTORY_ORDER_CUSTOMERS_STATUS_CHANGE_UNALLOWED_REASONS,
		));
	    }
	    
		$smarty->assign(array(
		    'tab'=>'info',
		    'SOURCE'=>$order->get_source_title(),
		    'HAS_PART_DELIVERY'=>$order->has_part_delivery(),
                    'ADD_ANOTHER_DHL_LABEL'=>ADD_ANOTHER_DHL_LABEL,
		));
		// memoquery
                $anz = \YES4Trade\Model\customers_memo::count_by_customers_id((int)$order->customer['ID']);
		
                $smarty->assign([
                    'memos'=>$anz,
                    'DISPLAY_MEMOS'=>DISPLAY_MEMOS,
                    'memo_link'=>xtc_href_link(FILENAME_CUSTOMERS,'action=memo&cID='.$order->customer['ID'])
                ]);
                
		// yes accounting
		if ($admin_access['ebay_mail_frame'] == '1') {
			$smarty->assign('mail_popup_link','<a href="#" onclick="window.open(\''. xtc_href_link('ebay_mail_frame.php','oID='.$order->info['id'].'&email='.urlencode($order->customer['email_address']).'&box=reply').'\',\'_blank\');">');
		}
		// begin modification for banktransfer
		$banktransfer_query = xtc_db_query("select banktransfer_prz, banktransfer_status, banktransfer_owner, banktransfer_number, banktransfer_bankname, banktransfer_blz, banktransfer_fax from banktransfer where orders_id = '" . $order->info['id'] . "'");
		if(xtc_db_num_rows($banktransfer_query)){
			$banktransfer = xtc_db_fetch_array($banktransfer_query);
			$smarty->assign('banktransfer',$banktransfer);
			switch ($banktransfer['banktransfer_status']) {
		          case 1: $error_val = TEXT_BANK_ERROR_1; break;
		          case 2: $error_val = TEXT_BANK_ERROR_2; break;
		          case 3: $error_val = TEXT_BANK_ERROR_3; break;
		          case 4: $error_val = TEXT_BANK_ERROR_4; break;
		          case 5: $error_val = TEXT_BANK_ERROR_5; break;
		          case 8: $error_val = TEXT_BANK_ERROR_8; break;
		          case 9: $error_val = TEXT_BANK_ERROR_9; break;
			}
			$smarty->assign('error_val',$error_val);
		}
		// end modification for banktransfer
		
		// FIBUNUMBERS ADDON
		// BUGFIX 08.12.10 mario: BEI UPSELLING KEINE FIBU
		$number = '';
		if( defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
			$number = $order->get_fibunumber(true);
			if(empty($number) or $number==''){
				if($admin_access['f_orders_fibunumbers'] == 1 and ($order->info['orders_status'] != ORDERS_STATUS_UPSELLING and $order->info['orders_status'] != ORDERS_STATUS_STORNIERT)){
					$smarty->assign('fibunumbers_link',xtc_href_link('orders.php','action=set_fibunumber&oID='.$order->info['id']));
					$smarty->assign('fibunumbers_link_title',BUTTON_FIBUNUMBERS);
				}
			}else{
				$smarty->assign('FIBU_NUMBER',$number);
			}
		}
		
		// KASSE ADDON
		if($order->is_kasse()){
			$kasse = $order->get_kasse_data();
			if( $kasse['branches_id'] > 0){
				$kasse['filiale'] = xtc_get_branch_title($kasse['branches_id']);
			}else{
				$kasse['filiale'] = 'Standard';
			}
			if( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_switch_kasse_payment'] == '1')){
				$smarty->assign('change_kasse_paymode_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=change_kasse_paymode'));
			}
			$smarty->assign('CHECKOUT_COUNTER_DATE',sprintf(TEXT_CHECKOUT_COUNTER_DATE,$kasse['paymode'],date('d.m.Y',strtotime($kasse['date_purchased'])),$kasse['filiale']) );
		}
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_kasse_change_paydate'] == '1')) {
			if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT and $order->is_kasse()){
				$smarty->assign('change_paydate_link',xtc_href_link('orders.php','action=change_paydate&oID='.$order->info['id']));
				$smarty->assign('change_branch_link',yes_draw_href_link(BUTTON_CHANGE_BRANCH,xtc_href_link('orders.php','action=change_branch&oID='.$order->info['id']),'lbOn','','chbrch'));
			}
		}

		// KOMBINIERT-INFO
		if($order->info['combined_orders_id'] > 0) {
			$smarty->assign('combined_orders_link',xtc_href_link(FILENAME_ORDERS,'oID='.$order->info['combined_orders_id'].'&action=edit'));
		}

		$combined_array = $order->get_combined_orders();
		if(sizeOf($combined_array)>0){
	  		$smarty->assign('combined_child_orders',$combined_array);
		}
		
		$feedbacks = array();
		$ebay_transactions = array();
		if(sizeOf($combined_array)>0){
		    $ebay_links = array();
		    foreach($order->get_auction_array() as $ebay_id){
			$ebay_links[] = '<a target="_blank" href="'.xtc_get_ebay_link(xtc_get_auction_site($ebay_id)).$ebay_id.'">'.$ebay_id.'</a>';
		    }
		    $smarty->assign('EBAY_LINK',implode(', ',$ebay_links));
		    foreach($combined_array as $cok=>$cov){
			    $feedback_query = xtc_db_query("SELECT ef.CommentingUser,ef.ItemNumber,ef.CommentType,ef.CommentText,ef.TimeOfComment,ef.status FROM ebay_transactions et LEFT JOIN ebay_feedback ef ON ef.ItemNumber=et.ebayid AND (ef.TransactionID=et.transactionid OR ef.TransactionID=0) AND ef.CommentingUser=et.userid WHERE et.orders_id='".$cov['orders_id']."'");
			    if(xtc_db_num_rows($feedback_query)){
				    $feedback = xtc_db_fetch_array($feedback_query);
				    if($feedback['ItemNumber'] != '')
					    $feedbacks[] = $feedback;
			    }
			    $transaction_query = xtc_db_query("SELECT et.ebayid,et.transactionid FROM ebay_transactions et WHERE et.orders_id='".$cov['orders_id']."'");
			    if(xtc_db_num_rows($transaction_query)){
				    $transaction = xtc_db_fetch_array($feedback_query);
				    if($transaction['transactionid'] != '')
					    $ebay_transactions[] = array('transaction_id'=>$transaction['transactionid'],'ebay_id'=>$transaction['ebayid']);
			    }
		    }
		    $smarty->assign('FEEDBACKS',$feedbacks);
		}else{
			if($order->info['ebay_id'] != ''){
				$feedback_query = xtc_db_query("SELECT ef.CommentingUser,ef.ItemNumber,ef.CommentType,ef.CommentText,ef.TimeOfComment,ef.status FROM ebay_transactions et LEFT JOIN ebay_feedback ef ON ef.ItemNumber=et.ebayid WHERE et.orders_id='".$order->info['id']."' AND (ef.TransactionID=et.transactionid or ef.TransactionID=0) AND ef.CommentingUser=et.userid ");
				if(xtc_db_num_rows($feedback_query)){
					$feedback = xtc_db_fetch_array($feedback_query);
					if($feedback['ItemNumber'] != '')
						$feedbacks[] = $feedback;
				}
				$smarty->assign('FEEDBACKS',$feedbacks);
                                // BOF - neues ebay kombinieren handling cron_ebay_orders
                                $ebay_links = [];
                                $trans_query = xtc_db_query(sprintf(
                                        "SELECT ebayid AS ebay_id FROM ebay_transactions WHERE orders_id='%d'",
                                        $order->info['id']
                                ));
                                while($trans = xtc_db_fetch_array($trans_query)){
                                    $ebay_links[] = '<a target="_blank" href="'.xtc_get_ebay_link(xtc_get_auction_site($trans['ebay_id'])).$trans['ebay_id'].'">'.$trans['ebay_id'].'</a>';
                                }
				$smarty->assign('EBAY_LINK',implode('<br />',$ebay_links));

				$transaction_query = xtc_db_query("SELECT et.ebayid,et.transactionid FROM ebay_transactions et WHERE et.orders_id='".$order->info['id']."'");
				if(xtc_db_num_rows($transaction_query)){
                                    while($transaction = xtc_db_fetch_array($transaction_query)){
					if($transaction['transactionid'] != ''){
                                            $ebay_transactions[] = array('transaction_id'=>$transaction['transactionid'],'ebay_id'=>$transaction['ebayid']);
                                        }
                                    }
				}
                                
                                //
                                // BEIM EINLESEN VON TRANSAKTIONEN WARTEN WIR EINE
                                // STUNDE BEVOR DER AUFTRAG IM VERSANDMODUL GELISTET
                                // WIRD. HIERMIT KANN DIESE SPERRE UMGANGEN WERDEN
                                //
                                if( $order->get_allow_shipping_ebay_1_hour_active()){
                                    $smarty->assign('ALLOW_SHIPPING_EBAY_1_HOUR',[
                                        'DURATION_STRING'=>sprintf(TEXT_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION,$order->get_allow_shipping_ebay_1_hour_active_duration()),
                                        'ACTIVE'=>"".$order->getAllow_shipping_ebay_1_hour(),
                                        'TOGGLE_LINK'=>xtc_href_link(FILENAME_ORDERS,'action=set_allow_shipping_ebay_1_hour_active&oID='.$order->info['id']),
                                        'TEXT_ALLOW_SHIPPING_EBAY_1_HOUR'=>TEXT_ALLOW_SHIPPING_EBAY_1_HOUR,
                                        'INTRO_ALLOW_SHIPPING_EBAY_1_HOUR'=>INTRO_ALLOW_SHIPPING_EBAY_1_HOUR,
                                        'BUTTON_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR'=>BUTTON_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR,
                                        'CONFIRM_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION_INACTIVE'=>CONFIRM_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION_INACTIVE,
                                        'CONFIRM_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION_ACTIVE'=>CONFIRM_TOGGLE_ALLOW_SHIPPING_EBAY_1_HOUR_REST_DURATION_ACTIVE,
                                        'ALLOW_SHIPPING_EBAY_1_HOUR_UPDATED'=>ALLOW_SHIPPING_EBAY_1_HOUR_UPDATED
                                    ]);
                                }
                                
			}
		}
		$smarty->assign('EBAY_TRANSACTIONS',$ebay_transactions);
		
		if(!defined('TABLE_PAYPAL')){
			define('TABLE_PAYPAL','paypal');
		}
		if(!defined('FILENAME_PAYPAL')){
			define('FILENAME_PAYPAL','paypal.php');
		}
		/*
		if ($order->info['payment_method']=='paypal_ipn' or $order->info['payment_method']=='paypal_directpayment' or $order->info['payment_method']=='paypal') {
			$paypal = new paypal_admin();
			$smarty->assign('PAYPAL_NOTE',$paypal->admin_notification((int)$_GET['oID']));
		}*/


		

		// ALTES KOMBINIEREN HANDLING
		if($order->info['is_parent'] == 'y') {
	  		$smarty->assign('child_orders',$order->get_child_orders());
		}

		if($order->info['parent_orders_id'] > 0) {
	  		// yes accounting
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_view'] == '1')) {
				$smarty->assign('parent_orders_link',xtc_href_link(FILENAME_ORDERS,'oID='.$order->info['parent_orders_id'].'&action=edit'));
			}
		}

		$javascript_string = '';		
		$reclamations = array();
		for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
			$product_collies = xtc_get_product_collies($order->products[$i]['id']);
			if(sizeOf($product_collies)>0){
				foreach($product_collies as $k=>$collie){
					$reclamation_query = xtc_db_query("SELECT rp.products_quantity,r.reclamations_type,r.reclamations_status, r.reclamations_id,date_format(r.date_created,'%d.%m.%y') as datum FROM reclamations_products rp,reclamations r WHERE r.orders_id='".$order->info['id']."' and rp.products_id='".$collie['collie_products_id']."' and rp.reclamations_id=r.reclamations_id");
					while( $reclamation = xtc_db_fetch_array($reclamation_query) ){
						$reclamations[ $order->products[$i]['id'] ]= true;
					}
				}
			}else{
				$reclamation_query = xtc_db_query("SELECT rp.products_quantity,r.reclamations_type,r.reclamations_status, r.reclamations_id,date_format(r.date_created,'%d.%m.%y') as datum FROM reclamations_products rp,reclamations r WHERE r.orders_id='".$order->info['id']."' and rp.products_id='".$order->products[$i]['id']."' and rp.reclamations_id=r.reclamations_id");
				while( $reclamation = xtc_db_fetch_array($reclamation_query) ){
					$reclamations[ $order->products[$i]['id'] ]= true;
				}
			}
		}

		$products_total_sum = 0;
		$sum_netto = 0;
		$weight_total = 0;
		$volume_total = 0;
		$products = array();
		$products_date_available = $order->get_products_date_available();		
		$xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
		$total_marge = 0;
		$own_weight_total = 0;
		$own_volume_total = 0;
		for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
			$product = array();
			$product['properties'] = $order->products[$i]['properties'];
			$products_total_sum += $order->products[$i]['qty'];
			$product['collies'] = xtc_get_product_collies($order->products[$i]['id']);
			$product['collies_rowspan'] = sizeOf($product['collies']);
			$product['name'] = xtc_db_prepare_input($order->products[$i]['name']);
			$product['slave_title'] = xtc_get_products_slave_title($order->products[$i]['id']);
			$product['comments'] = yes_get_product_comments($order->products[$i]['id']);
			$product['model'] = $order->products[$i]['model'];
            $product['opID'] = $order->products[$i]['opID']; 
			if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
			    if($order->info['marge'] != 0){
				$product['marge'] = $order->products[$i]['marge'];
			    }else{
				$product_marge = 0;
			    }
			}
			$product['id'] = $order->products[$i]['id'];
			if(isset($products_date_available[$product['id']])){
                            $product['date_available'] = $products_date_available[$product['id']];
                        }else{
                            $product['date_available'] = false;
                        }
			if(sizeOf($product['collies'])>0){
                            $product['name'] = '<b>[C]</b>&nbsp;'.$product['name'];
                            foreach($product['collies'] as $k=>$collie){

                                // ARTIKELNR DER COLLIS
                                $art_nr_query = xtc_db_query("SELECT products_model FROM products WHERE products_id='".$collie['collie_products_id']."'");
                                $art_nr = xtc_db_fetch_array($art_nr_query);
                                if(xtc_not_null($art_nr['products_model'])){
                                    $product['collies'][$k]['model'] = xtc_db_prepare_input($art_nr['products_model']);
                                }
                                $product['collies'][$k]['name'] = xtc_get_products_name($collie['collie_products_id']);
                                $product['collies'][$k]['order_qty'] = $collie['quantity']*$order->products[$i]['qty'];
                                $product['collies'][$k]['id'] = $collie['collie_products_id'];

                                //MARGENRECHNER
                                if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
                                    if($admin_access['f_products_distributors_prices'] == 1){
                                        if($order->info['marge'] == 0){
                                            $product['marge'] += $order->get_product_marge($product['collies'][$k]['id'], $product['collies'][$k]['order_qty']);
                                        }
                                    }
                                }
                            }
			}else{
			    // MARGENRECHNER
			    if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
				if($admin_access['f_products_distributors_prices'] == 1){
				    if(floatval($order->products[$i]['marge']) == 0){
						$product['marge'] = $order->get_product_marge($order->products[$i]['id'], $order->products[$i]['qty']);
				    }else{
						$product['marge'] = $order->products[$i]['marge'];
                    }
				}
			    }
			}

			if( isset($reclamations[ $order->products[$i]['id'] ])){
				$product['reclamation_link'] = xtc_image('images/icon_status_red.gif',TEXT_ERROR_RECLAMATION_FOR_PRODUCT_EXISTS);
			}

			$product['weight'] = xtc_get_ext_products_weight($order->products[$i]['id']);
			$product['weight_total'] = $product['weight']*$order->products[$i]['qty'];
			$weight_total += $product['weight']*$order->products[$i]['qty'];
		
			$product['volume'] = xtc_get_volumina($order->products[$i]['id'],4);
			$product['volume_total'] = floatval(str_replace(',','.',$product['volume']))*$order->products[$i]['qty'];
			$volume_total += $product['volume_total'];

			$product['price'] = $xtPrice->xtcFormat($order->products[$i]['final_price'], true);
			$product['single_price'] = $xtPrice->xtcFormat($order->products[$i]['final_price']/$order->products[$i]['qty'], true);
			$product['edit_link'] = xtc_href_link('categories.php','pID='.$order->products[$i]['id'].'&cPath='.xtc_get_product_path($order->products[$i]['id']).'&action=new_product');
			$product['qty'] = $order->products[$i]['qty'];
			$product['quantity_shipped'] = $order->products[$i]['quantity_shipped'];
			$product['not_ship'] = $order->products[$i]['not_ship'];
			if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
			    $product['marge_formatted'] = number_format($product['marge'],2,',','.');
			}
			if($order->info['source'] == 'amazon'){
			    $asin_query = xtc_db_query(sprintf(
				"SELECT asin FROM amazon_products WHERE products_id='%s' AND asin!=''",
				$order->products[$i]['id']
			    ));
			    if(xtc_db_num_rows($asin_query)){
				$asin_record = xtc_db_fetch_array($asin_query);
				$product['amazon_asin'] = $asin_record['asin'];
			    }
			}
			$product['own_weight'] = $order->products[$i]['weight'];
			$product['own_weight_total'] = $order->products[$i]['weight']*$order->products[$i]['qty'];
			$product['own_volume'] = $order->products[$i]['volume'];
			$product['own_volume_total'] = $order->products[$i]['volume']*$order->products[$i]['qty'];
			$own_weight_total += $product['own_weight_total'];
			$own_volume_total += $product['own_volume_total'];
			$puc = \YES4Trade\Model\product_un_classification::get_by_products_id(intval($order->products[$i]['id']));
			if($puc !== null){
				$product['UN_CLASSIFICATION_TITLE'] = $puc->get_un_classification_title();
			}
			$products[] = $product;
		}
		$smarty->assign([
			'volume_total'=>$volume_total,
			'own_weight_total'=>$own_weight_total,
			'own_volume_total'=>$own_volume_total
		]);
		if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
		    if($admin_access['f_products_distributors_prices'] == 1){
			if($order->info['marge'] == 0){
			    $marge = $order->get_marge();
			    $smarty->assign('marge',$marge);
			}else{
			    $smarty->assign('marge_formatted',number_format($order->info['marge'],2,',','.'));
			}
		    }
		}
                if($order->info['status'] != 1){
                    $smarty->assign('allow_copy',true);
                }
		$smarty->assign(array(
		    'SHIPPING_CLASS_EDIT_LINK'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=quick_edit_shipping_class'),
		    'TEXT_QUICK_SHIPPING_EDIT'=>TEXT_QUICK_SHIPPING_EDIT,
		    'PAYMENT_METHOD'=>xtc_get_payment_method_title($order->info['payment_method']),
		    'TEXT_NO_SPLIT_BY_DISCOUNT_ORDER'=>TEXT_NO_SPLIT_BY_DISCOUNT_ORDER,
			'UN_SCORE'=>$order->get_un_score()
		));
		$smarty->assign('products',$products);
		$smarty->assign('weight_total',$weight_total);
		$smarty->assign('sum_netto',format_price($sum_netto,1,$order->info['currency'],0,0));
		
		// das muss kundengruppenabh. sein
		$export_note = xtc_get_customers_status_export_note($order->info['status'],$_SESSION['languages_id']);
		if($export_note != '')
			$smarty->assign('notax',$export_note);
			
		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_split'] == '1')) {
			// ORDERSPLIT bedingung
			
			// BOF - Neue Paypal Statii
			$allow_orders_statuses = array(ORDERS_STATUS_UPSELLING, ORDERS_STATUS_BEZAHLT,1,2);
			if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and MODULE_PAYMENT_PAYPAL_STATUS == 'True'){
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_TMP_ID;
				//$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_SUCCESS_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_PENDING_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_REJECTED_ID;
			}
	
			if( $products_total_sum > 1 and $order->info['is_parent'] != 'y' and $order->info['parent_orders_id'] < 1 and in_array($order->info['orders_status'],$allow_orders_statuses) ) {
			// EOF - Neue Paypal Statii
                            // BOF MwSt Aenderungen - 2020/06
                            if($allow_split){
				// BOF - Bei FiBu kein Split
				if(empty($number) or $number==''){
					// EOF - Bei FiBu kein Split
					$smarty->assign('orders_split_link',yes_draw_href_button(
							sprintf(BUTTON_SPLIT,$title_order),
							xtc_href_link('orders_split.php','oID='.$order->info['id']),
						'width:120px;','button','ui-state-highlight'
					));
				}
                            }
                            // EOF MwSt Aenderungen - 2020/06
			} 
		}

		// VERSANDSPERRE BEDINGUNG
		// BOF - Neue Paypal Statii
		$allow_orders_statuses = array(ORDERS_STATUS_UPSELLING, ORDERS_STATUS_BEZAHLT,1,2);
		if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and MODULE_PAYMENT_PAYPAL_STATUS == 'True'){
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_TMP_ID;
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_SUCCESS_ID;
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_PENDING_ID;
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_REJECTED_ID;
		}
		$smarty->assign(array(
		    'BLOCK_SHIPPING_COMMENT'=>$order->info['block_shipping_comment'],
		    'BLOCK_SHIPPING'=>$order->info['block_shipping'],
		    'BLOCK_SHIPPING_END_DATE'=>($order->info['block_shipping_end_date'] > 0) ? xtc_date_short($order->info['block_shipping_end_date']) : ''
		));
		if( in_array($order->info['orders_status'],$allow_orders_statuses)){
		// EOF - Neue Paypal Statii
			if($order->info['block_shipping'] == 0){
				$smarty->assign('set_block_shipping_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=set_block_shipping'));
				$smarty->assign('set_block_shipping_button',"<input type='button' id=\"".$order->info['id']."\" value='".BLOCK_SHIPPING."' title='".BLOCK_SHIPPING_WITH_SPAN."' class='set_block_shipping_button ui-button ui-corner-all ui-state-default' style='width:200px;'>");
			}else{
				$smarty->assign('set_unblock_shipping_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=set_unblock_shipping'));
				$smarty->assign('set_unblock_shipping_button',"<input type='button' onClick='really_unblock_ship(\"".$order->info['id']."\");' title='".UNBLOCK_SHIPPING."' value='".UNBLOCK_SHIPPING."' class='ui-button ui-corner-all ui-state-error' style='width:200px;'>");
			}
		}
		
		// MAHNSPERRE BEDINGUNG

		if($order->info['orders_status'] == ORDERS_STATUS_OFFER){
			$smarty->assign('OFFER_WARNINGMODE',(($order->info['no_warning']==0)?YES:NO));
		}
		$allow_orders_statuses = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET);
		if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and MODULE_PAYMENT_PAYPAL_STATUS == 'True'){
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_TMP_ID;
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_SUCCESS_ID;
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_PENDING_ID;
			$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_REJECTED_ID;
		}

		if(in_array($order->info['orders_status'],$allow_orders_statuses)){
			$is_warn_query = xtc_db_query("SELECT warning_span FROM orders WHERE orders_id='".$order->info['id']."'");
			$is_warn = xtc_db_fetch_array($is_warn_query);
			if($is_warn['warning_span'] == 0){
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['ebayapi_warnings'] == '1')) {
					$smarty->assign('set_no_warn_span_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=set_no_warn_span'));
					$smarty->assign('set_no_warn_span_button',"<input type='button' onClick='really_nowarn_span(\"".$order->info['id']."\");' value='".BLOCK_ORDER_WARNINGS."' title='".BLOCK_ORDER_WARNINGS_SPAN."' class='ui-button ui-corner-all ui-state-default' style='width:200px;'>");
				}
			}else{
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['ebayapi_warnings'] == '1')) {
					$smarty->assign('unset_no_warn_span_link',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=unset_no_warn_span'));
					$smarty->assign('unset_no_warn_span_button',"<input type='button' onClick='really_unset_nowarn(\"".$order->info['id']."\");' value='".UNBLOCK_ORDER_WARNINGS."' title='".UNBLOCK_ORDER_WARNINGS."' class='ui-button ui-corner-all ui-state-error' style='width:200px;'>");
					$smarty->assign('warning_span',$is_warn['warning_span']);
				}
			}		
		}
		$warn_query = xtc_db_query("SELECT action,DATE_FORMAT(warning_date,'%d.%m.%Y.') as wd FROM ebay_warning_history WHERE orders_id='".$order->info['id']."'");
		if(xtc_db_num_rows($warn_query) > 0) {
			$warnings = array();
			while($warn = xtc_db_fetch_array($warn_query)){
				$warnings[] = $warn;
			}
			$smarty->assign('warnings',$warnings);
		}

		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_rueckstand'] == '1')) {
			$allow_orders_statuses = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_BEZAHLT);
			if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and MODULE_PAYMENT_PAYPAL_STATUS == 'True'){
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_TMP_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_SUCCESS_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_PENDING_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_REJECTED_ID;
			}

			if(in_array($order->info['orders_status'],$allow_orders_statuses)){
				if($order->info['rueckstand'] != 1){
					$smarty->assign('rueckstand_allow',1);
				}
			}
		}
		      	
		if($order->info['orders_status'] != ORDERS_STATUS_STORNIERT && $order->info['orders_status'] != ORDERS_STATUS_OFFER){
			if($admin_access['orders_storno'] == '1'){
				$smarty->assign('recla_ext_storno_link',xtc_href_link('orders_storno.php','ext_storno=1&oID='.$order->info['id']));
			}
		}

		if($admin_access['shipping'] == '1' and $order->allow_shipping()){
			// NACHSEHEN OB AUFTRAG BEREITS IM VERSANDMODUL GESPEICHERT
			$shipping_query = xtc_db_query(sprintf(
				"SELECT id FROM shippings WHERE orders_id='%s'",
				$order->info['id']
			));
			$shipping_saved = xtc_db_num_rows($shipping_query);
			if(str_contains($order->info['shipping_class'], 'selfpickup') !== true && $order->info['date_shipping'] == '0000-00-00 00:00:00' && !$shipping_saved ){
				//if(defined('YES_VERSANDABSCHLUSS_V2_TEST') and YES_VERSANDABSCHLUSS_V2_TEST == 'True'){
					$smarty->assign('VERSANDABSCHLUSS_V2',true);
				//}else{
				//    $smarty->assign('quick_shipping_link_title',IMAGE_QUICK_SHIPPING);
				//    $smarty->assign('quick_shipping_link',xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=quick_shipping'));
				//}
				$smarty->assign('one_click_shipping_link',xtc_href_link('shipping.php',xtc_get_all_get_params(array('action')).'action=one_click_shipping'));
				$smarty->assign('quick_shipping_process_title',BUTTON_QUICK_SHIPPING_PROCESS);
				$smarty->assign('quick_shipping_process_link',xtc_href_link('shipping.php','action=quick_shipping_confirm&ship_item_id[]='.$order->info['id'].'&ship_item_type=orders_id&from='.urlencode($from)));
                                
			}
                        $from = xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=edit');
		
		}

		$smarty->assign('orders_status_name',xtc_get_orders_status_name($order->info['orders_status']));

		$smarty->assign('edit_mode',1);

		
		// ACTIONS
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['orders_update'] == '1')) {
			$smarty->assign('orders_update_link',xtc_href_link('orders_update.php','oID='.$order->info['id']));
		}



		if($order->info['rueckstand'] == 1){
			$allow_orders_statuses = array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_BEZAHLT);
			if(defined('MODULE_PAYMENT_PAYPAL_STATUS') and MODULE_PAYMENT_PAYPAL_STATUS == 'True'){
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_TMP_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_SUCCESS_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_PENDING_ID;
				$allow_orders_statuses[] = PAYPAL_ORDER_STATUS_REJECTED_ID;
			}

			if(in_array($order->info['orders_status'],$allow_orders_statuses)){
				$smarty->assign('rueckstand',1);
				if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_rueckstand'] == '1')) {
					$smarty->assign('rueckstand_delete_link','<a href="javascript:really_unset_rueckstand(\''.$order->info['id'].'\');">'.xtc_image('images/icons/cross.gif',UNBLOCK_ORDER_RUECKSTAND).'</a>');
				}
			}
		}

		if( (!defined('KASSE_USER') || (int)KASSE_USER == 0) && !$_GET['redirect'] ) {
			$messageStack->add_session(ERROR_MISSING_USER_KASSE,'error');
		}
		if($order->customer['ID'] != KASSE_USER){
			$smarty->assign('crm_edit_link',xtc_href_link('customers.php','action=edit&cID='.$order->customer['ID']));
		}
		$smarty->assign(array(
		    'csID'=>$order->customer['csID'],
		    'TEXT_CSID'=>ENTRY_CID,
		    'SHIPPING_COMMENTS'=>$order->info['shipping_comments']
		));
		

		$smarty->assign('order_set_rueckstand_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=set_rueckstand' ));
		$smarty->assign('order_unset_rueckstand_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=unset_rueckstand' ));

		if($order->info['orders_status'] == ORDERS_STATUS_OFFER){
			$smarty->assign('BUTTON_PRINT',BUTTON_PRINT_OFFER);
			$smarty->assign('offer_email_link_title',BUTTON_EMAIL_OFFER);
			$smarty->assign('offer_email_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_offer_confirm&cID='.$order->customer['ID'] ));
			$smarty->assign('offer_to_order',yes_draw_href_button(
					BUTTON_OFFER_TO_ORDER,
					'javascript:offer_to_order(\''.xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action','cID')).'action=offer_to_order&cID='.$order->customer['ID'] ).'\');',
					'width:180px;')
			);
		}else{
			$invoice_array = array(ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET);
			if(in_array($order->info['orders_status'],$invoice_array)){
				$button_print_title = BUTTON_PRINT_INVOICE;
			}else{
				$button_print_title = BUTTON_PRINT_ORDER;
			}
			if(!empty($fibu_number) and strlen($fibu_number)>1){
				$button_print_title = BUTTON_PRINT_INVOICE;
			}
			$smarty->assign(array(
			    'BUTTON_EMAIL'=>sprintf(BUTTON_GENERIC_EMAIL,$title_order),
			    'order_email_allow'=>1
			));
			$smarty->assign('BUTTON_PRINT',$button_print_title);
			$smarty->assign('order_email_link',	xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_confirm&cID='.$order->customer['ID']));
			if($order->is_kasse()){
				
				$kasse_data = $order->get_kasse_data();
				
				$smarty->assign('BUTTON_PRINT_KASSE_SUCCESS',BUTTON_PRINT_KASSE_SUCCESS);
				$smarty->assign('BUTTON_PRINT_KASSE_LINK',xtc_href_link('print_order.php','oID='.$_REQUEST['oID'].'&kasse_payment_code='.$kasse_data['paymode']));
			}
		}

		// BEI DIESEN STATII WIRD AUFTRAGSBESTAETIGUNG ANGEBOTEN
		$order_confirmation_status_array = array(
			1,2,ORDERS_STATUS_OFFER,ORDERS_STATUS_UPSELLING
		);
		if(in_array($order->info['orders_status'],$order_confirmation_status_array)){
			if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_order_confirm'] == '1')) {
				$smarty->assign('order_confirmation_allow',1);
				$smarty->assign('BUTTON_OC_PRINT',BUTTON_PRINT_ORDER_CONFIRMATION);
				$smarty->assign('oc_email_button',BUTTON_EMAIL_ORDER_CONFIRMATION);
				$smarty->assign('oc_email_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_oc_confirm&cID='.$order->customer['ID'] ));
				$smarty->assign('print_oc_link',xtc_href_link(FILENAME_PRINT_ORDER,'oc=1&oID='.$order->info['id']));
			}
		}

		$smarty->assign('order_email_packing_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_packing&cID='.$order->customer['ID'] ));
		$smarty->assign('BUTTON_PACKINGSLIP_EMAIL',BUTTON_PACKINGSLIP_EMAIL);

		
                $smarty->assign('order_print_packingslip_allproducts_link',xtc_href_link(FILENAME_PRINT_PACKINGSLIP,'all_products=1&oID='.$order->info['id']));
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['print_packingslip'] == '1')) {
			if(PRINT_PACKINGSLIP_AFTER_PAYMENT == 'false' or ($order->info['orders_status'] == ORDERS_STATUS_BEZAHLT or (xtc_is_shipping_before_payment($order->info['payment_method']) && ($order->info['orders_status'] == 1 || $order->info['orders_status'] == ORDERS_STATUS_UPSELLING || $order->info['orders_status'] == 2 ) ) ) ){
				$smarty->assign('order_print_packingslip_allow',1);
				$smarty->assign('order_print_packingslip_link',xtc_href_link(FILENAME_PRINT_PACKINGSLIP,'oID='.$order->info['id']));
			}
		}
		if ( $admin_access['f_packingslip_pdf'] == '1' and $order->info['orders_status'] != ORDERS_STATUS_ABGESCHLOSSEN  and $order->info['orders_status'] != ORDERS_STATUS_STORNIERT and $order->info['orders_status'] != ORDERS_STATUS_VERSENDET ) {
			$smarty->assign('pdf_packingslip_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=packingslip_pdf' ));
		}
		
		
		
		
		$days_purchased = ((time()-strtotime($order->info['date_purchased']))/60/60/24); // wieviel tage ist die rechn alt
		if(FEEDBACK_REMINDER_ACTIVE == 'True' and $order->info['ebay_id'] != '' and $days_purchased < 90){
			$smarty->assign('BUTTON_EBAYFEEDBACK_BLOCK_STATUS1',BUTTON_EBAYFEEDBACK_BLOCK_STATUS1);
			$smarty->assign('BUTTON_EBAYFEEDBACK_BLOCK_STATUS0',BUTTON_EBAYFEEDBACK_BLOCK_STATUS0);
			$smarty->assign('EBAYFEEDBACK_BLOCK_STATUS_INTRO',EBAYFEEDBACK_BLOCK_STATUS_INTRO);
			$smarty->assign('order_ebayfeedback_block_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=ebayfeedback_block&cID='.$order->customer['ID'] ));
		}

		// INSEL PLZ
		$insel_plz_array = explode(',',SHIPPING_POSTCODES_GERMANY_SPECIAL);
		if($order->delivery['country'] == 'Germany' and in_array($order->delivery['postcode'],$insel_plz_array)){
			$smarty->assign('insel_plz',1);
		}

		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_orders_email'] == '1')) {

			if($order->info['orders_status'] != ORDERS_STATUS_OFFER){
				$smarty->assign('order_packingslip_email_allow',1);
				$smarty->assign('order_email_allow',1);
				$smarty->assign('order_packingslip_email_link',xtc_href_link( 'orders.php',xtc_get_all_get_params(array('action')).'action=email_packingslip_confirm&cID='.$order->customer['ID'] ));
			}else{
				$smarty->assign('offer_email_allow',1);
			}
		}

		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['print_order'] == '1')) {
			$smarty->assign('order_print_allow',1);
			$smarty->assign('print_order_link',xtc_href_link(FILENAME_PRINT_ORDER,'oID='.$order->info['id']));
			$smarty->assign('print_order_admin_link',xtc_href_link(FILENAME_PRINT_ORDER,'oID='.$order->info['id'].'&adminprint=1'));
		}

		// yes accounting
		if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['otc'] == '1')) {
			// BEDINGUNG warenausgabe
			if( $order->info['orders_status'] == ORDERS_STATUS_BEZAHLT or ( xtc_is_shipping_before_payment($order->info['payment_method']) and ($order->info['orders_status'] == 1 or $order->info['orders_status'] == 2 or $order->info['orders_status'] == ORDERS_STATUS_UPSELLING ) ) ){
				$smarty->assign('warenausgabe_allow',1);
				$smarty->assign('warenausgabe_link',xtc_href_link('otc.php','oID='.$order->info['id']));
				$smarty->assign('warenausgabe_button',xtc_image_button('button_warenausgabe.gif',TEXT_OTC));
			}
		}
		$smarty->assign(array(
		    'COMMENTS_VISIBLE'=>xtc_db_prepare_input(nl2br($order->info['comments_visible'])),
		    'number_of_reclamations'=>sizeOf($order->get_reclamations()),
		    'JS_CONFIRM_EXT_STORNO_WITH_RECLAMATIONS'=>JS_CONFIRM_EXT_STORNO_WITH_RECLAMATIONS
		));
		$smarty->assign('COMMENTS_VISIBLE_TITLE',COMMENTS_VISIBLE);
		$smarty->assign('COMMENTS_VISIBLE_EMPTY',COMMENTS_VISIBLE_EMPTY);
		$smarty->assign('BUTTON_COMMENTS_VISIBLE_EDIT_LINK',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=comments_visible_edit'));

		$smarty->assign('skonto_values',$order->get_skonto());
		$delivery_conditions = xtc_get_customers_status_delivery_conditions($order->info['status'],$_SESSION['languages_id']);
		if(xtc_not_null($delivery_conditions)){
			$smarty->assign('DELIVERY_CONDITIONS',$delivery_conditions);
		}

// BOF - Tomcraft - 2009-10-03 - Paypal Express Modul

		/*if ($order->info['payment_method']=='paypal_ipn' or $order->info['payment_method']=='paypal_directpayment' or $order->info['payment_method']=='paypal' ) {
			$paypal = new paypal_admin();
			$paypal->admin_notification((int)$_GET['oID']);
		}*/
		if (in_array( $order->info['payment_method'],['yes_ppp','paypal_ipn','paypal_directpayment','paypal'])) {
			$pp = new \YES4Trade\Model\paypal_api();
			$transid = $pp->getOrderAllocation($order->info['id']);
			$smarty->assign('PAYPAL_TRANSACTION_ID',$transid);
			$smarty->assign('REFUND_INFO_LINK',xtc_href_link('paypal.php?action=refund_info&txn='.$transid.'&oID='.$order->info['id']));
		}
		if(in_array($order->info['orders_status'],[1,2])){
			if(defined('MODULE_PAYMENT_YES_PPP_PAYPALME') and !empty(constant('MODULE_PAYMENT_YES_PPP_PAYPALME'))){
				$smarty->assign('PAYPALME_LINK',xtc_href_link('paypal.php','action=paypalme&oID='.$order->info['id']));
			}
		}
		
// EOF - Tomcraft - 2009-10-03 - Paypal Express Modul
		if($order->info['comments'] != ''){
			$smarty->assign('COMMENTS_DELETE_LINK',xtc_href_link('orders.php',xtc_get_all_get_params(array('action')).'action=delete_comment'));
			$smarty->assign('COMMENTS_DELETE_LINK_TITLE',COMMENTS_DELETE_LINK_TITLE);
		}
		if($order->has_unallocated_ebay_items()){
			$from = urlencode($_SERVER['HTTP_REFERER']);
			$smarty->assign('has_unallocated_ebay_items_link',xtc_href_link('ebayapi_cart.php','action=allocate_orders_products_select&orders_id='.$order->info['id'].'&from='.$from));
		}
                
                // BOF - Teillieferungen und DHL Etiketten
                $query = xtc_db_query(sprintf(
                        "SELECT id FROM shippings WHERE orders_id='%d'",
                        $order->info['id']
                ));
                if(xtc_db_num_rows($query)){
                    require_once(DIR_WS_CLASSES.'yes_shipping.php');
                    $shipments = array();
                    $nr = 0;
                    while($record = xtc_db_fetch_array($query)){
                        $shipping = new yes_shipping($record['id']);
                        $shipments[$nr] = array(
                            'shippings_id'=>$record['id'],
                            'date'=>xtc_date_short($shipping->getDate_finished()),
                            'versender'=>$shipping->getVersender(),
                            'tracking_numbers'=>$shipping->getTracking_id_array_full(),
                            'packages'=>$shipping->getPackages(),
                            'products'=>$shipping->getProducts(),
                            'stop_recreate'=>$shipping->getStop_recreate()
                        );
                        if(sizeOf($shipments[$nr]['tracking_numbers']) != $shipments[$nr]['packages']){
                            if($shipping->getVersender() == 'DHL' and defined('DHL_VERSENDEN_APPLICATION_ID') and DHL_VERSENDEN_APPLICATION_ID != ''){
                                $shipments[$nr]['get_label'] = $shipments[$nr]['packages']-sizeOf($shipments[$nr]['tracking_numbers']);
                            }
                        }
                        $nr++;
                    }
                    $smarty->assign('SHIPMENTS',$shipments);
                }
                // EOF - Teillieferungen und DHL Etiketten
                // BOF - TEMPORAERE SHIPPINGCOSTS
                // BOF - Teillieferungen und DHL Etiketten
                $tracking_tmp = array();
                $query = xtc_db_query(sprintf(
                        "SELECT  shippings_tracking_numbers_temp_id, transaction_id,date_added FROM shippings_tracking_numbers_temp WHERE target_type='order' AND target_type_id='%d'",
                        $order->info['id']
                ));
                if(xtc_db_num_rows($query)){
                    while($record = xtc_db_fetch_array($query)){
                        $tracking_temp[] = $record;
                    }
                    $smarty->assign(array(
                        'SHIPPING_TRACKING_TEMP'=>$tracking_temp,
                        'TEXT_TEMPORARY_TRACKING_NUMBER'=>TEXT_TEMPORARY_TRACKING_NUMBER,
                        'LINK_DELETE_TEMP_TRACKING_NUMBER'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('transaction_id','action')).'action=delete_temp_tracking_number')
                    ));
                    
                }
                // EOF - TEMPORAERE SHIPPINGCOSTS
		$smarty->assign('paymentinstructions', $order->get_paymentinstructions());
		if($order->info['yes_amazon_pay_reference_id'] != ''){
			$smarty->assign('yes_amazon_pay_reference_id',$order->info['yes_amazon_pay_reference_id']);
			$smarty->assign('amazon_pay_link',xtc_href_link('amazon_payments.php',xtc_get_all_get_params(array('yes_amazon_pay_reference_id')).'yes_amazon_pay_reference_id='.$order->info['yes_amazon_pay_reference_id']));
		}
                
                // BOF UNZER
                if($order->info['payment_method'] == 'unzer'){
                    require_once(DIR_FS_CATALOG.'includes/modules/payment/unzer.php');
                    $unzer_query = xtc_db_query(sprintf(
                            "SELECT * FROM unzer_payments WHERE orders_id='%d'",
                            $order->info['id']
                    ));
                    $unzer = xtc_db_fetch_array($unzer_query);
                    $smarty->assign('UNZER',$unzer);
                }
                // EOF UNZER
                
                $do_array = array();
                $do_query = xtc_db_query(sprintf(
                        "SELECT distributor_orders_id FROM distributor_orders do WHERE orders_id='%s'",
                        $order->info['id']
                ));
                while($do = xtc_db_fetch_array($do_query)){
                    $do_array[] = array('id'=>$do['distributor_orders_id'],
                        'link'=>xtc_href_link('distributor_orders.php','action=edit&doID='.$do['distributor_orders_id'])
                    );
                }
                if(sizeOf($do_array)){
                    $smarty->assign('DISTRIBUTOR_ORDERS',$do_array);
                }
                if(strstr($order->info['payment_method'],'klarna_yes_')){
                    $q = xtc_db_query(sprintf(
                            "SELECT * FROM klarna_orders WHERE orders_id='%d'",
                            $order->info['id']
                    ));
                    $record = xtc_db_fetch_array($q);
                    $data = array(
                        'klarna_order_id'=>$record['klarna_intern_orders_id'],
                        'klarna_merchant_id'=>$record['merchant_id'],
                        'klarna_secret'=>constant('MODULE_PAYMENT_KLARNA_YES_PAY_LATER_SECRET'),
                    );
                    $data_string = json_encode($data);                                                                                   

                    $api_url=(strstr(HTTP_CATALOG_SERVER, 'localhost'))?HTTP_CATALOG_SERVER.'klarna_api_caller.php':HTTPS_CATALOG_SERVER.'klarna_api_caller.php';
                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");                                                                     
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);                                                                  
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                                                                      
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array(                                                                          
                        'Content-Type: application/json',                                                                                
                        'Content-Length: ' . strlen($data_string))                                                                       
                    );                                                                                                                   

                    $result = curl_exec($ch);
                    curl_close($ch);
                    $result = json_decode($result,true);
                    $klarna_reference = $result['klarna_reference'];
                    $initial_payment_method = $result['initial_payment_method'];
                    if(isset($result['error'])){
                        $smarty->assign('klarna_payment_info',$result['error']);
                    }else{
			$klarna_status_str = sprintf("Total: %s / Captured: %s / <a href=\"javascript:;\" id=\"%s\" class=\"klarna_refund_order\">Refunded: %s</a>",
				number_format($result["order_amount"]/100,2,',','.'),
				number_format($result["captured_amount"]/100,2,',','.'),
				$record['klarna_intern_orders_id'],
				number_format($result["refunded_amount"]/100,2,',','.')
			);
			$smarty->assign('klarna_payment_info',sprintf('#%s Status %s<br />(%s/%s) %s',
			    $result['klarna_reference'],
			    $result['status'],
			    $result['initial_payment_method']['description'],
			    $result['initial_payment_method']['type'],
			    $klarna_status_str
			));
                    }
                }
                $secupay_transactions = $order->get_secupay_transaction_ids();
                $smarty->assign('SECUPAY_TRANSACTIONS',$secupay_transactions);
                
                if(strstr($order->info['shipping_class'],'dhlgkapi')){
                    require_once(DIR_FS_CATALOG.'includes/modules/shipping/dhlgkapi.php');
                    $dhlgkapi = new dhlgkapi;
                    if(!$dhlgkapi->shipment_id_exists($order->info['id'])){
                        $smarty->assign(array(
                            'DHL_WUNSCHPAKET' => $dhlgkapi->get_wunschpaket_account_html($order->info['id'],$order->delivery['postcode']),
                            'DHL_WUNSCHPAKET_FORM' => xtc_draw_form('dhl_wunschpaket',FILENAME_ORDERS,xtc_get_all_get_params(array('action')).'action=update_dhl_wunschpaket','POST'),
                            'IMAGE_UPDATE'=>IMAGE_UPDATE
                        ));
                    }else{
// DIE DHL INTRANSIT API HAB ICH NOCH NICHT ZUM LAUFEN GEBRACHT
/*
                        $tracking_ids = $order->get_shipping_tracking_id_array();
                        foreach($tracking_ids as $tid){
                            if($tid['versender'] == 'DHL'){
                                yes_debug($dhlgkapi->get_intransit_orders_from_shipment_id($tid['tracking_id']));
                            }
                        }
*/
                    }
                }
		break;
	case 'reclamations':
            $smarty->assign('tab','reclamations');
            require_once(DIR_WS_CLASSES.'reclamation.php');
            $smarty->configLoad($smarty->getTemplateVars('language_path'),'general');
            $smarty->configLoad($smarty->getTemplateVars('language_path'),'reclamation');
            $config_vars = $smarty->getConfigVars();
            $order_reclamations = $order->get_reclamations();
            if(sizeOf($order_reclamations)){
                $table = new tableBlock();
                $table->table_parameters = 'class="yesListTable_minimal rec_op_table" style="width: auto;"';
                $contents = [[
                    ['text'=>$config_vars['reclamations_id'],'th'=>true],
                    ['text'=>$config_vars['reclamation_type'],'th'=>true],
                    ['text'=>$config_vars['reclamation_reason'],'th'=>true],
                    ['text'=>$config_vars['status'],'th'=>true],
                    ['text'=>$config_vars['date_created'],'th'=>true],
                ]];
    
		foreach($order_reclamations as $rID){
                    $reclamation = new reclamation($rID);
                    $contents[] = [
                        ['text'=>smarty_function_yes_system_link(['id'=>$rID,'type'=>'reclamation'], $smarty)],
                        ['text'=> xtc_get_reclamations_types_name($reclamation->info['reclamations_type'])],
                        ['text'=> implode(', ',$reclamation->reasons)],
                        ['text'=> xtc_get_reclamations_status_name($reclamation->info['reclamations_status'])],
                        ['text'=> xtc_date_short($reclamation->info['date_created'])],
                    ];
		}
                $smarty->assign('reclamations',$table->tableBlock_draw($contents));
            } // eof sizeof order reclamations
            if(sizeOf($order->costs)>0){
                $table = new tableBlock();
                $table->table_parameters = 'class="yesListTable_minimal rec_op_table" style="width: auto;"';
                $contents = [[
                    ['text'=>$config_vars['reclamations_id'],'th'=>true],
                    ['text'=>$config_vars['comment'],'th'=>true],
                    ['text'=>$config_vars['amount'],'th'=>true],
                    ['text'=>$config_vars['date_created'],'th'=>true],
                    ['text'=>$config_vars['editor'],'th'=>true],
                ]];
                foreach($order->costs as $ck=>$cost){
                    $contents[] = [
                        ['text'=>smarty_function_yes_system_link(['id'=>$rID,'type'=>'reclamation'], $smarty)],
                        ['text'=>$cost['comments']],
                        ['text'=>number_format($cost['value'],2,',',''),'align'=>'right'],
                        ['text'=>xtc_date_short($cost['date_created'])],
                        ['text'=> xtc_get_editor_name($cost['editor_id'])],
                    ];
                }
                $smarty->assign('order_costs',$table->tableBlock_draw($contents));
            }
            $recla_action_buttons = [];
            // yes accounting
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['f_reclamations_add'] == '1')) {
                if(in_array($order->info['orders_status'], [ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET])){
                    if($order->info['select_set'] == '1' and $order->info['select_set_status'] == 0){
                    }else{
                        $reclamations_types = xtc_get_reclamations_types();
                        foreach($reclamations_types as $rec_key => $reclamation_type) {
                            // NICHT BEI WARENRUECKNAHME und TYPE != 5
                            if($reclamation_type['id'] != RECLAMATIONS_STATUS_WARENRUECKNAHME and $reclamation_type['id'] != 5){
                                $link = sprintf("javascript:yesDialogLink('%s','%s');",
                                    $reclamations_types[$rec_key]['text'],
                                    xtc_href_link('reclamations.php','action=stepwise_addorder_init&type='.$reclamation_type['id'].'&oID='.$order->info['id']),
                                );
                                $recla_action_buttons[] = yes_draw_href_button(
                                    $reclamations_types[$rec_key]['text'],
                                    $link,
                                    'width:200px;',
                                    'button',
                                    'ui-button ui-corner-all ui-state-default',
                                );
                            }
                        }
		    }
		}
                $recla_action_buttons[] = yes_draw_href_button(
                    BUTTON_REIMBURSEMENT,
                    sprintf("javascript:yesDialogLink('%s','%s');",
                        BUTTON_REIMBURSEMENT,
                        xtc_href_link('rueckerstattungen.php','action=add&oID='.$order->info['id'])
                    ),
                    'width:200px;',
                    'button',
                    'ui-button ui-corner-all ui-state-default'
                );
            }
            if ( ($_SESSION['customers_status']['customers_status_id'] == '0') && ($admin_access['quick_reclamation'] == '1')) {
                //ticket 1683
                //$valid_order_statuses = array(ORDERS_STATUS_BEZAHLT,ORDERS_STATUS_VERSENDET,ORDERS_STATUS_ABGESCHLOSSEN);
                $valid_order_statuses = array(ORDERS_STATUS_VERSENDET,ORDERS_STATUS_ABGESCHLOSSEN);
                // quick reclamation geht auch ohne branch - ticket 1591
                //if(YES_BRANCHES_COUNT > 0 and $_SESSION['allocated_branches_id'] > 0 and in_array($order->info['orders_status'],$valid_order_statuses)){
                if(in_array($order->info['orders_status'],$valid_order_statuses)){
                    $recla_action_buttons[] = yes_draw_href_button(
                        BUTTON_QUICK_RECLAMATION,
                        xtc_href_link('quick_reclamation.php',xtc_get_all_get_params(array('action','oID','tab')).'oID='.$order->info['id']),
                        'width:200px;',
                        'button',
                        'ui-button ui-corner-all ui-state-default'
                    );
		}
            }
            $smarty->assign('RECLAMATION_ACTION_BUTTONS',$recla_action_buttons);
            break;
	case 'stammdaten':
		$smarty->assign('tab','stammdaten');
		// STAMMDATEN
		if( (!defined('KASSE_USER') || (int)KASSE_USER == 0) && !$_GET['redirect'] ) {
			$messageStack->add_session(ERROR_MISSING_USER_KASSE,'error');
		}
		if($order->customer['ID'] != KASSE_USER){
			$smarty->assign('crm_edit_link',xtc_href_link('customers.php','action=edit&cID='.$order->customer['ID']));
		}
		$customers_query = xtc_db_query("select c.customers_status,c.block_warnings,c.block_warnings_span,c.block_warnings_dayspan,c.block_warnings_date, c.mobile,c.customers_vat_id,c.kto_nummer,c.kto_inhaber,c.kto_blz,c.kto_bank,c.customers_ebay_userid,c.customers_id,c.customers_cid, c.customers_gender, c.customers_firstname, c.customers_lastname, c.customers_dob, c.customers_email_address, a.entry_company, a.entry_street_address, a.entry_suburb, a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, a.entry_country_id, c.customers_telephone, c.customers_fax, c.customers_newsletter, c.customers_default_address_id from " . TABLE_CUSTOMERS . " c left join " . TABLE_ADDRESS_BOOK . " a on c.customers_default_address_id = a.address_book_id where a.customers_id = c.customers_id and c.customers_id = '" . $order->customer['ID'] . "'");
		$customers = xtc_db_fetch_array($customers_query);
		$customers['country_name'] = xtc_get_country_name($customers['entry_country_id']);
		$customers['customers_status_name'] = xtc_get_customers_status_name($customers['customers_status']);
		$cInfo = new objectInfo($customers);
		$smarty->assign(array(
		    'cInfo'=>$customers,
		    'BLOCK_WARNING_DAYSPAN'=>sprintf(TEXT_BLOCK_WARNING_DAYSPAN,$cInfo->block_warnings_dayspan,date('d.m.Y',strtotime($cInfo->block_warnings_date))),
		    'ADDITIONAL_EMAIL'=> implode(', ', yes_get_customers_email_aliases($order->customer['ID']))
		));

		break;
	case 'rueckerstattungen':
		$smarty->assign('tab','rueckerstattungen');
		// RUECKERSTATTUNGEN
		if(sizeOf($order->rueckerstattungen)>0){
			$rueckerstattungen=array();
			foreach($order->rueckerstattungen as $ck=>$rueck){
				$rueck['link'] = xtc_href_link('rueckerstattungen.php',xtc_get_all_get_params(array('action','rID','status')).'action=edit&rID='.$rueck['id']);
				if($rueck['reclamations_id'] > 0){ 
					$rueck['reclamation_link'] = xtc_href_link('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit&rID='.$rueck['reclamations_id']);
				}
				$rueck['editor'] = xtc_get_editor_name($rueck['editor_id']);
				$rueckerstattungen[] = $rueck;
			}
			$smarty->assign('order_rueckerstattungen',$rueckerstattungen);
		} // end rueck
		if($order->info['yes_amazon_pay_reference_id'] != '' and defined('MODULE_PAYMENT_YES_AMAZON_PAY_STATUS') and MODULE_PAYMENT_YES_AMAZON_PAY_STATUS == 'True'){
			$amazon_payment_refunds = array();
			$query = xtc_db_query(sprintf(
				"SELECT * FROM yes_amazon_pay_refunds WHERE yes_amazon_pay_reference_id='%s'",
				$order->info['yes_amazon_pay_reference_id']
			));
			while($record = xtc_db_fetch_array($query)){
				$record['date_created_formatted'] = xtc_date_long($record['date_created']);
				$record['RefundedAmount_formatted'] = number_format($record['RefundedAmount'],2,',','.');
				$amazon_payment_refunds[] = $record;
			}
			$smarty->assign('amazon_payment_refunds',$amazon_payment_refunds);
		}
		
		break;
	case 'retouren':
		$smarty->assign('tab','retouren');
		// RETOUREN	
		$retouren_query = xtc_db_query("SELECT * FROM retouren WHERE orders_id='".$order->info['id']."'");
		$retouren_num = xtc_db_num_rows($retouren_query);
		if($retouren_num > 0){
			$order_retouren = array();
			while($retoure = xtc_db_fetch_array($retouren_query)){
				$retoure['link'] = xtc_href_link('retoure.php',xtc_get_all_get_params(array('action','rID')).'action=edit&rID='.$retoure['retoure_id']);
				if($retoure['reclamations_id'] > 0){ 
					$retoure['reclamation_link'] = xtc_href_link('reclamations.php',xtc_get_all_get_params(array('action')).'action=edit&rID='.$retoure['reclamations_id']);
				}
				$retoure['retoure_status_name'] = xtc_get_retoure_status_name($retoure['retoure_status']);
				$order_retouren[] = $retoure;
			}
			$smarty->assign('order_retouren',$order_retouren);
		} // end if retouren > 1
		break;
	case 'history':
		$smarty->assign('tab','history');
		// HISTORY	
		$orders_history_query = xtc_db_query("select orders_status_id, date_added, customer_notified, comments,editor_id from " . TABLE_ORDERS_STATUS_HISTORY . " where orders_id = '" . xtc_db_input($order->info['id']) . "' order by date_added DESC");
		if (xtc_db_num_rows($orders_history_query)) {
			$history_array = array();
			while ($orders_history = xtc_db_fetch_array($orders_history_query)) {
				if ($orders_history['customer_notified'] == '1') {
					$orders_history['notified_icon'] = xtc_image(DIR_WS_ICONS . 'tick.gif', ICON_TICK);
				} else {
					$orders_history['notified_icon'] = xtc_image(DIR_WS_ICONS . 'cross.gif', ICON_CROSS);
				}
				$orders_history['status_name'] = xtc_get_orders_status_name($orders_history['orders_status_id']);
				//$orders_history['status_name'] = $orders_status_array[$orders_history['orders_status_id']];
				// xtc_db_output fuer comments entfernt
				$orders_history['comments'] = wordwrap(nl2br($orders_history['comments']),80,'-<br />',true);
				$orders_history['editor'] = xtc_get_editor_name($orders_history['editor_id']);
				$history_array[] = $orders_history; 
			}
			$smarty->assign('history_array',$history_array);
		}
		break;
	case 'payments':
		$smarty->assign('tab','payments');

		// PAYMENTS	
		$payment_query = xtc_db_query("SELECT ip.*,po.created FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='".$order->info['id']."'");
		$payment_orders = false;
		if(xtc_db_num_rows($payment_query) > 0){
			$payment_array = array();
			while($payment = xtc_db_fetch_array($payment_query)) {
				$payment['delete_link'] = xtc_href_link('incoming_payments.php?view=filterview&id='.$payment['id']);
				$vwz_string = '';
				for( $vwz = 1; $vwz<15; $vwz++ ){
					if($vwz != 2){
						if( trim( $payment['verwendungszweck'.$vwz] ) !=''  ) {
							$vwz_string .= $payment['verwendungszweck'.$vwz].' ';
						}
					}
				}
				$payment['vwz'] = $vwz_string;
				$payment_array[] = $payment;
			}
			$smarty->assign('payment_array',$payment_array);
		}
		break;
	case 'costs':
	    $packaging_costs_netto = 0;
	    $ebay_costs = 0;
	    $amazon_costs = 0;
	    $selbstkosten = 0;
	    $ek_netto = 0;
	    $deckungsbeitrag = 0;
            $has_shipping_costs = false;
	    foreach($order->totals as $ot){
		switch($ot['class']){
		    case 'ot_shipping':
                        // fuer produkt margen berechnung, dort werden
                        // dann versandkosten nicht mehr beruecksichtigt
                        $has_shipping_costs = true;
			break;
		}
	    }
		$brutto_total = 0;
		foreach($order->totals as $ot){
		    switch($ot['class']){
			case 'ot_total':
			    $brutto_total = $ot['value'];
			    break;
		    }
		}
		for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
			$collies = xtc_get_product_collies($order->products[$i]['id']);
			if(sizeOf($collies)>0){
                            $product['marge'] = 0;
                            foreach($collies as $k=>$collie){
                                // MARGENRECHNER
                                $marge = yes_product_margenrechner($collie['collie_products_id'], $order->info['source'], $order->delivery['country_id'],true);
                                $multiplier = $collie['quantity']*$order->products[$i]['qty'];
                                $packaging_costs_netto += ($marge['packaging_costs']*$multiplier);
                                $ebay_costs += ($marge['ebay_price'] * $multiplier);
                                $amazon_costs += ($marge['amz_price'] * $multiplier);
                                $selbstkosten += ($marge['selbstkosten'] * $multiplier);
                                if($admin_access['f_products_distributors_prices'] == 1){
                                    $ek_netto += ($marge['ek_netto'] * $multiplier);
                                }
                                $deckungsbeitrag += ($marge['vk_brutto'] * $multiplier);
                            }
			}else{
			    // MARGENRECHNER
                            if($order->products[$i]['marge'] != 0){
                                $selbstkosten += $order->products[$i]['marge'];
                            }else{
                                $marge = yes_product_margenrechner($order->products[$i]['id'], $order->info['source'], $order->delivery['country_id'],true, $has_shipping_costs);

                                $multiplier = $order->products[$i]['qty'];
                                $packaging_costs_netto += ($marge['packaging_costs']*$multiplier);
                                $ebay_costs += ($marge['ebay_price'] * $multiplier);
                                $amazon_costs += ($marge['amz_price'] * $multiplier);
                                // versandkosten nicht multiplizieren mit anzahl
                                $selbstkosten += ($marge['selbstkosten'] * $multiplier);//+$marge['shipping_netto'];
                                if($admin_access['f_products_distributors_prices'] == 1){
                                    $ek_netto += ($marge['ek_netto'] * $multiplier);
                                }
                                $deckungsbeitrag += ($marge['vk_brutto'] * $multiplier);
                            }
			}
		}
                if($order->info['marge'] != 0){
                    $deckungsbeitrag = $brutto_total-$order->info['marge'];
                }
		if($admin_access['f_products_distributors_prices'] == 1){
		    $smarty->assign(array(
			'EK_NETTO'=>number_format($ek_netto,2,',','.')
		    ));
		}
		$smarty->assign('tab','costs');
		if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
		    $smarty->assign(array(
			'PACKAGING_COSTS_NETTO'=>number_format($packaging_costs_netto,2,',','.'),
			'EBAY_COSTS'=>number_format($ebay_costs,2,',','.'),
			'AMAZON_COSTS'=>number_format($amazon_costs,2,',','.'),
			'SELBSTKOSTEN'=>number_format($selbstkosten,2,',','.'),
			'DECKUNGSBEITRAG'=>number_format($brutto_total-$deckungsbeitrag,2,',','.')
		    ));
		}else{
		    $smarty->assign('PAY_MODULE_MARGE_INTRO',PAYMODULE_MARGE_NOT_ACTIVATED);
		}
		
		if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True' ){
			if(is_file(DIR_WS_CLASSES.'amazon_order.php')){
				$settlements_array = array();
				$amzSmarty = new yesSmarty;
				$amzSmarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
				require_once(DIR_WS_CLASSES.'amazon_order.php');
				if(is_countable($combined_array) && sizeOf($combined_array)>0){
					foreach($combined_array as $cok=>$cov){
						$amz_query = xtc_db_query(sprintf(
							"SELECT amazon_orders_id FROM amazon_orders WHERE orders_id='%s'",
							$cov['orders_id']
						));
						if(xtc_db_num_rows($amz_query)){
							$amz = xtc_db_fetch_array($amz_query);
							$ao = new amazon_order($amz['amazon_orders_id']);
							$settlements_array[] = $ao->getSettlementsHTML($amzSmarty);
						}
					}
				}else{
					$amz_query = xtc_db_query(sprintf(
						"SELECT amazon_orders_id FROM amazon_orders WHERE orders_id='%s'",
						$order->info['id']
					));
					if(xtc_db_num_rows($amz_query)){
						while($amz = xtc_db_fetch_array($amz_query)){
						    $ao = new amazon_order($amz['amazon_orders_id']);
						    $settlements_array[] = $ao->getSettlementsHTML($amzSmarty);
						}
					}
				}
				if(sizeOf($settlements_array))
					$smarty->assign('settlements_array',$settlements_array);
			}
		}
                $smarty->assign(array(
		    'COSTS'=>$order->get_costs(),
		    'EBAY_FEES'=>$order->get_ebay_fees(),
                    'ORDERS_ID'=>$order->info['id']
		));
		break;
	case 'emails':
		$mail_id_array = array();
		$ee_list = \YES4Trade\Model\ebay_emails::filter([
			'orders_id'=>intval($order->info['id'])
		],['id']);
		foreach($ee_list as $ee){
		    $mail_id_array[] = intval($ee->id);
		}
		function _get_icon($type){
			$part = explode('/',$type);
			if(isset($part[1])){
				switch($part[1]){
					case 'png':
						$part[1] = 'gif';
						break;
				}
				if(is_file('images/icons/icon_'.$part[1].'.gif'))
					return 'images/icons/icon_'.$part[1].'.gif';
			}
			return 'images/icons/file.gif';
		}
		$tr_array = [];
		foreach($mail_id_array as $k=>$id){
			$tr_array[] = smarty_function_mail_list(['id'=>$id,'actions'=>0],$smarty);
			$email = new DBmail($id,true,true);
			$attachments_array = array();
			$attachments = $email->get_attachments();
			for($i=0;$i<sizeOf($attachments);$i++){
				$att = $attachments[$i];
				$attachments_array[] = array(
					'id'=>$att->getEbay_email_attachments_id(),
					'filename'=>$att->getFilename(),
					'filetype'=>$att->getFiletype(),
					'filetype_icon'=>_get_icon($att->getFiletype()),
					'filesize'=>$att->getFilesize(),
					'filesize_kb'=>number_format(($att->getFilesize() / 1024),2,',','.')
				);
			}
			$email_data[] = array(
			    'NO_ACTIONS'=>'1',
			    'ID'=>$email->id,
			    'EMAIL_CLEAN'=>$email->getFrom_email(-1,false),
			    'EID'=>'',//xtc_draw_checkbox_field('eId[]',$email->id),
			    'NAME'=>$email->getFrom_Name(30),
			    'EMAIL'=>$email->getFrom_email(40),
			    'ALLOCATED_USER'=>$email->customers_id,
			    'ALLOCATED_AUCTION'=>$email->ebay_id,
			    'OWNMAIL'=>$email->ownmail,
			    'READ_STATUS'=>$email->read_status,
			    'REPLY_STATUS'=>$email->reply_status,
			    'SUBJECT'=>$email->getSubject(120),
			    'ATTACHMENTS'=>$attachments_array,
			    'DATE'=>$email->getFormatedDate(),
			    'INPUT_BOX'=>xtc_draw_hidden_field('box',$box),
			    'EBAY_USER'=>$email->getEbayUser(),
			    'ALLOCATION_STATUS'=>$email->allocation_status,
			    'SAVE_STATUS'=>$email->saved
			);
		}
		$mail_smarty = &$smarty;
		$mail_smarty->assign('emails',$email_data);
		$mail_smarty->assign(array(
			'tr_array'=>$tr_array,
		    'NO_ACTIONS'=>'1',
		    'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
		    'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
		    'SORT_SUBJECT'=>'',
		    'SORT_DATE'=>'',
		)); // ohne Aktionen
		$smarty->assign(array(
		    'tab'=>'emails',
		    'TEXT_ALLOCATED_ORDER_EMAILS'=>TEXT_ALLOCATED_ORDER_EMAILS
		));
		$smarty->assign('MAIL_LISTING',$mail_smarty->fetch('mail_list.html'));
		break;
}
echo $smarty->fetch('orders_tab.html');
