<?php
$data = array();
$full_data = [];
$msg = [];
if(is_array($_POST) and sizeOf($_POST)>0){
	$title = xtc_db_input($_POST['find_orderproduct']);
	$orders_status = xtc_db_input($_POST['orders_status']);
	$start = xtc_db_input($_POST['products_date_available'].' 00:00:00');
	$end = xtc_db_input($_POST['products_date_end'].' 23:23:59');
	$versender = xtc_db_input($_POST['versender']);
	if(strlen(trim($title))==0){
		$msg = TEXT_EXT_SEARCH_NO_SEARCHTERM;
	}else{
		$sql_str = "SELECT o.orders_id FROM orders o, orders_products op ";
		if($versender != ''){
			$sql_str .= "LEFT JOIN shippings s ON o.orders_id=s.orders_id ";
		}
		
		$sql_str .= " WHERE o.orders_id=op.orders_id and ";
		$sql_str .= ($_POST['searchmode'] == 'pname') ? " op.products_name LIKE '%".$title."%' " : " op.products_id = '".$title."' ";
		
		if($versender != ''){
			$sql_str .= " and s.versender='".$versender."' ";
		}
		
		$sql_str .= " and o.date_purchased > '".$start."' and o.date_purchased<'".$end."'";
		if(xtc_not_null($orders_status))
			$sql_str .= " and o.orders_status='".$orders_status."'";
	
				
		$orders_query = xtc_db_query($sql_str);
		while( $order = xtc_db_fetch_array($orders_query) ){
			$data[] = $order['orders_id'];
		}
	}
	foreach($data as $k=>$oID){
		$order = new order($oID);
                $versender_arr = [];
		$versender = xtc_db_query("SELECT versender,date_added FROM shippings WHERE orders_id='".$oID."'");
		while($vers = xtc_db_fetch_array($versender)){
                    $versender_arr[] = $vers['versender'].' am '.xtc_date_short($vers['date_added']);
		}
                if(isset($_POST['export']) and $_POST['export'] == 1){
                    $versenderStr = implode(', ',$versender_arr);
                    $eoln = ', ';
                    $html = false;
                }else{
                    $eoln = '<br />';
                    $html = true;
                    $versenderStr = implode('<br />',$versender_arr);
                }
                $address = xtc_address_format(5, $order->customer, $html, '', $eoln);
                
                $products_arr = [];
                if(isset($_POST['export']) and $_POST['export'] == 1){
                    $prod_pattern = '%dx %s, %spID %d';
                }else{
                    $prod_pattern = '%dx %s<br />%spID %d';
                }
		foreach($order->products as $kp=>$product){
                    $products_arr[] = sprintf($prod_pattern,
                                $product['qty'], $product['name'],
                                (($product['model'] != '') ? TEXT_PRODUCTS_MODEL.': '.$product['model'].' / ' : ''),
                                $product['id']
                    );
		}
                if(isset($_POST['export']) and $_POST['export'] == 1){
                    $products = implode(';', $products_arr);
                }else{
                    $products = implode('<br />', $products_arr);
                }
                $full_data[] = array(
                    'oID'=>$oID,
                    'date'=>xtc_date_short($order->info['date_purchased']),
                    'cID'=>$order->customer['ID'],
                    'address'=>$address,
                    'postcode'=>$order->customer['postcode'],
                    'country'=>$order->customer['country'],
                    'products'=>$products,
                    'versender'=>$versenderStr
                );
        }

        if(isset($_POST['export']) and $_POST['export'] == 1 and sizeOf($full_data)){
            require_once(DIR_WS_CLASSES.'class.basics.php');
            require_once(DIR_WS_CLASSES.'class.csv.php');
            $basics = new basics;
            $path = \main::get_exportdata_path();
            $filename = $path.'/'.sprintf('AUFTRAGSARTIKEL_%s.csv',date('Y-m-d_His'));
            $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
            fclose($fh);
            $CSV = new CSVfile($filename);
            $CSV->delimiter = "\t";
            $CSV->open('w');
            $CSV->addRow(array(
                'orders_id',
                TABLE_HEADING_DATE_PURCHASED,
                TEXT_EXT_SEARCH_CUSTOMER_ID,
                TEXT_EXT_SEARCH_CUSTOMER_DATA,
                TEXT_EXT_SEARCH_ZIP,
                TABLE_HEADING_COUNTRY,
                TABLE_HEADING_PRODUCTS,
                TEXT_SHIPPER
            ));
            $CSV->encapsulate = '"';
            foreach($full_data as $full){
                $_row = [];
                foreach($full as $v){
                    $_row[] = $v;
                }
                $CSV->addRow($_row);
            }
            $CSV->close();
            $basics->download_file($filename, true);
            exit;
        }
}
/*
if ($messageStack->size > 0) {
	echo $messageStack->output();
}*/
$ext_orders_statuses = array(0=>array('id'=>'','text'=>'Alle'));
foreach($orders_statuses as $k=>$v){
	$ext_orders_statuses[] = $v;
}
yes_draw_pre_header();
?>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $_SESSION['language_charset']; ?>">
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css.php">
<link rel="stylesheet" type="text/css" href="<?php echo yes_get_cdn_link('jquery-ui-css'); ?>">
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script src="<?php echo yes_get_cdn_link('jquery'); ?>"></script> 
<title><?php echo TEXT_EXT_SEARCH_TITLE; ?></title>
<script type="text/javascript">

<?php 
$date_start = $_POST["products_date_available"] ?? date('Y-m-d');
$date_max = date('Y-m-d');
$date_end = $_POST["products_date_end"] ?? date('Y-m-d');
?>

   function shipping(){
	document.forms['search'].versender.disabled=true;
   	switch(document.forms['search'].orders_status.value){
		case '6':
		case '3':
		case '7':
			document.forms['search'].versender.disabled=false;
			break;
	}
   }
$(function(){
    $('input#export_result_as_csv').on('click',function(){
        $('form[name="search"] input[name="export"]').val('1');
        $('form[name="search"]').submit();
    });
});
</script>
<style>
    table.search-form-table{
        margin-bottom: 10px;
        display: inline-block;
        border-spacing: 10px;
        border-collapse: separate;
        
    }
    table.search-form-table tbody tr:nth-child(1) td{
        vertical-align: bottom;
        text-align: left;
    }
    table.search-form-table tbody tr td{
        vertical-align: top;
    }
    table.search-form-table tbody tr td.submit-td{
        vertical-align: middle;
    }
    .ext-search-page{
        padding-left: 15px;
    }
</style>
</head>
<body>
<div class="ui-widget ext-search-page">
<h3><?php echo TEXT_EXT_SEARCH_INTRO; ?></h3>
<?php echo xtc_draw_form("search",'orders.php',xtc_get_all_get_params()); ?>
<input type="hidden" name="export" value="0" />
<table class="ui-widget-content search-form-table" border="0">
    <tbody>
        <tr>
            <td><?php echo xtc_draw_radio_field('searchmode','pname',((!$_POST['searchmode'] or $_POST['searchmode'] == 'pname')?true:false)); ?>&nbsp;Produktname oder<br><?php echo xtc_draw_radio_field('searchmode','pid',(($_POST['searchmode'] == 'pid')?true:false)); ?>&nbsp;pID:</td>
            <td><?php echo ENTRY_STATUS; ?></td>
            <td><?php echo TEXT_SEARCH_STARTDATE; ?></small></td>
            <td><?php echo TEXT_SEARCH_ENDDATE; ?></small></td>
            <td rowspan="2"><input class="ui-button ui-corner-all ui-state-default" type="submit" value="<?php echo IMAGE_SEARCH; ?>" /></td>
        </tr>
        <tr>
            <td><input type="text" name="find_orderproduct" value="<?php echo $_POST['find_orderproduct']; ?>"></td>
            <td><?php echo xtc_draw_pull_down_menu('orders_status',$ext_orders_statuses,$_POST['orders_status'],'onChange="shipping();"'); ?>
                <br /><i><?php echo TEXT_SHIPPER; ?>:</i><br>
                <select name="versender" DISABLED>
                    <option value=""><?php echo TEXT_SELECT; ?></option>
                    <?php foreach($VERSENDER as $verk=>$versender){ ?>
                    <option value="<?php echo $versender; ?>"><?php echo $versender; ?></option>
                    <?php } ?>
                </select>
            </td>
            <td><input type="date" name="products_date_available" value="<?php echo $date_start; ?>" max="<?php echo $date_max; ?>" /></td>
            <td><input type="date" name="products_date_end" value="<?php echo $date_end; ?>" max="<?php echo $date_max; ?>" /></td>
        </tr>
    </tbody>
</table>
</form>

</div>
<?php
if(isset($msg) and is_countable($msg) and sizeOf($msg)){
    printf('<div class="ui-state-error">%s</div>',implode('<br />',$msg));
}
if(sizeOf($full_data)>0){
    echo '<input id="export_result_as_csv" type="button" class="ui-button ui-corner-all ui-state-highlight" value="Export CSV" />';
}
?>
<table border="0" class="yesListTable_minimal">
<?php
if(sizeOf($full_data)>0){
?>
    <thead>
        <tr class="ui-widget-header">
            <th>#</th>
            <th><?php echo TABLE_HEADING_DATE_PURCHASED; ?></th>
            <th><?php echo TEXT_EXT_SEARCH_CUSTOMER_ID; ?></th>
            <th><?php echo TEXT_EXT_SEARCH_CUSTOMER_DATA; ?></th>
            <th><?php echo TEXT_EXT_SEARCH_ZIP; ?></th>
            <th><?php echo TABLE_HEADING_COUNTRY; ?></th>
            <th><?php echo TABLE_HEADING_PRODUCTS; ?></th>
            <?php if($versender and $versender != ''){ ?>
            <th><?php echo TEXT_SHIPPER; ?></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
<?php
	foreach($full_data as $full){
?>
        <tr>
            <td><?php echo $full['oID']; ?></td>
            <td><?php echo $full['date']; ?></td>
            <td><?php echo $full['cID']; ?></td>
            <td><?php echo $full['address']; ?></td>
            <td><?php echo $full['postcode']; ?></td>
            <td><?php echo $full['country']; ?></td>
            <td><?php echo $full['products']; ?></td>
            <?php if($versender and $versender != ''){ ?>
            <td><?php echo $full['versender']; ?></td>
            <?php } ?>
        </tr>
<?php
	}
}
?>
    </tbody>
</table>

<?php
exit;
