<?php
$oID = (int)xtc_db_input($_GET['oID']);
$order = new order($oID);
$options = [];
$currencies_formats = [];
$curr = new \currencies();
foreach($curr->currencies as $k=>$c){
    $options[] = [
        'id'=>$k,
        'text'=>$c['title']
    ];
}

if(isset($_POST['currency'])){
    $order = new order($oID);
    $orig_currency = $order->info['currency'];
    yes_db_perform(TABLE_ORDERS,
        [
            'currency'=>$_POST['currency'],
            'last_modified'=>date('Y-m-d H:i:s'),
        ],
        'update',
        ['orders_id'=>$oID]
    );
    
    $order = new order($oID);
    $xtPrice = $order->get_price_instance();
    foreach($order->totals as $ot){
        $new = $xtPrice->xtcFormat($ot['value'], true);
        if(in_array($ot['class'],['ot_subtotal','ot_subtotal_no_tax','ot_total'])){
            $new = sprintf('<b>%s</b>',$new);
        }
        yes_db_perform(TABLE_ORDERS_TOTAL,
            [
                'text'=>$new
            ],
            'update',
            ['orders_total_id'=>$ot['otid']]
        );
    }
    $order->add_history($order->info['orders_status'],false,sprintf(
        TEXT_ORDER_CHANGE_CURRENCY_SUCCESS, $oID, $orig_currency, $_POST['currency']
    ));
    $messageStack->add_session(sprintf(MSG_SUCCESS_ORDER_CURRENCY_CONVERTED,$_POST['currency']),'success');
    xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(['action']).'action=edit'));
}
?>
<style type="text/css">
.totals{
    margin-top: 20px;
    padding: 4px;
    display: block;
    width: 550px;
}
.totals .ot{
    display: flex;
    border-bottom: 1px solid black;
}
.totals .ot .ot_name{
    font-weight: bold;
    width: 70%;
}
.totals .ot .ot_value{
    width: 30%;
    text-align: right;
}
.currencies_edit_link{
    text-align: right;
    float: right;
}
</style>
<script>
<?php printf("var CURRENCIES_FORMAT_ARRAY = %s;\n",json_encode($curr->currencies)); ?>
function rewrite_formatNumber(value, decimal_point, thousands_point, decimal_places) {
    // 1. Rundung auf gewünschte Dezimalstellen
    const rounded = value.toFixed(decimal_places);

    // 2. Split in Ganzzahl- und Dezimalteil
    let [intPart, decPart] = rounded.split('.');

    // 3. Tausendertrennzeichen einfügen
    intPart = intPart.replace(/\B(?=(\d{3})+(?!\d))/g, thousands_point);

    // 4. Wenn keine Nachkommastellen gewünscht
    if (decimal_places === 0) return intPart;

    // 5. Zusammenbauen mit lokalem Dezimaltrennzeichen
    return intPart + decimal_point + decPart;
}
function rewrite_totals(){
    var new_currency = $('select[name="currency"]').val();
    var decimal_point = CURRENCIES_FORMAT_ARRAY[new_currency].decimal_point;
    var thousands_point = CURRENCIES_FORMAT_ARRAY[new_currency].thousands_point;
    var decimal_places = parseInt(CURRENCIES_FORMAT_ARRAY[new_currency].decimal_places);

    $('.totals .ot').each(function(){
        $(this).children('.ot_value').text(
            CURRENCIES_FORMAT_ARRAY[new_currency].symbol_left
            + rewrite_formatNumber(parseFloat($(this).data('value')), decimal_point, thousands_point, decimal_places)
            + CURRENCIES_FORMAT_ARRAY[new_currency].symbol_right
        );
    });
}
</script>

<?php
printf('<div class="main">%s',
    xtc_draw_form('order_convert',FILENAME_ORDERS,xtc_get_all_get_params(),'POST'),
);
printf('<div><b>%s:</b> %s',
    TABLE_HEADING_CURRENCY,
    xtc_draw_pull_down_menu('currency',$options, $order->info['currency'],'id="currency" onchange="rewrite_totals()"')
);
printf('<div class="currencies_edit_link">%s</div>',
    yes_draw_href_button(constant('LINK_EDIT_CURRENCIES_TITLE'),
        xtc_href_link(FILENAME_CURRENCIES),
        '','button','ui-state-button ui-corner-all ui-state-default','_blank'
    )
);
printf('</div><p>%s</p><div class="totals">',
    constant('TEXT_ORDER_CHANGE_CURRENCY_INTRO')
);
foreach($order->totals as $ot){
    printf('<div class="ot" data-otid="%d" data-value="%s" data-otclass="%s"><div class="ot_name">%s</div><div class="ot_value">%s</div></div>',
        $ot['otid'], $ot['value'], $ot['class'],
        $ot['title'],
        $ot['text']
    );
}
echo '</div></fieldset>';
printf('%s</form>',
    yes_draw_href_button(constant('IMAGE_SAVE'),'','','submit','ui-button ui-corner-all ui-state-default')
);
echo '</div>';
?>

<?php
exit;
