<?php
require_once('includes/classes/jsmin.php');
require_once('includes/classes/main.php');
function md5_of_file($filename) {
  $ret='';
  if (filemtime($filename) === false) return false;
  $ret.=date("YmdHis", filemtime($filename)).$filename;
  return md5($ret);
}
function minify_js_get_script(string $write_dir='', string $file_with_path=''){
    if(empty($write_dir) or empty($file_with_path)){
        throw new Exception('minify_js_get_script() need writedir location and full file path');
    }
    $name=md5_of_file($file_with_path);
    if(file_exists($write_dir.$name)){
        $js = sprintf('/** %s LOADING EXISTING SOURCE FROM %s **/',
            basename(__FILE__),
            $write_dir.$name
        );
        $js .= file_get_contents($write_dir.$name);
    }else{
        $js = sprintf('/** %s LOADING NEW SOURCE %s **/',
            basename(__FILE__),
            $file_with_path
        );
        $js.=file_get_contents($file_with_path);
        $js=JSMin::minify($js);
        file_put_contents($write_dir.$name,$js);
        // eigentlich muesste die "alte" Datei entfernt werden - aber cache/ soll ja sowieso regelmaessig geloescht
    }
    return $js;
}

$error_msg = [];
$allowed_extensions = ['js'];
$allowed_path_array = ['js','includes','templates'];
$js_file = (isset($_REQUEST['file']))?trim(str_replace(['../','\\'],'',$_REQUEST['file'])):'';
$path_disect = explode('/', $js_file);
$valid_path = false;
if(sizeOf($path_disect)>1){
    if(in_array($path_disect[0], $allowed_path_array)){
        $valid_path = true;
    }
}

$js = '';
if(empty($js_file)){
	$error_msg[] = 'no file given';
}elseif(!is_file($js_file)){
        $error_msg[] = 'file '.$js_file.' not exists';
}elseif(!$valid_path){
        $error_msg[] = sprintf('unallowed location (only %s)',implode(', ',$allowed_path_array));
}else{
    $ext = pathinfo($js_file, PATHINFO_EXTENSION);
    if(!in_array(strtolower($ext),$allowed_extensions)){
        $error_msg[] = 'no '.$ext.' scripts allowed';
    }else{
        $writabledir='../cache/';
        if(!is_dir($writabledir) || !is_writeable($writabledir)){
            $error_msg[] = 'cache dir is not writeable';
        }else{
            $js = minify_js_get_script($writabledir,$js_file);
        }
    }
}

header('Content-type: text/javascript');
//header('Expires: '.gmdate("D, d M Y H:i:s", time() + 3600*24*365).' GMT');
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
$js = "// === BOF - YES MINIFY_JS ===\n\n".$js;
        
if(sizeOf($error_msg)){
    foreach($error_msg as $em){
        printf("%salert('[%s] %s');",$js,basename(__FILE__),$em);
    }
}else{
    if (substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')) ob_start("ob_gzhandler");
    echo $js;
    if (substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')) ob_flush();
}
echo "\n\n// === EOF - YES MINIFY_JS ===\n\n";
