<?php
/* -----------------------------------------------------------------------------------------
   
   Google Sitemaps by hendrik (http://www.ecombase.de/)
   V1.1 August 2006
   -----------------------------------------------------------------------------------------
   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(cod.php,v 1.28 2003/02/14); www.oscommerce.com 
   (c) 2003	 nextcommerce (invoice.php,v 1.6 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/
//defined( '_VALID_XTC' ) or die( 'Direct Access to this location is not allowed.' );
define('MODULE_XML_SITEMAP_TEXT_DESCRIPTION', 'Export - XML Sitemap nach dem sitemap protocol Standard von <a target="_blank" href="http://www.sitemaps.org/">http://www.sitemaps.org/</a>');
define('MODULE_XML_SITEMAP_TEXT_TITLE', 'XML Sitemap (v0.9)');
define('MODULE_XML_SITEMAP_FILE_TITLE','Dateiname');
define('MODULE_XML_SITEMAP_FILE_DESC','Name der XML Sitemap Datei');
define('MODULE_XML_SITEMAP_STATUS_DESC','Modulstatus');
define('MODULE_XML_SITEMAP_STATUS_TITLE','Status');
@define('EXPORT_YES','Nur Herunterladen');
@define('EXPORT_NO','Am Server Speichern');
@define('CHARSET','UTF-8');

define('MODULE_XML_SITEMAP_INSTALL_TITLE' , '<hr noshade><b>Installation im Shopverzeichnis?</b>');
define('MODULE_XML_SITEMAP_INSTALL_DESC' , 'Die XML Datei wird gz komprimiert im Shopverzeichnis abgelegt.');
// ----------------------
define ('SITEMAP_PAR_PRIORITY_LIST',    '0.5');        
define ('SITEMAP_PAR_PRIORITY_PRODUCT', '0.8');        
define ('SITEMAP_PAR_CHANGEFREQ', 'weekly');        
// ----------------------


// include needed functions

class xml_sitemap extends products_export {
    var $code, $title, $description, $enabled,$schema;


    function __construct() {
	$this->code = 'xml_sitemap';
	$this->title = MODULE_XML_SITEMAP_TEXT_TITLE;
	$this->description = MODULE_XML_SITEMAP_TEXT_DESCRIPTION;
	$this->sort_order = (defined('MODULE_XML_SITEMAP_SORT_ORDER')) ? MODULE_XML_SITEMAP_SORT_ORDER : 0;
	$this->enabled = ((defined('MODULE_XML_SITEMAP_STATUS') and MODULE_XML_SITEMAP_STATUS == 'True') ? true : false);
	$schema = new simpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><urlset></urlset>');
	$schema->addAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
	$this->schema = $schema;
    }
    
    
    function gmt_diff() {
      preg_match_all("/([\+|\-][0-9][0-9])([0-9][0-9])/", date("O"), $ausgabe, PREG_PATTERN_ORDER);
      return $ausgabe[1][0] . ":" . $ausgabe[2][0];
    }

    function xls_sitemap_entry( $link, $lastmod='', $priority=SITEMAP_PAR_PRIORITY_LIST, $changefreq=SITEMAP_PAR_CHANGEFREQ ) {
	if( $lastmod=='' ) {
	    $lastmod = date('Y-m-d');
	}

	$url = $this->schema->addChild('url');
	$url->addChild('loc',$link);
	$url->addChild('lastmod',$lastmod);
	$url->addChild('changefreq',$changefreq);
	$url->addChild('priority',$priority);
    }
    
// -------------------- Contents ----------------------
    function process_contents() {
	if(!function_exists('xtc_cleanName')){
	    require(DIR_FS_INC.'xtc_cleanName.inc.php');
        }
        $items = \YES4Trade\Model\content_manager::get_by_content_status_and_languages_id(1, (int)$_SESSION['languages_id']);
        foreach($items as $it) {
            $link = $this->xtc_href_link('shop_content.php','coID='.$it->content_group,'NONSSL');
            $this->xls_sitemap_entry( $link );     
        }
    }
      

// -------------------- Categories ----------------------
    function process_categories( ) {
	$group_check = '';
	$categories_query ="SELECT c.categories_image,
	    c.categories_id,
	    cd.categories_name 
	    FROM 
	    " . TABLE_CATEGORIES . " c left join
	    " . TABLE_CATEGORIES_DESCRIPTION ." cd on c.categories_id = cd.categories_id
	    WHERE 
	    c.categories_status = '1'                      and 
	    cd.language_id = ".$_SESSION['languages_id']." and 
	    c.parent_id = '0' ".$group_check."
	    ORDER BY 
	    c.sort_order ASC";

	$categories_query = yes_db_query($categories_query,true);
	if(yes_db_num_rows($categories_query)){
	    foreach($categories_query as $categories) {
		$link = $this->xtc_href_link('index.php','cPath='.$categories['categories_id'],'NONSSL');
		$this->xls_sitemap_entry( $link );     

		$category_tree=$this->get_category_tree($categories['categories_id']);
		foreach( $category_tree as $category_entry ) {
		    $link = $category_entry['link'];
		    $this->xls_sitemap_entry( $link );
		}
	    }
	}
    }
    

// -------------------- Products ----------------------
    function process_products( ) {      
	if(!function_exists('xtc_product_link'))
	    require(DIR_FS_INC.'xtc_product_link.inc.php');
	$export_query =xtc_db_query("SELECT
	    p.products_id,
	    p.products_last_modified, 
	    pd.products_name
	    FROM
	    " . TABLE_PRODUCTS . " p, 
	    " . TABLE_PRODUCTS_DESCRIPTION . " pd
	    WHERE
	    products_status = 1 and
	    p.products_id=pd.products_id and
	    pd.language_id=".$_SESSION['languages_id']."

	    ORDER BY
	    p.products_id"
	);

	while ($products = xtc_db_fetch_array($export_query)) {
	    $link = $this->xtc_href_link('product_info.php','products_id='.$products['products_id'],'NONSSL');
	    $this->xls_sitemap_entry( $link, date('Y-m-d',strtotime($products['products_last_modified'])), SITEMAP_PAR_PRIORITY_PRODUCT);
	}
    }

    function process($file) {
	if(!function_exists('xtc_href_link'))
	    require(DIR_FS_INC.'xtc_href_link.inc.php');

	@xtc_set_time_limit(0);

	$this->xls_sitemap_entry( HTTP_SERVER . "index.html" );
	
	$this->process_contents();
	
	$this->process_categories();
	$this->process_products();
	
	$schema = $this->schema->asXML();
	// -------------------------------------------------------------
	// create File
	if( isset($_POST['xml_sitemap_rootinstall']) and $_POST['xml_sitemap_rootinstall'] == 'yes' ) {
	    $filename = DIR_FS_DOCUMENT_ROOT.'export/'.$file;
	} else {
	    $filename=DIR_FS_DOCUMENT_ROOT.'export/' . $file;
	}
	if( !isset($_POST['xml_sitemap_rootinstall']) or $_POST['xml_sitemap_rootinstall'] != 'yes' ) {
	    $fp = fopen($filename, "w+");
	    fputs($fp, $schema);
	    fclose($fp);

	    // send File to Browser
	    $extension = substr($file, -3);
	    $fp = fopen($filename,"rb");
	    $buffer = fread($fp, filesize($filename));
	    fclose($fp);
	    header('Content-type: application/x-octet-stream');
	    header('Content-disposition: attachment; filename=' . $file);
	    echo $buffer;
	    exit;
	}else{
	    // Temporäre Datei zum Schreiben mit der maximalen Kompressionsstufe öffnen
	    $zp = gzopen($filename.'.gz', "w9");
	    // String in die Datei schreiben
	    gzwrite($zp, $schema);
	    // Datei schließen
	    gzclose($zp);
	}
    }

    function display() {
      return array('text' => 
                            MODULE_XML_SITEMAP_INSTALL_TITLE.'<br />'.
                            MODULE_XML_SITEMAP_INSTALL_DESC.'<br />'.
                            xtc_draw_radio_field('xml_sitemap_rootinstall', 'no',true).'nein'.'<br>'.
                            xtc_draw_radio_field('xml_sitemap_rootinstall', 'yes',false).'ja'.'<br>'.
                            '<br /><input value="'.IMAGE_EXPORT.'" type="submit" class="ui-button ui-corner-all ui-state-default">'.
                            '<input value="'.IMAGE_CANCEL.'" type="button" class="ui-button ui-corner-all ui-state-default" onClick="window.location.href=\''.xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=xml_sitemap').'\';">');
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_XML_SITEMAP_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }

    function install() {
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_XML_SITEMAP_FILE', 'sitemap.xml',  '6', '1', '', now())");
	xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_XML_SITEMAP_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
    }

    function remove() {
	xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
	return array('MODULE_XML_SITEMAP_STATUS','MODULE_XML_SITEMAP_FILE');
    }

    function get_category_tree( $parent_id = '0', $spacing = '', $exclude = '', $category_tree_array = '', $include_itself = false, $cPath = '' ) {
	global $SITEMAP;
	if ($parent_id == 0){ 
	    $cPath = ''; 
	} else {	
	    $cPath .= $parent_id . '_'; 
	}
	if (!is_array($category_tree_array)) 
	    $category_tree_array = array();

	if ($include_itself) {
	    $category_query = "select cd.categories_name from " . TABLE_CATEGORIES_DESCRIPTION . " cd where cd.language_id = '" . $_SESSION['languages_id'] . "' and c.categories_status = '1' and cd.categories_id = '" . $parent_id . "'";
	    $category_query = yes_db_query($category_query,true);
	    if(yes_db_num_rows($category_query))
		    $category = current($category_query);
	    $category_tree_array[] = array('id' => $parent_id, 'text' => $category['categories_name']);
	}
	$categories_query = "select c.categories_id, cd.categories_name, c.parent_id from " . TABLE_CATEGORIES . " c, " . TABLE_CATEGORIES_DESCRIPTION . " cd where c.categories_id = cd.categories_id and cd.language_id = '" . $_SESSION['languages_id'] . "' and c.parent_id = '" . $parent_id . "' and c.categories_status = '1' order by c.sort_order, cd.categories_name";
	$categories_query = yes_db_query($categories_query,true);
	if(yes_db_num_rows($categories_query)){
	    foreach ($categories_query as $categories ) {
		if ($exclude != $categories['categories_id']) {
		    $listing_data = array();
		    if($SITEMAP['get_products'] && xtc_count_products_in_category($categories['categories_id']) > 0) {
			$listing_data = get_all_products($categories['categories_id']);
		    }
		    $link = $this->xtc_href_link('index.php','cPath='.$cPath.$categories['categories_id'],'NONSSL');
		    
		    $category_tree_array[] = array( 'id'    => $categories['categories_id'],
			'text'  => $spacing . $categories['categories_name'],
			'link'  => $link,
			'pcount'=> sizeof($listing_data),
			'products'=>$listing_data
		    ); //-- DIR_WS_CATALOG . 'index.php?cPath=' . $cPath . $categories['categories_id']
		    $category_tree_array = $this->get_category_tree($categories['categories_id'], $spacing . '&nbsp;&nbsp;&nbsp;', $exclude, $category_tree_array, false, $cPath);
		}
	    }
	}
	return $category_tree_array;
    }
}