<?php
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_get_sha1_from_string.inc.php');
require_once(DIR_FS_INC.'xtc_checkdate.inc.php');
define('MODULE_AMAZON_ORDERS_PRODUCTS_TEXT_DESCRIPTION', 'Export - Amazonauftragsartikel   (Komma getrennt)');
define('MODULE_AMAZON_ORDERS_PRODUCTS_TEXT_TITLE', 'Amazon Auftragsartikel Export - CSV');
//define('MODULE_AMAZON_ORDERS_PRODUCTS_FILE_TITLE' , '<hr noshade>Dateiname');
//define('MODULE_AMAZON_ORDERS_PRODUCTS_FILE_DESC' , 'Geben Sie einen Dateinamen ein, falls die Exportdatei am Server gespeichert werden soll.<br>(Verzeichnis ebaymich/)');
define('MODULE_AMAZON_ORDERS_PRODUCTS_SORT_ORDER_TITLE', 'Sortierung');
define('MODULE_AMAZON_ORDERS_PRODUCTS_SORT_ORDER_DESC', 'Sortierung innerhalb Exportmodule');

define('MODULE_AMAZON_ORDERS_PRODUCTS_STATUS_DESC','Modulstatus');
define('MODULE_AMAZON_ORDERS_PRODUCTS_STATUS_TITLE','Status');
define('DATE_FORMAT_EXPORT', '%d.%m.%Y');  // this is used for strftime()
define('TEXT_EXPORT_START_DATE','Export Startdatum');
define('TEXT_EXPORT_END_DATE','Export Enddatum');
define('MODULE_AMAZON_ORDERS_PRODUCTS_LANGUAGE_ID',2);
define('MODULE_AMAZON_ORDERS_PRODUCTS_EXPORT_CSV_SEPARATOR',",");
define('MSG_ERROR_NO_ITEMS','Es wurden keine Datens&auml;tze exportiert');
define('JS_ERROR_INVALID_STARTDATE','Das Startdatum hat ein ungültiges Format (JJJJ-MM-DD): "%s"');
define('JS_ERROR_INVALID_ENDDATE','Das Enddatum hat ein ungültiges Format (JJJJ-MM-DD): "%s"');
// include needed functions

class amazon_orders_products extends products_export{
    var $code, $title, $description, $enabled,$sort_order,$max_items_per_step;


    function __construct() {
      global $order;

      $this->TextSign = '';
      $this->code = 'amazon_orders_products';
      $this->title = MODULE_AMAZON_ORDERS_PRODUCTS_TEXT_TITLE;
      $this->description = MODULE_AMAZON_ORDERS_PRODUCTS_TEXT_DESCRIPTION;
      $this->sort_order = (defined('MODULE_AMAZON_ORDERS_PRODUCTS_SORT_ORDER'))?MODULE_AMAZON_ORDERS_PRODUCTS_SORT_ORDER:0;
      $this->enabled = ((defined('MODULE_AMAZON_ORDERS_PRODUCTS_STATUS') and MODULE_AMAZON_ORDERS_PRODUCTS_STATUS == 'True') ? true : false);
      $this->max_items_per_step = 1000;
      $this->from_cron = (php_sapi_name() === 'cli') ? true : false;
    }
    
    private static function _get_start_date(){
	// BOF  - DATUM PRUEFEN UND NEU ZUSAMMENBASTELN
        $aktuellesDatum = new DateTime();
	$start_date_raw = xtc_db_input($_REQUEST['export_start_date']??date('Y-m-d',strtotime('-1 day')));
        $start_date_time = DateTime::createFromFormat('Y-m-d', $start_date_raw);
        // Ueberpruefung auf Fehler bei der Erstellung des DateTime-Objekts
        if ($start_date_time === false) {
            die(json_encode([
                'MSG'=>sprintf(JS_ERROR_INVALID_STARTDATE,$start_date_raw)
            ]));
        }
        if($start_date_time > $aktuellesDatum){
            $start_date_raw = date('Y-m-d');
        }
        return $start_date_raw;
    }
    
    private static function _get_end_date(){
	$end_date_raw = xtc_db_input($_REQUEST['export_end_date']??date('Y-m-d'));
        $end_date_time = DateTime::createFromFormat('Y-m-d', $end_date_raw);
        // Ueberpruefung auf Fehler bei der Erstellung des DateTime-Objekts
        if ($end_date_time === false) {
            die(json_encode([
                'MSG'=>sprintf(JS_ERROR_INVALID_ENDDATE,$end_date_raw)
            ]));
        }
        return $end_date_raw;
    }

    function get_sql( $order = true,$start = NULL){
	$export_query_raw = "SELECT aop.* FROM amazon_orders_products aop";
	$start_date = self::_get_start_date();
	$end_date = self::_get_end_date();
	if($start_date > $end_date){
	    $start_date = date('Y-m-d',strtotime('-1 day'));
	    $end_date = date('Y-m-d');
	}
	$end_date .= ' 23:59:59';
	
	$export_query_raw .= sprintf(" WHERE order_fulfillment_send_date > '%s' and order_fulfillment_send_date < '%s' ",
		$start_date,$end_date
	);
	if($order){
	    $export_query_raw .= " ORDER BY order_fulfillment_send_date";
	}
	if($start !== NULL){
	    $export_query_raw .= sprintf(" LIMIT %s, %s",
		    $start,$this->max_items_per_step
	    );
	}
	return $export_query_raw;
    }
    
    function get_schema(){
	return array('SKU',
	    'Titel',
	    'Anzahl',
	    'Preis (price_principal)',
	    'Versandkosten',
	    /*'Preis (Ohne Versand)',*/
	    'Versanddatum'
	);
    }
    
    public function get_total_number_of_items(){
	$query = xtc_db_query($this->get_sql(false));
	return xtc_db_num_rows($query);
    }
    function process_header(){
	$basics = new basics;
	$str = implode(MODULE_AMAZON_ORDERS_PRODUCTS_EXPORT_CSV_SEPARATOR, $this->get_schema())."\r\n";
	if(is_file($this->tmp_directory.'/00_HEADER.CSV'))
	    unlink($this->tmp_directory.'/00_HEADER.CSV');
	$basics->create_file($this->tmp_directory.'/00_HEADER.CSV', $str);
    }
    
    function process($file){
	$basics = new basics;
	global $messageStack;
        @xtc_set_time_limit(0);
	$export_params = array(
	    'start'=>0,
	    'particle_path'=>\main::get_exportdata_path().'AOP_EXPORT/',
	    'export'=>'yes'
	);
	if(isset($_REQUEST['start'])){
	    $export_params['start'] = (int)$_REQUEST['start'];
	}
	if($export_params['start'] == 0){
	    if(is_dir($export_params['particle_path'])){
		    $files = $basics->get_directory_content($export_params['particle_path']);
		    foreach($files as $f){
			    unlink($export_params['particle_path'].$f);
		    }
		    rmdir($export_params['particle_path']);
	    }
	    mkdir($export_params['particle_path']);
	}

	// mario - 19.01.2013
	if(!isset($this->language_id)) $this->language_id = $_SESSION['languages_id'];
	
	$counter = 0;
	$num_total = $this->get_total_number_of_items();
	$page_sql = $this->get_sql(true,$export_params['start']);
	$items = array();
	$query = xtc_db_query($page_sql);
	while($products = xtc_db_fetch_array($query)){
	    /*
	    $desc_query = xtc_db_query(sprintf(
		    "SELECT * FROM products_description WHERE products_id=%s and language_id=%s",
		    $products['products_id'],MODULE_AMAZON_ORDERS_PRODUCTS_LANGUAGE_ID
	    ));
	    $desc = xtc_db_fetch_array($desc_query);
	    */
	    $row = array(
		$products['sku'],
		$products['title'],
		$products['quantity'],
		number_format($products['price_principal'],2,',','.'),
		number_format($products['price_shipping'],2,',','.'),
		/*number_format($products['price_principal']-$products['price_shipping'],2,',','.'),*/
		xtc_date_short($products['order_fulfillment_send_date'])
	    );
	    $data = array();
	    foreach($row as $r){
		    $data[] = sprintf('"%s"',str_replace('"',"'",$r));
	    }
	    $items[] = implode(MODULE_AMAZON_ORDERS_PRODUCTS_EXPORT_CSV_SEPARATOR, $data);
	    $counter++;
	}
	if(!sizeOf($items)){
	    $messageStack->add_session(MSG_ERROR_NO_ITEMS,'error');
	    xtc_redirect(xtc_href_link('module_export.php',xtc_get_all_get_params(array('action','export_start_date','export_end_date'))));
	}
	$filename = sprintf('PART_%s.csv',$export_params['start']);
	$schema = implode("\r\n",$items);
	$basics->create_file($export_params['particle_path'].$filename, $schema);
	if( $export_params['start']+$this->max_items_per_step >= $num_total ){
		// KOMPLETT ERZEUGEN
		$schema = implode(MODULE_AMAZON_ORDERS_PRODUCTS_EXPORT_CSV_SEPARATOR,$this->get_schema())."\r\n";
		$files = $basics->get_directory_content($export_params['particle_path']);
		foreach($files as $f){
			$fp = fopen($export_params['particle_path'].$f,"rb");
			$schema .= fread($fp, filesize($export_params['particle_path']. $f))."\r\n";
			fclose($fp);
			unlink($export_params['particle_path'].$f);
		}
		// create File
		if(!isset($file) or $file==''){
			$file = $this->code.''.date('Ymd-his').'.csv';
		}
		$directory_without_slash = substr($export_params['particle_path'],0,strlen($export_params['particle_path'])-1);
		$basics->create_file($export_params['particle_path'] . $file, $schema);
		$basics->zip_file($directory_without_slash, $file, $file.'.zip', true);

		switch ($export_params['export']) {
			case 'yes':
//						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);

				header($_SERVER['SERVER_PROTOCOL'].' 200 OK');
				header("Content-Type: application/zip");
				header("Content-Transfer-Encoding: Binary");
				header("Content-Length: ".filesize($export_params['particle_path']. $file.'.zip'));
				header("Content-Disposition: attachment; filename=\"".$file.".zip\"");
				readfile($export_params['particle_path']. $file.'.zip');
				unlink($export_params['particle_path']. $file.'.zip');
				exit;
				break;
			case 'no':
//						unlink(DIR_FS_CATALOG.'../ebaymich/' . $file);
			    copy($export_params['particle_path']. $file.'.zip',DIR_FS_CATALOG.'ebaymich/'.$file.'.zip');
			    unlink($export_params['particle_path']. $file.'.zip');
			    if($this->from_cron){
				die('ebaymich/'.$file.".zip wurde erzeugt\r\n");
			    }else{
				$messageStack->add_session(sprintf(MSG_SUCCESS_FILE_EXPORTED,$file.'.zip'),'success');
			    }
			    break;
		}
	}else{
	    if($this->from_cron){
		die("\r\nGENERATED FILE: $filename\r\n".'Start: '.$export_params['start'].' / Generated: '.($counter-1).' / Total: '.$num_total." / MAX: ".$this->max_items_per_step."\r\n");
	    }else{
		$_GET['export_start_date'] = $_REQUEST['export_start_date'];
		$_GET['export_end_date'] = $_REQUEST['export_end_date'];
		$next_link = xtc_href_link('module_export.php',xtc_get_all_get_params(array('start')).'start='.($export_params['start']+$this->max_items_per_step));
		xtc_redirect($next_link);
	    }
	}
	
    }

    function display() {
		/* WIR WOLLEN AUSGEWAEHLTE KATEGORIEN EXPORTEN */
	$default_date = date('Y-m-d',time()-(60*60*24*7) );
		$array = array('text' =>  '<br />'.
		    TEXT_EXPORT_START_DATE.'<br /><input type="date" name="export_start_date" value="'.$default_date.'" /><br />'.
		    TEXT_EXPORT_END_DATE.'<br /><input type="date" name="export_end_date" value="'.date('Y-m-d').'" /><br />'.
		    yes_draw_href_button(IMAGE_EXPORT,'javascript:','width:120px;','submit') . '&nbsp;' .
			    yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(FILENAME_MODULE_EXPORT, 'set=' . $_GET['set'] . '&module=bestand'),'width:120px;')
		);
		return $array;
    }
	
	function prepare_string($string,$replace_gaense=true){
		if($replace_gaense)
			$string = str_replace('"','""',$string);
		return html_entity_decode($string);
	}

    function check() {
      if (!isset($this->_check)) {
        $check_query = xtc_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_AMAZON_ORDERS_PRODUCTS_STATUS'");
        $this->_check = xtc_db_num_rows($check_query);
      }
      return $this->_check;
    }
	
    function install() {
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_AMAZON_ORDERS_PRODUCTS_SORT_ORDER', '0',  '6', '1', '', now())");
      xtc_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_key, configuration_value,  configuration_group_id, sort_order, set_function, date_added) values ('MODULE_AMAZON_ORDERS_PRODUCTS_STATUS', 'True',  '6', '1', 'xtc_cfg_select_option(array(\'True\', \'False\'), ', now())");
	}

    function remove() {
      xtc_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }

    function keys() {
      return array('MODULE_AMAZON_ORDERS_PRODUCTS_STATUS','MODULE_AMAZON_ORDERS_PRODUCTS_SORT_ORDER');
    }

  }
