<?php
use Phpfastcache\CacheManager;
use Phpfastcache\Config\ConfigurationOption;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
define('YES_SQL_EMPTY_DATE','0000-00-00 00:00:00');

/* --------------------------------------------------------------
   $Id: cron_application_top.php,v 1.43 2020/09/17 10:00:46 ssh-511548-cvs Exp $

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(application_top.php,v 1.158 2003/03/22); www.oscommerce.com
   (c) 2003	 nextcommerce (application_top.php,v 1.46 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:

   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
   http://www.oscommerce.com/community/contributions,282
   Copyright (c) Strider | Strider@oscworks.com
   Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
   Copyright (c) Andre ambidex@gmx.net
   Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

   Released under the GNU General Public License
   --------------------------------------------------------------*/

  // Start the clock for the page parse time log
define('PAGE_PARSE_START_TIME', microtime());

  // Disable use_trans_sid as xtc_href_link() does this manually
if (function_exists('ini_set')) {
    ini_set('session.use_trans_sid', 0);
}

  // Set the local configuration parameters - mainly for developers or the main-configure
if (file_exists('includes/local/configure.php')) {
    include('includes/local/configure.php');
} else {
    require('includes/configure.php');
}
require('includes/filenames.php');
require(DIR_FS_CATALOG.'includes/global_functions.php');
require_once(DIR_FS_CATALOG.'includes/classes/vendor/autoload.php');

require_once(DIR_WS_CLASSES. 'ACK.php');
define('CHARSET','utf-8');
// NEUE PHPMAILER VERSION
require_once(DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/PHPMailer.php');
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/Exception.php';
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/PHPMailer.php';
require_once DIR_FS_DOCUMENT_ROOT.'includes/classes/PHPMailer-master/src/SMTP.php';
include(DIR_FS_CATALOG.'includes/php_deprecated_functions.php');

require_once(DIR_FS_INC . 'xtc_get_products_not_shipped.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_in_reclamations.inc.php');
require_once(DIR_FS_INC . 'xtc_get_products_at_amazon.inc.php');
require_once(DIR_FS_INC . 'xtc_get_storage_name.inc.php');
require_once(DIR_FS_INC.'yes_update_products_in_auction_quantity.inc.php');
require_once(DIR_FS_INC . 'yes_cdn.inc.php');
require_once(DIR_FS_INC . 'yes_product_margenrechner.inc.php');
require_once(DIR_FS_INC.'yes_encode_string.inc.php');
require_once(DIR_FS_INC.'yes_decode_string.inc.php');
require_once(DIR_WS_CLASSES . 'jsmin.php');
require_once(DIR_FS_INC . 'yes_get_products_vpe_string.inc.php');
require_once(DIR_FS_INC.'yes_get_products_properties_values_from_shopping_cart_id.inc.php');

require_once(DIR_WS_CLASSES.'main.php');
require_once(DIR_WS_CLASSES.'YES4Trade/autoload.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC . 'yes_eu_oss.inc.php');

require_once('includes/config.ebayapi.inc.php');
define('SQL_CACHEDIR',DIR_FS_CATALOG.'cache/');

require(DIR_FS_CATALOG . 'includes/classes/class.db.php');
require_once(DIR_FS_INC.'yes_db_query.inc.php');
$yes_db_class_instance = new db(0);

if(defined('USE_DOMPDF') and USE_DOMPDF == 'True'){
    require_once("includes/classes/yes_pdf.php");
}
define('YES_PHPFASTCACHE_METHOD','files');
define('YES_PHPFASTCACHE_TAG_NEW_ORDERS','new_orders');
define('YES_PHPFASTCACHE_STATS_EXPIRE',60*60*24);
$secure_path = main::get_secure_path();
$fc_config = array(
    "path" => $secure_path.DIRECTORY_SEPARATOR.'fastcache'
);

if(!is_dir($fc_config['path'])){
    mkdir($fc_config['path']) or die('Cant create fastcache dir');
    chmod($fc_config['path'],0777) or die('Cant give write access to fastcache dir');
}
// Setup File Path on your config files
CacheManager::setDefaultConfig(new ConfigurationOption([
  'path' => $fc_config['path'],
  'defaultTtl' => 3600,
]));
$InstanceCache = CacheManager::getInstance(YES_PHPFASTCACHE_METHOD);


  // Define the project version
  define('PROJECT_VERSION', 'XT-Commerce v3.0.1');


  // Used in the "Backup Manager" to compress backups
  define('LOCAL_EXE_GZIP', '/usr/bin/gzip');
  define('LOCAL_EXE_GUNZIP', '/usr/bin/gunzip');
  define('LOCAL_EXE_ZIP', '/usr/local/bin/zip');
  define('LOCAL_EXE_UNZIP', '/usr/local/bin/unzip');


	  define('TABLE_EBAY_CURRENCIES', 'ebay_currencies');
	  define('TABLE_EBAY_REGIONS', 'ebay_regions');
	  define('TABLE_EBAY_SITES', 'ebay_sites');
	  define('TABLE_EBAY_COUNTRIES', 'ebay_countries');
	  define('TABLE_EBAY_SAMMLER', 'ebay_sammler');
	  define("TABLE_EBAY_CONF","ebay_configuration");
	  define("TABLE_EBAY_TRANSACTIONS","ebay_transactions");
	  define("TABLE_EBAY_PRODUCTS","ebay_products");
	  define("TABLE_EBAY_DURATIONS","ebay_durations");
	  define('TABLE_EBAY_CATEGORYS','ebay_categorys');
	  define('TABLE_EBAY_SHIPPINGOPTIONS','ebay_shippingoptions');
	  define('TABLE_EBAY_PRODUCTS_TO_CATEGORIES','ebay_products_to_categories');
	  define('TABLE_EBAY_AUCTIONS','ebay_auctions');
	  define('TABLE_EBAY_EMAILS','ebay_emails');
	  define('TABLE_EBAY_DISPUTES','ebay_disputes');
	  define('TABLE_EBAY_CALLS','ebay_calls');
	  define('TABLE_EBAY_WARNING_HISTORY','ebay_warning_history');
	  define('TABLE_TEXTITEMS','ebay_textitems');

  // ***** E B A Y    E N D ******


  // define the database table names used in the project
  define('TABLE_ADDRESS_BOOK', 'address_book');
  define('TABLE_ADDRESS_FORMAT', 'address_format');
  define('TABLE_ADMIN_ACCESS', 'admin_access');
  define('TABLE_BANNERS', 'banners');
  define('TABLE_BANNERS_HISTORY', 'banners_history');
  define('TABLE_CATEGORIES', 'categories');
  define('TABLE_CATEGORIES_DESCRIPTION', 'categories_description');
  define('TABLE_CONFIGURATION', 'configuration');
  define('TABLE_CONFIGURATION_GROUP', 'configuration_group');
  define('TABLE_TPL_MODULES_CONFIGURATION', 'tpl_modules_configuration ');
  define('TABLE_COUNTRIES', 'countries');
  define('TABLE_CURRENCIES', 'currencies');
  define('TABLE_CUSTOMERS', 'customers');
  define('TABLE_CUSTOMERS_BASKET', 'customers_basket');
  define('TABLE_CUSTOMERS_BASKET_ATTRIBUTES', 'customers_basket_attributes');
  define('TABLE_CUSTOMERS_INFO', 'customers_info');
  define('TABLE_CUSTOMERS_IP', 'customers_ip');
  define('TABLE_CUSTOMERS_STATUS', 'customers_status');
  define('TABLE_CUSTOMERS_STATUS_HISTORY', 'customers_status_history');
  define('TABLE_FORMS', 'forms');
  define('TABLE_LANGUAGES', 'languages');
  define('TABLE_MANUFACTURERS', 'manufacturers');
  define('TABLE_MANUFACTURERS_INFO', 'manufacturers_info');
  define('TABLE_NEWSLETTERS', 'newsletters');
  define('TABLE_NEWSLETTERS_HISTORY', 'newsletters_history');
  define('TABLE_NEWSLETTER_RECIPIENTS', 'newsletter_recipients');
  define('TABLE_ORDERS', 'orders');
  define('TABLE_ORDERS_PRODUCTS', 'orders_products');
  define('TABLE_ORDERS_PRODUCTS_ATTRIBUTES', 'orders_products_attributes');
  define('TABLE_ORDERS_PRODUCTS_DOWNLOAD', 'orders_products_download');
  define('TABLE_ORDERS_STATUS', 'orders_status');
  define('TABLE_ORDERS_STATUS_HISTORY', 'orders_status_history');
  define('TABLE_ORDERS_TOTAL', 'orders_total');
  define('TABLE_ORDERS_RECALCULATE', 'orders_recalculate');
  define('TABLE_PRODUCTS', 'products');
  define('TABLE_PRODUCTS_ATTRIBUTES', 'products_attributes');
  define('TABLE_PRODUCTS_ATTRIBUTES_DOWNLOAD', 'products_attributes_download');
  define('TABLE_PRODUCTS_DESCRIPTION', 'products_description');
  define('TABLE_PRODUCTS_NOTIFICATIONS', 'products_notifications');
  define('TABLE_PRODUCTS_IMAGES', 'products_images');
  define('TABLE_PRODUCTS_OPTIONS', 'products_options');
  define('TABLE_PRODUCTS_OPTIONS_VALUES', 'products_options_values');
  define('TABLE_PRODUCTS_OPTIONS_VALUES_TO_PRODUCTS_OPTIONS', 'products_options_values_to_products_options');
  define('TABLE_PRODUCTS_TO_CATEGORIES', 'products_to_categories');
  define('TABLE_PRODUCTS_VPE', 'products_vpe');
  define('TABLE_PERSONAL_OFFERS_BY','personal_offers_by_customers_status_');
  define('TABLE_REVIEWS', 'reviews');
  define('TABLE_REVIEWS_DESCRIPTION', 'reviews_description');
  define('TABLE_SESSIONS', 'sessions');
  define('TABLE_SPECIALS', 'specials');
  define('TABLE_TAX_CLASS', 'tax_class');
  define('TABLE_TAX_RATES', 'tax_rates');
  define('TABLE_GEO_ZONES', 'geo_zones');
  define('TABLE_ZONES_TO_GEO_ZONES', 'zones_to_geo_zones');
  define('TABLE_WHOS_ONLINE', 'whos_online');
  define('TABLE_ZONES', 'zones');
  define('TABLE_BOX_ALIGN','box_align');
  define('TABLE_PRODUCTS_XSELL', 'products_xsell');
  define('TABLE_CUSTOMERS_MEMO','customers_memo');
  define('TABLE_CONTENT_MANAGER','content_manager');
  define('TABLE_PRODUCTS_CONTENT','products_content');
  define('TABLE_MEDIA_CONTENT','media_content');
  define('TABLE_MODULE_NEWSLETTER','module_newsletter');
  define('TABLE_CM_FILE_FLAGS', 'cm_file_flags');
  define('TABLE_COUPON_GV_QUEUE', 'coupon_gv_queue');
  define('TABLE_COUPON_GV_CUSTOMER', 'coupon_gv_customer');
  define('TABLE_COUPON_EMAIL_TRACK', 'coupon_email_track');
  define('TABLE_COUPON_REDEEM_TRACK', 'coupon_redeem_track');
  define('TABLE_COUPONS', 'coupons');
  define('TABLE_COUPONS_DESCRIPTION', 'coupons_description');
  define('TABLE_SHIPPING_STATUS', 'shipping_status');
  define('TABLE_BLACKLIST', 'card_blacklist');
  
  // include needed functions
  require_once(DIR_WS_CLASSES.'specials_ebay_revise.php');
  require_once(DIR_FS_INC.'xtc_is_preisbindung.inc.php');
  require_once(DIR_FS_INC.'xtc_get_preisbindung_value.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_connect.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_close.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_error.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_query.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_queryCached.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_perform.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_fetch_array.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_num_rows.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_data_seek.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_insert_id.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_free_result.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_fetch_fields.inc.php');
  require_once(DIR_FS_INC . 'xtc_note.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_output.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_input.inc.php');
  require_once(DIR_FS_INC . 'xtc_db_prepare_input.inc.php');
  require_once(DIR_FS_INC . 'xtc_get_ip_address.inc.php');
  require_once(DIR_FS_INC . 'xtc_setcookie.inc.php');
  require_once(DIR_FS_INC . 'xtc_validate_email.inc.php');
  require_once(DIR_FS_INC . 'xtc_not_null.inc.php');
  require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
  require_once(DIR_FS_INC . 'xtc_get_tax_rate.inc.php');
  
require_once('../'.DIR_WS_CLASSES.'product_properties.php');
require_once(DIR_FS_INC.'yes_get_products_images.inc.php');
require_once(DIR_FS_INC.'cartesian_functions.inc.php');
require_once(DIR_FS_INC . 'yes_push.inc.php');

  // customization for the design layout
  define('BOX_WIDTH', 0); // how wide the boxes should be in pixels (default: 125)

  // Some definitions for Order Edit must move to db next time.
  define('ORDERS_EDIT_TAX_STATUS', 'true');

  // Define how do we update currency exchange rates
  // Possible values are 'oanda' 'xe' or ''
  define('CURRENCY_SERVER_PRIMARY', 'oanda');
  define('CURRENCY_SERVER_BACKUP', 'xe');


  // include the database functions
//  require(DIR_WS_FUNCTIONS . 'database.php');

  // make a connection to the database... now
  xtc_db_connect() or die('Unable to connect to database server!');

$key = 'configuration'; // vereinheitlicht
$CachedString = $InstanceCache->getItem($key);
if (!$CachedString->isHit()) {
    // set application wide parameters
    $defines_array = [];
    $configuration_query = xtc_db_query('select configuration_key as cfgKey, configuration_value as cfgValue from ' . TABLE_CONFIGURATION . '');
    while ($configuration = xtc_db_fetch_array($configuration_query)) {
      $defines_array[] = ['key'=>$configuration['cfgKey'],'value'=>$configuration['cfgValue']];
    }
    $CachedString->set($defines_array)->expiresAfter(0);//configuration
    $InstanceCache->save($CachedString); // Save the cache item just like you do with doctrine and entities
}else{
    $defines_array = $CachedString->get();
}
foreach($defines_array as $cnfg){
  if(!defined($cnfg['key']) and $cnfg['key'] != 'MAX_DISPLAY_SEARCH_RESULTS'){
    define($cnfg['key'], $cnfg['value']);
  }
}
define('FILENAME_IMAGEMANIPULATOR',IMAGE_MANIPULATOR);


  if(!defined('STORE_DB_TRANSACTIONS')){
    // Use the DB-Logger
    define('STORE_DB_TRANSACTIONS', 'false');
  }
  if(!defined('SECURITY_CODE_LENGTH')){
    // Set the length of the redeem code, the longer the more secure
    define('SECURITY_CODE_LENGTH', '6');
  }


define('ORDERS_EDIT_TAX_VALUE',xtc_get_tax_rate(1));

// some code to solve compatibility issues
require(DIR_WS_FUNCTIONS . 'compatibility.php');

require(DIR_WS_FUNCTIONS . 'general.php');


// define how the session functions will be used
require(DIR_WS_FUNCTIONS . 'sessions.php');

  // define our general functions used application-wide
require(DIR_WS_FUNCTIONS . 'html_output.php');

// set the session name and save path
session_name('XTCsid');


// define our localization functions
require(DIR_WS_FUNCTIONS . 'localization.php');

// Include validation functions (right now only email address)
//require(DIR_WS_FUNCTIONS . 'validations.php');

// setup our boxes
require(DIR_WS_CLASSES . 'table_block.php');
require(DIR_WS_CLASSES . 'box.php');

// initialize the message stack for output messages
require(DIR_WS_CLASSES . 'message_stack.php');
$messageStack = new messageStack;

// split-page-results
require(DIR_WS_CLASSES . 'split_page_results.php');

// entry/item info classes
require(DIR_WS_CLASSES . 'object_info.php');

// email classes
require(DIR_WS_CLASSES . 'mime.php');
require(DIR_WS_CLASSES . 'email.php');

// Include Template Engine
if (defined('PDO::ATTR_DRIVER_NAME') and version_compare(phpversion(), '7.0', '>=')) {
  require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'class.yesSmarty.php');
}else{
  require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'Smarty_2.6.3/Smarty.class.php');
  require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'class.yesSmarty2.php');
}
// include the language translations
// include the language translations
if(defined('ADMIN_LANGUAGE')){
  require(DIR_FS_LANGUAGES . ADMIN_LANGUAGE . '/admin/'.ADMIN_LANGUAGE . '.php');
  if(isset($_SERVER['argc']) and is_countable($_SERVER['argc'])){
    $filename = '';
    for($i=0;$i<$_SERVER['argc'];$i++){
      if(stristr($_SERVER['argv'][$i],'.php')){
        $filename = $_SERVER['argv'][$i];
      }
    }
    if(!empty($filename)){
      $current_page = explode('?', basename($filename)); $current_page = $current_page[0]; // for BadBlue(Win32) webserver compatibility
      if ($current_page != '' and file_exists(DIR_FS_LANGUAGES . ADMIN_LANGUAGE . '/admin/'.$current_page)) {
        include(DIR_FS_LANGUAGES . ADMIN_LANGUAGE . '/admin/'.  $current_page);
      }
    }
  }
}
