<?php
require_once(DIR_FS_INC.'yes_customers_email_alias_functions.inc.php');
function _get_icon($type){
    $part = explode('/',$type);
    if(isset($part[1])){
        switch($part[1]){
            case 'png':
                $part[1] = 'gif';
                break;
        }
        if(is_file('images/icons/icon_'.$part[1].'.gif')){
            return 'images/icons/icon_'.$part[1].'.gif';
        }
    }
    return 'images/icons/file.gif';
}
if(!isset($customers_id)){
    $customers_id = (int)xtc_db_input($_GET['cID']);
}
if($customers_id <= 0){
    die('Falsche Parameter &uuml;bergeben.');
}
$cust = \YES4Trade\Model\customers::get_by_customers_id($customers_id);
if($cust->customers_default_address_id > 0){
    $ab = \YES4Trade\Model\address_book::get_by_address_book_id((int)$cust->customers_default_address_id);
}else{
    $ab = \YES4Trade\Model\address_book::get_by_customers_id($customers_id)[0];
}
$customers = xtc_array_merge($cust->toArray(), $ab->toArray());
$cInfo = new objectInfo($customers);

$customers['email_aliases'] = yes_get_customers_email_aliases($customers_id);

$customers['basket'] = array();
$basket_query = xtc_db_query(sprintf(
    "SELECT * FROM %s WHERE customers_id='%s'",
    TABLE_CUSTOMERS_BASKET,$cInfo->customers_id
));
while($basket = xtc_db_fetch_array($basket_query)){
    $basket['products_name'] = xtc_get_products_name($basket['products_id']);
    $bdate_y = substr($basket['customers_basket_date_added'],0,4);
    $bdate_m = substr($basket['customers_basket_date_added'],4,2);
    $bdate_d = substr($basket['customers_basket_date_added'],6,2);
    $basket['customers_basket_date_added'] = xtc_date_short($bdate_y.'-'.$bdate_m.'-'.$bdate_d);
    $customers['basket'][] = $basket;
}


$crm_smarty = new yesSmarty;
$crm_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

$customers['country_name'] = xtc_get_country_name($cInfo->entry_country_id);
if($cInfo->block_warnings == 1){
	if($cInfo->block_warnings_span == 0) {
		$customers['mahnstatus'] = HISTORY_MEMO_NO_WARN_TITLE;
	}else{
		$customers['mahnstatus'] = sprintf(TEXT_WARNING_DAYS_DATE,$cInfo->block_warnings_dayspan,xtc_date_short($cInfo->block_warnings_date));
	}
}else{
	$customers['mahnstatus'] = TEXT_WARNING_STATUS_OFF;
}
$customers['customers_email_address_urlencoded'] = urlencode($customers['customers_email_address']);
$crm_smarty->assign(array(
    'cInfo'=>$customers
));
	
$orders_smarty = new yesSmarty;
$orders_smarty->assign(array(
    'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'orders_paging_link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('orders_paging_link')).'orders_page=')
));

$memos_array = array();
$items = \YES4Trade\Model\customers_memo::get_by_customers_id((int)xtc_db_prepare_input($customers_id));
foreach($items as $it){
    $memos_array[] = array(
        'DATUM'=>$it->memo_date,
        'TITEL'=>$it->memo_title,
        'TEXT'=>$it->memo_text,
        'EDITOR'=>  xtc_get_editor_name($it->poster_id)
    );
}
$orders_smarty->assign('MEMOS',sizeOf($memos_array));
$orders_smarty->assign('MEMO',$memos_array);

$crm_smarty->assign('ORDERS',$orders_smarty->fetch(DIR_FS_ADMIN.'templates/order_list.html'));

$sum = '';

$orders_sum = array();
$years_sum = array();
$year_status_query = xtc_db_query(sprintf(
        "SELECT SUBSTRING( o.date_purchased, 1, 4 ) AS jahr, SUM( ot.value ) AS total_sum, orders_status
        FROM orders o
        LEFT JOIN  `orders_total` ot
        USING ( orders_id ) 
        WHERE o.customers_id = '%s' AND orders_status != '%s' 
        AND ot.class =  'ot_total'
        GROUP BY jahr,orders_status ORDER BY jahr DESC",
        xtc_db_prepare_input($customers_id),ORDERS_STATUS_STORNIERT
));
while($year_status = xtc_db_fetch_array($year_status_query)){
    $year_status['status_name'] = xtc_get_orders_status_name($year_status['orders_status']);
    $year_status['total_sum_formatted'] = number_format($year_status['total_sum'],2,',','.');
    $orders_sum[ $year_status['jahr'] ][] = $year_status;
    if($year_status['orders_status'] != ORDERS_STATUS_STORNIERT){
        $years_sum[ $year_status['jahr'] ] += $year_status['total_sum'];
    }
}
$crm_smarty->assign('ORDER_SUM',$orders_sum);
$crm_smarty->assign('YEARS_SUM',$years_sum);
$date_from = (date('Y')-2).'-01-01';
$source_query = xtc_db_query(sprintf(
    "SELECT source, SUM( ot.value ) AS total_sum
    FROM orders o
    LEFT JOIN  `orders_total` ot
    USING ( orders_id ) 
    WHERE o.customers_id = '%d' 
    AND date_purchased > '%s' 
    AND ot.class =  'ot_total' AND
    orders_status != '%s' 
    GROUP BY source ORDER BY source DESC",
    $customers_id,
    $date_from,ORDERS_STATUS_STORNIERT
));
$sum = array();
while($record = xtc_db_fetch_array($source_query)){
    if($record['source'] == '') {
        $record['source'] = 'nicht zugeordnet';
    }
    $sum[ $record['source'] ] = $record['total_sum'];
}
if(sizeOf($sum)>1){
    $crm_smarty->assign(array(
        'SOURCE_SUM'=>$sum,
        'stats_source_date'=>xtc_date_short($date_from)
    ));
}


$crm_smarty->assign('order_data',$orders_array);


$msg = array();
$payments = array();
$query = xtc_db_query("SELECT ip.id,ip.verwendungszweck1,ip.verwendungszweck2,ip.verwendungszweck4,ip.betrag,ip.buchungstag,orders_id FROM orders o LEFT JOIN payment_orders po USING(orders_id),incoming_payments ip WHERE ip.id=po.payment_id AND o.customers_id='".$order->customer['ID']."' ORDER BY po.created DESC");
while($row = xtc_db_fetch_array($query)){
    $date_mysql = implode( '-', array_reverse( explode( '.', $row['buchungstag'] ) ) ) . ' 00:00:00';
    $msg[] = array('id'=>'payment','title'=>ENTRY_DATE_PAYMENT.' '.number_format($row['betrag'],2,',','.').' '.$order->info['currency'],'text'=>$row['verwendungszweck1'].'<br />'.$row['verwendungszweck2'].'<br />'.$row['verwendungszweck4'],'date'=>strtotime($date_mysql));
    $payments[] = $row;
}


$payments_copy = array(); // manche ZE wurden mehreren Rechnungen zugewiesen
$payment_string = '';
if(sizeOf($payments)>0){
    $total_payments = 0;
    $payment_string =  '<table border="0" width="100%" cellspacing="0" cellpadding="2">';
    $payment_string .= '<tr class="dataTableHeadingRow">';
    $payment_string .= '    <td class="dataTableHeadingContent">'.TABLE_HEADING_DATE.'</td>';
    $payment_string .= '    <td class="dataTableHeadingContent">'.TABLE_HEADING_ORDERS_ID.'</td>';
    $payment_string .= '    <td class="dataTableHeadingContent">'.TABLE_HEADING_AMOUNT.'</td>';
    $payment_string .= '</tr>';
    foreach($payments as $k=>$pay){
        $payment_string .= '<tr class="dataTableRow">';
        $payment_string .= '    <td class="dataTableContent">'.$pay['buchungstag'].'</td>';
        $payment_string .= '    <td class="dataTableContent">'.$pay['orders_id'].'</td>';
        $payment_string .= '    <td class="dataTableContent" align="right">'.number_format($pay['betrag'],2,',','.').'</td>';
        $payment_string .= '</tr>';
        if(!in_array($pay['id'],$payments_copy)){
            $total_payments += $pay['betrag'];
            $payments_copy[] = $pay['id'];
        }
    }
    $payment_string .= '<tr class="dataTableRowSelected">';
    $payment_string .= '    <td class="dataTableContent" colspan="2">'.ENTRY_TOTAL.'</td>';
    $payment_string .= '    <td class="dataTableContent" align="right">'.number_format($total_payments,2,',','.').'</td>';
    $payment_string .= '</tr>';
    $payment_string .= '</table>';
}
$crm_smarty->assign('PAYMENTS',$payment_string);

// BOF RUECKS
$rueck_smarty = new yesSmarty;
$rueck_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$rueckerstattung_array = array();
$rueck_query = xtc_db_query("SELECT rueckerstattungs_id FROM rueckerstattungen WHERE customers_id='".xtc_db_prepare_input($customers_id)."' ORDER BY date_created DESC");
$num_ruecks = xtc_db_num_rows($rueck_query);
while($ruecks = xtc_db_fetch_array($rueck_query)){
    $rID = $ruecks['rueckerstattungs_id'];
    $rueckerstattung = new rueckerstattung($rID);
    $rueck_array[] = array(
        'RID'=>'<a target="_blank" href="'.xtc_href_link('rueckerstattungen.php','action=edit&rID='.$rueckerstattung->info['id']).'">'.$rueckerstattung->info['id'].'</a>',
        'OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$rueckerstattung->info['orders_id']).'">'.$rueckerstattung->info['orders_id'].'</a>',
        'RECID'=>(($rueckerstattung->info['reclamations_id'] > 0)?'<a target="_blank" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$rueckerstattung->info['reclamations_id']).'">'.$rueckerstattung->info['reclamations_id'].'</a>':''),
        'DATE_TITLE'=>ENTRY_DATE_CREATED,
        'DATE'=>yes_date_short($rueckerstattung->info['date_created']),
        'BETRAG'=>number_format($rueckerstattung->info['betrag'],2,',',''),
        'STATUS'=>xtc_get_rueckerstattungen_status_name($rueckerstattung->info['status']),
        'PAYMODE'=>$rueckerstattung->info['paymode']
    );
}
if($num_ruecks > 0){
    $rueck_smarty->assign('rueckerstattung_data',$rueck_array);
    $crm_smarty->assign('RUECKERSTATTUNGEN',$rueck_smarty->fetch(DIR_FS_ADMIN.'templates/rueckerstattung_list.html'));
}
// EOF RUECKS

// BOF RECLAMATIONS
$rec_smarty = new yesSmarty;
$rec_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$reclamations_array = array();
$rec_query = xtc_db_query("SELECT reclamations_id FROM reclamations WHERE customers_id='".xtc_db_prepare_input($customers_id)."' ORDER BY date_created DESC");
$num_recs = xtc_db_num_rows($rec_query);
while($recs = xtc_db_fetch_array($rec_query)){
    $paydate = '';
    $rID = $recs['reclamations_id'];
    $reclamation = new reclamation($rID);
    $recs_products_array = array();
    for($i=0;$i<count($reclamation->products);$i++){
        $recs_products_array[] = array('QTY'=>$reclamation->products[$i]['qty'],
            'PRODUCTS_NAME'=>$reclamation->products[$i]['name'],
            'PRODUCTS_PRICE'=>number_format($reclamation->products[$i]['final_price'],2,',','.'),
            'PROPERTIES'=>$reclamation->products[$i]['properties']
        );
    }

    $getship_query = xtc_db_query("SELECT versender,DATE_FORMAT(date_finished,'%d.%m.%Y') as datum FROM shippings WHERE reclamations_id='".$rID."'");
    while( $getship = xtc_db_fetch_array($getship_query) ){
        $paydate .= '<br /><br />'.sprintf(TEXT_SHIPPED_WITH,$getship['versender'],$getship['datum']);
    }
    $reclamations_array[] = array(
        'OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$reclamation->info['orders_id']).'">'.$reclamation->info['orders_id'].'</a>',
        'RID'=>'<a target="_blank" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$rID).'">'.$rID.'</a>',
        'DATE_CREATED_TITLE'=>ENTRY_DATE_CREATED,
        'DATE_CREATED'=>yes_strftime('%d.%m.%Y',strtotime( $reclamation->info['date_created']) ),
        'DATE_LAST_MODIFIED_TITLE'=>ENTRY_LAST_MODIFIED,
        'DATE_LAST_MODIFIED'=>($reclamation->info['last_modified'] > 0) ? yes_strftime('%d.%m.%Y',strtotime( $reclamation->info['last_modified']) ) : '',
        'STATUS'=>xtc_get_reclamations_status_name($reclamation->info['reclamations_status']),
        'TYPE'=>xtc_get_reclamations_types_name($reclamation->info['reclamations_type']),
        'REASONS'=>implode(',',$reclamation->reasons),
        'products'=>$recs_products_array,
        'address'=>xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, true,'',', ')
    );
}
if($num_recs > 0){
    $rec_smarty->assign('reclamations_data',$reclamations_array);
    $crm_smarty->assign('RECLAMATIONS',$rec_smarty->fetch(DIR_FS_ADMIN.'templates/reclamation_list.html'));
}
// EOF RECLAMATIONS
// BOF RETOURE

$ret_smarty = new yesSmarty;
$ret_smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$retoure_array = array();
$ret_query = xtc_db_query("SELECT retoure_id FROM retouren WHERE customers_id='".xtc_db_prepare_input($customers_id)."' ORDER BY date_created DESC");
$num_rets = xtc_db_num_rows($ret_query);
while($rets = xtc_db_fetch_array($ret_query)){
        $rID = $rets['retoure_id'];
        $retoure = new retoure($rID);
        $recs_products_array = array();
        for($i=0;$i<count($retoure->products);$i++){
                $rets_products_array[] = array('QTY'=>$retoure->products[$i]['qty'],
                    'PRODUCTS_NAME'=>$retoure->products[$i]['name'],
                    'PRODUCTS_PRICE'=>number_format($retoure->products[$i]['final_price'],2,',','.')
                );
        }

        $retoure_array[] = array(
            'OID'=>'<a target="_blank" href="'.xtc_href_link('orders.php','action=edit&oID='.$retoure->info['orders_id']).'">'.$retoure->info['orders_id'].'</a>',
            'recID'=>'<a target="_blank" href="'.xtc_href_link('reclamations.php','action=edit&rID='.$retoure->info['reclamations_id']).'">'.$retoure->info['reclamations_id'].'</a>',
            'RID'=>'<a target="_blank" href="'.xtc_href_link('retoure.php','action=edit&rID='.$rID).'">'.$rID.'</a>',
            'DATE_CREATED_TITLE'=>ENTRY_DATE_CREATED,
            'DATE_CREATED'=>yes_strftime('%d.%m.%Y',strtotime( $retoure->info['date_created']) ),
            'DATE_INITIATED_TITLE'=>'Eingeleitet:',
            'DATE_INITIATED'=>($retoure->info['date_initiated'] > 0) ? yes_strftime('%d.%m.%Y',strtotime( $retoure->info['date_initiated']) ) : '',
            'DATE_FINISHED_TITLE'=>'Geschlossen:',
            'DATE_FINISHED'=>($retoure->info['date_finished'] > 0) ? yes_strftime('%d.%m.%Y',strtotime( $retoure->info['date_finished']) ) : '',
            'SHIPPER'=>$retoure->info['versender'],
            'STATUS'=>xtc_get_retoure_status_name($retoure->info['retoure_status']),
            'products'=>$rets_products_array,
            'address'=>xtc_address_format($reclamation->delivery['format_id'], $reclamation->delivery, true,'',', ')
        );
}
if($num_rets > 0){
    $ret_smarty->assign('retoure_data',$retoure_array);
    $crm_smarty->assign('RETOURE',$ret_smarty->fetch(DIR_FS_ADMIN.'templates/retoure_list.html'));
}

// EOF RETOURE


$lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
$customers_status = main::get_customers_status($cInfo->customers_status,$lang_id);

$email = $cInfo->customers_email_address;
$crm_smarty->assign('NEW_MAIL_LINK',xtc_href_link('ebay_mail_frame.php','box=reply&email='.urlencode($email)));
$crm_smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
$crm_smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);
$additional_title = 'ID: '.$cInfo->customers_id;
if($cInfo->customers_cid != ''){
    $additional_title .= '&nbsp;/&nbsp;'.TEXT_CID_SHORT.': '.$cInfo->customers_cid;
}
$additional_title .= '&nbsp;('.$customers_status['customers_status_name'].')';


$buttons = array(
    array('text'=>IMAGE_BACK,
        'link'=>xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('cID', 'action'))),
        'auth'=>true,
        'lbOn'=>false
    ),
    array('text'=>IMAGE_EDIT_CUSTOMER,
        'link'=>xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('cID', 'action')) . 'cID=' . $cInfo->customers_id . '&action=edit'),
        'auth'=>true,
        'lbOn'=>false
    ),
    array('text'=>TEXT_EMAIL,
        'link'=>"javascript:void(window.open('".xtc_href_link('ebay_mail_frame.php', 'email=' . urlencode($cInfo->customers_email_address))."','_blank'));",
        'auth'=>true,
        'lbOn'=>false
    ),
    array('text'=>BUTTON_NEW_ORDER,
        'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action')).'action=new_order'),
        'auth'=>( $admin_access['f_customers_new_order'] == '1') ? true : false,
        'lbOn'=>false,
        'error'=>($cInfo->customers_status == 1) ? ERROR_CUSTOMERS_STATUS_GUEST_NOT_ALLOWED_TO_CREATE_NEW_ORDER : false,
        'js_confirmation'=>true,
        'js_confirmation_text'=>sprintf('%s?',BUTTON_NEW_ORDER),
    ),
    array('text'=>BUTTON_NEW_OFFER,
        'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action')).'action=new_offer'),
        'auth'=>( $admin_access['f_offers'] == '1' ) ? true : false,
        'lbOn'=>false,
        'error'=>($cInfo->customers_status == 1) ? ERROR_CUSTOMERS_STATUS_GUEST_NOT_ALLOWED_TO_CREATE_NEW_ORDER : false,
        'js_confirmation'=>true,
        'js_confirmation_text'=>sprintf('%s?',BUTTON_NEW_OFFER),
    ),
    array(
        'text' => TEXT_ALL_ORDERS, 
        'link'=>xtc_href_link(FILENAME_ORDERS, 'cID=' . $cInfo->customers_id),
        'lbOn'=>false,
        'auth'=>true
    )
);
// BOF - MEMOS AUSLAGERN	
$anz = \YES4Trade\Model\customers_memo::get_by_customers_id((int)xtc_db_input($_GET['cID']));
$buttons[] = array('text'=>sprintf(BUTTON_MEMO_COUNT,sizeOf($anz)),
    'link'=>xtc_href_link('customers.php',xtc_get_all_get_params(array('action','last_action')).'action=memo&last_action='.$_REQUEST['action']),
    'auth'=>true,
    'lbOn'=>true
);

// EOF - MEMOS AUSLAGERN	
$customer = new customer($cInfo->customers_id,true);
$right_content = '';
if($admin_access['stats_sales_report'] == 1){
    $refresh_account_link = xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(array('action')).'action=update_current_account_value');
    $right_content = sprintf('<div class="crm_customer_account_value" title="%s">%s: %s %s</div>',
            TEXT_ACCOUNT_VALUE_INTRO,TEXT_ACCOUNT_VALUE,
            number_format($customer->getAccount_value(),2,',','.'),
            yes_draw_href_link(IMAGE_UPDATE, $refresh_account_link,'ui-state-default')
    );
}
$crm_smarty->assign(array(
    'HEADING_TITLE'=>BUTTON_CRM.' '.$cInfo->customers_lastname.' '.$cInfo->customers_firstname,
    'ADDITIONAL_HEADING_TITLE'=>$additional_title,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'RIGHT_CONTENT'=>$right_content,
    'CRM_MULTIPLE_EMAIL_ADDRESS_SELECTOR'=>CRM_MULTIPLE_EMAIL_ADDRESS_SELECTOR,
    'TEXT_YEAR'=>TEXT_YEAR,
    'TEXT_UMSATZ'=>TEXT_UMSATZ,
    'TEXT_UMSATZ_CUSTOMER_WITHOUT_STORNO'=>TEXT_UMSATZ_CUSTOMER_WITHOUT_STORNO,
    'TEXT_STATISTICS_SOURCE'=>TEXT_STATISTICS_SOURCE,
    'TEXT_UMSATZ_CUSTOMER_WITHOUT_STORNO_BY_SOURCE'=>TEXT_UMSATZ_CUSTOMER_WITHOUT_STORNO_BY_SOURCE,
    'TEXT_UMSATZ_BY_YEAR_AND_STATUS'=>TEXT_UMSATZ_BY_YEAR_AND_STATUS,
    'TEXT_BANKDATA'=>TEXT_BANKDATA,
    'TEXT_KONTONUMMER'=>TEXT_KONTONUMMER,
    'TEXT_BLZ'=>TEXT_BLZ,
    'TEXT_KONTOINHABER'=>TEXT_KONTOINHABER,
    'TEXT_PAYMENTS'=>TEXT_HEADER_MENU_PAYMENTS,
    'TITLE_MEMO'=>TITLE_MEMO,
    'EXT_POPUP_WIDTH'=>EXT_POPUP_WIDTH,
    'EXT_POPUP_HEIGHT'=>EXT_POPUP_HEIGHT,
));
$double_accounts = array(array(
    'id'=>$cInfo->customers_id,
    'text'=>TEXT_SELECT
));
$doubles = \YES4Trade\Model\customers::get_customers_email_duplicates(
    $cInfo->customers_id, $cInfo->customers_email_address
);
foreach($doubles as $doubCID){
    $dc = \YES4Trade\Model\customers::get_by_customers_id( intval($doubCID) );
    $double_accounts[] = array(
        'id'=>intval($doubCID),
        'text'=>'#'.$doubCID.': '.$dc->customers_firstname.' '.$dc->customers_lastname
    );
}
if(sizeOf($double_accounts)>1){
    $crm_smarty->assign('INPUT_MULTIPLE_EMAILS',xtc_draw_pull_down_menu(
        'jump_to_customers_id', $double_accounts
    ));
}
$limit_emails = isset($_GET['all_emails'])?0:30;
$emails = \YES4Trade\Model\ebay_emails::get_by_from_email_or_customers_id(
    $cInfo->customers_email_address,
    $cInfo->customers_id,['id'],$limit_emails
);
if(is_countable($emails) and sizeOf($emails)){
    $crm_smarty->assign('EMAILS',$emails);
    $crm_smarty->assign('EMAILS_NUM',sizeOf($emails));
    if(!isset($_GET['all_emails'])){
        $crm_smarty->assign('show_all_emails_link',
            sprintf('<a href="%s"><button class="ui-state-button ui-corner-all ui-state-default" type="button">%s</button></a>',
                xtc_href_link(FILENAME_CUSTOMERS,xtc_get_all_get_params(['all_emails']).'all_emails=1'),
                TEXT_SHOW_ALL
            )
        );
    }
}

$crm_html = $crm_smarty->fetch(DIR_FS_ADMIN.'templates/crm.html');
