<?php
/* --------------------------------------------------------------
   $Id: split_page_results_array.php,v 1.2 2017/04/28 08:05:56 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(split_page_results.php,v 1.13 2003/05/05); www.oscommerce.com 
   (c) 2003	 nextcommerce (split_page_results.php,v 1.6 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

class splitPageResultsArray {
    function __construct(&$current_page_number, $max_rows_per_page, &$data_array, &$products_query_num_rows) {
        if (empty($current_page_number)) {
              $current_page_number = 1;
        }
        $products_query_num_rows = (is_countable($data_array)) ? sizeOf($data_array) : 0;
        $total_rows = $products_query_num_rows;
        $num_pages = ceil($total_rows / $max_rows_per_page);
        if ($current_page_number > $num_pages) {
            $current_page_number = $num_pages;
        }
        $offset = ($max_rows_per_page * ($current_page_number - 1));
        if($offset < 0){
		  $offset = 0;
        }
    }
    function display_links($query_numrows, $max_rows_per_page, $max_page_links, $current_page_number, $parameters = '', $page_name = 'page') {

      if ( xtc_not_null($parameters) && (substr($parameters, -1) != '&') ) $parameters .= '&';

      // calculate number of pages needing links
      $num_pages = ceil($query_numrows / $max_rows_per_page);


      $pages_array = array();
	  if($num_pages <= 20){
		  for ($i=1; $i<=$num_pages; $i++) {
			$pages_array[] = array('id' => $i, 'text' => $i);
		  }
	  }

      if ($num_pages > 1) {
        $display_links = xtc_draw_form('pages', basename($_SERVER['PHP_SELF']), '', 'get');
        if ($current_page_number > 1) {
          $display_links .= '<a href="' . xtc_href_link(basename($_SERVER['PHP_SELF']), $parameters . $page_name . '=' . ($current_page_number - 1), 'NONSSL') . '" class="splitPageLink">' . PREVNEXT_BUTTON_PREV . '</a>&nbsp;&nbsp;';
        } else {
          $display_links .= PREVNEXT_BUTTON_PREV . '&nbsp;&nbsp;';
        }

		if($num_pages <= 20){
			$display_links .= sprintf(TEXT_RESULT_PAGE, xtc_draw_pull_down_menu($page_name, $pages_array, $current_page_number, 'onChange="this.form.submit();"'), $num_pages);
		}else{
			$display_links .= sprintf(TEXT_RESULT_PAGE, xtc_draw_hidden_field($page_name, $current_page_number).'<input type="button" value="'.$current_page_number.'" onclick="split_page_select(this,'.(int)$num_pages.');" /><img src="images/pixel_trans.gif" width="1" border="0" /></a>', $num_pages);
		}

        if (($current_page_number < $num_pages) && ($num_pages != 1)) {
          $display_links .= '&nbsp;&nbsp;<a href="' . xtc_href_link(basename($_SERVER['PHP_SELF']), $parameters . $page_name . '=' . ($current_page_number + 1), 'NONSSL') . '" class="splitPageLink">' . PREVNEXT_BUTTON_NEXT . '</a>';
        } else {
          $display_links .= '&nbsp;&nbsp;' . PREVNEXT_BUTTON_NEXT;
        }

        if ($parameters != '') {
          if (substr($parameters, -1) == '&') $parameters = substr($parameters, 0, -1);
          $pairs = explode('&', $parameters);
          // php8 bugfix
          //while (list(, $pair) = each($pairs)) {
          foreach($pairs as $egal => $pair) {
            list($key,$value) = explode('=', $pair);
			$display_links .= xtc_draw_hidden_field(rawurldecode($key), rawurldecode($value));
          }
        }

        if (SID) $display_links .= xtc_draw_hidden_field(session_name(), session_id());

        $display_links .= '</form>';
      } else {
        $display_links = sprintf(TEXT_RESULT_PAGE, $num_pages, $num_pages);
      }

      return $display_links;
    }

    function display_count($query_numrows, $max_rows_per_page, $current_page_number, $text_output) {
      $to_num = ($max_rows_per_page * $current_page_number);
      if ($to_num > $query_numrows) $to_num = $query_numrows;
      $from_num = ($max_rows_per_page * ($current_page_number - 1));
      if ($to_num == 0) {
        $from_num = 0;
      } else {
        $from_num++;
      }

      return sprintf($text_output, $from_num, $to_num, $query_numrows);
    }
  }
?>
