<?php
class simple_lock{
	var $lockfile,$content,$send_status_mail,$lock_duration_minutes;
	function __construct($lockfile,$send_status_mail = false,$content = '1',$lock_duration_minutes = 15){
	    if(empty($lockfile)){
		die('simple_lock expects parameter lockfile');
	    }
	    $this->lockfile = $lockfile;
	    $this->content = $content;
	    $this->send_status_mail = $send_status_mail;
	    $this->lock_duration_minutes = $lock_duration_minutes;
	    clearstatcache();
	}
	
	function lock(){
	    if(!is_file($this->lockfile) and !file_exists($this->lockfile)){
		if(file_put_contents($this->lockfile, $this->content) === FALSE){
			die('CANT CREATE '.$this->lockfile);
		}
	    }else{
		$changed = filectime($this->lockfile);
		$file_garbage_time = $changed+(60*$this->lock_duration_minutes);
		if(time() <= $file_garbage_time){
		    $msg = sprintf(
			    "Der Prozess ist durch %s noch fuer %s gesperrt.",
			    $this->lockfile,yes_strftime('%M:%S',$file_garbage_time-time())
		    );
		    if($this->send_status_mail){
			$url = parse_url(HTTP_SERVER);
			$subject = 'FILE LOCK '.$_SERVER['SCRIPT_NAME'].' @ '.$url['host'];
			if($url['host'] != 'localhost')
			    mail('m.aspeleiter@yes-websolutions.de,b.agri@yes4trade.de',$subject,$msg);
		    }
		    die("\r\n----- LOCKED -----\r\n\r\n$msg\r\n\r\n");
		}else{
			$this->destroy();
			// neu anlegen
			file_put_contents($this->lockfile, $this->content);
		}
	    }
	}
	function destroy(){
	    if(is_file($this->lockfile))
		unlink($this->lockfile);
	}
}
