<?php
/* --------------------------------------------------------------
   (c) mario aspeleiter 05/2005 <dazze@gmx.de>
   --------------------------------------------------------------*/
require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'product_shipping_extra_charges.php');
require_once(realpath(__DIR__).DIRECTORY_SEPARATOR.'class.ebay_item.php');
class product {
    const IMAGE_PATH_ARRAY = array(
        DIR_FS_CATALOG_ORIGINAL_IMAGES,
        DIR_FS_CATALOG_THUMBNAIL_IMAGES,
        DIR_FS_CATALOG_INFO_IMAGES,
        DIR_FS_CATALOG_POPUP_IMAGES,
        DIR_FS_CATALOG_EBAYCATEGORY_IMAGES
    );

    var $info,$language_id,$collies,$storages,$distributors,$xtPrice,$mo_images,
        $shipping_extra_charges, $country;

    function __construct( $products_id, $language_id = -1,$do_queries = true, $country_id = -1 ) {
        $this->info = array();
        $this->collies = array();
        $this->storages = array();
        $this->distributors = array();
        $this->mo_images = array();
        $this->shipping_extra_charges = array();
        $this->language_id = ($language_id >= 0) ? $language_id : $_SESSION['languages_id'];
        // EU-OSS 2021/07
        $this->country = ($country_id == -1) ? STORE_COUNTRY : $country_id;
        if($do_queries){
            $this->query($products_id);
            $this->collies = $this->get_collies();
            $this->mo_images = $this->get_mo_images();
            $this->shipping_extra_charges = $this->load_shipping_extra_charges();
        }else{
            $this->info['products_id'] = $products_id;
        }
    }

	public function get_amazon_values(){
		$query = xtc_db_query(sprintf(
			"SELECT * FROM amazon_products WHERE products_id='%s'",
			$this->info['products_id']
		));
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			return $record;
		}
		return array();
	}
	
    function query($products_id) {
        $products_query = xtc_db_query("select p.*,pd.*,p2c.categories_id from products p,products_description pd LEFT JOIN products_to_categories p2c USING(products_id) where p.products_id = '" . xtc_db_input($products_id) . "' and pd.language_id='".$this->language_id."' and pd.products_id=p.products_id");
        if(xtc_db_num_rows($products_query)){
            $product = xtc_db_fetch_array($products_query);
            $product['products_tax_class_id'] = yes_eu_oss_get_products_tax_class_id($product['products_id'], $this->country);
            $this->info = xtc_db_prepare_input($product);
        }
    }

   function get_collies(){
		$collies = array();
		if(!isset($this->info['products_id'])){
			return $collies;
		}
		$collies_query = xtc_db_query("SELECT collie_products_id,quantity,sort_order FROM products_collies WHERE products_id='".$this->info['products_id']."' ORDER BY sort_order");
		if(xtc_db_num_rows($collies_query)){
			while($collie = xtc_db_fetch_array($collies_query)){
				$collies[] = $collie;
			}
			$collies = xtc_db_prepare_input($collies);
		}
		return $collies;
   }

   function get_storages($get_available_places=false){
	$product_storage_array = array();
	$product_storage_query = xtc_db_query("SELECT sn.id,sn.storage_id,sn.nummer,s.name FROM storage_numbers sn LEFT JOIN storages s ON s.id=sn.storage_id WHERE sn.products_id='".$this->info['products_id']."'");
	while($product_storage = xtc_db_fetch_array($product_storage_query)){
		$product_storage['link'] = xtc_href_link('storage_numbers.php','pID='.$this->info['products_id'].'&stID='.$product_storage['storage_id'].'&sID='.$product_storage['id']);
		$places_query = xtc_db_query("SELECT id,storage_places_id FROM storage_products WHERE products_id='".$this->info['products_id']."' and storage_id='".$product_storage['storage_id']."'");
		if(xtc_db_num_rows($places_query))
			$product_storage['places'] = array();
		while($places = xtc_db_fetch_array($places_query)){
			$places['link'] = xtc_href_link('storage_admin.php','spID='.$places['id'].'&pID='.$this->info['products_id'].'&stID='.$product_storage['storage_id']);
			$places['storage_place'] = yes_get_storage_place_title($places['storage_places_id']);
			$product_storage['places'][] = $places;
		}
		$product_storage['add_link'] = xtc_href_link('storage_admin.php','stID='.$product_storage['id'].'&pID='.$this->info['products_id'].'&action=addproduct');
		$product_storage['storage_link'] = xtc_href_link('storage.php','action=edit&sID='.$product_storage['storage_id']);
		if($get_available_places){
		    $product_storage['av_places'] = array();
		    $places_query = xtc_db_query(sprintf(
			    "SELECT storage_places_id,title FROM storage_places stp WHERE storage_id='%s' AND storage_places_id NOT IN (SELECT storage_places_id FROM storage_products WHERE products_id='%s' AND storage_id='%s') ORDER BY title",
			    $product_storage['storage_id'],
			    $this->info['products_id'],
			    $product_storage['storage_id']
		    ));
		    //products_id='".$this->info['products_id']."' and sp.storage_id='".$product_storage['storage_id']."' AND sp.id IS NULL");
		    if(xtc_db_num_rows($places_query))
		    while($places = xtc_db_fetch_array($places_query)){
			    $product_storage['av_places'][] = $places;
		    }
		}
		$product_storage_array[] = $product_storage;
	}
	$this->storages = $product_storage_array;
	return xtc_db_prepare_input($this->storages);
   }

   /**
    * LIEFERT ALLE LIEFERANTEN INFOS
    * optional incl der EK Preise je Lieferant
    *
    * @param boolean $prices
    * @return <type>
    */
   function get_distributors($prices = false){
	// NUR WENN NOCH NICHT GESETZT DURCHLAUFEN
	$product_distributors_array = array();
	$product_distributors_query = yes_db_query(sprintf(
		"SELECT dp.*,d.name,d.id FROM products_distributors dp LEFT JOIN distributors d ON d.id=dp.distributor_id WHERE dp.products_id='%s' ORDER BY dp.is_default DESC",
		$this->info['products_id']
	));

	if(!yes_db_num_rows($product_distributors_query))
		return $product_distributors_array;

	foreach($product_distributors_query as $product_distributors){
		$product_distributors['distributor_link'] = xtc_href_link('distributor.php','dID='.$product_distributors['id']);
		if($prices){
			$product_distributors['prices'] = $this->get_distributor_prices($product_distributors['id']);
		}
		$product_distributors_array[] = $product_distributors;
	}
	$this->distributors = xtc_db_prepare_input($product_distributors_array);
	return $this->distributors;
   }

   function get_edit_link(){
	if(!function_exists('xtc_get_parent_categories'))
		require_once(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
	if(!function_exists('xtc_get_product_path'))
		require_once(DIR_FS_INC.'xtc_get_product_path.inc.php');
	$cp = xtc_get_product_path($this->info['products_id']);
	return xtc_href_link(FILENAME_CATEGORIES, 'cPath=' . $cp . '&pID=' . $this->info['products_id'].'&action=new_product');
   }

   function get_weight($netto = false){
       $select_key = ($netto) ? 'products_weight_netto' : 'products_weight';
	if(sizeOf($this->collies)>0){
		$pweight = 0;
		foreach($this->collies as $k=>$collie){
			$weight_query = xtc_db_query(sprintf(
				"SELECT %s FROM %s WHERE products_id='%s'",
				$select_key,TABLE_PRODUCTS,$collie['collie_products_id']
			));
			$weight_res = xtc_db_fetch_array($weight_query);
			$pweight += $weight_res[$select_key]*$collie['quantity'];
		}
		return $pweight;	
	}else{
		return $this->info[$select_key];
	}
   }
   
   function get_weight_netto(){
       return $this->get_weight(true);
   }

   function get_bestands_popup_link(){
	return '<a title="Bestandsinfo anzeigen" href="#" onClick="window.open(\''.xtc_href_link('products.php','action=bestand&pID='.$this->info['products_id']).'\',\'popup\',\'width=400px,height=500px,scrollbars=yes,resizable=yes\');">';
   }

    public function add_history($comments){
         self::add_history_static( $this->info['products_id'], $comments );
    }
   
    public static function add_history_static($products_id, string $comments){
        $editor_id = intval($_SESSION['customer_id'] ?? 0);
	$insert_sql_array = array(
            'editor_id'=>$editor_id,
            'products_id'=>intval($products_id),
            'date_saved'=>'now()',
            'comments'=>$comments
	);
	xtc_db_perform('products_history',$insert_sql_array);
    }

   function get_distributor_prices($distributor_id=0){
	$sql_query_raw = sprintf("SELECT * FROM distributor_product_prices WHERE products_id='%s' ORDER BY price",$this->info['products_id']);
	if($distributor_id > 0){
		$sql_query_raw = sprintf("SELECT * FROM distributor_product_prices WHERE products_id='%s' and distributor_id='%s' ORDER BY price",$this->info['products_id'],$distributor_id);
	}
	$prices = array();
	$sql_query = xtc_db_query($sql_query_raw);
	while($sql = xtc_db_fetch_array($sql_query)){
		$prices[] = xtc_db_prepare_input($sql);
	}
	return $prices;
   }

   public function get_cross_selling_allocations():array{
	$xsells = array();
	$xsell_query = xtc_db_query("SELECT * FROM " . TABLE_PRODUCTS_XSELL . " WHERE products_id='".$this->info['products_id']."' ORDER BY sort_order");
	while($xsell = xtc_db_fetch_array($xsell_query)){
		$xsells[] = array(
			'products_id'=>intval($xsell['xsell_id']),
			'sort_order'=>intval($xsell['sort_order']),
			'products_name'=>xtc_get_products_name($xsell['xsell_id'])
		);
	}
	return $xsells;
   }
   function get_xsells(){
	$xsells = array();
	$xsell_query = xtc_db_query("SELECT * FROM " . TABLE_PRODUCTS_XSELL . " WHERE products_id='".$this->info['products_id']."'");
	while($xsell = xtc_db_fetch_array($xsell_query)){
		$xsells[] = array(
			'products_id'=>$xsell['products_id'],
			'sort_order'=>$xsell['sort_order']
		);
	}
	return $xsells;
   }
   
   public function xsell_cleanup(){
       xtc_db_query(sprintf(
               "DELETE FROM %s WHERE products_id='%s' OR xsell_id='%s'",
               TABLE_PRODUCTS_XSELL,$this->info['products_id'],
               $this->info['products_id']
       ));
       $this->add_history(' Cross Selling: removed');
   }
   
   public function xsell_copy($from_pid){
       $query = xtc_db_query(sprintf(
               "SELECT * FROM %s WHERE products_id='%s'",
               TABLE_PRODUCTS_XSELL,(int)$from_pid
       ));
       $num = (int)xtc_db_num_rows($query);
       while($record = xtc_db_fetch_array($query)){
           unset($record['ID']);
           $record['products_id'] = $this->info['products_id'];
           xtc_db_perform(TABLE_PRODUCTS_XSELL,$record);
       }
       $this->add_history('Cross Selling: copy '.$num.' xsells from pID '.$from_pid);
       return $num;
   }

   // muss auch in der yes/includes/classes Version definiert werden
   function get_running_auctions_list(){
		$auctions = array();
		$products_in_auction = \YES4Trade\Model\ebay_auctions::get_runnings_by_products_id(intval($this->info['products_id']),[
			'id', 'type', 'sku','ebay_id','quantity','quantity_sold','title','user'
		]);
		foreach($products_in_auction as $ea_item){
			$record = $ea_item->toArray();
			$record['variation'] = 0;
			$auctions[] = $record;
		}
		$query = xtc_db_query(sprintf(
			"SELECT id, ea.type, ebay_id,eav.quantity,eav.sku,eav.quantity_sold,title,user,1 as variation FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON eav.ebay_auctions_id=ea.id WHERE ea.products_id='0' AND eav.products_id='%s' AND status=0",
			$this->info['products_id']
		));                
		while($record = xtc_db_fetch_array($query)){
			$auctions[] = $record;
		}
		return $auctions;
   }

   function get_running_auctions(){
		$auctions = array();

		$products_in_auction = \YES4Trade\Model\ebay_auctions::get_runnings_by_products_id(intval($this->info['products_id']),[
			'id','ebay_id'
		]);
		foreach($products_in_auction as $ea_item){
			$auctions[] = $ea_item->toArray();
		}
		return $auctions;
   }

   function get_ebay_products_list(){
		$ebay_products = array();
		$query = xtc_db_query(sprintf(
			"SELECT id,locked,0 AS variation FROM ebay_products WHERE products_id='%s'",
			$this->info['products_id']
		));
		while($record = xtc_db_fetch_array($query)){
			$ebay_products[] = $record;
		}
		$query = xtc_db_query(sprintf(
			"SELECT ep.id,locked,1 AS variation,ev.sku FROM ebay_products ep LEFT JOIN ebay_variations_sets evs ON ep.id=evs.ebay_products_id LEFT JOIN ebay_variations ev USING(ebay_variations_sets_id) WHERE ev.products_id='%s'",
			$this->info['products_id']
		));
		while($record = xtc_db_fetch_array($query)){
			$ebay_products[] = $record;
		}
		return $ebay_products;
   }

   function get_ebay_products(){
		$ebay_products = array();
		$query = xtc_db_query(sprintf(
			"SELECT id,locked FROM ebay_products WHERE products_id='%s'",
			$this->info['products_id']
		));
		while($record = xtc_db_fetch_array($query)){
			$ebay_products[] = $record;
		}
		return $ebay_products;
   }

   /**
    * Gibt ein Array aller Bilder zurueck
    * nr = Bildnummer
    * name = Filename
    *
    * @return array Images for product
    */
   function get_images($file_check_dir = ''){
	   $images = array();
	   if(xtc_not_null($this->info['products_image'])){
	       $check = true;
	       if($file_check_dir != ''){
		   if(!is_file(DIR_FS_CATALOG.'images/product_images/'.$file_check_dir.'/'.$this->info['products_image'])){
		       $check = false;
		   }
	       }
	       if($check){
		$images[] = array( 'nr' => 0, 'name'=>$this->info['products_image'] );
	       }
	   }
	   $query = xtc_db_query(sprintf(
			"SELECT image_nr,image_name FROM products_images WHERE products_id='%s' ORDER BY image_name",
			   $this->info['products_id']
	   ));
	   while($row = xtc_db_fetch_array($query)){
	       $check = true;
	       if($file_check_dir != ''){
		   if(!is_file(DIR_FS_CATALOG.'images/product_images/'.$file_check_dir.'/'.$row['image_name'])){
		       $check = false;
		   }
	       }
	       if($check){
		   $images[] = array(
			   'nr'=>$row['image_nr'],
			   'name'=>$row['image_name']
		   );
	       }
	   }
	   return $images;
   }

   /**
    * BENOETIGT KLASSEN:
    * class.ebay.php
    *
    *
    * @param array $cs_array - customer statuses from xtc_get_customers_statuses
    */
   function delete($cs_array){
	    global $EBAYAPI;
		if(!is_object($EBAYAPI))
			die('Class ebayApi nicht verfuegbar');
		$query_raw = array();
		foreach($cs_array as $cs){
                    if(!isset($cs['id'])){
                        continue; // 0 und 1 existieren nicht - 07/22
                    }
                    \YES4Trade\Model\group_prices::delete_by_products_id($cs['id'],$this->info['products_id']);
		}
		$images = $this->get_images();
		$delete_files = array();
		for( $i = 0; $i < sizeOf( $images ); $i++ ){
			if($images[$i]['nr'] > 0){
				$query_raw[] = sprintf("DELETE FROM products_images WHERE products_id='%s' and image_nr='%s'",
						$this->info['products_id'],$images[$i]['nr']
				);
			}
			$delete_files[] = $images[$i]['name'];
		}
		$query = xtc_db_query(sprintf("SELECT reviews_id FROM reviews WHERE products_id='%s'",
				$this->info['products_id']
		));
		while($row = xtc_db_fetch_array($query)){
			$query_raw[] = sprintf("DELETE FROM reviews_description WHERE reviews_id='%s'",
				$row['reviews_id']
			);
		}
                
                \YES4Trade\Model\products_to_categories::delete($this->info['products_id']);
		$simple_tables = array(
			'amazon_products',
			'branches_products',
			'customers_basket',
			'customers_basket_attributes',
			'distributor_product_prices',
			'history_bestand',
			'products_content',
			'products_description',
			'products_history',
			'products_notifications',
			'specials',
			'products',
			'products_storages',
			'products_storages_history',
			'products_to_characteristics',
			'products_to_groups',
			'products_xsell',
			'products_distributors',
			'products_characteristic_text_values',
			'reviews',
			'shipping_graduation_products',
			'storage_numbers',
			'storage_products',
			'products_graduated_prices',
			'groups_allocations',
			'products_master_slave_values',
		    'products_email_notifications',
			'product_un_classification',
		);
		if(defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') and YES_PAYMODULE_PRODUCTS_FAKE_SETS == 'True')
		    $simple_tables[] = 'products_fake_sets';

		foreach($simple_tables as $table){
			$query_raw[] = sprintf("DELETE FROM %s WHERE products_id='%s'",
					$table,$this->info['products_id']
			);
		}
		$query_raw[] = sprintf("DELETE FROM products_collies WHERE products_id='%s' or collie_products_id='%s'",
				$this->info['products_id'],$this->info['products_id']
		);

		for($i=0;$i<sizeOf($delete_files);$i++){
			xtc_del_image_file($delete_files[$i]);
		}



		$delete_ebay_products = array();
		$ebay_products = $this->get_ebay_products();
		for($i=0;$i<sizeOf($ebay_products);$i++){
			$delete_ebay_products[] = $ebay_products[$i]['id'];
		}
                foreach($delete_ebay_products as $epID){
                    $ep = new ebay_product($epID);
                    $ep->delete();
                }
		foreach($query_raw as $query){
			xtc_db_query($query);
		}
		
		// MASTER SLAVE KEYS
		$query = xtc_db_query(sprintf(
			"SELECT products_master_keys_id FROM products_master_keys WHERE products_id='%s'",
			$this->info['products_id']
		));
		while($record = xtc_db_fetch_array($query)){
			xtc_db_query(sprintf(
				"DELETE FROM products_master_keys_description WHERE products_master_keys_id='%s'",
				$record['products_master_keys_id']
			));
			xtc_db_query(sprintf(
				"DELETE FROM products_master_keys WHERE products_master_keys_id='%s'",
				$record['products_master_keys_id']
			));
		}
		
		// properties
		$query = xtc_db_query(sprintf(
			"SELECT products_properties_id FROM products_properties WHERE products_id='%s'",
			$this->info['products_id']
		));
		while($record = xtc_db_fetch_array($query)){
			xtc_db_query(sprintf(
				"DELETE FROM products_properties_description WHERE products_properties_id='%s'",
				$record['products_properties_id']
			));
			$query2 = xtc_db_query(sprintf(
				"SELECT products_properties_values_id FROM products_properties_values WHERE products_properties_id='%s'",
				$record['products_properties_id']
			));
			while($record2 = xtc_db_fetch_array($query2)){
				xtc_db_query(sprintf(
					"DELETE FROM products_properties_values_description WHERE products_properties_values_id='%s'",
					$record2['products_properties_values_id']
				));
			}
			xtc_db_query(sprintf(
				"DELETE FROM products_properties_values WHERE products_properties_id='%s'",
				$record['products_properties_id']
			));
		}
		xtc_db_query(sprintf(
			"DELETE FROM products_properties WHERE products_id='%s'",
			$this->info['products_id']
		));
                // XY PRICES
                $xy = \YES4Trade\Model\product_properties_xy_prices::get_from_products_id($this->info['products_id']);
                if($xy !== false){
                    \YES4Trade\Model\product_properties_xy_prices::delete($xy->product_properties_xy_prices_id);
                }
                
		return true;
   }
   
   function get_unallocated_storage_products_quantity(){
	   $query = xtc_db_query(sprintf(
			   "SELECT SUM(sp.quantity) as anz FROM storage_products sp WHERE products_id=%s",
			   $this->info['products_id']
	   ));
	   $record = xtc_db_fetch_array($query);
	   return $this->info['products_quantity']-(int)$record['anz'];
   }
	function get_default_distributor_id(){
		$query = xtc_db_query(sprintf(
			"SELECT distributor_id FROM products_distributors WHERE is_default=1 AND products_id=%s",
			$this->info['products_id']
		));
		if(xtc_db_num_rows($query)){
			$record = xtc_db_fetch_array($query);
			return $record['distributor_id'];
		}
		return 0;
	}
	
	public function get_manufacturers_data(){
	    if( $this->info['manufacturers_id'] == 0 ) return array();
	    if(!isset($this->info['manufacturers_data'])){
		$query = xtc_db_query(sprintf(
			"SELECT * FROM %s WHERE manufacturers_id='%s'",
			TABLE_MANUFACTURERS,$this->info['manufacturers_id']
		));
		if(xtc_db_num_rows($query)){
		    $record = xtc_db_fetch_array($query);
		    unset($record['manufacturers_id']);
		    $this->manufacturers_data = $record;
		    return $this->manufacturers_data;
		}else{
		    return array();
		}
	    }
	    return $this->manufacturers_data;
	}
	
	function get_shop_link($connection='NONSSL',$add_session_id = false,$search_engine_safe=true){
	    global $session_started; // woher auch immer, eigentlich egal
	    if ($connection == 'NONSSL') {
	      $link = HTTP_SERVER . DIR_WS_CATALOG;
	    } elseif ($connection == 'SSL') {
	      if (ENABLE_SSL == true) {
	        $link = HTTPS_SERVER . DIR_WS_CATALOG;
	      } else {
	        $link = HTTP_SERVER . DIR_WS_CATALOG;
	      }
	    } else {
	      die('</td></tr></table></td></tr></table><br /><br /><font color="#ff0000"><b>Error!</b></font><br /><br /><b>Unable to determine connection method on a link!<br /><br />Known methods: NONSSL SSL</b><br /><br />');
	    }
	    $page = 'product_info.php';
	    $parameters = 'products_id=' . $this->info['products_id'];
	    $link .= $page . '?'.$parameters;
	    $separator = '&';

	    while ( (substr($link, -1) == '&') || (substr($link, -1) == '?') ) $link = substr($link, 0, -1);

	// Add the session ID when moving from different HTTP and HTTPS servers, or when SID is defined
	    if ( ($add_session_id == true) && ($session_started == true) && (SESSION_FORCE_COOKIE_USE == 'False') ) {
	      if (defined('SID') && xtc_not_null(SID)) {
	        $sid = SID;
	      } elseif ( ( ($request_type == 'NONSSL') && ($connection == 'SSL') && (ENABLE_SSL == true) ) || ( ($request_type == 'SSL') && ($connection == 'NONSSL') ) ) {
	        if ($http_domain != $https_domain) {
	          $sid = session_name() . '=' . session_id();
	        }
	      }
	    }

	//--- SEO Hartmut König -----------------------------------------//
	    if (((SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true)) )
	        {
	        require_once(DIR_FS_INC . 'shopstat_functions.inc.php');

	        $seolink = shopstat_getSEO( $page,
	                                    $parameters,
	                                    $connection,
	                                    $add_session_id,
	                                    $search_engine_safe,
	                                    'admin');
	        if($seolink)
	            {
	            $link       = $seolink;
	            $elements   = parse_url($link);
	            (isset($elements['query']))
	                ? $separator = '&'
	                : $separator = '?';
	            }
	        }
	//--- SEO Hartmut König -----------------------------------------//

		// remove session if useragent is a known Spider
	    if ($truncate_session_id) $sid=NULL;

	    if (isset($sid)) {
	      $link .= $separator . $sid;
	    }
	/*
	    if ( (SEARCH_ENGINE_FRIENDLY_URLS == 'true') && ($search_engine_safe == true) ) {
	      while (strstr($link, '&&')) $link = str_replace('&&', '&', $link);

	      $link = str_replace('?', '/', $link);
	      $link = str_replace('&', '/', $link);
	      $link = str_replace('=', '/', $link);
	      $separator = '?';
	    }
	*/

	    //-- W3C-Conform
	    if($urlencode)
	        {
	        $link = htmlentities($link);
	        }

	    return $link;
	}
	
	function get_fake_sets(){
	    $items = array();
	    if(!defined('YES_PAYMODULE_PRODUCTS_FAKE_SETS') or YES_PAYMODULE_PRODUCTS_FAKE_SETS != 'True'){
		return $items;
	    }
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM products_fake_sets WHERE products_id='%s'",
		    $this->info['products_id']
	    ));
	    if(xtc_db_num_rows($query)){
		return xtc_db_fetch_array($query);
	    }
	    return $items;
	}
	
	public function get_group_allocations_data($groups_id,$language_id,$ebay_flag = false){
            $gh = new \YES4Trade\Model\group_handler((int)$language_id);
            $allocs = $gh->get_allocated_product_group_characteristic_values($this->info['products_id']);
            foreach($allocs as $alloc){
                if( $ebay_flag == true ){
                    if($alloc['ebay_visible'] == 1){
                        $allocation_array[ $alloc['title'] ] = $alloc['value'];
                    }
                }else{
                    $allocation_array[ $alloc['title'] ] = $alloc['value'];
                }
            }
	    return $allocation_array;
	}
	
	function get_shipping_status_name(){
	    $query = xtc_db_query(sprintf("SELECT shipping_status_name FROM %s where shipping_status_id = '%s' and language_id = '%s'",
		    TABLE_SHIPPING_STATUS,$this->info['products_shippingtime'],
		    $this->language_id
	    ));
	    $record = xtc_db_fetch_array($query);
	    return $record['shipping_status_name'];
	}
	
	function get_storage_numbers($storage_id){
	    $result = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT nummer FROM storage_numbers WHERE products_id='%s' AND storage_id='%s'",
		    $this->info['products_id'],$storage_id
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$result[] = $record['nummer'];
	    }
	    return $result;
	}
        
        /**
         * Liefert den DB Eintrag als Array aus storage_products des Artikels 
         * zur storage_id
         * 
         * @param int $storage_id
         * @return array
         */
	function get_storage_allocation($storage_id){
	    $query = xtc_db_query(sprintf(
		    "SELECT storage_places_id, quantity,created,changed,storage_place,priority FROM storage_products WHERE products_id='%s' AND storage_id='%s'",
		    $this->info['products_id'],$storage_id
	    ));
	    if(xtc_db_num_rows($query)){
		$record = xtc_db_fetch_array($query);
                if($record['storage_places_id'] > 0){
                    $record['storage_place'] = yes_get_storage_place_title($record['storage_places_id']);
                }
		$record['storage_numbers'] = $this->get_storage_numbers($storage_id);
		return $record;
	    }else{
		return array();
	    }
	}

	public function copy_and_save_image($filename,$image_number){
	    $image_locations = self::IMAGE_PATH_ARRAY;
	    $pname_arr = explode('.',basename($filename));
	    $nsuffix = strtolower(array_pop($pname_arr));
	    $products_image_name = $this->info['products_id'] . '_'.$image_number.'.' . $nsuffix;
	    if($image_number == 0){
		if(isset($this->info['products_image']) and $this->info['products_image'] != '' and $this->info['products_image'] != $products_image_name){
		    foreach($image_locations as $delete_path){
                        if(is_dir($delete_path)){
                            @unlink($delete_path.$this->info['products_image']);
                        }
		    }
		}
	    }else{
		foreach($this->mo_images as $mo){
		    if($mo['image_nr'] == $image_number and $mo['image_name'] != '' and $mo['image_name'] != $products_image_name){
			foreach($image_locations as $delete_path){
                            if(is_dir($delete_path)){
                                unlink($delete_path.$mo['image_name']);
                            }
			}
		    }
		}
	    }
	    rename ($filename, DIR_FS_CATALOG_ORIGINAL_IMAGES.$products_image_name);
	    if(EXTERN_EBAYPICTURE_SERVER == 1){

			$link = ftp_connect(EXTERN_EBAYPICTURE_SERVER_HOST);
			if (!ftp_login($link,EXTERN_EBAYPICTURE_SERVER_USERNAME,EXTERN_EBAYPICTURE_SERVER_PASSWORD))
				throw new Exception("EXTERN_EBAYPICTURE_SERVER: Kann mich nicht einloggen.");

			if (!ftp_chdir($link, "www-data/images"))
				throw new Exception("EXTERN_EBAYPICTURE_SERVER: Kann nicht in das Zielverzeichnis /pub wechseln.");
			if(!is_file($filename))
				throw new Exception('EXTERN_EBAYPICTURE_SERVER: '.$filename.' ist keine Datei.');
			$result = ftp_put($link,$products_image_name, DIR_FS_CATALOG_ORIGINAL_IMAGES.$products_image_name, FTP_BINARY);
			if (!$result)
				throw new Exception("EXTERN_EBAYPICTURE_SERVER: Upload von Datei $products_image_name  fehlgeschlagen.");
			ftp_quit($link);

  		}
		$link_check = DIR_FS_CATALOG_THUMBNAIL_IMAGES;
		if(substr($link_check,strlen($link_check)-1,strlen($link_check)) == '/'){
		    $link_check = substr($link_check,0,strlen($link_check)-1);
		}
		\main::resize_image($products_image_name, DIR_FS_CATALOG_ORIGINAL_IMAGES, DIR_FS_CATALOG_THUMBNAIL_IMAGES, [
			PRODUCT_IMAGE_THUMBNAIL_WIDTH,
			PRODUCT_IMAGE_THUMBNAIL_HEIGHT
		]);
		\main::resize_image($products_image_name, DIR_FS_CATALOG_ORIGINAL_IMAGES, DIR_FS_CATALOG_POPUP_IMAGES, [
			PRODUCT_IMAGE_POPUP_WIDTH,
			PRODUCT_IMAGE_POPUP_HEIGHT
		]);
		\main::resize_image($products_image_name, DIR_FS_CATALOG_ORIGINAL_IMAGES, DIR_FS_CATALOG_INFO_IMAGES, [
			PRODUCT_IMAGE_INFO_WIDTH,
			PRODUCT_IMAGE_INFO_HEIGHT
		]);


		// ORIG IMAGES SIND ZU GROSS - POPUP NEHMEN
		if(defined('USE_NO_ORIGINAL_IMAGES') and USE_NO_ORIGINAL_IMAGES == 'True'){
			unlink(DIR_FS_CATALOG_ORIGINAL_IMAGES.'/'.$products_image_name);
			copy(DIR_FS_CATALOG_POPUP_IMAGES.'/'.$products_image_name,DIR_FS_CATALOG_ORIGINAL_IMAGES.'/'.$products_image_name);
		}

		$editor_id = intval($_SESSION['customer_id'] ??  0);
		if($image_number == 0){
			$sql_data_array['products_image'] = xtc_db_prepare_input($products_image_name);
			xtc_db_perform('products',$sql_data_array,'update','products_id='.$this->info['products_id']);


			// products_history
			$comments = HISTORY_PRODUCTS_IMAGE1_UPLOAD;
			xtc_db_query("INSERT INTO products_history SET products_id='".$this->info['products_id']."',editor_id='".$editor_id."',date_saved=now(),comments='".$comments."'");
		}else{
			$query = xtc_db_query(sprintf(
				"SELECT image_id FROM products_images WHERE image_nr='%s' and products_id='%s'",
				$image_number,$this->info['products_id']

			));
			if(!xtc_db_num_rows($query)){
				$sql_data_array = array(
					'products_id'=>$this->info['products_id'],
					'image_nr'=>$image_number,
					'image_name'=>$products_image_name
				);
				xtc_db_perform('products_images',$sql_data_array);
			}else{
				$sql_data_array = array(
					'image_name'=>$products_image_name
				);
				xtc_db_perform('products_images',$sql_data_array,'update',"products_id='".$this->info['products_id']."' and image_nr='".$image_number."'");
			}
			// products_history
			$comments = sprintf(HISTORY_PRODUCTS_MO_IMAGE_UPLOAD,$products_image_name);
			xtc_db_query("INSERT INTO products_history SET products_id='".$this->info['products_id']."',editor_id='".$editor_id."',date_saved=now(),comments='".$comments."'");
		}
		return $products_image_name;
	}
	
	public function get_mo_images(){
	    $images = array();
		// 01/2017: ORDER BY image_nr eingefuegt, speziell fuer Variantenbilder Handling
	    $query = xtc_db_query(sprintf(
		    "SELECT image_nr,image_name FROM %s WHERE products_id='%s' ORDER BY image_nr",
		    TABLE_PRODUCTS_IMAGES, $this->info['products_id']
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$images[] = $record;
	    }
	    return $images;
	}

	public function get_packaging_details(){
	    $info = array();
	    if($this->info['packagings_id'] == 0){
		return $info;
	    }
	    $query = xtc_db_query(sprintf(
		    "SELECT * FROM packagings WHERE packagings_id='%s'",
		    $this->info['packagings_id']
	    ));
	    if(xtc_db_num_rows($query)){
		$record = xtc_db_fetch_array($query);
		$info = array(
		    'title'=>xtc_db_prepare_input($record['title']),
		    'weight'=>$record['weight'],
		    'weight_brutto'=>$this->info['products_weight_netto']+$record['weight']
		);
	    }
	    return $info;
	}
	
	
	public function get_slaves(){
	    $slaves = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT products_id FROM %s WHERE products_master='%s'",
		    TABLE_PRODUCTS,$this->info['products_id']
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$slaves[] = $record['products_id'];
	    }
	    return $slaves;
	}
	
	public function get_master_slave_values($master_id,$language_id = -1){
	    if($language_id < 0)
		$language_id = $_SESSION['languages_id'];
	    $values = array();
	    if($master_id < 1)
		return $values;
	    $master_keys = array();
	    $query = xtc_db_query(sprintf(
		    "SELECT pmk.products_master_keys_id,title FROM products_master_keys pmk LEFT JOIN products_master_keys_description pmkd USING(products_master_keys_id) WHERE products_id='%s' AND language_id='%s' ORDER BY sort_order",
		    $master_id,$language_id
	    ));
	    while($record = xtc_db_fetch_array($query)){
		$master_keys[] = $record;
	    }
	    if(!sizeOf($master_keys))
		return $values;
	    foreach($master_keys as $pmk){
		$query = xtc_db_query(sprintf(
			"SELECT title FROM products_master_slave_values WHERE products_id='%s' AND products_master_key_id='%s' AND language_id='%s'",
			$this->info['products_id'],$pmk['products_master_keys_id'],$language_id
		));
		while($record = xtc_db_fetch_array($query)){
		    $values[] = array(
			'value'=>xtc_db_prepare_input($record['title']),
			'key'=>xtc_db_prepare_input($pmk['title']),
		    );
		}
	    }
	    return $values;
	}
        
        /**
         * Hole in_auction Wert
         * 
         * Es wird der in_auction Wert ermittelt aus den ebay_auction Tabellen
         * Eigentlich veraltet bzw ueberfluessig, da es ja products.in_auction
         * gibt.
         * Ausserdem heikel, denn Stklistenartikel haben keinen in_auction Wert
         * 
         * @return type
         */
        function get_auction_quantity_from_ebay_auctions(){
            // normale auktion
			$in_auction = \YES4Trade\Model\ebay_auctions::calc_running_auctions_quantity_for_products_id(intval($this->info['products_id']));
            
            // normale varianten auktion
            $query = xtc_db_query(sprintf(
				"SELECT SUM(eav.quantity) as anz FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON eav.ebay_auctions_id = ea.id WHERE eav.products_id='%s' and ea.status=0",
				$this->info['products_id']
            ));
            $record = xtc_db_fetch_array($query);
            $in_auction += $record['anz'];
            
            $sets = xtc_get_product_in_collies($this->info['products_id']);
            if(sizeOf($sets)){
                foreach($sets as $set){
                    // als colli in normaler auktion
                    $in_auction = \YES4Trade\Model\ebay_auctions::calc_running_auctions_quantity_for_products_id(intval($set['products_id']));
                    
                    // als colli in varianten auktion
                    $query = xtc_db_query(sprintf(
                            "SELECT SUM(eav.quantity) as anz FROM ebay_auctions ea LEFT JOIN ebay_auctions_variations eav ON eav.ebay_auctions_id = ea.id WHERE eav.products_id='%s' and ea.status=0",
                            $set['products_id']
                    ));
                    $record = xtc_db_fetch_array($query);
                    $in_auction += $record['anz']*$set['quantity'];
                }
            }
            return $in_auction;
        }
        
        public function get_single_price($currency = DEFAULT_CURRENCY, $customers_status = 1,$country = STORE_COUNTRY){
            $this->xtPrice = new xtcPrice($currency, $customers_status);
            // EOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
            $products_tax_class_id = yes_eu_oss_get_products_tax_class_id(
                $this->info['products_id'], $country
            );
            $taxrate = xtc_get_tax_rate($products_tax_class_id,$country);
            if(PRICE_IS_BRUTTO == 'true'){
                $product_price = $this->xtPrice->xtcGetPrice($this->info['products_id'],
                    $format=true,
                    1,
                    $products_tax_class_id,
                    $this->info['products_price']
                );
                $product_price = str_replace('<font size="-1" color="#ff0000">','',$product_price);
                $product_price = str_replace('</font>','',$product_price);
                $price = $product_price;
            }else{
                $price = $this->xtcFormat($this->info['products_price'],true);
            }
            return array(
                'price'=>$price,
                'setting'=>sprintf('1 Stk, %s &raquo;%s&laquo;, %s',IMAGE_STATUS, xtc_get_customers_status_name($customers_status), xtc_get_country_name($country))
            );
        }
    /**
     * prueft ob der artikel als Sammlerprodukt oder eBay Timer gespeichert
     * oder bei ebay, amazon eingestellt ist
     * Rueckgabe array:
     * array(
     *      'ebay_products'=>0,
     *      'ebay_timer'=>0,
     *      'ebay'=>0,
     *      'amazon'=>0,
     *  )
     * @return array
     */
    function check_delete(){
        $return = array(
            'ebay_products'=>0,
            'ebay_timer'=>0,
            'ebay'=>0,
            'amazon'=>0,
        );
        $ia = $this->get_auction_quantity_from_ebay_auctions();
        if($ia > 0){
            $return['ebay'] = $ia;
        }
        $aa = $this->get_amazon_values();
        if($aa['quantity'] > 0){
            $return['amazon'] = $aa['quantity'];
        }
        $ep = $this->get_ebay_products_list();
        if(sizeOf($ep)){
            $return['ebay_products'] = sizeOf($ep);
        }
        return $return;
    }
    
    public function get_products_content( $language_id = null ){
        $array = array();
        $lang_sql = ($language_id === null) ? 2 : $language_id;
        $items = \YES4Trade\Model\products_content::get_by_products_id($this->info['products_id']);
        foreach($items as $it){
            $record = $it->toArray();
			$pcd = \YES4Trade\Model\products_content_description::get_by_content_id_and_language_id(intval($record['content_id']),intval($lang_sql));
			$record['content_name'] = $pcd->content_name??'';
			$record['file_comment'] = $pcd->file_comment??'';
            if(!empty($record['content_file'])){
                $record['content_file_basename'] = basename($record['content_file']);
            }else{
                $record['content_file_basename'] = '';
            }
            $array[] = $record;
        }
        return $array;
    }
    
    public function delete_products_content($file = ''){
        $items = \YES4Trade\Model\products_content::get_by_products_id($this->info['products_id']);
        foreach($items as $it){
            if(!empty($file)){
                if($it->content_file == $file){
                    \YES4Trade\Model\products_content::delete($it->content_id);
                }
            }else{
                \YES4Trade\Model\products_content::delete($it->content_id);
            }
        }
    }
    
    public function load_shipping_extra_charges(){
        $array = array();
        $query = xtc_db_query(sprintf(
                "SELECT products_shipping_extra_charge_id FROM products_shipping_extra_charge WHERE products_id='%s'",
                $this->info['products_id']
        ));
        while($record = xtc_db_fetch_array($query)){
            $array[] = $record['products_shipping_extra_charge_id'];
        }
        foreach($array as $products_shipping_extra_charge_id){
            $this->shipping_extra_charges[] = new product_shipping_extra_charges($products_shipping_extra_charge_id);
        }
    }
    
    public function has_special_price(){
        $query = xtc_db_query(sprintf(
                "SELECT specials_id FROM %s WHERE products_id='%s'",
                TABLE_SPECIALS,$this->info['products_id']
        ));
        return xtc_db_num_rows($query);
    }
    
    /**
     * Ist die angegebene products_id ein gespeicherter Artikel in der Tabelle
     * products?
     * @param int $products_id
     * @return boolean
     */
    public static function isProduct($products_id){
        if($products_id < 1 or !is_int($products_id)){
            return false;
        }
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM %s WHERE products_id='%s'",
                TABLE_PRODUCTS, $products_id
        ));
        return (xtc_db_num_rows($query))?true:false;
    }
    
    /**
     * Ermittelt alle products_id zu einer products_ean
     * 
     * @param String $ean
     * @return array
     */
    public static function get_products_id_array_from_ean($ean){
        $return = array();
        if(empty($ean)){
            return $return;
        }
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM %s WHERE products_ean='%s'",
                TABLE_PRODUCTS, $ean
        ));
        if(!xtc_db_num_rows($query)){
            return $return;
        }
        while($product = xtc_db_fetch_array($query)){
            $return[] = $product['products_id'];
        }
        return $return;
    }
    
    public function delete_image($image){
        foreach(self::IMAGE_PATH_ARRAY as $path){
            if(is_dir($path) and is_file($path.$image)){
                unlink($path.$image);
            }
        }
    }
    
    
    public static function is_stuecklistenartikel(int $products_id){
        $query = xtc_db_query(sprintf(
                "SELECT products_collies_id FROM products_collies WHERE products_id='%d'",
                $products_id
        ));
        return (xtc_db_num_rows($query)>0) ? true : false;
    }
    
    public function get_vpe_string(float $price, string $currency){
        require_once(DIR_FS_INC.'xtc_format_price_order.inc.php');
        $vpe_name = xtc_get_vpe_name($this->info['products_vpe']);
        return xtc_format_price_order(
                $price / $this->info['products_vpe_value'] * $this->info['products_vpe_base_measure'],1,
                $currency
        ).'/'.number_format($this->info['products_vpe_base_measure'],2,',','.').
        ' ' .$vpe_name;
    }
    
    public static function update_status( int $products_id, bool $status, string $comments = '' ){
        $update_sql_array = [
            'products_status'=>($status===true)?1:0,
            'products_last_modified'=>'now()',
        ];
        xtc_db_perform(TABLE_PRODUCTS,$update_sql_array, 'update', "products_id='".$products_id."'");
        if( !empty($comments) ){
            self::add_history_static( $products_id, $comments );
        }
    }
    
    public static function exists( $products_id ){
        if($products_id < 1){
            return false;
        }
        $query = xtc_db_query(sprintf(
                "SELECT products_id FROM %s WHERE products_id='%d'",
                TABLE_PRODUCTS, $products_id
        ));
        return (xtc_db_num_rows($query)>0) ? true : false;
    }

	public static function get_groups_export_string(int $products_id, int $language_id):string{
		require_once(DIR_FS_INC.'xtc_productgroups.inc.php');
		require_once(DIR_FS_INC.'yes_get_products_characteristics.inc.php');
		$groups = xtc_get_product_groups($products_id);
		$char = yes_get_products_characteristics($products_id, $language_id);
		$return = '';
		foreach($groups as $g){
			$g = \YES4Trade\Model\groups::get_by_groups_id($g['id'],$language_id);
			if(intval($g->visible) != 1){
				continue;
			}
			$return .= sprintf('<p><b>%s</b></p>',BOX_PRODUCTS_ATTRIBUTES);
			$return_lines = [];
			foreach($char as $c){
				if($c['group_id'] != $g->groups_id){
					continue;
				}
				if(intval($c['visible']) != 1){
					continue;
				}
				$return_lines[] = sprintf('<b>%s:</b> %s',
					$c['title'], $c['value']
				);
			}
			$return .= implode('<br />',$return_lines);
		}
		return $return;
	}
}
