<?php
class ebay_finding_api
{
    var $appid;
    var $urlfilter;
    var $endpoint = 'http://svcs.ebay.com/services/search/FindingService/v1';
    var $version = '1.0.0';
    var $globalid = 'EBAY-DE';
    function __construct(){
        $ini_conf = ebayApi::get_ebay_config_ini();
	$this->appid = $ini_conf['ebay-config']['app-key-prod'];
    }
    
    function call($params){
	$query = $params['query'];
	$safequery = urlencode($query);  // Make the query URL-friendly
	$filterarray = array(
	    array(
	    'name' => 'SELLER',
	    'value' => $params['seller']),
	);
	$this->buildURLArray($filterarray);
	// Construct the findItemsByKeywords HTTP GET call 
	$apicall = "$this->endpoint?";
	$apicall .= "OPERATION-NAME=findItemsByKeywords";
	$apicall .= "&SERVICE-VERSION=$this->version";
	$apicall .= "&SECURITY-APPNAME=$this->appid";
	$apicall .= "&GLOBAL-ID=$this->globalid";
	$apicall .= "&keywords=$safequery";
	$apicall .= "&paginationInput.entriesPerPage=1";
	$apicall .= "&outputSelector(0)=PictureURLSuperSize&outputSelector(1)=PictureURLLarge";
	$apicall .= "$this->urlfilter";

	// Load the call and capture the document returned by eBay API
	$resp = simplexml_load_file($apicall);
	if ($resp->ack == "Success") {
	  $results = array();
	  // If the response was loaded, parse it and build links  
	  foreach($resp->searchResult->item as $item) {
	    $results['PictureURLSuperSize'] = $item->pictureURLSuperSize;
	    $results['PictureURLLarge'] = $item->pictureURLLarge;
	  }
	}else {
	  $results['Error']  = "<h3>Oops! The request was not successful. Make sure you are using a valid ";
	  $results['Error']  .= "AppID for the Production environment.</h3>";
	}
	return $results;
    }
    
    private function buildURLArray ($filterarray) {
      global $i;
      // Iterate through each filter in the array
      foreach($filterarray as $itemfilter) {
	// Iterate through each key in the filter
	foreach ($itemfilter as $key =>$value) {
	  if(is_array($value)) {
	    foreach($value as $j => $content) { // Index the key for each value
	      $this->urlfilter .= "&itemFilter($i).$key($j)=$content";
	    }
	  }
	  else {
	    if($value != "") {
	      $this->urlfilter .= "&itemFilter($i).$key=$value";
	    }
	  }
	}
	$i++;
      }
    } // End of buildURLArray function
    
}
