<?php
/**
 * DO NOT EDIT THIS FILE!
 *
 * This file was automatically generated from external sources.
 *
 * Any manual change here will be lost the next time the SDK
 * is updated. You've been warned!
 */

namespace DTS\eBaySDK\PostOrder\Services;

class PostOrderService extends \DTS\eBaySDK\PostOrder\Services\PostOrderBaseService
{
    const API_VERSION = 'v2';

    /**
     * @property array $operations Associative array of operations provided by the service.
     */
    protected static $operations = [
        'ApproveCancellationRequest' => [
            'method' => 'POST',
            'resource' => 'cancellation/{cancelId}/approve',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ApproveCancellationRequestRestResponse',
            'params' => [
                'cancelId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CheckCancellationEligibility' => [
            'method' => 'POST',
            'resource' => 'cancellation/check_eligibility',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CheckCancellationEligibilityRestResponse',
            'params' => [
            ]
        ],
        'ConfirmCancellationRefund' => [
            'method' => 'POST',
            'resource' => 'cancellation/{cancelId}/confirm',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ConfirmCancellationRefundRestResponse',
            'params' => [
                'cancelId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetCancellation' => [
            'method' => 'GET',
            'resource' => 'cancellation/{cancelId}?',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetCancellationRestResponse',
            'params' => [
                'cancelId' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'fieldgroups' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'RejectCancellationRequest' => [
            'method' => 'POST',
            'resource' => 'cancellation/{cancelId}/reject',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\RejectCancellationRequestRestResponse',
            'params' => [
                'cancelId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'SearchCancellations' => [
            'method' => 'GET',
            'resource' => 'cancellation/search',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SearchCancellationsRestResponse',
            'params' => [
                'buyer_login_name' => [
                    'valid' => ['string']
                ],
                'cancel_id' => [
                    'valid' => ['string']
                ],
                'creation_date_range_from' => [
                    'valid' => ['string']
                ],
                'creation_date_range_to' => [
                    'valid' => ['string']
                ],
                'item_id' => [
                    'valid' => ['string']
                ],
                'legacy_order_id' => [
                    'valid' => ['string']
                ],
                'limit' => [
                    'valid' => ['string']
                ],
                'offset' => [
                    'valid' => ['string']
                ],
                'seller_login_name' => [
                    'valid' => ['string']
                ],
                'sort' => [
                    'valid' => ['string']
                ],
                'transaction_id' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'SubmitCancellationRequest' => [
            'method' => 'POST',
            'resource' => 'cancellation',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SubmitCancellationRequestRestResponse',
            'params' => [
            ]
        ],
        'AppealCaseDecision' => [
            'method' => 'POST',
            'resource' => 'casemanagement/{caseId}/appeal',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\AppealCaseDecisionRestResponse',
            'params' => [
                'caseId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CloseCase' => [
            'method' => 'POST',
            'resource' => 'casemanagement/{caseId}/close',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CloseCaseRestResponse',
            'params' => [
                'caseId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetCase' => [
            'method' => 'GET',
            'resource' => 'casemanagement/{caseId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetCaseRestResponse',
            'params' => [
                'caseId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'IssueCaseRefund' => [
            'method' => 'POST',
            'resource' => 'casemanagement/{caseId}/issue_refund',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\IssueCaseRefundRestResponse',
            'params' => [
                'caseId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'ProvideReturnShipmentInfo' => [
            'method' => 'POST',
            'resource' => 'casemanagement/{caseId}/provide_shipment_info',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ProvideReturnShipmentInfoRestResponse',
            'params' => [
                'caseId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'ProvidesReturnAddress' => [
            'method' => 'POST',
            'resource' => 'casemanagement/{caseId}/provide_return_address',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ProvidesReturnAddressRestResponse',
            'params' => [
                'caseId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'SearchCases' => [
            'method' => 'GET',
            'resource' => 'casemanagement/search',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SearchCasesRestResponse',
            'params' => [
                'case_creation_date_range_from' => [
                    'valid' => ['string']
                ],
                'case_creation_date_range_to' => [
                    'valid' => ['string']
                ],
                'case_status_filter' => [
                    'valid' => ['string']
                ],
                'fieldgroups' => [
                    'valid' => ['string']
                ],
                'item_id' => [
                    'valid' => ['string']
                ],
                'limit' => [
                    'valid' => ['string']
                ],
                'offset' => [
                    'valid' => ['string']
                ],
                'order_id' => [
                    'valid' => ['string']
                ],
                'return_id' => [
                    'valid' => ['string']
                ],
                'sort' => [
                    'valid' => ['string']
                ],
                'transaction_id' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'CheckInquiryEligibility' => [
            'method' => 'POST',
            'resource' => 'inquiry/check_eligibility',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CheckInquiryEligibilityRestResponse',
            'params' => [
            ]
        ],
        'CloseInquiry' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/close',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CloseInquiryRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'ConfirmInquiryRefund' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/confirm_refund',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ConfirmInquiryRefundRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CreateInquiry' => [
            'method' => 'POST',
            'resource' => 'inquiry',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CreateInquiryRestResponse',
            'params' => [
            ]
        ],
        'EscalateInquiry' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/escalate',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\EscalateInquiryRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetInquiry' => [
            'method' => 'GET',
            'resource' => 'inquiry/{inquiryId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetInquiryRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'IssueInquiryRefund' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/issue_refund',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\IssueInquiryRefundRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'ProvideInquiryRefundInfo' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/provide_refund_info',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ProvideInquiryRefundInfoRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'ProvideInquiryShipmentInfo' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/provide_shipment_info',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ProvideInquiryShipmentInfoRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'SearchInquiries' => [
            'method' => 'GET',
            'resource' => 'inquiry/search',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SearchInquiriesRestResponse',
            'params' => [
                'fieldgroups' => [
                    'valid' => ['string']
                ],
                'inquiry_creation_date_range_from' => [
                    'valid' => ['string']
                ],
                'inquiry_creation_date_range_to' => [
                    'valid' => ['string']
                ],
                'inquiry_status' => [
                    'valid' => ['string']
                ],
                'item_id' => [
                    'valid' => ['string']
                ],
                'limit' => [
                    'valid' => ['string']
                ],
                'offset' => [
                    'valid' => ['string']
                ],
                'order_id' => [
                    'valid' => ['string']
                ],
                'sort' => [
                    'valid' => ['string']
                ],
                'transaction_id' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'SendInquiryMessage' => [
            'method' => 'POST',
            'resource' => 'inquiry/{inquiryId}/send_message',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SendInquiryMessageRestResponse',
            'params' => [
                'inquiryId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'AddShippingLabelInfo' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/add_shipping_label',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\AddShippingLabelInfoRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CancelReturnRequest' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/cancel',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CancelReturnRequestRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CheckReturnEligibility' => [
            'method' => 'POST',
            'resource' => 'return/check_eligibility',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CheckReturnEligibilityRestResponse',
            'params' => [
            ]
        ],
        'CheckShippingLabelEligibility' => [
            'method' => 'GET',
            'resource' => 'return/{returnId}/check_label_print_eligibility',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CheckShippingLabelEligibilityRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CreateReturnDraft' => [
            'method' => 'POST',
            'resource' => 'return/draft',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CreateReturnDraftRestResponse',
            'params' => [
            ]
        ],
        'CreateReturnRequest' => [
            'method' => 'POST',
            'resource' => 'return',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CreateReturnRequestRestResponse',
            'params' => [
                'fieldgroups' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'CreateReturnShippingLabel' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/initiate_shipping_label',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CreateReturnShippingLabelRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'DeleteReturnDraftFile' => [
            'method' => 'DELETE',
            'resource' => 'return/draft/{draftId}/file/{fileId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\DeleteReturnDraftFileRestResponse',
            'params' => [
                'draftId' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'fileId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'DeleteReturnFile' => [
            'method' => 'DELETE',
            'resource' => 'return/{returnId}/file/{fileId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\DeleteReturnFileRestResponse',
            'params' => [
                'fileId' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'EscalateReturn' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/escalate',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\EscalateReturnRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturn' => [
            'method' => 'GET',
            'resource' => 'return/{returnId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnRestResponse',
            'params' => [
                'fieldgroups' => [
                    'valid' => ['string']
                ],
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturnDraft' => [
            'method' => 'GET',
            'resource' => 'return/draft/{draftId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnDraftRestResponse',
            'params' => [
                'draftId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturnDraftFiles' => [
            'method' => 'GET',
            'resource' => 'return/draft/{draftId}/files',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnDraftFilesRestResponse',
            'params' => [
                'draftId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturnEstimate' => [
            'method' => 'POST',
            'resource' => 'return/estimate',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnEstimateRestResponse',
            'params' => [
            ]
        ],
        'GetReturnFiles' => [
            'method' => 'GET',
            'resource' => 'return/{returnId}/files',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnFilesRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturnMetadata' => [
            'method' => 'GET',
            'resource' => 'return/metadata/{metadataKey}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnMetadataRestResponse',
            'params' => [
                'metadataKey' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturnPreferences' => [
            'method' => 'GET',
            'resource' => 'return/preference',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnPreferencesRestResponse',
            'params' => [
            ]
        ],
        'GetReturnShippingLabel' => [
            'method' => 'GET',
            'resource' => 'return/{returnId}/get_shipping_label',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnShippingLabelRestResponse',
            'params' => [
                'return_id' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetShipmentTracking' => [
            'method' => 'GET',
            'resource' => 'return/{returnId}/tracking',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetShipmentTrackingRestResponse',
            'params' => [
                'carrier_used' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'tracking_number' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'IssueReturnRefund' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/issue_refund',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\IssueReturnRefundRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'MarkReturnReceived' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/mark_as_received',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\MarkReturnReceivedRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'MarkReturnRefundReceived' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/mark_refund_received',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\MarkReturnRefundReceivedRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'MarkReturnRefundSent' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/mark_refund_sent',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\MarkReturnRefundSentRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'MarkReturnShipped' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/mark_as_shipped',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\MarkReturnShippedRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'ProcessReturnRequest' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/decide',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\ProcessReturnRequestRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'SearchReturns' => [
            'method' => 'GET',
            'resource' => 'return/search',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SearchReturnsRestResponse',
            'params' => [
                'creation_date_range_from' => [
                    'valid' => ['string']
                ],
                'creation_date_range_to' => [
                    'valid' => ['string']
                ],
                'item_id' => [
                    'valid' => ['string']
                ],
                'limit' => [
                    'valid' => ['string']
                ],
                'offset' => [
                    'valid' => ['string']
                ],
                'return_state' => [
                    'valid' => ['string']
                ],
                'sort' => [
                    'valid' => ['string']
                ],
                'states' => [
                    'valid' => ['string']
                ],
                'transaction_id' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'SendReturnMessage' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/send_message',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SendReturnMessageRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'SendReturnShippingLabel' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/send_shipping_label',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SendReturnShippingLabelRestResponse',
            'params' => [
                'return_id' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'to_email_address' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'SetReturnPreferences' => [
            'method' => 'POST',
            'resource' => 'return/preference',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SetReturnPreferencesRestResponse',
            'params' => [
            ]
        ],
        'SubmitReturnFile' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/file/submit',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\SubmitReturnFileRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateReturnDraft' => [
            'method' => 'PUT',
            'resource' => 'return/draft/{draftId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\UpdateReturnDraftRestResponse',
            'params' => [
                'draftId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UpdateShipmentTracking' => [
            'method' => 'PUT',
            'resource' => 'return/{returnId}/update_tracking',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\UpdateShipmentTrackingRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UploadReturnDraftFile' => [
            'method' => 'POST',
            'resource' => 'return/draft/{draftId}/file/upload',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\UploadReturnDraftFileRestResponse',
            'params' => [
                'draftId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'UploadReturnFile' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/file/upload',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\UploadReturnFileRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'VoidShippingLabel' => [
            'method' => 'POST',
            'resource' => 'return/{returnId}/void_shipping_label',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\VoidShippingLabelRestResponse',
            'params' => [
                'returnId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'CreateCustomList' => [
            'method' => 'POST',
            'resource' => 'rules/custom_list',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CreateCustomListRestResponse',
            'params' => [
            ]
        ],
        'CreateReturnRules' => [
            'method' => 'POST',
            'resource' => 'rules',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\CreateReturnRulesRestResponse',
            'params' => [
            ]
        ],
        'GetCustomList' => [
            'method' => 'GET',
            'resource' => 'rules/custom_list_detail',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetCustomListRestResponse',
            'params' => [
            ]
        ],
        'GetCustomLists' => [
            'method' => 'GET',
            'resource' => 'rules/custom_list',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetCustomListsRestResponse',
            'params' => [
            ]
        ],
        'GetReturnRuleTemplates' => [
            'method' => 'GET',
            'resource' => 'rules/get_templates',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnRuleTemplatesRestResponse',
            'params' => [
            ]
        ],
        'GetStoreCategories' => [
            'method' => 'GET',
            'resource' => 'rules/get_store_category',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetStoreCategoriesRestResponse',
            'params' => [
            ]
        ],
        'GetReturnRule' => [
            'method' => 'GET',
            'resource' => 'rules/{ruleId}',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnRuleRestResponse',
            'params' => [
                'ruleId' => [
                    'valid' => ['string'],
                    'required' => true
                ]
            ]
        ],
        'GetReturnRuleHistory' => [
            'method' => 'GET',
            'resource' => 'rules/{ruleId}/get_trigger_history',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnRuleHistoryRestResponse',
            'params' => [
                'limit' => [
                    'valid' => ['string']
                ],
                'offset' => [
                    'valid' => ['string']
                ],
                'ruleId' => [
                    'valid' => ['string'],
                    'required' => true
                ],
                'trigger_date_range_from' => [
                    'valid' => ['string']
                ],
                'trigger_date_range_to' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'GetReturnRules' => [
            'method' => 'GET',
            'resource' => 'rules/disposition_rules_list',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\GetReturnRulesRestResponse',
            'params' => [
                'fieldgroups' => [
                    'valid' => ['string']
                ]
            ]
        ],
        'UpdateCustomList' => [
            'method' => 'PUT',
            'resource' => 'rules/custom_list',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\UpdateCustomListRestResponse',
            'params' => [
            ]
        ],
        'UpdateReturnRules' => [
            'method' => 'PUT',
            'resource' => 'rules',
            'responseClass' => '\DTS\eBaySDK\PostOrder\Types\UpdateReturnRulesRestResponse',
            'params' => [
            ]
        ]
    ];

    /**
     * @param array $config Configuration option values.
     */
    public function __construct(array $config = [])
    {
        parent::__construct($config);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ApproveCancellationRequestRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ApproveCancellationRequestRestResponse
     */
    public function approveCancellationRequest(\DTS\eBaySDK\PostOrder\Types\ApproveCancellationRequestRestRequest $request)
    {
        return $this->approveCancellationRequestAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ApproveCancellationRequestRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function approveCancellationRequestAsync(\DTS\eBaySDK\PostOrder\Types\ApproveCancellationRequestRestRequest $request)
    {
        return $this->callOperationAsync('ApproveCancellationRequest', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckCancellationEligibilityRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CheckCancellationEligibilityRestResponse
     */
    public function checkCancellationEligibility(\DTS\eBaySDK\PostOrder\Types\CheckCancellationEligibilityRestRequest $request)
    {
        return $this->checkCancellationEligibilityAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckCancellationEligibilityRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkCancellationEligibilityAsync(\DTS\eBaySDK\PostOrder\Types\CheckCancellationEligibilityRestRequest $request)
    {
        return $this->callOperationAsync('CheckCancellationEligibility', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ConfirmCancellationRefundRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ConfirmCancellationRefundRestResponse
     */
    public function confirmCancellationRefund(\DTS\eBaySDK\PostOrder\Types\ConfirmCancellationRefundRestRequest $request)
    {
        return $this->confirmCancellationRefundAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ConfirmCancellationRefundRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function confirmCancellationRefundAsync(\DTS\eBaySDK\PostOrder\Types\ConfirmCancellationRefundRestRequest $request)
    {
        return $this->callOperationAsync('ConfirmCancellationRefund', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetCancellationRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetCancellationRestResponse
     */
    public function getCancellation(\DTS\eBaySDK\PostOrder\Types\GetCancellationRestRequest $request)
    {
        return $this->getCancellationAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetCancellationRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCancellationAsync(\DTS\eBaySDK\PostOrder\Types\GetCancellationRestRequest $request)
    {
        return $this->callOperationAsync('GetCancellation', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\RejectCancellationRequestRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\RejectCancellationRequestRestResponse
     */
    public function rejectCancellationRequest(\DTS\eBaySDK\PostOrder\Types\RejectCancellationRequestRestRequest $request)
    {
        return $this->rejectCancellationRequestAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\RejectCancellationRequestRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function rejectCancellationRequestAsync(\DTS\eBaySDK\PostOrder\Types\RejectCancellationRequestRestRequest $request)
    {
        return $this->callOperationAsync('RejectCancellationRequest', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchCancellationsRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SearchCancellationsRestResponse
     */
    public function searchCancellations(\DTS\eBaySDK\PostOrder\Types\SearchCancellationsRestRequest $request)
    {
        return $this->searchCancellationsAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchCancellationsRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchCancellationsAsync(\DTS\eBaySDK\PostOrder\Types\SearchCancellationsRestRequest $request)
    {
        return $this->callOperationAsync('SearchCancellations', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SubmitCancellationRequestRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SubmitCancellationRequestRestResponse
     */
    public function submitCancellationRequest(\DTS\eBaySDK\PostOrder\Types\SubmitCancellationRequestRestRequest $request)
    {
        return $this->submitCancellationRequestAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SubmitCancellationRequestRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function submitCancellationRequestAsync(\DTS\eBaySDK\PostOrder\Types\SubmitCancellationRequestRestRequest $request)
    {
        return $this->callOperationAsync('SubmitCancellationRequest', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\AppealCaseDecisionRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\AppealCaseDecisionRestResponse
     */
    public function appealCaseDecision(\DTS\eBaySDK\PostOrder\Types\AppealCaseDecisionRestRequest $request)
    {
        return $this->appealCaseDecisionAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\AppealCaseDecisionRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function appealCaseDecisionAsync(\DTS\eBaySDK\PostOrder\Types\AppealCaseDecisionRestRequest $request)
    {
        return $this->callOperationAsync('AppealCaseDecision', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CloseCaseRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CloseCaseRestResponse
     */
    public function closeCase(\DTS\eBaySDK\PostOrder\Types\CloseCaseRestRequest $request)
    {
        return $this->closeCaseAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CloseCaseRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function closeCaseAsync(\DTS\eBaySDK\PostOrder\Types\CloseCaseRestRequest $request)
    {
        return $this->callOperationAsync('CloseCase', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetCaseRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetCaseRestResponse
     */
    public function getCase(\DTS\eBaySDK\PostOrder\Types\GetCaseRestRequest $request)
    {
        return $this->getCaseAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetCaseRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCaseAsync(\DTS\eBaySDK\PostOrder\Types\GetCaseRestRequest $request)
    {
        return $this->callOperationAsync('GetCase', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\IssueCaseRefundRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\IssueCaseRefundRestResponse
     */
    public function issueCaseRefund(\DTS\eBaySDK\PostOrder\Types\IssueCaseRefundRestRequest $request)
    {
        return $this->issueCaseRefundAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\IssueCaseRefundRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function issueCaseRefundAsync(\DTS\eBaySDK\PostOrder\Types\IssueCaseRefundRestRequest $request)
    {
        return $this->callOperationAsync('IssueCaseRefund', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvideReturnShipmentInfoRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ProvideReturnShipmentInfoRestResponse
     */
    public function provideReturnShipmentInfo(\DTS\eBaySDK\PostOrder\Types\ProvideReturnShipmentInfoRestRequest $request)
    {
        return $this->provideReturnShipmentInfoAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvideReturnShipmentInfoRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function provideReturnShipmentInfoAsync(\DTS\eBaySDK\PostOrder\Types\ProvideReturnShipmentInfoRestRequest $request)
    {
        return $this->callOperationAsync('ProvideReturnShipmentInfo', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvidesReturnAddressRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ProvidesReturnAddressRestResponse
     */
    public function providesReturnAddress(\DTS\eBaySDK\PostOrder\Types\ProvidesReturnAddressRestRequest $request)
    {
        return $this->providesReturnAddressAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvidesReturnAddressRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function providesReturnAddressAsync(\DTS\eBaySDK\PostOrder\Types\ProvidesReturnAddressRestRequest $request)
    {
        return $this->callOperationAsync('ProvidesReturnAddress', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchCasesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SearchCasesRestResponse
     */
    public function searchCases(\DTS\eBaySDK\PostOrder\Types\SearchCasesRestRequest $request)
    {
        return $this->searchCasesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchCasesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchCasesAsync(\DTS\eBaySDK\PostOrder\Types\SearchCasesRestRequest $request)
    {
        return $this->callOperationAsync('SearchCases', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckInquiryEligibilityRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CheckInquiryEligibilityRestResponse
     */
    public function checkInquiryEligibility(\DTS\eBaySDK\PostOrder\Types\CheckInquiryEligibilityRestRequest $request)
    {
        return $this->checkInquiryEligibilityAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckInquiryEligibilityRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkInquiryEligibilityAsync(\DTS\eBaySDK\PostOrder\Types\CheckInquiryEligibilityRestRequest $request)
    {
        return $this->callOperationAsync('CheckInquiryEligibility', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CloseInquiryRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CloseInquiryRestResponse
     */
    public function closeInquiry(\DTS\eBaySDK\PostOrder\Types\CloseInquiryRestRequest $request)
    {
        return $this->closeInquiryAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CloseInquiryRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function closeInquiryAsync(\DTS\eBaySDK\PostOrder\Types\CloseInquiryRestRequest $request)
    {
        return $this->callOperationAsync('CloseInquiry', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ConfirmInquiryRefundRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ConfirmInquiryRefundRestResponse
     */
    public function confirmInquiryRefund(\DTS\eBaySDK\PostOrder\Types\ConfirmInquiryRefundRestRequest $request)
    {
        return $this->confirmInquiryRefundAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ConfirmInquiryRefundRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function confirmInquiryRefundAsync(\DTS\eBaySDK\PostOrder\Types\ConfirmInquiryRefundRestRequest $request)
    {
        return $this->callOperationAsync('ConfirmInquiryRefund', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateInquiryRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CreateInquiryRestResponse
     */
    public function createInquiry(\DTS\eBaySDK\PostOrder\Types\CreateInquiryRestRequest $request)
    {
        return $this->createInquiryAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateInquiryRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInquiryAsync(\DTS\eBaySDK\PostOrder\Types\CreateInquiryRestRequest $request)
    {
        return $this->callOperationAsync('CreateInquiry', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\EscalateInquiryRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\EscalateInquiryRestResponse
     */
    public function escalateInquiry(\DTS\eBaySDK\PostOrder\Types\EscalateInquiryRestRequest $request)
    {
        return $this->escalateInquiryAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\EscalateInquiryRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function escalateInquiryAsync(\DTS\eBaySDK\PostOrder\Types\EscalateInquiryRestRequest $request)
    {
        return $this->callOperationAsync('EscalateInquiry', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetInquiryRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetInquiryRestResponse
     */
    public function getInquiry(\DTS\eBaySDK\PostOrder\Types\GetInquiryRestRequest $request)
    {
        return $this->getInquiryAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetInquiryRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInquiryAsync(\DTS\eBaySDK\PostOrder\Types\GetInquiryRestRequest $request)
    {
        return $this->callOperationAsync('GetInquiry', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\IssueInquiryRefundRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\IssueInquiryRefundRestResponse
     */
    public function issueInquiryRefund(\DTS\eBaySDK\PostOrder\Types\IssueInquiryRefundRestRequest $request)
    {
        return $this->issueInquiryRefundAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\IssueInquiryRefundRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function issueInquiryRefundAsync(\DTS\eBaySDK\PostOrder\Types\IssueInquiryRefundRestRequest $request)
    {
        return $this->callOperationAsync('IssueInquiryRefund', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvideInquiryRefundInfoRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ProvideInquiryRefundInfoRestResponse
     */
    public function provideInquiryRefundInfo(\DTS\eBaySDK\PostOrder\Types\ProvideInquiryRefundInfoRestRequest $request)
    {
        return $this->provideInquiryRefundInfoAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvideInquiryRefundInfoRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function provideInquiryRefundInfoAsync(\DTS\eBaySDK\PostOrder\Types\ProvideInquiryRefundInfoRestRequest $request)
    {
        return $this->callOperationAsync('ProvideInquiryRefundInfo', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvideInquiryShipmentInfoRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ProvideInquiryShipmentInfoRestResponse
     */
    public function provideInquiryShipmentInfo(\DTS\eBaySDK\PostOrder\Types\ProvideInquiryShipmentInfoRestRequest $request)
    {
        return $this->provideInquiryShipmentInfoAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProvideInquiryShipmentInfoRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function provideInquiryShipmentInfoAsync(\DTS\eBaySDK\PostOrder\Types\ProvideInquiryShipmentInfoRestRequest $request)
    {
        return $this->callOperationAsync('ProvideInquiryShipmentInfo', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchInquiriesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SearchInquiriesRestResponse
     */
    public function searchInquiries(\DTS\eBaySDK\PostOrder\Types\SearchInquiriesRestRequest $request)
    {
        return $this->searchInquiriesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchInquiriesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchInquiriesAsync(\DTS\eBaySDK\PostOrder\Types\SearchInquiriesRestRequest $request)
    {
        return $this->callOperationAsync('SearchInquiries', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SendInquiryMessageRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SendInquiryMessageRestResponse
     */
    public function sendInquiryMessage(\DTS\eBaySDK\PostOrder\Types\SendInquiryMessageRestRequest $request)
    {
        return $this->sendInquiryMessageAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SendInquiryMessageRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendInquiryMessageAsync(\DTS\eBaySDK\PostOrder\Types\SendInquiryMessageRestRequest $request)
    {
        return $this->callOperationAsync('SendInquiryMessage', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\AddShippingLabelInfoRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\AddShippingLabelInfoRestResponse
     */
    public function addShippingLabelInfo(\DTS\eBaySDK\PostOrder\Types\AddShippingLabelInfoRestRequest $request)
    {
        return $this->addShippingLabelInfoAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\AddShippingLabelInfoRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addShippingLabelInfoAsync(\DTS\eBaySDK\PostOrder\Types\AddShippingLabelInfoRestRequest $request)
    {
        return $this->callOperationAsync('AddShippingLabelInfo', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CancelReturnRequestRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CancelReturnRequestRestResponse
     */
    public function cancelReturnRequest(\DTS\eBaySDK\PostOrder\Types\CancelReturnRequestRestRequest $request)
    {
        return $this->cancelReturnRequestAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CancelReturnRequestRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelReturnRequestAsync(\DTS\eBaySDK\PostOrder\Types\CancelReturnRequestRestRequest $request)
    {
        return $this->callOperationAsync('CancelReturnRequest', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckReturnEligibilityRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CheckReturnEligibilityRestResponse
     */
    public function checkReturnEligibility(\DTS\eBaySDK\PostOrder\Types\CheckReturnEligibilityRestRequest $request)
    {
        return $this->checkReturnEligibilityAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckReturnEligibilityRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkReturnEligibilityAsync(\DTS\eBaySDK\PostOrder\Types\CheckReturnEligibilityRestRequest $request)
    {
        return $this->callOperationAsync('CheckReturnEligibility', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckShippingLabelEligibilityRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CheckShippingLabelEligibilityRestResponse
     */
    public function checkShippingLabelEligibility(\DTS\eBaySDK\PostOrder\Types\CheckShippingLabelEligibilityRestRequest $request)
    {
        return $this->checkShippingLabelEligibilityAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CheckShippingLabelEligibilityRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkShippingLabelEligibilityAsync(\DTS\eBaySDK\PostOrder\Types\CheckShippingLabelEligibilityRestRequest $request)
    {
        return $this->callOperationAsync('CheckShippingLabelEligibility', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnDraftRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CreateReturnDraftRestResponse
     */
    public function createReturnDraft(\DTS\eBaySDK\PostOrder\Types\CreateReturnDraftRestRequest $request)
    {
        return $this->createReturnDraftAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnDraftRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnDraftAsync(\DTS\eBaySDK\PostOrder\Types\CreateReturnDraftRestRequest $request)
    {
        return $this->callOperationAsync('CreateReturnDraft', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnRequestRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CreateReturnRequestRestResponse
     */
    public function createReturnRequest(\DTS\eBaySDK\PostOrder\Types\CreateReturnRequestRestRequest $request)
    {
        return $this->createReturnRequestAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnRequestRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnRequestAsync(\DTS\eBaySDK\PostOrder\Types\CreateReturnRequestRestRequest $request)
    {
        return $this->callOperationAsync('CreateReturnRequest', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnShippingLabelRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CreateReturnShippingLabelRestResponse
     */
    public function createReturnShippingLabel(\DTS\eBaySDK\PostOrder\Types\CreateReturnShippingLabelRestRequest $request)
    {
        return $this->createReturnShippingLabelAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnShippingLabelRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnShippingLabelAsync(\DTS\eBaySDK\PostOrder\Types\CreateReturnShippingLabelRestRequest $request)
    {
        return $this->callOperationAsync('CreateReturnShippingLabel', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\DeleteReturnDraftFileRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\DeleteReturnDraftFileRestResponse
     */
    public function deleteReturnDraftFile(\DTS\eBaySDK\PostOrder\Types\DeleteReturnDraftFileRestRequest $request)
    {
        return $this->deleteReturnDraftFileAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\DeleteReturnDraftFileRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteReturnDraftFileAsync(\DTS\eBaySDK\PostOrder\Types\DeleteReturnDraftFileRestRequest $request)
    {
        return $this->callOperationAsync('DeleteReturnDraftFile', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\DeleteReturnFileRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\DeleteReturnFileRestResponse
     */
    public function deleteReturnFile(\DTS\eBaySDK\PostOrder\Types\DeleteReturnFileRestRequest $request)
    {
        return $this->deleteReturnFileAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\DeleteReturnFileRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteReturnFileAsync(\DTS\eBaySDK\PostOrder\Types\DeleteReturnFileRestRequest $request)
    {
        return $this->callOperationAsync('DeleteReturnFile', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\EscalateReturnRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\EscalateReturnRestResponse
     */
    public function escalateReturn(\DTS\eBaySDK\PostOrder\Types\EscalateReturnRestRequest $request)
    {
        return $this->escalateReturnAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\EscalateReturnRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function escalateReturnAsync(\DTS\eBaySDK\PostOrder\Types\EscalateReturnRestRequest $request)
    {
        return $this->callOperationAsync('EscalateReturn', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnRestResponse
     */
    public function getReturn(\DTS\eBaySDK\PostOrder\Types\GetReturnRestRequest $request)
    {
        return $this->getReturnAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnRestRequest $request)
    {
        return $this->callOperationAsync('GetReturn', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnDraftRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnDraftRestResponse
     */
    public function getReturnDraft(\DTS\eBaySDK\PostOrder\Types\GetReturnDraftRestRequest $request)
    {
        return $this->getReturnDraftAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnDraftRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnDraftAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnDraftRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnDraft', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnDraftFilesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnDraftFilesRestResponse
     */
    public function getReturnDraftFiles(\DTS\eBaySDK\PostOrder\Types\GetReturnDraftFilesRestRequest $request)
    {
        return $this->getReturnDraftFilesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnDraftFilesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnDraftFilesAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnDraftFilesRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnDraftFiles', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnEstimateRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnEstimateRestResponse
     */
    public function getReturnEstimate(\DTS\eBaySDK\PostOrder\Types\GetReturnEstimateRestRequest $request)
    {
        return $this->getReturnEstimateAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnEstimateRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnEstimateAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnEstimateRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnEstimate', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnFilesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnFilesRestResponse
     */
    public function getReturnFiles(\DTS\eBaySDK\PostOrder\Types\GetReturnFilesRestRequest $request)
    {
        return $this->getReturnFilesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnFilesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnFilesAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnFilesRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnFiles', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnMetadataRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnMetadataRestResponse
     */
    public function getReturnMetadata(\DTS\eBaySDK\PostOrder\Types\GetReturnMetadataRestRequest $request)
    {
        return $this->getReturnMetadataAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnMetadataRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnMetadataAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnMetadataRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnMetadata', $request);
    }

    /**
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnPreferencesRestResponse
     */
    public function getReturnPreferences()
    {
        return $this->getReturnPreferencesAsync()->wait();
    }

    /**
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnPreferencesAsync()
    {
        return $this->callOperationAsync('GetReturnPreferences');
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnShippingLabelRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnShippingLabelRestResponse
     */
    public function getReturnShippingLabel(\DTS\eBaySDK\PostOrder\Types\GetReturnShippingLabelRestRequest $request)
    {
        return $this->getReturnShippingLabelAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnShippingLabelRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnShippingLabelAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnShippingLabelRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnShippingLabel', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetShipmentTrackingRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetShipmentTrackingRestResponse
     */
    public function getShipmentTracking(\DTS\eBaySDK\PostOrder\Types\GetShipmentTrackingRestRequest $request)
    {
        return $this->getShipmentTrackingAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetShipmentTrackingRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getShipmentTrackingAsync(\DTS\eBaySDK\PostOrder\Types\GetShipmentTrackingRestRequest $request)
    {
        return $this->callOperationAsync('GetShipmentTracking', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\IssueReturnRefundRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\IssueReturnRefundRestResponse
     */
    public function issueReturnRefund(\DTS\eBaySDK\PostOrder\Types\IssueReturnRefundRestRequest $request)
    {
        return $this->issueReturnRefundAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\IssueReturnRefundRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function issueReturnRefundAsync(\DTS\eBaySDK\PostOrder\Types\IssueReturnRefundRestRequest $request)
    {
        return $this->callOperationAsync('IssueReturnRefund', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnReceivedRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\MarkReturnReceivedRestResponse
     */
    public function markReturnReceived(\DTS\eBaySDK\PostOrder\Types\MarkReturnReceivedRestRequest $request)
    {
        return $this->markReturnReceivedAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnReceivedRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markReturnReceivedAsync(\DTS\eBaySDK\PostOrder\Types\MarkReturnReceivedRestRequest $request)
    {
        return $this->callOperationAsync('MarkReturnReceived', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnRefundReceivedRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\MarkReturnRefundReceivedRestResponse
     */
    public function markReturnRefundReceived(\DTS\eBaySDK\PostOrder\Types\MarkReturnRefundReceivedRestRequest $request)
    {
        return $this->markReturnRefundReceivedAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnRefundReceivedRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markReturnRefundReceivedAsync(\DTS\eBaySDK\PostOrder\Types\MarkReturnRefundReceivedRestRequest $request)
    {
        return $this->callOperationAsync('MarkReturnRefundReceived', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnRefundSentRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\MarkReturnRefundSentRestResponse
     */
    public function markReturnRefundSent(\DTS\eBaySDK\PostOrder\Types\MarkReturnRefundSentRestRequest $request)
    {
        return $this->markReturnRefundSentAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnRefundSentRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markReturnRefundSentAsync(\DTS\eBaySDK\PostOrder\Types\MarkReturnRefundSentRestRequest $request)
    {
        return $this->callOperationAsync('MarkReturnRefundSent', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnShippedRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\MarkReturnShippedRestResponse
     */
    public function markReturnShipped(\DTS\eBaySDK\PostOrder\Types\MarkReturnShippedRestRequest $request)
    {
        return $this->markReturnShippedAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\MarkReturnShippedRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function markReturnShippedAsync(\DTS\eBaySDK\PostOrder\Types\MarkReturnShippedRestRequest $request)
    {
        return $this->callOperationAsync('MarkReturnShipped', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProcessReturnRequestRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\ProcessReturnRequestRestResponse
     */
    public function processReturnRequest(\DTS\eBaySDK\PostOrder\Types\ProcessReturnRequestRestRequest $request)
    {
        return $this->processReturnRequestAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\ProcessReturnRequestRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function processReturnRequestAsync(\DTS\eBaySDK\PostOrder\Types\ProcessReturnRequestRestRequest $request)
    {
        return $this->callOperationAsync('ProcessReturnRequest', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchReturnsRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SearchReturnsRestResponse
     */
    public function searchReturns(\DTS\eBaySDK\PostOrder\Types\SearchReturnsRestRequest $request)
    {
        return $this->searchReturnsAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SearchReturnsRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchReturnsAsync(\DTS\eBaySDK\PostOrder\Types\SearchReturnsRestRequest $request)
    {
        return $this->callOperationAsync('SearchReturns', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SendReturnMessageRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SendReturnMessageRestResponse
     */
    public function sendReturnMessage(\DTS\eBaySDK\PostOrder\Types\SendReturnMessageRestRequest $request)
    {
        return $this->sendReturnMessageAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SendReturnMessageRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendReturnMessageAsync(\DTS\eBaySDK\PostOrder\Types\SendReturnMessageRestRequest $request)
    {
        return $this->callOperationAsync('SendReturnMessage', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SendReturnShippingLabelRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SendReturnShippingLabelRestResponse
     */
    public function sendReturnShippingLabel(\DTS\eBaySDK\PostOrder\Types\SendReturnShippingLabelRestRequest $request)
    {
        return $this->sendReturnShippingLabelAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SendReturnShippingLabelRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendReturnShippingLabelAsync(\DTS\eBaySDK\PostOrder\Types\SendReturnShippingLabelRestRequest $request)
    {
        return $this->callOperationAsync('SendReturnShippingLabel', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SetReturnPreferencesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SetReturnPreferencesRestResponse
     */
    public function setReturnPreferences(\DTS\eBaySDK\PostOrder\Types\SetReturnPreferencesRestRequest $request)
    {
        return $this->setReturnPreferencesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SetReturnPreferencesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setReturnPreferencesAsync(\DTS\eBaySDK\PostOrder\Types\SetReturnPreferencesRestRequest $request)
    {
        return $this->callOperationAsync('SetReturnPreferences', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SubmitReturnFileRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\SubmitReturnFileRestResponse
     */
    public function submitReturnFile(\DTS\eBaySDK\PostOrder\Types\SubmitReturnFileRestRequest $request)
    {
        return $this->submitReturnFileAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\SubmitReturnFileRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function submitReturnFileAsync(\DTS\eBaySDK\PostOrder\Types\SubmitReturnFileRestRequest $request)
    {
        return $this->callOperationAsync('SubmitReturnFile', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateReturnDraftRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\UpdateReturnDraftRestResponse
     */
    public function updateReturnDraft(\DTS\eBaySDK\PostOrder\Types\UpdateReturnDraftRestRequest $request)
    {
        return $this->updateReturnDraftAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateReturnDraftRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateReturnDraftAsync(\DTS\eBaySDK\PostOrder\Types\UpdateReturnDraftRestRequest $request)
    {
        return $this->callOperationAsync('UpdateReturnDraft', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateShipmentTrackingRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\UpdateShipmentTrackingRestResponse
     */
    public function updateShipmentTracking(\DTS\eBaySDK\PostOrder\Types\UpdateShipmentTrackingRestRequest $request)
    {
        return $this->updateShipmentTrackingAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateShipmentTrackingRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateShipmentTrackingAsync(\DTS\eBaySDK\PostOrder\Types\UpdateShipmentTrackingRestRequest $request)
    {
        return $this->callOperationAsync('UpdateShipmentTracking', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UploadReturnDraftFileRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\UploadReturnDraftFileRestResponse
     */
    public function uploadReturnDraftFile(\DTS\eBaySDK\PostOrder\Types\UploadReturnDraftFileRestRequest $request)
    {
        return $this->uploadReturnDraftFileAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UploadReturnDraftFileRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadReturnDraftFileAsync(\DTS\eBaySDK\PostOrder\Types\UploadReturnDraftFileRestRequest $request)
    {
        return $this->callOperationAsync('UploadReturnDraftFile', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UploadReturnFileRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\UploadReturnFileRestResponse
     */
    public function uploadReturnFile(\DTS\eBaySDK\PostOrder\Types\UploadReturnFileRestRequest $request)
    {
        return $this->uploadReturnFileAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UploadReturnFileRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function uploadReturnFileAsync(\DTS\eBaySDK\PostOrder\Types\UploadReturnFileRestRequest $request)
    {
        return $this->callOperationAsync('UploadReturnFile', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\VoidShippingLabelRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\VoidShippingLabelRestResponse
     */
    public function voidShippingLabel(\DTS\eBaySDK\PostOrder\Types\VoidShippingLabelRestRequest $request)
    {
        return $this->voidShippingLabelAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\VoidShippingLabelRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function voidShippingLabelAsync(\DTS\eBaySDK\PostOrder\Types\VoidShippingLabelRestRequest $request)
    {
        return $this->callOperationAsync('VoidShippingLabel', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateCustomListRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CreateCustomListRestResponse
     */
    public function createCustomList(\DTS\eBaySDK\PostOrder\Types\CreateCustomListRestRequest $request)
    {
        return $this->createCustomListAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateCustomListRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCustomListAsync(\DTS\eBaySDK\PostOrder\Types\CreateCustomListRestRequest $request)
    {
        return $this->callOperationAsync('CreateCustomList', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnRulesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\CreateReturnRulesRestResponse
     */
    public function createReturnRules(\DTS\eBaySDK\PostOrder\Types\CreateReturnRulesRestRequest $request)
    {
        return $this->createReturnRulesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\CreateReturnRulesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnRulesAsync(\DTS\eBaySDK\PostOrder\Types\CreateReturnRulesRestRequest $request)
    {
        return $this->callOperationAsync('CreateReturnRules', $request);
    }

    /**
     * @return \DTS\eBaySDK\PostOrder\Types\GetCustomListRestResponse
     */
    public function getCustomList()
    {
        return $this->getCustomListAsync()->wait();
    }

    /**
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomListAsync()
    {
        return $this->callOperationAsync('GetCustomList');
    }

    /**
     * @return \DTS\eBaySDK\PostOrder\Types\GetCustomListsRestResponse
     */
    public function getCustomLists()
    {
        return $this->getCustomListsAsync()->wait();
    }

    /**
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCustomListsAsync()
    {
        return $this->callOperationAsync('GetCustomLists');
    }

    /**
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnRuleTemplatesRestResponse
     */
    public function getReturnRuleTemplates()
    {
        return $this->getReturnRuleTemplatesAsync()->wait();
    }

    /**
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnRuleTemplatesAsync()
    {
        return $this->callOperationAsync('GetReturnRuleTemplates');
    }

    /**
     * @return \DTS\eBaySDK\PostOrder\Types\GetStoreCategoriesRestResponse
     */
    public function getStoreCategories()
    {
        return $this->getStoreCategoriesAsync()->wait();
    }

    /**
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStoreCategoriesAsync()
    {
        return $this->callOperationAsync('GetStoreCategories');
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRuleRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnRuleRestResponse
     */
    public function getReturnRule(\DTS\eBaySDK\PostOrder\Types\GetReturnRuleRestRequest $request)
    {
        return $this->getReturnRuleAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRuleRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnRuleAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnRuleRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnRule', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRuleHistoryRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnRuleHistoryRestResponse
     */
    public function getReturnRuleHistory(\DTS\eBaySDK\PostOrder\Types\GetReturnRuleHistoryRestRequest $request)
    {
        return $this->getReturnRuleHistoryAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRuleHistoryRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnRuleHistoryAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnRuleHistoryRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnRuleHistory', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRulesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\GetReturnRulesRestResponse
     */
    public function getReturnRules(\DTS\eBaySDK\PostOrder\Types\GetReturnRulesRestRequest $request)
    {
        return $this->getReturnRulesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\GetReturnRulesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnRulesAsync(\DTS\eBaySDK\PostOrder\Types\GetReturnRulesRestRequest $request)
    {
        return $this->callOperationAsync('GetReturnRules', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateCustomListRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\UpdateCustomListRestResponse
     */
    public function updateCustomList(\DTS\eBaySDK\PostOrder\Types\UpdateCustomListRestRequest $request)
    {
        return $this->updateCustomListAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateCustomListRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCustomListAsync(\DTS\eBaySDK\PostOrder\Types\UpdateCustomListRestRequest $request)
    {
        return $this->callOperationAsync('UpdateCustomList', $request);
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateReturnRulesRestRequest $request
     * @return \DTS\eBaySDK\PostOrder\Types\UpdateReturnRulesRestResponse
     */
    public function updateReturnRules(\DTS\eBaySDK\PostOrder\Types\UpdateReturnRulesRestRequest $request)
    {
        return $this->updateReturnRulesAsync($request)->wait();
    }

    /**
     * @param \DTS\eBaySDK\PostOrder\Types\UpdateReturnRulesRestRequest $request
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateReturnRulesAsync(\DTS\eBaySDK\PostOrder\Types\UpdateReturnRulesRestRequest $request)
    {
        return $this->callOperationAsync('UpdateReturnRules', $request);
    }
}
