<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/
require_once(DIR_FS_INC.'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC.'xtc_get_tax_description.inc.php');
class distributor_order {
    var $info, $totals, $products, $distributor;

    function __construct($distributor_order_id) {
      $this->info = array();
      $this->totals = array();
      $this->products = array();
      $this->products_collected = array();
      $this->distributor = array();
      $this->delivery = array();
      $this->query($distributor_order_id);	
    }

    private function query($distributor_order_id) {
		$distributor_order_query = xtc_db_query(sprintf(
			"select * from distributor_orders o where distributor_orders_id = '%d'",
			xtc_db_input($distributor_order_id)
		));
		if(!xtc_db_num_rows($distributor_order_query)){
			return false;
		}
		$distributor_order = xtc_db_fetch_array($distributor_order_query);
		$distributor_allow_tax_query = xtc_db_query(sprintf(
			"SELECT * FROM distributors WHERE id=%d",
			$distributor_order['distributor_id']
		));
		$distributor_allow_tax = xtc_db_fetch_array($distributor_allow_tax_query);
		$allow_tax = $distributor_allow_tax['tax_orders'];
		
		$this->info = array(
			'currency' => $distributor_order['currency'],
			'currency_value' => $distributor_order['currency_value'],
			'comments' => $distributor_order['comments'],
			'language' => $distributor_order['language'],
			'date_saved' => $distributor_order['date_created'],
			'orders_status' => $distributor_order['orders_status'],
			'id' => $distributor_order['distributor_orders_id'],
			'last_modified' => $distributor_order['last_modified'],
			'date_receipt'=>$distributor_order['date_receipt'],
			'estimated_date_receipt'=>$distributor_order['estimated_date_receipt'],
			'date_payment' => $distributor_order['date_payment'],
			'distributor_id' => $distributor_order['distributor_id'],
			'allow_tax'=>$allow_tax,
			'comments_visible'=>$distributor_order['comments_visible'],
		    'payment_terms'=>$distributor_order['payment_terms']
		);

		
		$totals_query = xtc_db_query("select * from distributor_orders_total where orders_id = '" . xtc_db_input($distributor_order_id) . "' order by sort_order");
		while ($totals = xtc_db_fetch_array($totals_query)) {
			$this->totals[] = array('title' => $totals['title'],
				'text' => $totals['text'],
				'value' => $totals['value'],
				'id' => $totals['orders_id'],
				'otid' => $totals['orders_total_id'],
				'class' => $totals['class']
			);
		}

		$this->distributor = array('name' => $distributor_order['distributor_name'],
			'ID' => $distributor_order['distributor_id'],
			'street_address' => $distributor_order['distributor_street_address'],
                    'company'=>$distributor_order['distributor_company'],
			'city' => $distributor_order['distributor_city'],
                        'suburb'=>$distributor_order['distributor_suburb'],
			'postcode' => $distributor_order['distributor_postcode'],
			'telephone' => $distributor_order['distributor_telephone'],
			'country' => $distributor_order['distributor_country'],
			'email_address' => $distributor_order['distributor_email_address'],
			'allow_tax'=>$allow_tax
		);

		$this->delivery = array('name' => $distributor_order['delivery_name'],
			'street_address' => $distributor_order['delivery_street_address'],
			'suburb' => $distributor_order['delivery_suburb'],
			'city' => $distributor_order['delivery_city'],
			'postcode' => $distributor_order['delivery_postcode'],
			'country' => $distributor_order['delivery_country'],
			'company' => $distributor_order['delivery_company'],
			'telephone' => $distributor_order['delivery_telephone'],
		);

		$index = 0;
		$distributor_orders_products_query = xtc_db_query(sprintf(
			"select * from distributor_orders_products where distributor_orders_id ='%s' ORDER BY stuecklistenartikel DESC,date_added DESC",
			xtc_db_input($distributor_order_id)
		));

		while ($distributor_orders_products = xtc_db_fetch_array($distributor_orders_products_query)) {

			$netto = xtc_oe_get_price_o_tax($distributor_orders_products['products_price'],$distributor_orders_products['products_tax'],$check=false);
			$this->products[$index] = array(
				'qty' => $distributor_orders_products['products_quantity'],
				'name' => xtc_db_prepare_input($distributor_orders_products['products_name']),
				'link'=>xtc_href_link('categories.php','pID='.$distributor_orders_products['products_id'].'&cPath='.xtc_get_product_path($distributor_orders_products['products_id']).'&action=new_product'),
				'dopID'=>$distributor_orders_products['distributor_orders_products_id'],
				'id' => $distributor_orders_products['products_id'],
				'model' => $distributor_orders_products['products_model'],
				'tax' => $distributor_orders_products['products_tax'],
				'stuecklistenartikel' => $distributor_orders_products['stuecklistenartikel'],
				'stuecklisten_id' => $distributor_orders_products['stuecklisten_id'],
				'collie_qty' => $distributor_orders_products['collie_qty'],
				'price' => $distributor_orders_products['products_price'],
				'price_netto' => $netto,
				'discount' => $distributor_orders_products['products_discount_made'],
				'qty_rueckbuch' => $distributor_orders_products['qty_rueckbuch'],
				'rueckbuch_invoice_qty'=>$this->get_rueckbuch_invoice_qty($distributor_orders_products['products_id']),
				'final_price' => $distributor_orders_products['final_price'],
				'allow_tax' => $distributor_orders_products['allow_tax'],
				'date_added' => $distributor_orders_products['date_added'],
				'properties'=>$this->get_properties($distributor_orders_products['distributor_orders_products_id'])
			);
			if( $distributor_orders_products['stuecklisten_id']>0 ){
				if(!isset($this->products_collected['stk'][$distributor_orders_products['stuecklisten_id']][$distributor_orders_products['products_id']]))
						$this->products_collected['stk'][$distributor_orders_products['stuecklisten_id']][$distributor_orders_products['products_id']] = 0;
				$this->products_collected['stk'][$distributor_orders_products['stuecklisten_id']][$distributor_orders_products['products_id']] += $distributor_orders_products['products_quantity'] / $distributor_orders_products['collie_qty'];
			}else{
				if(!isset($this->products_collected['default'][$distributor_orders_products['products_id']]))
						$this->products_collected['default'][$distributor_orders_products['products_id']] = 0;
				$this->products_collected['default'][$distributor_orders_products['products_id']] += $distributor_orders_products['products_quantity'];
			}
			$index++;
		}// end while
    } // end function
	/**
	 * Liefert ein Array aller Rechnungen zum Lieferanten
	 * [ type=>id ]
	 *
	 * @return array
	 */
	public function get_invoices(){
		$invoices_array = array();
		$invoices_query = xtc_db_query("SELECT distributor_invoices_id,invoice_type FROM distributor_invoices WHERE distributor_orders_id='".$this->info['id']."'");
		while($invoices = xtc_db_fetch_array($invoices_query)){
			$invoices_array[ $invoices['invoice_type'] ] = $invoices['distributor_invoices_id'];
		}
		return $invoices_array;
	}
	/**
	 * Prueft ob eine teilzahlungsrechnung aus einer lb generiert werden darf
	 * @return boolean
	 */
	public function allow_invoice(){
		if(sizeOf($this->products)==0){
			return false;
		}
		// nur wenn keine anderen rechnungen vorhanden
		if(sizeOf($this->get_invoices())>0){
			return false;
		}
		$total = 0;
		for($i=0;$i<sizeOf($this->totals);$i++){
			if($this->totals[$i]['class'] == 'ot_total'){
				$total = $this->totals[$i]['value'];
			}
		}
		if($total == 0){
			return false;
		}
		return true;
	}

	/**
	 * Prueft ob eine wareneingangs-rechnung aus einer lb generiert werden darf
	 * @return boolean
	 */
	public function allow_invoice_we(){
		if(sizeOf($this->products)==0){
			return false;
		}else{
			// es muss bereits ein wareneingang vorhanden sein
			$rueckbuch_count = 0;
			for($i=0;$i<sizeOf($this->products);$i++){
				if($this->products[$i]['qty_rueckbuch'] > 0){
					$rueckbuch_count += $this->products[$i]['qty_rueckbuch'];
				}
			}
			if($rueckbuch_count == 0)
				return false;
		}
		// nur wenn noch keine teilzahlungsrechng
		if(sizeOf($this->get_invoices())>0){
			foreach($this->get_invoices() as $type=>$diID){
				if($type == 'installment'){
					return false;
				}
			}
		}
		$total = 0;
		for($i=0;$i<sizeOf($this->totals);$i++){
			if($this->totals[$i]['class'] == 'ot_total'){
				$total = $this->totals[$i]['value'];
			}
		}
		if($total == 0){
			return false;
		}
		return true;
	}

	/**
	 * AKTUALISIERT DEN STATUS EINER Lieferantenbestellung UND FUEGT
	 * EINEN HISTORIENEINTRAG HINZU
	 * BEIM STORNO AUSSERDEM NOCH HISTORIENEINTRAG ZU DEN ARTIKELN
	 * @param int $status
	 * @param string $msg
	 * @param int $usr
	 */
	public function update_status($status,&$msg,$usr=0){
		xtc_db_query("UPDATE distributor_orders SET orders_status='".$status."' where distributor_orders_id = '" . $this->info['id'] . "'");
		switch($status){
			case DISTRIBUTOR_ORDERS_STATUS_BESTELLT:
				$msg = 'Die Lieferantenbestellung wurde auf den Status Bestellt gesetzt. '.$msg;
				break;
			case DISTRIBUTOR_ORDERS_STATUS_STORNIERT:
				$msg = 'Die Lieferantenbestellung wurde storniert. '.$msg;
				$products_query = yes_db_query(sprintf(
					"SELECT products_id FROM distributor_orders_products WHERE distributor_orders_id='%s'",
					$this->info['id']
				));
				if(yes_db_num_rows($products_query)){
					foreach($products_query as $record){
						$insert_sql_array = array(
							'products_id'=>$record['products_id'],
							'comments'=>$msg . ' (Lieferanten-Bestellnr.: '.$this->info['id'].')',
							'editor_id'=>$_SESSION['customer_id'],
							'date_saved'=>'now()'
						);
						xtc_db_perform('products_history',$insert_sql_array);
					}
					xtc_db_query("DELETE FROM distributor_orders_products WHERE distributor_orders_id='".$this->info['id']."'");
				}
				break;
			case DISTRIBUTOR_ORDERS_STATUS_OFFEN:
				$msg = 'Die Lieferantenbestellung wurde auf den Status Offen gesetzt. '.$msg;
				break;
			case DISTRIBUTOR_ORDERS_STATUS_EINGETROFFEN:
				$msg = 'Die Lieferantenbestellung wurde auf den Status Eingetroffen gesetzt. '.$msg;
				break;
		}
		$this->insert_history($status,$customer_notified='0',$msg,$usr);
	}

	/**
	 * ERZEUGT EINE LIEFERANTENRECHNUNG
	 *
	 * @param int $type
	 * @param string $msg
	 * @param int $usr
	 * @param array $products_array
	 */
	public function generate_invoice($type,&$msg,$usr,$products_array=array()){
		$sql_data_array = array('distributor_id' => $this->distributor['ID'],
			'distributor_orders_id'=>$this->info['id'],
			'distributor_name' =>$this->distributor['name'],
			'distributor_street_address' =>$this->distributor['street_address'],
			'distributor_city' =>$this->distributor['city'],
			'distributor_postcode' =>$this->distributor['postcode'],
			'distributor_telephone' =>$this->distributor['telephone'],
			'distributor_country' =>$this->distributor['country'],
			'distributor_email_address' => $this->distributor['email_address'],
			'last_modified' => 'now()',
			'from_date'=>'now()',
			'currency'=>DEFAULT_CURRENCY,
			'date_created' => 'now()',
			'invoice_type'=>$type,  
			'status' => '1'
		);
		xtc_db_perform('distributor_invoices', $sql_data_array);
		$orders_id = xtc_db_insert_id();
		$sum = 0;
		$total_sum = 0;
		$shippingcosts = 0;
		if($type == 'installment'){
			for($i=0;$i<sizeOf($this->products);$i++){
				$insert_sql_array = array('distributor_invoices_id'=>$orders_id,
					'products_id'=>$this->products[$i]['id'],
					'products_model'=>$this->products[$i]['model'],
					'products_name'=>$this->products[$i]['name'],
					'products_price'=>$this->products[$i]['price'],
					'products_discount_made'=>$this->products[$i]['discount'],
					'final_price'=>$this->products[$i]['final_price'],
					'products_tax'=>$this->products[$i]['tax'],
					'products_quantity'=>$this->products[$i]['qty'],
					'allow_tax'=>$this->info['allow_tax'],
					'stuecklisten_id'=>$this->products[$i]['stuecklisten_id'],
					'collie_qty'=>$this->products[$i]['collie_qty'],
					'stuecklistenartikel'=>$this->products[$i]['stuecklistenartikel'],
					'date_added'=>'now()'
				);
				$sum += $this->products[$i]['price']*$this->products[$i]['qty'];
				xtc_db_perform('distributor_invoices_products',$insert_sql_array);
				$dipID = xtc_db_insert_id();
				if(sizeOf($this->products[$i]['properties'])){
					foreach($this->products[$i]['properties'] as $property){
						$insert_sql_array = array(
							'distributor_invoices_products_id'=>$dipID,
							'property_title'=>$property['property_title'],
							'property_value'=>$property['property_value']
						);
						xtc_db_perform('distributor_invoices_products_properties',$insert_sql_array);
					}
				}
			}
			$total_sum = $sum;

			// VERSANDKOSTEN ADDEN
			for($i=0;$i<sizeOf($this->totals);$i++){
				if($this->totals[$i]['class'] == 'ot_shipping'){
					$shippingcosts = $this->totals[$i]['value'];
				}
			}
			$total_sum += $shippingcosts;
			
		}else{
			for($i=0;$i<sizeOf($this->products);$i++){
				if($this->products[$i]['stuecklisten_id'] == 0){
					if($products_array[ $this->products[$i]['id'] ] ){
						$insert_sql_array = array('distributor_invoices_id'=>$orders_id,
							'products_id'=>$this->products[$i]['id'],
							'products_model'=>$this->products[$i]['model'],
							'products_name'=>$this->products[$i]['name'],
							'products_price'=>$this->products[$i]['price'],
							'products_discount_made'=>$this->products[$i]['discount'],
							'final_price'=>($products_array[ $this->products[$i]['id'] ] * $this->products[$i]['price']),
							'products_tax'=>$this->products[$i]['tax'],
							'products_quantity'=>$products_array[ $this->products[$i]['id'] ],
							'allow_tax'=>$this->info['allow_tax'],							'stuecklisten_id'=>$this->products[$i]['stuecklisten_id'],
							'collie_qty'=>$this->products[$i]['collie_qty'],
							'stuecklistenartikel'=>$this->products[$i]['stuecklistenartikel'],
							'date_added'=>'now()'
						);
						$sum += $this->products[$i]['price']*$products_array[ $this->products[$i]['id'] ];
						xtc_db_perform('distributor_invoices_products',$insert_sql_array);
						$dipID = xtc_db_insert_id();
						if(sizeOf($this->products[$i]['properties'])){
							foreach($this->products[$i]['properties'] as $property){
								$insert_sql_array = array(
									'distributor_invoices_products_id'=>$dipID,
									'property_title'=>$property['property_title'],
									'property_value'=>$property['property_value']
								);
								xtc_db_perform('distributor_invoices_products_properties',$insert_sql_array);
							}
						}
					}
				}
			}
		}
	
		$sql_data_array = array('distributor_invoices_id' => $orders_id,
			'title' => '<b>Summe</b>:',
			'text' => number_format($total_sum,2,',','.').' '.$this->info['currency'],
			'value' => $total_sum,
			'sort_order' => MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER,
			'class' => 'ot_total');
		xtc_db_perform('distributor_invoices_total', $sql_data_array);

		if($shippingcosts > 0){
			$sql_data_array = array('distributor_invoices_id' => $orders_id,
				'title' => 'Frachtkosten:',
				'text' => number_format($shippingcosts,2,',','.').' '.$this->info['currency'],
				'value' => $shippingcosts,
				'sort_order' => MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER,
				'class' => 'ot_shipping');
			xtc_db_perform('distributor_invoices_total', $sql_data_array);
		}
	
		$sql_data_array = array('distributor_invoices_id' => $orders_id,
			'title' => '<b>Zwischensumme</b>:',
			'text' => number_format($sum,2,',','.').' '.$this->info['currency'],
			'value' => $sum,
			'sort_order' => MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER,
			'class' => 'ot_subtotal');
	
		xtc_db_perform('distributor_invoices_total', $sql_data_array);
		
		$insert_sql_array = array('distributor_invoices_id'=>$orders_id,
			'distributor_invoices_status_id'=>'1',
			'date_added'=>'now()',
			'customer_notified'=>'0',
			'comments'=>'Neue Rechnung zum Lieferanten angelegt, generiert aus Lieferantenbestellung '.$this->info['id'],
			'editor_id'=>$usr
		);
		xtc_db_perform('distributor_invoices_status_history',$insert_sql_array);
	
		$msg = 'Lieferantenrechnung Nr. '.$orders_id.' wurde generiert.';
		$this->insert_history($status = '1',$customer_notified='0',$msg,$usr);
	}

	/**
	 * LOESCHT EINE LIEFERANTENBESTELLUNG INCL ENTH RECHNUNGEN
	 * SCHREIBT ZU JEDEM ARTIKEL EINEN HISTORIENEINTRAG
	 *
	 * @param string $msg
	 * @param int $usr
	 */
	public function delete(&$msg,$usr){
		$deleted_invoices = 0;
		$diID_query = xtc_db_query("SELECT distributor_invoices_id FROM distributor_invoices WHERE distributor_orders_id='".$this->info['id']."'");
		while($diID_res = xtc_db_fetch_array($diID_query)){
			$diID = $diID_res['distributor_invoices_id'];
			xtc_db_query("DELETE FROM distributor_invoices_entries WHERE distributor_invoices_id='".$diID."'");
			xtc_db_query("DELETE FROM distributor_invoices_installments WHERE distributor_invoices_id='".$diID."'");
			xtc_db_query("DELETE FROM distributor_invoices_status_history WHERE distributor_invoices_id='".$diID."'");
			xtc_db_query("DELETE FROM distributor_invoices_total WHERE distributor_invoices_id='".$diID."'");
			
			$dip_query = xtc_db_query(sprintf(
				"SELECT distributor_invoices_products_id FROM distributor_invoices_products WHERE distributor_invoices_id='%s'",
				$diID
			));
			while($dip = xtc_db_fetch_array($dip_query)){
				xtc_db_query(sprintf(
					"DELETE FROM distributor_invoices_products_properties WHERE distributor_invoices_products_id='%s'",
					$dip['distributor_invoices_products_id']
				));
			}
			xtc_db_query(sprintf(
				"DELETE FROM distributor_invoices_products WHERE distributor_invoices_id='%s'",
				$diID
			));
			
			$deleted_invoices++;
		}
		xtc_db_query("DELETE FROM distributor_invoices WHERE distributor_orders_id='".$this->info['id']."'");
		xtc_db_query("DELETE FROM distributor_orders WHERE distributor_orders_id='".$this->info['id']."'");

		$msg = 'Die Lieferantenbestellung Nr. '.$this->info['id'].' wurde incl. '.$deleted_invoices.' Lieferantenrechnungen geloescht.';

		$products_query = yes_db_query(sprintf(
			"SELECT distributor_orders_products_id,products_id FROM distributor_orders_products WHERE distributor_orders_id='%s'",
			$this->info['id']
		));
		if(yes_db_num_rows($products_query)){
			foreach($products_query as $record){
				xtc_db_query(sprintf(
					"DELETE FROM distributor_orders_products_properties WHERE distributor_orders_products_id='%s'",
					$record['distributor_orders_products_id']
				));
				$insert_sql_array = array(
					'products_id'=>$record['products_id'],
					'comments'=>$msg,
					'editor_id'=>$_SESSION['customer_id'],
					'date_saved'=>'now()'
				);
				xtc_db_perform('products_history',$insert_sql_array);
			}
			xtc_db_query("DELETE FROM distributor_orders_products WHERE distributor_orders_id='".$this->info['id']."'");
		}

		xtc_db_query("DELETE FROM distributor_orders_status_history WHERE distributor_orders_id='".$this->info['id']."'");
		xtc_db_query("DELETE FROM distributor_orders_total	WHERE distributor_orders_id='".$this->info['id']."'");
	}
	
	public static function insert_history_static(int $distributor_orders_id, int $status,bool $customer_notified,string $comments, int $usr=Null){
            if($usr === Null){
                $usr = intval($_SESSION['customer_id']??0);
            }
            $insert_sql_array = array(
                'distributor_orders_id'=>$distributor_orders_id,
                'orders_status_id'=>$status,
                'date_added'=>date('Y-m-d H:i:s'),
                'customer_notified'=>($customer_notified)?1:0,
                'comments'=>$comments,
                'editor_id'=>$usr
            );
            xtc_db_perform('distributor_orders_status_history',$insert_sql_array);
	}
	
	function insert_history($status,$customer_notified,$comments,$usr=Null){
            if($usr === Null){
                $usr = intval($_SESSION['customer_id']??0);
            }
            $insert_sql_array = array('distributor_orders_id'=>$this->info['id'],
                'orders_status_id'=>$status,
                'date_added'=>'now()',
                'customer_notified'=>$customer_notified,
                'comments'=>$comments,
                'editor_id'=>$usr
            );
            xtc_db_perform('distributor_orders_status_history',$insert_sql_array);
	}
	
	function update_comments($comments){
		$update_sql_array = array('comments'=>$comments,
			'last_modified'=>'now()'
		);
		xtc_db_perform('distributor_orders',$update_sql_array,'update',"distributor_orders_id='".$this->info['id']."'");
	}
	
	// checkt wieviel wareneingangsprodukte schon in lieferantenrechnungen zu dieser bestellung gebucht wurden
	function get_rueckbuch_invoice_qty($products_id){
		$products_count_query = xtc_db_query("SELECT SUM(dip.products_quantity) as anzahl FROM distributor_invoices di LEFT JOIN distributor_invoices_products dip USING(distributor_invoices_id) WHERE di.distributor_orders_id='".$this->info['id']."' and dip.products_id='".$products_id."' and dip.stuecklisten_id=0");
		$products_count = xtc_db_fetch_array($products_count_query);
		return (int)$products_count['anzahl'];
	}

	public function sort_array($array,$key,$sort_ascending=true){
		if(!is_array($array) or empty($key))
			return false;
		return $this->msort($array,$key,$sort_ascending);
	}

	private static function msort($array, $id="id", $sort_ascending=true) {
        $temp_array = array();
        while(count($array)>0) {
            $lowest_id = 0;
            $index=0;
            foreach ($array as $item) {
                if (isset($item[$id])) {
					if ($array[$lowest_id][$id]) {
						if ($item[$id]<$array[$lowest_id][$id]) {
							$lowest_id = $index;
						}
                    }
				}
                $index++;
            }
            $temp_array[] = $array[$lowest_id];
            $array = array_merge(array_slice($array, 0,$lowest_id), array_slice($array, $lowest_id+1));
        }
		if ($sort_ascending) {
			return $temp_array;
		} else {
			return array_reverse($temp_array);
		}
    }

	public function get_products_grouped(){
		if(!sizeOf($this->products)){
			return array();
		}
		/**
		 * WIR REDUZIEREN DAS ARRAY - COLLIS FLIEGEN RAUS
		 */
		$main_products = array();
		foreach($this->products as $product){
			if($product['stuecklisten_id'] == 0){
				$main_products[] = $product;
			}
		}
		// NUN WEISEN WIR DIE COLLIS DEN HAUPTARTIKELN ZU
		foreach($this->products as $product){
			if($product['stuecklisten_id'] > 0){
				$this->allocate_colli_product($main_products, $product);
			}
		}
		return $main_products;
	}
	
	private static function allocate_colli_product(&$main_products,$values){
		foreach($main_products as $k=>$m){
			if($m['id'] == $values['stuecklisten_id'] and $m['stuecklistenartikel'] == 1)
				$main_products[$k]['collies'][] = $values;
		}
	}
	
	public function get_properties($dopID){
		$properties_array = array();
		$properties_query = xtc_db_query(sprintf(
			"SELECT property_title,property_value FROM distributor_orders_products_properties WHERE distributor_orders_products_id='%s'",
			$dopID
		));
		if(xtc_db_num_rows($properties_query)){
			while($properties = xtc_db_fetch_array($properties_query)){
				 $properties_array[] = $properties;
			}
		}
		return $properties_array;
	}
	
	function recalc(){
	    // ALLE PRODUKTE ZUSAMMENRECHNEN FUER ZWISCHENSUMME
	    $products_query = xtc_db_query(sprintf(
		    "select SUM(final_price) as subtotal_final from distributor_orders_products where distributor_orders_id = '%s' ",
		    $this->info['id']
	    ));
	    $products = xtc_db_fetch_array($products_query);
	    $subtotal_final = (float)$products['subtotal_final'];
	    $subtotal_text = number_format($subtotal_final,2,',','.').' '.$this->info['currency'];
	    $update_sql_array = array(
		'text'=>$subtotal_text, 
		'value'=>$subtotal_final
	    );
	    xtc_db_perform('distributor_orders_total',$update_sql_array, 'update',"orders_id = '" . $this->info['id'] . "' and class = 'ot_subtotal' ");
	    $allow_tax = $this->info['allow_tax'];
            $country_id = STORE_COUNTRY;

            // UM DEN HOECHSTEN MWST SATZ ZU ERMITTELN DIESES ARRAY FUELLEN
            $different_taxes = [];
            
	    // ENTHALTENE MWST ERMITTELN
	    $products_query = xtc_db_query("select final_price, products_tax,products_id from distributor_orders_products where distributor_orders_id = '" . $this->info['id'] . "' ");
	    while($products = xtc_db_fetch_array($products_query)){
		    if ($allow_tax == '1'){
			    $tax_rate = $products['products_tax'];
			    $nprice = xtc_oe_get_price_o_tax($products['final_price'], $products['products_tax'], 0);
			    $bprice = $products['final_price'];
			    $tax = ($bprice - $nprice);
		    }else{
			    $tax_rate = '0';
			    $nprice = $products['final_price'];
			    $bprice = xtc_oe_get_price_i_tax($products['final_price'], $products['products_tax'], 0);
			    $tax = '0';
		    }
                    $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($products['products_id'], $country_id);
                    
                    // UM DEN HOECHSTEN MWST SATZ ZU ERMITTELN DIESES ARRAY FUELLEN
                    if(!isset($different_taxes[ $products_tax_class_id ])){
                        $different_taxes[ $products_tax_class_id ] = 0;
                    }
                    $different_taxes[ $products_tax_class_id ] += $tax;
                    
		    $sql_data_array = array('distributor_orders_id' => $this->info['id'],
			'n_price' => $nprice,
			'b_price' => $bprice,
			'tax' => $tax,
			'tax_rate' => $tax_rate,
			'class'=>'products',
                        'tax_class_id'=>$products_tax_class_id
		    );
		    xtc_db_perform('distributor_orders_recalculate', $sql_data_array);
	    }
            $max = 0;
            $tax_class_id = current(array_keys($different_taxes));
            foreach($different_taxes as $mc=>$v){
                if($v > $max){
                    $max = $v;
                    $tax_class_id = $mc;
                }
            }

	    // Shipping

	    $tax_check = ORDERS_EDIT_TAX_STATUS;
	    $tax_value = ($allow_tax == 1) ? xtc_get_tax_rate($tax_class_id,$country_id) : 0;

	    $shipping_query = xtc_db_query("select value from distributor_orders_total where orders_id = '" . $this->info['id'] . "' and class='ot_shipping' ");
	    $shipping = xtc_db_fetch_array($shipping_query);
	    if ($allow_tax == '1'){
		    if ($tax_check =='true'){
			    $tax_rate = $tax_value;
			    $nprice = xtc_oe_get_price_o_tax($shipping['value'], $tax_value, 0);
			    $bprice = $shipping['value'];
			    $tax = ($bprice - $nprice);
		    }else{
			    $tax_rate = '0';
			    $nprice = $shipping['value'];
			    $bprice = $shipping['value'];
			    $tax = '0';
		    }
	    }else{
		    $tax_rate = '0';
		    $nprice = $shipping['value'];
		    $bprice = $shipping['value'];
		    $tax = '0';
	    }
	    $sql_data_array = array('distributor_orders_id' => $this->info['id'],
		'n_price' => $nprice,
		'b_price' => $bprice,
		'tax' => $tax,
		'tax_rate' => $tax_rate,
		'class'=>'shipping',
                'tax_class_id'=>$this->get_shipping_tax_class()
	    );
	    xtc_db_perform('distributor_orders_recalculate', $sql_data_array);

	    // end shipping

	    // Alte UST L�schen
	    xtc_db_query("delete from distributor_orders_total where orders_id = '" . $this->info['id'] . "' and class='ot_tax'");
	    // Alte UST L�schen ENDE

	    // Neue UST Zusammenrechnen und in die DB Schreiben

            $ust_values = [];
	    $ust_query = xtc_db_query("select tax_rate, tax, tax_class_id from distributor_orders_recalculate where distributor_orders_id = '" . $this->info['id'] . "' and tax !='0'");
	    while($ust = xtc_db_fetch_array($ust_query)){
                $key = $ust['tax_class_id'].':'.number_format($ust['tax_rate'],2,'.','');
                if ($ust['tax']<>0){
                    if(!isset($ust_values[$key])){
                        $ust_values[ $key ] = 0;
                    }
                    $ust_values[ $key ] += $ust['tax'];
                }
            }
            foreach($ust_values as $tax=>$tax_value){
                $tax_parts = explode(':',$tax);
                $tax_class_id = $tax_parts[0];
                $title = xtc_get_tax_description($tax_class_id, $country_id);
                $text=number_format($tax_value,2,',','.').' '.$this->info['currency'];
		$sql_data_array = array('orders_id' => $this->info['id'],
                    'title' => $title,
                    'text' => $text,
                    'value' => $tax_value,
                    'class' => 'ot_tax',
                    'sort_order' => MODULE_ORDER_TOTAL_TAX_SORT_ORDER
                );
                xtc_db_perform('distributor_orders_total', $sql_data_array);
	    }
	    xtc_db_query("delete from distributor_orders_recalculate where distributor_orders_id = '" . $this->info['id'] . "'");

	    // Neue UST Zusammenrechnen und in die DB Schreiben ENDE

	    if ($allow_tax =='1'){
	      $total_query = xtc_db_query("select SUM(value) as value_new from distributor_orders_total where orders_id = '" . $this->info['id'] . "' and class!='ot_coupon' and class!='ot_gv' and class!='ot_tax' and class!='ot_total'");
	    }else{
	      $total_query = xtc_db_query("select SUM(value) as value_new from distributor_orders_total where orders_id = '" . $this->info['id'] . "' and class!='ot_coupon' and class!='ot_gv' and class!='ot_subtotal_no_tax' and class!='ot_total'");
	    }
	    $total = xtc_db_fetch_array($total_query);

	    $text=number_format($total['value_new'],2,',','.').' '.$this->info['currency'];

	    $sql_data_array = array(
		'value' => $total['value_new'],
		'text' => $text
	    );

	    xtc_db_perform('distributor_orders_total', $sql_data_array, 'update', 'orders_id = \'' . $this->info['id'] . '\' and class="ot_total"');
	    if(xtc_not_null($_GET['popurl'])){
		    xtc_redirect(xtc_href_link('distributor_orders.php', 'action=edit&doID=' . $this->info['id'].'&popurl='.$_GET['popurl']));
	    }
	}
        
	public function get_update_address_part_prefix($address_type){
		switch($address_type){
			case 'distributor':
				$prefix = 'distributor_';
				break;
			case 'shipping':
				$prefix = 'delivery_';
				break;
		}
		return $prefix;
	}
	
	public function get_address_part_sql($address_type,$data,$transform_to='',$utf8_decode=true){
		$prefix = $this->get_update_address_part_prefix($address_type);
		$update_sql_array = array();
		$target_key = ($transform_to != '') ? $this->get_update_address_part_prefix($transform_to) : '';
		foreach($data as $key=>$val){
			if(!strstr($key,$prefix) or $key == 'update_customers_name'){
				continue;
			}
			if(strstr($key,'country')){
				if($target_key != ''){
					if($utf8_decode)
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string( xtc_get_country_name( $val ) );
					else
						$update_sql_array[ str_replace($prefix,$target_key,$key) ] = xtc_get_country_name( $val );
				}else{
					if($utf8_decode)
						$update_sql_array[ $key ] = yes_decode_string(xtc_get_country_name($val));
					else
						$update_sql_array[ $key ] = xtc_get_country_name($val);
				}
			}else{
				if($target_key != ''){
					$update_sql_array[ str_replace($prefix,$target_key,$key) ] = yes_decode_string($val);
				}else{
					$update_sql_array[ $key ] = yes_decode_string($val);
				}
			}
		}
		return $update_sql_array;
	}
	public function update_address_part($update_sql_array){
		foreach($update_sql_array as $key => $val){
			if(mb_detect_encoding($val) == 'UTF-8'){
				//$update_sql_array[ $key ] = utf8_encode($val);
			}
		}
		xtc_db_perform('distributor_orders',$update_sql_array,'update',"distributor_orders_id='".$this->info['id']."'");
	}
        
    public function get_shipping_tax_class(){
        $tax_class_id = 0;
        if(is_array($this->products)){
            $taxes = array();
            $country_id = STORE_COUNTRY;
            foreach($this->products as $k=>$product){
                $products_tax_class_id = yes_eu_oss_get_products_tax_class_id($product['id'], $country_id);
                $key = $products_tax_class_id.':'.number_format($product['tax'],2,'.','');
                if(!isset($taxes[ $key ])){
                    $taxes[ $key ] = 0;
                }
                $taxes[ $key ] += $product['final_price'];
            }
			// BUGFIX 07/25 PRUEFEN OB $taxes EINEN EINTRAG HAT
			if(is_countable($taxes) and sizeOf($taxes)){
            	$max = max($taxes);
			}else{
				$max = 0;
			}
            foreach($taxes as $tax=>$val){
                if($val == $max){
                    $tax_parts = explode(':',$tax);
                    $tax_class_id = $tax_parts[ 0 ];
                }
            }
        }
        return $tax_class_id;
    }
        
    public function get_tax_class_from_rate($tax_rate):int{
        require_once(DIR_FS_INC.'xtc_get_country_data_from_name.inc.php');
        $country_data = xtc_get_country_data_from_name($this->delivery['country']);
        $countries_id = intval($country_data['countries_id']);
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        /*if(!yes_eu_oss_use_country_handling($countries_id)){
            $countries_id = STORE_COUNTRY;
        }*/
        // BOF - BUGF_CH_OSS - BLOCK UEBERFLUESSIG WENN AKTIV
        $z2gz = \YES4Trade\Model\zones_to_geo_zones::get_by_zone_country_id($countries_id);
        // gibt scheinbar nur eine verknuepfung zones_to_geo_zones/zone_country_id
        $geo_zone = current($z2gz);
        $tax_class_query = xtc_db_query(sprintf(
            "SELECT tax_class_id FROM tax_rates WHERE tax_rate=%s AND tax_zone_id='%s' LIMIT 1",
            $tax_rate,$geo_zone->geo_zone_id
        ));
        $tax_class = xtc_db_fetch_array($tax_class_query);
        return intval($tax_class['tax_class_id']);
    }

  
}
