<?php
/**
 * Description of customer
 *
 * @author mario aspeleiter
 */
class customer {
    var $customers_id,$customers_cid,$customers_vat_id,$customers_vat_id_status,
	    $customers_warning,$customers_status,$customers_gender,
	    $customers_firstname,$customers_lastname,$customers_dob,
	    $customers_email_address,$customers_default_address_id,
	    $customers_telephone,$customers_fax,$customers_password,
	    $customers_newsletter,$customers_newsletter_mode,$member_flag,
	    $delete_user,$account_type,$password_request_key,
	    $customers_ebay_userid,$kto_nummer,$kto_blz,$kto_bank,$kto_inhaber,
	    $kto_iban,$kto_swift,$block_warnings,$block_warnings_span,
	    $block_warnings_dayspan,$block_warnings_date,$mobile,
	    $subject_from_textitem,$branches_id,$customers_date_added,
	    $customers_last_modified,$refferers_id,$orders_default_search_type,
	    $use_own_mailaddress,$easylog_tn_national,$easylog_tn_international,
	    $account_value,$account_value_alert_notified;

    function __construct( $customers_id = NULL,$details = false){
	if($customers_id !== NULL and (int)$customers_id > 0){
	    $this->get_sql_data( $customers_id,$details );
	}
    }
    public function getCustomers_id() {
	return $this->customers_id;
    }

    public function setCustomers_id($customers_id) {
	$this->customers_id = $customers_id;
    }

    public function getCustomers_cid() {
	return $this->customers_cid;
    }

    public function setCustomers_cid($customers_cid) {
	$this->customers_cid = $customers_cid;
    }

    public function getCustomers_vat_id() {
	return $this->customers_vat_id;
    }

    public function setCustomers_vat_id($customers_vat_id) {
	$this->customers_vat_id = $customers_vat_id;
    }

    public function getCustomers_vat_id_status() {
	return $this->customers_vat_id_status;
    }

    public function setCustomers_vat_id_status($customers_vat_id_status) {
	$this->customers_vat_id_status = $customers_vat_id_status;
    }

    public function getCustomers_warning() {
	return $this->customers_warning;
    }

    public function setCustomers_warning($customers_warning) {
	$this->customers_warning = $customers_warning;
    }

    public function getCustomers_status() {
	return $this->customers_status;
    }

    public function setCustomers_status($customers_status) {
	$this->customers_status = $customers_status;
    }

    public function getCustomers_gender() {
	return $this->customers_gender;
    }

    public function setCustomers_gender($customers_gender) {
	$this->customers_gender = $customers_gender;
    }

    public function getCustomers_firstname() {
	return $this->customers_firstname;
    }

    public function setCustomers_firstname($customers_firstname) {
	$this->customers_firstname = $customers_firstname;
    }

    public function getCustomers_lastname() {
	return $this->customers_lastname;
    }

    public function setCustomers_lastname($customers_lastname) {
	$this->customers_lastname = $customers_lastname;
    }

    public function getCustomers_dob() {
	return $this->customers_dob;
    }

    public function setCustomers_dob($customers_dob) {
	$this->customers_dob = $customers_dob;
    }

    public function getCustomers_email_address() {
	return $this->customers_email_address;
    }

    public function setCustomers_email_address($customers_email_address) {
	$this->customers_email_address = $customers_email_address;
    }

    public function getCustomers_default_address_id() {
	return $this->customers_default_address_id;
    }

    public function setCustomers_default_address_id($customers_default_address_id) {
	$this->customers_default_address_id = $customers_default_address_id;
    }

    public function getCustomers_telephone() {
	return $this->customers_telephone;
    }

    public function setCustomers_telephone($customers_telephone) {
	$this->customers_telephone = $customers_telephone;
    }

    public function getCustomers_fax() {
	return $this->customers_fax;
    }

    public function setCustomers_fax($customers_fax) {
	$this->customers_fax = $customers_fax;
    }

    public function getCustomers_password() {
	return $this->customers_password;
    }

    public function setCustomers_password($customers_password) {
	$this->customers_password = $customers_password;
    }

    public function getCustomers_newsletter() {
	return $this->customers_newsletter;
    }

    public function setCustomers_newsletter($customers_newsletter) {
	$this->customers_newsletter = $customers_newsletter;
    }

    public function getCustomers_newsletter_mode() {
	return $this->customers_newsletter_mode;
    }

    public function setCustomers_newsletter_mode($customers_newsletter_mode) {
	$this->customers_newsletter_mode = $customers_newsletter_mode;
    }

    public function getMember_flag() {
	return $this->member_flag;
    }

    public function setMember_flag($member_flag) {
	$this->member_flag = $member_flag;
    }

    public function getDelete_user() {
	return $this->delete_user;
    }

    public function setDelete_user($delete_user) {
	$this->delete_user = $delete_user;
    }

    public function getAccount_type() {
	return $this->account_type;
    }

    public function setAccount_type($account_type) {
	$this->account_type = $account_type;
    }

    public function getPassword_request_key() {
	return $this->password_request_key;
    }

    public function setPassword_request_key($password_request_key) {
	$this->password_request_key = $password_request_key;
    }

    public function getCustomers_ebay_userid() {
	return $this->customers_ebay_userid;
    }

    public function setCustomers_ebay_userid($customers_ebay_userid) {
	$this->customers_ebay_userid = $customers_ebay_userid;
    }

    public function getKto_nummer() {
	return $this->kto_nummer;
    }

    public function setKto_nummer($kto_nummer) {
	$this->kto_nummer = $kto_nummer;
    }

    public function getKto_blz() {
	return $this->kto_blz;
    }

    public function setKto_blz($kto_blz) {
	$this->kto_blz = $kto_blz;
    }

    public function getKto_bank() {
	return $this->kto_bank;
    }

    public function setKto_bank($kto_bank) {
	$this->kto_bank = $kto_bank;
    }

    public function getKto_inhaber() {
	return $this->kto_inhaber;
    }

    public function setKto_inhaber($kto_inhaber) {
	$this->kto_inhaber = $kto_inhaber;
    }

    public function getKto_iban() {
	return $this->kto_iban;
    }

    public function setKto_iban($kto_iban) {
	$this->kto_iban = $kto_iban;
    }

    public function getKto_swift() {
	return $this->kto_swift;
    }

    public function setKto_swift($kto_swift) {
	$this->kto_swift = $kto_swift;
    }

    public function getBlock_warnings() {
	return $this->block_warnings;
    }

    public function setBlock_warnings($block_warnings) {
	$this->block_warnings = $block_warnings;
    }

    public function getBlock_warnings_span() {
	return $this->block_warnings_span;
    }

    public function setBlock_warnings_span($block_warnings_span) {
	$this->block_warnings_span = $block_warnings_span;
    }

    public function getBlock_warnings_dayspan() {
	return $this->block_warnings_dayspan;
    }

    public function setBlock_warnings_dayspan($block_warnings_dayspan) {
	$this->block_warnings_dayspan = $block_warnings_dayspan;
    }

    public function getBlock_warnings_date() {
	return $this->block_warnings_date;
    }

    public function setBlock_warnings_date($block_warnings_date) {
	$this->block_warnings_date = $block_warnings_date;
    }

    public function getMobile() {
	return $this->mobile;
    }

    public function setMobile($mobile) {
	$this->mobile = $mobile;
    }

    public function getSubject_from_textitem() {
	return $this->subject_from_textitem;
    }

    public function setSubject_from_textitem($subject_from_textitem) {
	$this->subject_from_textitem = $subject_from_textitem;
    }

    public function getBranches_id() {
	return $this->branches_id;
    }

    public function setBranches_id($branches_id) {
	$this->branches_id = $branches_id;
    }

    public function getCustomers_date_added() {
	return $this->customers_date_added;
    }

    public function setCustomers_date_added($customers_date_added) {
	$this->customers_date_added = $customers_date_added;
    }

    public function getCustomers_last_modified() {
	return $this->customers_last_modified;
    }

    public function setCustomers_last_modified($customers_last_modified) {
	$this->customers_last_modified = $customers_last_modified;
    }

    public function getRefferers_id() {
	return $this->refferers_id;
    }

    public function setRefferers_id($refferers_id) {
	$this->refferers_id = $refferers_id;
    }

    public function getOrders_default_search_type() {
	return $this->orders_default_search_type;
    }

    public function setOrders_default_search_type($orders_default_search_type) {
	$this->orders_default_search_type = $orders_default_search_type;
    }

    public function getUse_own_mailaddress() {
	return $this->use_own_mailaddress;
    }

    public function setUse_own_mailaddress($use_own_mailaddress) {
	$this->use_own_mailaddress = $use_own_mailaddress;
    }

    public function getEasylog_tn_national() {
	return $this->easylog_tn_national;
    }

    public function setEasylog_tn_national($easylog_tn_national) {
	$this->easylog_tn_national = $easylog_tn_national;
    }

    public function getEasylog_tn_international() {
	return $this->easylog_tn_international;
    }

    public function setEasylog_tn_international($easylog_tn_international) {
	$this->easylog_tn_international = $easylog_tn_international;
    }
    
    public function getAccount_value() {
	return $this->account_value;
    }

    public function setAccount_value($account_value) {
	$this->account_value = $account_value;
    }
    
    public function getAccount_value_alert_notified() {
	return $this->account_value_alert_notified;
    }

    public function setAccount_value_alert_notified($account_value_alert_notified) {
	$this->account_value_alert_notified = $account_value_alert_notified;
    }

    
    
    
    private function get_sql_data($id,$details = false){
	$details_string = ($details) ? '*' : 'customers_id';
	$query = xtc_db_query(sprintf(
		"SELECT %s FROM %s WHERE customers_id='%s'",
		$details_string,TABLE_CUSTOMERS,$id
	));
	$record = xtc_db_fetch_array($query);
	foreach($record as $key=>$value){
	    $function = 'set'.ucfirst($key);
	    if(method_exists($this,$function)){
		$this->$function( $value );
	    }
	}
    }
    
    public function count_orders(){
        $query = xtc_db_query(sprintf(
                "SELECT COUNT(orders_id) as anz FROM %s WHERE customers_id='%s' AND orders_status != %s",
                TABLE_ORDERS,$this->getCustomers_id(),ORDERS_STATUS_STORNIERT
        ));
        $record = xtc_db_fetch_array($query);
        return $record['anz'];
    }
    
    public function get_account_value( $startDate = NULL, $endDate = NULL){
	$query_raw = sprintf(
		"SELECT SUM(value) as summe FROM %s o LEFT JOIN %s ot USING(orders_id) WHERE o.orders_status IN (%s) AND ot.class='ot_total' AND o.customers_id='%s'",
		TABLE_ORDERS,TABLE_ORDERS_TOTAL,
		implode(',',array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_BEZAHLT)),
		$this->getCustomers_id()
	);
	if($startDate != NULL and $this->is_valid_date($startDate)){
	    $query_raw .= sprintf(" AND o.date_purchased > '%s'",$startDate);
	}
	if($endDate != NULL and $this->is_valid_date($endDate)){
	    $query_raw .= sprintf(" AND o.date_purchased < '%s'",$endDate);
	}
	$query = xtc_db_query($query_raw);
	$record = xtc_db_fetch_array($query);
	return $record['summe'];
    }
    private function is_valid_date($string){
	$date = date_parse($string);
	if ($date["error_count"] == 0 && checkdate($date["month"], $date["day"], $date["year"]))
	    return true;
	return false;
    }
    
    function update_current_account_value(){
	$update_sql_array = array(
	    'account_value'=>$this->get_account_value()
	);
	xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$this->getCustomers_id()."'");
	$query = xtc_db_query(sprintf(
	    "SELECT c.account_value_alert_notified,cs.account_value_alert_limit FROM %s cs LEFT JOIN %s c ON c.customers_status=cs.customers_status_id WHERE c.customers_id='%s' AND account_value_alert_status=1 LIMIT 1",
	    TABLE_CUSTOMERS_STATUS,TABLE_CUSTOMERS, $this->getCustomers_id()
	));
	if(xtc_db_num_rows($query)){
	   $record = xtc_db_fetch_array($query);
	   if($record['account_value_alert_notified'] == 0 and $record['account_value_alert_limit'] < $update_sql_array['account_value']){
		require_once(DIR_FS_INC.'yes_write_notice.inc.php');
		$rec_array = main::get_notice_recipients('customers_status');
		if(sizeOf($rec_array)){
		    $name_query = xtc_db_query(sprintf(
			    "SELECT CONCAT(customers_firstname, ' ',customers_lastname) as name FROM %s WHERE customers_id='%s'",
			    TABLE_CUSTOMERS,$this->getCustomers_id()
		    ));
		    $name = xtc_db_fetch_array($name_query);
		    yes_write_notice(sprintf('Gesamtumsatz Limit %s erreicht: %s (ID: %s)', 
			    number_format($record['account_value_alert_limit'],2,',','.'),
			    $name['name'],$this->getCustomers_id()
			),sprintf('Aktuelle Kundengruppe: %s<br />Kundengruppen Limit: %s<br />Aktueller Gesamtumsatz: %s',  
			    xtc_get_customers_status_name($this->getCustomers_status()),
			    number_format($record['account_value_alert_limit'],2,',','.'),
			    number_format($update_sql_array['account_value'],2,',','.')
			 ),0,$rec_array
		     );
		    $update_sql_array = array(
			'account_value_alert_notified'=>1
		    );
		    xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$this->getCustomers_id()."'");
		}
	   }
	}
   }
   
   public function get_customers_status_image(){
       $lang_id = (isset($_SESSION['languages_id']))?$_SESSION['languages_id']:2;
       $record = main::get_customers_status($this->getCustomers_status(),$lang_id);
       return $record['customers_status_image'];
   }
   
   public function add_order( $orders_status, $source = 'admin' ){
        // get default language file
       foreach(\YES4Trade\Model\languages::get_list() as $l){
           if($l['code'] == DEFAULT_LANGUAGE){
               $lang_data = $l;
           }
       }
       
        // include order total lang file
        require_once('../lang/' . $lang_data['directory'] . '/modules/order_total/ot_total.php');
        require_once('../lang/' . $lang_data['directory'] . '/modules/order_total/ot_subtotal.php');
        if($this->getCustomers_default_address_id() > 0){
            $item = \YES4Trade\Model\address_book::get_by_address_book_id((int)$this->getCustomers_default_address_id());
        }else{
            $items = \YES4Trade\Model\address_book::get_by_customers_id((int)$this->getCustomers_id());
            $item = current($items);
        }
        if($item !== null){
            $customers = $item->toArray();
        }else{
            $customers = [];
        }

        // ADDRESS CLASS ADDON
        $delivery_defaults = \YES4Trade\Model\address_book::get_by_customers_id((int)$this->getCustomers_id(), ["address_class='delivery'"]);
        if(sizeOf($delivery_defaults)){
            $delivery_default = current($delivery_defaults);
            $delivery_address_data = $delivery_default->toArray();
        }else{
            $delivery_address_data = $customers;
        }
        $country_query = xtc_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '".$delivery_address_data['entry_country_id']."'");
        $country = xtc_db_fetch_array($country_query);
        $delivery_address_data['countries_name'] = $country['countries_name'];

        $billing_defaults = \YES4Trade\Model\address_book::get_by_customers_id((int)$this->getCustomers_id(), ["address_class='billing'"]);
        if(sizeOf($billing_defaults)){
            $billing_default = current($billing_defaults);
            $billing_address_data = $billing_default->toArray();
        }else{
            $billing_address_data = $customers;
        }
        $country_query = xtc_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '".$billing_address_data['entry_country_id']."'");
        $country = xtc_db_fetch_array($country_query);
        $billing_address_data['countries_name'] = $country['countries_name'];

        $customer_defaults = \YES4Trade\Model\address_book::get_by_customers_id((int)$this->getCustomers_id(), ["address_class='customer'"]);
        if(sizeOf($customer_defaults)){
            $customer_default = current($customer_defaults);
            $customers_address_data = $customer_default->toArray();
        }else{
            $customers_address_data = $customers;
        }
        $country_query = xtc_db_query("select countries_name from " . TABLE_COUNTRIES . " where countries_id = '".$customers_address_data['entry_country_id']."'");
        $country = xtc_db_fetch_array($country_query);
        $customers_address_data['countries_name'] = $country['countries_name'];

        $lang_id = (isset($_SESSION['languages_id'])) ? $_SESSION['languages_id'] : 2;
        $stat = main::get_customers_status($this->getCustomers_status(),$lang_id);

        $currency_value_query = xtc_db_query("SELECT value FROM currencies WHERE code='".DEFAULT_CURRENCY."'");
        $currency_value = xtc_db_fetch_array($currency_value_query);
        if($currency_value['value'] == 0) 
            $currency_value['value'] = '1';
        $payment_method = 'moneyorder';
        if(xtc_not_null($stat['customers_status_default_admin_paymentmethod'])){
            $payment_method = $stat['customers_status_default_admin_paymentmethod'];
        }
        $sql_data_array = array('customers_id' => $this->getCustomers_id(),
            'customers_cid' => $this->getCustomers_cid(),
            'customers_vat_id' => $this->getCustomers_vat_id(),
            'customers_status' => $this->getCustomers_status(),
            'customers_status_name' => xtc_db_prepare_input($stat['customers_status_name']),
            'customers_status_image' => xtc_db_prepare_input($stat['customers_status_image']),
            'customers_status_discount' => xtc_db_prepare_input($stat['customers_status_discount']),
            'customers_name' => xtc_db_prepare_input($customers_address_data['entry_firstname'] . ' '. $customers_address_data['entry_lastname']),
            'customers_company' => xtc_db_prepare_input($customers_address_data['entry_company']),
            'customers_street_address' => xtc_db_prepare_input($customers_address_data['entry_street_address']),
            'customers_suburb' => xtc_db_prepare_input($customers_address_data['entry_suburb']),
            'customers_city' => xtc_db_prepare_input($customers_address_data['entry_city']),
            'customers_postcode' => xtc_db_prepare_input($customers_address_data['entry_postcode']),
            'customers_state' => xtc_db_prepare_input($customers_address_data['entry_state']),
            'customers_country' => xtc_db_prepare_input($customers_address_data['countries_name']),
            'customers_telephone' => $this->getCustomers_telephone(),
            'customers_mobile' => $this->getMobile(),
            'customers_email_address' => $this->getCustomers_email_address(),
            'customers_address_format_id' => '5',
            'customers_ip' => '0',
            'delivery_name' => xtc_db_prepare_input($delivery_address_data['entry_firstname'] . ' '. $delivery_address_data['entry_lastname']),
            'delivery_company' => xtc_db_prepare_input($delivery_address_data['entry_company']),
            'delivery_street_address' => xtc_db_prepare_input($delivery_address_data['entry_street_address']),
            'delivery_suburb' => xtc_db_prepare_input($customers_address_data['entry_suburb']),
            'delivery_city' => xtc_db_prepare_input($delivery_address_data['entry_city']),
            'delivery_postcode' => xtc_db_prepare_input($delivery_address_data['entry_postcode']),
            'delivery_state' => xtc_db_prepare_input($delivery_address_data['entry_state']),
            'delivery_country' => xtc_db_prepare_input($delivery_address_data['countries_name']),
            'delivery_address_format_id' => '5',
            'billing_name' => xtc_db_prepare_input($billing_address_data['entry_firstname'] . ' '. $billing_address_data['entry_lastname']),
            'billing_company' => xtc_db_prepare_input($billing_address_data['entry_company']),
            'billing_street_address' => xtc_db_prepare_input($billing_address_data['entry_street_address']),
            'billing_suburb' => xtc_db_prepare_input($customers_address_data['entry_suburb']),
            'billing_city' => xtc_db_prepare_input($billing_address_data['entry_city']),
            'billing_postcode' => xtc_db_prepare_input($billing_address_data['entry_postcode']),
            'billing_state' => xtc_db_prepare_input($billing_address_data['entry_state']),
            'billing_country' => xtc_db_prepare_input($billing_address_data['countries_name']),
            'billing_address_format_id' => '5',
            'payment_method' => $payment_method,
            'cc_type' => '',
            'cc_owner' => '',
            'cc_number' => '',
            'cc_expires' => '',
            'cc_start' => '',
            'cc_issue' => '',
            'cc_cvv' => '',
            'comments' => '',
            'last_modified' => 'now()',
            'date_purchased' => 'now()',
            'orders_status' => $orders_status,
            'orders_date_finished' => '',
            'currency' => DEFAULT_CURRENCY,
            'currency_value' => $currency_value['value'],
            'account_type' => $this->getAccount_type(),
            'customers_ip' => '',
            'language' => 'german',
            'source'=>$source
        );
        if($source == 'admin'){
            $sql_data_array['payment_class'] = $payment_method;
            $sql_data_array['shipping_method'] = 'Pauschale Versandkosten';
            $sql_data_array['shipping_class'] = 'flat_flat';
            $sql_data_array['source_editor_id'] = $_SESSION['customer_id'];
        }

        if($sql_data_array['orders_status'] == ORDERS_STATUS_OFFER){
            $sql_data_array['no_warning'] = 1;
        }
        xtc_db_perform(TABLE_ORDERS, $sql_data_array);
        $orders_id = xtc_db_insert_id();

        $total_title = MODULE_ORDER_TOTAL_TOTAL_TITLE;
        if( $stat['customers_status_add_tax_ot']==0 ){
                $total_title = MODULE_ORDER_TOTAL_TOTAL_TITLE_NO_TAX;
        }

        $sql_data_array = array (
                'orders_id' => $orders_id,
                'title' => $total_title . ':',
                'text' => '0',
                'value' => '0',
                'class' => 'ot_total'
        );

        $insert_sql_data = array (
                'sort_order' => MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER
        );
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

        $subtotal_title = MODULE_ORDER_TOTAL_SUBTOTAL_TITLE;
        $subtotal_class = 'ot_subtotal';
        $subtotal_sort_order = MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER;
        if( $stat['customers_status_show_price_tax']==0 and $stat['customers_status_add_tax_ot'] == 1){
            $subtotal_title = MODULE_ORDER_TOTAL_SUBTOTAL_TITLE_NO_TAX;
            $subtotal_class = 'ot_subtotal_no_tax';
            $subtotal_sort_order = MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER;
        }

        $sql_data_array = array (
            'orders_id' => $orders_id,
            'title' => $subtotal_title . ':',
            'text' => '0',
            'value' => '0',
            'class' => $subtotal_class
        );

        $insert_sql_data = array (
            'sort_order' => $subtotal_sort_order
        );
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
        return $orders_id;
   }
   
   /**
    * Ermittelt eine customers_id anhand der email adresse
    * Gibt -1 zurueck wenn nichts gefunden wird
    * 
    * @param String $email
    * @return int customers_id
    * @throws Exception
    */
   public static function get_customers_id_by_email($email){
       $customers_id = -1;
       if(!xtc_validate_email($email)){
           throw new Exception('Invalid Email '.$email);
       }
       $query = xtc_db_query(sprintf(
               "SELECT customers_id FROM %s WHERE customers_email_address='%s'",
               TABLE_CUSTOMERS,$email
       ));
       if(!xtc_db_num_rows($query)){
           return $customers_id;
       }
       $record = xtc_db_fetch_array($query);
       return $record['customers_id'];
   }
   
   /**
    * ERZEUGT EINEN EINTRAG IN DER TABELLE customers UND GIBT DIE customers_id
    * ZURUECK
    * @param array $insert_sql_data
    * @return int customers_id
    */
   public static function add(array $insert_sql_data){
        require_once(DIR_FS_INC.'xtc_create_password.inc.php');
        require_once(DIR_FS_INC.'xtc_encrypt_password.inc.php');
        if(!isset($insert_sql_data['customers_password'])){
            $insert_sql_data['customers_password'] = xtc_encrypt_password( xtc_RandomString(8) );
        }
        if(!isset($insert_sql_data['customers_date_added'])){
            $insert_sql_data['customers_date_added'] = 'now()';
        }
        xtc_db_perform(TABLE_CUSTOMERS, $insert_sql_data);
        return xtc_db_insert_id();
   }
   
   public function add_address_book_entry(array $insert_sql_data){
        $insert_sql_data['customers_id'] = (int)$this->getCustomers_id();
        $insert_sql_data['address_date_added'] = date('Y-m-d H:i:s');
        if(isset($insert_sql_data['entry_zone_id'])){
            $insert_sql_data['entry_zone_id'] = (int)$insert_sql_data['entry_zone_id'];
        }
        if(isset($insert_sql_data['entry_country_id'])){
            $insert_sql_data['entry_country_id'] = (int)$insert_sql_data['entry_country_id'];
        }
        $new = new \YES4Trade\Model\address_book($insert_sql_data);
        return $new->create();
   }

   /**
    * Aktualisiert den default_address_book_id Wert eines customers Eintrags
    * @param int $abID
    */
   public function update_default_address_book_id($abID){
       $update_sql_array = array(
           'customers_default_address_id'=>$abID
       );
       xtc_db_perform(TABLE_CUSTOMERS,$update_sql_array,'update',"customers_id='".$this->getCustomers_id()."'");
   }
   
   public function add_memo($title, $text,$poster_id = 0){
       $new = new \YES4Trade\Model\customers_memo([
           'customers_id'=>(int)$this->getCustomers_id(),
           'memo_date'=>date('Y-m-d H:i:s'),
           'memo_title'=>$title,
           'memo_text'=>$text,
           'poster_id'=>(int)$poster_id
       ]);
       $new->create();
   }
   
   public static function exists( int $customers_id ){
       if($customers_id < 1){
           return false;
       }
       $query = xtc_db_query(sprintf(
            "SELECT customers_id FROM %s WHERE customers_id='%d'",
            TABLE_CUSTOMERS, $customers_id
       ));
       return (xtc_db_num_rows($query)>0)?true : false;
   }

   public function get_customers_info(){
    $query = yes_query(
        "SELECT * FROM customers_info WHERE customers_info_id=:id",[
            'id'=>$this->getCustomers_id()
        ],true
    );
    if($query == false){
        return [];
    }
    return $query;
   }

   public function get_last_login_date():\DateTime{
    $query = yes_query(
        "SELECT customers_ip_date FROM customers_ip WHERE customers_id=:id ORDER BY customers_ip_date DESC LIMIT 1",[
            'id'=>$this->getCustomers_id()
        ],true
    );
    if($query == false){
        return new \DateTime();
    }
    return new \DateTime($query['customers_ip_date']);
   }
}
